const SHIPMENT_STATUS_TRANSIT_HN = 5;
$('#btn_scan').click(async function (e) {
    let _code = $('#scan_code').val();

    if (_code == '') {
        return showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: 'Không có mã code để cập nhật'
        })
    }else {
        onConfirmScan();
    }
});

async function onConfirmScan(_data = null) {
    try {
        const call = async () => {
            let _url = window.location.origin + '/scan/update-status'
            if (!_data) {
                _data = {
                    status: SHIPMENT_STATUS_TRANSIT_HN,
                    code: $('#scan_code').val(),
                }
            }
            let _res = await ajaxContants2(_url, 'POST', _data)
            if (_res.status == 200) {
                showMessage({
                    icon: 'success',
                    title: 'Thông báo',
                    text: 'Cập nhật thành công'
                });
                $('#scan_code').val('');
            } else {
                showMessage(_res.message)
            }
        }
        let alert = {
            icon: 'question',
            title: ' thông báo',
            text: 'Cập nhật đơn hàng này với trạng thái Transit HN'
        }
        onConfirmAction(alert, call)
    } catch (error) {
        console.log(error);
    }        
    
}

