let pub_limit = 10;
let pub_page = 1;

$(document).ready(function () {
    $('input[name="daterange"]').daterangepicker({
        opens: 'left',
        startDate: moment().subtract(3, 'months').startOf('month'),
        endDate: moment().endOf('month'),
        locale: {
            format: 'DD/MM/YYYY',
            applyLabel: "Áp dụng",
            cancelLabel: "Hủy",
            customRangeLabel: "Tùy chỉnh",
            daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
            monthNames: [
                "Tháng 1",
                "Tháng 2",
                "Tháng 3",
                "Tháng 4",
                "Tháng 5",
                "Tháng 6",
                "Tháng 7",
                "Tháng 8",
                "Tháng 9",
                "Tháng 10",
                "Tháng 11",
                "Tháng 12",
            ],
        }
    }, function (start, end, label) {
        page = 1;
        fetchData();
    });

    fetchData()
});

$(document).on('click', '.pagination a', function (event) {
    event.preventDefault();
    pub_page = $(this).attr('href').split('page=')[1];
    fetchData();
});

$('#keywords').on('keypress', function (e) {
    if (e.which === 13) { // 13 là mã ASCII của phím Enter
        fetchData();
    }
})

function getFilters() {
    return {
        keywords: $('#keywords').val(),
        date_range: {
            start_date: $('input[name="daterange"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
            end_date: $('input[name="daterange"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
        }
    }
}


function fetchData() {

    let url = window.location.origin + '/list/bag-code'
    let data = {
        bag_code_kind: pub_bag_code_kind,
        paginate: {
            limit: pub_limit,
            page: pub_page,
        },
        filters: getFilters()
    }
    ajaxPostHTML(url, data, 'content')
}

const form_vali = ['dest_code', 'count_bag', 'total_package', 'total_weight', 'bag_code_type'];

const refreshVali = () => {
    form_vali.forEach(function (vali) {
        if ($(`#${vali}_err`)) {
            $(`#${vali}_err`).html('');
        }
    });
}
$('#btn_add_bag').click(function () {
    createBagCode();
});

$('#modalAddBagCode').on('show.bs.modal', function (e) {
    refreshVali();
    form_vali.forEach(function (vali) {
        if ($(`#${vali}`)) {
            $(`#${vali}`).html('');
        }
    })
});
async function createBagCode() {
    refreshVali();
    $('#btn_add_bag').attr('disabled', true)
    $('#btn_add_bag').html(iconLoadingHtml())
    try {

        let url = window.location.origin + '/list/bag-code/create';
        let data = {
            bag_code_kind: pub_bag_code_kind,
            dest_code: $('#dest_code').val(),
            branch_id: $('#branch_id').val(),
            count_bag: $('#count_bag').val(),
            total_package: $('#total_package') ? $('#total_package').val() : 0,
            total_weight: $('#total_weight') ? $('#total_weight').val() : 0,
            bag_code_type: $('#bag_code_type') ? $('#bag_code_type').val() : 0,
        }

        let res = await ajaxContants2(url, 'POST', data)
        if (res.status === 200) {
            $('#btn_close_bg').click();
            fetchData();
        } else if (res.status === 422) {
            var errors = res.error;
            $.each(errors, function (key, value) {
                $('#' + key + '_err').text(value[0]);
            });
        }
        if (res.message) {
            showMessage(res.message);
        }

        $('#btn_add_bag').attr('disabled', false)
        $('#btn_add_bag').html('Xác nhận')
    } catch (error) {
        $('#btn_add_bag').attr('disabled', false)
        $('#btn_add_bag').html('Xác nhận')
        refreshVali();
    }

}