var clipboard = new ClipboardJS(".copy-to-clipboard");
var setIntervalCheckPayment = null;

$(document).ready(function () {
    clipboard.on("success", function (e) {
        var tooltip = bootstrap.Tooltip.getInstance(e.trigger);
        e.trigger.setAttribute("data-bs-original-title", "Copied!");
        tooltip.show();
        e.trigger.setAttribute("data-bs-original-title", "Copy to clipboard");
        e.clearSelection();
    });

    clipboard.on("error", function (e) {
        var key = /mac/i.test(navigator.userAgent) ? "\u2318" : "Ctrl-";
        var message = "Press " + key + "C to copy";
        var tooltip = bootstrap.Tooltip.getInstance(e.trigger);
        e.trigger.setAttribute("data-bs-original-title", message);
        tooltip.show();
        e.trigger.setAttribute("data-bs-original-title", "Copy to clipboard");
    });

    // Nếu thời gian hết hạn chưa qua thì hiển thị đồng hồ đếm ngược
    if (countDownDate > new Date().getTime()) {
        // Cập nhật thời gian còn lại mỗi 1 giây
        var x = setInterval(function () {
            // Lấy thời gian hiện tại
            var now = new Date().getTime();

            // Tính thời gian còn lại
            var distance = countDownDate - now;

            // Tính số ngày, giờ, phút, giây
            var minutes = Math.floor(
                (distance % (1000 * 60 * 60)) / (1000 * 60)
            );
            var seconds = Math.floor((distance % (1000 * 60)) / 1000);

            // Hiển thị thời gian còn lại
            $("#minutes").text(minutes);
            $("#seconds").text(seconds);

            // Nếu thời gian hết hạn, hiển thị thông báo
            if (distance < 0) {
                clearInterval(x);
                $(".countdown").text("EXPIRED");
                window.location.reload();
            }
        }, 1000);
    }

    setIntervalCheckPayment = setInterval(async function () {
        const result = await checkPayment();
        if (result) {
            clearInterval(setIntervalCheckPayment);
            window.location.reload();
        }
    }, 1000);
});

async function checkPayment() {
    try {
        const response = await sendRequest(`${window.location.origin}/sepay/check-payment`, "POST", {recharge_id: recharge_id});

        return response.is_paid;
    } catch (error) {
        return false;
    }
}
