setBtnClickShowMore()
function setBtnClickShowMore() {
    var buttons = document.querySelectorAll('.btn.btn-floating.btn-icon.btn-rounded.btn-flush-success.btn-xs');
    // Lặp qua từng button và thêm sự kiện click cho mỗi button
    buttons.forEach(function (button) {
        button.addEventListener('click', function () {
            // Chọn thẻ <i> trong nút
            var iconElement = this.querySelector('i');

            // Kiểm tra lớp của thẻ <i> để xác định trạng thái hiện tại
            if (iconElement.classList.contains('fa-plus')) {
                // Nếu hiện tại là icon plus, thay đổi thành icon minus
                iconElement.classList.remove('fa-plus');
                iconElement.classList.add('fa-minus');

                // Thay đổi lớp màu của nút thành btn-flush-danger
                this.classList.remove('btn-flush-success');
                this.classList.add('btn-flush-danger');
            } else {
                // Nếu hiện tại là icon minus, thay đổi thành icon plus
                iconElement.classList.remove('fa-minus');
                iconElement.classList.add('fa-plus');

                // Thay đổi lớp màu của nút thành btn-flush-success
                this.classList.remove('btn-flush-danger');
                this.classList.add('btn-flush-success');
            }
        });
    });
}



var uploadedFileInfo = null;

new Dropzone("#myDropzone", {
    url: "/upload",
    autoProcessQueue: false,
    paramName: "file",
    clickable: true,
    maxFilesize: 10, // MB
    addRemoveLinks: true,
    acceptedFiles: '.png,.jpg',
    dictDefaultMessage: "Tải hình ảnh ở đây",

    init: function () {
        var dropzone = this;
        dropzone.on("complete", function (file) {
        });
        dropzone.on("addedfile", function (file) {
            uploadedFileInfo = file;
        });
        dropzone.on("removedfile", function (file) {
        });
    }
});

// function getTypeRecharge() {
//     let type = 0;
//     if ($('#pay_vnpay').is(':checked')) {
//         type = 1;
//     }
//     if ($('#pay_usdt').is(':checked')) {
//         type = 2;
//     }
//     return type;
// }

async function onCreateRecharge() {
    try {
        emptyVal();

        let type = $('input[name="pay_kind"]:checked').val();
        let amount = convertStringToNumber($("#amount_recharge").val());
        let note = $("#note_recharge").val();

        let _url = '';
        let _data = {
            type: type,
            amount: amount,
            note: note
        };

        if ($('#pay_vnpay').is(':checked')) {
            _url = window.location.origin + "/sepay/recharge";
        } else {
            _url = window.location.origin + "/recharge/create";
            _data.image = Dropzone.forElement("#myDropzone").files[0] ?? null;

            if (Dropzone.forElement("#myDropzone").files.length <= 0) {
                $('#image_recharge_err').addClass('d-block');
                $('#image_recharge_err').html('Không được để trống hình ảnh');
                return
            }
        }
        let res = await ajaxContants(_url, "POST", _data);
        if (res.status == 200) {
            if (res.url) {
                window.location.href = res.url;
            }
            showMessage({
                icon: "success",
                title: "Thành công",
                text: res.message
            });
            Dropzone.forElement("#myDropzone").removeAllFiles(true);
        } else {
            if (res.status == 422) {
                var errors = res.error; // Lấy thông điệp lỗi từ phản hồi JSON
                $.each(errors, function (key, value) {
                    // Hiển thị thông điệp lỗi tương ứng với mỗi trường
                    $('#' + key + '_recharge_err').text(value[0]);
                    $('#' + key + '_recharge_err').addClass('d-block');
                });
            } else {
                showMessage({
                    icon: "error",
                    title: "Thất bại",
                    text: res.message
                });
            }

        }
    } catch (error) {
        showMessage({
            icon: "error",
            title: "Thành công",
            text: "Lỗi khi gọi đến serve"
        });
    }
}

function emptyVal() {
    $('#amount_recharge_err').html('');
    $('#amount_recharge_err').removeClass('d-block')
    $('#note_recharge_err').html('');
    $('#note_recharge_err').removeClass('d-block')
    $('#image_recharge_err').html('');
    $('#image_recharge_err').removeClass('d-block')
}

async function getWalletUser() {
    let _url = window.location.origin + "/wallet/user";
    let _data = {};

    let res = await ajaxContants2(_url, "POST", _data);

    if (res.status === 200) {
        let amount = "Số dư: " + res.wallet.amount.toLocaleString() + " vnd"
        $('#amount_wallet_user').text(amount);
    } else {
    }
}
pub_usdt_price = 0;
showNote('vnpay');

async function showNote(kind) {

    try {
        $('#amount_recharge').prop('disabled', true);
        let url = window.location.origin + '/content-payment';
        let data = {
            kind: kind,
        }

        const call = (res) => {
            if (kind == 'usdt') {
                pub_usdt_price = res.data.price;
                let price = convertStringToNumber($('#amount_recharge').val());
                $('#payment_price_convert').val(formatNumberThousand(price * pub_usdt_price));
            }
        }

        await ajaxPostHTML(url, data, 'content-payment', call)
        $('#amount_recharge').prop('disabled', false);
    } catch (error) {
        $('#amount_recharge').prop('disabled', false);
    }
}

// $('#amount_recharge').change(function () {
//     if ($('#payment_price_convert')) {
//         let price = convertStringToNumber($('#amount_recharge').val());
//         $('#payment_price_convert').val(formatNumberThousand(price * pub_usdt_price));
//     }
// })

$('#amount_recharge').on('keyup', function () {
    if ($('#payment_price_convert')) {
        let price = convertStringToNumber($('#amount_recharge').val());
        $('#payment_price_convert').val(formatNumberThousand(price * pub_usdt_price));
    }
});

// $('input.text-number').on('change', function (e) {
//     let val = $(this).val();
//     console.log(formatNumber(val));
//     // val = val.replace(/[^\d.]/g, '');
//     // val = Math.round(val).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ',');
//     if ($(this).attr('id')) {

//     }
//     $(this).val(formatNumber(val));
// });

$('input.text-number').on('input', function (e) {
    let val = $(this).val();
    $(this).val(formatNumber(val));
});


$('#rechargeInpModal').on('hidden.bs.modal', function (e) {
    Dropzone.forElement("#myDropzone").removeAllFiles(true);
    convertStringToNumber($("#amount_recharge").val(''))
    $("#note_recharge").val('')
});


function setMyDatatable(params) {
    $(params).DataTable({
        responsive: true,
        paging: false,
        searching: false,
        ordering: false,
        select: false
    });
    $('.dataTables_info').addClass('d-none');
}

function convertTimeFormat(timeString) {
    const date = new Date(timeString);
    const year = date.getFullYear();
    const month = ('0' + (date.getMonth() + 1)).slice(-2);
    const day = ('0' + date.getDate()).slice(-2);
    const hours = ('0' + date.getHours()).slice(-2);
    const minutes = ('0' + date.getMinutes()).slice(-2);
    const seconds = ('0' + date.getSeconds()).slice(-2);
    return `${year}-${month}-${day} ${hours}:${minutes}:${seconds}`;
}

function onActionBtnShowClick(button) {  // vd: onclick="onActionBtnShowClick(this)"
    const $btn = $(button);
    const $btnIcon = $btn.find('span i');

    if ($btnIcon.hasClass('fa-plus')) {
        $btnIcon.toggleClass('fa-plus fa-minus');
        $btn.toggleClass('btn-flush-success btn-flush-danger');
    } else {
        $btnIcon.toggleClass('fa-minus fa-plus');
        $btn.toggleClass('btn-flush-danger btn-flush-success');
    }
}

function onShowModal(key, isShow = true, onShow = null, onHiden) {
    const modal = $(key);
    if (modal) {
        isShow ? modal.modal('show') : modal.modal('hide');

        if (onShow) {
            modal.on('shown.bs.modal', function () {
                onShow();
            });
        }
        if (onHiden) {
            modal.on('hidden.bs.modal', function () {
                onHiden();
            });
        }
    }
}

function onBtnLoading(key, params = true, text = "Xác nhận") {
    var btn = $(key);
    if (!btn) {
        return;
    }
    btn.html(params ? iconLoadingHtml() : text);
    btn.prop('disabled', params);
}

function readFileAsBase64(file) {
    return new Promise((resolve, reject) => {
        let reader = new FileReader();
        reader.onload = function(event) {
            resolve(event.target.result);  // Trả về Base64 của tệp
        };
        reader.onerror = function(error) {
            reject(error);  // Xử lý lỗi nếu có
        };
        reader.readAsDataURL(file);  // Đọc tệp và chuyển thành Base64
    });
}