var order_pickup_id = null, limit = 20, page = 1, order_pickup_status = null, order_pickup_image = null, order_pickup_cancel_des = null;
const url_get_order_pickup = `${window.location.href}/pagination`;
let _orders_pickup = [];
const array_show_img = [4, 5];
$(document).ready(function () {
    onPagination(url_get_order_pickup);

    // $('#autocomplete').change(function () {
    //     $('#address_map_google').val($('#autocomplete').val())
    // })
    $(".select2").select2();
});

$('#modal_update_order_pickup').on('show.bs.modal', function () {
    resetFormModalOrderPickup();
    $(`#modal_body_order_pickup`).html('');
    $(`#modal_body_order_image`).html('');
    $(`#modal_body_order_cancel_des`).html('');
    $('[name="order_pickup_date_time"]').val(moment().format('DD/MM/YYYY HH:mm:ss'));
});

$('#modal_update_order_pickup').on('hidden.bs.modal', function () {
    resetFormModalOrderPickup();
});

function showPickupDetail(key) {
    const icon = $(`#btn_pickup_${key} span i`).attr('class');
    if (icon == "fa fa-plus") {
        $(`#btn_pickup_${key} span i`).removeClass('fa-plus');
        $(`#btn_pickup_${key} span i`).addClass('fa-minus');
        $(`#btn_pickup_${key}`).removeClass('btn-flush-success');
        $(`#btn_pickup_${key}`).addClass('btn-flush-danger');
    } else {
        $(`#btn_pickup_${key} span i`).removeClass('fa-minus');
        $(`#btn_pickup_${key} span i`).addClass('fa-plus');
        $(`#btn_pickup_${key}`).removeClass('btn-flush-danger');
        $(`#btn_pickup_${key}`).addClass('btn-flush-success');
    }
}

function onClickOrderPickupStatus(status = null) {
    order_pickup_status = status;
    $('.order_pickup_status').each(function () {
        const id = $(this).attr('id');
        const id_status = id.split('_')[3];
        $(this).removeClass('active');
        if (order_pickup_status === null) {
            $('#order_pickup_status_null').addClass('active');
        } else {
            if (id_status == order_pickup_status) {
                $(this).addClass('active');
            }
        }
    });
    onPagination(url_get_order_pickup);
}

$('input[name="order_pickup_date_range"]').daterangepicker({
    opens: 'left',
    startDate: moment().subtract(3, 'months').startOf('month'),
    endDate: moment().endOf('month'),
    locale: {
        format: 'DD/MM/YYYY',
        applyLabel: "Áp dụng",
        cancelLabel: "Hủy",
        customRangeLabel: "Tùy chỉnh",
        daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
        monthNames: [
            "Tháng 1",
            "Tháng 2",
            "Tháng 3",
            "Tháng 4",
            "Tháng 5",
            "Tháng 6",
            "Tháng 7",
            "Tháng 8",
            "Tháng 9",
            "Tháng 10",
            "Tháng 11",
            "Tháng 12",
        ],
    }
}, function (start, end, label) {

});

$('input[name="order_pickup_date_time"]').daterangepicker({
    opens: 'left',
    singleDatePicker: true,
    timePicker: true,
    timePicker24Hour: true,
    timePickerSeconds: true,
    locale: {
        format: 'DD/MM/YYYY HH:mm:ss',
        applyLabel: "Áp dụng",
        cancelLabel: "Hủy",
        customRangeLabel: "Tùy chỉnh",
        daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
        monthNames: [
            "Tháng 1",
            "Tháng 2",
            "Tháng 3",
            "Tháng 4",
            "Tháng 5",
            "Tháng 6",
            "Tháng 7",
            "Tháng 8",
            "Tháng 9",
            "Tháng 10",
            "Tháng 11",
            "Tháng 12",
        ],
    }
}, function (start, end, label) {

});

$(document).on('click', '.pagination a', function (event) {
    event.preventDefault();
    page = $(this).attr('href').split('page=')[1];
    onPagination(url_get_order_pickup);
});

$('[name="order_pickup_date_range"]').on('change', function () {
    onPagination(url_get_order_pickup);
});

$('[name="order_pickup_branch_id"]').on('change', function () {
    onPagination(url_get_order_pickup);
});

let typingTimer = null;
const searchInput = $('[name="order_pickup_keywords"]');
const ignoredKeys = [13, 16, 17, 18, 20, 27, 37, 38, 39, 40, 91];

searchInput.on('keyup', function (event) {
    if (!ignoredKeys.includes(event.keyCode)) {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            onPagination(url_get_order_pickup);
        }, 500);
    }
});

searchInput.on('keydown', function (event) {
    if (!ignoredKeys.includes(event.keyCode)) {
        clearTimeout(typingTimer);
    }
});

function filters() {
    // $('#loading_show_table_content').addClass('d-block');
    // $('#loading_show_table_content').removeClass('d-none');
    return {
        date_range: {
            start_date: $('input[name="order_pickup_date_range"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
            end_date: $('input[name="order_pickup_date_range"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
        },
        order_pickup_status: order_pickup_status,
        branch_id: $('[name="order_pickup_branch_id"]').val(),
        keywords: $('[name="order_pickup_keywords"]').val(),
    };
}

async function onPagination(_url) {
    $('#show_table_content').html('');
    try {
        let data = {
            is_api: false,
            limit: limit,
            page: page,
            filters: JSON.stringify(Object.assign({}, filters())),
        };
        const result = await sendRequest(_url, 'POST', data);
        if (result.status == 200) {
            $('#show_table_content').html(result.html);
            _orders_pickup = result.orders_pickup
        }
        $('#loading_show_table_content').removeClass('d-block');
        $('#loading_show_table_content').addClass('d-none');
    } catch (error) {
        $('#loading_show_table_content').removeClass('d-block');
        $('#loading_show_table_content').addClass('d-none');
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}

function resetFormModalOrderPickup() {
    order_pickup_id = null;
    order_pickup_image = null;
    order_pickup_cancel_des = null;
    $('[name="order_pickup_type"]').val($('[name="order_pickup_type"] option:first').val());
    $('[name="branch_id"]').val($('[name="branch_id"] option:first').val());
    $('[name="order_pickup_date_time"]').val(moment().format('DD/MM/YYYY HH:mm:ss'));
    $('[name="order_pickup_awb"]').val('');
    $('[name="order_pickup_gross_weight"]').val('');
    $('[name="order_pickup_number_packages"]').val('');
    $('[name="order_pickup_phone"]').val('');
    $('[name="order_pickup_name"]').val('');
    // $('[name="order_pickup_address"]').val('');

    $('#autocomplete').val('');
    $('#lat').val('');
    $('#lng').val('');

    // end 

    $('[name="order_pickup_note"]').val('');
}

$('#close_order_pickup').on('click', async function () {
    $('#btn_close_modal_order_pickup').click();
});

$('#save_order_pickup').on('click', async function () {
    $('#close_order_pickup').attr('disabled', true);
    $('#save_order_pickup').attr('disabled', true);
    let form_validate = [
        'order_pickup_type',
        'branch_id',
        'order_pickup_date_time',
        'order_pickup_awb',
        'order_pickup_gross_weight',
        'order_pickup_number_packages',
        'order_pickup_phone',
        'order_pickup_address',
        'order_pickup_name'
    ];
    if (order_pickup_id) {
        form_validate.push('order_pickup_status');
        if (array_show_img.includes(Number($('[name="order_pickup_status"]').val()))) {
            form_validate.push('order_pickup_image');
        }
        if ($('[name="order_pickup_status"]').val() == 5) {
            form_validate.push('order_pickup_cancel_des');
        }
        form_validate = form_validate.filter(item => item !== 'order_pickup_date_time');
    }
    try {
        let data = new FormData();
        data.append('is_api', false);
        data.append('order_pickup_id', order_pickup_id);
        data.append('order_pickup_type', $('[name="order_pickup_type"]').val());
        data.append('branch_id', $('[name="branch_id"]').val());
        data.append('fwd_id', $('#fwd_ids').val());
        data.append('order_pickup_date_time', moment($('[name="order_pickup_date_time"]').val(), 'DD/MM/YYYY HH:mm:ss').format('DD-MM-YYYY HH:mm:ss'));
        data.append('order_pickup_awb', $('[name="order_pickup_awb"]').val());
        data.append('order_pickup_gross_weight', $('[name="order_pickup_gross_weight"]').val());
        data.append('order_pickup_number_packages', $('[name="order_pickup_number_packages"]').val());
        data.append('order_pickup_phone', $('[name="order_pickup_phone"]').val());
        data.append('order_pickup_name', $('[name="order_pickup_name"]').val());
        // data.append('order_pickup_address', $('[name="order_pickup_address"]').val());
        data.append('order_pickup_address', $('#autocomplete').val());
        data.append('latitude', $('#lat').val());
        data.append('longitude', $('#lng').val());

        data.append('order_pickup_cancel_des', $('#order_pickup_cancel_des') ? $('#order_pickup_cancel_des').val() : '');




        // end order_pickup_address
        data.append('order_pickup_note', $('[name="order_pickup_note"]').val());
        if (order_pickup_id) {
            data.append('order_pickup_status', $('[name="order_pickup_status"]').val());
            // if ($('[name="order_pickup_status"]').val() != 0) {
            //     if ($('#order_pickup_image').prop('files')[0]) {
            //         data.append('order_pickup_image', $('#order_pickup_image').prop('files')[0]);
            //     }
            // }
            if (array_show_img.includes(Number($('[name="order_pickup_status"]').val()))) {
                if ($('#order_pickup_image').prop('files')[0]) {
                    data.append('order_pickup_image', $('#order_pickup_image').prop('files')[0]);
                }
            }
        }



        const result = await sendRequest(`${window.location.origin}/order-pickup/update`, 'POST', data, true);

        if (result.status == 200) {
            $('#btn_close_modal_order_pickup').click();
            page = 1;
            onPagination(url_get_order_pickup);
            if ($('#fwd_ids')) {
                $('#fwd_ids').val(null);
            }
        }

        if (result.status != 422) {
            showMessage(result.message);
        }
        $.each(form_validate, function (key, value) {
            $(`#error_${value}`).html('');
        });
        $('#close_order_pickup').attr('disabled', false);
        $('#save_order_pickup').attr('disabled', false);
    } catch (error) {
        if (error.status == 422) {
            $.each(form_validate, function (key, value) {
                if (error.responseJSON.errors[value]) {
                    $(`#error_${value}`).html(error.responseJSON.errors[value][0]);
                } else {
                    $(`#error_${value}`).html('');
                }
            });
        }
        if (error.status != 422) {
            showMessage(error.message);
        }
        $('#close_order_pickup').attr('disabled', false);
        $('#save_order_pickup').attr('disabled', false);
    }
});

async function onEditOrderPickup(pickup_id) {
    order_pickup_id = pickup_id;
    $(`#btn_edit_order_pickup_${pickup_id}`).attr('disabled', true);
    try {
        let data = {
            is_api: false,
            order_pickup_id: pickup_id,
        }
        const result = await sendRequest(`${window.location.origin}/order-pickup/detail`, 'POST', data);

        if (result.status == 200) {
            $('#btn_modal_update_order_pickup').click();
            order_pickup_id = pickup_id;
            $('[name="order_pickup_type"]').val(result.data.order_pickup_type);
            $('[name="branch_id"]').val(result.data.branch_id);

            $('[name="order_pickup_date_time"]').val(moment(result.data.order_pickup_date_time).format('DD/MM/YYYY HH:mm:ss'));
            $('[name="order_pickup_awb"]').val(result.data.order_pickup_awb);
            $('[name="order_pickup_gross_weight"]').val(result.data.order_pickup_gross_weight);
            $('[name="order_pickup_number_packages"]').val(result.data.order_pickup_number_packages);
            $('[name="order_pickup_phone"]').val(result.data.order_pickup_phone);

            if (result.data.order_pickup_name) {
                $('[name="order_pickup_name"]').val(result.data.order_pickup_name);
            }
            $('[name="order_pickup_note"]').val(result.data.order_pickup_note);

            // $('[name="order_pickup_address"]').val(result.data.order_pickup_address);

            if (document.getElementById('fwd_ids') && result.data.fwd_id) {
                // if ($('#fwd_ids').is('input')) {
                //     $('#fwd_ids').val(result.data.fwd_id);
                // } else if ($('#fwd_ids').is('select')) {
                //     $('#fwd_ids').val(result.data.fwd_id).trigger('change');
                // }
                $('#fwd_ids').val(result.data.fwd_id)
            }

            if (checkLocation(result.data.latitude, result.data.longitude)) {
                updateMapWithLatLng(result.data.latitude, result.data.longitude);;
            }

            $(`#modal_body_order_pickup`).html(`
                <div class="col-sm-12"${result.show_status ? '' : 'style="display: none;"'}>
                    <div class="form-group">
                        <label class="form-label">Trạng thái *</label>
                        <select class="form-select" name="order_pickup_status">
                            ${Object.entries(result.order_pickup_status).map(([key_status, status]) => `
                                <option value="${key_status}">
                                    ${status}
                                </option>
                            `).join('')}
                        </select>
                        <small class="">*Khi cập nhật về trạng thái chờ duyệt, nếu pickup đã được chọn thì shipper đó sẽ bị hủy đơn</small>
                        <small id="error_order_pickup_status" class="text-danger"></small>
                    </div>
                </div>    
                
            `);
            $('[name="order_pickup_status"]').val(result.data.order_pickup_status);
            if (array_show_img.includes(result.data.order_pickup_status)) {
                order_pickup_image = result.data.order_pickup_image;
                $(`#modal_body_order_image`).html(`
                    <div class="col-sm-12">
                        <div class="form-group
                            <label class="form-label">Hình ảnh *</label>
                            <input type="file" id="order_pickup_image" class="dropify" data-default-file="${window.location.origin}/${order_pickup_image}" accept="image/jpeg, image/png" />
                            <small id="error_order_pickup_image" class="text-danger"></small>
                        </div>
                    </div>
                `);
                $('.dropify').dropify({
                    messages: {
                        'default': '<span class="main-text">Tải hình ảnh chất lượng cao lên</span><span class="sub-text"> Làm cho bài đăng trên blog của bạn trở nên hấp dẫn</span>',
                        'replace': 'Kéo và thả hoặc nhấp để thay thế',
                        'remove': 'Xóa',
                        'error': 'Rất tiếc, đã xảy ra sự cố.'
                    },
                    tpl: {
                        message: '<div class="dropify-message"><span class="file-icon"></span> <p>{{ default }}</p></div>',
                    }
                });
            }
            if (result.data.order_pickup_status == 5) {
                order_pickup_cancel_des = result.data.order_pickup_cancel_des;
                $(`#modal_body_order_cancel_des`).html(`
                    <div class="col-sm-12">
                        <div class="form-group">
                            <label class="form-label">Nguyên nhân hủy bỏ*</label>
                            <textarea class="form-control" id="order_pickup_cancel_des" rows="3">${order_pickup_cancel_des}</textarea>
                            <small id="error_order_pickup_cancel_des" class="text-danger"></small>
                        </div>
                    </div>
                `);
            }
        } else {
            showMessage(result.message);
        }
        $(`#btn_edit_order_pickup_${pickup_id}`).attr('disabled', false);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
        $(`#btn_edit_order_pickup_${pickup_id}`).attr('disabled', false);
    }
}

$('body').on('change', '[name="order_pickup_status"]', function () {
    if (array_show_img.includes(Number($('[name="order_pickup_status"]').val()))) {
        $(`#modal_body_order_image`).html(`
            <div class="col-sm-12">
                <div class="form-group">
                    <label class="form-label">Hình ảnh *</label>
                    <input type="file" id="order_pickup_image" class="dropify" accept="image/jpeg, image/png" ${order_pickup_image !== null && order_pickup_image !== '' ? `data-default-file="${window.location.origin}/${order_pickup_image}` : ''}"/>
                    <small id="error_order_pickup_image" class="text-danger"></small>
                </div>
            </div>
        `);
        $('.dropify').dropify({
            messages: {
                'default': '<span class="main-text">Tải hình ảnh chất lượng cao lên</span><span class="sub-text"> Làm cho bài đăng trên blog của bạn trở nên hấp dẫn</span>',
                'replace': 'Kéo và thả hoặc nhấp để thay thế',
                'remove': 'Xóa',
                'error': 'Rất tiếc, đã xảy ra sự cố.'
            },
            tpl: {
                message: '<div class="dropify-message"><span class="file-icon"></span> <p>{{ default }}</p></div>',
            }
        });
    } else {
        $(`#modal_body_order_image`).html('');
    }
    if ($('[name="order_pickup_status"]').val() == 6) {
        $(`#modal_body_order_cancel_des`).html(`
            <div class="col-sm-12">
                <div class="form-group">
                    <label class="form-label">Nguyên nhân hủy bỏ*</label>
                    <textarea class="form-control" id="order_pickup_cancel_des" rows="3">${order_pickup_cancel_des !== null ? order_pickup_cancel_des : ''}</textarea>
                    <small id="error_order_pickup_cancel_des" class="text-danger"></small>
                </div>
            </div>
        `);
    } else {
        $(`#modal_body_order_cancel_des`).html('');
    }
});

function onCancelPickup(order_pickup_id) {
    const callback = async (note) => {
        $(`#btn_delete_order_pickup_${order_pickup_id}`).attr('disabled', true);
        try {
            const data = {
                order_pickup_id: order_pickup_id,
                order_pickup_cancel_des: note,
            }
            const result = await sendRequest(`${window.location.origin}/order-pickup/delete`, 'POST', data);
            if (result.status == 200) {
                onPagination(url_get_order_pickup);
            }
            showMessage(result.message);
            $(`#btn_delete_order_pickup_${order_pickup_id}`).attr('disabled', false);
        } catch (error) {
            if (error.status != 422) {
                showMessage(error.message);
            }
            $(`#btn_delete_order_pickup_${order_pickup_id}`).attr('disabled', false);
        }
    }

    onConfirmActionWithInp({
        icon: 'question',
        text: 'Bạn có chắc chắn muốn hủy đơn này không?'
    }, callback, true)


}

function onDeleteOrderPickup(order_pickup_id) {
    let event = {
        title: 'Xác nhận hành vi!',
        text: 'Bạn có chắc muốn xóa order pickup này!',
        icon: 'question',
        type: 'agreeDeleteOrderPickup',
        data: {
            is_api: false,
            order_pickup_id: order_pickup_id,
        }
    };
    confirmEvent(event);

}

async function agreeDeleteOrderPickup(data) {
    $(`#btn_delete_order_pickup_${data.order_pickup_id}`).attr('disabled', true);
    try {
        const result = await sendRequest(`${window.location.origin}/order-pickup/delete`, 'POST', data);
        if (result.status == 200) {
            onPagination(url_get_order_pickup);
        }
        showMessage(result.message);
        $(`#btn_delete_order_pickup_${data.order_pickup_id}`).attr('disabled', false);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
        $(`#btn_delete_order_pickup_${data.order_pickup_id}`).attr('disabled', false);
    }
}


const pub_branch = ['Xe tải', 'Xe bán tải', 'Xe máy'];
const pub_status = ['Đang chờ', 'Đang đi lấy', 'Đã pickup'];

$('#btn_export_excel').click(async function () {
    $('#loading_show_table_content').removeClass('d-block');
    $('#loading_show_table_content').addClass('d-none');
    if (_orders_pickup.length < 1) {
        return showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: 'Không có dữ liệu để xuất'
        })
    }

    let excel = [];

    _orders_pickup.forEach(function (item, index) {
        let _item = {
            Id: item.order_pickup_code,
            PhuongTien: pub_branch[item.order_pickup_type],
            TrangThai: pub_status[item.order_pickup_status],
            ChiNhanh: item.branch.branch_name,
            DiaChi: item.order_pickup_address,
            Phone: item.order_pickup_phone,
            DateTime: item.order_pickup_date_time,
            GrossWeight: item.order_pickup_gross_weight,
            Note: item.order_pickup_note,
            Method: item.order_pickup_date_time_method,
        }
        excel.push(_item)
    })


    const worksheet = XLSX.utils.json_to_sheet(excel);


    // Tạo một workbook mới và thêm worksheet vào
    const workbook = XLSX.utils.book_new();
    XLSX.utils.book_append_sheet(workbook, worksheet, 'Sheet1');

    // Xuất workbook ra file Excel
    const excelBuffer = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });

    // Tạo một Blob và sử dụng FileSaver.js để lưu file
    const blob = new Blob([excelBuffer], { type: 'application/octet-stream' });
    saveAs(blob, 'order-pickup.xlsx');
})

if ($('#fwd_ids')) {
    $('#fwd_ids').change(async function () {
        chooseFwd();
    })
}

async function chooseFwd() {
    let url = window.location.origin + '/profile/info';
    let data = {
        user_id: $('#fwd_ids').val(),
    }
    let res = await ajaxContants2(url, 'POST', data);

    if (res.status == 200) {

        if (checkLocation(res.data.user_latitude, res.data.user_longitude)) {
            updateMapWithLatLng(res.data.user_latitude, res.data.user_longitude);
        }
        $('#order_pickup_name').val(res.data.user_contact_name);

        $('[name="order_pickup_phone"]').val(res.data.user_phone);
        // console.log(res);
        // console.log(res.data.order_pickup_name, res.data.user_contact_name);

    } else {
        $('#order_pickup_name').val("");
        $('[name="order_pickup_phone"]').val("");
    }
}


function checkLocation(lat, log) {
    if (!lat || !log) {
        return false;
    }
    if (lat == 0 && log == 0) {
        return false;
    }
    if (lat == "" && log == "") {
        return false;
    }
    return true;
}

async function showModallAddShipper(id) {
    try {
        $('#add_shipper_id').html('');
        order_pickup_id = id;
        let url = window.location.origin + '/order-pickup/shipper-free';
        let data = {};

        let res = await ajaxContants2(url, 'POST', data);

        if (res.status == 200) {
            $.each(res.shippers, function (index, option) {
                $('#add_shipper_id').append(new Option(option.user_contact_name + ` [${option.user_code}]`, option.user_id));
            });

            $('#addShipperFree').modal('show');
        } else {
            showMessage(res.message);
        }
    } catch (error) {
        showMessage({
            icon: 'error',
            title: 'Thông báo',
            text: 'Xảy ra lỗi ko xác định'
        });
        console.log(error);

    }
}

$('#addShipperFree').on('hidden.bs.modal', function (e) {
    order_pickup_id = null;
});

async function onAddShipper() {
    let url = window.location.origin + '/order-pickup/shipper-take';
    let data = {
        order_pickup_id: order_pickup_id,
        shipper_id: $('#add_shipper_id').val(),
    };

    let res = await ajaxContants2(url, 'POST', data);
    if (res.status == 200) {
        showMessage(res.message);
        $('#addShipperFree').modal('hide');
        onPagination(url_get_order_pickup);
    } else if (res.status == 422) {
        showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: 'Vui lòng chọn shipper'
        });
    } else {
        showMessage(res.message);
    }
}

function onDeleteShipper(params) {


    const callback = async () => {
        let url = window.location.origin + "/order-pickup/shipper-cancel";
        let data = {
            order_pickup_id: params
        }
        let res = await ajaxContants2(url, 'POST', data);
        if (res.status == 200) {
            showMessage(res.message);
            $('#addShipperFree').modal('hide');
            onPagination(url_get_order_pickup);
        } else if (res.status == 422) {
            showMessage({
                icon: 'warning',
                title: 'Thông báo',
                text: 'Vui lòng chọn shipper'
            });
        } else {
            showMessage(res.message);
        }
    }

    onConfirmAction({
        icon: 'warning',
        title: 'Thông báo',
        text: 'Bạn có chắc chắn muốn xóa đơn hàng này khỏi shipper không?'
    }, callback)
}

$(document).on('click', '.btn-update-status', function () {
    const order_pickup_id = $(this).data('order_pickup_id');
    const order_pickup_status = $(this).data('order_pickup_status');

    let type_order_pickup_status = {
        2: 'Xác nhận',
        3: 'Đang đi lấy',
        4: 'Đã lấy hàng',
        5: 'Đã pickup',
        6: 'Hủy đơn'
    };
    const event = {
        title: 'Xác nhận hành vi!',
        text: 'Bạn có chắc muốn cập nhật trạng thái đơn hàng này thành [' + type_order_pickup_status[order_pickup_status] + '] không?',
        icon: 'question',
        type: 'updateStatusOrderPickup',
        data: {
            is_api: false,
            order_pickup_id: order_pickup_id,
            order_pickup_status: order_pickup_status,
        }
    };
    confirmEvent(event);
});

async function updateStatusOrderPickup(data) {
    try {
        const result = await sendRequest(`${window.location.origin}/order-pickup/update-status`, 'POST', data);
        if (result.status == 200) {
            onPagination(url_get_order_pickup);
        }
        showMessage(result.message);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}

$(document).on('click', '.btn-update-status-picked', function () {
    const order_pickup_id = $(this).data('order_pickup_id');
    const order_pickup_status = $(this).data('order_pickup_status');

    $('#modalUploadOrderPickupImageBackdrop').data('order_pickup_id', order_pickup_id);
    $('#modalUploadOrderPickupImageBackdrop').data('order_pickup_status', order_pickup_status);
});

$(document).on('hidden.bs.modal', '#modalUploadOrderPickupImageBackdrop', function () {
    $('#order_pickup_image').val('');
    $('#modalUploadOrderPickupImageBackdrop').data('order_pickup_id', null);
});

$(document).on('click', '#btnUploadOrderPickupImage', async function () {
    if ($('[name="order_pickup_image"]').prop('files').length == 0) {
        showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: 'Vui lòng chọn hình ảnh'
        });
        return;
    }
    try {
        const order_pickup_id = $('#modalUploadOrderPickupImageBackdrop').data('order_pickup_id');
        const order_pickup_status = $('#modalUploadOrderPickupImageBackdrop').data('order_pickup_status');
        const order_pickup_image = $('[name="order_pickup_image"]').prop('files')[0];

        const data = new FormData();
        data.append('is_api', false);
        data.append('order_pickup_id', order_pickup_id);
        data.append('order_pickup_status', order_pickup_status);
        data.append('order_pickup_image', order_pickup_image);

        const result = await sendRequest(`${window.location.origin}/order-pickup/update-status`, 'POST', data, true);

        onPagination(url_get_order_pickup);
        $('#modalUploadOrderPickupImageBackdrop').modal('hide');
        onPagination(url_get_order_pickup);
        showMessage(result.message);
    } catch (error) {
        showMessage(error.message);
    }
});