let limit = 50;
let page = 1;

let btn_kind = 0 // 0: create, 1 update
let btn_text = ['Tạo MAWB mới', 'Cập nhật MAWB']

let sm_tracktry_id = null


$(document).ready(function () {
    $('input[name="daterange"]').daterangepicker({
        opens: 'left',
        startDate: moment().subtract(3, 'months').startOf('month'),
        endDate: moment().endOf('month'),
        locale: {
            format: 'DD/MM/YYYY',
            applyLabel: "Áp dụng",
            cancelLabel: "Hủy",
            customRangeLabel: "Tùy chỉnh",
            daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
            monthNames: [
                "Tháng 1",
                "Tháng 2",
                "Tháng 3",
                "Tháng 4",
                "Tháng 5",
                "Tháng 6",
                "Tháng 7",
                "Tháng 8",
                "Tháng 9",
                "Tháng 10",
                "Tháng 11",
                "Tháng 12",
            ],
        }
    }, function (start, end, label) {
        page = 1;
        fetchData();
    });
});

function getFilters() {
    return {
        keywords: $('#keywords').val(),
        tracking_status: $('#tracking_status').val(),
        date_range: {
            start_date: $('input[name="daterange"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
            end_date: $('input[name="daterange"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
        }
    }
}

$('#tracking_status').on('change', function (e) {
    page = 1;
    fetchData();
})

$('#keywords').on('keypress', function (e) {
    if (e.which === 13) { // 13 là mã ASCII của phím Enter
        page = 1;
        fetchData();
    }
})

function getData(id = null) {

    let services = "";
    let service_ids = [];
    var selectedOptions = $('#service').select2('data');
    selectedOptions.map(function (option) {
        services = services + " " + option.text;
        service_ids.push(option.id);
    });

    return {
        sm_tracktry_id: id,
        awb_code: $('#awb_code').val(),
        hawb_no: $('#hawb_no').val(),
        service: services,
        service_ids: JSON.stringify(service_ids),
        branch_id: $('#branch_id').val(),
        airline: $('#airline').val(),
        partner: $('#partner').val(),
        dest: $('#dest').val(),
        load: $('#load').val(),
        flight: $('#flight').val(),
        eta: $('#eta').val(),
        etd: $('#etd').val(),
    }
}

$(document).ready(function () {
    fetchData()
});

$(document).on('click', '.pagination a', function (event) {
    event.preventDefault();
    page = $(this).attr('href').split('page=')[1];
    fetchData();
});

function fetchData(_url = null, _page = null, _limit = null, filters = null) {
    if (!_url) {
        _url = window.location.origin + '/mawb-manager/list-sm-tracktry'
    }
    let _data = {
        paginate: {
            limit: _limit === null ? limit : _limit,
            page: _page === null ? page : _page
        },
        filters: filters == null ? getFilters() : filters
    }

    ajaxPostHTML(_url, _data, 'content')
}

$('#btn_sm_shipment').click(async function () {
    refreshTextVali()

    $('#btn_icon').html(iconLoadingHtml())
    if (btn_kind == 1) {
        await onUpdateMAWB();
    } else {
        await onCreateMAWB();
    }

    $('#btn_icon').html('<i class="fas fa-plus"></i>')
});



async function onCreateMAWB() {

    let _url = window.location.origin + '/mawb-manager/create-sm-tracktry'
    let _data = getData()

    let res = await ajaxContants2(_url, 'POST', _data);

    if (res.status === 200) {
        fetchData();
        refreshTextVali(true)
        showMessage(res.message)
    } else if (res.status === 422) {
        var errors = res.error; // Lấy thông điệp lỗi từ phản hồi JSON
        $.each(errors, function (key, value) {
            // Hiển thị thông điệp lỗi tương ứng với mỗi trường
            $('#' + key + '_err').text(value[0]);
        });
        showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: 'Vui lòng kiểm tra dữ liệu truyền vào'
        })
    } else {
        showMessage(res.message)
    }

}

async function onUpdateMAWB() {

   

    let _url = window.location.origin + '/mawb-manager/update-sm-tracktry'
    let _data = getData(sm_tracktry_id)
    let res = await ajaxContants2(_url, 'POST', _data);

    if (res.status === 200) {
        fetchData();
        refreshTextVali(true)
        showMessage(res.message)
    } else if (res.status === 422) {
        var errors = res.error; // Lấy thông điệp lỗi từ phản hồi JSON
        $.each(errors, function (key, value) {
            // Hiển thị thông điệp lỗi tương ứng với mỗi trường
            $('#' + key + '_err').text(value[0]);
        });
        showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: 'Vui lòng kiểm tra dữ liệu truyền vào'
        })
    } else {
        showMessage(res.message)
    }

}

function refreshTextVali(refresh_data = false) {
    $('#awb_code_err').val('');
    $('#service_err').val('');
    $('#branch_id_err').val('');

    if (refresh_data) {
        sm_tracktry_id = null;
        $('#awb_code').val('');
        $('#hawb_no').val('');
        $('#airline').val('');
        $('#partner').val('');
        $('#dest').val('');
        $('#service').val([]).trigger('change');

        btn_kind = 0
        $('#btn_text').text(btn_text[btn_kind])
    }
}

async function onEditSmTracking(id) {

    // if (!$('#contactapp-wrap').hasClass('contactapp-sidebar-toggle')) {
    //     $('#contactapp-wrap').addClass('contactapp-sidebar-toggle');
    // }

    sm_tracktry_id = id;
    btn_kind = 1
    $('#btn_text').text(btn_text[btn_kind])
    let _url = window.location.origin + '/mawb-manager/detail-sm-tracktry'

    let _data = {
        sm_tracktry_id: sm_tracktry_id
    }
    let res = await ajaxContants2(_url, 'POST', _data);

    if (res.status == 200) {
        let data = res.sm_tracking

        $('#awb_code').val(data.awb_code)
        $('#hawb_no').val(data.hawb_no)
        $('#service').val(JSON.parse(data.service_ids)).trigger('change');
        $('#branch_id').val(data.branch_id)
        $('#airline').val(data.airline)
        $('#partner').val(data.partner)
        $('#dest').val(data.dest)
        // Load, Flight, ETA, ETD
        $('#load').val(data.load)
        $('#flight').val(data.flight)
        $('#eta').val(data.eta)
        $('#etd').val(data.etd)


        // document.getElementById('body-content').style.paddingLeft = '270px';
    } else {
        showMessage(res.message)
    }
}

function onHiden(id) {

    const call = async () => {
        let _url = window.location.origin + '/mawb-manager/hiden-sm-tracktry'

        let _data = {
            sm_tracktry_id: id
        }
        let res = await ajaxContants2(_url, 'POST', _data);
        if (res.status == 200) {
            fetchData();
        }
        showMessage(res.message)
    }

    let alert = {
        icon: 'question',
        text: 'Bạn có muốn ẩn đối tượng này không'
    }
    onConfirmAction(alert, call);
}

function onSearchHawb() {
    Swal.fire({
        title: "Nhập mã hawb bạn muốn tìm kiếm",
        input: "text",
        inputAttributes: {
            autocapitalize: "off"
        },
        showCancelButton: true,
        confirmButtonText: "Look up",
        showLoaderOnConfirm: true,
        preConfirm: async (package_code) => {
            try {
                const url = window.location.origin + '/mawb-manager/search-hawb';
                const data = {
                    package_code: package_code
                }
                const res = await ajaxContants2(url, 'POST', data);
                if (res.status != 200) {
                    return Swal.showValidationMessage(res.message);
                }
                return res;
            } catch (error) {
                Swal.showValidationMessage(`
              Request failed: ${error}`);
            }
        },
        allowOutsideClick: () => !Swal.isLoading()
    }).then((result) => {
        if (result.isConfirmed) {
            const _data = result.value;
            console.log(_data);

            if (_data.status == 200) {
                Swal.fire({
                    title: `Kết quả`,
                    width: 600,
                    html: _data.html
                });
            } else {
                Swal.fire({
                    title: `Kết quả`,
                    html: _data.message
                });
            }


        }
    });
}