let pub_package_tracking_id = null;
let pub_page = 1;
let pub_limit = 50;

$(document).ready(function () {
    fetchData();
})

$(document).on('click', '.pagination a', function (event) {
    event.preventDefault();
    pub_page = $(this).attr('href').split('page=')[1];
    fetchData();
});

function fetchData() {
    let url = window.location.origin + '/mawb-manager/package-tracking/list'
    let data = {
        package_code: pub_package_code,
        paginate: {
            limit: pub_limit,
            page: pub_page
        },
    }

    ajaxPostHTML(url, data, 'content')
}

function onAddPackageTracking() {
    onShowModal('#addPackageTracking');
}

function onUpdatePackageTracking(data) {

    pub_package_tracking_id = data.package_tracking_id;
    $('#package_tracking_address').val(data.package_tracking_address);
    $('#package_tracking_note').val(data.package_tracking_note);
    $('#package_tracking_date').val(data.package_tracking_date);

    onShowModal('#addPackageTracking');
}

function onDeletePackageTracking(key) {
    const callback = async () => {
        let url = window.location.origin + '/mawb-manager/package-tracking/delete';
        let data = {
            package_tracking_id: key,
        }
        let res = await ajaxContants2(url, 'POST', data);
        if (res.status == 200) {
            fetchData();
        }
        showMessage(res.message);
    }

    onConfirmAction({
        icon: 'question',
        title: 'Xác nhận!',
        text: 'Bạn có chắc chắn muốn xóa trạng thái này không?'
    }, callback);
}

$('#addPackageTracking').on('hidden.bs.modal', function () {
    pub_package_tracking_id = null;
    emptyValidate();
    emptyData();
});

function emptyValidate() {
    $('#address_err').html('');
    $('#note_err').html('');
    $('#date_err').html('');
}

function emptyData() {
    $('#package_tracking_address').val("");
    $('#package_tracking_note').val("");
    $('#package_tracking_date').val("");
}

async function onUpdateOrCreateTracking() {
    try {
        onBtnLoading('#btn-add-tracking');
        emptyValidate();
        let url = window.location.origin + '/mawb-manager/package-tracking/update';
        let data = {
            package_tracking_id: pub_package_tracking_id,
            package_code: pub_package_code,
            date: $('#package_tracking_date').val(),
            address: $('#package_tracking_address').val(),
            note: $('#package_tracking_note').val(),
        }

        let res = await ajaxContants2(url, 'POST', data);

        if (res.status == 200) {
            onShowModal('#addPackageTracking', false);
            fetchData();
        } else if (res.status == 422) {

            var errors = res.error;
            $.each(errors, function (key, value) {
                // Hiển thị thông điệp lỗi tương ứng với mỗi trường
                $('#' + key + '_err').text(value[0]);
            });
        }
        showMessage(res.message);
        onBtnLoading('#btn-add-tracking', false, 'Cập nhật');
    } catch (error) {
        onBtnLoading('#btn-add-tracking', false, 'Cập nhật');
    }

}

async function updateTrackingCode() {
    onLoadingSweet(false);

    try {
        const url = window.location.origin + '/mawb-manager/package-tracking/update-tracking-code';
        const data = {
            package_code: pub_package_code,
            package_tracking_code: $('#tracking_code').val(),
        }
        let res = await ajaxContants2(url, 'POST', data);

        if (res.status == 200) {
            fetchData();
            showMessage(res.message);

        } else if (res.status == 422) {
            showMessage({
                icon: 'warning',
                text: 'Không được để trống dữ liệu'
            })
        } else {
            showMessage(res.message);
        }


    } catch (error) {
        showMessage({
            icon: 'success',
            text: 'Cập nhật thành công'
        })
    }
    onLoadingSweet(false);

}

function onCreateTrackingOnePackage(package_code) {
    Swal.fire({
        title: "Thông báo",
        text: "Bạn có chắc chắn muốn cập nhật lại mã tracking mới?",
        icon: "question",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Yes"
    }).then(async (result) => {
        if (result.isConfirmed) {
            const url = window.location.origin + '/mawb-manager/package-tracking/update-new-tracking';
            const data = {
                package_code: package_code,
                tracking_code: $('#tracking_code').val(),
            }

            const res = await ajaxContants2(url, 'POST', data);
            showMessage(res.message);
        }
    });
}