let pub_page = 1;
let pub_limit = 50;

const TABLE_COST = 1;
const TABLE_LINK = 2;
let pub_table_kind = TABLE_LINK;

let pub_is_get_all_user = false;
let pub_choosed_id = [];

$(window).ready(function () {
    fetchData();
})

$(document).on('click', '.pagination a', async function (event) {
    event.preventDefault();
    pub_page = $(this).attr('href').split('page=')[1];
    await fetchData();

});

$('#keywords').on('keypress', function (e) {
    if (e.which === 13) { // 13 là mã ASCII của phím Enter
        pub_table_kind = TABLE_LINK;
        fetchData();
    }
})

$('#keywords-cost').on('keypress', function (e) {
    if (e.which === 13) { // 13 là mã ASCII của phím Enter
        pub_table_kind = TABLE_COST;
        fetchData();
    }
})

$('#select_service_cost').change(function () {
    pub_table_kind = TABLE_COST;
    fetchData();
})

function fetchData() {

    let url = window.location.origin + '/manages/sale';
    let html_id = "";
    let data = {
        paginate: {
            page: pub_page,
            limit: pub_limit
        }
    };

    switch (pub_table_kind) {
        case TABLE_COST:
            html_id = 'content-cost';

            url = url + '/fwd/add-cost/list';
            data.filters = {
                keywords: $('#keywords-cost').val(),
                service_id: $('#select_service_cost').val()
            }
            data.html_kind = 'leader-link-cost';
            data.is_get_all_user = pub_is_get_all_user;
            data.choosed_id = pub_choosed_id;
            break;
        case TABLE_LINK:
            html_id = 'content';
            url = url + '/leader-link-cost/list';
            data.filters = {
                keywords: $('#keywords').val(),
            };
            break;

        default:
            return showMessage({
                icon: 'error',
                title: 'Thông báo',
                text: 'Không tìm thấy loại danh sách cần hiển thị'
            })
    }
    
    ajaxPostHTML(url, data, html_id);

}


$('#offcanvasCost').on('show.bs.modal', function () {
    pub_table_kind = TABLE_COST;
    pub_page = 1;
    fetchData();
});

$('#offcanvasCost').on('hidden.bs.modal', function () {
    pub_table_kind = TABLE_LINK;
    pub_choosed_id = [];
    pub_is_get_all_user = false;
    $('#keywords-cost').val('');
    fetchData();
});


function onChooseCost(value) {
    let index = pub_choosed_id.indexOf(value);
    if (index === -1) {
        pub_choosed_id.push(value);
    } else {
        pub_choosed_id.splice(index, 1);
        $('#check-all-user').prop('checked', false);
    }
}


async function onCheckAll(checked) {
    onLoadingSweet(true);
    if (!checked) {
        pub_choosed_id = [];
    }
    pub_is_get_all_user = checked;

    let url = window.location.origin + '/manages/sale/fwd/add-cost/list'
    let data = {
        is_get_all_user: pub_is_get_all_user,
        choosed_id: pub_choosed_id,
        is_get_ids: true,
        filters: {
            keywords: $('#keywords-cost').val(),
            service_id: $('#select_service_cost').val()
        }
    }

    let res = await ajaxContants2(url, 'POST', data);
    if (res.status != 200) {
        onLoadingSweet(false);
        return showMessage(res.message);
    }

    pub_choosed_id = res.fwd_costs
    fetchData();
    onLoadingSweet(false);
    $('#check-all-user').prop('checked', true);
}

function confirmLinkLeader() {
    try {
        if (pub_choosed_id.length <= 0) {
            return showMessage({
                text: 'Bạn cần chọn bảng giá cần liên kết'
            });
        }
        const callback = async () => {
            $('#btn-link-cost').html(iconLoadingHtml());
            $('#btn-link-cost').attr('disabled', true);

            let url = window.location.origin + '/manages/sale/leader-link-cost';
            let data = {
                leader_id: $('#select_leader').val(),
                choosed_id: pub_choosed_id
            }

            let res = await ajaxContants2(url, 'POST', data);
            if (res.status == 200) {
                pub_choosed_id = [];
                pub_page = 1;
                $('#keywords-cost').val('');
                fetchData();
            }
            showMessage(res.message);

            $('#btn-link-cost').html('Xác nhận')
            $('#btn-link-cost').attr('disabled', false);
        }

        onConfirmAction({
            icon: 'question',
            title: 'Thông báo',
            text: `Bạn có chắc muốn liên kết leader đã chọn với ${pub_choosed_id.length} bảng giá fwd đã chọn không?`
        }, callback)
    } catch (error) {
        showMessage();
    }
    $('#btn-link-cost').html('Xác nhận')
    $('#btn-link-cost').attr('disabled', false);
}

function onRemoveLink(key) {
    try {

        const callback = async () => {

            let url = window.location.origin + '/manages/sale/leader-link-cost/remove';
            let data = {
                fwd_cost_id: key,
            }

            let res = await ajaxContants2(url, 'POST', data);
            if (res.status == 200) {
                fetchData();
            }
            showMessage(res.message);
        }
        onConfirmAction({
            icon: 'question',
            title: 'Thông báo',
            text: `Bạn có chắc muốn xóa liên kết đã chọn không?`
        }, callback)
    } catch (error) {
        
    }
}