const USERS = 0;
const KPIS = 1;

let pub_limit = 50;
let pub_page = 1;
let pub_list_kind = KPIS;


$(document).ready(function () {
    $('#display_range_time').hide();

    fetchData(window.location.origin + '/manages/sale/kpi-list')
})

$(document).on('click', '.pagination a', async function (event) {
    event.preventDefault();
    pub_page = $(this).attr('href').split('page=')[1];
    await fetchData();

});

$('#set_time_kind').change(function () {
    fetchData(window.location.origin + '/manages/sale/kpi-list')
})

$('#keywords').on('keypress', function (e) {
    if (e.which === 13) { // 13 là mã ASCII của phím Enter
        pub_list_kind = KPIS;
        fetchData(window.location.origin + '/manages/sale/kpi-list');
    }
})

$('#keywords-user').on('keypress', function (e) {
    if (e.which === 13) { // 13 là mã ASCII của phím Enter
        pub_list_kind = USERS;
        fetchData(window.location.origin + '/manages/sale/kpi-users');
    }
})

async function fetchData(url = null) {
    let data = {};
    let loading = true;
    let html_id = '';
    if (pub_list_kind == KPIS) {
        url = url ? url : window.location.origin + '/manages/sale/kpi-list'
        html_id = 'content';
        pub_limit = 8;
        data = {
            paginate: {
                limit: pub_limit,
                page: pub_page
            },
            filters: {
                keywords: $('#keywords').val(),
                time_kind: $('#set_time_kind').val(),
            }
        }

    } else if (pub_list_kind == USERS) {
        setDataKpisSelect2()
        pub_limit = 50;
        url = url ? url : window.location.origin + '/manages/sale/kpi-users'
        data = {
            choosed_id: pub_id_user_choosed ? pub_id_user_choosed : null,
            is_get_all_user: pub_is_get_all_user ? pub_is_get_all_user : false,
            paginate: {
                limit: pub_limit,
                page: pub_page
            },
            filters: {
                keywords: $('#keywords-user').val(),
                key_kind: $('#key_search_user').val(),
                show_kind: $('#show_user_kind').val(),
                show_user_team: $('#show_user_team').val(),
            }
        }
        html_id = 'content_users';
    } else {
        return showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: 'Xảy ra lỗi khi thao tác đến serve'
        })
    }


    await ajaxPostHTML(url, data, html_id, null);
    // let res = await ajaxContants2(url, 'POST', data, loading);
}




//-START-////////////////////////// Khởi tạo hoặc cập nhật kpi ////////////////////////-START-//
let pub_range_kpis = [];
let pub_sale_kpi_id = null;
const NO_TIME_RANGE = 0;
const HAVE_TIME_RANGE = 1;

$('#set_kpi_time_range').change(function () {
    if ($('#set_kpi_time_range').is(':checked')) {
        $('#display_range_time').show();
    } else {
        $('#display_range_time').hide();
    }
});

function addItemRangeApi() {

    let range = {
        range_kpi_name: "",
        salary: 0,
        ratio_commission: 0,
        profit_start: 0,
        profit_end: 1,
        leader_have_commission: 0
    }

    pub_range_kpis.push(range);
    renderViewRangeKpi();
}

function onDeleteItemRangeKpi(index) {

    const callback = () => {
        pub_range_kpis.splice(index, 1);
        renderViewRangeKpi()
    }

    onConfirmAction({
        icon: 'question',
        title: 'Thông báo',
        text: 'Bạn có chắc muốn xóa mốc kpi này không'
    }, callback)
}

async function showDetailKpi(key) {
    let url = window.location.origin + '/manages/sale/kpi-detail';
    let data = {
        kpi_id: key,
    }
    let res = await ajaxContants2(url, 'POST', data);

    if (res.status == 200) {
        let sale_kpi = res.sale_kpi;

        pub_sale_kpi_id = sale_kpi.sale_kpi_id;
        $('#kpi_name').val(sale_kpi.kpi_name);
        if (sale_kpi.time_kind == HAVE_TIME_RANGE) {
            $('#set_kpi_time_range').prop('checked', true);
            $('#kpi_time_start').val(sale_kpi.time_start);
            $('#kpi_time_end').val(sale_kpi.time_end);
            $('#display_range_time').show();
        } else {
            $('#set_kpi_time_range').prop('checked', false);
            $('#display_range_time').hide();

        }
        pub_range_kpis = sale_kpi.range_kpis
        
        renderViewRangeKpi();
        document.getElementById('openModalAddKpi').click();
    }
}

function onSetSalary(index, value) {
    value = convertStringToNumber(value);
    if (value < 0) {
        return showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: 'Lương cơ bản không được phép bé hơn 0',
        })
    }
    pub_range_kpis[index].salary = value;
}

function onSetNameRange(index, value) {
    pub_range_kpis[index].range_kpi_name = value;
}

function onSetRatioCommission(index, inputElement) {
    let value = inputElement.value;

    let error = value < 0 || value > 100 ? true : false;
    if (error) {
        showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: 'Hoa hồng không được phép ' + (value < 0 ? 'bé hơn 0' : 'lớn hơn 100'),
        })
        value = value < 0 ? 0 : 100
        inputElement.value = value;
        pub_range_kpis[index].ratio_commission = value;
        return
    }
    pub_range_kpis[index].ratio_commission = value;
}

function onSetProfitStart(index, value) {
    value = convertStringToNumber(value);
    if (value < 0) {
        return showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: 'Hạn mức khởi đầu không được phép bé hơn 0',
        })
    }
    pub_range_kpis[index].profit_start = value;
}
function onSetProfitEnd(index, value) {
    value = convertStringToNumber(value);
    if (value < 0) {
        return showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: 'Hạn mức kết thúc không được phép bé hơn 0',
        })
    }
    pub_range_kpis[index].profit_end = value;
}
function onCheckHaveLeaderCommission(index, isChecked) {
    if (isChecked) {
        pub_range_kpis[index].leader_have_commission = 1;
    }else{
        pub_range_kpis[index].leader_have_commission = 0;
    }
}

async function onCreateOrUpdate() {
    if (!onValidateKpi()) {
        return showWarning('Vui lòng kiểm tra dữ liệu nhập vào');
    }
    try {
        $('#btn-save-kpi').html(iconLoadingHtml());
        let url = window.location.origin + '/manages/sale/kpi-handle'
        let data = {
            kpi_id: pub_sale_kpi_id,
            kpi_name: $('#kpi_name').val(),
            time_kind: $('#set_kpi_time_range').is(':checked') ? HAVE_TIME_RANGE : NO_TIME_RANGE,
            time_start: $('#set_kpi_time_range').is(':checked') ? $('#kpi_time_start').val() : null,
            time_end: $('#set_kpi_time_range').is(':checked') ? $('#kpi_time_end').val() : null,
            range_kpis: pub_range_kpis
        }

        let res = await ajaxContants2(url, 'POST', data);

        if (res.status == 200) {
            document.getElementById('closeModalAddKpi').click();

            fetchData(window.location.origin + '/manages/sale/kpi-list')
            emptyErrorMessage();
        }
        showMessage(res.message);
        // $('#btn-save-kpi').html('Xác nhận');
    } catch (error) {
        showMessage({
            icon: 'error',
            title: 'Lỗi',
            text: 'Xảy ra lỗi không xác định khi gọi đến serve'
        });
    }
    $('#btn-save-kpi').html('Xác nhận');

}

function onDeleteKpi(key) {
    const callback = async () => {
        let res = await ajaxContants2(window.location.origin + '/manages/sale/kpi-delete', 'POST', { kpi_id: key });
        showMessage(res.message);
        fetchData(window.location.origin + '/manages/sale/kpi-list')
    }
    onConfirmAction({
        icon: 'warning',
        title: 'Thông báo',
        text: 'Việc xóa bảng này đồng nghĩa với các sale đang sử dụng bảng này cũng không thể sử dụng nữa, bạn có chắc chắn chứ?'
    }, callback)
}

function emptyErrorMessage() {
    $('#kpi_name_err').html('');
    $('#set_kpi_time_range_err').html('');
    $('#display_item_kpi_err').html('');
    pub_range_kpis.forEach((item, index) => {
        $(`#key${index}_range_name_err`).html('');
        $(`#key${index}_salary_err`).html('');
        $(`#key${index}_ratio_commission_err`).html('');
        $(`#key${index}_range_profit_err`).html('');
    })
}

function onValidateKpi() {
    emptyErrorMessage();
    let result = true;

    if (pub_range_kpis.length == 0) {
        $('#display_item_kpi_err').html('Bạn cần nhập ít nhất 1 hạn mức cho kpi');
        result = false
    }

    pub_range_kpis.forEach((item, index) => {
        if (item.range_kpi_name == "") {
            $(`#key${index}_range_name_err`).html('Không được để trống tên mức chỉ tiêu');
        }
        if (!item.hasOwnProperty('profit_start') || !item.hasOwnProperty('profit_end')) {
            $(`#key${index}_range_profit_err`).html('Không được để trống giá mức hạn mức chỉ tiêu');
            result = false
        } else if (item.profit_start > item.profit_end) {
            $(`#key${index}_range_profit_err`).html('Mốc doanh thu kết thúc phải lớn hơn mốc doanh thu khởi đầu');
            result = false
        }

        if (!item.hasOwnProperty('salary')) {
            $(`#key${index}_salary_err`).html('Không được để trống mức lương cơ bản');
            result = false
        } else if (item.salary < 0) {
            $(`#key${index}_salary_err`).html('Mức lương cơ bản không được bé hơn 0');
            result = false
        }

        if (!item.hasOwnProperty('ratio_commission')) {
            $(`#key${index}_ratio_commission_err`).html('Không được để trống mức hoa hồng');
            result = false
        } else if (item.ratio_commission < 0 || item.ratio_commission > 100) {
            $(`#key${index}_ratio_commission_err`).html('Mức hoa hồng không được bé hơn 0 hay lớn hơn 100');
            result = false
        }
    })

    if ($('#kpi_name').val() == '') {
        $('#kpi_name_err').html('Cần nhập tên cho hạn mức kpi')
        result = false
    }

    if ($('#set_kpi_time_range').is(':checked')) {
        if (!$('#kpi_time_start').val() || !$('#kpi_time_end').val()) {
            $('#set_kpi_time_range_err').html('Bạn cần nhập thời gian có thể sử dụng cho kpi');
            result = false
        } else if (new Date($('#kpi_time_start').val()) > new Date($('#kpi_time_end').val())) {
            $('#set_kpi_time_range_err').html('Thời gian kết thúc phải lớn hơn thời gian bắt đầu');
            result = false
        }
    }

    return result;
}

function renderViewRangeKpi() {
    $('#display-item-kpi').html('');
    let html = '';
    pub_range_kpis.forEach((item, index) => {
        html += itemViewRange(item, index);
    })

    $('#display-item-kpi').html(html)

    $('input.text-number').on('input', function (e) {
        let val = $(this).val();
        $(this).val(formatNumber(val));
    });
}



function itemViewRange(item, index) {
    const have_commission = item.leader_have_commission == 1 ? 'checked' : '';
    return `
            <div class="card mb-5 position-relative" id="display-item-range-key${index}">
                <div class="text-end">
                    <button onclick="onDeleteItemRangeKpi(${index})"
                    class="position-absolute top-0 start-100 translate-middle
                    btn btn-icon btn-soft-danger btn-animated">
                        <span class="icon"><i class="fas fa-trash"></i></span></button>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="mb-3">
                            <label for="" class="form-label">Tên mốc</label>
                            <input type="text" class="form-control" value="${item.range_kpi_name}"
                                    aria-describedby="" onchange="onSetNameRange(${index}, this.value)">
                            <small id="key${index}_range_name_err" class="form-text text-danger"></small>
                        </div>
                        <div class="col-sm-7">
                            <div class="form-group">
                                <label class="form-label" for="">Lương cơ bản</label>
                                <input type="text" class="form-control text-number" value="${item.salary.toLocaleString()}"
                                    onchange="onSetSalary(${index}, this.value)">
                                <small id="key${index}_salary_err" class="form-text text-danger"></small>
                            </div>
                        </div>
                        <div class="col-sm-5">
                            <div class="form-group">
                                <label for="" class="form-label">Hoa hồng</label>
                                <div class="input-group">
                                    <input type="number" min="0" max="100" class="form-control"
                                       value="${item.ratio_commission}" onchange="onSetRatioCommission(${index}, this)">
                                    <span class="input-group-text">%</span>
                                </div>
                                <small id="key${index}_ratio_commission_err" class="form-text text-danger"></small>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="" class="form-label">Mốc doanh thu </label>
                            <div class="input-group mb-3">
                                <input type="text" class="form-control text-number" 
                                onchange="onSetProfitStart(${index}, this.value)"
                                value="${item.profit_start.toLocaleString()}">
                                <span class="input-group-text"> <= </span>
                                <span class="input-group-text">Doanh thu</i></span>
                                <span class="input-group-text"> < </span>
                                <input type="text" class="form-control text-number" 
                                onchange="onSetProfitEnd(${index}, this.value)"
                                value="${item.profit_end.toLocaleString()}">
                            </div>
                            <small id="key${index}_range_profit_err" class="form-text text-danger"></small>
                        </div>
                        <div class="form-check mx-3">
                            <input class="form-check-input" type="checkbox" onchange="onCheckHaveLeaderCommission(${index}, this.checked)"
                            name="leader_have_commission" id="leader_have_commission_${index}" ${have_commission}>
                            <label class="form-check-label" for="leader_have_commission_${index}">
                                Leader được hưởng hoa hồng khi sale đạt chỉ tiêu
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        `;
}

// Khi modal được mở
var modalAddKpi = document.getElementById('modalAddKpi');
modalAddKpi.addEventListener('show.bs.modal', function (event) {
});

// Khi modal bị ẩn đi
modalAddKpi.addEventListener('hidden.bs.modal', function (event) {
    pub_list_kind = KPIS;
    // Xử lý data trên modal
    pub_sale_kpi_id = null;
    pub_range_kpis = [];
    $('#kpi_name').val('');
    $('#set_kpi_time_range').prop('checked', false);
    $('#kpi_time_start').val('');
    $('#kpi_time_end').val('');
    $('#display-item-kpi').html('');

});

//-END-////////////////////////// khởi tạo hoặc cập nhật kpi  ////////////////////////-END-//



//-START-////////////////////////// Danh sách users, gắp api cho user  ////////////////////////-START-//

let pub_id_user_choosed = [];
let pub_is_get_all_user = false;

function showUserWithKpi() {
    pub_list_kind = USERS;
    fetchData();
}

$('#show_user_kind').change(function () {
    pub_is_get_all_user = false;
    pub_id_user_choosed = [];
    pub_page = 1;
    showUserWithKpi();
})
$('#show_user_team').change(function () {
    pub_is_get_all_user = false;
    pub_id_user_choosed = [];
    pub_page = 1;
    showUserWithKpi();
})
async function setDataKpisSelect2() {
    $('#select_kpi').html('');
    $('#select_kpi').append('<option selected>Chọn KPI</option>');

    let url = window.location.origin + '/manages/sale/kpi-select';
    let data = {};
    let res = await ajaxContants2(url, 'POST', data);
    if (res.status == 200) {
        let kpis = [];
        kpis = res.kpis
        kpis.forEach((item, index) => {
            $('#select_kpi').append(`<option value="${item.sale_kpi_id}">${item.kpi_name}</option>`);
        });
    } else {
        showMessage(res.message);
    }
}

$('#offcanvasExample').on('hidden.bs.offcanvas', function () {
    pub_list_kind = KPIS;
    pub_id_user_choosed = [];
    pub_is_get_all_user = false;

    $('#show_user_kind').val('');
    $('#show_user_team').val('');
});
$('.select2').each(function () {
    $(this).select2({
        dropdownParent: $(this).parent(),
    });
});


function onChooseUser(value) {
    let index = pub_id_user_choosed.indexOf(value);
    if (index === -1) {
        pub_id_user_choosed.push(value);
    } else {
        pub_id_user_choosed.splice(index, 1);
        $('#check-all-user').prop('checked', false);
    }
}

async function onCheckAll(checked) {
    onLoadingSweet(true);
    if (!checked) {
        pub_id_user_choosed = [];

    }
    pub_is_get_all_user = checked;

    let url = window.location.origin + '/manages/sale/kpi-users'
    let data = {
        is_get_ids: true,
        choosed_id: pub_id_user_choosed ? pub_id_user_choosed : null,
        is_get_all_user: pub_is_get_all_user ? pub_is_get_all_user : false,
        paginate: {
            limit: pub_limit,
            page: pub_page
        },
        filters: {
            keywords: $('#keywords-user').val(),
            // key_kind: $('#key_search_user').val(),
            show_kind: $('#show_user_kind').val(),
            show_user_team: $('#show_user_team').val(),
        }
    }

    let res = await ajaxContants2(url, 'POST', data);
    if (res.status != 200) {
        onLoadingSweet(false);
        return showMessage(res.message);
    }

    pub_id_user_choosed = res.keys

    await fetchData();

    onLoadingSweet(false);


    $('#check-all-user').prop('checked', true);
}

function onConfirmActionSale() {
    try {
        switch ($('#action_kind').val()) {
            case "0":
                showWarning('Vui lòng chọn chức năng muốn thực hiện');
                break;

            case "1":
            case "2":
                if (pub_id_user_choosed.length < 1) {
                    return showWarning('Vui lòng chọn sale muốn liên kết');
                }
                if ($('#action_kind').val() == 2 && !Number.isInteger(Number($('#select_kpi').val()))) {
                    return showWarning('Vui lòng chọn KPI muốn liên kết');
                }
                onSaleConnectKpi()
                pub_is_get_all_user = false;
                break;

            default:
                showWarning('Vui lòng chọn chức năng muốn thực hiện');
                break;
        }
    } catch (error) {
        $('#btn-connect-kpi').html('Xác nhận');
    }

}

async function onSaleConnectKpi() {

    try {
        $('#btn-connect-kpi').html(iconLoadingHtml());
        let url = window.location.origin + '/manages/sale/kpi-connect-sale'
        let data = {
            sale_ids: pub_id_user_choosed,
            kpi_id: $('#select_kpi').val(),
            kind: $('#action_kind').val()
        }
        let res = await ajaxContants2(url, 'POST', data);
        if (res.status == 200) {
            pub_id_user_choosed = [];
        }
        showMessage(res.message);
        fetchData();
        $('#btn-connect-kpi').html('Xác nhận');
    } catch (error) {
        $('#btn-connect-kpi').html('Xác nhận');

    }
}

//-END-////////////////////////// Danh sách users, gắp api cho user  ////////////////////////-END-//

function showWarning(params) {
    return showMessage({
        icon: 'warning',
        title: 'Thông báo',
        text: params
    });
}
