pub_page = 1;
pub_limit = 30;

const CONTENT_INFO = 0;
const CONTENT_LIST = 1;
let pub_content = CONTENT_LIST;

let pub_choosed_id = [];



$(document).on('click', '.pagination a', async function (event) {
    event.preventDefault();
    pub_page = $(this).attr('href').split('page=')[1];
    fetchData();
});

$(window).ready(function () {
    $('input[name="datetimes"]').daterangepicker({
        opens: 'left',
        startDate: moment().subtract(0, 'months').startOf('month'),
        endDate: moment().endOf('month'),
        locale: {
            format: 'DD/MM/YYYY',
            applyLabel: "Áp dụng",
            cancelLabel: "Hủy",
            customRangeLabel: "Tùy chỉnh",
            daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
            monthNames: [
                "Tháng 1",
                "Tháng 2",
                "Tháng 3",
                "Tháng 4",
                "Tháng 5",
                "Tháng 6",
                "Tháng 7",
                "Tháng 8",
                "Tháng 9",
                "Tháng 10",
                "Tháng 11",
                "Tháng 12",
            ],
        }
    }, function (start, end, label) {
        pub_content = CONTENT_LIST;
        fetchData();
    });

    fetchData();
})

function fetchData() {
    let url;
    let data = {
        paginate: {
            page: pub_page,
            limit: pub_limit
        }
    };
    let html_id = pub_content == CONTENT_INFO ? 'content-info' : 'content-list';

    switch (pub_content) {
        case CONTENT_INFO:
            url = window.location.origin + '/manages/sale/fwd/add-cost/list';
            data.company_id = pub_company_id;
            break;

        case CONTENT_LIST:
            url = window.location.origin + '/manages/sale/fwd/company/shipments';
            data = {
                page: pub_page,
                limit: pub_limit,
                user_id: pub_company_id,
                filters: {
                    date_range: {
                        start_date: $('input[name="datetimes"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
                        end_date: $('input[name="datetimes"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
                    },
                    keywords: $('#keywords').val(),
                }
            }
            break;
        default:
            return showMessage({
                icon: 'warning',
                title: 'Cảnh báo',
                text: 'Lỗi khi cố tải nổi dung'
            })
    }
    ajaxPostHTML(url, data, html_id);

}

function showContent(params) {
    pub_content = params;
    fetchData();
}

$('#keywords').change(function () {
    pub_content = CONTENT_LIST;
    fetchData();
})

async function onExportExcel() {
    onLoadingSweet(true);
    try {
        const url = window.location.origin + '/manages/sale/fwd/company/shipments';
        const data = {
            user_id: pub_company_id,
            filters: {
                date_range: {
                    start_date: $('input[name="datetimes"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
                    end_date: $('input[name="datetimes"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
                },
                keywords: $('#keywords').val(),
            },
            is_excel: true
        }

        fetchExportExcel(url, data, '#btn_excel', 'Báo cáo FWD company.xlsx');
    } catch (error) {
        showMessage();
        onLoadingSweet(false);
    }
    onLoadingSweet(false);
}