let pub_page = 1;
let pub_limit = 20;
const TABLE_COST = 1;
const TABLE_USERS = 2;
let pub_table_kind = TABLE_COST;

let pub_is_get_all_user = false;
let pub_choosed_id = [];

let pub_is_user_not_in_ids = [];

$(window).ready(function () {
    fetchData();
})

$(document).on('click', '.pagination a', async function (event) {
    event.preventDefault();
    pub_page = $(this).attr('href').split('page=')[1];
    await fetchData();

});

$('#keywords').on('keypress', function (e) {
    if (e.which === 13) { // 13 là mã ASCII của phím Enter
        pub_table_kind = TABLE_COST;
        fetchData();
    }
})

$('#keywords-user').on('keypress', function (e) {
    if (e.which === 13) { // 13 là mã ASCII của phím Enter
        pub_table_kind = TABLE_USERS;
        fetchData();
    }
})

$('#select_service_cost').change(function () {
    pub_table_kind = TABLE_COST;
    pub_page = 1;
    fetchData();
})

function fetchData() {

    let url = window.location.origin + '/manages/sale';
    let html_id = "";
    let data = {
        paginate: {
            page: pub_page,
            limit: pub_limit
        }
    };

    switch (pub_table_kind) {
        case TABLE_COST:
            html_id = 'content';

            url = url + '/fwd/add-cost/list';
            data.filters = {
                keywords: $('#keywords').val(),
                service_id: $('#select_service_cost').val()
            }
            break;
        case TABLE_USERS:

            html_id = 'content-users';

            url = url + '/fwd/add-cost/table-user';
            data.filters = {
                keywords: $('#keywords-user').val(),
            };
            data.service_id = $('#select_service').val();
            data.is_get_all_user = pub_is_get_all_user;
            data.choosed_id = pub_choosed_id;
            break;

        default:
            return showMessage({
                icon: 'error',
                title: 'Thông báo',
                text: 'Không tìm thấy loại danh sách cần hiển thị'
            })
    }

    ajaxPostHTML(url, data, html_id);

}


function onChooseUser(value) {
    let index = pub_choosed_id.indexOf(value);
    if (index === -1) {
        pub_choosed_id.push(value);
    } else {
        pub_choosed_id.splice(index, 1);
        $('#check-all-user').prop('checked', false);
    }
}


async function onCheckAll(checked) {
    onLoadingSweet(true);

    if (!checked) {
        pub_choosed_id = [];
    }
    pub_is_get_all_user = checked;

    let url = window.location.origin + '/manages/sale/fwd/add-cost/table-user'
    let data = {
        servie_id: $('#select_service').val(),
        is_get_all_user: pub_is_get_all_user,
        choosed_id: pub_choosed_id,
        is_get_ids: true,
        filters: {
            keywords: $('#keywords-user').val(),
        }
    }

    let res = await ajaxContants2(url, 'POST', data);
    if (res.status != 200) {
        onLoadingSweet(false);
        return showMessage(res.message);
    }

    pub_choosed_id = res.users
    await fetchData();
    onLoadingSweet(false);

    $('#check-all-user').prop('checked', true);
}


$('#select_service').change(function () {
    onCheckAll(false);
})


$('#offcanvasUsers').on('show.bs.offcanvas', function () {
    pub_table_kind = TABLE_USERS;
    pub_page = 1;
    fetchData();
});

$('#offcanvasUsers').on('hidden.bs.offcanvas', function () {
    pub_table_kind = TABLE_COST;
    pub_choosed_id = [];
    pub_is_get_all_user = false;
    $('#keywords-user').val('');
    fetchData();
});

async function confirmCreateCost() {

    if (pub_choosed_id.length < 1) {
        return showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: 'Vui lòng hãy chọn ít nhất 1 fwd'
        });
    }

    const callback = async () => {
        $('#btn-create-cost').html(iconLoadingHtml());
        $('#btn-create-cost').attr('disabled', true);
        let url = window.location.origin + '/manages/sale/fwd/add-cost/create-miltiple-cost'
        let data = {
            service_id: $('#select_service').val(),
            fwd_ids: pub_choosed_id,
            leader_cost: convertStringToNumber($('#leader_cost').val()),
            member_cost: convertStringToNumber($('#member_cost').val()),
            leader_member_cost: convertStringToNumber($('#leader_member_cost').val())
        }
        // return $('#btn-create-cost').html('Xác nhận');
        let res = await ajaxContants2(url, 'POST', data);

        if (res.status == 200) {
            pub_choosed_id = [];
            pub_is_get_all_user = false;
            fetchData();
        }
        showMessage(res.message);
        $('#btn-create-cost').html('Xác nhận')
        $('#btn-create-cost').attr('disabled', false);
    }


    onConfirmAction({
        icon: 'question',
        title: 'Thông báo',
        text: 'Bản có chắc muốn thêm bảng giá theo dịch vụ cho các fwd đã chọn không'
    }, callback)
}

function onDeleteCost(key) {


    const callback = async () => {
        let url = window.location.origin + '/manages/sale/fwd/add-cost/delete-cost';
        let data = {
            fwd_cost_id: key,
        }
        let res = await ajaxContants2(url, 'POST', data);

        if (res.status == 200) {
            fetchData();
        }
        showMessage(res.message);
    }

    onConfirmAction({
        icon: 'question',
        title: 'Thông báo',
        text: 'Bản có chắc muốn xóa đối tượng này không'
    }, callback)
}


function openModalUpdate(key, leader_cost, member_cost, leader_member_cost) {


    $('#cost_leader_update').val(leader_cost);
    $('#cost_member_update').val(member_cost);
    $('#cost_leader_member_update').val(leader_member_cost);

    let btns_html = `<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Đóng</button>
                    <button type="button" class="btn btn-primary" onclick="onUpdateCost(${key})">Cập nhật</button>`

    $('#footer-content-update').html(btns_html);

    $('#updateCostFwdModal').modal('show');
}

function emptyValidate() {
    $('#cost_leader_update_err').html('');
    $('#cost_member_update_err').html('');
    $('#cost_leader_member_update_err').html('');
}

$('#updateCostFwdModal').on('show.bs.modal', function () {
});
$('#updateCostFwdModal').on('hide.bs.modal', function () {
    emptyValidate();
    $('#cost_leader_update').val('');
    $('#cost_member_update').val('');
    $('#cost_leader_member_update').val('');
});

function onUpdateCost(key) {


    const callback = async () => {
        emptyValidate();
        let url = window.location.origin + '/manages/sale/fwd/add-cost/update-cost';
        let data = {
            fwd_cost_id: key,
            leader_cost: convertStringToNumber($('#cost_leader_update').val()),
            member_cost: convertStringToNumber($('#cost_member_update').val()),
            leader_member_cost: convertStringToNumber($('#cost_leader_member_update').val())
        }

        let res = await ajaxContants2(url, 'POST', data);

        if (res.status == 200) {
            fetchData();
            $('#updateCostFwdModal').modal('hide');
        } else if (res.status == 422) {
            $.each(errors, function (key, value) {
                $('#' + key + '_update_err').html(value[0]);
            });
        }
        showMessage(res.message);
    }

    onConfirmAction({
        icon: 'question',
        title: 'Thông báo',
        text: 'Bản có chắc muốn cập nhật đối tượng này không'
    }, callback)
}