var parent_key_manage_admin_system = null, child_key_manage_admin_system = null, page = 1, limit = 100, show_page_url = '';
var filters = [];
var pub_route_sidebars = [];
let pub_choosed_paycash = [];

const URL_SERVICE_SURCHARGE_FEE = '/manages/admin/system/service-surcharge-fee/';

$(document).ready(function () {
    $.fn.offcanvas.Constructor.prototype._initializeFocusTrap = () => ({ activate: () => { }, deactivate: () => { } });
});

function chooseTypeManageAdminSystem(parent_key, child_key, _url, menu_title = '') {
    page = 1;
    $('#offcanvasRightMangeAdminSystemBody').html('');
    $('#loading').removeClass('d-none');
    $('#loading').addClass('d-block');
    $('#offcanvasRightMangeAdminSystemLabel').html(menu_title);
    $('#manage_admin_system_content').addClass('pointer-events-none');
    $('#offcanvasRightMangeAdminSystemBody').addClass('d-none');
    $(`#simplebar_content_${parent_key_manage_admin_system}_${child_key_manage_admin_system}`).removeClass('active');
    $(`#card_simplebar_content_${parent_key_manage_admin_system}_${child_key_manage_admin_system}`).removeClass('bg-success bg-opacity-25');
    parent_key_manage_admin_system = parent_key;
    child_key_manage_admin_system = child_key;
    $(`#simplebar_content_${parent_key_manage_admin_system}_${child_key_manage_admin_system}`).addClass('active');
    $(`#card_simplebar_content_${parent_key_manage_admin_system}_${child_key_manage_admin_system}`).addClass('bg-success bg-opacity-25');

    show_page_url = _url;
    onShowPageManageAdminSystem();
}

$('#closeOffcanvasRightMangeAdminSystem').off().on('click', function () {
    $('#offcanvasRightMangeAdminSystemLabel').html('');
    $('#offcanvasRightMangeAdminSystemBody').html('');
    $('#manage_admin_system_content').removeClass('pointer-events-none');
    $(`#simplebar_content_${parent_key_manage_admin_system}_${child_key_manage_admin_system}`).removeClass('active');
    $(`#card_simplebar_content_${parent_key_manage_admin_system}_${child_key_manage_admin_system}`).removeClass('bg-success bg-opacity-25');
    parent_key_manage_admin_system = null;
    child_key_manage_admin_system = null;
    limit = 20;
    page = 1;
    show_page_url = '';
    filters = [];
    refreshIds();
});

function refreshIds() {
    //Danh sách loại tài khoản
    position_id = null;
    //Danh sách chi nhánh công ty
    branch_id = null;
    //Danh sách dịch vụ
    service_id = null;
    //Danh sách quốc gia
    country_id = null;
    //Danh sách hàng hóa phụ thu
    surcharge_goods_id = null;
    //Danh sách State/Province
    state_id = null;
    //Danh sách Liên Kết Quốc Gia - Dịch Vụ
    country_and_service_link_id = null;
    //Thêm Thành Phố Vào Hệ Thống
    city_id = null;
    //Danh Sách Dịch Vụ Khuyến Mãi
    promotion_service_id = null;
    //Danh Sách Discount Tài Khoản
    discount_user_id = null;
    discount_user_kg_levels = [];
    //Cài đặt Bảng Giá
    form_price_list = {};
    key_item_child_price_list = null;
    key_form_price_list = null;
    item_child_price_list_tmp = null;
    branchs = {};
    sub_child_price_list_area_cities = {};
    sub_child_price_list_area_town = {};
    //Chi phí vận hành công ty
    operating_costs = {};
    //Tìm kiếm
    filters = {};
    // Setting Import Excel Bảng Giá
    price_list_zone = {};
    // Danh sách remote
    town_id = null;
}

$(document).on('click', '.pagination a', function (event) {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    event.preventDefault();
    page = $(this).attr('href').split('page=')[1];
    onPagination(`${show_page_url}/pagination`);
});

async function onShowPageManageAdminSystem() {
    try {
        let data = {
            is_api: false,
            limit: limit,
            page: page
        };
        const result = await sendRequest(show_page_url, 'POST', data);
        if (result.status == 200) {
            $('#loading').removeClass('d-block');
            $('#loading').addClass('d-none');
            $('#manage_admin_system_content').removeClass('pointer-events-none');
            $('#offcanvasRightMangeAdminSystemBody').html(result.html);
            $('#offcanvasRightMangeAdminSystemBody').removeClass('d-none');

            initAutocomplete(); // load gg map
            if (result.route_sidebars) {
                pub_route_sidebars = result.route_sidebars
            }

        }
    } catch (error) {
        $('#loading').removeClass('d-block');
        $('#loading').addClass('d-none');
        $('#manage_admin_system_content').removeClass('pointer-events-none');
        $('#offcanvasRightMangeAdminSystemBody').removeClass('d-none');
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}

async function onPagination(_url) {
    $('#show_table_content').html('');
    try {
        let data = {
            is_api: false,
            limit: limit,
            page: page,
            filters: JSON.stringify(Object.assign({}, filters)),
        };
        const result = await sendRequest(_url, 'POST', data);
        if (result.status == 200) {
            $('#show_table_content').html(result.html);
        }
        $('#loading_show_table_content').removeClass('d-block');
        $('#loading_show_table_content').addClass('d-none');
    } catch (error) {
        $('#loading_show_table_content').removeClass('d-block');
        $('#loading_show_table_content').addClass('d-none');
        if (error.status != 422) {
            showMessage(error.message);
        }

    }
}

function reloadOnePageManage() {
    $('#loading').removeClass('d-none');
    $('#loading').addClass('d-block');
    $('#offcanvasRightMangeAdminSystemBody').addClass('d-none');
    onShowPageManageAdminSystem();
    refreshIds();
}

function startLoadingOffcanvasRightMangeAdminSystemBody() {
    $('#offcanvasRightMangeAdminSystemBody').html('');
    $('#offcanvasRightMangeAdminSystemBody').addClass('d-none');
    $('#loading').removeClass('d-none');
    $('#loading').addClass('d-block');
    $('#manage_admin_system_content').addClass('pointer-events-none');
}

function closeLoadingOffcanvasRightMangeAdminSystemBody() {
    $('#offcanvasRightMangeAdminSystemBody').removeClass('d-none');
    $('#loading').addClass('d-none');
    $('#loading').removeClass('d-block');
    $('#manage_admin_system_content').removeClass('pointer-events-none');
}

// Lịch sử hoạt động của tài khoản


$('body').on('change', '[name="account_log_search"]', function () {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    page = 1;
    filters.keywords = $('[name="account_log_search"]').val();
    onPagination(`${show_page_url}/pagination`);
});

function onclickShowDetailAccountActivity(key) {
    Swal.fire({
        title: "Đây là chức năng dành cho dev",
        input: "text",
        inputAttributes: {
            autocapitalize: "off"
        },
        showCancelButton: true,
        confirmButtonText: "Xác nhận",
        showLoaderOnConfirm: true,
        preConfirm: async (pass) => {
            try {
                const password = pass ?? 'not_passs';
                if (pass == null || pass == '') {
                    return Swal.showValidationMessage(`
                        Lỗi: Không được để trống mật khẩu
                      `);
                }
                const url = window.location.origin + `/manages/admin/system/account-activity-logs/detail/${key}/${password} `;
                const response = await ajaxContants2(url, 'GET', []);
                return response;
            } catch (error) {

                Swal.showValidationMessage(`
              Lỗi: ${error.responseJSON.message.text}
            `);
            }
        },
        allowOutsideClick: () => !Swal.isLoading()
    }).then((result) => {
        if (result.isConfirmed) {
            if (result.value.data) {
                const res = result.value;
                if (res.status == 200) {
                    Swal.fire({
                        title: "Chi tiết dữ liệu thay đổi",
                        icon: "info",
                        html: `${res.data}`,
                        width: '90%',
                        scrollbarPadding: true
                    });
                } else {
                    Swal.showValidationMessage(`
                        Lỗi: ${res.message.text}
                      `);
                }
            }

        }
    });
}

async function getStatesByCountry(id_name, country_id, is_change_value = false, change_value = '') {
    $(`#${id_name}`).find('option').not('[value=""]').remove();
    try {
        let data = {
            country_id: country_id
        };
        const result = await sendRequest(`${window.location.origin}/states-by-country`, 'POST', data);

        if (result.status == 200) {
            $.each(result.states, function (index, state) {
                $(`#${id_name}`).append($('<option>', {
                    value: state.state_id,
                    text: `${state.state_name} - ${state.state_code}`
                }));
            });
            if (is_change_value) {
                $(`#${id_name}`).val(change_value);
            }
            $(`#${id_name}`).trigger('change');
        }
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}

async function getJsonCitiesByCountry(country_id) {
    try {
        let data = {
            country_id: country_id
        };
        const result = await sendRequest(`${window.location.origin}/cities-by-country`, 'POST', data);
        if (result.status == 200) {
            return result.cities;
        }
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}

async function getAreasInVietNam(key_city = null, key_district = null, key_element_district, key_element_ward, is_name = true) {
    if (!key_district) {
        $(is_name ? `[name="${key_element_district}"]` : `#${key_element_district}`).find('option').not('[value=""]').remove();
        $(is_name ? `[name="${key_element_district}"]` : `#${key_element_district}`).attr("disabled", true);
    }
    $(is_name ? `[name="${key_element_ward}"]` : `#${key_element_ward}`).find('option').not('[value=""]').remove();
    $(is_name ? `[name="${key_element_ward}"]` : `#${key_element_ward}`).attr("disabled", true);
    try {
        let data = {
            city: key_city,
            district: key_district,
        }
        const result = await sendRequest(`${window.location.origin}/areas-in-viet-nam`, 'POST', data);
        if (result.status == 200) {
            if (!key_district) {
                $.each(result.areas.districts, function (key, district) {
                    $(is_name ? `[name="${key_element_district}"]` : `#${key_element_district}`).append($('<option>', {
                        value: key,
                        text: `${district}`
                    }));
                });
            }
            $.each(result.areas.wards, function (key, ward) {
                $(is_name ? `[name="${key_element_ward}"]` : `#${key_element_ward}`).append($('<option>', {
                    value: key,
                    text: `${ward}`
                }));
            });
        } else {
            showMessage(result.message);
        }
        $(is_name ? `[name="${key_element_district}"]` : `#${key_element_district}`).attr("disabled", false);
        $(is_name ? `[name="${key_element_ward}"]` : `#${key_element_ward}`).attr("disabled", false);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
        $(is_name ? `[name="${key_element_district}"]` : `#${key_element_district}`).attr("disabled", false);
        $(is_name ? `[name="${key_element_ward}"]` : `#${key_element_ward}`).attr("disabled", false);
    }
}

//Danh sách loại tài khoản
var position_id = null;

async function savePosition() {
    $('#save_position').attr('disabled', true);
    try {
        var checked_menus = [];
        $(".menu_checkbox:checked").each(function () {
            checked_menus.push(this.id);
        });

        let data = {
            is_api: false,
            position_id: position_id,
            position_name: $('[name="position_name"]').val(),
            limit_amount_flg: $('[name="limit_amount_flg"]').val(),
            // limit_amount_flg: 0,
            active_flg: $('[name="active_flg"]').val(),
            checked_menus: JSON.stringify(checked_menus),
        };
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/positions/update`, 'POST', data);

        if (result.status == 200) {
            $('[name="position_name"]').val('');
            $('[name="active_flg"]').val('1');
            // $('[name="limit_amount_flg"]').val('0');
            $(".menu_checkbox").each(function () {
                $(this).prop('checked', true);
            });
            position_id = null;
            onPagination(`${show_page_url}/pagination`);
        }

        $.each(['position_name'], function (key, value) {
            $(`#error_${value}`).html('');
        });

        showMessage(result.message);
        $('#save_position').attr('disabled', false);
    } catch (error) {
        if (error.status == 422) {
            $.each(['position_name'], function (key, value) {
                if (error.responseJSON.errors[value]) {
                    $(`#error_${value}`).html(error.responseJSON.errors[value][0]);
                } else {
                    $(`#error_${value}`).html('');
                }
            });
        }
        if (error.status != 422) {
            showMessage(error.message);
        }
        $('#save_position').attr('disabled', false);
    }
}

async function onEditPosition(id) {
    position_id = id;
    try {
        let data = {
            is_api: false,
            position_id: position_id
        };
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/positions/detail`, 'POST', data);

        if (result.status == 200) {
            $('[name="position_name"]').val(result.data.position_name);
            $('[name="active_flg"]').val(result.data.active_flg);
            // $('[name="limit_amount_flg"]').val(result.data.limit_amount_flg);
            $(".menu_checkbox").each(function () {
                let id_checkbox = this.id;
                let filtered = result.data.menus_by_position.filter(function (menu_by_position) {
                    return menu_by_position.menu_key == id_checkbox;
                });
                $(this).prop('checked', filtered.length > 0 ? true : false);
            });
        } else {
            showMessage(result.message);
        }
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}

function onDeletePosition(id) {
    let event = {
        title: 'Xác nhận hành vi!',
        text: 'Bạn có chắc muốn xóa loại người dùng này, hành động này sẽ khóa tất cả tài khoản đang mang loại người dùng này!',
        icon: 'question',
        type: 'agreeDeletePosition',
        data: {
            is_api: false,
            position_id: id,
        }
    };
    confirmEvent(event);
}

async function agreeDeletePosition(data) {
    try {
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/positions/delete`, 'POST', data);
        if (result.status == 200) {
            position_id = null;
            onPagination(`${show_page_url}/pagination`);
        }
        showMessage(result.message);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}
//Danh sách loại tài khoản

//Danh sách chi nhánh công ty
var branch_id = null;

async function saveBranch() {
    $('#save_branch').attr('disabled', true);
    try {
        let data = {
            is_api: false,
            branch_id: branch_id,
            branch_name: $('[name="branch_name"]').val(),
            // branch_description: $('[name="branch_description"]').val(),
            branch_description: $('#autocomplete').val(),
            branch_latitude: $('#lat').val(),
            branch_longitude: $('#lng').val(),
            active_flg: $('[name="active_flg"]').val(),
        };
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/branchs/update`, 'POST', data);

        if (result.status == 200) {
            $('[name="branch_name"]').val('');
            // $('[name="branch_description"]').val('');
            $('[name="active_flg"]').val('1');
            $('#autocomplete').val('');

            branch_id = null;
            let data = {
                page: 1,
                limit: 10,
            }
            ajaxPostHTML(window.location.origin + `/manages/admin/system/branchs/display/pagination`, data, 'show_table_content')
        }

        $.each(['branch_name'], function (key, value) {
            $(`#error_${value}`).html('');
        });

        showMessage(result.message);
        $('#save_branch').attr('disabled', false);
    } catch (error) {
        if (error.status == 422) {
            $.each(['branch_name'], function (key, value) {
                if (error.responseJSON.errors[value]) {
                    $(`#error_${value}`).html(error.responseJSON.errors[value][0]);
                } else {
                    $(`#error_${value}`).html('');
                }
            });
        }
        if (error.status != 422) {
            showMessage(error.message);
        }
        $('#save_branch').attr('disabled', false);
    }
}

async function onEditBranch(id) {
    branch_id = id;
    try {
        let data = {
            is_api: false,
            branch_id: branch_id
        };
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/branchs/detail`, 'POST', data);

        if (result.status == 200) {
            $('[name="branch_name"]').val(result.data.branch_name);
            // $('[name="branch_description"]').val(result.data.branch_description);
            $('[name="active_flg"]').val(result.data.active_flg);

            if (result.data.branch_latitude && result.data.branch_longitude) {
                updateMapWithLatLng(result.data.branch_latitude, result.data.branch_longitude);
            }
        } else {
            showMessage(result.message);
        }
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}

function onDeleteBranch(id) {
    let event = {
        title: 'Xác nhận hành vi!',
        text: 'Bạn có chắc muốn xóa chi nhánh công ty này, hành động này sẽ khóa tất cả tài khoản đang ở chi nhánh công ty này!',
        icon: 'question',
        type: 'agreeDeleteBranch',
        data: {
            is_api: false,
            branch_id: id,
        }
    };
    confirmEvent(event);
}

async function agreeDeleteBranch(data) {
    try {
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/branchs/delete`, 'POST', data);
        if (result.status == 200) {
            branch_id = null;
            onPagination(`${show_page_url}/pagination`);
        }
        showMessage(result.message);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}
//Danh sách chi nhánh công ty

// Danh sách Account Công Ty
$('body').on('change', '[name="users_position_id"]', function () {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    page = 1;
    filters.position_id = $('[name="users_position_id"]').val();

    onPagination(`${show_page_url}/pagination`);
});

$('body').on('change', '[name="payment_method"]', function () {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    page = 1;
    filters.payment_method = $('[name="payment_method"]').val();
    onPagination(`${show_page_url}/pagination`);
});

$('body').on('change', '[name="users_branch_id"]', function () {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    page = 1;
    filters.branch_id = $('[name="users_branch_id"]').val();
    onPagination(`${show_page_url}/pagination`);
});

$('body').on('change', '[name="users_active_flg"]', function () {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    page = 1;
    filters.active_flg = $('[name="users_active_flg"]').val();
    onPagination(`${show_page_url}/pagination`);
});

$('body').on('change', '[name="users_keywords"]', function () {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    page = 1;
    filters.keywords = $('[name="users_keywords"]').val();
    onPagination(`${show_page_url}/pagination`);
});

function onLoadPageUsers() {
    startLoadingOffcanvasRightMangeAdminSystemBody();
    onShowPageManageAdminSystem();
}

async function onLoadPageCreateUser() {
    startLoadingOffcanvasRightMangeAdminSystemBody();
    try {
        let data = {
            is_api: false,
        }
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/users/create/display`, 'POST', data);
        if (result.status == 200) {
            $('#offcanvasRightMangeAdminSystemBody').html(result.html);
        }
        closeLoadingOffcanvasRightMangeAdminSystemBody();
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
        closeLoadingOffcanvasRightMangeAdminSystemBody();
    }
}

async function onCreateNewUser() {
    $('#create_new_user').on('click', function (event) {
        event.preventDefault();
    });
    $('#create_new_user').attr('disabled', true);
    let form_validate = ['user_name', 'password', 'position_id', 'branch_id', 'user_contact_name', 'user_phone', 'user_address', 'user_price_list_main_type'];
    try {
        let data = {
            is_api: false,
            user_name: $('[name="user_name"]').val(),
            password: $('[name="password"]').val(),
            position_id: $('[name="position_id"]').val(),
            branch_id: $('[name="branch_id"]').val(),
            user_contact_name: $('[name="user_contact_name"]').val(),
            user_phone: $('[name="user_phone"]').val(),
            user_address: $('[name="user_address"]').val(),
            agree_user_signature: $('[name="agree_user_signature"]').prop('checked'),
            user_signature: paintCanvas.toDataURL('image/png'),
            user_price_list_main_type: $('[name="user_price_list_main_type"]').val(),
            // user_price_list_main_type_child: getCheckedService($('[name="user_price_list_main_type"]:checked').val())
        }

        // $.each($('.select_child_price_list'), function (key, value) {
        //     let select_name = $(value).attr('name');
        //     data[`${select_name}`] = $(`[name="${select_name}"]`).val();
        //     form_validate.push(select_name);
        // });
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/users/create/handle`, 'POST', data);
        if (result.status == 200) {
            onLoadPageUsers();
        }
        showMessage(result.message);
        $('#create_new_user').attr('disabled', true);

        $.each(form_validate, function (key, value) {
            $(`#error_${value}`).html('');
        });
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        } else {
            $.each(form_validate, function (key, value) {
                if (error.responseJSON.errors[value]) {
                    $(`#error_${value}`).html(error.responseJSON.errors[value][0]);
                } else {
                    $(`#error_${value}`).html('');
                }
            });
        }
        $('#create_new_user').attr('disabled', false);
    }
}

async function onEditUser(id) {
    startLoadingOffcanvasRightMangeAdminSystemBody();
    try {
        let data = {
            is_api: false,
            user_id: id
        };
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/users/edit/display`, 'POST', data);
        if (result.status == 200) {
            $('#offcanvasRightMangeAdminSystemBody').html(result.html);
        }
        closeLoadingOffcanvasRightMangeAdminSystemBody();
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
        closeLoadingOffcanvasRightMangeAdminSystemBody();
    }
}

$('body').on('keyup', '[name="user_limit_amount_for_sale"]', function () {
    $('[name="user_limit_amount_for_sale"]').val(formatNumber($('[name="user_limit_amount_for_sale"]').val()));
});

async function onSaveEditUser(id) {
    let form_validate = ['user_name', 'password', 'position_id', 'branch_id', 'user_contact_name', 'user_phone', 'user_address', 'user_price_list_main_type'];
    try {
        $('#on_save_edit_user').on('click', function (event) {
            event.preventDefault();
        });
        $('#on_save_edit_user').attr('disabled', true);
        let data = {
            is_api: false,
            user_id: id,
            user_name: $('[name="user_name"]').val(),
            password: $('[name="password"]').val(),
            position_id: $('[name="position_id"]').val(),
            branch_id: $('[name="branch_id"]').val(),
            user_limit_amount_for_sale: convertStringToNumber($('[name="user_limit_amount_for_sale"]').val()),
            user_contact_name: $('[name="user_contact_name"]').val(),
            user_phone: $('[name="user_phone"]').val(),
            user_address: $('[name="user_address"]').val(),
            agree_user_signature: $('[name="agree_user_signature"]').prop('checked'),
            user_signature: paintCanvas.toDataURL('image/png'),
            user_price_list_main_type: $('[name="user_price_list_main_type"]').val(),
            // user_price_list_main_type_child: getCheckedService($('[name="user_price_list_main_type"]:checked').val()),
        }
        // $.each($('.select_child_price_list'), function (key, value) {
        //     let select_name = $(value).attr('name');
        //     data[`${select_name}`] = $(`[name="${select_name}"]`).val();
        //     form_validate.push(select_name);
        // });
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/users/edit/handle`, 'POST', data);
        if (result.status == 200) {
            onLoadPageUsers();
        }
        showMessage(result.message);
        $('#on_save_edit_user').attr('disabled', false);

        $.each(form_validate, function (key, value) {
            $(`#error_${value}`).html('');
        });
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        } else {
            $.each(form_validate, function (key, value) {
                if (error.responseJSON.errors[value]) {
                    $(`#error_${value}`).html(error.responseJSON.errors[value][0]);
                } else {
                    $(`#error_${value}`).html('');
                }
            });
        }
        $('#on_save_edit_user').attr('disabled', false);
    }
}

async function onLockUser(id, active) {
    let text = active == 1 ? 'khóa' : 'mở khóa';
    let event = {
        title: 'Xác nhận hành vi!',
        text: `Bạn có chắc muốn ${text} tài khoản này!`,
        icon: 'question',
        type: 'agreeLockUser',
        data: {
            is_api: false,
            user_id: id,
            active_flg: active,
        }
    };
    confirmEvent(event);
}

async function agreeLockUser(data) {
    try {
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/users/lock`, 'POST', data);
        if (result.status == 200) {
            onPagination(`${show_page_url}/pagination`);
        }
        showMessage(result.message);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}

function onLockExport(id, params) {
    const text = params == 1 ? 'khóa' : 'mở khóa';
    onConfirmAction({
        icon: 'question',
        title: 'Xác nhận hành vi!',
        text: `Bạn có chắc chắn muốn ${text} xuất hàng của đối tượng này không?`,
    }, async () => {
        const url = `${window.location.origin}/manages/admin/system/users/lock-export`;
        const data = {
            is_api: false,
            user_id: id,
            is_export: params,
        };
        const result = await ajaxContants2(url, 'POST', data);
        if (result.status == 200) {
            onPagination(`${show_page_url}/pagination`);
        }
        showMessage(result.message);
    })
}

async function onDeleteUserById(id) {
    let event = {
        title: 'Xác nhận hành vi!',
        text: `Bạn có chắc muốn xóa tài khoản này!`,
        icon: 'question',
        type: 'agreeDeleteUserById',
        data: {
            is_api: false,
            user_id: id,
        }
    };
    confirmEvent(event);
}

async function agreeDeleteUserById(data) {
    try {
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/users/delete`, 'POST', data);

        onPagination(`${show_page_url}/pagination`);
        showMessage(result.message);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}
//Danh sách Account Công Ty

// Reset ví tiền
async function onRefreshWallet(id) {
    try {
        Swal.fire({
            title: "Thông báo",
            text: 'Bạn có chắc chắn muốn reset ví tiền này về 0 không?',
            icon: "question",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Xác nhận",
            cancelButtonText: "Hủy",
        }).then(async (result) => {
            if (result.isConfirmed) {
                const url = window.location.origin + '/manages/admin/system/refresh-wallet';
                const data = {
                    user_id: id,
                }
                let res = await ajaxContants2(url, 'POST', data);
                if (res.status == 200) {
                    onPagination(`${show_page_url}/pagination`);
                }
                showMessage(res.message);
            }
        });

    } catch (error) {
        if (error.responseJSON.message) {
            showMessage(error.responseJSON.message);
        }
    }
}

function closeDeductWalletModal() {
    $('#deductWalletModal').modal('hide');
    $('#deductAmount').val('');
    $('#deductNote').val('');
}
function closeDeductDebitModal() {
    $('#deductDebitModal').modal('hide');
    $('#deductDebit').val('');
    $('#deductNote').val('');
}

/**
 * Opens the modal to deduct a user's wallet and calls the deduct wallet API.
 * @param {number} id - The user ID.
 * @param {number} amount - The user's current wallet amount.
 */
async function onDeductWallet(id, amount) {
    $('#deductWalletModal').modal('show');
    $('#currentAmount').text(amount.toLocaleString('de-DE'));

    $('#deductWalletConfirm').off('click').on('click', async () => {
        const amount = $('#deductAmount').val();
        const note = $('#deductNote').val();

        if (!amount) {
            alert('Vui lòng nhập số tiền!');
            return;
        }

        const url = window.location.origin + '/manages/admin/system/deduct-wallet';
        const data = {
            user_id: id,
            amount: amount,
            note: note
        }
        let res = await ajaxContants2(url, 'POST', data);
        if (res.status == 200) {
            onPagination(`${show_page_url}/pagination`);
            $('#deductAmount').val('');
            $('#deductNote').val('');
        }
        showMessage(res.message);
        $('#deductWalletModal').modal('hide');
    });
}

/**
 * Mở modal reset công nợ
 * @param {number} id id người dùng
 * @param {string} [user_name] tên người dùng
 */
function onOpenResetDebitModal(id, user_name = '') {
    Swal.fire({
        title: "Thông báo",
        html: `Reset công nợ của <strong>${user_name}</strong> về 0?`,
        icon: "question",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Xác nhận",
        cancelButtonText: "Hủy",
    }).then(async (result) => {
        if (result.isConfirmed) {
            onResetDebit(id);
        }
    });
}

/**
 * Reset công nợ của user
 * @param {number} id - ID của user
 * @returns {Promise<void>}
 */
async function onResetDebit(id) {
    const url = window.location.origin + '/manages/admin/system/refresh-debit';
    const data = {
        user_id: id,
    }
    let res = await ajaxContants2(url, 'POST', data);
    if (res.status == 200) {
        onPagination(`${show_page_url}/pagination`);
    }
    showMessage(res.message);
}

async function onDeductDebit(id, amount) {
    $('#deductDebitModal').modal('show');
    $('#currentDebit').text(amount.toLocaleString('de-DE'));

    $('#deductDebitConfirm').off('click').on('click', async () => {
        const amount = $('#deductDebitAmount').val();
        const note = $('#deductDebitNote').val();

        if (!amount) {
            alert('Vui lòng nhập số tiền!');
            return;
        }

        const url = window.location.origin + '/manages/admin/system/deduct-debit';
        const data = {
            user_id: id,
            amount: amount,
            note: note
        }
        let res = await ajaxContants2(url, 'POST', data);
        if (res.status == 200) {
            onPagination(`${show_page_url}/pagination`);
            $('#deductDebitAmount').val('');
            $('#deductDebitNote').val('');
        }
        showMessage(res.message);
        $('#deductDebitModal').modal('hide');
    });
}

//Danh sách dịch vụ
var service_id = null;

$('body').on('change', '[name="promotion_service"]', function () {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    page = 1;
    filters.promotion_service_id = $('[name="promotion_service"]').val();
    onPagination(`${show_page_url}/pagination`);
});

$('body').on('change', '[name="promotion_keywords"]', function () {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    page = 1;
    filters.keywords = $('[name="promotion_keywords"]').val();
    onPagination(`${show_page_url}/pagination`);
});



async function saveService() {
    $('#save_service').attr('disabled', true);
    try {
        let data = {
            is_api: false,
            service_id: service_id,
            service_name: $('[name="service_name"]').val(),
            service_volumetric_mass: $('[name="service_volumetric_mass"]').val(),
            service_applicable_weight: $('[name="service_applicable_weight"]').val(),
            service_note: $('[name="service_note"]').val(),
            promotion_flg: $('[name="promotion_flg"]').val(),
            active_flg: $('[name="active_flg"]').val(),
            service_kind: $('[name="service_kind"]').val(),
        };
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/services/update`, 'POST', data);

        if (result.status == 200) {
            $('[name="service_name"]').val('');
            $('[name="service_volumetric_mass"]').val('');
            $('[name="service_applicable_weight"]').val('21');
            $('[name="service_note"]').val('');
            $('[name="promotion_flg"]').val('0')
            $('[name="active_flg"]').val('1');
            $('[name="service_kind"]').val('0');

            // showInpServiceCode(false)

            service_id = null;
            onPagination(`${show_page_url}/pagination`);
        }

        $.each(['service_name', 'service_volumetric_mass', 'service_applicable_weight', 'service_note'], function (key, value) {
            $(`#error_${value}`).html('');
        });

        showMessage(result.message);
        $('#save_service').attr('disabled', false);
    } catch (error) {
        if (error.status == 422) {
            $.each(['service_name', 'service_volumetric_mass', 'service_applicable_weight', 'service_note'], function (key, value) {
                if (error.responseJSON.errors[value]) {
                    $(`#error_${value}`).html(error.responseJSON.errors[value][0]);
                } else {
                    $(`#error_${value}`).html('');
                }
            });
        }
        if (error.status != 422) {
            showMessage(error.message);
        }
        $('#save_service').attr('disabled', false);
    }
}


async function onEditService(id) {
    service_id = id;
    try {
        let data = {
            is_api: false,
            service_id: service_id
        };
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/services/detail`, 'POST', data);

        if (result.status == 200) {
            $('[name="service_name"]').val(result.data.service_name);
            $('[name="service_volumetric_mass"]').val(result.data.service_volumetric_mass);
            $('[name="service_applicable_weight"]').val(result.data.service_applicable_weight);
            $('[name="service_note"]').val(result.data.service_note);
            $('[name="promotion_flg"]').val(result.data.promotion_flg)
            $('[name="active_flg"]').val(result.data.active_flg);
            $('[name="service_kind"]').val(result.data.service_kind);
        } else {
            showMessage(result.message);
        }
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}

function onDeleteService(id) {
    let event = {
        title: 'Xác nhận hành vi!',
        text: 'Bạn có chắc muốn xóa dịch vụ này!',
        icon: 'question',
        type: 'agreeDeleteService',
        data: {
            is_api: false,
            service_id: id,
        }
    };
    confirmEvent(event);
}

async function agreeDeleteService(data) {
    try {
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/services/delete`, 'POST', data);
        if (result.status == 200) {
            service_id = null;
            onPagination(`${show_page_url}/pagination`);
        }
        showMessage(result.message);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}


//Danh sách phụ thu theo dịch vụ

async function saveServiceSurchargeFee() {
    $('#save_service').attr('disabled', true);
    try {
        let data = {
            is_api: false,
            service_surcharge_fee_id: $('#service_surcharge_fee_id').val(),
            service_id: $('[name="service_id"]').val(),
            surcharge_name: $('[name="surcharge_name"]').val(),
            amount: $('[name="amount"]').val(),
            condition_type: $('[name="condition_type"]').val(),
            condition_value: $('[name="condition_value"]').val(),
        };
        const url = window.location.origin + URL_SERVICE_SURCHARGE_FEE + 'update';
        const result = await sendRequest(url, 'POST', data);

        if (result.status == 200) {
            $('#service_surcharge_fee_id').val('');
            // $('[name="service_id"]').val('');
            $('[name="surcharge_name"]').val('0');
            $('[name="amount"]').val('0');
            $('[name="condition_value"]').val('0');

            // showInpServiceCode(false)
            onPagination(`${show_page_url}/pagination`);
        }

        $.each(['service_id', 'surcharge_name', 'amount', 'condition_value'], function (key, value) {
            $(`#error_${value}`).html('');
        });

        showMessage(result.message);
        $('#save_service').attr('disabled', false);
    } catch (error) {
        if (error.status == 422) {
            $.each(['service_name', 'service_volumetric_mass', 'service_applicable_weight', 'service_note'], function (key, value) {
                if (error.responseJSON.errors[value]) {
                    $(`#error_${value}`).html(error.responseJSON.errors[value][0]);
                } else {
                    $(`#error_${value}`).html('');
                }
            });
        }
        if (error.status != 422) {
            showMessage(error.message);
        }
        $('#save_service').attr('disabled', false);
    }
}


async function onEditServiceSurchargeFee(id) {
    try {
        let data = {
            is_api: false,
            service_surcharge_fee_id: id
        };
        const url = window.location.origin + URL_SERVICE_SURCHARGE_FEE + 'detail';
        const result = await sendRequest(url, 'POST', data);

        if (result.status == 200 && typeof result.data.service_surcharge_fees != null) {
            const surcharge = result.data.service_surcharge_fees;
            $('#service_surcharge_fee_id').val(surcharge.service_surcharge_fee_id);
            $('[name="service_id"]').val(String(surcharge.service_id));
            $('[name="surcharge_name"]').val(surcharge.surcharge_name);
            $('[name="amount"]').val(surcharge.amount);
            $('[name="condition_type"]').val(String(surcharge.condition_type));
            $('[name="condition_value"]').val(surcharge.condition_value);
        } else {
            showMessage(result.message);
        }
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}

function onDeleteServiceSurchargeFee(id) {
    let event = {
        title: 'Xác nhận hành vi!',
        text: 'Bạn có chắc muốn xóa dịch vụ này!',
        icon: 'question',
        type: 'agreeDeleteServiceSurchargeFee',
        data: {
            is_api: false,
            service_surcharge_fee_id: id,
        }
    };
    confirmEvent(event);
}

async function agreeDeleteServiceSurchargeFee(data) {
    try {
        const url = window.location.origin + URL_SERVICE_SURCHARGE_FEE + 'delete';
        const result = await sendRequest(url, 'POST', data);
        if (result.status == 200) {
            $('#service_surcharge_fee_id').val('');
            // $('[name="service_id"]').val('');
            $('[name="surcharge_name"]').val('');
            $('[name="amount"]').val('21');
            $('[name="condition_value"]').val('');
            onPagination(`${show_page_url}/pagination`);
        }
        showMessage(result.message);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}
//Danh sách phụ thu dịch vụ

//Danh sách Quốc gia
var country_id = null;

$('body').on('change', '[name="countries_active_flg"]', function () {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    page = 1;
    filters.active_flg = $('[name="countries_active_flg"]').val();
    onPagination(`${show_page_url}/pagination`);
});

$('body').on('change', '[name="countries_keywords"]', function () {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    page = 1;
    filters.keywords = $('[name="countries_keywords"]').val();
    onPagination(`${show_page_url}/pagination`);
});

$('body').on('change', '[name="shipment_branch_id"], [name="shipment_status"], [name="shipment_payment_status"], [name="shipment_keywords"]', function () {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    page = 1;
    filters = {
        shipment_branch_id: $('[name="shipment_branch_id"]').val(),
        shipment_status: $('[name="shipment_status"]').val(),
        shipment_payment_status: $('[name="shipment_payment_status"]').val(),
        keywords: $('[name="shipment_keywords"]').val(),
        date_range: {
            start_date: $('input[name="report_shipment_daterange"]').data('daterangepicker').startDate.format('DD-MM-YYYY') ?? null,
            end_date: $('input[name="report_shipment_daterange"]').data('daterangepicker').endDate.format('DD-MM-YYYY') ?? null
        },
    };
    onPagination(`${show_page_url}/pagination`);
});

$('body').on('change', '[name="pay_cash_checked"], [name="payment_cash_keywords"], [name="difference_amount"], [name="bill_type"]', function () {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    page = 1;
    filters = {
        checked: $('[name="pay_cash_checked"]').val(),
        keywords: $('[name="payment_cash_keywords"]').val(),
        difference_amount: $('[name="difference_amount"]').val(),
        bill_type: $('[name="bill_type"]').val(),
        date_range: {
            start_date: $('input[name="payment_cash_daterange"]').data('daterangepicker')
                .startDate.format('DD-MM-YYYY') ?? null,
            end_date: $('input[name="payment_cash_daterange"]').data('daterangepicker')
                .endDate.format('DD-MM-YYYY') ?? null
        },
        is_check_all: $('#is_check_all').is(':checked'),
        choosed_paycash: pub_choosed_paycash
    }
    onPagination(`${show_page_url}/pagination`);
});

async function saveCountry() {
    $('#save_country').attr('disabled', true);
    try {
        let data = {
            is_api: false,
            country_id: country_id,
            country_name: $('[name="country_name"]').val(),
            country_code: $('[name="country_code"]').val(),
            active_flg: $('[name="active_flg"]').val(),
        };
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/countries/update`, 'POST', data);

        if (result.status == 200) {
            $('[name="country_name"]').val('');
            $('[name="country_code"]').val('');
            $('[name="active_flg"]').val('1');
            country_id = null;
            onPagination(`${show_page_url}/pagination`);
        }

        $.each(['country_name', 'country_code'], function (key, value) {
            $(`#error_${value}`).html('');
        });

        showMessage(result.message);
        $('#save_country').attr('disabled', false);
    } catch (error) {
        if (error.status == 422) {
            $.each(['country_name', 'country_code'], function (key, value) {
                if (error.responseJSON.errors[value]) {
                    $(`#error_${value}`).html(error.responseJSON.errors[value][0]);
                } else {
                    $(`#error_${value}`).html('');
                }
            });
        }
        if (error.status != 422) {
            showMessage(error.message);
        }
        $('#save_country').attr('disabled', false);
    }
}

async function onEditCountry(id) {
    country_id = id;
    try {
        let data = {
            is_api: false,
            country_id: country_id
        };
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/countries/detail`, 'POST', data);

        if (result.status == 200) {
            $('[name="country_name"]').val(result.data.country_name);
            $('[name="country_code"]').val(result.data.country_code);
            $('[name="active_flg"]').val(result.data.active_flg);
        } else {
            showMessage(result.message);
        }
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}

function onDeleteCountry(id) {
    let event = {
        title: 'Xác nhận hành vi!',
        text: 'Bạn có chắc muốn xóa quốc gia này!',
        icon: 'question',
        type: 'agreeDeleteCountry',
        data: {
            is_api: false,
            country_id: id,
        }
    };
    confirmEvent(event);
}

async function agreeDeleteCountry(data) {
    try {
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/countries/delete`, 'POST', data);
        if (result.status == 200) {
            country_id = null;
            onPagination(`${show_page_url}/pagination`);
        }
        showMessage(result.message);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}
//Danh sách Quốc gia

//Danh sách hàng hóa phụ thu
var surcharge_goods_id = null;

$('body').on('keyup', '[name="surcharge_goods_price"]', function () {
    $('[name="surcharge_goods_price"]').val(formatNumber($('[name="surcharge_goods_price"]').val()));
});

async function saveSurchargeGoods() {
    $('#save_surcharge_goods').attr('disabled', true);
    try {
        let data = {
            is_api: false,
            surcharge_goods_id: surcharge_goods_id,
            surcharge_goods_name: $('[name="surcharge_goods_name"]').val(),
            surcharge_goods_type: $('[name="surcharge_goods_type"]').val(),
            surcharge_goods_price: convertStringToNumber($('[name="surcharge_goods_price"]').val()),
            active_flg: $('[name="active_flg"]').val(),
        };
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/surcharge-goods/update`, 'POST', data);

        if (result.status == 200) {
            $('[name="surcharge_goods_name"]').val('');
            $('[name="surcharge_goods_type"]').val('');
            $('[name="surcharge_goods_price"]').val('');
            $('[name="active_flg"]').val('1');
            surcharge_goods_id = null;
            onPagination(`${show_page_url}/pagination`);
        }

        $.each(['surcharge_goods_name', 'surcharge_goods_type', 'surcharge_goods_price'], function (key, value) {
            $(`#error_${value}`).html('');
        });

        showMessage(result.message);
        $('#save_surcharge_goods').attr('disabled', false);
    } catch (error) {
        if (error.status == 422) {
            $.each(['surcharge_goods_name', 'surcharge_goods_type', 'surcharge_goods_price'], function (key, value) {
                if (error.responseJSON.errors[value]) {
                    $(`#error_${value}`).html(error.responseJSON.errors[value][0]);
                } else {
                    $(`#error_${value}`).html('');
                }
            });
        }
        if (error.status != 422) {
            showMessage(error.message);
        }
        $('#save_surcharge_goods').attr('disabled', false);
    }
}

async function onEditSurchargeGoods(id) {
    surcharge_goods_id = id;
    try {
        let data = {
            is_api: false,
            surcharge_goods_id: surcharge_goods_id
        };
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/surcharge-goods/detail`, 'POST', data);

        if (result.status == 200) {
            $('[name="surcharge_goods_name"]').val(result.data.surcharge_goods_name);
            $('[name="surcharge_goods_type"]').val(result.data.surcharge_goods_type);
            $('[name="surcharge_goods_price"]').val(formatNumberThousand(result.data.surcharge_goods_price));
            $('[name="active_flg"]').val(result.data.active_flg);
        } else {
            showMessage(result.message);
        }
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}

function onDeleteSurchargeGoods(id) {
    let event = {
        title: 'Xác nhận hành vi!',
        text: 'Bạn có chắc muốn xóa hàng hóa phụ thu này!',
        icon: 'question',
        type: 'agreeDeleteSurchargeGoods',
        data: {
            is_api: false,
            surcharge_goods_id: id,
        }
    };
    confirmEvent(event);
}

async function agreeDeleteSurchargeGoods(data) {
    try {
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/surcharge-goods/delete`, 'POST', data);
        if (result.status == 200) {
            surcharge_goods_id = null;
            onPagination(`${show_page_url}/pagination`);
        }
        showMessage(result.message);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}
//Danh sách hàng hóa phụ thu

//Danh sách State/Province
var state_id = null;

$('body').on('change', '[name="states_country_id"]', function () {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    page = 1;
    filters.country_id = $('[name="states_country_id"]').val();
    onPagination(`${show_page_url}/pagination`);
});

$('body').on('change', '[name="states_keywords"]', function () {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    page = 1;
    filters.keywords = $('[name="states_keywords"]').val();
    onPagination(`${show_page_url}/pagination`);
});

async function saveState() {
    $('#save_state').attr('disabled', true);
    try {
        let data = {
            is_api: false,
            state_id: state_id,
            country_id: $('[name="country_id"]').val(),
            state_post_code: $('[name="state_post_code"]').val(),
            state_code: $('[name="state_code"]').val(),
            state_name: $('[name="state_name"]').val(),
            state_details: 'remote',
            active_flg: $('[name="active_flg"]').val(),
        };
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/states/update`, 'POST', data);

        if (result.status == 200) {
            $('#country_id').val('').trigger('change');
            $('[name="state_post_code"]').val('');
            $('[name="state_code"]').val('');
            $('[name="state_name"]').val('');
            $('[name="active_flg"]').val('1');
            state_id = null;
            onPagination(`${show_page_url}/pagination`);
        }

        $.each(['country_id', 'state_post_code', 'state_code', 'state_name'], function (key, value) {
            $(`#error_${value}`).html('');
        });

        showMessage(result.message);
        $('#save_state').attr('disabled', false);
    } catch (error) {
        if (error.status == 422) {
            $.each(['country_id', 'state_post_code', 'state_code', 'state_name'], function (key, value) {
                if (error.responseJSON.errors[value]) {
                    $(`#error_${value}`).html(error.responseJSON.errors[value][0]);
                } else {
                    $(`#error_${value}`).html('');
                }
            });
        }
        if (error.status != 422) {
            showMessage(error.message);
        }
        $('#save_state').attr('disabled', false);
    }
}

async function onEditState(id) {
    state_id = id;
    try {
        let data = {
            is_api: false,
            state_id: state_id
        };
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/states/detail`, 'POST', data);

        if (result.status == 200) {
            $('#country_id').val(result.data.country ? result.data.country.country_id : '').trigger('change');
            $('[name="state_post_code"]').val(result.data.state_post_code);
            $('[name="state_code"]').val(result.data.state_code);
            $('[name="state_name"]').val(result.data.state_name);
            $('[name="active_flg"]').val(result.data.active_flg);
        } else {
            showMessage(result.message);
        }
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}

function onDeleteState(id) {
    let event = {
        title: 'Xác nhận hành vi!',
        text: 'Bạn có chắc muốn xóa state này!',
        icon: 'question',
        type: 'agreeDeleteState',
        data: {
            is_api: false,
            state_id: id,
        }
    };
    confirmEvent(event);
}

async function agreeDeleteState(data) {
    try {
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/states/delete`, 'POST', data);
        if (result.status == 200) {
            state_id = null;
            onPagination(`${show_page_url}/pagination`);
        }
        showMessage(result.message);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}
//Danh sách State/Province

//Danh sách Liên Kết Quốc Gia - Dịch Vụ
var country_and_service_link_id = null;

$('body').on('change', '[name="country_service_country_keywords"]', function () {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    page = 1;
    filters.keywords = $('[name="country_service_country_keywords"]').val();
    onPagination(`${show_page_url}/pagination`);
});

async function saveCountriesServices() {
    $('#save_country_service').attr('disabled', true);
    try {
        let countries_services = {};
        $.each($('.select_multiple_services'), function (key, value) {
            countries_services[value.id] = $(value).val();
        });
        let data = {
            is_api: false,
            countries_services: JSON.stringify(countries_services),
        };
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/countries-services/update`, 'POST', data);

        if (result.status == 200) {
            onPagination(`${show_page_url}/pagination`);
        }

        showMessage(result.message);
        $('#save_country_service').attr('disabled', false);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
        $('#save_country_service').attr('disabled', false);
    }
}

async function onEditCountryService(id) {
    country_and_service_link_id = id;
    try {
        let data = {
            is_api: false,
            country_and_service_link_id: country_and_service_link_id
        };
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/countries-services/detail`, 'POST', data);

        if (result.status == 200) {
            $('#country_id').val(result.data.country ? result.data.country.country_id : '').trigger('change');
            $('#service_id').val(result.data.service.service_id ? result.data.service.service_id : '').trigger('change');
            $('[name="active_flg"]').val(result.data.active_flg);
        } else {
            showMessage(result.message);
        }
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}

function onDeleteCountryService(id) {
    let event = {
        title: 'Xác nhận hành vi!',
        text: 'Bạn có chắc muốn xóa liên kết này!',
        icon: 'question',
        type: 'agreeDeleteCountryService',
        data: {
            is_api: false,
            country_and_service_link_id: id,
        }
    };
    confirmEvent(event);
}

async function agreeDeleteCountryService(data) {
    try {
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/countries-services/delete`, 'POST', data);
        if (result.status == 200) {
            country_and_service_link_id = null;
            onPagination(`${show_page_url}/pagination`);
        }
        showMessage(result.message);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}
//Danh sách Liên Kết Quốc Gia - Dịch Vụ

//Thêm Thành Phố Vào Hệ Thống
var city_id = null;

$('body').on('change', '[name="country_id"]', function () {
    getStatesByCountry('state_id', $('[name="country_id"]').val());
});

$('body').on('change', '[name="cities_country_id"]', function () {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    page = 1;
    filters.country_id = $('[name="cities_country_id"]').val();
    getStatesByCountry('cities_state_id', $('[name="cities_country_id"]').val());
    onPagination(`${show_page_url}/pagination`);
});

$('body').on('change', '[name="cities_state_id"]', function () {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    page = 1;
    filters.state_id = $('[name="cities_state_id"]').val();
    onPagination(`${show_page_url}/pagination`);
});

$('body').on('change', '[name="cities_active_flg"]', function () {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    page = 1;
    filters.active_flg = $('[name="cities_active_flg"]').val();
    onPagination(`${show_page_url}/pagination`);
});

$('body').on('change', '[name="cities_keywords"]', function () {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    page = 1;
    filters.keywords = $('[name="cities_keywords"]').val();
    onPagination(`${show_page_url}/pagination`);
});

async function saveCity() {
    $('#save_city').attr('disabled', true);
    try {
        let data = {
            is_api: false,
            city_id: city_id,
            country_id: $('[name="country_id"]').val(),
            city_name: $('[name="city_name"]').val(),
            city_post_code: $('[name="city_post_code"]').val(),
            state_id: $('[name="state_id"]').val(),
            active_flg: $('[name="active_flg"]').val(),
        };
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/cities/update`, 'POST', data);

        if (result.status == 200) {
            $('#country_id').val('').trigger('change');
            $('#state_id').find('option').not('[value=""]').remove();
            $('#state_id').val('').trigger('change');
            $('[name="city_name"]').val('');
            $('[name="city_post_code"]').val('');
            $('[name="active_flg"]').val('1');
            city_id = null;
            onPagination(`${show_page_url}/pagination`);
        }

        $.each(['country_id', 'state_id', 'city_name', 'city_post_code'], function (key, value) {
            $(`#error_${value}`).html('');
        });

        showMessage(result.message);
        $('#save_city').attr('disabled', false);
    } catch (error) {
        if (error.status == 422) {
            $.each(['country_id', 'state_id', 'city_name', 'city_post_code'], function (key, value) {
                if (error.responseJSON.errors[value]) {
                    $(`#error_${value}`).html(error.responseJSON.errors[value][0]);
                } else {
                    $(`#error_${value}`).html('');
                }
            });
        }
        if (error.status != 422) {
            showMessage(error.message);
        }
        $('#save_city').attr('disabled', false);
    }
}

async function onEditCity(id) {
    city_id = id;
    try {
        let data = {
            is_api: false,
            city_id: city_id
        };
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/cities/detail`, 'POST', data);

        if (result.status == 200) {
            $('#country_id').val(result.data.country ? result.data.country.country_id : '').trigger('change');
            getStatesByCountry('state_id', result.data.country ? result.data.country.country_id : '', true, result.data.state.state_id ? result.data.state.state_id : '');
            $('[name="city_name"]').val(result.data.city_name);
            $('[name="city_post_code"]').val(result.data.city_post_code);
            $('[name="active_flg"]').val(result.data.active_flg);
        } else {
            showMessage(result.message);
        }
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}

function onDeleteCity(id) {
    let event = {
        title: 'Xác nhận hành vi!',
        text: 'Bạn có chắc muốn xóa thành phố này!',
        icon: 'question',
        type: 'agreeDeleteCity',
        data: {
            is_api: false,
            city_id: id,
        }
    };
    confirmEvent(event);
}

async function agreeDeleteCity(data) {
    try {
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/cities/delete`, 'POST', data);
        if (result.status == 200) {
            city_id = null;
            onPagination(`${show_page_url}/pagination`);
        }
        showMessage(result.message);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}
//Danh sách Thêm Thành Phố Vào Hệ Thống

//Danh Sách Dịch Vụ Khuyến Mãi
var promotion_service_id = null;

async function savePromotionService() {
    $('#save_promotion_service').attr('disabled', true);
    try {
        let data = {
            is_api: false,
            promotion_service_id: promotion_service_id,
            user_id: $('[name="user_id"]').val(),
            active_flg: $('[name="active_flg"]').val(),
        };
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/promotion-services/update`, 'POST', data);

        if (result.status == 200) {
            $(`#user_id`).find('option').not('[value=""]').remove();
            $('#user_id').val('').trigger('change');
            $('[name="active_flg"]').val('1');
            $.each(result.users, function (index, user) {
                $(`#user_id`).append($('<option>', {
                    value: user.user_id,
                    text: `${user.user_name} [${user.user_contact_name}]`
                }));
            });
            promotion_service_id = null;
            onPagination(`${show_page_url}/pagination`);
        }

        $.each(['user_id'], function (key, value) {
            $(`#error_${value}`).html('');
        });

        showMessage(result.message);
        $('#save_promotion_service').attr('disabled', false);
    } catch (error) {
        if (error.status == 422) {
            $.each(['user_id'], function (key, value) {
                if (error.responseJSON.errors[value]) {
                    $(`#error_${value}`).html(error.responseJSON.errors[value][0]);
                } else {
                    $(`#error_${value}`).html('');
                }
            });
        }
        if (error.status != 422) {
            showMessage(error.message);
        }
        $('#save_promotion_service').attr('disabled', false);
    }
}

function onDeletePromotionService(id) {
    let event = {
        title: 'Xác nhận hành vi!',
        text: 'Bạn có chắc muốn xóa dịch vụ khuyến mãi này!',
        icon: 'question',
        type: 'agreeDeletePromotionService',
        data: {
            is_api: false,
            promotion_service_id: id,
        }
    };
    confirmEvent(event);
}

async function agreeDeletePromotionService(data) {
    try {
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/promotion-services/delete`, 'POST', data);
        if (result.status == 200) {
            $(`#user_id`).find('option').not('[value=""]').remove();
            promotion_service_id = null;
            onPagination(`${show_page_url}/pagination`);
            $.each(result.users, function (index, user) {
                $(`#user_id`).append($('<option>', {
                    value: user.user_id,
                    text: `${user.user_name} [${user.user_contact_name}]`
                }));
            });
        }
        showMessage(result.message);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}
//Danh Sách Dịch Vụ Khuyến Mãi

//Chỉnh sửa Hệ Thống
function saveSystemSettings(id) {
    let event = {
        title: 'Xác nhận hành vi!',
        text: 'Bạn có chắc muốn lưu lại các thay đổi!',
        icon: 'question',
        type: 'agreeSaveSystemSettings',
        data: {
            is_api: false,
            service_accountant_status: $('[name="service_accountant_status"]').prop('checked'),
            authenticator_all_user_status: $('[name="authenticator_all_user_status"]').prop('checked'),
            setting_admin_account: $('[name="setting_admin_account"]').val(),
            setting_accountant_account: $('[name="setting_accountant_account"]').val(),
            setting_document_account: $('[name="setting_document_account"]').val(),
            setting_sale_account: $('[name="setting_sale_account"]').val(),
            setting_fwd_account: $('[name="setting_fwd_account"]').val(),
            setting_shipper_account: $('[name="setting_shipper_account"]').val(),
            setting_driver_account: $('[name="setting_driver_account"]').val(),
            setting_ops_leader_account: $('[name="setting_ops_leader_account"]').val(),
            setting_account_edit_order_pickup: $('[name="setting_account_edit_order_pickup"]').val(),
            setting_account_update_notifications: $('[name="setting_account_update_notifications"]').val(),
            setting_account_view_and_update_shipment_operating_cost: $('[name="setting_account_view_and_update_shipment_operating_cost"]').val(),
            setting_account_scan: $('[name="setting_account_scan"]').val(),
            setting_account_ticket: $('[name="setting_account_ticket"]').val(),
            setting_account_debits: $('[name="setting_account_debits"]').val(),
            setting_print_bill_type: $('[name="setting_print_bill_type"]').val(),
            setting_company_name: $('[name="setting_company_name"]').val(),
            setting_headquarters_address: $('[name="setting_headquarters_address"]').val(),
            setting_email_address: $('[name="setting_email_address"]').val(),
            setting_website_address: $('[name="setting_website_address"]').val(),
            setting_hotline: $('[name="setting_hotline"]').val(),
            setting_zalo: $('[name="setting_zalo"]').val(),
            setting_facebook: $('[name="setting_facebook"]').val(),
        }
    };
    confirmEvent(event);
}

async function agreeSaveSystemSettings(data) {
    $('#save_system_settings').attr('disabled', true);
    try {
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/settings/update`, 'POST', data);
        $.each(['setting_admin_account', 'setting_accountant_account', 'setting_document_account', 'setting_sale_account', 'setting_fwd_account', 'setting_shipper_account', 'setting_driver_account', 'setting_ops_leader_account'], function (key, value) {
            $(`#error_${value}`).html('');
        });
        showMessage(result.message);
        $('#save_system_settings').attr('disabled', false);
    } catch (error) {
        if (error.status == 422) {
            $.each(['setting_admin_account', 'setting_accountant_account', 'setting_document_account', 'setting_sale_account', 'setting_fwd_account', 'setting_shipper_account', 'setting_driver_account'], function (key, value) {
                if (error.responseJSON.errors[value]) {
                    $(`#error_${value}`).html(error.responseJSON.errors[value][0]);
                } else {
                    $(`#error_${value}`).html('');
                }
            });
        }
        if (error.status != 422) {
            showMessage(error.message);
            $.each(['setting_admin_account', 'setting_accountant_account', 'setting_document_account', 'setting_sale_account', 'setting_fwd_account', 'setting_shipper_account', 'setting_driver_account'], function (key, value) {
                $(`#error_${value}`).html('');
            });
        }
        $('#save_system_settings').attr('disabled', false);
    }
}
//Chỉnh sửa Hệ Thống

//Danh Sách Discount Tài Khoản
var discount_user_id = null;
var discount_user_kg_levels = [];

async function saveDiscountUser() {
    $('#save_discount_user').attr('disabled', true);
    try {
        let data = {
            is_api: false,
            discount_user_id: discount_user_id,
            user_id: $('[name="user_id"]').val(),
            service_id: $('[name="service_id"]').val(),
            discount_start_date: $('input[name="discount_user_daterange"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
            discount_end_date: $('input[name="discount_user_daterange"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
            discount_note: $('[name="discount_note"]').val(),
            discount_user_kg_levels: JSON.stringify(discount_user_kg_levels)
        };
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/discount-users/update`, 'POST', data);

        if (result.status == 200) {
            $('#user_id').val('').trigger('change');
            $('#service_id').val('').trigger('change');
            $('input[name="discount_user_daterange"]').data('daterangepicker').setStartDate(moment().startOf('month'));
            $('input[name="discount_user_daterange"]').data('daterangepicker').setEndDate(moment().endOf('month'));
            $('[name="discount_note"]').val('');
            $('#form_discount_user_kg_levels').html('');
            discount_user_id = null;
            discount_user_kg_levels = [];
            onPagination(`${show_page_url}/pagination`);
        }

        $.each(['user_id', 'service_id', 'discount_user_daterange'], function (key, value) {
            $(`#error_${value}`).html('');
        });

        showMessage(result.message);
        $('#save_discount_user').attr('disabled', false);
    } catch (error) {
        if (error.status == 422) {
            $.each(['user_id', 'service_id', 'discount_user_daterange'], function (key, value) {
                if (error.responseJSON.errors[value]) {
                    $(`#error_${value}`).html(error.responseJSON.errors[value][0]);
                } else {
                    $(`#error_${value}`).html('');
                }
            });
        }
        if (error.status != 422) {
            showMessage(error.message);
        }
        $('#save_discount_user').attr('disabled', false);
    }
}

async function onEditDiscountUser(id) {
    discount_user_id = id;
    try {
        let data = {
            is_api: false,
            discount_user_id: discount_user_id
        };
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/discount-users/detail`, 'POST', data);

        if (result.status == 200) {
            $('#user_id').val(result.data.user ? result.data.user.user_id : '').trigger('change');
            $('#service_id').val(result.data.service ? result.data.service.service_id : '').trigger('change');
            $('input[name="discount_user_daterange"]').data('daterangepicker').setStartDate(moment(result.data.discount_start_date));
            $('input[name="discount_user_daterange"]').data('daterangepicker').setEndDate(moment(result.data.discount_end_date));
            $('[name="discount_note"]').val(result.data.discount_note);

            discount_user_kg_levels = result.data.discount_user_weight_levels;
            $('#form_discount_user_kg_levels').html('');
            setDisplayDiscountUserKgLevels();
        } else {
            showMessage(result.message);
        }
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}

function onDeleteDiscountUser(id) {
    let event = {
        title: 'Xác nhận hành vi!',
        text: 'Bạn có chắc muốn xóa giảm giá tài khoản này!',
        icon: 'question',
        type: 'agreeDeleteDiscountUser',
        data: {
            is_api: false,
            discount_user_id: id,
        }
    };
    confirmEvent(event);
}

async function agreeDeleteDiscountUser(data) {
    try {
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/discount-users/delete`, 'POST', data);
        if (result.status == 200) {
            discount_user_id = null;
            onPagination(`${show_page_url}/pagination`);
        }
        showMessage(result.message);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}

function setDisplayDiscountUserKgLevels() {
    discount_user_kg_levels = Object.values(discount_user_kg_levels);

    $.each(discount_user_kg_levels, function (key, discount_user_kg_level) {
        $('#form_discount_user_kg_levels').append(`
            <div class="form-group">
                <div class="input-group mb-1">
                    <span class="input-group-text">></span>
                    <input type="number" class="form-control discount_user_weight" placeholder="Nhập số cân nặng" required
                        value="${discount_user_kg_level.discount_user_weight}" data-key="${key}">
                    <span class="input-group-text">kg</span>
                </div>
                <div class="input-group">
                    <input type="number" class="form-control discount_user_amount" placeholder="Nhập số tiền" required
                        value="${discount_user_kg_level.discount_user_amount}" data-key="${key}">
                    <button type="button" class="btn btn-danger input-group-text btn_remove_discount_user_kg_level" data-key="${key}">
                        <i class="fas fa-trash-alt"></i>
                    </button>
                </div>
                <hr>
            </div>
        `);
    });
}

$(document).on('click', '.btn_remove_discount_user_kg_level', function () {
    const key = $(this).data('key');
    delete discount_user_kg_levels[key];

    $('#form_discount_user_kg_levels').html('');
    setDisplayDiscountUserKgLevels();
});

$(document).on('click', '#add_discount_user_kg_level', function () {
    const last_key = discount_user_kg_levels.length;
    discount_user_kg_levels[last_key] = {
        discount_user_weight: 0,
        discount_user_amount: 0,
    };

    $('#form_discount_user_kg_levels').html('');
    setDisplayDiscountUserKgLevels();
});

$(document).on('keyup', '.discount_user_weight', function () {
    const key = $(this).data('key');
    discount_user_kg_levels[key].discount_user_weight = $(this).val();
});

$(document).on('keyup', '.discount_user_amount', function () {
    const key = $(this).data('key');
    discount_user_kg_levels[key].discount_user_amount = $(this).val();
});
//Danh Sách Discount Tài Khoản

//Danh sách Account FWD
$('body').on('change', '[name="user_address_1"]', function () {
    getAreasInVietNam($('[name="user_address_1"]').val(), null, 'user_address_2', 'user_address_3', false)
});

$('body').on('change', '[name="user_address_2"]', function () {
    getAreasInVietNam($('[name="user_address_1"]').val(), $('[name="user_address_2"]').val(), 'user_address_2', 'user_address_3', false)
});

function onLoadPageFWDUsers() {
    startLoadingOffcanvasRightMangeAdminSystemBody();
    onShowPageManageAdminSystem();
}

async function onExportExcelFWDUser() {
    try {
        let data = {
            is_api: false,
            export_excel: true,
            filters: {
                active_flg: $('[name="users_active_flg"]').val(),
                keywords: $('[name="users_keywords"]').val(),
            },
        };
        const url = `${window.location.origin}/manages/admin/system/fwd-users/display/pagination`;
        const file_name = 'Danh sach FWD.xlsx';
        fetchExportExcel(url, data, '#btn_excel_sm', file_name)
    } catch (error) {
        showMessage()
    }
}

async function onLoadPageCreateFWDUser() {
    startLoadingOffcanvasRightMangeAdminSystemBody();
    try {
        let data = {
            is_api: false,
        }
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/fwd-users/create/display`, 'POST', data);
        if (result.status == 200) {
            await $('#offcanvasRightMangeAdminSystemBody').html(result.html);
            initAutocomplete(); // load gg map
        }
        closeLoadingOffcanvasRightMangeAdminSystemBody();
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
        closeLoadingOffcanvasRightMangeAdminSystemBody();
    }
}


async function onCreateNewFWDUser() {
    $('body').on('click', '#create_new_fwd_user', function (event) {
        event.preventDefault();
    });
    $('#create_new_fwd_user').attr('disabled', true);
    let form_validate = [
        'user_logo',
        'user_name',
        'password',
        'user_contact_name',
        'user_accountant_key',
        'user_company_name',
        'user_tax_code',
        'user_phone',
        'branch_id',
        'user_address_1',
        'user_address_2',
        'user_address_3',
        'user_address',
        'user_price_list_main_type',
        'user_limit_amount_for_sale'
    ];
    try {
        let data = new FormData();
        data.append('is_api', false);
        // $.each($('.select_child_price_list'), function (key, value) {
        //     let select_name = $(value).attr('name');
        //     data.append(`${select_name}`, $(`[name="${select_name}"]`).val());
        //     form_validate.push(select_name);
        // });
        data.append('user_logo', $('[name="user_logo"]')[0]['files'][0]);
        data.append('user_name', $('[name="user_name"]').val());
        data.append('password', $('[name="password"]').val());
        data.append('user_contact_name', $('[name="user_contact_name"]').val());
        data.append('user_accountant_key', $('[name="user_accountant_key"]').val());
        data.append('user_debit_type', $('[name="user_debit_type"]').val());
        data.append('user_company_name', $('[name="user_company_name"]').val());
        data.append('user_tax_code', $('[name="user_tax_code"]').val());
        data.append('user_phone', $('[name="user_phone"]').val());
        data.append('branch_id', $('[name="branch_id"]').val());
        data.append('user_address_1', $('[name="user_address_1"]').val());
        data.append('user_address_2', $('[name="user_address_2"]').val());
        data.append('user_address_3', $('[name="user_address_3"]').val());
        // data.append('user_address', $('[name="user_address"]').val());
        data.append('contract_years', $('[name="contract_years"]').val());
        data.append('user_address', $('#autocomplete').val());
        data.append('user_latitude', $('#lat').val());
        data.append('user_longitude', $('#lng').val());

        data.append('user_limit_amount_for_sale', convertStringToNumber($('[name="user_limit_amount_for_sale"]').val()));

        data.append('user_price_list_main_type', $('[name="user_price_list_main_type"]').val());
        // data.append('user_price_list_main_type_child', JSON.stringify(getCheckedService($('[name="user_price_list_main_type"]:checked').val())));

        const result = await sendRequest(`${window.location.origin}/manages/admin/system/fwd-users/create/handle`, 'POST', data, true);

        if (result.status == 200) {
            onLoadPageFWDUsers();
        }
        showMessage(result.message);
        $('#create_new_fwd_user').attr('disabled', false);

        $.each(form_validate, function (key, value) {
            $(`#error_${value}`).html('');
        });
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        } else {
            $.each(form_validate, function (key, value) {
                if (error.responseJSON.errors[value]) {
                    $(`#error_${value}`).html(error.responseJSON.errors[value][0]);
                } else {
                    $(`#error_${value}`).html('');
                }
            });
        }
        $('#create_new_fwd_user').attr('disabled', false);
    }
}

async function onEditFWDUser(id) {
    startLoadingOffcanvasRightMangeAdminSystemBody();
    try {
        let data = {
            is_api: false,
            user_id: id
        };
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/fwd-users/edit/display`, 'POST', data);
        if (result.status == 200) {
            $('#offcanvasRightMangeAdminSystemBody').html(result.html);
            await initAutocomplete(); // load gg map
            if (checkLocation(result.data.user_latitude, result.data.user_longitude)) {
                updateMapWithLatLng(result.data.user_latitude, result.data.user_longitude);
            }

        }
        closeLoadingOffcanvasRightMangeAdminSystemBody();
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
        closeLoadingOffcanvasRightMangeAdminSystemBody();
    }
}

async function onSaveEditFWDUser(id) {
    let form_validate = [
        'user_logo',
        'user_name',
        'password',
        'user_contact_name',
        'user_accountant_key',
        'user_company_name',
        'user_tax_code',
        'user_phone',
        'branch_id',
        'user_address_1',
        'user_address_2',
        'user_address_3',
        'user_address',
        'user_price_list_main_type',
        'user_limit_amount_for_sale'
    ];
    try {
        $('#on_save_edit_fwd_user').on('click', function (event) {
            event.preventDefault();
        });
        $('#on_save_edit_fwd_user').attr('disabled', true);
        let data = new FormData();
        data.append('is_api', false);
        // $.each($('.select_child_price_list'), function (key, value) {
        //     let select_name = $(value).attr('name');
        //     data.append(`${select_name}`, $(`[name="${select_name}"]`).val());
        //     form_validate.push(select_name);
        // });
        data.append('user_id', id);
        data.append('user_logo', $('[name="user_logo"]')[0]['files'][0]);
        data.append('user_name', $('[name="user_name"]').val());
        data.append('password', $('[name="password"]').val());
        data.append('user_contact_name', $('[name="user_contact_name"]').val());
        data.append('user_accountant_key', $('[name="user_accountant_key"]').val());
        data.append('user_debit_type', $('[name="user_debit_type"]').val());
        data.append('user_company_name', $('[name="user_company_name"]').val());
        data.append('user_tax_code', $('[name="user_tax_code"]').val());
        data.append('user_phone', $('[name="user_phone"]').val());
        data.append('branch_id', $('[name="branch_id"]').val());
        data.append('user_address_1', $('[name="user_address_1"]').val());
        data.append('user_address_2', $('[name="user_address_2"]').val());
        data.append('user_address_3', $('[name="user_address_3"]').val());
        // data.append('user_address', $('[name="user_address"]').val());
        data.append('contract_years', $('[name="contract_years"]').val());
        data.append('user_address', $('#autocomplete').val());
        data.append('user_latitude', $('#lat').val());
        data.append('user_longitude', $('#lng').val());

        data.append('user_limit_amount_for_sale', convertStringToNumber($('[name="user_limit_amount_for_sale"]').val()));



        data.append('user_price_list_main_type', $('[name="user_price_list_main_type"]').val() ?? null);
        // data.append('user_price_list_main_type_child', JSON.stringify(getCheckedService($('[name="user_price_list_main_type"]:checked').val())));
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/fwd-users/edit/handle`, 'POST', data, true);

        if (result.status == 200) {
            onLoadPageFWDUsers();
        }
        showMessage(result.message);
        $('#on_save_edit_fwd_user').attr('disabled', false);

        $.each(form_validate, function (key, value) {
            $(`#error_${value}`).html('');
        });
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        } else {
            $.each(form_validate, function (key, value) {
                if (error.responseJSON.errors[value]) {
                    $(`#error_${value}`).html(error.responseJSON.errors[value][0]);
                } else {
                    $(`#error_${value}`).html('');
                }
            });
        }
        $('#on_save_edit_fwd_user').attr('disabled', false);
    }
}

async function onLockFWDUser(id, active) {
    let text = active == 1 ? 'khóa' : 'mở khóa';
    let event = {
        title: 'Xác nhận hành vi!',
        text: `Bạn có chắc muốn ${text} tài khoản này!`,
        icon: 'question',
        type: 'agreeLockFWDUser',
        data: {
            is_api: false,
            user_id: id,
            active_flg: active,
        }
    };
    confirmEvent(event);
}

async function agreeLockFWDUser(data) {
    try {
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/fwd-users/lock`, 'POST', data);
        if (result.status == 200) {
            onPagination(`${show_page_url}/pagination`);
        }
        showMessage(result.message);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}
//Danh sách Account FWD

//Cài đặt Bảng Giá
var form_price_list = {};

$('body').on('change', '[name="price_list_active_flg"]', function () {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    page = 1;
    filters.active_flg = $('[name="price_list_active_flg"]').val();
    onPagination(`${show_page_url}/pagination`);
});

$('body').on('change', '[name="price_list_keywords"]', function () {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    page = 1;
    filters.keywords = $('[name="price_list_keywords"]').val();
    onPagination(`${show_page_url}/pagination`);
});

$('body').on('change', '[name="date_range_flg"]', function () {
    if ($('[name="date_range_flg"]').val() == 1) {
        $('#form_price_list').append(`
            <div id="form_price_list_date_range" class="col-sm-12">
                <div class="form-group">
                    <label class="form-label">Thời gian sử dụng *</label>
                    <input type="text" name="price_list_date_range" class="form-control">
                    <small id="error_price_list_date_range" class="text-danger"></small>
                </div>
            </div>
        `);

        $('input[name="price_list_date_range"]').daterangepicker({
            opens: 'left',
            startDate: moment().subtract(3, 'months').startOf('month'),
            endDate: moment().endOf('month'),
            locale: {
                format: 'DD/MM/YYYY',
                applyLabel: "Áp dụng",
                cancelLabel: "Hủy",
                customRangeLabel: "Tùy chỉnh",
                daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
                monthNames: [
                    "Tháng 1",
                    "Tháng 2",
                    "Tháng 3",
                    "Tháng 4",
                    "Tháng 5",
                    "Tháng 6",
                    "Tháng 7",
                    "Tháng 8",
                    "Tháng 9",
                    "Tháng 10",
                    "Tháng 11",
                    "Tháng 12",
                ],
            }
        }, function (start, end, label) {

        });
    } else {
        $('#form_price_list #form_price_list_date_range').remove();
    }
});

$('body').on('change', '[name="price_list_tranport_type"]', function () {
    if (Object.keys(form_price_list).length > 0) {
        Swal.fire({
            icon: 'question',
            title: 'Xác nhận hành vi!',
            text: `Khi bạn thay đổi loại bảng giá thì sẽ xóa các bảng giá bạn đã tạo trước đó!`,
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            confirmButtonText: 'Xác Nhận',
            cancelButtonColor: '#d33',
            cancelButtonText: 'Hủy',
        }).then((result) => {
            if (result.isConfirmed) {
                form_price_list = {};
                $('#accordionFormPriceList').html('');
                $('[name="price_list_tranport_type"]').trigger('change');
            }
            if (!result.isConfirmed) {
                if ($('[name="price_list_tranport_type"]').val() == 0) {
                    $('[name="price_list_tranport_type"]').val(1);
                } else if ($('[name="price_list_tranport_type"]').val() == 1) {
                    $('[name="price_list_tranport_type"]').val(0);
                }
            }
        });
        return;
    }
    if ($('[name="price_list_tranport_type"]').val() == 0) {
        $('#form_create_display_child_price_list').html(`
            <button type="button" class="btn btn-primary" onclick="onCreateDisplayChildPriceList()">
                <span class="fs-4">+</span>
            </button>    
        `);
    } else if ($('[name="price_list_tranport_type"]').val() == 1) {
        $('#form_create_display_child_price_list').html('');
        for (let index = 0; index < 2; index++) {
            onCreateDisplayChildPriceList(index);
        }
    }
});

function onLoadPagePriceListSetting() {
    startLoadingOffcanvasRightMangeAdminSystemBody();
    onShowPageManageAdminSystem();
    refreshIds();
}

async function onLoadPageCreatePriceList() {
    startLoadingOffcanvasRightMangeAdminSystemBody();
    try {
        let data = {
            is_api: false,
        }
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/price-list/settings/create/display`, 'POST', data);
        if (result.status == 200) {
            $('#offcanvasRightMangeAdminSystemBody').html(result.html);
            form_price_list = {};
            key_form_price_list = null;
        }
        closeLoadingOffcanvasRightMangeAdminSystemBody();
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
        closeLoadingOffcanvasRightMangeAdminSystemBody();
    }
}

function onCreateDisplayChildPriceList(child_price_list_kind = 2) {
    let child_price_list = {
        child_price_list_title: '',
        branch_id: branchs[0]['branch_id'],
        position_id: positions[0]['position_id'],
        user_type: 1,
        child_price_list_kind: child_price_list_kind,
        price_list_id: null,
        item_child_price_list: {},
    };
    let last_key = Object.keys(form_price_list).length;
    form_price_list[last_key] = child_price_list;

    $('#accordionFormPriceList').append(`
        <div class="accordion-item">
            <h2 class="accordion-header" id="accordionFormPriceList_heading_${last_key}">
                <button class="accordion-button" type="button" data-bs-toggle="collapse"
                    data-bs-target="#accordionFormPriceList_collapse_${last_key}" aria-expanded="true"
                    aria-controls="accordionFormPriceList_collapse_${last_key}">
                    <div class="d-flex align-items-center">
                        <i class="acon-icon ri-file-list-3-line"></i> 
                        <span id="header_form_price_list_${last_key}_child_price_list_title" class="ms-3">
                            Chưa có tiêu đề
                        </span>
                    </div>
                </button>
            </h2>
            <div id="accordionFormPriceList_collapse_${last_key}" class="accordion-collapse collapse show"
                aria-labelledby="accordionFormPriceList_heading_${last_key}">
                <div class="accordion-body">
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label class="form-label">Tiêu đề *</label>
                                <input name="form_price_list.${last_key}.child_price_list_title" class="form-control" 
                                    type="text" placeholder="Nhập tiêu đề" 
                                    onkeyup="onChangeChildPriceListTitle(${last_key})">
                                <small id="error_form_price_list.${last_key}.child_price_list_title" class="text-danger"></small>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label class="form-label">Chi nhánh</label>
                                <select class="form-select" name="form_price_list.${last_key}.branch_id">
                                    ${branchs.map((branch, key_branch) => {
        return `<option value="${branch['branch_id']}">${branch['branch_name']}</option>`
    }).join('')}
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group">
                                <label class="form-label">Loại tài khoản</label>
                                <select class="form-select" name="form_price_list.${last_key}.position_id">
                                    ${positions.map((position, key_position) => {
        return `<option value="${position['position_id']}">${position['position_name']}</option>`
    }).join('')}
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group">
                                <label class="form-label">Dành cho</label>
                                <select class="form-select" name="form_price_list.${last_key}.user_type">
                                    ${child_price_list_types.map((child_price_list_type, key_child_price_list_type) => {
        return `<option value="${key_child_price_list_type}">${child_price_list_type}</option>`
    }).join('')}
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group">
                                <label class="form-label">Loại</label>
                                <select class="form-select" onchange="onChangeChildPriceListKind(${last_key})" 
                                    name="form_price_list.${last_key}.child_price_list_kind" disabled>
                                    ${child_price_list_kinds.map((item, index) => {
        return `<option ${index == child_price_list_kind ? 'selected' : ''} value="${index}">${item}</option>`
    }).join('')}
                                </select>
                            </div>
                        </div>
                    </div>
                    <div id="form_price_list_${last_key}_items_child_price_list" class="row"></div>
                    <div class="text-end mt-3 mb-2">
                        ${$('[name="price_list_tranport_type"]').val() != 1 ? `
                            <button type="button" class="btn btn-success"
                                onclick="onImportChildPriceList(${last_key})">
                                <i class="acon-icon ri-file-add-line"></i>
                                <label class="text-white">Import excel</label>
                            </button>
                        ` : ''}
                        <button type="button" class="btn btn-primary"
                            id="on_create_display_item_child_price_list_${last_key}"
                            onclick="onCreateDisplayItemChildPriceList(${last_key})">
                            <i class="acon-icon ri-file-add-line"></i>
                            <label class="text-white">Thêm bảng giá</label>
                        </button>
                        ${$('[name="price_list_tranport_type"]').val() == 1 ? '' : `<button type="button" class="btn btn-danger" onclick="onDeleteDisplayChildPriceList(${last_key})">
                            <i class="acon-icon ri-delete-bin-fill"></i> 
                        </button>`}
                    </div>
                </div>
            </div>
        </div>
    `);
}

function setDisplayFormChildPriceList() {
    $('#accordionFormPriceList').html('');
    $.each(form_price_list, function (key, item) {
        form_price_list[key]['item_child_price_list'] = form_price_list[key]['item_child_price_list'] ? form_price_list[key]['item_child_price_list'] : {};
        $('#accordionFormPriceList').append(`
            <div class="accordion-item">
                <h2 class="accordion-header" id="accordionFormPriceList_heading_${key}">
                    <button class="accordion-button" type="button" data-bs-toggle="collapse"
                        data-bs-target="#accordionFormPriceList_collapse_${key}" aria-expanded="true"
                        aria-controls="accordionFormPriceList_collapse_${key}">
                        <div class="d-flex align-items-center">
                            <i class="acon-icon ri-file-list-3-line"></i> 
                            <span id="header_form_price_list_${key}_child_price_list_title" class="ms-3">
                                ${item.child_price_list_title}
                            </span>
                        </div>
                    </button>
                </h2>
                <div id="accordionFormPriceList_collapse_${key}" class="accordion-collapse collapse show"
                    aria-labelledby="accordionFormPriceList_heading_${key}">
                    <div class="accordion-body">
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label class="form-label">Tiêu đề *</label>
                                    <input name="form_price_list.${key}.child_price_list_title" class="form-control" 
                                        type="text" placeholder="Nhập tiêu đề"
                                        value="${item.child_price_list_title}"
                                        onkeyup="onChangeChildPriceListTitle(${key})">
                                    <small id="error_form_price_list.${key}.child_price_list_title" class="text-danger"></small>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label class="form-label">Chi nhánh</label>
                                    <select class="form-select" name="form_price_list.${key}.branch_id">
                                        ${branchs.map((branch, key_branch) => {
            return `<option ${branch['branch_id'] == item.branch_id ? 'selected' : ''} value="${branch['branch_id']}">${branch['branch_name']}</option>`
        }).join('')}
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label class="form-label">Loại tài khoản</label>
                                    <select class="form-select" name="form_price_list.${key}.position_id">
                                        ${positions.map((position, key_position) => {
            return `<option ${position['position_id'] == item.position_id ? 'selected' : ''} value="${position['position_id']}">${position['position_name']}</option>`
        }).join('')}
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label class="form-label">Dành cho</label>
                                    <select class="form-select" name="form_price_list.${key}.user_type">
                                        ${child_price_list_types.map((child_price_list_type, key_child_price_list_type) => {
            return `<option ${key_child_price_list_type == item.user_type ? 'selected' : ''} value="${key_child_price_list_type}">${child_price_list_type}</option>`
        }).join('')}
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label class="form-label">Loại</label>
                                    <select class="form-select" onchange="onChangeChildPriceListKind(${key})" 
                                        name="form_price_list.${key}.child_price_list_kind" disabled>
                                        ${child_price_list_kinds.map((child_price_list_kind, key_child_price_list_kind) => {
            return `<option ${key_child_price_list_kind == item.child_price_list_kind ? 'selected' : ''} value="${key_child_price_list_kind}">${child_price_list_kind}</option>`
        }).join('')}
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div id="form_price_list_${key}_items_child_price_list" class="row"></div>
                        <div class="text-end mt-3 mb-2">
                            ${$('[name="price_list_tranport_type"]').val() != 1 ? `
                                <button type="button" class="btn btn-success"
                                    onclick="onImportChildPriceList(${key})">
                                    <i class="acon-icon ri-file-add-line"></i>
                                    <label class="text-white">Import excel</label>
                                </button>
                            ` : ''}
                            <button type="button" class="btn btn-primary"
                                id="on_create_display_item_child_price_list_${key}"
                                onclick="onCreateDisplayItemChildPriceList(${key})">
                                <i class="acon-icon ri-file-add-line"></i>
                                <label class="text-white">Thêm bảng giá</label>
                            </button>
                            ${$('[name="price_list_tranport_type"]').val() == 1 ? '' : `<button type="button" class="btn btn-danger" onclick="onDeleteDisplayChildPriceList(${key})">
                                <i class="acon-icon ri-delete-bin-fill"></i> 
                            </button>`}
                        </div>
                    </div>
                </div>
            </div>
        `);
    });
}

function onImportChildPriceList(key) {
    $('#save_modal_import_excel_price_list').data('keypricelist', key);
    $('#choose_file_excel_price_list').val('');
    $('#modal_import_excel_price_list').modal('show');
}

$(document).on('click', '#close_modal_import_excel_price_list', async function () {
    $('#save_modal_import_excel_price_list').data('keypricelist', null);
    $('#modal_import_excel_price_list').modal('hide');
});

$(document).on('click', '#close_modal_import_excel_price_list', async function () {
    $('#save_modal_import_excel_price_list').data('keypricelist', null);
    $('#modal_import_excel_price_list').modal('hide');
});

$(document).on('click', '#save_modal_import_excel_price_list', async function () {
    $('#close_modal_import_excel_price_list').attr('disabled', true);
    $('#save_modal_import_excel_price_list').attr('disabled', true);
    try {
        const key = $('#save_modal_import_excel_price_list').data('keypricelist');
        if (key != null) {
            const files = $('#choose_file_excel_price_list')[0].files;
            let messages = [];

            for (let index = 0; index < files.length; index++) {
                const file = files[index];

                const reader = new FileReader();

                const data = await new Promise((resolve, reject) => {
                    reader.onload = function (e) {
                        const data = new Uint8Array(e.target.result);
                        resolve(data);
                    };

                    reader.onerror = function (error) {
                        reject(error);
                    };

                    reader.readAsArrayBuffer(file);
                });

                const workbook = XLSX.read(data, { type: 'array' });
                const sheetName = workbook.SheetNames[0];
                const worksheet = workbook.Sheets[sheetName];
                const jsonData = XLSX.utils.sheet_to_json(worksheet, { header: 1 });

                const form_data = {
                    'data': jsonData,
                    'item_price_list_type': $('[name="item_price_list_type"]:checked').val(),
                };

                const result = await sendRequest(`${window.location.origin}/manages/admin/system/price-list/settings/edit/item-child-price-list/excel`, 'POST', form_data);

                if (result.status == 200) {
                    if (result.results.length > 0) {
                        form_price_list[key]['item_child_price_list'] = Object.values(form_price_list[key]['item_child_price_list']);
                        const mergedArray = [...form_price_list[key]['item_child_price_list'], ...result.results];

                        const uniqueArray = Array.from(
                            mergedArray.reduce((map, item) => {
                                if (map.has(item.service_id)) {
                                    const existingItem = map.get(item.service_id);
                                    map.set(item.service_id, {
                                        ...existingItem,
                                        ...item,
                                        weight_range: item.weight_range
                                    });
                                } else {
                                    map.set(item.service_id, item);
                                }
                                return map;
                            }, new Map()).values()
                        );

                        form_price_list[key]['item_child_price_list'] = uniqueArray;

                        key_form_price_list = key;
                        setDisplayCardItemChildPriceListWithService();
                        key_form_price_list = null;

                        messages.push({
                            'title': 'Thành công!',
                            'text': `Import dữ liệu từ file excel ${file.name} thành công.`,
                            'icon': 'success',
                        });
                    } else {
                        messages.push({
                            'title': 'Có gì đó không đúng!',
                            'text': `Không tìm thấy bảng giá nào thích hợp để import từ file excel ${file.name}.`,
                            'icon': 'warning',
                        });
                    }
                }
            }

            showMessageTopRight(messages);
            $('#modal_import_excel_price_list').modal('hide');
            $('#save_modal_import_excel_price_list').data('keypricelist', null);
        }
        $('#close_modal_import_excel_price_list').attr('disabled', false);
        $('#save_modal_import_excel_price_list').attr('disabled', false);
    } catch (error) {
        showMessage(error.message);
        $('#close_modal_import_excel_price_list').attr('disabled', false);
        $('#save_modal_import_excel_price_list').attr('disabled', false);
    }
});

function onChangeChildPriceListTitle(key) {
    $(`#header_form_price_list_${key}_child_price_list_title`).html(
        $(`[name="form_price_list.${key}.child_price_list_title"]`).val()
    );
    form_price_list[key]['child_price_list_title'] = $(`[name="form_price_list.${key}.child_price_list_title"]`).val();
}

function onDeleteDisplayChildPriceList(key) {
    if (form_price_list.hasOwnProperty(key)) {
        let element = $(`#accordionFormPriceList_heading_${key}`).parent();
        element.addClass('fade-out');
        setTimeout(() => {
            delete form_price_list[key];
            element.remove();
        }, 500);
    } else {
        console.log("Không tìm thấy phần tử có key '" + key + "' trong object.");
    }
}

async function onCreateDisplayItemChildPriceList(key) {
    $(`#on_create_display_item_child_price_list_${key}`).attr('disabled', true);
    try {
        let data = {
            is_api: false,
            price_list_tranport_type: $('[name="price_list_tranport_type"]').val(),
            country_ids: Object.values(form_price_list[key]['item_child_price_list']).map(item => item.country_id),
            service_ids: Object.values(form_price_list[key]['item_child_price_list']).map(item => item.service_id),
        }
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/price-list/settings/create/item-child-price-list/display`, 'POST', data);
        if (result.status == 200) {
            $('#modalBodyItemChildPriceList').html(result.html);
            $('#exampleModalItemChildPriceList').modal('show');
            $('.modal-backdrop').remove();
            onStartFormCreateItemChildPriceList(key);
        } else {
            showMessage(result.message);
        }
        $(`#on_create_display_item_child_price_list_${key}`).attr('disabled', false);
    } catch (error) {
        showMessage(error.message);
        $(`#on_create_display_item_child_price_list_${key}`).attr('disabled', false);
    }
}

let key_item_child_price_list = null;
let key_form_price_list = null;
function onStartFormCreateItemChildPriceList(key) {
    key_form_price_list = key;
    key_item_child_price_list = null;
}

$('body').on('click', '#saveExampleModalItemChildPriceList', async function () {
    $('#closeExampleModalItemChildPriceList').attr('disabled', true);
    $('#saveExampleModalItemChildPriceList').attr('disabled', true);
    form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['is_editing'] = true;
    if ($('[name="price_list_tranport_type"]').val() == 1) {
        setDisplayCardItemChildPriceListWithAreas();
    }
    if ($('[name="price_list_tranport_type"]').val() == 0) {
        if ($('#item_child_price_list_service_id').val()) {
            setDisplayCardItemChildPriceListWithService();
        } else {
            alert('Chưa chọn dịch vụ!');
        }
    }
    key_item_child_price_list = null;
    key_form_price_list = null;

    $('#closeExampleModalItemChildPriceList').attr('disabled', false);
    $('#saveExampleModalItemChildPriceList').attr('disabled', false);
});

$('body').on('click', '#closeExampleModalItemChildPriceList', async function () {
    $('#closeExampleModalItemChildPriceList').attr('disabled', true);
    $('#saveExampleModalItemChildPriceList').attr('disabled', true);
    if (key_item_child_price_list != null && !form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['is_editing']) {
        await onDeleteChildPriceList(key_form_price_list, key_item_child_price_list);
    } else {
        if (form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list] && item_child_price_list_tmp != null) {
            form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list] = JSON.parse(item_child_price_list_tmp);
        }
    }
    key_form_price_list = null;
    key_item_child_price_list = null;
    item_child_price_list_tmp = null;

    $('#closeExampleModalItemChildPriceList').attr('disabled', false);
    $('#saveExampleModalItemChildPriceList').attr('disabled', false);
});

$('body').on('change', '#item_child_price_list_country_id', async function () {
    $('#closeExampleModalItemChildPriceList').attr('disabled', true);
    $('#saveExampleModalItemChildPriceList').attr('disabled', true);
    if ($('#item_child_price_list_country_id').val()) {
        try {
            let cities = await getJsonCitiesByCountry($('#item_child_price_list_country_id').val());
            if (Object.keys(cities).length > 0) {
                if (key_item_child_price_list == null) {
                    key_item_child_price_list = Object.keys(form_price_list[key_form_price_list]['item_child_price_list']).length;
                }
                const weight_range = {
                    cities,
                    child_price_list_from_weight: 0,
                    child_price_list_to_weight: 0,
                    weight_range_flg: 1,
                };
                form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list] = {
                    title: '',
                    weight_range: {
                        0: weight_range,
                    },
                    country_id: $('#item_child_price_list_country_id').val(),
                    is_editing: form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list] ? form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list] : false,
                    is_not_empty_cities: cities.length > 0,
                };
                form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list].title = $('#item_child_price_list_country_id option:selected').text();

                $('#form_excel_price_list').html(`
                    <div class="col-auto mb-3">
                        <button type="button" class="btn btn-primary mb-0" onclick="exportToExcel()">
                            <span>Xuất mẫu excel</span>
                        </button>
                    </div>
                    <div class="col-auto mb-3">
                        <div class="input-group">
                            <input type="file" class="form-control" id="input_import_excel_price_list"
                                aria-describedby="input_import_excel_price_list_addon" aria-label="Import file excel"
                                accept="application/vnd.ms-excel, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet">
                            <button class="btn btn-outline-primary mb-0" type="button" id="input_import_excel_price_list_addon">
                                <span>Import file excel</span>
                            </button>
                        </div>
                    </div>
                `);
                setDisplayFormItemChildPriceListWithAreas();
            } else {
                $('#form_excel_price_list').html('');
                $('#content_item_child_price_list').addClass('mb300');
                $('#content_item_child_price_list').html(`
                    <div class="alert alert-danger" role="alert">
                        Không có thành phố!
                    </div>
                `);
            }
        } catch (error) {

        }
    } else {
        $('#form_excel_price_list').html('');
        $('#content_item_child_price_list').addClass('mb300');
        $('#content_item_child_price_list').html(`
            <div class="alert alert-danger" role="alert">
                Không có thành phố!
            </div>
        `);
    }
    $('#closeExampleModalItemChildPriceList').attr('disabled', false);
    $('#saveExampleModalItemChildPriceList').attr('disabled', false);
});

$(document).on('change', '#item_child_price_list_service_id', async function () {
    $('#closeExampleModalItemChildPriceList').attr('disabled', true);
    $('#saveExampleModalItemChildPriceList').attr('disabled', true);
    if ($('#item_child_price_list_service_id').val()) {
        try {
            if (key_item_child_price_list == null) {
                key_item_child_price_list = Object.keys(form_price_list[key_form_price_list]['item_child_price_list']).length;
            }
            form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list] = {
                title: '',
                sub_child_price_list_type: $('[name="sub_child_price_list_type"]').val(),
                weight_range: {},
            };
            form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][0] = {
                title: '',
                sub_child_price_list_area: {},
                data: {
                    0: {
                        child_price_list_from_weight: 0,
                        child_price_list_to_weight: 0,
                        item_child_price_list_amount: 0,
                        weight_range_flg: 1,
                    }
                }
            };
            if ($('[name="sub_child_price_list_type"]').val() == 4) {
                form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][1] = {
                    title: '',
                    sub_child_price_list_area: {},
                    data: {
                        0: {
                            child_price_list_from_weight: 0,
                            child_price_list_to_weight: 0,
                            item_child_price_list_amount: 0,
                            weight_range_flg: 1,
                        }
                    }
                };
            }
            form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['service_id'] = $('#item_child_price_list_service_id').val();
            form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['is_editing'] = form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['is_editing'] ? form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['is_editing'] : false;
            form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['title'] = $('#item_child_price_list_service_id option:selected').text().trim();

            $('#form_excel_price_list').html(`
                <div class="col-auto mb-3">
                    <button type="button" class="btn btn-primary mb-0" onclick="exportToExcel()">
                        <span>Xuất mẫu excel</span>
                    </button>
                </div>
                <div class="col-auto mb-3">
                    <div class="input-group">
                        <input type="file" class="form-control" id="input_import_excel_price_list"
                            aria-describedby="input_import_excel_price_list_addon" aria-label="Import file excel"
                            accept="application/vnd.ms-excel, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet">
                        <button class="btn btn-outline-primary mb-0" type="button" id="input_import_excel_price_list_addon">
                            <span>Import file excel</span>
                        </button>
                    </div>
                </div>
            `);

            setDisplayFormItemChildPriceListWithService();
        } catch (error) {

        }
    } else {
        $('#form_excel_price_list').html('');
        $('#content_item_child_price_list').addClass('mb300');
        $('#content_item_child_price_list').html(`
            <div class="alert alert-danger" role="alert">
                Chưa chọn dịch vụ!
            </div>
        `);
    }
    $('#closeExampleModalItemChildPriceList').attr('disabled', false);
    $('#saveExampleModalItemChildPriceList').attr('disabled', false);
});

$(document).on('change', '[name="sub_child_price_list_type"]', async function () {
    $('#closeExampleModalItemChildPriceList').attr('disabled', true);
    $('#saveExampleModalItemChildPriceList').attr('disabled', true);
    if ($('[name="sub_child_price_list_type"]').val() && $('#item_child_price_list_service_id').val()) {
        if (key_item_child_price_list != null) {
            form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list] = {
                title: '',
                sub_child_price_list_type: $('[name="sub_child_price_list_type"]').val(),
                weight_range: {},
            };
            form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][0] = {
                title: '',
                sub_child_price_list_area: {},
                data: {
                    0: {
                        child_price_list_from_weight: 0,
                        child_price_list_to_weight: 0,
                        item_child_price_list_amount: 0,
                        weight_range_flg: 1,
                    }
                }
            };
            if ($('[name="sub_child_price_list_type"]').val() == 4) {
                form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][1] = {
                    title: '',
                    sub_child_price_list_area: {},
                    data: {
                        0: {
                            child_price_list_from_weight: 0,
                            child_price_list_to_weight: 0,
                            item_child_price_list_amount: 0,
                            weight_range_flg: 1,
                        }
                    }
                };
            }
            form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['service_id'] = $('#item_child_price_list_service_id').val();
            form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['is_editing'] = form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['is_editing'] ? form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['is_editing'] : false;
            form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['title'] = $('#item_child_price_list_service_id option:selected').text().trim();

            $('#form_excel_price_list').html(`
                <div class="col-auto mb-3">
                    <button type="button" class="btn btn-primary mb-0" onclick="exportToExcel()">
                        <span>Xuất mẫu excel</span>
                    </button>
                </div>
                <div class="col-auto mb-3">
                    <div class="input-group">
                        <input type="file" class="form-control" id="input_import_excel_price_list"
                            aria-describedby="input_import_excel_price_list_addon" aria-label="Import file excel"
                            accept="application/vnd.ms-excel, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet">
                        <button class="btn btn-outline-primary mb-0" type="button" id="input_import_excel_price_list_addon">
                            <span>Import file excel</span>
                        </button>
                    </div>
                </div>
            `);

            setDisplayFormItemChildPriceListWithService();
        }

    } else {

    }
    $('#closeExampleModalItemChildPriceList').attr('disabled', false);
    $('#saveExampleModalItemChildPriceList').attr('disabled', false);
});

$('body').on('click', '#btn_add_column_item_child_price_list', async function () {
    let key_item_price_list_weight_range = Object.keys(form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range']).length;
    if ($('[name="price_list_tranport_type"]').val() == 1) {
        let cities = JSON.stringify(form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list].weight_range[0]['cities']);
        form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list].weight_range[key_item_price_list_weight_range] = {
            cities: JSON.parse(cities),
            child_price_list_from_weight: 0,
            child_price_list_to_weight: 0,
            weight_range_flg: 1,
        };
        $.each(form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list].weight_range[key_item_price_list_weight_range]['cities'], function (key, item) {
            form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list].weight_range[key_item_price_list_weight_range]['cities'][key] = {
                item_child_price_list_amount: 0,
                city_id: item.city_id,
                weight_range_flg: item.weight_range_flg,
            };
        });
        await setDisplayFormItemChildPriceListWithAreas();
    }
    if ($('[name="price_list_tranport_type"]').val() == 0) {
        form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][key_item_price_list_weight_range] = {
            title: '',
            data: {},
            sub_child_price_list_area: {},
        };
        $.each(form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][0]['data'], function (key_data, item) {
            form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list].weight_range[key_item_price_list_weight_range]['data'][key_data] = {
                child_price_list_from_weight: item.child_price_list_from_weight,
                child_price_list_to_weight: item.child_price_list_to_weight,
                item_child_price_list_amount: 0,
                weight_range_flg: item.weight_range_flg
            };
        });
        await setDisplayFormItemChildPriceListWithService();
    }
    $('.table-responsive').animate({ scrollLeft: $('.table-responsive')[0].scrollWidth }, 0);
});

$('body').on('change', '[name^="form_price_list"]', async function () {
    let value = $(this).val();
    let input_name = $(this).attr('name');
    var parts = input_name.split('.');
    var last_part = parts[parts.length - 1];
    if (last_part == 'title' || last_part == 'child_price_list_title') {

    } else {
        value = `${convertStringToNumber(value)}`;
        $(`[name="${input_name}"]`).val(formatNumber(value));
    }

    input_name = input_name.replace('form_price_list.', '');
    form_price_list = setData(form_price_list, input_name, value);

    if (parts[8] !== undefined && (parts[8] == "child_price_list_to_weight" || parts[8] == "child_price_list_from_weight" || parts[8] == "weight_range_flg")) {
        let child_price_list_kind = await getData(form_price_list, `${parts[1]}.child_price_list_kind`);
        if (parts, child_price_list_kind == 2) {
            let get_data_weight_range = await getData(form_price_list, `${parts[1]}.item_child_price_list.${parts[3]}.weight_range`);
            $.each(get_data_weight_range, function (key_i, i) {
                if (key_i > 0) {
                    $.each(i.data, function (key_j, j) {
                        form_price_list[parts[1]]['item_child_price_list'][parts[3]]['weight_range'][key_i]['data'][key_j]['child_price_list_from_weight'] = get_data_weight_range[0]['data'][key_j]['child_price_list_from_weight'];
                        form_price_list[parts[1]]['item_child_price_list'][parts[3]]['weight_range'][key_i]['data'][key_j]['child_price_list_to_weight'] = get_data_weight_range[0]['data'][key_j]['child_price_list_to_weight'];
                        form_price_list[parts[1]]['item_child_price_list'][parts[3]]['weight_range'][key_i]['data'][key_j]['weight_range_flg'] = get_data_weight_range[0]['data'][key_j]['weight_range_flg'];
                    });
                }
            });
            if (parts[8] == "weight_range_flg") {
                setDisplayFormItemChildPriceListWithService(parts[1], parts[3]);
            }
        }
    }
});

function deleteColumnItemChildPriceList(key_item_price_list_weight_range) {
    if (form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list].weight_range.hasOwnProperty(key_item_price_list_weight_range)) {
        if (Object.keys(form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list].weight_range).length > 1) {
            delete form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list].weight_range[key_item_price_list_weight_range];
            form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'] = Object.values(form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range']);
            if ($('[name="price_list_tranport_type"]').val() == 1) {
                setDisplayFormItemChildPriceListWithAreas();
            }
            if ($('[name="price_list_tranport_type"]').val() == 0) {
                setDisplayFormItemChildPriceListWithService();
            }
        } else {
            return alert("Phải có ít nhất là 1 cột dữ liệu");
        }
    } else {
        console.log("Không tìm thấy phần tử có key '" + key_item_price_list_weight_range + "' trong object.");
    }
}

async function onDeleteChildPriceList(key_price_list, key_child_price_list) {
    $(`#form_price_list_${key_price_list}_items_child_price_list_${key_child_price_list}`).remove();
    delete form_price_list[key_price_list]['item_child_price_list'][key_child_price_list];
}

function setDisplayFormItemChildPriceListWithAreas() {
    form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'] = Object.values(form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range']);
    let data = form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list];
    $('#content_item_child_price_list').removeClass('mb300');
    $('#content_item_child_price_list').html(`
        <div class="table-responsive" style="max-height:450px; overflow: auto;">
            <table class="table table-borderless">
                <thead>
                    <tr>
                        <th scope="col">Địa chỉ</th>
                        <th id="form_add_column_item_child_price_list" class="border-0" scope="col">
                            <button id="btn_add_column_item_child_price_list" type="button" class="btn btn-info">
                                <i class="fa fa-plus"></i>
                            </button>
                        </th>
                    </tr>
                </thead>
                <tbody id="tbody_item_child_price_list_state"></tbody>
            </table>
        </div>
    `);

    let check_isset_key_i = null;
    $.each(data.weight_range, function (key_i, i) {
        $(`
            <th id="th_form_price_list_${key_form_price_list}_item_child_price_list_${key_item_child_price_list}_weight_range_${key_i}" scope="col">
                <div>
                    <button type="button" class="btn btn-danger w-100 mb-1"
                        onclick="deleteColumnItemChildPriceList(${key_i})">
                        <i class="fa fa-trash"></i>
                    </button>
                </div>
                <div class="d-flex flex-row align-items-center">
                    <input class="form-control" type="text" 
                        name="form_price_list.${key_form_price_list}.item_child_price_list.${key_item_child_price_list}.weight_range.${key_i}.child_price_list_from_weight"
                        value="${i.child_price_list_from_weight}">
                    <div class="ms-1">-</div>
                    <input class="form-control ms-1" type="text"
                        name="form_price_list.${key_form_price_list}.item_child_price_list.${key_item_child_price_list}.weight_range.${key_i}.child_price_list_to_weight"
                        value="${i.child_price_list_to_weight}">
                </div>
            </th>
        `).insertBefore('#form_add_column_item_child_price_list');

        $.each(i['cities'], function (key_j, j) {
            form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list].weight_range[key_i]['cities'][key_j]['item_child_price_list_amount'] = form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list].weight_range[key_i]['cities'][key_j]['item_child_price_list_amount'] ? form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list].weight_range[key_i]['cities'][key_j]['item_child_price_list_amount'] : 0;
            if (check_isset_key_i === null || check_isset_key_i == key_i) {
                check_isset_key_i = key_i;
                $(`#tbody_item_child_price_list_state`).append(`
                    <tr id="tr_form_price_list_${key_form_price_list}_item_child_price_list_${key_item_child_price_list}_weight_range_${key_i}_cities_${key_j}">
                        <td>${j.city_name}</td>
                        <td id="td_form_price_list_${key_form_price_list}_item_child_price_list_${key_item_child_price_list}_weight_range_${key_i}_cities_${key_j}" style="min-width:200px">
                            <input name="form_price_list.${key_form_price_list}.item_child_price_list.${key_item_child_price_list}.weight_range.${key_i}.cities.${key_j}.item_child_price_list_amount" 
                                    class="form-control" type="text" 
                            value="${formatNumberThousand(form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list].weight_range[key_i]['cities'][key_j]['item_child_price_list_amount'])}">
                        </td>
                    </tr>
                `);
            } else {
                $(`#tr_form_price_list_${key_form_price_list}_item_child_price_list_${key_item_child_price_list}_weight_range_${check_isset_key_i}_cities_${key_j}`).append(`
                    <td id="td_form_price_list_${key_form_price_list}_item_child_price_list_${key_item_child_price_list}_weight_range_${key_i}_cities_${key_j}" style="min-width:200px">
                        <input name="form_price_list.${key_form_price_list}.item_child_price_list.${key_item_child_price_list}.weight_range.${key_i}.cities.${key_j}.item_child_price_list_amount" 
                                class="form-control" type="text" 
                        value="${formatNumberThousand(form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list].weight_range[key_i]['cities'][key_j]['item_child_price_list_amount'])}">
                    </td>
                `);
            }
        });
    });
}

function setDisplayFormItemChildPriceListWithService() {
    form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'] = Object.values(form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range']);
    let data = form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list];
    $('#content_item_child_price_list').removeClass('mb300');
    $('#content_item_child_price_list').html(`
        <div class="table-responsive" style="max-height:450px; overflow: auto;">
            <table class="table table-borderless">
                <thead>
                    <tr>
                        <th scope="col">Mức Kg</th>
                        <th id="form_add_column_item_child_price_list" class="border-0" scope="col">
                            ${data['sub_child_price_list_type'] != 0 && data['sub_child_price_list_type'] != 4 ? `<button id="btn_add_column_item_child_price_list" type="button" class="btn btn-info">
                                <i class="fa fa-plus"></i>
                            </button>` : ''}
                        </th>
                    </tr>
                </thead>
                <tbody id="tbody_item_child_price_list_state"></tbody>
            </table>
        </div>
    `);

    let check_isset_key_i = null;
    $.each(data.weight_range, function (key_i, i) {
        $(`
            <th id="th_form_price_list_${key_form_price_list}_item_child_price_list_${key_item_child_price_list}_weight_range_${key_i}" scope="col">
                <div class="d-flex flex-row">
                    ${data['sub_child_price_list_type'] != 0 ? `<button type="button" class="btn ${Object.keys(i['sub_child_price_list_area']).length > 0 ? 'btn-warning' : 'btn-primary'} me-2 w-100 mb-1"
                        onclick="setAreaColumnItemChildPriceList(${key_i})">
                        <i class="fa fa-pen"></i>
                    </button>` : ''}
                    ${data['sub_child_price_list_type'] != 0 && data['sub_child_price_list_type'] != 4 ? `
                        <button type="button" class="btn btn-danger w-100 mb-1"
                            onclick="deleteColumnItemChildPriceList(${key_i})">
                            <i class="fa fa-trash"></i>
                        </button>
                    ` : ''}
                </div>
                <div class="d-flex flex-row align-items-center">
                    <input class="form-control" type="text"
                        placeholder="Nhập tiêu đề"
                        name="form_price_list.${key_form_price_list}.item_child_price_list.${key_item_child_price_list}.weight_range.${key_i}.title"
                        value="${i.title}">
                </div>
            </th>
        `).insertBefore('#form_add_column_item_child_price_list');

        $.each(i['data'], function (key_j, j) {
            if (check_isset_key_i === null || check_isset_key_i == key_i) {
                check_isset_key_i = key_i;
                $(`#tbody_item_child_price_list_state`).append(`
                    <tr id="tr_form_price_list_${key_form_price_list}_item_child_price_list_${key_item_child_price_list}_weight_range_${key_i}_data_${key_j}">
                        <td class="d-flex flex-row align-items-center"
                            id="td_form_price_list_${key_form_price_list}_item_child_price_list_${key_item_child_price_list}_weight_range_${key_i}_data_${key_j}" style="min-width:250px">
                            ${onDisplaySelectedChangeWeightRangeFlg(key_i, key_j)}
                        </td>
                        <td id="td_form_price_list_${key_form_price_list}_item_child_price_list_${key_item_child_price_list}_weight_range_${key_i}_data_${key_j}_item_child_price_list_amount" style="min-width:200px">
                            <input name="form_price_list.${key_form_price_list}.item_child_price_list.${key_item_child_price_list}.weight_range.${key_i}.data.${key_j}.item_child_price_list_amount" 
                                    class="form-control" type="text" 
                            value="${formatNumberThousand(form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list].weight_range[key_i]['data'][key_j]['item_child_price_list_amount'])}">
                        </td>
                        <td id="td_delete_form_price_list_${key_form_price_list}_item_child_price_list_${key_item_child_price_list}_weight_range_${key_i}_data_${key_j}" 
                            class="d-flex justify-content-center align-items-center"
                            onclick="deleteRowItemChildPriceListWeighRange(${key_i}, ${key_j})">
                            <button type="button" class="btn btn-danger">
                                <i class="fa fa-trash"></i>
                            </button>
                        </td>
                    </tr>
                `);
            } else {
                $(`
                    <td id="td_form_price_list_${key_form_price_list}_item_child_price_list_${key_item_child_price_list}_weight_range_${key_i}_data_${key_j}_item_child_price_list_amount" style="min-width:200px">
                        <input name="form_price_list.${key_form_price_list}.item_child_price_list.${key_item_child_price_list}.weight_range.${key_i}.data.${key_j}.item_child_price_list_amount" 
                                class="form-control" type="text" 
                        value="${formatNumberThousand(form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list].weight_range[key_i]['data'][key_j]['item_child_price_list_amount'])}">
                    </td>
                `).insertBefore(`#td_delete_form_price_list_${key_form_price_list}_item_child_price_list_${key_item_child_price_list}_weight_range_${check_isset_key_i}_data_${key_j}`);
            }
        });
    });
    $(`#tbody_item_child_price_list_state`).append(`
        <tr id="tr_add_row_form_price_list_${key_form_price_list}_item_child_price_list_${key_item_child_price_list}_weight_range">
            <td class="d-flex justify-content-start align-items-center">
                <button type="button" class="btn btn-info"
                onclick="addRowItemChildPriceListWeighRange()">
                    <i class="fa fa-plus"></i>
                </button>
            </td>
        </tr>
    `);
}

async function setAreaColumnItemChildPriceList(key_item_price_list_weight_range) {
    try {
        let data = {
            is_api: false,
            sub_child_price_list_type: form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['sub_child_price_list_type'],
            service_id: form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['service_id'],
            country_id: form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['country_id'] ? form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['country_id'] : $('#sub_child_price_list_area_country').val(),
            sub_child_price_list_area: JSON.stringify(form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][key_item_price_list_weight_range]['sub_child_price_list_area']),
            weight_range: JSON.stringify(form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range']),
        }
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/price-list/settings/item-child-price-list/sub-child-price-list-type`, 'POST', data);
        if (result.status == 200) {
            $('#exampleModalSubChildPriceListArea').modal({
                backdrop: false,
                zIndex: 9999
            });
            $('#exampleModalSubChildPriceListArea').modal('show');
            await setDisplayModalSubChildPriceListArea(result, key_item_price_list_weight_range);
            if (data['sub_child_price_list_type'] == 3) {
                sub_child_price_list_area_cities = result.sub_child_price_list_area_cities;
                setDisplaySubChildPriceListAreaCities();
            } else if (data['sub_child_price_list_type'] == 4) {
                sub_child_price_list_area_town = result.sub_child_price_list_area_town;
                setDisplaySubChildPriceListAreaTown();
            }
        } else {
            showMessage(result.message);
        }
    } catch (error) {
        showMessage(error.message);
    }
}

function setDisplayModalSubChildPriceListArea(result, key_item_price_list_weight_range) {
    if (form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['sub_child_price_list_type'] == 1) {
        $('#modalBodySubChildPriceListArea').html(`
            <div class="modal-content">
                <div class="modal-body" style="min-height: 600px;">
                    <div class="row gx-3">
                        <div class="col-12">
                            <div class="form-group">
                                <label class="form-label">Chọn quốc gia</label>
                                <select class="form-select select2 select2-multiple" multiple="multiple"
                                    id="sub_child_price_list_area">
                                    ${result.countries.map(item => {
            return `
                                            <option value="${Number(item['country_id'])}" ${Object.values(result.sub_child_price_list_area).includes(Number(item['country_id'])) ? 'selected' : ''}>
                                                ${item['country']['country_name']} - ${item['country']['country_code']}
                                            </option>
                                        `;
        })}
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer d-flex justify-content-center">
                    <button onclick="saveExampleModalSubChildPriceListArea(${key_item_price_list_weight_range})" type="button" class="btn btn-primary">Lưu</button>
                </div>
            </div>
        `);
    } else if (form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['sub_child_price_list_type'] == 2) {
        $('#modalBodySubChildPriceListArea').html(`
            <div class="modal-content">
                <div class="modal-body" style="min-height: 600px;">
                    <div class="row gx-3">
                        <div class="col-12">
                            <div class="form-group">
                                <label class="form-label">Chọn quốc gia</label>
                                <select class="form-select select2" ${result.country_id && key_item_price_list_weight_range != 0 ? 'disabled' : ''}
                                     onchange="onChangeSubChildPriceListAreaCountry(${key_item_price_list_weight_range})"
                                    id="sub_child_price_list_area_country">
                                    <option value="">Chọn một quốc gia</option>
                                    ${result.countries.map(item => {
            return `
                                            <option value="${item['country_id']}" ${result.country_id == item['country_id'] ? 'selected' : ''}>
                                                ${item['country']['country_name']} - ${item['country']['country_code']}
                                            </option>
                                        `;
        })}
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row gx-3">
                        <div class="col-12">
                            <div class="form-group">
                                <label class="form-label">Chọn tiểu bang</label>
                                <select class="form-select select2 select2-multiple" multiple="multiple" 
                                    id="sub_child_price_list_area">
                                    ${result.states.map(item => {
            return `
                                            <option value="${Number(item['state_id'])}" ${Object.values(result.sub_child_price_list_area).includes(Number(item['state_id'])) ? 'selected' : ''}>
                                                ${item['state_name']}
                                            </option>
                                        `;
        })}
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer d-flex justify-content-center">
                    <button onclick="saveExampleModalSubChildPriceListArea(${key_item_price_list_weight_range})" type="button" class="btn btn-primary">Lưu</button>
                </div>
            </div>
        `);
    } else if (form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['sub_child_price_list_type'] == 3) {
        $('#modalBodySubChildPriceListArea').html(`
            <div class="modal-content">
                <div class="modal-body" style="min-height: 600px;">
                    <div class="row gx-3">
                        <div class="col-12">
                            <div class="form-group">
                                <label class="form-label">Chọn quốc gia</label>
                                <select class="form-select select2" ${result.country_id && key_item_price_list_weight_range != 0 ? 'disabled' : ''}
                                     onchange="onChangeSubChildPriceListAreaCountry(${key_item_price_list_weight_range})"
                                    id="sub_child_price_list_area_country">
                                    ${result.countries.map(item => {
            return `
                                            <option value="${item['country_id']}" ${result.country_id == item['country_id'] ? 'selected' : ''}>
                                                ${item['country']['country_name']} - ${item['country']['country_code']}
                                            </option>
                                        `;
        })}
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row gx-3">
                        <div class="col-12">
                            <div class="form-group">
                                <label class="form-label">Chọn thành phố</label>
                                <input type="text" class="form-control input-list-search" 
                                    onkeyup="onChangeSubChildPriceListAreaCities(${key_item_price_list_weight_range})"
                                    placeholder="Nhập tên thành phố cần thêm">
                                <div class="position-relative">
                                    <div class="card list-search-card position-absolute w-100 d-none mb-0" style="z-index: 1">
                                        <ul class="list-group list-group-flush list-search-ul" style="min-height: 400px; max-height: 400px; overflow-y: auto"></ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label class="form-label">Danh sách thành phố đã chọn</label>
                                <ul class="list-group sub_child_price_list_area_cities" style="max-height: 350px; overflow-y: auto"></ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer d-flex justify-content-center">
                    <button onclick="saveExampleModalSubChildPriceListArea(${key_item_price_list_weight_range})" type="button" class="btn btn-primary">Lưu</button>
                </div>
            </div>
        `);
    } else if (form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['sub_child_price_list_type'] == 4) {
        $('#modalBodySubChildPriceListArea').html(`
            <div class="modal-content">
                <div class="modal-body" style="min-height: 600px;">
                    <div class="row gx-3">
                        <div class="col-12">
                            <div class="form-group">
                                <label class="form-label">Chọn quốc gia</label>
                                <select class="form-select select2" ${result.country_id && key_item_price_list_weight_range != 0 ? 'disabled' : ''}
                                     onchange="onChangeSubChildPriceListAreaCountry(${key_item_price_list_weight_range})"
                                    id="sub_child_price_list_area_country">
                                    ${result.countries.map(item => {
            return `
                                            <option value="${item['country_id']}" ${result.country_id == item['country_id'] ? 'selected' : ''}>
                                                ${item['country']['country_name']} - ${item['country']['country_code']}
                                            </option>
                                        `;
        })}
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row gx-3">
                        <div class="col-12">
                            <div class="form-group">
                                <label class="form-label">Chọn post code</label>
                                <input type="text" class="form-control input-list-search" 
                                    onkeyup="onChangeSubChildPriceListAreaTown(${key_item_price_list_weight_range})"
                                    placeholder="Nhập post code cần thêm">
                                <div class="position-relative">
                                    <div class="card list-search-card position-absolute w-100 d-none mb-0" style="z-index: 1">
                                        <ul class="list-group list-group-flush list-search-ul" style="min-height: 400px; max-height: 400px; overflow-y: auto"></ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label class="form-label">Danh sách post code đã chọn</label>
                                <ul class="list-group sub_child_price_list_area_town" style="max-height: 350px; overflow-y: auto"></ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer d-flex justify-content-center">
                    <button onclick="saveExampleModalSubChildPriceListArea(${key_item_price_list_weight_range})" type="button" class="btn btn-primary">Lưu</button>
                </div>
            </div>
        `);
    }

    $('.select2').each(function () {
        $(this).select2({
            dropdownParent: $(this).parent(),
        });
    });
}

function saveExampleModalSubChildPriceListArea(key_item_price_list_weight_range) {
    if (form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['sub_child_price_list_type'] == 3) {
        form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][key_item_price_list_weight_range]['sub_child_price_list_area'] = Object.values(sub_child_price_list_area_cities).map(city => city.city_id);
        sub_child_price_list_area_cities = {};
    } else if (form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['sub_child_price_list_type'] == 4) {
        form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][key_item_price_list_weight_range]['sub_child_price_list_area'] = Object.values(sub_child_price_list_area_town).map(town => town.town_id);
        sub_child_price_list_area_town = {};
    } else {
        let country_ids = $('#sub_child_price_list_area').val();
        let convert_country_ids = {};
        $.each(country_ids, function (key, item) {
            convert_country_ids[item] = parseInt(item);
        });
        form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][key_item_price_list_weight_range]['sub_child_price_list_area'] = convert_country_ids;
    }
    $('#exampleModalSubChildPriceListArea').modal('hide');
    setDisplayFormItemChildPriceListWithService();
}

async function onChangeSubChildPriceListAreaCountry(key_item_price_list_weight_range) {
    try {
        let data = {
            is_api: false,
            sub_child_price_list_type: form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['sub_child_price_list_type'],
            service_id: form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['service_id'],
            country_id: form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['country_id'] ? form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['country_id'] : $('#sub_child_price_list_area_country').val(),
            sub_child_price_list_area: form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][key_item_price_list_weight_range]['sub_child_price_list_area'],
            weight_range: form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'],
        }
        $.each(form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'], function (key_data, item) {
            form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][key_data]['sub_child_price_list_area'] = {};
        });
        if (data['sub_child_price_list_type'] == 3) {
            sub_child_price_list_area_cities = {};
            setDisplaySubChildPriceListAreaCities();
        } else if (data['sub_child_price_list_type'] == 4) {
            sub_child_price_list_area_town = {};
            setDisplaySubChildPriceListAreaTown();
        }
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/price-list/settings/item-child-price-list/sub-child-price-list-type`, 'POST', data);
        if (result.status == 200) {
            setDisplayModalSubChildPriceListArea(result, key_item_price_list_weight_range);
        } else {
            showMessage(result.message);
        }
    } catch (error) {
        showMessage(error.message);
    }
}

$('body').on('focus', '.input-list-search', async function () {
    $('.list-search-card').removeClass('d-none');
});

$('body').on('blur', '.input-list-search', async function () {
    if (!$('.list-search-card').is(':hover')) {
        $('.list-search-card').addClass('d-none');
    }
});

$('.list-search-card').on('mouseenter', function () {
    $('.list-search-card').removeClass('d-none');
});

$('.list-search-card').on('mouseleave', function () {
    $('.list-search-card').addClass('d-none');
});

$('body').on('click', '#exampleModalSubChildPriceListArea', function (event) {
    if (event.target.closest('.list-search-card') == null && event.target.closest('.input-list-search') == null) {
        $('.list-search-card').addClass('d-none');
    }
});

async function onChangeSubChildPriceListAreaCities(key_item_price_list_weight_range) {
    try {
        let data = {
            country_id: form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['country_id'] ? form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['country_id'] : $('#sub_child_price_list_area_country').val(),
            keywords: $('.input-list-search').val(),
            sub_child_price_list_type: form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['sub_child_price_list_type'],
            sub_child_price_list_area: form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][key_item_price_list_weight_range]['sub_child_price_list_area'],
            weight_range: form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'],
        }
        setTimeout(async () => {
            $('.list-search-ul').html('');
            if (!$('.input-list-search').val() && $('.input-list-search').val() == "") {
                return false;
            }
            const result = await sendRequest(`${window.location.origin}/manages/admin/system/price-list/settings/item-child-price-list/sub-child-price-list-type`, 'POST', data);
            if (result.status == 200) {
                $.each(result.cities, function (key, item) {
                    $('.list-search-ul').append(`
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <div class="form-check">
                                <input type="checkbox" class="form-check-input input_choose_city"
                                    ${sub_child_price_list_area_cities[item.city_id] ? 'checked' : ''}
                                    value="${item.city_id}|${item.city_name}" id="input_city_${item.city_id}">
                                <label class="form-check-label" for="input_city_${item.city_id}">
                                    ${item.city_name}
                                </label>
                            </div>
                        </li>
                    `);
                });
            } else {
                showMessage(result.message);
            }
        }, 500);
    } catch (error) {
        showMessage(error.message);
    }
}

async function onChangeSubChildPriceListAreaTown(key_item_price_list_weight_range) {
    try {
        let data = {
            country_id: form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['country_id'] ? form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['country_id'] : $('#sub_child_price_list_area_country').val(),
            keywords: $('.input-list-search').val(),
            sub_child_price_list_type: form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['sub_child_price_list_type'],
            sub_child_price_list_area: JSON.stringify(form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][key_item_price_list_weight_range]['sub_child_price_list_area']),
            weight_range: JSON.stringify(form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range']),
        }

        setTimeout(async () => {
            $('.list-search-ul').html('');
            if (!$('.input-list-search').val() && $('.input-list-search').val() == "") {
                return false;
            }
            const result = await sendRequest(`${window.location.origin}/manages/admin/system/price-list/settings/item-child-price-list/sub-child-price-list-type`, 'POST', data);

            $.each(result.town, function (key, item) {
                $('.list-search-ul').append(`
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input input_choose_town"
                                ${sub_child_price_list_area_town[item.town_id] ? 'checked' : ''}
                                value="${item.town_id}|${item.town_postal_code}" id="input_town_${item.town_id}">
                            <label class="form-check-label" for="input_town_${item.town_id}">
                                ${item.town_postal_code}
                            </label>
                        </div>
                    </li>
                `);
            });
        }, 500);
    } catch (error) {
        showMessage(error.message);
    }
}

let sub_child_price_list_area_cities = {};
let sub_child_price_list_area_town = {};
$('body').on('click', '.input_choose_city', function () {
    let city = $(this).val().split('|');
    if ($(this).is(':checked')) {
        sub_child_price_list_area_cities[city[0]] = {
            city_id: city[0],
            city_name: city[1],
        };
    } else {
        delete sub_child_price_list_area_cities[city[0]];
    }
    setDisplaySubChildPriceListAreaCities();
});

$(document).on('click', '.input_choose_town', function () {
    let town = $(this).val().split('|');
    if ($(this).is(':checked')) {
        sub_child_price_list_area_town[town[0]] = {
            town_id: town[0],
            town_postal_code: town[1],
        };
    } else {
        delete sub_child_price_list_area_town[town[0]];
    }
    setDisplaySubChildPriceListAreaTown();
});

function setDisplaySubChildPriceListAreaCities() {
    sub_child_price_list_area_cities = Object.assign({}, sub_child_price_list_area_cities);
    $('.sub_child_price_list_area_cities').html('');
    $.each(sub_child_price_list_area_cities, function (key, item) {
        $('.sub_child_price_list_area_cities').append(`
            <li class="list-group-item d-flex flex-row justify-content-start align-items-center">
                <div>
                    <button type="button" class="btn btn-sm btn-danger" 
                        onclick="deleteSubChildPriceListAreaCities(${item['city_id']})">
                        <i class="fa fa-trash"></i>
                    </button>
                </div>
                <span class="ms-2">${item.city_name}</span>
            </li>
        `);
    });
}

function setDisplaySubChildPriceListAreaTown() {
    sub_child_price_list_area_town = Object.assign({}, sub_child_price_list_area_town);
    $('.sub_child_price_list_area_town').html('');
    $.each(sub_child_price_list_area_town, function (key, item) {
        $('.sub_child_price_list_area_town').append(`
            <li class="list-group-item d-flex flex-row justify-content-start align-items-center">
                <div>
                    <button type="button" class="btn btn-sm btn-danger"
                        onclick="deleteSubChildPriceListAreaTown(${item['town_id']})">
                        <i class="fa fa-trash"></i>
                    </button>
                </div>
                <span class="ms-2">${item.town_postal_code}</span>
            </li>
        `);
    });
}

function deleteSubChildPriceListAreaCities(city_id) {
    if (sub_child_price_list_area_cities[city_id]) {
        delete sub_child_price_list_area_cities[city_id];
        $(`#input_city_${city_id}`).prop('checked', false);
        setDisplaySubChildPriceListAreaCities();
    }
}

function deleteSubChildPriceListAreaTown(town_id) {
    if (sub_child_price_list_area_town[town_id]) {
        delete sub_child_price_list_area_town[town_id];
        $(`#input_town_${town_id}`).prop('checked', false);
        setDisplaySubChildPriceListAreaTown();
    }
}

function onDisplaySelectedChangeWeightRangeFlg(key_item_price_list_weight_range, key_data) {
    let weight_range_flg = form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list].weight_range[key_item_price_list_weight_range]['data'][key_data]['weight_range_flg'];
    let html = '';
    if (weight_range_flg == 1) {
        html = `
            <input name="form_price_list.${key_form_price_list}.item_child_price_list.${key_item_child_price_list}.weight_range.${key_item_price_list_weight_range}.data.${key_data}.child_price_list_from_weight" 
                    class="form-control ms-1" type="text" 
            value="${formatNumberThousand(form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list].weight_range[key_item_price_list_weight_range]['data'][key_data]['child_price_list_from_weight'])}">
            <span class="ms-1 me-1"> - </span>
            <input name="form_price_list.${key_form_price_list}.item_child_price_list.${key_item_child_price_list}.weight_range.${key_item_price_list_weight_range}.data.${key_data}.child_price_list_to_weight" 
                    class="form-control" type="text" 
            value="${formatNumberThousand(form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list].weight_range[key_item_price_list_weight_range]['data'][key_data]['child_price_list_to_weight'])}"></input>
        `;
    } else {
        html = `
            <input name="form_price_list.${key_form_price_list}.item_child_price_list.${key_item_child_price_list}.weight_range.${key_item_price_list_weight_range}.data.${key_data}.child_price_list_to_weight" 
                    class="form-control ms-1" type="text" 
            value="${formatNumberThousand(form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list].weight_range[key_item_price_list_weight_range]['data'][key_data]['child_price_list_to_weight'])}"></input>
        `;
    }

    return `
        <select class="form-select"
            name="form_price_list.${key_form_price_list}.item_child_price_list.${key_item_child_price_list}.weight_range.${key_item_price_list_weight_range}.data.${key_data}.weight_range_flg">
            <option ${weight_range_flg == 0 ? 'selected' : ''} value="0">N</option>
            <option ${weight_range_flg == 1 ? 'selected' : ''} value="1">N to N</option>
            <option ${weight_range_flg == 2 ? 'selected' : ''} value="2">>N</option>
            <option ${weight_range_flg == 3 ? 'selected' : ''} value="3">>=N</option>
        </select>
        ${html}
    `;
}

function setDisplayCardItemChildPriceListWithAreas() {
    $(`#form_price_list_${key_form_price_list}_items_child_price_list`).html('');
    $.each(form_price_list[key_form_price_list]['item_child_price_list'], function (key_value, value) {
        let data = value;
        if (data.is_not_empty_cities || (data.country_id != undefined && data.country_id != "")) {
            if (!data.weight_range) {
                $(`#form_price_list_${key_form_price_list}_items_child_price_list`).append(`
                    <div id="form_price_list_${key_form_price_list}_items_child_price_list_${key_value}" class="col-sm-4">
                        <div class="card">
                            <div class="card-header bg-gradient-success d-flex justify-content-between">
                                <h6 class="text-white">
                                    ${$('[name="price_list_tranport_type"]').val() == 1 ? data['country_name'] + ' - ' + data['country_code'] : data['service_name']}
                                </h6>
                                <div class="text-end">
                                    <button type="button" class="btn btn-info"
                                        id="on_edit_sub_child_price_list_${key_form_price_list}_${key_value}"
                                        onclick="onEditSubChildPriceList(${key_form_price_list}, ${key_value})">
                                        <i class="acon-icon ri-pencil-line"></i> 
                                    </button>
                                    <button type="button" class="btn btn-danger"
                                        onclick="onDeleteChildPriceList(${key_form_price_list}, ${key_value})">
                                        <i class="acon-icon ri-delete-bin-fill"></i> 
                                    </button>
                                </div>
                            </div>
                            <div id="card_item_price_list_${key_form_price_list}_${key_value}" class="p-1 card-body-item-price-list">
                                <div class="alert alert-primary" role="alert">
                                    Nhấn chỉnh sửa để xem và chỉnh sửa thông tin!
                                </div>
                            </div>
                        </div>
                    </div>
                `);
            } else {
                let title = data['title'] ? data['title'] : `${data.country_name} - ${data.country_code}`;
                $(`#form_price_list_${key_form_price_list}_items_child_price_list`).append(`
                    <div id="form_price_list_${key_form_price_list}_items_child_price_list_${key_value}" class="col-sm-4">
                        <div class="card">
                            <div class="card-header ${data.sub_child_price_list_id ? 'bg-gradient-success' : 'bg-gradient-warning'} d-flex justify-content-between">
                                <h6 class="text-white">
                                    ${title}
                                </h6>
                                <div class="text-end">
                                    <button type="button" class="btn btn-info"
                                        id="on_edit_item_child_price_list_${key_form_price_list}_${key_value}"
                                        onclick="onEditChildPriceList(${key_form_price_list}, ${key_value})">
                                        <i class="acon-icon ri-pencil-line"></i> 
                                    </button>
                                    <button type="button" class="btn btn-danger"
                                        onclick="onDeleteChildPriceList(${key_form_price_list}, ${key_value})">
                                        <i class="acon-icon ri-delete-bin-fill"></i> 
                                    </button>
                                </div>
                            </div>
                            <div id="card_item_price_list_${key_form_price_list}_${key_value}" class="p-1 card-body-item-price-list">
                                <div class="table-responsive">
                                    <table class="table table-borderless">
                                        <thead>
                                            <tr id="show_tr_item_price_list_${key_form_price_list}_${key_value}">
                                                <th scope="col">Địa chỉ</th>
                                            </tr>
                                        </thead>
                                        <tbody id="tbody_card_item_child_price_list_state_${key_form_price_list}_${key_value}"></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                `);

                $.each(data['weight_range'], function (key_weight_range, item) {
                    $(`#show_tr_item_price_list_${key_form_price_list}_${key_value}`).append(`
                        <th scope="col">
                            ${item.child_price_list_from_weight} - ${item.child_price_list_to_weight}Kg
                        </th>
                    `);
                    $.each(item['cities'], function (key_city, city) {
                        if (key_weight_range == 0) {
                            $(`#tbody_card_item_child_price_list_state_${key_form_price_list}_${key_value}`).append(`
                                <tr id="tr_item_child_price_list_state_${key_form_price_list}_${key_value}_${key_weight_range}_${city.city_id}">
                                    <td>${city.city_name}</td>
                                    <td style="min-width:150px">${formatNumberThousand(city.item_child_price_list_amount)}</td>
                                </tr>
                            `);
                        } else {
                            $(`#tr_item_child_price_list_state_${key_form_price_list}_${key_value}_0_${city.city_id}`).append(`
                                <td style="min-width:150px">${formatNumberThousand(city.item_child_price_list_amount)}</td>
                            `);
                        }
                    });
                });
            }
            $('#exampleModalItemChildPriceList').modal('hide');
            $('#saveExampleModalItemChildPriceList').attr('disabled', false);
        } else {
            $('#saveExampleModalItemChildPriceList').attr('disabled', false);
            return alert("Không có thành phố nào trong quốc gia này nên không thể tạo bảng giá");
        }
    });
}

function setDisplayCardItemChildPriceListWithService() {
    $(`#form_price_list_${key_form_price_list}_items_child_price_list`).html('');
    $.each(form_price_list[key_form_price_list]['item_child_price_list'], function (key_value, value) {
        let data = value;
        if (data.service_id != undefined && data.service_id != "") {
            if (!data.weight_range) {
                $(`#form_price_list_${key_form_price_list}_items_child_price_list`).append(`
                    <div id="form_price_list_${key_form_price_list}_items_child_price_list_${key_value}" class="col-sm-4">
                        <div class="card">
                            <div class="card-header bg-gradient-success d-flex justify-content-between">
                                <h6 class="text-white">
                                    ${$('[name="price_list_tranport_type"]').val() == 1 ? data['country_name'] + ' - ' + data['country_code'] : data['service_name']}
                                </h6>
                                <div class="text-end">
                                    <button type="button" class="btn btn-info"
                                        id="on_edit_sub_child_price_list_${key_form_price_list}_${key_value}"
                                        onclick="onEditSubChildPriceList(${key_form_price_list}, ${key_value})">
                                        <i class="acon-icon ri-pencil-line"></i> 
                                    </button>
                                    <button type="button" class="btn btn-danger"
                                        onclick="onDeleteChildPriceList(${key_form_price_list}, ${key_value})">
                                        <i class="acon-icon ri-delete-bin-fill"></i> 
                                    </button>
                                </div>
                            </div>
                            <div id="card_item_price_list_${key_form_price_list}_${key_value}" class="p-1 card-body-item-price-list">
                                <div class="alert alert-primary" role="alert">
                                    Nhấn chỉnh sửa để xem và chỉnh sửa thông tin!
                                </div>
                            </div>
                        </div>
                    </div>
                `);
            } else {
                $(`#form_price_list_${key_form_price_list}_items_child_price_list`).append(`
                    <div id="form_price_list_${key_form_price_list}_items_child_price_list_${key_value}" class="col-sm-4">
                        <div class="card">
                            <div class="card-header ${data.is_editing ? 'bg-gradient-warning' : 'bg-gradient-success'} d-flex justify-content-between">
                                <h6 class="text-white">
                                    ${data['title']}
                                </h6>
                                <div class="text-end">
                                    <button type="button" class="btn btn-info"
                                        id="on_edit_item_child_price_list_${key_form_price_list}_${key_value}"
                                        onclick="onEditChildPriceList(${key_form_price_list}, ${key_value})">
                                        <i class="acon-icon ri-pencil-line"></i> 
                                    </button>
                                    <button type="button" class="btn btn-danger"
                                        onclick="onDeleteChildPriceList(${key_form_price_list}, ${key_value})">
                                        <i class="acon-icon ri-delete-bin-fill"></i> 
                                    </button>
                                </div>
                            </div>
                            <div id="card_item_price_list_${key_form_price_list}_${key_value}" class="p-1 card-body-item-price-list">
                                <div class="table-responsive">
                                    <table class="table table-borderless">
                                        <thead>
                                            <tr id="show_tr_item_price_list_${key_form_price_list}_${key_value}">
                                                <th scope="col">Mức Kg</th>
                                            </tr>
                                        </thead>
                                        <tbody id="tbody_card_item_child_price_list_state_${key_form_price_list}_${key_value}"></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                `);

                let check_isset_key_i = null;
                $.each(data.weight_range, function (key_i, i) {
                    $(`#show_tr_item_price_list_${key_form_price_list}_${key_value}`).append(`
                        <th scope="col">
                            ${i.title}
                        </th>
                    `);

                    $.each(i['data'], function (key_j, j) {
                        let html = '';
                        if (j.weight_range_flg == 0) {
                            html = `${j.child_price_list_to_weight}`;
                        } else if (j.weight_range_flg == 1) {
                            html = `${j.child_price_list_from_weight} - ${j.child_price_list_to_weight}`;
                        } else if (j.weight_range_flg == 2) {
                            html = `> ${j.child_price_list_to_weight}`;
                        } else if (j.weight_range_flg == 3) {
                            html = `>= ${j.child_price_list_to_weight}`;
                        }
                        if (check_isset_key_i === null || check_isset_key_i == key_i) {
                            check_isset_key_i = key_i;
                            $(`#tbody_card_item_child_price_list_state_${key_form_price_list}_${key_value}`).append(`
                                <tr id="tr_item_child_price_list_state_${key_form_price_list}_${key_value}_${key_i}_${key_j}">
                                    <td>${html}</td>
                                    <td style="min-width:150px">${formatNumberThousand(j.item_child_price_list_amount)}</td>
                                </tr>
                            `);
                        } else {
                            $(`#tr_item_child_price_list_state_${key_form_price_list}_${key_value}_${check_isset_key_i}_${key_j}`).append(`
                                <td style="min-width:150px">${formatNumberThousand(j.item_child_price_list_amount)}</td>
                            `);
                        }
                    });
                });
            }
            $('#exampleModalItemChildPriceList').modal('hide');
            $('#saveExampleModalItemChildPriceList').attr('disabled', false);
        } else {
            $('#saveExampleModalItemChildPriceList').attr('disabled', false);
            return alert("Chưa chọn dịch vụ nên không thể tạo bảng giá");
        }
    });
}

async function addRowItemChildPriceListWeighRange() {
    let data = form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'];
    let last_key_data = null;
    $.each(data, function (key_i, i) {
        last_key_data = Object.keys(i.data).length;
        form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][key_i]['data'][last_key_data] = {
            child_price_list_from_weight: 0,
            child_price_list_to_weight: 0,
            item_child_price_list_amount: 0,
            weight_range_flg: 1
        };
    });
    await setDisplayFormItemChildPriceListWithService();
    $('.table-responsive').animate({ scrollTop: $('.table-responsive')[0].scrollHeight }, 0);
}

async function deleteRowItemChildPriceListWeighRange(key_item_price_list_weight_range, key_data) {
    if (form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list].weight_range.hasOwnProperty(key_item_price_list_weight_range)) {
        if ($('[name="price_list_tranport_type"]').val() == 0) {
            if (Object.keys(form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list].weight_range[0].data).length > 1) {
                $.each(form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list].weight_range, function (key_i, i) {
                    delete form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list].weight_range[key_i]['data'][key_data];
                    let dataArray = Object.values(form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list].weight_range[key_i]['data']);
                    dataArray.splice(key_data, 1);
                    form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list].weight_range[key_i]['data'] = Object.assign({}, dataArray);
                });
                await setDisplayFormItemChildPriceListWithService();
                $('.table-responsive').animate({ scrollTop: $('.table-responsive')[0].scrollHeight, scrollLeft: $('.table-responsive')[0].scrollWidth }, 0);
            } else {
                return alert("Phải có ít nhất là 1 cột dữ liệu");
            }
        }
    } else {
        console.log("Không tìm thấy phần tử có key '" + key_item_price_list_weight_range + "' trong object.");
    }
}

var item_child_price_list_tmp = null;
async function onEditChildPriceList(key_price_list, key_child_price_list) {
    $(`#on_edit_item_child_price_list_${key_price_list}_${key_child_price_list}`).attr('disabled', true);
    try {
        let data = {
            is_api: false,
            price_list_tranport_type: $('[name="price_list_tranport_type"]').val(),
            country_ids: Object.values(form_price_list[key_price_list]['item_child_price_list']).map(item => item.country_id),
            service_ids: Object.values(form_price_list[key_price_list]['item_child_price_list']).map(item => item.service_id),
            country_id: form_price_list[key_price_list]['item_child_price_list'][key_child_price_list]['country_id'],
            service_id: form_price_list[key_price_list]['item_child_price_list'][key_child_price_list]['service_id'],
            sub_child_price_list_type: form_price_list[key_price_list]['item_child_price_list'][key_child_price_list]['sub_child_price_list_type'],
        }
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/price-list/settings/create/item-child-price-list/display`, 'POST', data);
        if (result.status == 200) {
            $('#modalBodyItemChildPriceList').html(result.html);
            $('#exampleModalItemChildPriceList').modal('show');
            $('.modal-backdrop').remove();
            form_price_list[key_price_list]['item_child_price_list'][key_child_price_list]['is_editing'] = true;
            item_child_price_list_tmp = JSON.stringify(form_price_list[key_price_list]['item_child_price_list'][key_child_price_list]);
            key_form_price_list = key_price_list;
            key_item_child_price_list = key_child_price_list;
            if ($('[name="price_list_tranport_type"]').val() == 1) {
                setDisplayFormItemChildPriceListWithAreas();
            }
            if ($('[name="price_list_tranport_type"]').val() == 0) {
                setDisplayFormItemChildPriceListWithService();
            }
        } else {
            showMessage(result.message);
        }
        $(`#on_edit_item_child_price_list_${key_price_list}_${key_child_price_list}`).attr('disabled', false);
    } catch (error) {
        showMessage(error.message);
        $(`#on_edit_item_child_price_list_${key_price_list}_${key_child_price_list}`).attr('disabled', false);
    }
}

async function onCreateNewPriceListSetting() {
    $(`#create_new_price_list_setting`).attr('disabled', true);
    try {
        let data = {
            is_api: false,
            price_list_title: $('[name="price_list_title"]').val(),
            price_list_tranport_type: $('[name="price_list_tranport_type"]').val(),
            active_flg: $('[name="active_flg"]').val(),
            date_range_flg: $('[name="date_range_flg"]').val(),
            price_list_start_date: $('input[name="price_list_date_range"]').data('daterangepicker') ? $('input[name="price_list_date_range"]').data('daterangepicker').startDate.format('DD-MM-YYYY') : null,
            price_list_end_date: $('input[name="price_list_date_range"]').data('daterangepicker') ? $('input[name="price_list_date_range"]').data('daterangepicker').endDate.format('DD-MM-YYYY') : null,
            form_price_list: JSON.stringify(form_price_list),
        }
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/price-list/settings/create/handle`, 'POST', data);
        if (result.status == 200) {
            form_price_list = {};
            branchs = {};
            onLoadPagePriceListSetting();
        }
        showMessage(result.message);
        $(`#create_new_price_list_setting`).attr('disabled', false);
        $.each(['price_list_title', 'active_flg', 'date_range_flg'], function (key, value) {
            $(`#error_${value}`).html('');
        });
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        } else {
            $.each(pluck_key(error.responseJSON.errors), function (key, value) {
                if (error.responseJSON.errors[value]) {
                    $(`#error_${value}`).html(error.responseJSON.errors[value][0]);
                } else {
                    $(`#error_${value}`).html('');
                }
            });
        }
        $(`#create_new_price_list_setting`).attr('disabled', false);
    }
}

async function onLoadPageEditPriceList(price_list_id) {
    startLoadingOffcanvasRightMangeAdminSystemBody();
    try {
        let data = {
            is_api: false,
            price_list_id: price_list_id
        }
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/price-list/settings/edit/display`, 'POST', data);
        if (result.status == 200) {
            form_price_list = {};
            key_form_price_list = null;
            $('#offcanvasRightMangeAdminSystemBody').html(result.html);
            if (result.date_range.date_range_flg == 1) {
                $('input[name="price_list_date_range"]').daterangepicker({
                    opens: 'left',
                    startDate: moment().subtract(3, 'months').startOf('month'),
                    endDate: moment().endOf('month'),
                    locale: {
                        format: 'DD/MM/YYYY',
                        applyLabel: "Áp dụng",
                        cancelLabel: "Hủy",
                        customRangeLabel: "Tùy chỉnh",
                        daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
                        monthNames: [
                            "Tháng 1",
                            "Tháng 2",
                            "Tháng 3",
                            "Tháng 4",
                            "Tháng 5",
                            "Tháng 6",
                            "Tháng 7",
                            "Tháng 8",
                            "Tháng 9",
                            "Tháng 10",
                            "Tháng 11",
                            "Tháng 12",
                        ],
                    }
                }, function (start, end, label) {

                });
                $('input[name="price_list_date_range"]').data('daterangepicker').setStartDate(moment(result.date_range.price_list_start_date));
                $('input[name="price_list_date_range"]').data('daterangepicker').setEndDate(moment(result.date_range.price_list_end_date));
            }
        }
        closeLoadingOffcanvasRightMangeAdminSystemBody();
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
        closeLoadingOffcanvasRightMangeAdminSystemBody();
    }
}

function setDisplayFormCardSubChildPriceList() {
    if ($('[name="price_list_tranport_type"]').val() == 0) {
        $.each(form_price_list, function (key_i, i) {
            $.each(i['item_child_price_list'], function (key_j, j) {
                form_price_list[key_i]['item_child_price_list'][key_j]['is_editing'] = false;
                $(`#form_price_list_${key_i}_items_child_price_list`).append(`
                    <div id="form_price_list_${key_i}_items_child_price_list_${key_j}" class="col-sm-4">
                        <div class="card">
                            <div class="card-header bg-gradient-success d-flex justify-content-between">
                                <h6 class="text-white">
                                    ${[0, 1].includes(i.child_price_list_kind) ? j['country_name'] + ' - ' + j['country_code'] : j['service_name']}
                                </h6>
                                <div class="text-end">
                                    <button type="button" class="btn btn-info"
                                        id="on_edit_sub_child_price_list_${key_i}_${key_j}"
                                        onclick="onEditSubChildPriceList(${key_i}, ${key_j})">
                                        <i class="acon-icon ri-pencil-line"></i> 
                                    </button>
                                    <button type="button" class="btn btn-danger"
                                        onclick="onDeleteChildPriceList(${key_i}, ${key_j})">
                                        <i class="acon-icon ri-delete-bin-fill"></i> 
                                    </button>
                                </div>
                            </div>
                            <div id="card_item_price_list_${key_i}_${key_j}" class="p-1 card-body-item-price-list">
                                <div class="table-responsive">
                                    <table class="table table-borderless">
                                        <thead>
                                            <tr id="show_tr_item_price_list_${key_i}_${key_j}">
                                                <th scope="col">Mức Kg</th>
                                            </tr>
                                        </thead>
                                        <tbody id="tbody_card_item_child_price_list_state_${key_i}_${key_j}"></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                `);

                let check_isset_key_i = null;
                $.each(j['weight_range'], function (key_k, k) {
                    $(`#show_tr_item_price_list_${key_i}_${key_j}`).append(`
                        <th scope="col">
                            ${k.title}
                        </th>
                    `);

                    $.each(k['data'], function (key_l, l) {
                        let html = '';
                        if (l.weight_range_flg == 0) {
                            html = `${l.child_price_list_to_weight}`;
                        } else if (l.weight_range_flg == 1) {
                            html = `${l.child_price_list_from_weight} - ${l.child_price_list_to_weight}`;
                        } else if (l.weight_range_flg == 2) {
                            html = `> ${l.child_price_list_to_weight}`;
                        } else if (l.weight_range_flg == 3) {
                            html = `>= ${l.child_price_list_to_weight}`;
                        }
                        if (check_isset_key_i === null || check_isset_key_i == key_k) {
                            check_isset_key_i = key_k;
                            $(`#tbody_card_item_child_price_list_state_${key_i}_${key_j}`).append(`
                                <tr id="tr_item_child_price_list_state_${key_i}_${key_j}_${key_k}_${key_l}">
                                    <td>${html}</td>
                                    <td style="min-width:150px">${formatNumberThousand(l.item_child_price_list_amount)}</td>
                                </tr>
                            `);
                        } else {
                            $(`#tr_item_child_price_list_state_${key_i}_${key_j}_${check_isset_key_i}_${key_l}`).append(`
                                <td style="min-width:150px">${formatNumberThousand(l.item_child_price_list_amount)}</td>
                            `);
                        }
                    });
                });
            });
        });
    }
}

async function onEditSubChildPriceList(key_price_list, key_child_price_list) {
    $(`#on_edit_sub_child_price_list_${key_price_list}_${key_child_price_list}`).attr('disabled', true);
    try {
        let data = {
            is_api: false,
            price_list_tranport_type: price_list_tranport_type,
            sub_child_price_list: {
                country_id: form_price_list[key_price_list]['item_child_price_list'][key_child_price_list]['country_id'],
                service_id: form_price_list[key_price_list]['item_child_price_list'][key_child_price_list]['service_id'],
                sub_child_price_list_id: form_price_list[key_price_list]['item_child_price_list'][key_child_price_list]['sub_child_price_list_id'],
                sub_child_price_list_type: form_price_list[key_price_list]['item_child_price_list'][key_child_price_list]['sub_child_price_list_type'],
            },
        }
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/price-list/settings/edit/item-child-price-list/display`, 'POST', data);

        if (result.status == 200) {
            $('#modalBodyItemChildPriceList').html(result.html);
            $('#exampleModalItemChildPriceList').modal('show');
            $('.modal-backdrop').remove();
            form_price_list[key_price_list]['item_child_price_list'][key_child_price_list]['is_editing'] = true;
            form_price_list[key_price_list]['item_child_price_list'][key_child_price_list]['country_id'] = result.country_id;
            form_price_list[key_price_list]['item_child_price_list'][key_child_price_list]['is_not_empty_cities'] = result.is_not_empty_cities;
            form_price_list[key_price_list]['item_child_price_list'][key_child_price_list]['weight_range'] = result.weight_range;
            key_form_price_list = key_price_list;
            key_item_child_price_list = key_child_price_list;
            if (result.price_list_tranport_type == 1) {
                setDisplayFormItemChildPriceListWithAreas();
            }
            if (result.price_list_tranport_type == 0) {
                sub_child_price_list_area_cities = {};
                setDisplayFormItemChildPriceListWithService();
            }
        } else {
            showMessage(result.message);
        }
        $(`#on_edit_sub_child_price_list_${key_price_list}_${key_child_price_list}`).attr('disabled', false);
    } catch (error) {
        showMessage(error.message);
        $(`#on_edit_sub_child_price_list_${key_price_list}_${key_child_price_list}`).attr('disabled', false);
    }
}

async function onSaveEditPriceList(price_list_id) {
    let event = {
        title: 'Xác nhận hành vi!',
        text: `Bạn có chắc muốn cập nhật thông tin bảng giá này!`,
        icon: 'question',
        type: 'agreeSaveEditPriceList',
        data: {
            is_api: false,
            price_list_id: price_list_id,
            price_list_title: $('[name="price_list_title"]').val(),
            active_flg: $('[name="active_flg"]').val(),
            date_range_flg: $('[name="date_range_flg"]').val(),
            price_list_start_date: $('input[name="price_list_date_range"]').data('daterangepicker') ? $('input[name="price_list_date_range"]').data('daterangepicker').startDate.format('DD-MM-YYYY') : null,
            price_list_end_date: $('input[name="price_list_date_range"]').data('daterangepicker') ? $('input[name="price_list_date_range"]').data('daterangepicker').endDate.format('DD-MM-YYYY') : null,
            price_list_tranport_type: $('[name="price_list_tranport_type"]').val(),
            form_price_list: JSON.stringify(form_price_list),
        }
    };
    confirmEvent(event);
}

async function agreeSaveEditPriceList(data) {
    $(`#on_save_edit_price_list`).attr('disabled', true);
    try {
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/price-list/edit/handle`, 'POST', data);
        if (result.status == 200) {
            form_price_list = {};
            branchs = {};
            onLoadPagePriceListSetting();
        }
        showMessage(result.message);
        $(`#on_save_edit_price_list`).attr('disabled', false);
        $.each(['price_list_title', 'active_flg', 'date_range_flg'], function (key, value) {
            $(`#error_${value}`).html('');
        });
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        } else {
            $.each(['price_list_title'], function (key, value) {
                if (error.responseJSON.errors[value]) {
                    $(`#error_${value}`).html(error.responseJSON.errors[value][0]);
                } else {
                    $(`#error_${value}`).html('');
                }
            });
        }
        $(`#on_save_edit_price_list`).attr('disabled', false);
    }
}

async function onDeletePriceList(price_list_id) {
    let event = {
        title: 'Xác nhận hành vi!',
        text: `Bạn có chắc muốn xóa bảng giá này!`,
        icon: 'question',
        type: 'agreeDeletePriceList',
        data: {
            is_api: false,
            price_list_id: price_list_id,
        }
    };
    confirmEvent(event);
}

async function agreeDeletePriceList(data) {
    try {
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/price-list/settings/delete/handle`, 'POST', data);
        if (result.status == 200) {
            onPagination(`${show_page_url}/pagination`);
        }
        showMessage(result.message);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}

$('body').on('change', '#input_import_excel_price_list', function () {
    $('#closeExampleModalItemChildPriceList').attr('disabled', true);
    $('#saveExampleModalItemChildPriceList').attr('disabled', true);

    const file = this.files[0];

    const readFilePromise = new Promise((resolve, reject) => {
        if (file) {
            const reader = new FileReader();

            reader.onload = function (event) {
                const data = event.target.result;
                const workbook = XLSX.read(data, { type: 'binary' });
                const sheetName = workbook.SheetNames[0];
                const sheet = workbook.Sheets[sheetName];
                const jsonData = XLSX.utils.sheet_to_json(sheet, { header: 1 });

                resolve(jsonData);
            };

            reader.onerror = function (event) {
                reject([]);
            };

            reader.readAsBinaryString(file);
        } else {
            reject([]);
        }
    });

    let data_tmp = JSON.stringify(form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]);
    readFilePromise.then((jsonData) => {
        let count_column = jsonData[0].length - 1;
        form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'] = {};
        if ($('[name="price_list_tranport_type"]').val() == 1 && (jsonData[0][0] == "Địa chỉ" || jsonData[0][0] == "Đỹa chỰ")) {
            let data_tmp_parse = JSON.parse(data_tmp);
            for (let i = 0; i < count_column; i++) {
                form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][i] = {};
                form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][i]['cities'] = {};
                form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][i]['child_price_list_from_weight'] = jsonData[0][i + 1].split("-")[0];
                form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][i]['child_price_list_to_weight'] = jsonData[0][i + 1].split("-")[1];
                form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][i]['weight_range_flg'] = 1;
                for (var j = 1; j < jsonData.length; j++) {
                    if (data_tmp_parse['weight_range'][i] && data_tmp_parse['weight_range'][i]['cities'][j - 1] && data_tmp_parse['weight_range'][i]['cities'][j - 1]['city_id'] != jsonData[j][0].split("|")[0]) {
                        form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list] = JSON.parse(data_tmp);
                        $('#input_import_excel_price_list').val('');
                        showMessage({
                            title: 'Đã xảy ra lỗi!',
                            text: 'File excel này không cùng quốc gia với bảng giá này!',
                            icon: 'error',
                        });
                        $('#closeExampleModalItemChildPriceList').attr('disabled', false);
                        $('#saveExampleModalItemChildPriceList').attr('disabled', false);
                        return false;
                    }
                    form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][i]['cities'][j - 1] = {};
                    form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][i]['cities'][j - 1]['city_id'] = jsonData[j][0].split("|")[0];
                    form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][i]['cities'][j - 1]['city_name'] = jsonData[j][0].split("|")[1];
                    form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][i]['cities'][j - 1]['item_child_price_list_amount'] = jsonData[j][i + 1];
                }
            }
            setDisplayFormItemChildPriceListWithAreas();
        } else if ($('[name="price_list_tranport_type"]').val() == 0 && jsonData[0][0] == "Mức kg") {
            if (form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['sub_child_price_list_type'] == 0 && jsonData[0].length > 2) {
                form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list] = JSON.parse(data_tmp);
                $('#input_import_excel_price_list').val('');
                showMessage({
                    title: 'Đã xảy ra lỗi!',
                    text: 'File excel này không dùng cho với loại bảng giá này!',
                    icon: 'error',
                });
                $('#closeExampleModalItemChildPriceList').attr('disabled', false);
                $('#saveExampleModalItemChildPriceList').attr('disabled', false);
                return false;
            }
            for (var i = 0; i < count_column; i++) {
                form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][i] = {
                    title: jsonData[0][i + 1],
                    data: {},
                    sub_child_price_list_area: {}
                };
                for (var j = 1; j < jsonData.length; j++) {
                    if (form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][i]['data'][j - 1] == undefined) {
                        form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][i]['data'][j - 1] = {};
                    }
                    form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][i]['data'][j - 1]['item_child_price_list_amount'] = jsonData[j][i + 1];
                    jsonData[j][0] = `${jsonData[j][0]}`;
                    if (jsonData[j][0].indexOf('-') !== -1) {
                        form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][i]['data'][j - 1]['child_price_list_from_weight'] = jsonData[j][0].split("-")[0];
                        form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][i]['data'][j - 1]['child_price_list_to_weight'] = jsonData[j][0].split("-")[1];
                        form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][i]['data'][j - 1]['weight_range_flg'] = 1;
                    } else if (jsonData[j][0].indexOf('>') !== -1 && jsonData[j][0].indexOf('>=') === -1) {
                        form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][i]['data'][j - 1]['child_price_list_from_weight'] = 0;
                        form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][i]['data'][j - 1]['child_price_list_to_weight'] = jsonData[j][0].split(">")[1];
                        form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][i]['data'][j - 1]['weight_range_flg'] = 2;
                    } else if (jsonData[j][0].indexOf('>=') !== -1) {
                        form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][i]['data'][j - 1]['child_price_list_from_weight'] = 0;
                        form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][i]['data'][j - 1]['child_price_list_to_weight'] = jsonData[j][0].split(">=")[1];
                        form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][i]['data'][j - 1]['weight_range_flg'] = 3;
                    } else {
                        form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][i]['data'][j - 1]['child_price_list_from_weight'] = 0;
                        form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][i]['data'][j - 1]['child_price_list_to_weight'] = jsonData[j][0];
                        form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['weight_range'][i]['data'][j - 1]['weight_range_flg'] = 0;
                    }
                }
            }
            setDisplayFormItemChildPriceListWithService();
        } else {
            form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list] = JSON.parse(data_tmp);
            $('#input_import_excel_price_list').val('');
            showMessage({
                title: 'Đã xảy ra lỗi!',
                text: 'File excel này không dùng cho với loại bảng giá này!',
                icon: 'error',
            });
            $('#closeExampleModalItemChildPriceList').attr('disabled', false);
            $('#saveExampleModalItemChildPriceList').attr('disabled', false);
            return false;
        }
        $('#input_import_excel_price_list').val('');
        showMessage({
            title: 'Thành công!',
            text: 'Tải file excel lên thành công, xin hãy kiểm tra trước khi lưu!',
            icon: 'success',
        });
        $('#closeExampleModalItemChildPriceList').attr('disabled', false);
        $('#saveExampleModalItemChildPriceList').attr('disabled', false);
    }).catch((error) => {
        form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list] = JSON.parse(data_tmp);
        $('#input_import_excel_price_list').val('');
        showMessage({
            title: 'Đã xảy ra lỗi!',
            text: 'Tải file excel lên thất bại!',
            icon: 'error',
        });
        $('#closeExampleModalItemChildPriceList').attr('disabled', false);
        $('#saveExampleModalItemChildPriceList').attr('disabled', false);
    });
});
//Cài đặt Bảng Giá  

// Xóa hoàn toàn tài khoản chờ xét duyệt
async function onDeleteUser(id) {
    const onDelete = async () => {
        let _url = window.location.origin + '/manages/admin/system/wait-users/delete';
        let _data = {
            id: id
        }
        let res = await sendRequest(_url, 'POST', _data);
        if (res.status == 200) {
            Swal.fire({
                title: "Deleted!",
                text: "Xóa đối tượng thành công.",
                icon: "success"
            });
            onPagination(`${show_page_url}`);
        } else {
            Swal.fire({
                title: "Error!",
                text: res.message,
                icon: "error"
            });
        }
    }
    let alert = {
        title: "Thông báo?",
        text: "Bạn có chắc chắn xóa tài khoản này không!",
        icon: "warning",
    }
    onConfirmAction(alert, onDelete)
}

//Chỉnh sửa Điều Khoản
async function onEditTermsInterface() {
    let event = {
        title: 'Xác nhận hành vi!',
        text: `Bạn có chắc muốn lưu lại điều khoản!`,
        icon: 'question',
        type: 'agreeEditTermsInterface',
        data: {
            is_api: false,
            content: editor_terms_interface.getData()
        }
    };
    confirmEvent(event);
}

async function agreeEditTermsInterface(data) {
    $('#on_edit_terms_interface').attr('disabled', true);
    try {
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/terms-interface/handle`, 'POST', data);
        showMessage(result.message);
        $('#on_edit_terms_interface').attr('disabled', false);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
        $('#on_edit_terms_interface').attr('disabled', false);
    }
}
//Chỉnh sửa Điều Khoản

// Chỉnh sửa thông tin debit

var countNoteDebit = null;
function onPlusDebitInfo(type) {
    if (countNoteDebit === null) {
        countNoteDebit = $('input[name^="footer.note."]').length;
    }
    countNoteDebit++;
    $('#debit_' + type).append(`<div class="input-group mb-3" id="footer_${type}_${countNoteDebit}">
                                        <button class="btn btn-danger" onclick="onRemoveDebitInfo('${type}', ${countNoteDebit})" type="button"><i
                                                class="fa fa-times"></i></button>
                                        <input type="text" class="form-control"
                                            name="footer.${type}.${countNoteDebit}" placeholder=""
                                            value="" required>
                                    </div>`);
}
function onRemoveDebitInfo(type, index) {
    console.log(`#footer.${type}.${index}`);

    $(`#footer_${type}_${index}`).remove();
}

$('#info_excel').on('submit', function (e) {
    e.preventDefault();
})
function getDebitExcelInfo() {
    return new Promise((resolve, reject) => {
        try {
            var header = [];
            var footerNote = [];
            var hn = [];
            var hcm = [];
            var dn = [];

            $('input[name^="header."]').each(function () {
                header.push($(this).val());
            });

            $('input[name^="footer.note."]').each(function () {
                footerNote.push($(this).val());
            });

            $('input[name^="footer.hn."]').each(function () {
                hn.push($(this).val());
            });

            $('input[name^="footer.hcm."]').each(function () {
                hcm.push($(this).val());
            });

            $('input[name^="footer.dn."]').each(function () {
                dn.push($(this).val());
            });

            resolve({
                header: header,
                footer: {
                    note: footerNote,
                    hn: hn,
                    hcm: hcm,
                    dn: dn,
                }
            });
        } catch (error) {
            reject(null);
        }
    });
}

async function onEditInfoDebit() {
    Swal.fire({
        title: "Thông báo",
        text: 'Bạn có chắc muốn cập nhật thông tin debit không',
        icon: "question",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Xác nhận",
        cancelButtonText: "Hủy",
    }).then(async (result) => {
        if (result.isConfirmed) {
            try {
                $('#on_edit_info_debit').attr('disabled', true);

                let url = window.location.origin + '/manages/admin/system/info-debit/handle';
                let data = {
                    is_api: false,
                    content: editor_info_debit.getData(),
                    excels: await getDebitExcelInfo()
                }

                const result = await sendRequest(url, 'POST', data);
                showMessage(result.message);
                $('#on_edit_info_debit').attr('disabled', false);
            } catch (error) {
                if (error.status != 422) {
                    showMessage(error.message);
                }
                $('#on_edit_info_debit').attr('disabled', false);
            }
        }
    });

}

//Chi phí vận hành công ty
function addOperatingCost() {
    let last_key = Object.keys(operating_costs).length;
    operating_costs[last_key] = {
        operating_cost_name: '',
        operating_cost_description: '',
        operating_cost_type: 0,
        operating_cost_package_number_flg: 0,
        child_operating_cost: {
            0: {
                operating_cost_default_flg: 0,
                operating_cost_name: '',
                operating_cost_amount: 0,
            }
        }
    };
    setDisplayOperatingCost();
}

function setDisplayOperatingCost() {
    $('#form_operating_costs').html('');
    operating_costs = Object.values(operating_costs);
    $.each(operating_costs, function (key, operating_cost) {
        $('#form_operating_costs').append(`
            <div class="col-sm-6 mb-3">
                <div class="card card-wth-line">
                    <div class="card-line bg-primary"></div>
                    <div class="card-body">
                        <div class="col-sm-12 mb-3">
                            <input type="text" name="operating_costs.${key}.operating_cost_name" class="form-control" placeholder="Nhập tiêu đề"
                                    value="${operating_cost['operating_cost_name']}">
                        </div>
                        <div class="col-sm-12 mb-3">
                            <input type="text" name="operating_costs.${key}.operating_cost_description" class="form-control" placeholder="Nhập mô tả"
                                    value="${operating_cost['operating_cost_description'] ? operating_cost['operating_cost_description'] : ''}">
                        </div>
                        <div class="row mb-3">
                            <div class="col-sm-6">
                                <div class="input-group">
                                    <span class="input-group-text">Loại</span>
                                    <select class="form-select" name="operating_costs.${key}.operating_cost_type">
                                        <option value="0" ${operating_cost['operating_cost_type'] == 0 ? 'selected' : ''}>Chọn 1</option>
                                        <option value="1" ${operating_cost['operating_cost_type'] == 1 ? 'selected' : ''}>Chọn nhiều</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="chip chip-secondary h-100">
                                    <input type="checkbox" name="operating_costs.${key}.operating_cost_package_number_flg" ${operating_cost['operating_cost_package_number_flg'] == 1 ? 'checked' : ''}>
                                    <span class="h-100"><span class="chip-text">Theo kiện hàng</span></span>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                                <button class="btn btn-success w-100" onclick="addChildOperatingCost(${key})">
                                    <span>Thêm chi phí</span>
                                </button>
                            </div>
                            <div class="col-sm-6">
                                <button class="btn btn-danger w-100" onclick="deleteOperatingCost(${key})">
                                    <span>Xóa</span>
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer d-flex flex-column" id="form_child_operating_cost_${key}"></div>
                </div>
            </div>
        `);
        setDisplayChildOperatingCost(operating_cost['child_operating_cost'], key);
    });
}

function setDisplayChildOperatingCost(child_operating_cost, key_operating_cost) {
    $(`#form_child_operating_cost_${key_operating_cost}`).html('');
    $.each(child_operating_cost, function (key, child) {
        $(`#form_child_operating_cost_${key_operating_cost}`).append(`
            <div class="col-sm-12 mb-3">
                <div class="input-group">
                    <div class="chip chip-primary input-group-text">
                        <input type="checkbox" name="operating_costs.${key_operating_cost}.child_operating_cost.${key}.operating_cost_default_flg" ${child['operating_cost_default_flg'] == 1 ? 'checked' : ''}>
                        <span><span class="chip-text">Tự động tính</span></span>
                    </div>
                    <input type="text" class="form-control" placeholder="Tên chi phí" name="operating_costs.${key_operating_cost}.child_operating_cost.${key}.operating_cost_name"
                            value="${child['operating_cost_name']}">
                    <input type="text" class="form-control" placeholder="Nhập số tiền" name="operating_costs.${key_operating_cost}.child_operating_cost.${key}.operating_cost_amount"
                            value="${formatNumberThousand(child['operating_cost_amount'])}">
                    <div class="input-group-text">
                        <button class="btn btn-sm btn-danger" onclick="deleteChildOperatingCost(${key_operating_cost}, ${key})">
                            <i class="fa fa-trash"></i>
                        </button>
                    </div>
                </div>
            </div>
        `);
    })
}

function addChildOperatingCost(key_operating_cost) {
    let last_key = Object.keys(operating_costs[key_operating_cost]['child_operating_cost']).length;
    operating_costs[key_operating_cost]['child_operating_cost'][last_key] = {
        operating_cost_default_flg: 0,
        operating_cost_name: '',
        operating_cost_amount: 0
    };
    setDisplayChildOperatingCost(operating_costs[key_operating_cost]['child_operating_cost'], key_operating_cost);
}

function deleteOperatingCost(key_operating_cost) {
    if (operating_costs.hasOwnProperty(key_operating_cost)) {
        delete operating_costs[key_operating_cost];
        setDisplayOperatingCost();
    }
}

function deleteChildOperatingCost(key_operating_cost, key_child_operating_cost) {
    if (operating_costs[key_operating_cost]['child_operating_cost'].hasOwnProperty(key_child_operating_cost)) {
        delete operating_costs[key_operating_cost]['child_operating_cost'][key_child_operating_cost];
        setDisplayChildOperatingCost(operating_costs[key_operating_cost]['child_operating_cost'], key_operating_cost);
    }
}

$('body').on('change', '[name^="operating_costs"]', async function () {
    let value = $(this).val();
    let input_name = $(this).attr('name');
    var parts = input_name.split('.');
    var last_part = parts[parts.length - 1];
    let key_operating_cost = parts[1];
    if (last_part == 'operating_cost_amount') {
        value = `${convertStringToNumber(value)}`;
        $(`[name="${input_name}"]`).val(formatNumber(value));
    }
    if (last_part == 'operating_cost_package_number_flg') {
        value = $(this).is(':checked') ? 1 : 0;
    }
    if (last_part == 'operating_cost_default_flg') {
        let value_tmp = $(this).is(':checked') ? 1 : 0;
        if (operating_costs[key_operating_cost]['operating_cost_type'] == 0) {
            await $.each(operating_costs[key_operating_cost]['child_operating_cost'], function (key, child) {
                operating_costs[key_operating_cost]['child_operating_cost'][key]['operating_cost_default_flg'] = 0;
                $(`[name="operating_costs.${key_operating_cost}.child_operating_cost.${key}.operating_cost_default_flg"]`).prop('checked', false);
            });
        }
        $(`[name="${input_name}`).prop('checked', value_tmp == 1 ? true : false);
        value = $(`[name="${input_name}`).is(':checked') ? 1 : 0;
    }
    if (last_part == 'operating_cost_type') {
        if (value == 0) {
            $.each(operating_costs[key_operating_cost]['child_operating_cost'], function (key, child) {
                operating_costs[key_operating_cost]['child_operating_cost'][key]['operating_cost_default_flg'] = 0;
                $(`[name="operating_costs.${key_operating_cost}.child_operating_cost.${key}.operating_cost_default_flg"]`).prop('checked', false);
            });
        }
    }
    input_name = input_name.replace('operating_costs.', '');
    operating_costs = setData(operating_costs, input_name, value);
});

function onSaveOperatingCosts() {
    let event = {
        title: 'Xác nhận hành vi!',
        text: `Bạn có chắc muốn lưu lại các thay đổi của chi phí vận hành công ty!`,
        icon: 'question',
        type: 'agreeSaveOperatingCosts',
        data: {
            is_api: false,
            operating_costs: operating_costs,
        }
    };
    confirmEvent(event);
}

async function agreeSaveOperatingCosts(data) {
    $(`#on_save_operating_costs`).attr('disabled', false);
    try {
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/operating-cost/handle`, 'POST', data);
        if (result.status == 200) {
            operating_costs = Object.assign({}, result.operating_costs);
        }
        showMessage(result.message);
        $(`#on_save_operating_costs`).attr('disabled', false);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
        $(`#on_save_operating_costs`).attr('disabled', false);
    }
}
//Chi phí vận hành công ty


$(document).ready(function () {

})

function onShowDisplayService(key) {

    // $('#error_user_price_list_main_type_child').remove()
    $('.display-select').addClass('d-none');
    $('.display-select').removeClass('d-block');
    $('#display-select-' + key).removeClass('d-none');
    $('#display-select-' + key).addClass('d-block');
    // $('#display-select-' + key).append('<small id="error_user_price_list_main_type_child" class="text-danger"></small>')


}

function getCheckedService(key) {
    var checkedRadios = $(`#display-select-${key} input[type="radio"]:checked`);

    var values = checkedRadios.map(function () {
        return $(this).val();
    }).get();

    return values;
}


async function btnVnpay(params) {
    try {
        onLoadingIcon('.btn-vnpay', true, 'Xác nhận')
        let url = window.location.origin + '/manages/admin/system/infomation-vnpay/action'

        let data = {
            kind: params,
            password: $('#check-password').val() ? $('#check-password').val() : null,
            // hash_secret: $('#hash_secret').val() ? $('#hash_secret').val() : null,
            // tmn_code: $('#tmn_code').val() ? $('#tmn_code').val() : null,
            token_payment: $('#token_payment').val() ? $('#token_payment').val() : null,
            match_pattern: $('#match_pattern').val() ? $('#match_pattern').val() : null,
        }

        let res = await ajaxContants2(url, 'POST', data);

        if (res.status == 200) {
            if (params == "checked") {
                $('#content-finished').html(res.html);
                $('#content-check').addClass('d-none');
            } else if (params == "update") {

            }
        }
        showMessage(res.message);
        onLoadingIcon('.btn-vnpay', false, 'Xác nhận')
    } catch (error) {
        showMessage(error.message);
        onLoadingIcon('.btn-vnpay', false, 'Xác nhận')

    }
}
offcanvasVNPay.addEventListener('shown.bs.offcanvas', function () {
    $('#content-finished').html('');
    $('#content-check').removeClass('d-none');
    $('#check-password').val('');
});

offcanvasVNPay.addEventListener('hide.bs.offcanvas', function () {
    $('#content-finished').html('');
    $('#content-check').removeClass('d-none');
});

offcanvasVNPay.addEventListener('hidden.bs.offcanvas', function () {
    $('#content-finished').html('');
    $('#content-check').removeClass('d-none');
});

function checkLocation(lat, log) {
    if (!lat || !log) {
        return false;
    }
    if (lat == 0 && log == 0) {
        return false;
    }
    if (lat == "" && log == "") {
        return false;
    }
    return true;
}

$(document).on('change', '[name="associate_with_service_keywords"]', function () {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    page = 1;
    filters.keywords = $(this).val();
    onPagination(`${show_page_url}/pagination`);
});

async function saveAssociateWithServices() {
    $('#save_associate_with_service').attr('disabled', true);
    try {
        let associate_with_service_apis = {};
        $.each($('.select_multiple_api_labels'), function (key, value) {
            associate_with_service_apis[value.id] = $(value).val();
        });
        let data = {
            is_api: false,
            associate_with_service_apis: associate_with_service_apis,
        };

        const result = await sendRequest(`${window.location.origin}/manages/admin/system/associate-with-service/update`, 'POST', data);

        if (result.status == 200) {
            onPagination(`${show_page_url}/pagination`);
        }

        showMessage(result.message);
        $('#save_associate_with_service').attr('disabled', false);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
        $('#save_associate_with_service').attr('disabled', false);
    }
}

$(document).on('click', '#btn_upload_weight_conversion', async function () {
    $('#btn_upload_weight_conversion').attr('disabled', true);
    try {
        const file = $('#upload_weight_conversion')[0].files[0];
        const reader = new FileReader();
        let formData = {};

        reader.onload = async function (e) {
            const data = await e.target.result;
            const workbook = await XLSX.read(data, { type: 'binary' });
            const sheetName = await workbook.SheetNames[0];
            const sheet = await workbook.Sheets[sheetName];
            const jsonData = await XLSX.utils.sheet_to_json(sheet, { header: 1 });

            formData['weight-conversion'] = JSON.stringify(jsonData);
            const result = await sendRequest(`${window.location.origin}/manages/admin/system/weight-conversion/upload`, 'POST', formData);

            showMessage(result.message);
            $('#upload_weight_conversion').val('');
            $('#modal_upload_weight_conversion').modal('hide');
        };
        reader.readAsBinaryString(file);
    } catch (error) {
        showMessage(error.message);
    }
    $('#btn_upload_weight_conversion').attr('disabled', false);
});

$(document).on('click', '.download-weight-conversion', async function () {
    $(this).attr('disabled', true);
    try {
        const service_id = $(this).data('service_id');
        const service_name = $(this).data('service_name');
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/weight-conversion/download`, 'POST', { service_id: service_id });

        if (result.data.length > 0) {
            let convert_data = [];

            $.each(result.data, function (index, item) {
                convert_data.push({
                    'Mức Kg': item.initial_weight,
                    [service_name]: item.weight_conversion + '' + item.weight_unit
                });
            });

            const worksheet = XLSX.utils.json_to_sheet(convert_data);

            const workbook = XLSX.utils.book_new();
            XLSX.utils.book_append_sheet(workbook, worksheet, `${service_name}`);

            XLSX.writeFile(workbook, `weight_conversion_${service_name}.xlsx`);
        } else {
            showMessage({
                title: 'Thông báo',
                text: 'Không có dữ liệu để xuất file!',
                icon: 'error'
            });
        }
    } catch (error) {
        showMessage(error.message);
    }
    $(this).attr('disabled', false);
});

function setDisplaySelect2Sidebar(type, route) {
    var safeRoute = route.replace(/\./g, '\\.');
    if (type == 1) {
        $('#display_user_' + safeRoute).removeClass('d-none').addClass('d-block');
        $('#display_position_' + safeRoute).removeClass('d-block').addClass('d-none');
    } else {
        $('#display_position_' + safeRoute).removeClass('d-none').addClass('d-block');
        $('#display_user_' + safeRoute).removeClass('d-block').addClass('d-none');
    }
}

async function saveSystemSidebarsSettings() {
    $('#save_system_sidebars_settings').attr("disabled", true);
    $('#save_system_sidebars_settings').html(iconLoadingHtml());
    try {
        if (pub_route_sidebars.length < 1) {
            showMessage({
                icon: 'error',
                title: 'Thông báo',
                text: 'Xảy ra lỗi khi cố gọi đến serve'
            });
        }

        let url = window.location.origin + '/manages/admin/system/menu-settings/handle';

        let data = {};

        pub_route_sidebars.forEach((key, index) => {
            data[key] = {
                is_all: $(`[name="${key}_is_all"]`).prop('checked') ? true : false,
                user_ids: $(`[name="${key}_user_ids"]`).val(),
                position_ids: $(`[name="${key}_position_ids"]`).val(),
            };
        });

        let res = await ajaxContants2(url, 'POST', data);
        showMessage(res.message);
        $('#save_system_sidebars_settings').attr("disabled", false);
        $('#save_system_sidebars_settings').html('Lưu lại những thay đổi');

    } catch (error) {
        showMessage({
            icon: 'error',
            title: 'Thông báo',
            text: 'Xảy ra lỗi khi cố gọi đến serve'
        });
        $('#save_system_sidebars_settings').attr("disabled", false);
        $('#save_system_sidebars_settings').html('Lưu lại những thay đổi');
    }
}

async function saveSystemMenuSaleSettings() {
    $('#save_system_sidebars_settings').attr("disabled", true);
    $('#save_system_sidebars_settings').html(iconLoadingHtml());
    try {
        if (pub_route_sidebars.length < 1) {
            showMessage({
                icon: 'error',
                title: 'Thông báo',
                text: 'Xảy ra lỗi khi cố gọi đến serve'
            });
        }

        let url = window.location.origin + '/manages/admin/system/menu-sale/handle';

        let data = {};

        pub_route_sidebars.forEach((key, index) => {
            data[key] = {
                // is_all: $(`[name="${key}_is_all"]`).prop('checked') ? true : false,
                // user_ids: $(`[name="${key}_user_ids"]`).val(),
                position_ids: $(`[name="sale_${key}_position_ids"]`).val(),
            };
        });

        let res = await ajaxContants2(url, 'POST', data);
        showMessage(res.message);
        $('#save_system_sidebars_settings').attr("disabled", false);
        $('#save_system_sidebars_settings').html('Lưu lại những thay đổi');

    } catch (error) {
        showMessage({
            icon: 'error',
            title: 'Thông báo',
            text: 'Xảy ra lỗi khi cố gọi đến serve'
        });
        $('#save_system_sidebars_settings').attr("disabled", false);
        $('#save_system_sidebars_settings').html('Lưu lại những thay đổi');
    }
}

//Hiển thị giao diện quản lý hình ảnh liên quan
$(document).on('click', '#save_system_settings_images_of_web', async function () {
    $(this).attr('disabled', true);
    try {
        let data = new FormData();
        data.append('is_api', false);
        data.append('image_login', $('[name="image_login"]')[0]['files'][0]);

        const result = await sendRequest(`${window.location.origin}/manages/admin/system/images-of-web/handle`, 'POST', data, true);

        showMessage(result.message);
        $(this).attr('disabled', false);
    } catch (error) {
        if (error.status == 422) {
            showMessage({
                'title': 'Cảnh báo!',
                'text': 'Không được để trống dữ liệu.',
                'icon': 'warning'
            });
        } else {
            showMessage(result.message);
        }
        $(this).attr('disabled', false);
    }
});

// Setting Import Excel Bảng Giá
var price_list_zone = {};

function onLoadPageSettingImportExcelPriceList() {
    startLoadingOffcanvasRightMangeAdminSystemBody();
    onShowPageManageAdminSystem();
    refreshIds();
}

async function onLoadPageCreateSettingImportExcelPriceList() {
    startLoadingOffcanvasRightMangeAdminSystemBody();
    try {
        let data = {
            is_api: false,
        };
        const result = await sendRequest(
            `${window.location.origin}/manages/admin/system/price-list/setting-import-excel/create/display`,
            "POST",
            data
        );
        if (result.status == 200) {
            $("#offcanvasRightMangeAdminSystemBody").html(result.html);
        }
        closeLoadingOffcanvasRightMangeAdminSystemBody();
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
        closeLoadingOffcanvasRightMangeAdminSystemBody();
    }
}

$(document).on('change', '#price_list_zone_type', function () {
    $('#accordionFormSettingExcelPriceList').html(`
        <div class="alert alert-danger">
            <div class="alert-message">
                <strong>Lưu ý!</strong>
                <p>
                    - Bạn cần nhập đúng thông tin zone theo mẫu excel để import thành công.
                </p>
                <p>
                    - Đối với loại bảng giá theo post code nếu không có trong hệ thống, hệ thống sẽ tự động tạo mới zone.
                </p>
            </div>
        </div>
    `);

    $('#price_list_zone_excel_file').val('');

    const value = $(this).val();

    if (value != 1) {
        $('#form_choose_country_id').html(`
            <div class="form-group">
                <label class="form-label">Chọn quốc gia *</label>
                <select class="form-select select2" id="price_list_zone_country_id">
                    <option value="" selected>Chọn quốc gia</option>
                    ${priceListZoneCountries.map((country) => {
            return `<option value="${country.country_id}">
                            ${country.country_name} - ${country.country_code}
                        </option>`;
        }).join('')}
                </select>
            </div>
        `);

        $('#price_list_zone_country_id').select2({
            dropdownParent: $(this).parent()
        });
    } else {
        $('#form_choose_country_id').html('');
    }
});

$(document).on('change', '#price_list_zone_excel_file', async function () {
    if ($('#price_list_zone_country_id').val() == '') {
        showMessage({
            title: 'Cảnh báo!',
            text: 'Vui lòng chọn quốc gia trước khi chọn file excel.',
            icon: 'warning'
        });

        $(this).val('');
        return false;
    }

    $('#price_list_zone_excel_file').attr('disabled', true);
    $('#create_new_price_list_setting').attr('disabled', true);
    $('#btn_edit_price_list_setting_import_excel').attr('disabled', true);

    const file = this.files[0];
    const reader = new FileReader();
    reader.onload = async function (e) {
        const data = await e.target.result;
        const workbook = await XLSX.read(data, { type: 'binary' });
        const sheetName = await workbook.SheetNames[0];
        const sheet = await workbook.Sheets[sheetName];
        const jsonData = XLSX.utils.sheet_to_json(sheet, { header: 1 });

        await setDisplaySettingImportExcelPriceList(jsonData, true);

        $('#price_list_zone_excel_file').attr('disabled', false);
        $('#create_new_price_list_setting').attr('disabled', false);
        $('#btn_edit_price_list_setting_import_excel').attr('disabled', false);
    };

    reader.readAsBinaryString(file);
});

async function setDisplaySettingImportExcelPriceList(data, is_edit = false) {
    try {
        if (is_edit) {
            price_list_zone['service_ids'] = $('#price_list_zone_service_ids').val();
            price_list_zone['country_id'] = $('#price_list_zone_country_id').val();
            price_list_zone['price_list_zone_type'] = $('#price_list_zone_type').val();
            price_list_zone['data'] = [];

            if (price_list_zone['price_list_zone_type'] == 4) {
                $.each(data, function (index, item) {
                    if (index > 0) {
                        price_list_zone['data'].push({
                            postcode: item[0] ?? '',
                            zone: item[1] ?? '',
                            town: item[2] ?? '',
                            state: item[3] ?? '',
                        });
                    }
                });
            } else {
                const count_column = data[0].length;

                for (let i = 0; i < count_column; i++) {
                    price_list_zone['data'][i] = {
                        title: data[0][i],
                        zone: [],
                    };

                    for (let j = 1; j < data.length; j++) {
                        if (data[j][i]) {
                            const explode_zone = data[j][i].split('-');
                            price_list_zone['data'][i]['zone'].push({
                                name: explode_zone[0] ?? '',
                                code: explode_zone[1] ?? '',
                            });
                        }
                    }
                }
            }
            price_list_zone['price_list_zone_type'] = parseInt(price_list_zone['price_list_zone_type']);
            data = price_list_zone;
        }

        if ([1, 2, 3].includes(data['price_list_zone_type'])) {
            $('#accordionFormSettingExcelPriceList').html(`<div class="row" id="contentSettingExcelPriceList"></div>`);
            $.each(data['data'], function (index, item) {
                $('#contentSettingExcelPriceList').append(`
                    <div class="col-sm-3 mb-3">
                        <div class="card">
                            <div class="p-1">
                                <div class="fs-5 text-dark fw-bold text-center mb-2">
                                    ${item['title'] ?? ''}
                                </div>
                                <div class="table-responsive">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th scope="col">#</th>
                                                <th scope="col">
                                                    ${data['price_list_zone_type'] == 1 ? 'Tên quốc gia' : data['price_list_zone_type'] == 2 ? 'Tên tiểu bang' : 'Tên thành phố'}
                                                </th>
                                                <th scope="col">Code</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            ${item['zone'].map((i, key) => {
                    return `
                                                    <tr>
                                                        <th scope="row">${key + 1}</th>
                                                        <td>${i['name'] ?? ''}</td>
                                                        <td>${i['code'] ?? ''}</td>
                                                    </tr>
                                                `;
                }).join('')}
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>    
                `);
            });
        } else if (data['price_list_zone_type'] == 4) {
            $('#accordionFormSettingExcelPriceList').html(`
                <div class="row">
                    <div class="col-sm-8">
                        <div class="fs-5 text-dark fw-bold text-center">
                            ${price_list_zone['service_name'] ?? ''} Remote
                        </div>
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">Postcode</th>
                                        <th scope="col">Zone</th>
                                        <th scope="col">Town</th>
                                        <th scope="col">State</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    ${data['data'].map((item, index) => {
                return `
                                            <tr>
                                                <th scope="row">${index + 1}</th>
                                                <td>${item['postcode'] ?? ''}</td>
                                                <td>${item['zone'] ?? ''}</td>
                                                <td>${item['town'] ?? ''}</td>
                                                <td>${item['state'] ?? ''}</td>
                                            </tr>
                                        `;
            }).join('')}
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="fs-5 text-dark fw-bold text-center">
                            ${price_list_zone['service_name'] ?? ''} Metro
                        </div>
                        <div class="alert alert-warning">
                            <div class="alert-message">
                                <strong>Các post code còn lại sẽ được tính là metro</strong>
                            </div>
                        </div>
                    </div>
                </div>
            `);
        }
    } catch (error) {
        $('#price_list_zone_excel_file').attr('disabled', false);
        $('#create_new_price_list_setting').attr('disabled', false);
        $('#btn_edit_price_list_setting_import_excel').attr('disabled', false);
        showMessage({
            title: 'Đã xảy ra lỗi!',
            text: 'File excel này không đúng định dạng!',
            icon: 'error',
        });
    }
}

async function onCreatePriceListSettingImportExcel() {
    $('#create_new_price_list_setting').attr('disabled', true);
    try {
        price_list_zone['service_ids'] = $('#price_list_zone_service_ids').val();
        price_list_zone['price_list_zone_type'] = $('#price_list_zone_type').val();
        price_list_zone['country_id'] = $('#price_list_zone_country_id').val();

        let data = {
            is_api: false,
            price_list_zone: JSON.stringify(price_list_zone),
        };

        const result = await sendRequest(
            `${window.location.origin}/manages/admin/system/price-list/setting-import-excel/create/handle`,
            "POST",
            data
        );

        onShowPageManageAdminSystem();
        showMessage(result.message);
    } catch (error) {
        showMessage(error.message);
    }
    $('#create_new_price_list_setting').attr('disabled', false);
}

async function onLoadPageEditSettingImportExcelPriceList(price_list_zone_id) {
    startLoadingOffcanvasRightMangeAdminSystemBody();
    try {
        let data = {
            is_api: false,
            price_list_zone_id: price_list_zone_id,
        };
        const result = await sendRequest(
            `${window.location.origin}/manages/admin/system/price-list/setting-import-excel/edit/display`,
            "POST",
            data
        );

        if (result.price_list_zone.price_list_zone_type == 4) {
            price_list_zone = result.price_list_zone;
            price_list_zone['service_name'] = result.service_name;
            price_list_zone['data'] = price_list_zone['data'][0]['zone'];
        } else {
            price_list_zone = result.price_list_zone;
        }

        $("#offcanvasRightMangeAdminSystemBody").html(result.html);
        $('#price_list_zone_type').val(price_list_zone['price_list_zone_type']).trigger('change');
        $('#price_list_zone_service_id').val(price_list_zone['service_id']).trigger('change');
        $('#price_list_zone_country_id').val(price_list_zone['country_id']).trigger('change');
        setDisplaySettingImportExcelPriceList(price_list_zone);
        closeLoadingOffcanvasRightMangeAdminSystemBody();
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
        closeLoadingOffcanvasRightMangeAdminSystemBody();
    }
}

$(document).on('click', '#btn_edit_price_list_setting_import_excel', async function () {
    $('#btn_edit_price_list_setting_import_excel').attr('disabled', true);
    try {
        let data = {
            is_api: false,
            service_id: $('#price_list_zone_service_id').val(),
            price_list_zone: JSON.stringify(price_list_zone),
        };

        const result = await sendRequest(
            `${window.location.origin}/manages/admin/system/price-list/setting-import-excel/edit/handle`,
            "POST",
            data
        );

        onShowPageManageAdminSystem();
        showMessage(result.message);
    } catch (error) {
        showMessage(error.message);
    }
    $('#btn_edit_price_list_setting_import_excel').attr('disabled', false);
});

function onDeleteSettingImportExcelPriceList(price_list_zone_id) {
    let event = {
        title: 'Xác nhận hành vi!',
        text: `Bạn có chắc muốn xóa cài đặt import excel bảng giá này!`,
        icon: 'question',
        type: 'agreeDeleteSettingImportExcelPriceList',
        data: {
            is_api: false,
            price_list_zone_id: price_list_zone_id,
        }
    };
    confirmEvent(event);
}

async function agreeDeleteSettingImportExcelPriceList(data) {
    try {
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/price-list/setting-import-excel/delete`, 'POST', data);
        onPagination(`${show_page_url}/pagination`);
        showMessage(result.message);
    } catch (error) {
        showMessage(error.message);
    }
}
// Setting Import Excel Bảng Giá

// Danh sách remote
var town_id = null;

$(document).on('change', '#remote_country_id', async function () {
    await getStatesByCountry('remote_state_id', $('#remote_country_id').val());
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    page = 1;
    filters.country_id = $('#remote_country_id').val();
    onPagination(`${show_page_url}/pagination`);
});

$(document).on('change', '#remote_state_id', function () {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    page = 1;
    filters.state_id = $('#remote_state_id').val();
    onPagination(`${show_page_url}/pagination`);
});

$(document).on('change', '[name="remote_keywords"]', function () {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    page = 1;
    filters.keywords = $('[name="remote_keywords"]').val();
    onPagination(`${show_page_url}/pagination`);
});

async function onEditRemote(id) {
    try {
        town_id = id;
        let data = {
            town_id: id,
        };

        const result = await sendRequest(`${window.location.origin}/manages/admin/system/remote/detail`, 'POST', data);

        $('#country_id').val(result.town.country_id).trigger('change');
        $('#service_id').val(result.town.service_id).trigger('change');
        setTimeout(() => {
            $('#state_id').val(result.town.state_id).trigger('change');
        }, 1000);
        $('[name="town_name"]').val(result.town.town_name);
        $('[name="town_postal_code"]').val(result.town.town_postal_code);
        $('[name="town_zone_code"]').val(result.town.town_zone_code);
    } catch (error) {
        showMessage(error.message);
    }
}

async function saveRemote() {
    $('#save_remote').attr('disabled', true);
    try {
        let data = {
            town_id: town_id,
            country_id: $('#country_id').val(),
            service_id: $('#service_id').val(),
            state_id: $('#state_id').val(),
            town_name: $('[name="town_name"]').val(),
            town_postal_code: $('[name="town_postal_code"]').val(),
            town_zone_code: $('[name="town_zone_code"]').val(),
        };

        const result = await sendRequest(`${window.location.origin}/manages/admin/system/remote/update`, 'POST', data);

        $('#country_id').val('').trigger('change');
        $('#service_id').val('').trigger('change');
        $('#state_id').val('').trigger('change');
        $('[name="town_name"]').val('');
        $('[name="town_postal_code"]').val('');
        $('[name="town_zone_code"]').val('');

        onPagination(`${show_page_url}/pagination`);
        showMessage(result.message);
    } catch (error) {
        showMessage(error.message);
    }
    $('#save_remote').attr('disabled', false);
}

async function onDeleteRemote(town_id) {
    let event = {
        title: 'Xác nhận hành vi!',
        text: `Bạn có chắc muốn xóa remote này!`,
        icon: 'question',
        type: 'agreeDeleteRemote',
        data: {
            is_api: false,
            town_id: town_id,
        }
    };
    confirmEvent(event);
}

async function agreeDeleteRemote(data) {
    try {
        const result = await sendRequest(`${window.location.origin}/manages/admin/system/remote/delete`, 'POST', data);
        onPagination(`${show_page_url}/pagination`);
        showMessage(result.message);
    } catch (error) {
        showMessage(error.message);
    }
}

async function onReportSaleExcel() {

    const data = {
        is_api: false,
        limit: limit,
        page: page,
        filters: JSON.stringify(Object.assign({}, filters)),
    }
    const url = `${show_page_url}/pagination`;
    const btn = '#btn_report_excel_sale';
    const fileName = 'ReportSale.xlsx';
    // fetchExportExcel(url, data, btn, fileName)

    try {
        onBtnLoading(btn, true)
        if (typeof data.export_excel === 'undefined') {
            data.export_excel = true;
        }
        const response = await fetch(url, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify(data)
        });

        if (response.ok) {
            const blob = await response.blob(); // Chuyển kết quả sang dạng blob
            const link = document.createElement('a');
            link.href = window.URL.createObjectURL(blob);
            link.download = fileName; // Tên file tải về
            link.click(); // Tự động tải file
        } else {
            showMessage({
                icon: 'error',
                text: 'Xuất file excel thất bại'
            })
        }
        onBtnLoading(btn, false, '<i class="fas fa-file-excel"></i>')
    } catch (error) {
        console.log(error);

        onBtnLoading(btn, false, '<i class="fas fa-file-excel"></i>')
        showMessage()

    }
}

function emptyValiAmountOriginShipment() {
    $('#shipment_code_err').html('');
    $('#set_amount_err').html('');
}

async function onCreateAmountOriginShipment() {
    onBtnLoading('#add_amount_origin', true);
    emptyValiAmountOriginShipment()
    try {
        let url = window.location.origin + '/manages/admin/system/set-amount-origin-shipment/handle';
        let data = {
            shipment_code: $('#shipment_code').val(),
            set_amount: convertStringToNumber($('#set_amount').val()),
        }

        let res = await ajaxContants2(url, 'POST', data);
        if (res.status == 422) {
            errors = res.error;
            $.each(errors, function (key, value) {
                $('#' + key + '_err').html(value[0]);
            });
            showMessage({ text: 'Vui lòng kiểm tra dữ liệu nhập vào' })
        } else {
            $('#shipment_code').val('');
            $('#set_amount').val(0);
            showMessage(res.message)
            onPagination(`${show_page_url}/pagination`);
        }

        onBtnLoading('#add_amount_origin', false);
    } catch (error) {
        onBtnLoading('#add_amount_origin', false);
    }

}

async function onDeleteAmountOriginShipment(params) {

    Swal.fire({
        title: "Thông báo",
        text: 'Bạn có chắc chắn muốn xóa áp giá của đơn ' + params,
        icon: "question",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Xác nhận",
        cancelButtonText: "Hủy",
    }).then(async (result) => {
        if (result.isConfirmed) {
            try {
                let url = window.location.origin + '/manages/admin/system/set-amount-origin-shipment/delete';
                let data = {
                    shipment_code: params
                }
                let res = await ajaxContants2(url, 'POST', data);
                if (res.status == 200) {
                    onPagination(`${show_page_url}/pagination`);
                }
                showMessage(res.message)

            } catch (error) {
                showMessage()
            }
        }
    });

}


async function onConfirmPaymentCash() {
    if (pub_choosed_paycash.length <= 0) {
        return showMessage({
            icon: 'warning',
            text: 'Vui lòng chọn đơn muốn xác nhận'
        })
    }
    Swal.fire({
        icon: 'question',
        title: 'Xác nhận',
        text: 'Xác nhận ' + pub_choosed_paycash.length + ' đơn',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        confirmButtonText: 'Xác Nhận',
        cancelButtonColor: '#d33',
        cancelButtonText: 'Hủy',
    }).then(async (result) => {
        if (result.isConfirmed) {
            onBtnLoading('#btn_confirm_pay_cash', true);
            try {
                let url = window.location.origin + '/manages/admin/system/payment-cash/confirm';
                let data = {
                    is_api: false,
                    choosed_paycash: pub_choosed_paycash,
                };

                let res = await ajaxContants2(url, 'POST', data);
                if (res.status == 200) {
                    is_check_all = false;
                    $('#is_check_all').prop('checked', false);
                    pub_choosed_paycash = [];
                    onPagination(`${show_page_url}/pagination`);

                }
                showMessage(res.message);

                onBtnLoading('#btn_confirm_pay_cash', false, 'Duyệt lệnh');
            } catch (error) {
                onBtnLoading('#btn_confirm_pay_cash', false, 'Duyệt lệnh');
                showMessage();
            }
        }
    })

}

async function onCheckAllPayCash() {
    onLoadingSweet(true)
    try {
        let url = window.location.origin + '/manages/admin/system/payment-cash/check-all';
        filters.is_check_all = $('#is_check_all').is(':checked');
        let data = {
            is_api: false,
            filters: JSON.stringify(Object.assign({}, filters)),
        };

        let res = await ajaxContants2(url, 'POST', data);
        if (res.status == 200) {
            pub_choosed_paycash = res.choosed_paycash;
            onPagination(`${show_page_url}/pagination`);
            $('#is_check_all').prop('checked', false);
        } else {
            showMessage(res.message);
        }
    } catch (error) {
        showMessage();
    }
    onLoadingSweet(false);

}

function onChoosePaymentCash(id) {
    var index = pub_choosed_paycash.indexOf(id);

    if (index === -1) {
        pub_choosed_paycash.push(id);
    } else {
        pub_choosed_paycash.splice(index, 1);
        $('#is_check_all').prop('checked', false);
    }

}

async function onExportExcelCheckPayment() {

    const data = {
        is_api: false,
        filters: JSON.stringify(Object.assign({}, filters)),
        export_excel: true
    }
    const url = `${show_page_url}/pagination`;
    const fileName = 'ReportSale.xlsx';
    // fetchExportExcel(url, data, btn, fileName)

    try {
        // onBtnLoading(btn, true)
        onLoadingSweet(true)
        const response = await fetch(url, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify(data)
        });

        if (response.ok) {
            const blob = await response.blob(); // Chuyển kết quả sang dạng blob
            const link = document.createElement('a');
            link.href = window.URL.createObjectURL(blob);
            link.download = fileName; // Tên file tải về
            link.click(); // Tự động tải file
        } else {
            showMessage({
                icon: 'error',
                text: 'Xuất file excel thất bại'
            })
        }
    } catch (error) {

        showMessage()

    }
    onLoadingSweet(false)

}

function onRefundCheckedPayment(id) {
    onConfirmAction({
        icon: 'question',
        title: 'Hủy xác nhận',
        text: 'Bạn có chắc chắn muốn hủy xác nhận đơn này không?',
    }, async function () {
        onLoadingSweet(true)
        try {
            let url = window.location.origin + '/manages/admin/system/payment-cash/refund-checked';
            filters.is_check_all = $('#is_check_all').is(':checked');
            let data = {
                checked_id: id
            };

            let res = await ajaxContants2(url, 'POST', data);
            if (res.status == 200) {
                page = 1;
                onPagination(`${show_page_url}/pagination`);
            } else {
                showMessage(res.message);
            }
        } catch (error) {
            showMessage();
        }
        onLoadingSweet(false);
    })

}

function onRemoveCheckedPayment(id, status) {

    if (status == 1) {

        Swal.fire({
            icon: 'question',
            title: 'Xác nhận hoàn lại',
            text: 'Thao tác này sẽ làm mới lại thanh toán của đối tượng, bạn vẫn muốn tiếp tục không?',
            input: "text",
            inputPlaceholder: "Nhập lý do bị từ chối",
            inputAttributes: {
                autocapitalize: "off"
            },
            showCancelButton: true,
            confirmButtonText: "Xác nhận",
            showLoaderOnConfirm: true,
            preConfirm: async (note) => {
                const data = {
                    checked_id: id,
                    checked_note: note
                }
                onReturnCheckedPayment(data);
            },
            // allowOutsideClick: () => !Swal.isLoading()
        }).then((result) => {
            // if (result.isConfirmed) {
            //     Swal.fire({
            //         title: `${result.value.login}'s avatar`,
            //         imageUrl: result.value.avatar_url
            //     });
            // }
        });
    } else {
        const data = {
            checked_id: id
        }
        onConfirmAction({
            icon: 'question',
            title: 'Hủy xác nhận',
            text: 'Bạn có chắc chấn muốn xóa ghi chú này không',
        }, async () => onReturnCheckedPayment(data));
    }
}

async function onReturnCheckedPayment(data) {
    try {
        let url = window.location.origin + '/manages/admin/system/payment-cash/remove-checked';
        onLoadingSweet(true)

        let res = await ajaxContants2(url, 'POST', data);
        if (res.status == 200) {
            page = 1;
            onPagination(`${show_page_url}/pagination`);
        } else {
            showMessage(res.message);
        }
    } catch (error) {
        onLoadingSweet(false);
        showMessage();
    }
    onLoadingSweet(false);
}

function showModalCheckedPayment(id, total, cash, bank) {

    $('#checked_id').val(id);
    $('#checked_total_amount').val(formatNumberThousand(total));

    $('#label_cash').val(formatNumberThousand(cash));
    $('#checked_amount_cash').val(cash);

    $('#label_bank').val(formatNumberThousand(bank));
    $('#checked_amount_bank').val(bank);

    setTextLabelAmount(bank, cash);

    // $('#checked_amount_cash').on('input', function () {
    //     let total_amount = convertStringToNumber($('#checked_total_amount').val());
    //     let amount_cash = $('#checked_amount_cash').val();

    //     let checked_amount_bank = total_amount - amount_cash;

    //     $('#checked_amount_bank').val(checked_amount_bank);

    //     setTextLabelAmount(checked_amount_bank, amount_cash);
    // });

    // $('#checked_amount_bank').on('input', function () {
    //     let total_amount = convertStringToNumber($('#checked_total_amount').val());
    //     let amount_bank = $('#checked_amount_bank').val();

    //     let checked_amount_cash = total_amount - amount_bank;
    //     $('#checked_amount_cash').val(checked_amount_cash);

    //     setTextLabelAmount(amount_bank, checked_amount_cash);
    // });
    onChangePricePayBankOrCash();


    $('#modalConfirmOneCheckedPayment').modal('show');
}

function onChangePricePayBankOrCash() {
    $('#checked_amount_bank, #checked_amount_cash').on('input', function () {
        let total_amount = convertStringToNumber($('#checked_total_amount').val());
        let amount_cash = convertStringToNumber($('#checked_amount_cash').val());
        let amount_bank = convertStringToNumber($('#checked_amount_bank').val());

        let input_id = $(this).attr('id');
        if (input_id === 'checked_amount_bank') {
            setTextLabelAmount(amount_bank, total_amount - amount_bank);
            $('#checked_amount_cash').val(total_amount - amount_bank);
        } else if (input_id === 'checked_amount_cash') {
            setTextLabelAmount(total_amount - amount_cash, amount_cash);
            $('#checked_amount_bank').val(total_amount - amount_cash);
        }

    })
}
function setTextLabelAmount(bank, cash) {
    $('#label_bank').html(formatNumberThousand(bank));
    $('#label_cash').html(formatNumberThousand(cash));
}



async function onConfirmOneCheckedPayment() {
    onLoadingSweet(true)
    try {
        let url = window.location.origin + '/manages/admin/system/payment-cash/confirm-one';
        let data = {
            checked_id: $('#checked_id').val(),
            checked_amount_cash: $('#checked_amount_cash').val(),
            checked_amount_bank: $('#checked_amount_bank').val(),
            checked_note: $('#checked_note').val(),
        };

        let res = await ajaxContants2(url, 'POST', data);
        if (res.status == 200) {
            page = 1;
            onPagination(`${show_page_url}/pagination`);
            $('#modalConfirmOneCheckedPayment').modal('hide');

        } else if (res.status == 422) {
            let errors = res.error;
            if (errors) {
                Object.entries(errors).forEach(([key, item]) => {
                    if ($(`#${key}_err`).length) {
                        $(`#${key}_err`).html(item[0]);
                    }
                });
            }
        }
        onLoadingSweet(false);
        showMessage(res.message);
    } catch (error) {
        console.log(error);
        showMessage();
        onLoadingSweet(false);
    }
    onLoadingSweet(false);

}