let limit = 25,
    page = 1,
    _url = window.location.origin + "/logo-service";

$(document).ready(function () {
    $('input[name="logo_service_daterange"]').daterangepicker(
        {
            opens: "left",
            startDate: moment().subtract(3, "months").startOf("month"),
            endDate: moment().endOf("month"),
            locale: {
                format: "DD/MM/YYYY",
                applyLabel: "Áp dụng",
                cancelLabel: "Hủy",
                customRangeLabel: "Tùy chỉnh",
                daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
                monthNames: [
                    "Tháng 1",
                    "Tháng 2",
                    "Tháng 3",
                    "Tháng 4",
                    "Tháng 5",
                    "Tháng 6",
                    "Tháng 7",
                    "Tháng 8",
                    "Tháng 9",
                    "Tháng 10",
                    "Tháng 11",
                    "Tháng 12",
                ],
            },
            ranges: {
                "Tháng này": [
                    moment().startOf("month"),
                    moment().endOf("month"),
                ],
                "Tháng trước": [
                    moment().subtract(1, "month").startOf("month"),
                    moment().subtract(1, "month").endOf("month"),
                ],
                "3 tháng trước": [
                    moment().subtract(3, "month").startOf("month"),
                    moment().subtract(1, "month").endOf("month"),
                ],
                "6 tháng trước": [
                    moment().subtract(6, "month").startOf("month"),
                    moment().subtract(1, "month").endOf("month"),
                ],
                "Năm nay": [moment().startOf("year"), moment().endOf("year")],
                "Năm trước": [
                    moment().subtract(1, "year").startOf("year"),
                    moment().subtract(1, "year").endOf("year"),
                ],
            },
        },
        function (start, end, label) {
            onGetTransferList();
        }
    );

    onGetLogoServiceList();
});

$(document).on("change", '[name="logo_service_keywords"]', function () {
    onGetLogoServiceList();
});

$(document).on("click", ".pagination a", function (event) {
    event.preventDefault();
    page = $(this).attr("href").split("page=")[1];
    onGetLogoServiceList();
});

function getFilters() {
    return {
        date_range: {
            start_date: $('input[name="logo_service_daterange"]')
                .data("daterangepicker")
                .startDate.format("DD-MM-YYYY"),
            end_date: $('input[name="logo_service_daterange"]')
                .data("daterangepicker")
                .endDate.format("DD-MM-YYYY"),
        },
        keywords: $('[name="logo_service_keywords"]').val(),
    };
}

async function onGetLogoServiceList() {
    $("#show_table_content").html("");
    $("#loading_show_table_content").addClass("d-block");
    $("#loading_show_table_content").removeClass("d-none");
    try {
        let data = {
            limit: limit,
            page: page,
            filters: JSON.stringify(Object.assign({}, getFilters())),
        };
        
        const result = await sendRequest(`${_url}/pagination`, "POST", data);

        if (result.status == 200) {
            $("#show_table_content").html(result.html);
        }

        $("#loading_show_table_content").removeClass("d-block");
        $("#loading_show_table_content").addClass("d-none");
    } catch (error) {
        $("#loading_show_table_content").removeClass("d-block");
        $("#loading_show_table_content").addClass("d-none");
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}

$(document).on("change", ".form-logo-service", async function () {
    const service_id = $(this).data("service_id");
    const title = $(this).find(".logo-service-title").val();
    const description = $(this).find(".logo-service-description").val();
    const file = $(this).find(".dropify-logo-service").prop("files")[0];

    updateLogoService(service_id, title, description, file);
});

async function updateLogoService(service_id, title, description, file = null) {
    try {
        const formData = new FormData();

        formData.append("logo", file);
        formData.append("service_id", service_id);
        formData.append("title", title);
        formData.append("description", description);

        const response = await sendRequest(`${_url}/upload`, "POST", formData, true);
        
        showMessage(response.message);
        onGetLogoServiceList();
    } catch (error) {
        showMessage(error.message);
    }
}

$(document).on("click", ".dropify-clear", async function () {
    try {
        // Tìm phần tử cha chứa data-service_id
        const service_id = $(this).closest('.form-logo-service').data('service_id');

        if (!service_id) {
            throw new Error('Service ID không tồn tại.');
        }

        // Gửi request
        const response = await sendRequest(`${_url}/delete-logo`, "POST", { service_id: service_id });

        showMessage(response.message);
        onGetLogoServiceList();
    } catch (error) {
        showMessage(error.message || 'Có lỗi xảy ra.');
    }
});