let excels = [];
let limit = 10;
let page = 1;

showTableLabels();

$(document).on('click', '.pagination a', function (event) {
    event.preventDefault();
    page = $(this).attr('href').split('page=')[1];
    showTableLabels();
});

let timeoutKeyupPostalCode;
$('#keywords').on('input', function (e) {
    // if (e.which === 13) { // 13 là má ASCII của phím Enter

    // }
    clearTimeout(timeoutKeyupPostalCode);
    timeoutKeyupPostalCode = setTimeout(async function () {
        page = 1;
        showTableLabels();

    }, 500);

})


$('#label_type').change(function () {
    page = 1;
    showTableLabels();
})

$("#label-dropzone").dropzone({
    url: "/upload",
    maxFiles: 1,
    autoProcessQueue: false,
    paramName: "file",
    clickable: true,
    maxFilesize: 10,
    addRemoveLinks: true,
    acceptedFiles: '.xlsx',
    dictDefaultMessage: "Tải file excel ở đây",
    init: function () {
        this.on("addedfile", function (file) {
            $('#create_label_nz').html(iconLoadingHtml())
            $('#create_label_nz').prop('disabled', true);
            // Xử lý khi một tệp mới được thêm vào Dropzone
            var reader = new FileReader();
            reader.onload = function (e) {
                var data = new Uint8Array(e.target.result);
                var workbook = XLSX.read(data, { type: 'array' });
                var firstSheetName = workbook.SheetNames[0];
                var worksheet = workbook.Sheets[firstSheetName];
                var json = XLSX.utils.sheet_to_json(worksheet);
                if (json.length < 1) {
                    $('#upload-file-excel').val();
                    return showMessage({
                        text: 'Dữ liệu excel trống'
                    })
                }

                setDataExcel(json);
                $('#create_label_nz').html('Tạo label NZ post')
                $('#create_label_nz').prop('disabled', false);
            };
            reader.readAsArrayBuffer(file);

        });

        this.on("uploadprogress", function (file, progress) {
            // Xử lý khi tệp đang được tải lên
            console.log("Tiến trình tải lên:", progress, "%", " cho tệp ", file.name);
        });

        this.on("success", function (file, response) {
            // Xử lý khi tệp được tải lên thành công
            console.log("Tải lên thành công:", file.name, " Phản hồi từ server:", response);
        });

        this.on("error", function (file, errorMessage) {
            // Xử lý khi có lỗi xảy ra trong quá trình tải lên
            console.log("Lỗi tải lên:", file.name, " Thông báo lỗi:", errorMessage);
            alert("Lỗi tải lên:" + errorMessage);
            this.removeFile(file);
        });
    }
});


async function setDataExcel(data) {
    const trimObjectKeys = (obj) => {
        const trimmedArray = [];
        for (const key in obj) {
            if (obj.hasOwnProperty(key)) {
                // const trimmedKey = key.trim();

                let count_excel = trimmedArray.length;
                if (typeof obj[key].serviceType == 'undefined' && count_excel > 0) {
                    // Ensure childOrders array exists before pushing
                    if (!Array.isArray(trimmedArray[count_excel - 1].childOrders)) {
                        trimmedArray[count_excel - 1].childOrders = [];
                    }
                    trimmedArray[count_excel - 1].childOrders.push(obj[key]);
                } else {


                    trimmedArray.push({
                        ...obj[key],
                        childOrders: [{
                            weight: obj[key].weight,
                            height: obj[key].height,
                            length: obj[key].length,
                            width: obj[key].width
                        }]
                    });
                }
            }
        }
        // console.log(trimmedArray);
        return trimmedArray;
    };

    excels = trimObjectKeys(data);
}

function showTableLabels() {
    let _url = window.location.origin + '/labels/paginate'
    let _data = {
        filters: {
            label_type: $('#label_type').val(),
            keywords: $('#keywords').val(),
        },
        paginate: {
            limit: limit,
            page: page
        }
    }
    const call = (res) => {
        // setMyDatatable('.myDatatable')
    }
    ajaxPostHTML(_url, _data, 'content-labels', call)
}


$('#create_label_nz').on('click', async function (e) {

    try {
        if (excels.length < 1) {
            return showMessage({
                icon: 'warning',
                title: 'Thông báo',
                text: 'File excel rỗng'
            })
        }
        $('#create_label_nz').html(iconLoadingHtml())
        $('#create_label_nz').prop('disabled', true);

        // console.log(excels);
        let _excels = [];
        excels.forEach(function (item, index) {
            _excels.push(getDataEx(item));
        })

        let _url = window.location.origin + '/labels';
        let _data = {
            excels: _excels
        }
        let res = await ajaxContants2(_url, 'POST', _data);

        if (res.status === 200) {
            showMessage({
                icon: 'success',
                title: 'Thông báo',
                text: 'Khởi tạo label thành công'
            })
            showTableLabels();
        } else {
            showMessage(res.message)
        }
    } catch (error) {
        console.log(error);
        showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: 'Xảy ra lỗi khi gọi đến serve'
        })
    }

    $('#create_label_nz').html('Tạo label')
    $('#create_label_nz').prop('disabled', false);
})


function getDataEx(data) {
    let data_ex = {
        referenceNo: data.referenceNo,
        shippingMethodCode: data.serviceType, //data.serviceType   AP-NZPOST
        shippingFirstName: data.recipientName,
        shippingPhone: data.phone,
        email: data.email,
        shippingAddress: data.addressLine1,
        shippingAddress1: data.addressLine2,
        shippingCity: data.city,
        shippingState: data.state,
        shippingZip: data.postcode,
        countryCode: data.country,
        instruction: data.instruction,
        itemCount: data.itemCount,
        applicationName: data.description,
        unitPrice: data.unitValue,
        weight: data.weight,
        height: data.height,
        length: data.length,
        width: data.width,
        dimensionUnit: data.dimensionUnit,
        weightUnit: data.weightUnit,
        shipperName: data.shipperName,
        childOrders: data.childOrders
    };
    return data_ex;
}


$('#create_label_auk').on('click', async function (e) {
    
    try {
        if (excels.length < 1) {
            return showMessage({
                icon: 'warning',
                title: 'Thông báo',
                text: 'File excel rỗng'
            })
        }

        $('#create_label_auk').html(iconLoadingHtml())
        $('#create_label_auk').prop('disabled', true);

        let _excels = [];
        excels.forEach(function (item, index) {
            let excel = {
                lineCode: item.lineCode,
                orderNo: item.orderNo,
                destination: item.destination,
                consigneeName: item.consigneeName,
                consigneeAdress1: item.consigneeAdress1,
                consigneeAdress2: item.consigneeAdress2,
                consigneeCity: item.consigneeCity,
                consigneeState: item.consigneeState,
                consigneePostcode: item.consigneePostcode,
                consigneeCountryCode: item.consigneeCountryCode,
                consigneePhone: item.consigneePhone,
                consignorName: item.consignorName,
                consignorAddress1: item.consignorAddress1,
                consignorAddress2: item.consignorAddress2,
                consignorCity: item.consignorCity,
                consignorState: item.consignorState,
                consignorPostcode: item.consignorPostcode,
                consignorCountryCode: item.consignorCountryCode,
                consignorPhone: item.consignorPhone,
                parcelQty: item.parcelQty,
                parcelVolume: item.parcelVolume,
                parcelWeight: item.parcelWeight,
                goodsDescription: item.goodsDescription,
                goodValue: item.goodValue,
                length: item.length,
                width: item.width,
                height: item.height,
            }
            _excels.push(excel);
        })

        let _url = window.location.origin + '/labels/auk';
        let _data = {
            excels: _excels
        }
        let res = await ajaxContants2(_url, 'POST', _data);

        if (res.status === 200) {
            showMessage({
                icon: 'success',
                title: 'Thông báo',
                text: 'Khởi tạo label thành công'
            })
            showTableLabels();
        } else {
            showMessage(res.message)
        }
    } catch (error) {
        showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: 'Vui lòng kiểm tra dữ liệu trên excel tải lên'
        })
    }

    $('#create_label_auk').html('Tạo label ')
    $('#create_label_auk').prop('disabled', false);
})

$(document).on('click', '#create_label_dpd', async function (e) 
{
    if (excels.length < 1) {
        return showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: 'File excel rỗng'
        })
    }

    $('#create_label_dpd').html(iconLoadingHtml())
    $('#create_label_dpd').prop('disabled', true);
    try {
        const formData = new FormData();
        formData.append('excels', JSON.stringify(excels));
        
        const response = await sendRequest(`${window.location.origin}/labels/dpd`, "POST", formData, true);

        showMessage(response.message);
        showTableLabels();
    } catch (error) {
        showMessage(error.message);
    }
    $('#create_label_dpd').html('Tạo label DPD')
    $('#create_label_dpd').prop('disabled', false);
})

$(document).on('click', '#create_label_etower', async function (e) 
{
    if (excels.length < 1) {
        return showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: 'File excel rỗng'
        })
    }

    $('#create_label_etower').html(iconLoadingHtml())
    $('#create_label_etower').prop('disabled', true);
    try {
        const formData = new FormData();
        formData.append('excels', JSON.stringify(excels));
        
        const response = await sendRequest(`${window.location.origin}/labels/etower`, "POST", formData, true);

        showMessage(response.message);
        showTableLabels();
    } catch (error) {
        showMessage(error.message);
    }
    $('#create_label_etower').html('Tạo label ETOWER')
    $('#create_label_etower').prop('disabled', false);
});

$(document).on('click', '#create_label_top_log_au', async function (e) 
{
    if (excels.length < 1) {
        return showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: 'File excel rỗng'
        })
    }

    $('#create_label_etower').html(iconLoadingHtml())
    $('#create_label_etower').prop('disabled', true);
    try {
        const formData = new FormData();
        formData.append('excels', JSON.stringify(excels));
        
        const response = await sendRequest(`${window.location.origin}/labels/top-log-au`, "POST", formData, true);

        showMessage(response.message);
        showTableLabels();
    } catch (error) {
        showMessage(error.message);
    }
    $('#create_label_etower').html('Tạo label')
    $('#create_label_etower').prop('disabled', false);
});

async function onPrintFile(file){
    try {
        const response = await fetch(`${window.location.origin}/${file}`);
        let html = await response.text();

        const css = `
            <style>
                @page {
                    margin-left: 0in;
                    margin-right: 0in;
                    margin-top: 0in;
                    margin-bottom: 0;
                }
            </style>
        `;
        html = css + html;

        const width = window.innerWidth;
        const height = window.innerHeight;
        const printWindow = window.open("", "", `width=${width},height=${height}`);

        printWindow.document.write(html);
        printWindow.document.close();
        printWindow.focus();
        setTimeout(() => {
            printWindow.print();
        }, 1000);
    } catch (error) {
        console.error('Error printing file:', error);
    }
}