let limit = 50;
let page = 1;

$('#keywords').on('keypress', function (e) {
    if (e.which === 13) { // 13 là mã ASCII của phím Enter
        fetchData();
    }
})

$(document).ready(function () {
    fetchData()
});

$(document).on('click', '.pagination a', function (event) {
    event.preventDefault();
    page = $(this).attr('href').split('page=')[1];
    fetchData();
});



function fetchData() {
    try {
        let url = window.location.origin + '/debit/detail-shipment';
        let data = {
            paginate: {
                limit: limit,
                page: page,
            },
            filters: {
                keywords: $('#keywords').val(),
            },
            debit_id: pub_debit_id
        }


        ajaxPostHTML(url, data, 'content')

    } catch (error) {

    }
}

Dropzone.autoDiscover = false;


if (document.getElementById('debitFwdDropzone')) {

    // Khởi tạo Dropzone trên phần tử với id "debitFwdDropzone"
    var debitFwdDropzone = new Dropzone("#debitFwdDropzone", {
        url: "/upload",
        autoProcessQueue: false,
        paramName: "file",
        clickable: true,
        maxFilesize: 10, // MB
        addRemoveLinks: true,
        acceptedFiles: '.png,.jpg',
        dictDefaultMessage: "Tải hình ảnh ở đây",

        init: function () {
            var dropzone = this;
            dropzone.on("complete", function (file) {
            });
            dropzone.on("addedfile", function (file) {
            });
            dropzone.on("removedfile", function (file) {
            });
        }
    });

    function emptyValiPayment() {
        $('#images_debit_err').html('')
        $('#note_debit').html('')
    }

    function onPaymentDebit() {
        emptyValiPayment();
        try {
            if (Dropzone.forElement("#debitFwdDropzone").files.length <= 0) {
                $('#images_debit_err').html('Không được để trống hình ảnh');
                return
            }
            $('#images_debit_err').html('');

            var dataURLs = [];

            Dropzone.forElement("#debitFwdDropzone").files.forEach(async function (file) {
                let base64 = await readFileAsBase64(file);
                dataURLs.push(base64);
            })

            const callback = async () => {
                onBtnLoading('#btn_payment_debit', true);
                let _url = window.location.origin + '/debit/payment-fwd';
                let _data = {
                    debit_no: pub_debit_no,
                    debit_note: $('#note_debit').val(),
                    debit_payment_method: $('input[name="debit_payment_method"]:checked').val(),
                    debit_payment_amount: convertStringToNumber($('#debit_payment_amount').val()),
                    bank_amount: convertStringToNumber($('#debit_payment_bank_amount').val()),
                    cash_amount: convertStringToNumber($('#debit_payment_cash_amount').val()),
                    debits_images: JSON.stringify(dataURLs),
                }

                let res = await ajaxContants2(_url, "POST", _data);

                if (res.status === 200) {
                    fetchData();
                    onShowModal('#modalPaymentDebit', false);
                    location.reload();
                } else {

                }
                showMessage(res.message)
                onBtnLoading('#btn_payment_debit', false, 'Thanh toán');
            }

            onConfirmAction({
                icon: 'warning',
                title: 'Thông báo',
                text: 'Xác nhận thanh toán công nợ'
            }, callback)
        } catch (error) {
            showMessage();
            onBtnLoading('#btn_payment_debit', false, 'Thanh toán');
        }
        onBtnLoading('#btn_payment_debit', false, 'Thanh toán');

    }
}

if (document.getElementById('debitAdvanceDropzone')) {

    var debitAdvanceDropzone = new Dropzone("#debitAdvanceDropzone", {
        url: "/upload",
        autoProcessQueue: false,
        paramName: "file",
        clickable: true,
        maxFilesize: 10, // MB
        addRemoveLinks: true,
        acceptedFiles: '.png,.jpg',
        dictDefaultMessage: "Tải hình ảnh ở đây",

        init: function () {
            var dropzone = this;
            dropzone.on("complete", function (file) {
            });
            dropzone.on("addedfile", function (file) {
            });
            dropzone.on("removedfile", function (file) {
            });
        }
    });

    function emptyAdvance() {
        $('#debit_advance_amount').html('')
        $('#debit_advance_images').html('')
        $('#debit_advance_note').html('')
    }

    function onAdvanceDebit() {
        try {
            if (Dropzone.forElement("#debitAdvanceDropzone").files.length <= 0) {
                $('#images_advance_err').html('Không được để trống hình ảnh');
                // showMessage({text: "Cần phải có bằng chứng"})
                return
            }
            $('#debit_advance_amount_err').html('');

            var dataURLs = [];

            Dropzone.forElement("#debitAdvanceDropzone").files.forEach(async function (file) {
                let base64 = await readFileAsBase64(file);
                dataURLs.push(base64);
            })

            const callback = async () => {
                onBtnLoading('#btn_advance_debit', true);
                emptyAdvance();
                let _url = window.location.origin + '/debit/advance-fwd';
                let _data = {
                    debit_no: pub_debit_no,
                    debit_advance_images: JSON.stringify(dataURLs),
                    debit_advance_note: $('#note_advance').val(),
                    debit_advance_amount: convertStringToNumber($('#debit_advance_amount').val()),
                }

                let res = await ajaxContants2(_url, "POST", _data);

                if (res.status === 200) {
                    fetchData();
                    onShowModal('#modalPaymentDebit', false);
                    location.reload();
                } else if (res.status == 422) {
                    var errors = res.error;
                    $.each(errors, function (key, value) {
                        // Hiển thị thông điệp lỗi tương ứng với mỗi trường
                        if ($('#' + key + '_err')) {
                            $('#' + key + '_err').html(value[0])
                        }
                    });
                }
                showMessage(res.message)
                onBtnLoading('#btn_advance_debit', false, 'Tạm ứng');
            }

            onConfirmAction({
                icon: 'warning',
                title: 'Thông báo',
                text: 'Xác nhận tạm ứng'
            }, callback)
        } catch (error) {
            showMessage();
            onBtnLoading('#btn_advance_debit', false, 'Tạm ứng');
        }
        onBtnLoading('#btn_advance_debit', false, 'Tạm ứng');

    }
}

function onConfirmPaymentDebit() {
    try {
        const callback = async () => {
            onBtnLoading('#btn_confirm_payment_debit', true);
            let _url = window.location.origin + '/debit/payment';
            let _data = {
                debit_no: pub_debit_no,
                debit_payment_amount: convertStringToNumber($('#debit_payment_amount').val()),
                bank_amount: convertStringToNumber($('#debit_payment_bank_amount').val()),
                cash_amount: convertStringToNumber($('#debit_payment_cash_amount').val()),
            }
    
            let res = await ajaxContants2(_url, "POST", _data);
    
            if (res.status === 200) {
                fetchData();
                location.reload();
            } else {
            }
            showMessage(res.message)
            onBtnLoading('#btn_confirm_payment_debit', false, 'Xác nhận');
        }
    
        onConfirmAction({
            icon: 'warning',
            title: 'Thông báo',
            text: 'Xác nhận thanh toán công nợ'
        }, callback)
    } catch (error) {
        showMessage();
    }
    onBtnLoading('#btn_confirm_payment_debit', false, 'Xác nhận');
}

$('#debit_payment_bank_amount, #debit_payment_cash_amount, #debit_payment_amount').on('input', function () {
    let total_price = convertStringToNumber($('#debit_payment_amount').val());
    let bank_price = convertStringToNumber($('#debit_payment_bank_amount').val());
    let cash_price = convertStringToNumber($('#debit_payment_cash_amount').val());

    let input_id = $(this).attr('id');
    
    if (input_id === 'debit_payment_bank_amount') {
        $('#debit_payment_cash_amount').val(formatNumber2(total_price - bank_price));
    } else if (input_id === 'debit_payment_cash_amount') {
        $('#debit_payment_bank_amount').val(formatNumber2(total_price - cash_price));
    }else{
        $('#debit_payment_cash_amount').val(formatNumber2(total_price - bank_price))
    }
    
})