$(document).ready(function () {
    
})

async function onRegister() {
    let url = window.location.origin + '/register';
    console.log($('#lat').val());
    console.log($('#lng').val());
    
    let data = {
        user_name: $('#user_name').val(),
        password: $('#password').val(),
        confirm_password: $('#confirm_password').val(),
        user_logo: await getBase64FromFile(document.getElementById('user_logo').files[0]),
        user_address: $('#user_address').val(),
        user_address_1: $('#city_of_registration').val(),
        user_address_2: $('#district_of_registration').val(),
        user_address_3: $('#ward_of_registration').val(),
        user_phone: $('#user_phone').val(),
        user_tax_code: $('#user_tax_code').val(),
        user_accountant_key: $('#user_accountant_key').val(),
        user_contact_name: $('#user_contact_name').val(),
        user_company_name: $('#user_company_name').val(),
        user_latitude: $('#lat').val(),
        user_longitude: $('#lng').val(),

        is_api: false
    }

    
    
    if (!$('#agree_terms_use_service').prop('checked')) {
        showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: 'Bạn cần xác nhận với điều khoản của chúng tôi!'
        })
        // return
    }

    const callback = (res) => {
        clearValErr();
        if (res.status == 200) {
            let registry = {
                icon: 'success',
                title: 'Thành công',
                text: res.message
            }
            // showMessage(registry);
            if (res.route) {
                window.location.href = res.route;
            }
            // window.location.href = typeof res.route === undefined ? window.location.origin : res.route
        } else if (res.status == 422) {
            var errors = res.error.responseJSON.errors; // Lấy thông điệp lỗi từ phản hồi JSON
            
            // Display error correctsponding
            $.each(errors, function (key, value) {
                $('#' + key + '_err').text(value[0]);
                $('#' + key + '_err').addClass('d-block')
            });
        } else {
            let alert = {
                icon: 'warning',
                title: 'Cảnh báo',
                text: res.message
            }
            showMessage(alert)
        }
        // $('#login_btn').html('ĐĂNG NHẬP');

    }
    // $('#login_btn').html(iconLoadingHtml());
    ajaxContants(url, 'POST', data, callback);
}

async function getBase64FromFile(file) {
    return new Promise((resolve, reject) => {
        var reader = new FileReader();

        reader.onload = function (e) {
            resolve(e.target.result); // Trả về kết quả Base64
        };

        reader.onerror = function (error) {
            reject(error); // Nếu có lỗi xảy ra, trả về lỗi
        };

        if(reader){
            reader.readAsDataURL(file);
        }
    });
}
function displaySelectedImage(event, elementId) {
    const selectedImage = document.getElementById(elementId);
    const fileInput = event.target;

    if (fileInput.files && fileInput.files[0]) {
        const reader = new FileReader();

        reader.onload = function(e) {
            selectedImage.src = e.target.result;
        };

        reader.readAsDataURL(fileInput.files[0]);
    }
}
function clearValErr() {
    $('#user_name_err').text('');
    $('#user_name_err').removeClass('d-block')
    $('#password_err').text('');
    $('#password_err').removeClass('d-block')
    $('#confirm_password_err').text('');
    $('#confirm_password_err').removeClass('d-block')
    $('#user_company_name_err').text('');
    $('#user_company_name_err').removeClass('d-block')
    $('#user_contact_name_err').text('');
    $('#user_contact_name_err').removeClass('d-block')
    $('#user_accountant_key_err').text('');
    $('#user_accountant_key_err').removeClass('d-block')
    $('#user_tax_code_err').text('');
    $('#user_tax_code_err').removeClass('d-block')
    $('#user_phone_err').text('');
    $('#user_phone_err').removeClass('d-block')
    $('#user_address_1_err').text('');
    $('#user_address_1_err').removeClass('d-block')
    $('#user_address_err').text('');
    $('#user_address_err').removeClass('d-block')
    $('#user_logo_err').text('');
    $('#user_logo_err').removeClass('d-block')
}

$('#city_of_registration').on('change', async function () {
    $('div.actions.clearfix').addClass('d-none');
    await getAreasInVietNam($('[name="city_of_registration"]').val(), null, 'district_of_registration', 'ward_of_registration', false);
    $('div.actions.clearfix').removeClass('d-none');
});

$('#district_of_registration').on('change', async function () {
    $('div.actions.clearfix').addClass('d-none');
    await getAreasInVietNam($('[name="city_of_registration"]').val(), $('[name="district_of_registration"]').val(), 'district_of_registration', 'ward_of_registration', false)
    $('div.actions.clearfix').removeClass('d-none');
});


async function getAreasInVietNam(key_city = null, key_district = null, key_element_district, key_element_ward, is_name = true) {
    if (!key_district) {
        $(is_name ? `[name="${key_element_district}"]` : `#${key_element_district}`).find('option').not('[value=""]').remove();
        $(is_name ? `[name="${key_element_district}"]` : `#${key_element_district}`).attr("disabled", true);
    }
    $(is_name ? `[name="${key_element_ward}"]` : `#${key_element_ward}`).find('option').not('[value=""]').remove();
    $(is_name ? `[name="${key_element_ward}"]` : `#${key_element_ward}`).attr("disabled", true);
    try {
        let data = {
            city: key_city,
            district: key_district,
        }
        const result = await sendRequest(`${window.location.origin}/areas-in-viet-nam`, 'POST', data);
        if (result.status == 200) {
            if (!key_district) {
                $.each(result.areas.districts, function (key, district) {
                    $(is_name ? `[name="${key_element_district}"]` : `#${key_element_district}`).append($('<option>', {
                        value: key,
                        text: `${district}`
                    }));
                });
            }
            $.each(result.areas.wards, function (key, ward) {
                $(is_name ? `[name="${key_element_ward}"]` : `#${key_element_ward}`).append($('<option>', {
                    value: key,
                    text: `${ward}`
                }));
            });
        } else {
            showMessage(result.message);
        }
        $(is_name ? `[name="${key_element_district}"]` : `#${key_element_district}`).attr("disabled", false);
        $(is_name ? `[name="${key_element_ward}"]` : `#${key_element_ward}`).attr("disabled", false);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
        $(is_name ? `[name="${key_element_district}"]` : `#${key_element_district}`).attr("disabled", false);
        $(is_name ? `[name="${key_element_ward}"]` : `#${key_element_ward}`).attr("disabled", false);
    }
}