// biến user_id đã dc khai báo toàn cục ở trang blade.php không dc khai báo nữa 

let address1 = null;
let address2 = null;
let address3 = null;
let areas = [];
let limit = 50;
let page = 1;

$(document).ready(function () {
    const urlParams = new URLSearchParams(window.location.search);
    const tabParam = urlParams.get('tab');
    
    getUser();

    displayTabContent(tabParam);

    tabNavigator();

    passwordToggler();
});

function passwordToggler() {
    const passwordToggle = document.getElementById('password-toggle');
    const passwordIcon = document.getElementById('password-icon');
    const passwordInput = document.getElementById('current_password');

    if (passwordToggle) {
        passwordToggle.addEventListener('click', () => {
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                passwordIcon.classList.remove('fa-eye');
                passwordIcon.classList.add('fa-eye-slash');
            } else {
                passwordInput.type = 'password';
                passwordIcon.classList.remove('fa-eye-slash');
                passwordIcon.classList.add('fa-eye');
            }
        });
    }
}

function displayTabContent(tabParam) {
    console.log(tabParam);
    
    if (tabParam == 'recharge_history') {
        let _url = window.location.origin + '/recharge/list';
        getTableHtml(_url);
        

    } else if (tabParam == 'wallet_fluctuation') {
        
        let _url = window.location.origin + '/wallet/fluctuation';
        getTableHtml(_url, 'content-wallet-fluctuation');
    }
}


function tabNavigator() {
    const urlParams = new URLSearchParams(window.location.search);
    const tabParam = urlParams.get('tab');

    const defaultTab = 'update'; // Set the default tab to display

    const tabs = document.querySelectorAll('.nav-tabs li');
    const tabContent = document.querySelectorAll('.tab-content .tab-pane');

    // Remove active class from all tabs
    tabs.forEach((tab) => {
        tab.querySelector('a').classList.remove('active');
    });
    tabContent.forEach((content) => {
        content.classList.remove('show', 'active');
    });

    tabs.forEach((tab) => {
        const tabLink = tab.querySelector('a');
        const tabId = tabLink.getAttribute('href').replace('#', '');

        if (tabParam && tabLink.getAttribute('href') === `#${tabParam}`) {
            tabLink.classList.add('active');
            tabContent.forEach((content) => {
                if (content.id === tabId) {
                    content.classList.add('show', 'active');
                }
            });
        } else if (!tabParam && tabId === defaultTab) {
            tabLink.classList.add('active');
            tabContent.forEach((content) => {
                if (content.id === tabId) {
                    content.classList.add('show', 'active');
                }
            });
        }
    });
}

$(document).on('click', '.pagination a', function (event) {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    event.preventDefault();
    page = $(this).attr('href').split('page=')[1];
    let url = $(this).attr('href').split('?')[0];
    getTableHtml(url);
});

async function getUser() {
    let _url = window.location.origin + '/profile/info';
    let _data = {
        user_id: user_id,
        is_api: false
    };
    let res = await sendRequest(_url, 'POST', _data);
    if (res.status === 200) {
        let user = res.data;
        $('#user_name').text(user.user_name);
        $('#user_code').text(user.user_code);
        $('#user_api_key').text(user.user_api_key);
        $('#user_limit_amount_for_sale').text(user.user_limit_amount_for_sale);

        $('#user_phone').val(user.user_phone);
        // $('#user_accountant_key').val(user.user_accountant_key);
        $('#user_company_name').val(user.user_company_name);
        $('#user_contact_name').val(user.user_contact_name);
        $('#user_tax_code').val(user.user_tax_code);
        $('#user_limit_amount_for_sale').text(user.user_limit_amount_for_sale);
        $('#user_address').val(user.user_address);

        let _html_logo = ''
        if (user.user_logo) {
            let logo = window.location.origin + '/' + user.user_logo
            _html_logo = `<img src="${logo}" alt="user" class="avatar-img" >`
        } else {
            _html_logo = `<span class="initial-wrap">${user.name_avatar}</span>`
        }
        $('#avatar').html(_html_logo);

        if (user.user_signature) {
            let signature = window.location.origin + '/' + user.user_signature
            // let _html_signature = `<img src="${signature}" alt="" style="height: 150px; object-fit: cover">`
            let _html_signature = `<a href="${signature}" target="_blank" class="btn btn-sm btn-primary"> Xem chữ ký đã lưu </a>`
            $('#display_user_signature').html(_html_signature);
        }

        address1 = user.user_address_1;
        address2 = user.user_address_2;
        address3 = user.user_address_3;
        showAddresses();
    } else {
        showMessage({
            icon: 'error',
            title: 'Lỗi',
            text: res.message
        });
    }
}

async function showAddresses() {
    let _url = window.location.origin + '/areas-in-viet-nam';
    let _data = {
        city: address1,
        district: address2
    }

    let res = await sendRequest(_url, "POST", _data);
    if (res.status == 200) {
        areas = res.areas
        if (!areas.districts[address2]) {
            address2 = null
        }
        if (!areas.wards[address3]) {
            address3 = null
        }

        $('#address2').attr("disabled", true);
        $('#address3').attr("disabled", true);

        $('#address2').html('');
        $('#address3').html('');

        $.each(areas.cities, function (index, item) {
            let _check = address1 == index ? 'selected' : '';
            let _html = `<option value="${index}" ${_check}>${item}</option>`
            $('#address1').append(_html);
        });
        if (address1 || address1 == 0) {
            $('#address2').attr("disabled", false);
            $.each(areas.districts, function (index, item) {
                let _check = address2 == index ? 'selected' : '';
                let _html = `<option value="${index}" ${_check}>${item}</option>`
                $('#address2').append(_html);
            });
        }
        if (address2 || address2 == 0) {
            $('#address3').attr("disabled", false);
            $.each(areas.wards, function (index, item) {
                let _check = address3 == index ? 'selected' : '';
                let _html = `<option value="${index}" ${_check}>${item}</option>`
                $('#address3').append(_html);
            });
        }
    } else {
        showMessage({
            icon: 'error',
            title: 'Lỗi',
            text: res.message
        });
    }
}

$('#address1').on('change', function () {
    address1 = this.value;
    showAddresses();
});
$('#address2').on('change', function () {
    address2 = this.value;
    showAddresses();
});

const onChangeFile = (id_inp, id_div_img) => {
    const file = document.getElementById(id_inp).files[0];
    const reader = new FileReader();
    reader.onload = e => {
        let _html = `<img src="${e.target.result}" alt="user" class="avatar-img" style="max-height: 150px">`
        $('#' + id_div_img).html(_html);
    }
    reader.readAsDataURL(file);
}

async function updateInfoUser() {
    $('#updateInfo').prop('disabled', true);

    try {
        let _url = window.location.origin + '/profile/edit';
        // var formData = new FormData();
        // formData.append('user_id', user_id);
        // formData.append('is_api', false);
        // formData.append('user_company_name', $('#user_company_name').val());
        // formData.append('user_contact_name', $('#user_contact_name').val());
        // formData.append('user_accountant_key', $('#user_accountant_key').val());
        // formData.append('user_tax_code', $('#user_tax_code').val());
        // formData.append('user_phone', $('#user_phone').val());
        // formData.append('user_address_1', $('#address1').val());
        // formData.append('user_address_2', $('#address2').val());
        // formData.append('user_address_3', $('#address3').val());
        // formData.append('user_address', $('#user_address').val());
        // formData.append('user_logo', document.getElementById('user_logo').files[0]);
        // if ($('[name="agree_user_signature"]').prop('checked')) {
        //     let signature = paintCanvas.toDataURL('image/png')
        //     formData.append('user_signature', signature);
        // }
        let formData = {
            user_id: user_id,
            user_company_name: $('#user_company_name').val(),
            user_contact_name: $('#user_contact_name').val(),
            user_tax_code: $('#user_tax_code').val(),
            user_phone: $('#user_phone').val(),
            user_address_1: $('#address1').val(),
            user_address_2: $('#address2').val(),
            user_address_3: $('#address3').val(),
            user_address: $('#user_address').val(),
            user_logo: document.getElementById('user_logo').files[0]
        }

        if ($('[name="agree_user_signature"]').prop('checked')) {
            let signature = paintCanvas.toDataURL('image/png')
            formData.user_signature = signature
        }

        let res = await ajaxContants2(_url, 'POST', formData, true);

        console.log(res);
        if (res.status === 200) {
            showMessage({
                icon: 'success',
                title: 'Thông báo',
                text: res.message
            });
        } else if (res.status === 422) {
            var errors = res.error;
            $.each(errors, function (key, value) {
                $('#' + key + '_err').text(value[0]);
            });
            showMessage({
                icon: 'error',
                title: 'Lỗi',
                text: res.message
            });
        } else {
            showMessage({
                icon: 'error',
                title: 'Lỗi',
                text: res.message
            });
        }
    } catch (error) {
        showMessage({
            icon: 'error',
            title: 'Lỗi',
            text: res.message
        });
    }

    $('#updateInfo').prop('disabled', false);
}

$(document).on('click', '#change_password', async function () {
    let _url = window.location.origin + "/new-password";
    let _data = {
        old_password: $('#old_password').val(),
        password: $('#password').val(),
        confirm_password: $('#confirm_password').val(),
    }
    // resetValPassword()

    let res = await ajaxContants2(_url, 'POST', _data)
    if (res.status === 200) {
        showMessage({
            icon: 'success',
            title: 'Thông báo',
            text: 'Thay đổi mật khẩu thành công'
        });

        $('#old_password').val('')
        $('#password').val('')
        $('#confirm_password').val('')
    } else if (res.status === 422) {
        var errors = res.error; // Lấy thông điệp lỗi từ phản hồi JSON
        $.each(errors, function (key, value) {
            // Hiển thị thông điệp lỗi tương ứng với mỗi trường
            $('#' + key + '_err').text(value[0]);
            $('#' + key + '_err').addClass('d-block')
        });
    } else {
        showMessage({
            icon: 'error',
            title: 'Thông báo',
            text: 'Xảy ra lỗi không xác định'
        });
    }
});

$(document).on('click', '#change_user_accountant_key', async function () {
    let formData = {
        user_accountant_key: $('#user_accountant_key').val(),
        current_password: $('#current_password').val(),
    }
    let _url = window.location.origin + "/profile/update-user-accountant-key";

    let res = await ajaxContants2(_url, 'POST', formData, true)
    if (res.status === 200) {
        showMessage({
            icon: 'success',
            title: 'Thông báo',
            text: 'Thay đổi mã kế toán thành công'
        });

        $('#current_password').val('')
        $('#user_accountant_key').val('')
    } else if (res.status === 422) {
        var errors = res.error;
        $.each(errors, function (key, value) {
            $('#' + key + '_err').text(value[0]);
            $('#' + key + '_err').addClass('d-block')
        });
    } else {
        showMessage({
            icon: 'error',
            title: 'Thông báo',
            text: 'Xảy ra lỗi không xác định'
        });
    }
});

function resetTextErrPassword() {
    $('#old_password_err').text('')
    $('#password_err').text('')
    $('#confirm_password_err').text('')
}

function getListRecharge() {
    window.location.href = '?tab=recharge_history';
}

function getListWalletFlut() {
    window.location.href = '?tab=wallet_fluctuation';
}



function getTableHtml(url, tabId) {
    try {
        let _data = {
            limit: limit,
            page: page,
            is_api: false,
            filters: {
                discount_start_date: $('input[name="discount_user_daterange"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
                discount_end_date: $('input[name="discount_user_daterange"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
                key_type: $('#key_type').val(),
                keywords: $('#keywords').val()
            }
        }
        
        ajaxPostHTML(url, _data, 'content');
    } catch (error) {

        $('#content').html('<p class="text-center text-secondary">Xảy ra lỗi khi tải dữ liệu</p>');
    }
}

function onShowPaginateList() {
    if ($('#title_list').text() == 'Lịch sử nạp tiền') {
        let _url = window.location.origin + '/recharge/list'
        getTableHtml(_url);
    } else {
        let _url = window.location.origin + '/wallet/fluctuation'
        getTableHtml(_url);
    }
}

function showDetail(key) {

    let _url = window.location.origin + '/recharge/detail/user'
    let _data = {
        recharge_id: key,
    };
    ajaxPostHTML(_url, _data, 'content-recharge-detail');
}