let pub_limit = 50, pub_page = 1
fetchData();

$(document).on('click', '.pagination a', function (event) {
    event.preventDefault();
    pub_page = $(this).attr('href').split('page=')[1];
    fetchData();
});


$('#keywords').on('keypress', function (e) {
    if (e.which === 13) { // 13 là mã ASCII của phím Enter
        pub_page = 1;
        fetchData();
    }
})

async function fetchData() {
    try {
        let url = window.location.origin + '/api-documents/paginate'
        let data = {
            paginate: {
                limit: pub_limit,
                page: pub_page
            },
            filters: {
                keywords: $('#keywords').val(),
            }
        };
        ajaxPostHTML(url, data, 'content')
    } catch (error) {

        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}

async function onDeleteApi(params) {

    Swal.fire({
        title: "Thông báo",
        text: 'Bạn có chắc chắn muốn xóa document này không?',
        icon: "question",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Xác nhận",
        cancelButtonText: "Hủy",
    }).then(async (result) => {
        if (result.isConfirmed) {
            try {
                let url = window.location.origin + '/api-documents/delete'
                let data = {
                    key: params
                };
                let res = await ajaxContants2(url, 'POST', data);
                if (res.status == 200) {
                    fetchData();
                }
                showMessage(res.message);
            } catch (error) {
                showMessage()
            }
        }
    });
}