let pub_limit = 10;
let pub_page = 1;

$(document).ready(function () {
    $('input[name="datetimes"]').daterangepicker({
        opens: 'left',
        startDate: moment().subtract(0, 'months').startOf('month'),
        endDate: moment().endOf('month'),
        locale: {
            format: 'DD/MM/YYYY',
            applyLabel: "Áp dụng",
            cancelLabel: "Hủy",
            customRangeLabel: "Tùy chỉnh",
            daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
            monthNames: [
                "Tháng 1",
                "Tháng 2",
                "Tháng 3",
                "Tháng 4",
                "Tháng 5",
                "Tháng 6",
                "Tháng 7",
                "Tháng 8",
                "Tháng 9",
                "Tháng 10",
                "Tháng 11",
                "Tháng 12",
            ],
        },
        ranges: {
            'Tháng này': [moment().startOf('month'), moment().endOf('month')],
            'Tháng trước': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '3 tháng trước': [moment().subtract(3, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '6 tháng trước': [moment().subtract(6, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'Năm nay': [moment().startOf('year'), moment().endOf('year')],
            'Năm trước': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
        }
    }, function (start, end, label) {
        pub_page = 1;
        fetchData();
    });

    $(document).on('click', '.pagination a', function (event) {
        event.preventDefault();
        pub_page = $(this).attr('href').split('page=')[1];
        fetchData();
    });

    fetchData();
});

$('#wallet_fluctuaton_kind').on('change', function (event) {
    pub_page = 1;
    fetchData();
});

$('#keywords').on('keydown', function (event) {
    if (event.key === "Enter" || event.keyCode === 13) {
        event.preventDefault(); // Ngăn hành động mặc định (nếu có, ví dụ submit form)
        pub_page = 1;
        fetchData();
    }
});

function getFilters() {
    return {
        keywords: $('#keywords').val(),
        kind: $('#wallet_fluctuaton_kind').val(),
        date_range: {
            start_date: $('input[name="datetimes"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
            end_date: $('input[name="datetimes"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
        },
    }
}


function fetchData() {
    try {
        const url = window.location.origin + '/accountant/wallet-fluctuations/paginate';

        const data = {
            paginate: {
                page: pub_page,
                limit: pub_limit
            },
            filters: getFilters(),
        }


        ajaxPostHTML(url, data, 'content');
    } catch (error) {
        $('#content').html('<p class="text-center text-secondary">Xảy ra lỗi khi tải dữ liệu</p>');
    }
}