let pub_limit = 30;
let pub_page = 1;


$(document).ready(function () {
    $('input[name="datetimes"]').daterangepicker({
        opens: 'left',
        startDate: moment().subtract(3, 'months').startOf('month'),
        endDate: moment().endOf('month'),
        locale: {
            format: 'DD/MM/YYYY',
            applyLabel: "Áp dụng",
            cancelLabel: "Hủy",
            customRangeLabel: "Tùy chỉnh",
            daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
            monthNames: [
                "Tháng 1",
                "Tháng 2",
                "Tháng 3",
                "Tháng 4",
                "Tháng 5",
                "Tháng 6",
                "Tháng 7",
                "Tháng 8",
                "Tháng 9",
                "Tháng 10",
                "Tháng 11",
                "Tháng 12",
            ],
        },
        ranges: {
            'Tháng này': [moment().startOf('month'), moment().endOf('month')],
            'Tháng trước': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '3 tháng trước': [moment().subtract(3, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '6 tháng trước': [moment().subtract(6, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'Năm nay': [moment().startOf('year'), moment().endOf('year')],
            'Năm trước': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
        }
    }, function (start, end, label) {
        pub_page = 1;
        fetchData()
    });

    fetchData()
});


function getFilters() {
    return {
        keywords: $('#keywords').val(),
        statement_status: $('#statement_status').val(),
        statement_payment_method: $('#statement_payment_method').val(),
        checked_payment_status: $('#checked_payment_status').val(),
        date_range: {
            start_date: $('input[name="datetimes"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
            end_date: $('input[name="datetimes"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
        },
    }
}

$('#keywords').on('keypress', function (e) {
    if (e.which === 13) {
        pub_page = 1;
        fetchData();
    }
})

$('#statement_status, #statement_payment_method, #checked_payment_status').on('change', function (e) {
    pub_page = 1;
    fetchData();
})

$(document).on('click', '.pagination a', function (event) {
    event.preventDefault();
    pub_page = $(this).attr('href').split('page=')[1];
    fetchData();
});


function fetchData() {

    const url = window.location.origin + '/statement/paginate'
    const data = {
        paginater: {
            page: pub_page,
            limit: pub_limit
        },
        filters: getFilters()
    }

    ajaxPostHTML(url, data, 'content')
}

async function onCreateStatement() {
    onBtnLoading('#btn-statement', true);
    try {
        const url = window.location.origin + '/statement/create';
        const data = {
            fwd_id: $('#fwd_id').val(),
            statement_start: $('#statement_start').val(),
            statement_end: $('#statement_end').val(),
        }
        let res = await ajaxContants2(url, 'POST', data);
        if (res.status == 200) {
            onShowModal('#modalCreateStatement', false);
            fetchData();
        }
        showMessage(res.message);
    } catch (error) {
        showMessage();
    }
    onBtnLoading('#btn-statement', false, 'Xác nhận');
}

async function onCancelStatement(statement_no) {

    try {
        Swal.fire({
            title: "Thông báo",
            text: 'Bạn có chắc chắn muốn hủy lệnh statement ' + statement_no + ' không?',
            icon: "question",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Xác nhận",
            cancelButtonText: "Hủy",
        }).then(async (result) => {
            if (result.isConfirmed) {
                const url = window.location.origin + '/statement/cancel';
                const data = {
                    statement_code: statement_no,
                }
                let res = await ajaxContants2(url, 'POST', data);
                if (res.status == 200) {
                    fetchData();
                }
                showMessage(res.message);
            }
        });
    } catch (error) {
        if (error.responseJSON.message) {
            showMessage(error.responseJSON.message);
        }
    }

}