let limit = 30, page = 1;

$(document).ready(function () {
    $(".select2").select2();

    $('input[name="shipment_daterange"]').daterangepicker({
        opens: 'left',
        startDate: moment().subtract(3, 'months').startOf('month'),
        endDate: moment().endOf('month'),
        locale: {
            format: 'DD/MM/YYYY',
            applyLabel: "Áp dụng",
            cancelLabel: "Hủy",
            customRangeLabel: "Tùy chỉnh",
            daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
            monthNames: [
                "Tháng 1",
                "Tháng 2",
                "Tháng 3",
                "Tháng 4",
                "Tháng 5",
                "Tháng 6",
                "Tháng 7",
                "Tháng 8",
                "Tháng 9",
                "Tháng 10",
                "Tháng 11",
                "Tháng 12",
            ],
        },
        ranges: {
            'Tháng này': [moment().startOf('month'), moment().endOf('month')],
            'Tháng trước': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '3 tháng trước': [moment().subtract(3, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '6 tháng trước': [moment().subtract(6, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'Năm nay': [moment().startOf('year'), moment().endOf('year')],
            'Năm trước': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
        }
    }, function (start, end, label) {
        page = 1;
        fetchData();
    });

    fetchData();
});

$(document).on('click', '.pagination a', function (event) {
    event.preventDefault();
    page = $(this).attr('href').split('page=')[1];
    fetchData();
});

function getFilters() {
    return {
        date_range: {
            start_date: $('input[name="shipment_daterange"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
            end_date: $('input[name="shipment_daterange"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
        },
        shipment_branch_id: $('[name="shipment_branch_id"]').val(),
        shipment_status: $('[name="shipment_status"]').val(),
        shipment_payment_status: $('[name="shipment_payment_status"]').val(),
        keywords: $('#keywords').val(),
        shipment_paid_by: $('[name="shipment_paid_by"]').val(),
        shipment_payment_method: $('[name="shipment_payment_method"]').val(),
    }
}


$('[name="shipment_branch_id"], [name="shipment_status"], [name="shipment_paid_by"], [name="shipment_payment_status"], [name="shipment_payment_method"]').on('change', function () {
    page = 1;
    fetchData();
});
$('#keywords').on('keypress', function (e) {
    if (e.which === 13) { // 13 là mã ASCII của phím Enter
        page = 1;
        console.log(getFilters());
        fetchData();
    }
})

function fetchData() {
    try {
        const url = window.location.origin + '/accountant/shipment-paginate'
        let data = {
            is_api: false,
            limit: limit,
            page: page,
            filters: JSON.stringify(Object.assign({}, getFilters())),
        };

        ajaxPostHTML(url, data, 'show_table_content')

    } catch (error) {
        console.log(error);
    }
}

function onConfirmShipment(shipment_code) {
    Swal.fire({
        title: "Thông báo",
        icon: 'question',
        text: 'Bạn có muốn xác nhận lệnh này không?',
        input: "textarea",
        inputPlaceholder: "Nhập ghi chú tại đây (không quá 225 kí tự)",
        inputValidator: (value) => {
            // if (!value) {
            //     return 'Bạn phải nhập nguyên nhân hủy!';
            // } else if (value.length > 225) {
            //     return 'Nguyên nhân không được vượt quá 225 kí tự!';
            // }
            if (value && value.length > 225) {
                return 'Nội dung không vượt quá 225 kí tự!';
            }
        },
        showCancelButton: true,
        confirmButtonColor: "#d33",
        showLoaderOnConfirm: true,
        preConfirm: async (note) => {
            try {
                const url = window.location.origin + "/accountant/shipment-acction";
                const data = {
                    shipment_code: shipment_code,
                    accountant_status: 1,
                    shipment_payment_des: note
                }
                const response = await ajaxContants2(url, 'POST', data);
                return response
            } catch (error) {
                Swal.showValidationMessage('Xảy ra lỗi khi gọi lên serve');
            }
        },
        allowOutsideClick: () => !Swal.isLoading()
    }).then((result) => {

        if (result.isConfirmed) {
            const res = result.value;
            if (res.status == 200) {
                fetchData()
            }
            Swal.fire(res.message || 'Đã xảy ra lỗi');
        }

    });

}

async function onConfirmShipment2(shipment_code, price) {
    await Swal.fire({
        title: "Thông báo xác nhận thanh toán",
        icon: 'question',
        html: `
            <div class="mx-3 mt-3 text-start">
                <div class="mb-3">
                    <label for="" class="form-label">Tổng tiền</label>
                    <input type="text" class="form-control text-float" id="payment_total" value="${formatNumber2(price, 0)}">
                </div>
                <div class="mb-3">
                    <label for="" class="form-label">Chuyển khoản</label>
                    <input type="text" class="form-control text-float" id="payment_bank" value="${formatNumber2(price, 0)}">
                </div>
                <div class="mb-3">
                    <label for="" class="form-label">Tiền mặt</label>
                    <input type="text" class="form-control text-float" id="payment_cash" value="0">
                </div>
                <textarea class="mb-3 form-control" id="shipment_payment_note2" rows="3" placeholder="Nhập ghi chú"></textarea>
            </div>
        `,
        showCancelButton: true,
        confirmButtonColor: "#d33",
        showLoaderOnConfirm: true,
        didOpen: () => {
            // Chạy sau khi modal đã mở
       
            $('#payment_bank, #payment_cash, #payment_total').on('input', function () {
                let total_price = convertStringToNumber2(document.getElementById('payment_total').value);
                let bank_price = convertStringToNumber2(document.getElementById('payment_bank').value);
                let cash_price = convertStringToNumber2(document.getElementById('payment_cash').value);
                let input_id = $(this).attr('id');
        
                if (input_id === 'payment_bank') {
                    $('#payment_cash').val(formatNumber2(total_price - bank_price, 0));
                } else if (input_id === 'payment_cash') {
                    $('#payment_bank').val(formatNumber2(total_price - cash_price, 0));
                } else {
                    $('#payment_cash').val(formatNumber2(total_price - bank_price, 0))
                }
        
            })

            // onSetValuePrice();
        },
        preConfirm: async () => {
            try {
                const url = window.location.origin + "/accountant/shipment-acction";
                const data = {
                    shipment_code: shipment_code,
                    accountant_status: 1,
                    shipment_payment_des: $('#shipment_payment_note2').val(),
                    payment_bank: convertStringToNumber2($('#payment_bank').val()),
                    payment_cash: convertStringToNumber2($('#payment_cash').val()),
                };
                const response = await ajaxContants2(url, 'POST', data);
                return response;
            } catch (error) {
                Swal.showValidationMessage('Xảy ra lỗi khi gọi lên server');
            }
        },
        allowOutsideClick: () => !Swal.isLoading()
    }).then((result) => {
        if (result.isConfirmed) {
            const res = result.value;
            if (res.status == 200) {
                fetchData();
            }
            Swal.fire(res.message || 'Đã xảy ra lỗi');
        }
    });

}

function convertStringToNumber2(value) {
    if (typeof str !== "string") return value; // Kiểm tra kiểu dữ liệu đầu vào
    return Number(str.replace(/,/g, ""));
}

function onSetValuePrice() {
    
    $('input.text-number').on('input', function (e) {
        let val = $(this).val();
        $(this).val(formatNumber(val));
    });
}

async function setConfirmShipment(data) {
    try {
        const url = window.location.origin + "/accountant/shipment-acction";
        const result = await ajaxContants2(url, 'POST', data);
        if (result.status == 200) {
            fetchData();
        }
        showMessage(result.message);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}

async function onCancelShipment(shipment_code) {
    Swal.fire({
        title: "Thông báo",
        icon: "warning",
        text: "Bạn có chắc chắn muốn hủy lệnh này không?",
        input: "textarea",
        inputPlaceholder: "Nhập nguyên nhân hủy tại đây (không quá 225 kí tự)",
        inputValidator: (value) => {
            // if (!value) {
            //     return 'Bạn phải nhập nguyên nhân hủy!';
            // } else if (value.length > 225) {
            //     return 'Nguyên nhân không được vượt quá 225 kí tự!';
            // }
            if (value && value.length > 225) {
                return 'Nội dung không vượt quá 225 kí tự!';
            }
        },
        showCancelButton: true,
        confirmButtonColor: "#d33",
        showLoaderOnConfirm: true,
        preConfirm: async (note) => {
            try {
                const url = window.location.origin + "/accountant/shipment-acction";
                const data = {
                    shipment_code: shipment_code,
                    accountant_status: 2,
                    accountant_cancel_note: note
                }
                const response = await ajaxContants2(url, 'POST', data);
                return response
            } catch (error) {
                Swal.showValidationMessage('Xảy ra lỗi khi gọi lên serve');
            }
        },
        allowOutsideClick: () => !Swal.isLoading()
    }).then((result) => {

        if (result.isConfirmed) {
            const res = result.value;
            if (res.status == 200) {
                fetchData()
            }
            Swal.fire(res.message || 'Đã xảy ra lỗi');
        }
    });
}

function onAccountantConfirm(shipment_code) {
    return Swal.fire({
        icon: 'question',
        title: 'Thông báo',
        text: 'Xác nhận cho phép hàng xuất',
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        confirmButtonText: 'Xác Nhận',
        cancelButtonColor: "#d33",
        cancelButtonText: 'Hủy',
    }).then(async (result) => {
        if (result.isConfirmed) {
            const url = window.location.origin + "/accountant/shipment-acction";
            const data = {
                shipment_code: shipment_code,
                accountant_status: 1,
                is_only_confirm: 1
            }
            const response = await ajaxContants2(url, 'POST', data);
            if (response.status == 200) {
                fetchData()
            }
            showMessage(response.message);
        }
    });
}