let pub_limit = 100;
let pub_page = 1;
let pub_financial_code = null;

$(document).ready(function () {
    $('input[name="datetimes"]').daterangepicker({
        opens: 'left',
        startDate: moment().subtract(3, 'months').startOf('month'),
        endDate: moment().endOf('month'),
        locale: {
            format: 'DD/MM/YYYY',
            applyLabel: "Áp dụng",
            cancelLabel: "Hủy",
            customRangeLabel: "Tùy chỉnh",
            daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
            monthNames: [
                "Tháng 1",
                "Tháng 2",
                "Tháng 3",
                "Tháng 4",
                "Tháng 5",
                "Tháng 6",
                "Tháng 7",
                "Tháng 8",
                "Tháng 9",
                "Tháng 10",
                "Tháng 11",
                "Tháng 12",
            ],
        },
        ranges: {
            'Tháng này': [moment().startOf('month'), moment().endOf('month')],
            'Tháng trước': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '3 tháng trước': [moment().subtract(3, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '6 tháng trước': [moment().subtract(6, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'Năm nay': [moment().startOf('year'), moment().endOf('year')],
            'Năm trước': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
        }
    }, function (start, end, label) {
        pub_page = 1;
        fetchData();
    });

    fetchData()
});

var financialImages = new Dropzone("#financialImages", {
    url: "/upload",
    autoProcessQueue: false,
    paramName: "file",
    clickable: true,
    maxFilesize: 10, // MB
    addRemoveLinks: true,
    acceptedFiles: '.png,.jpg',
    dictDefaultMessage: "Tải hình ảnh ở đây",

    init: function () {
        var dropzone = this;
        dropzone.on("complete", function (file) {
        });
        dropzone.on("addedfile", function (file) {
        });
        dropzone.on("removedfile", function (file) {
        });
        $('#modalFinancial').on('hidden.bs.modal', function () {
            dropzone.removeAllFiles(true);
        });
    }
});


$('#keywords').on('keypress', function (e) {
    if (e.which === 13) { // 13 là mã ASCII của phím Enter
        fetchData();
    }
})

function getFilters() {
    return {
        keywords: $('#keywords').val(),
        financial_branch_id: $('#financial_branch').val(),
        financial_type: $('#financial_type').val(),
        financial_method: $('#financial_method').val(),
        financial_is_salary: $('#financial_is_salary_select').val(),
        date_range: {
            start_date: $('input[name="datetimes"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
            end_date: $('input[name="datetimes"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
        },
    }
}

$('#financial_type, #financial_method, #financial_branch, #financial_is_salary_select').on('change', function () {
    pub_page = 1;
    fetchData();
});

$(document).on('click', '.pagination a', function (event) {
    event.preventDefault();
    pub_page = $(this).attr('href').split('page=')[1];
    fetchData();
});

function fetchData() {
    const url = window.location.origin + '/accountant/financial-paginate';

    const data = {
        paginate: {
            limit: pub_limit,
            page: pub_page,
        },
        filters: getFilters(),
    }

    const callback = (res) => {
        if (res.charts) {
            let dataChart = res.charts;
            createChart(dataChart);
        }
        if (res.statis_amount) {
            let statis_amount = res.statis_amount;

            let total_chi_bank = statis_amount.total_chi_bank
            $('#total_chi_bank').html(total_chi_bank.toLocaleString() + ' vnd');

            let total_chi_cash = statis_amount.total_chi_cash;
            $('#total_chi_cash').html(total_chi_cash.toLocaleString() + ' vnd');

            let total_chi = statis_amount.total_chi_bank + statis_amount.total_chi_cash;
            $('#total_chi').html(total_chi.toLocaleString() + ' vnd');

            let total_thu_cash = statis_amount.total_thu_cash;
            $('#total_thu_cash').html(total_thu_cash.toLocaleString() + ' vnd');

            let total_cash_con = statis_amount.total_thu_cash - statis_amount.total_chi_cash;
            $('#total_cash_con').html(total_cash_con.toLocaleString() + ' vnd');

            let total_salary = statis_amount.total_salary;
            $('#total_salary').html(total_salary.toLocaleString() + ' vnd');
        }
    }
    ajaxPostHTML(url, data, 'content', callback)
}


function emptyValidate() {
    $('#financial_customer_name_err').html('');
    $('#financial_amount_err').html('');
    $('#financial_images_err').html('');
    $('#financial_content_err').html('');
}

async function onCreateOrUpdateFinancial() {

    try {
        emptyValidate()
        if ($('input[name="financial_method"]:checked').val() == 1 && Dropzone.forElement("#financialImages").files.length <= 0) {
            $('#financial_images_err').html('Không được để trống hình ảnh');
            return
        }
        var dataURLs = [];
        var old_imgs = [];
        for (let file of Dropzone.forElement("#financialImages").files) {
            if (file instanceof Blob || file instanceof File) {
                let base64 = await readFileAsBase64(file);
                dataURLs.push(base64);
            } else {
                let startIndex = file.dataURL.indexOf("uploads/images/");
                let relativePath = file.dataURL.substring(startIndex);
                old_imgs.push(relativePath);
            }
        }
        const url = window.location.origin + '/accountant/financial-handle';
        const data = {
            financial_code: pub_financial_code,
            financial_branch_id: $('#financial_branch_id').val(),
            financial_type: $('input[name="financial_type"]:checked').val(),
            financial_amount: convertStringToNumber($('#financial_amount').val()),
            financial_method: $('input[name="financial_method"]:checked').val(),
            financial_customer_name: $('#financial_customer_name').val(),
            financial_content: $('#financial_content').val(),
            financial_is_salary: $('#financial_is_salary').prop('checked') ? 1 : 0,
            financial_images: JSON.stringify(dataURLs),
            financial_old_imgs: JSON.stringify(old_imgs),
        }

        let res = await ajaxContants2(url, "POST", data);
        console.log(res);

        if (res.status === 200) {
            fetchData();
            onShowModal('#modalFinancial', false, null, onHiden);
            showMessage(res.message)
        } else if (res.status == 422) {
            let errors = res.error;
            if (errors) {
                Object.entries(errors).forEach(([key, item]) => {
                    if ($(`#${key}_err`).length) {
                        $(`#${key}_err`).html(item[0]);
                    }
                });
            }
            showMessage({
                text: 'Kiểm tra dữ liệu nhập vào'
            })
        } else {
            showMessage(res.message)
        }
    } catch (error) {
        showMessage();
    }

}



const onHiden = () => {
    pub_financial_code = null;
    // if (Dropzone.forElement("#modalFinancial")) {
    //     Dropzone.forElement("#modalFinancial").removeAllFiles(true);
    // }
    $('#financial_amount').val(0);
    $('#financial_customer_name').val('');
    $('#financial_content').val('');
    $('#financial_is_salary').prop('checked', false);

    $('#modalFinancialLabel').html('Khởi tạo thu/chi')

    $('#modal_content_imgs').html('');
    emptyValidate()

}


$(document).ready(function () {
    $('#modalFinancial').on('hidden.bs.modal', function () {
        onHiden();
    })
})

async function onShowModalFinancial(code) {
    $('#modalFinancialLabel').html('Thu/chi mã: ' + code);
    const url = window.location.origin + '/accountant/financial-detail';
    const data = {
        financial_code: code,
    }

    let res = await ajaxContants2(url, "POST", data);
    if (res.status == 200) {
        const data = res.financial;
        pub_financial_code = data.financial_code;
        let images = JSON.parse(data.financial_images);
        images.forEach(element => {
            let url_img = window.location.origin + '/' + element;

            let mockFile = { name: "Filename", size: 3000000 };
            financialImages.displayExistingFile(mockFile, url_img);
            financialImages.files.push(mockFile);
        });

        $('#financial_branch_id').val(data.financial_branch_id)
        $('#financial_amount').val(data.financial_amount);
        $('#financial_customer_name').val(data.financial_customer_name);
        $('#financial_content').val(data.financial_content);
        $('#financial_is_salary').prop('checked', data.financial_is_salary == 1);

        $('input[name="financial_type"][value="' + data.financial_type + '"]').prop('checked', true);
        $('input[name="financial_method"][value="' + data.financial_method + '"]').prop('checked', true);



        onShowModal('#modalFinancial', true, null, onHiden);
    } else {
        showMessage(res.message)
    }
}


async function onDeleteFinancial(code) {
    Swal.fire({
        title: "Thông báo",
        text: 'Bạn có chắc muốn xóa chi tiêu này không?',
        icon: "question",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Xác nhận",
        cancelButtonText: "Hủy",
    }).then(async (result) => {
        if (result.isConfirmed) {
            const url = window.location.origin + '/accountant/financial-delete';
            const data = {
                financial_code: code,
            }

            let res = await ajaxContants2(url, "POST", data);
            if (res.status == 200) fetchData();
            showMessage(res.message)
        }
    });
}


async function exportExcelFinancial() {
    try {
        onBtnLoading('#btn_export_financial', true)
        let url = window.location.origin + '/accountant/financial-paginate'
        let data = {
            filters: getFilters(),
            export_excel: true
        };
        const response = await fetch(url, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify(data)
        });

        if (response.ok) {
            const blob = await response.blob(); // Chuyển kết quả sang dạng blob
            const link = document.createElement('a');
            link.href = window.URL.createObjectURL(blob);
            link.download = 'export.xlsx'; // Tên file tải về
            link.click(); // Tự động tải file
        } else {
            showMessage({
                icon: 'error',
                text: 'Xuất file excel thất bại'
            })
        }
        onBtnLoading('#btn_export_financial', false, 'Export')
    } catch (error) {
        onBtnLoading('#btn_export_financial', false, 'Export')
        console.error(error);
        showMessage()

    }
}

var chart = null;
function createChart(data) {
    if (chart) {
        chart.destroy();
    }

    var options = {
        series: [{
            name: 'Thu',
            data: data.total_thu
        }, {
            name: 'Chi',
            data: data.total_chi
        }],
        chart: {
            type: 'bar',
            height: 350
        },
        plotOptions: {
            bar: {
                horizontal: false,
                columnWidth: '55%',
            },
        },
        dataLabels: {
            enabled: false
        },
        stroke: {
            show: true,
            width: 2,
            colors: ['transparent']
        },
        colors: ['#4CAF50', '#FF0000'],
        xaxis: {
            categories: data.month,
        },
        yaxis: {
            title: {
                text: 'VND'
            },
            labels: {
                formatter: function (value) {
                    return value.toLocaleString();
                },
            },
        },
        fill: {
            opacity: 1
        },
        tooltip: {
            y: {
                formatter: function (val) {
                    return val.toLocaleString() + " vnd";
                }
            }
        }
    };

    var chart = new ApexCharts(document.querySelector("#column_chart_1"), options);
    chart.render();
}



