let limit = 30;
let page = 1;

function getFilters() {
    return {
        keywords: $('#keywords').val(),
        filter_by: $('#filter_by').val(),
        debit_type: $('#debit_type').val(),
        debit_status: $('#debit_status').val(),
        debit_account: 1,
        date_range: {
            start_date: $('input[name="datetimes"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
            end_date: $('input[name="datetimes"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
        },
        admin_confirm: $('#admin_confirm').val(),
    }
}

$(document).ready(function () {
    $('input[name="datetimes"]').daterangepicker({
        opens: 'left',
        startDate: moment().subtract(3, 'months').startOf('month'),
        endDate: moment().endOf('month'),
        locale: {
            format: 'DD/MM/YYYY',
            applyLabel: "Áp dụng",
            cancelLabel: "Hủy",
            customRangeLabel: "Tùy chỉnh",
            daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
            monthNames: [
                "Tháng 1",
                "Tháng 2",
                "Tháng 3",
                "Tháng 4",
                "Tháng 5",
                "Tháng 6",
                "Tháng 7",
                "Tháng 8",
                "Tháng 9",
                "Tháng 10",
                "Tháng 11",
                "Tháng 12",
            ],
        },
        ranges: {
            'Tháng này': [moment().startOf('month'), moment().endOf('month')],
            'Tháng trước': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '3 tháng trước': [moment().subtract(3, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '6 tháng trước': [moment().subtract(6, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'Năm nay': [moment().startOf('year'), moment().endOf('year')],
            'Năm trước': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
        }
    }, function (start, end, label) {
        page = 1;
        fetchData();
    });

    $('input[name="datetimes2"]').daterangepicker({
        opens: 'left',
        startDate: moment().subtract(3, 'months').startOf('month'),
        endDate: moment().endOf('month'),
        locale: {
            format: 'DD/MM/YYYY',
            applyLabel: "Áp dụng",
            cancelLabel: "Hủy",
            customRangeLabel: "Tùy chỉnh",
            daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
            monthNames: [
                "Tháng 1",
                "Tháng 2",
                "Tháng 3",
                "Tháng 4",
                "Tháng 5",
                "Tháng 6",
                "Tháng 7",
                "Tháng 8",
                "Tháng 9",
                "Tháng 10",
                "Tháng 11",
                "Tháng 12",
            ],
        },
        ranges: {
            'Tháng này': [moment().startOf('month'), moment().endOf('month')],
            'Tháng trước': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '3 tháng trước': [moment().subtract(3, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '6 tháng trước': [moment().subtract(6, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'Năm nay': [moment().startOf('year'), moment().endOf('year')],
            'Năm trước': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
        }
    }, function (start, end, label) {

    });

    Dropzone.autoDiscover = false;

    // Khởi tạo Dropzone trên phần tử với id "debitFwdDropzone"
    var debitFwdDropzone = new Dropzone("#debitFwdDropzone", {
        url: "/upload",
        autoProcessQueue: false,
        paramName: "file",
        clickable: true,
        maxFilesize: 10, // MB
        addRemoveLinks: true,
        acceptedFiles: '.png,.jpg',
        dictDefaultMessage: "Tải hình ảnh ở đây",

        init: function () {
            var dropzone = this;
            dropzone.on("complete", function (file) {
            });
            dropzone.on("addedfile", function (file) {
            });
            dropzone.on("removedfile", function (file) {
            });
        }
    });

    var debitAdvanceDropzone = new Dropzone("#debitAdvanceDropzone", {
        url: "/upload",
        autoProcessQueue: false,
        paramName: "file",
        clickable: true,
        maxFilesize: 10, // MB
        addRemoveLinks: true,
        acceptedFiles: '.png,.jpg',
        dictDefaultMessage: "Tải hình ảnh ở đây",

        init: function () {
            var dropzone = this;
            dropzone.on("complete", function (file) {
            });
            dropzone.on("addedfile", function (file) {
            });
            dropzone.on("removedfile", function (file) {
            });
        }
    });
});


$('#keywords').on('keypress', function (e) {
    if (e.which === 13) { // 13 là mã ASCII của phím Enter
        page = 1;
        fetchData();
    }
})



$(document).ready(function () {
    fetchData()
});

$(document).on('click', '.pagination a', function (event) {
    event.preventDefault();
    page = $(this).attr('href').split('page=')[1];
    fetchData();
});


$('#debit_status, #debit_type, #admin_confirm').on('change', function () {
    page = 1;
    fetchData();
});


function fetchData(_url = null, _page = null, _limit = null, filters = null) {
    if (!_url) {
        _url = window.location.origin + '/debit/list'
    }

    let _data = {
        paginate: {
            limit: _limit === null ? limit : _limit,
            page: _page === null ? page : _page,
        },
        is_cancel: true,
        filters: filters === null ? getFilters() : filters,
    }

    const callback = (res) => {
        let header_debit = res.header_debit;
        $('#debit_pedding').text(`(${header_debit.number_pendding} đơn) ` + header_debit.price_pendding.toLocaleString() + ' vnd ');
        $('#debit_success').text(`(${header_debit.number_success} đơn) ` + header_debit.price_success.toLocaleString() + ' vnd ');
        $('#debit_warning').text(`(${header_debit.number_warning} đơn) ` + header_debit.price_warning.toLocaleString() + ' vnd ');

        let dataChart = res.chart;
        // createChart(dataChart);
    }


    ajaxPostHTML(_url, _data, 'content', callback)
}



let pub_debit_no = null;

function onShowModalPaymentDebit(code) {

    const onHiden = () => {
        pub_debit_no = null;
        Dropzone.forElement("#debitFwdDropzone").removeAllFiles(true);
        $('#payment_method_bank').prop('checked', true);
        $('#modalPaymentDebitLabel').html('Thanh toán debit: ')
        $('#images_debit_err').html('');

    }

    const onShow = () => {
        $('#modalPaymentDebitLabel').html('Thanh toán debit: ' + code);
    }

    onShowModal('#modalPaymentDebit', true, onShow, onHiden);

    pub_debit_no = code;

}

function onPaymentDebit() {

    try {
        if (Dropzone.forElement("#debitFwdDropzone").files.length <= 0) {
            $('#images_debit_err').html('Không được để trống hình ảnh');
            return
        }
        $('#images_debit_err').html('');

        var dataURLs = [];

        Dropzone.forElement("#debitFwdDropzone").files.forEach(async function (file) {
            let base64 = await readFileAsBase64(file);
            dataURLs.push(base64);
        })


        const callback = async () => {

            let _url = window.location.origin + '/debit/payment-fwd';
            let _data = {
                debit_no: pub_debit_no,
                debits_images: JSON.stringify(dataURLs),
                debit_note: $('#note_debit').val(),
                debit_payment_method: $('input[name="debit_payment_method"]:checked').val()
            }

            let res = await ajaxContants2(_url, "POST", _data);

            if (res.status === 200) {
                fetchData();
                onShowModal('#modalPaymentDebit', false);
            } else {

            }
            showMessage(res.message)
        }

        onConfirmAction({
            icon: 'warning',
            title: 'Thông báo',
            text: 'Xác nhận thanh toán công nợ'
        }, callback)
    } catch (error) {
        showMessage();
    }

}

function onAdvanceDebit() {

    try {
        if (Dropzone.forElement("#debitFwdDropzone").files.length <= 0) {
            $('#images_debit_err').html('Không được để trống hình ảnh');
            return
        }
        $('#images_debit_err').html('');

        var dataURLs = [];

        Dropzone.forElement("#debitFwdDropzone").files.forEach(async function (file) {
            let base64 = await readFileAsBase64(file);
            dataURLs.push(base64);
        })


        const callback = async () => {

            let _url = window.location.origin + '/debit/payment-fwd';
            let _data = {
                debit_no: pub_debit_no,
                debits_images: JSON.stringify(dataURLs),
                debit_note: $('#note_debit').val(),
                debit_payment_method: $('input[name="debit_payment_method"]:checked').val()
            }

            let res = await ajaxContants2(_url, "POST", _data);

            if (res.status === 200) {
                fetchData();
                onShowModal('#modalPaymentDebit', false);
            } else {

            }
            showMessage(res.message)
        }

        onConfirmAction({
            icon: 'warning',
            title: 'Thông báo',
            text: 'Xác nhận thanh toán công nợ'
        }, callback)
    } catch (error) {
        showMessage();
    }

}

function onShowModalPaymentDebit(code) {

    const onHiden = () => {
        pub_debit_no = null;
        Dropzone.forElement("#debitAdvanceDropzone").removeAllFiles(true);
        $('#modalPaymentDebitLabel').html('Tạm ứng debit: ')
        $('#images_advance_err').html('');
        $('#debit_advance_amount_err').html('');

    }

    const onShow = () => {
        $('#modalPaymentDebitLabel').html('Tạm ứng debit: ' + code);
    }

    onShowModal('#modalAdvanceDebit', true, onShow, onHiden);

    pub_debit_no = code;

}

async function onCancelDebit(params) {
    try {
        Swal.fire({
            title: "Thông báo",
            text: 'Bạn có chắc chắn muốn hủy lệnh không',
            icon: "question",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Xác nhận",
            cancelButtonText: "Hủy",
        }).then(async (result) => {
            if (result.isConfirmed) {
                const url = window.location.origin + '/debit/fwd/cancel-debit';
                const data = {
                    debit_id: params
                }
                const res = await ajaxContants2(url, "POST", data);
                if (res.status == 200) {
                    fetchData()
                }
                showMessage(res.message)
            }
        });
    } catch (error) {
        if (error.responseJSON.message) {
            showMessage(error.responseJSON.message);
        }
    }
}



// export excel debit
async function getDataExcel() {
    onBtnLoading('#btn_export_debit', true)
    try {
        let _url = window.location.origin + '/debit/list'
        let data = {
            filters: getFilters(),
            export_excel: true
        };
        const result = await sendRequest(_url, 'POST', data);
        if (result.status == 200) {
            await exportExcel(result.excels);
        } else {
            showMessage(res.message)
        }
        onBtnLoading('#btn_export_debit', false, 'Export')
    } catch (error) {
        onBtnLoading('#btn_export_debit', false, 'Export')
    }


}

async function exportExcel(_excels) {
    if (_excels.length < 1) {
        return showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: 'Không có dữ liệu để xuất'
        })
    }

    let excels = [];

    _excels.forEach(function (item, index) {
        let _item = {
            ThoiGian: convertTimeFormat(item.created_at),
            DebitNo: item.debit_no,
            Company: item.customer_company,
            NguoiTao: item.creator_name,
            Loai: item.type_label,
            TrangThai: item.status_label,
            MaKhach: item.customer_code,
            TongVat: item.total_vat,
            TongTien: item.total_price,
        }
        excels.push(_item)
    })


    const worksheet = XLSX.utils.json_to_sheet(excels);


    // Đặt độ rộng cho các cột
    worksheet['!cols'] = [
        { wpx: 150 },
        { wpx: 150 },
        { wpx: 300 },
        { wpx: 100 },
        { wpx: 100 },
        { wpx: 100 },
        { wpx: 100 },
        { wpx: 100 },
        { wpx: 100 },
        { wpx: 100 },
    ];


    // Tạo một workbook mới và thêm worksheet vào
    const workbook = XLSX.utils.book_new();
    XLSX.utils.book_append_sheet(workbook, worksheet, 'Sheet1');

    // Xuất workbook ra file Excel
    const excelBuffer = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });

    // Tạo một Blob và sử dụng FileSaver.js để lưu file
    const blob = new Blob([excelBuffer], { type: 'application/octet-stream' });
    saveAs(blob, 'debit.xlsx');
}

// export excel shipment

async function exportExcelShipment() {
    try {
        onBtnLoading('#btn_export_sm', true)
        let url = window.location.origin + '/debit/fwd/export-shipment'
        let data = {
            filters: getFilters(),
            export_excel: true
        };
        // const response = await sendRequest(url, 'POST', data);
        const response = await fetch(url, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify(data)
        });

        if (response.ok) {
            const blob = await response.blob(); // Chuyển kết quả sang dạng blob
            const link = document.createElement('a');
            link.href = window.URL.createObjectURL(blob);
            link.download = 'export.xlsx'; // Tên file tải về
            link.click(); // Tự động tải file
        } else {
            showMessage(res.message)
        }
        onBtnLoading('#btn_export_sm', false, 'Export')
    } catch (error) {
        onBtnLoading('#btn_export_sm', false, 'Export')
        showMessage(res.message)

    }
}

async function exportExcelShipmentForService() {
    try {
        onBtnLoading('#btn_export_sm_service', true)
        let url = window.location.origin + '/debit/fwd/export-shipment'
        let filters = getFilters();
        filters.service_id = $('#export_service_id').val();
        let data = {
            filters: filters,
            export_excel: true
        };
        // const response = await sendRequest(url, 'POST', data);
        const response = await fetch(url, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify(data)
        });

        if (response.ok) {
            const blob = await response.blob(); // Chuyển kết quả sang dạng blob
            const link = document.createElement('a');
            link.href = window.URL.createObjectURL(blob);
            link.download = 'export.xlsx'; // Tên file tải về
            link.click(); // Tự động tải file
        } else {
            showMessage()
        }
        onBtnLoading('#btn_export_sm_service', false, 'Export')
    } catch (error) {
        onBtnLoading('#btn_export_sm_service', false, 'Export')
        showMessage()

    }
}

async function onExportExcel(type = null) {
    let data = {
        is_api: false,
        export_excel: true,
        type_excel: type,
        is_cancel: true,
        filters: {
            debit_account: 1,
            service_ids: $('#export_service_id').val(),
            date_range: {
                start_date: $('input[name="datetimes2"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
                end_date: $('input[name="datetimes2"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
            },
        },
    };
    let url = "";
    let file_name = 'Report.xlsx';
    if (type == 0) {
        file_name = 'Export Debit Package.xlsx';
        url = window.location.origin + '/debit/fwd/export-shipment';

    } else if (type == 1) {
        file_name = 'Export Report Debit.xlsx';
        url = window.location.origin + '/debit/list';

    } else if (type == 2) {
        if ($('input[name="one-date"]').val() == '') {
            return showMessage({
                icon: 'warning',
                title: 'Thông báo',
                text: 'Vui lòng chọn ngày'
            })
            
        }
        file_name = `Export Report Debit Package ${$('input[name="one-date"]').val()}.xlsx`;
        url = window.location.origin + '/debit/fwd/export-shipment'
        data.filters.date_range = {
            start_date: $('input[name="one-date"]').val(),
            end_date: $('input[name="one-date"]').val(),
        }
        data.filters.service_ids = null;

    }
    await fetchExportExcel(url, data, '#btn_excel_sm', file_name);

}

