let pub_limit = 50;
let pub_page = 1;


$(document).ready(function () {
    $('input[name="datetimes"]').daterangepicker({
        opens: 'left',
        startDate: moment().subtract(3, 'months').startOf('month'),
        endDate: moment().endOf('month'),
        locale: {
            format: 'DD/MM/YYYY',
            applyLabel: "Áp dụng",
            cancelLabel: "Hủy",
            customRangeLabel: "Tùy chỉnh",
            daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
            monthNames: [
                "Tháng 1",
                "Tháng 2",
                "Tháng 3",
                "Tháng 4",
                "Tháng 5",
                "Tháng 6",
                "Tháng 7",
                "Tháng 8",
                "Tháng 9",
                "Tháng 10",
                "Tháng 11",
                "Tháng 12",
            ],
        },
        ranges: {
            'Tháng này': [moment().startOf('month'), moment().endOf('month')],
            'Tháng trước': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '3 tháng trước': [moment().subtract(3, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '6 tháng trước': [moment().subtract(6, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'Năm nay': [moment().startOf('year'), moment().endOf('year')],
            'Năm trước': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
        }
    }, function (start, end, label) {
        fetchData()
    });

    fetchData()
});


function getFilters() {
    return {
        keywords: $('#keywords').val(),
        credit_status: $('#credit_status').val(),
        date_range: {
            start_date: $('input[name="datetimes"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
            end_date: $('input[name="datetimes"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
        },
    }
}

$('#keywords').on('keypress', function (e) {
    if (e.which === 13) {
        fetchData();
    }
})


$(document).on('click', '.pagination a', function (event) {
    event.preventDefault();
    pub_page = $(this).attr('href').split('page=')[1];
    fetchData();
});


function fetchData() {

    const url = window.location.origin + '/credit'
    const data = {
        paginater: {
            page: pub_page,
            limit: pub_limit
        },
        filters: getFilters()
    }

    ajaxPostHTML(url, data, 'content')
}

async function onCreateCredit() {
    onBtnLoading('#btn-credit', true);
    try {
        const url = window.location.origin + '/credit/create';
        const data = {
            fwd_id: $('#fwd_id').val(),
        }
        let res = await ajaxContants2(url, 'POST', data);
        if (res.status == 200) {
            onShowModal('#modalCreateCredit', false);
            fetchData();
        }
        showMessage(res.message);
    } catch (error) {
        showMessage();
    }
    onBtnLoading('#btn-credit', false, 'Xác nhận');
}

async function onCancelCredit(credit_no) {

    try {
        Swal.fire({
            title: "Thông báo",
            text: 'Bạn có chắc chắn muốn hủy lệnh credit ' + credit_no + ' không?',
            icon: "question",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Xác nhận",
            cancelButtonText: "Hủy",
        }).then(async (result) => {
            if (result.isConfirmed) {
                const url = window.location.origin + '/credit/cancel';
                const data = {
                    credit_no: credit_no,
                }
                let res = await ajaxContants2(url, 'POST', data);
                if (res.status == 200) {
                    fetchData();
                }
                showMessage(res.message);
            }
        });
    } catch (error) {
        if (error.responseJSON.message) {
            showMessage(error.responseJSON.message);
        }
    }

}

new Dropzone("#imgsCreditDropzone", {
    url: "/upload",
    autoProcessQueue: false,
    paramName: "file",
    clickable: true,
    maxFilesize: 10,
    addRemoveLinks: true,
    acceptedFiles: ".jpg,.jpeg,.png,.gif",
    dictDefaultMessage: "Tải hình ảnh ở đây",
})

function onUpBillCredit(credit_no, status) {
    $('#credit_no').val(credit_no);
    if (status == 2) {
        $('#display_status_pending').removeClass('d-block').addClass('d-none');
    }
    $('#modalUpBillCredit').modal('show'); 
}

$(document).ready(function () {
    // Bắt sự kiện khi modal đóng
    $('#modalUpBillCredit').on('hidden.bs.modal', function () {
        Dropzone.forElement("#imgsCreditDropzone").removeAllFiles(true);
        $('#credit_no').val('');
        $('#credit_note').val('');
        $('#display_status_pending').removeClass('d-none').addClass('d-block');
    });
});

async function confirmUpdateBillCredit() {
    // emptyValidate();
    onLoadingSweet(true)
    try {
        var dataURLs = [];
        var old_imgs = [];
        for (let file of Dropzone.forElement("#imgsCreditDropzone").files) {
            if (file instanceof Blob || file instanceof File) {
                let base64 = await readFileAsBase64(file);
                dataURLs.push(base64);
            } else {
                let startIndex = file.dataURL.indexOf("uploads/images/");
                let relativePath = file.dataURL.substring(startIndex);
                old_imgs.push(relativePath);
            }
        }
        const url = window.location.origin + '/credit/detail/payment';
        const data = {
            credit_id: $('#credit_no').val(),
            credit_note: $('#credit_note').val(),
            credit_images: JSON.stringify(dataURLs),
            credit_status: $('input[name="credit_status"]:checked').val(),
        }

        let res = await ajaxContants2(url, 'POST', data);
        if (res.status == 200) {
            $('#modalUpBillCredit').modal('hide');
            fetchData();
        } else if (res.status == 422) {
            let errors = res.error;
            if (errors) {
                Object.entries(errors).forEach(([key, item]) => {
                    if ($(`#${key}_err`).length) {
                        $(`#${key}_err`).html(item[0]);
                    }
                });
            }
        }
        showMessage(res.message)
    } catch (error) {
        onLoadingSweet(false)
        
        showMessage();
    }
    onLoadingSweet(false)
}