let pub_page = 1;
let pub_limit = 50;


$(document).ready(function () {
    if (document.getElementById('paymentCreditDropzone')) {
        new Dropzone("#paymentCreditDropzone", {
            url: "/upload",
            autoProcessQueue: false,
            paramName: "file",
            clickable: true,
            maxFilesize: 10, // MB
            addRemoveLinks: true,
            acceptedFiles: '.png,.jpg',
            dictDefaultMessage: "Tải hình ảnh ở đây",
        });

    }
    if (document.getElementById('paymentCreditDropzone2')) {
        new Dropzone("#paymentCreditDropzone2", {
            url: "/upload",
            autoProcessQueue: false,
            paramName: "file",
            clickable: true,
            maxFilesize: 10, // MB
            addRemoveLinks: true,
            acceptedFiles: '.png,.jpg',
            dictDefaultMessage: "Tải hình ảnh ở đây",
        });

    }
    fetchData();

    $('#keywords').on('keypress', function (e) {
        if (e.which === 13) { // 13 là mã ASCII của phím Enter
            pub_page = 1;
            fetchData();
        }
    })
    $(document).on('click', '.pagination a', function (event) {
        event.preventDefault();
        pub_page = $(this).attr('href').split('page=')[1];
        fetchData();
    });
});

function fetchData() {
    const url = window.location.origin + '/credit/detail/paginate';
    const data = {
        paginate: {
            page: pub_page,
            limit: pub_limit
        },
        filters: {
            keywords: $('#keywords').val(),
        },
        credit_id: pub_credit_id
    };
    const callback = () => {
        $('input.text-number').on('input', function (e) {
            let val = $(this).val();
            $(this).val(formatNumber(val));
        });
    }
    ajaxPostHTML(url, data, 'content', callback);
}

$('#form-add-package').on('submit', function (event) {
    event.preventDefault();
    onAddPackage();
});

function emptyValidateForm() {
    $('#package_code_err').html('');
    $('#goods_compensation_err').html('');
    $('#credit_item_note_err').html('');
}

async function onAddPackage() {
    onLoadingSweet(true);
    emptyValidateForm();
    try {
        const url = window.location.origin + '/credit/detail/add-package';
        const data = {
            credit_id: pub_credit_id,
            package_code: $('#package_code').val(),
            goods_compensation: convertStringToNumber($('#goods_compensation').val()),
            credit_item_note: $('#credit_item_note').val(),
        };
        let res = await ajaxContants2(url, 'POST', data);
        if (res.status == 200) {

            $('#package_code').val('');
            $('#goods_compensation').val('');
            $('#credit_item_note').val('');
            emptyValidateForm();

            pub_page = 1;
            fetchData();
            showMessage(res.message);

        } else if (res.status == 422) {
            const errors = res.error

            for (const [key, value] of Object.entries(errors)) {
                $(`#${key}_err`).html(value[0]);
            }
        } else {
            showMessage(res.message);
        }
    } catch (error) {
        showMessage();
    }
    onLoadingSweet(false);
}

async function onRemovePackage(params) {
    Swal.fire({
        title: "Thông báo",
        text: "Bạn có chắc muốn xóa package này ra khỏi credit không?",
        icon: "question",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Xác nhận",
        cancelButtonText: "Hủy",
    }).then(async (result) => {
        if (result.isConfirmed) {
            try {
                onLoadingSweet(true);
                const url = window.location.origin + '/credit/detail/remove-package';
                const data = {
                    credit_item_id: params,
                };
                let res = await ajaxContants2(url, 'POST', data);
                if (res.status == 200) {
                    fetchData();
                }
                showMessage(res.message);
            } catch (error) {
                showMessage();
            }
            onLoadingSweet(false);
        }
    });
}

async function onUpdateValuePackage(item_id) {

    Swal.fire({
        title: "Thông báo",
        text: 'Bạn có chắc muốn cập nhật lại giá trị package này không?',
        icon: "question",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Xác nhận",
        cancelButtonText: "Hủy",
    }).then(async (result) => {
        if (result.isConfirmed) {
            try {
                onLoadingSweet(true);
                const url = window.location.origin + '/credit/detail/value-package';
                const data = {
                    credit_item_id: item_id,
                    value_package: convertStringToNumber($('#value_package_' + item_id).val()),
                };
                let res = await ajaxContants2(url, 'POST', data);
                if (res.status == 200) {
                    fetchData();
                }
                showMessage(res.message);
            } catch (error) {
                showMessage();
            }
            onLoadingSweet(false);
        }
    });

}

async function onPaymentDebitOrStatment() {

    $('#images_payment2_err').html('');

    var paymentCreditDropzone = Dropzone.forElement("#paymentCreditDropzone2");
    if (paymentCreditDropzone.files.length <= 0) {
        $('#images_payment2_err').html('Không được để trống hình ảnh');
        return
    }

    Swal.fire({
        title: "Thông báo",
        text: 'Xác nhận thanh toán?',
        icon: "question",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Xác nhận",
        cancelButtonText: "Hủy",
    }).then(async (result) => {
        if (result.isConfirmed) {
            onLoadingSweet(true);
            try {
                var dataURLs = await Promise.all(
                    paymentCreditDropzone.files.map(async function (file) {
                        return await readFileAsBase64(file);
                    })
                );

                const url = window.location.origin + '/credit/detail/payment';
                const data = {
                    credit_id: pub_credit_id,
                    credit_note: $('#credit_note').val(),
                    credit_status: $('input[name="credit_status2"]:checked').val(),
                    credit_images: JSON.stringify(dataURLs),
                }

                let res = await ajaxContants2(url, "POST", data);

                if (res.status == 200) {
                    location.reload();
                } else {
                    showMessage(res.message)
                }
            } catch (error) {
                showMessage();
            }
            onLoadingSweet(false);
        }
    });
}

async function onPaymentCredit() {
    $('#images_payment_err').html('');

    var paymentCreditDropzone = Dropzone.forElement("#paymentCreditDropzone");
    if (paymentCreditDropzone.files.length <= 0) {
        $('#images_payment_err').html('Không được để trống hình ảnh');
        return
    }

    Swal.fire({
        title: "Thông báo",
        text: "Xác nhận thanh toán?",
        icon: "question",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Xác nhận",
        cancelButtonText: "Hủy",
    }).then(async (result) => {
        if (result.isConfirmed) {
            onLoadingSweet(true);
            try {
                var dataURLs = await Promise.all(
                    paymentCreditDropzone.files.map(async function (file) {
                        return await readFileAsBase64(file);
                    })
                );

                const url = window.location.origin + '/credit/detail/payment';
                const data = {
                    credit_id: pub_credit_id,
                    credit_images: JSON.stringify(dataURLs),
                    credit_status: $('input[name="credit_status"]:checked').val(),
                }

                let res = await ajaxContants2(url, "POST", data);

                if (res.status == 200) {
                    location.reload();
                } else {
                    showMessage(res.message)
                }
            } catch (error) {
                showMessage();
            }
            onLoadingSweet(false);
        }
    });
}
