(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("get-pixels"), require("ndarray"), require("ndarray-linear-interpolate"));
	else if(typeof define === 'function' && define.amd)
		define(["get-pixels", "ndarray", "ndarray-linear-interpolate"], factory);
	else if(typeof exports === 'object')
		exports["Quagga"] = factory(require("get-pixels"), require("ndarray"), require("ndarray-linear-interpolate"));
	else
		root["Quagga"] = factory(root["get-pixels"], root["ndarray"], root["ndarray-linear-interpolate"]);
})(this, function(__WEBPACK_EXTERNAL_MODULE_164__, __WEBPACK_EXTERNAL_MODULE_165__, __WEBPACK_EXTERNAL_MODULE_166__) {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// identity function for calling harmony imports with the correct context
/******/ 	__webpack_require__.i = function(value) { return value; };
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 167);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports) {

/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */
function isObject(value) {
  var type = typeof value;
  return value != null && (type == 'object' || type == 'function');
}

module.exports = isObject;


/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _array_helper = __webpack_require__(3);

var _array_helper2 = _interopRequireDefault(_array_helper);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function BarcodeReader(config, supplements) {
    this._row = [];
    this.config = config || {};
    this.supplements = supplements;
    return this;
}

BarcodeReader.prototype._nextUnset = function (line, start) {
    var i;

    if (start === undefined) {
        start = 0;
    }
    for (i = start; i < line.length; i++) {
        if (!line[i]) {
            return i;
        }
    }
    return line.length;
};

BarcodeReader.prototype._matchPattern = function (counter, code, maxSingleError) {
    var i,
        error = 0,
        singleError = 0,
        sum = 0,
        modulo = 0,
        barWidth,
        count,
        scaled;

    maxSingleError = maxSingleError || this.SINGLE_CODE_ERROR || 1;

    for (i = 0; i < counter.length; i++) {
        sum += counter[i];
        modulo += code[i];
    }
    if (sum < modulo) {
        return Number.MAX_VALUE;
    }
    barWidth = sum / modulo;
    maxSingleError *= barWidth;

    for (i = 0; i < counter.length; i++) {
        count = counter[i];
        scaled = code[i] * barWidth;
        singleError = Math.abs(count - scaled) / scaled;
        if (singleError > maxSingleError) {
            return Number.MAX_VALUE;
        }
        error += singleError;
    }
    return error / modulo;
};

BarcodeReader.prototype._nextSet = function (line, offset) {
    var i;

    offset = offset || 0;
    for (i = offset; i < line.length; i++) {
        if (line[i]) {
            return i;
        }
    }
    return line.length;
};

BarcodeReader.prototype._correctBars = function (counter, correction, indices) {
    var length = indices.length,
        tmp = 0;
    while (length--) {
        tmp = counter[indices[length]] * (1 - (1 - correction) / 2);
        if (tmp > 1) {
            counter[indices[length]] = tmp;
        }
    }
};

BarcodeReader.prototype._matchTrace = function (cmpCounter, epsilon) {
    var counter = [],
        i,
        self = this,
        offset = self._nextSet(self._row),
        isWhite = !self._row[offset],
        counterPos = 0,
        bestMatch = {
        error: Number.MAX_VALUE,
        code: -1,
        start: 0
    },
        error;

    if (cmpCounter) {
        for (i = 0; i < cmpCounter.length; i++) {
            counter.push(0);
        }
        for (i = offset; i < self._row.length; i++) {
            if (self._row[i] ^ isWhite) {
                counter[counterPos]++;
            } else {
                if (counterPos === counter.length - 1) {
                    error = self._matchPattern(counter, cmpCounter);

                    if (error < epsilon) {
                        bestMatch.start = i - offset;
                        bestMatch.end = i;
                        bestMatch.counter = counter;
                        return bestMatch;
                    } else {
                        return null;
                    }
                } else {
                    counterPos++;
                }
                counter[counterPos] = 1;
                isWhite = !isWhite;
            }
        }
    } else {
        counter.push(0);
        for (i = offset; i < self._row.length; i++) {
            if (self._row[i] ^ isWhite) {
                counter[counterPos]++;
            } else {
                counterPos++;
                counter.push(0);
                counter[counterPos] = 1;
                isWhite = !isWhite;
            }
        }
    }

    // if cmpCounter was not given
    bestMatch.start = offset;
    bestMatch.end = self._row.length - 1;
    bestMatch.counter = counter;
    return bestMatch;
};

BarcodeReader.prototype.decodePattern = function (pattern) {
    var self = this,
        result;

    self._row = pattern;
    result = self._decode();
    if (result === null) {
        self._row.reverse();
        result = self._decode();
        if (result) {
            result.direction = BarcodeReader.DIRECTION.REVERSE;
            result.start = self._row.length - result.start;
            result.end = self._row.length - result.end;
        }
    } else {
        result.direction = BarcodeReader.DIRECTION.FORWARD;
    }
    if (result) {
        result.format = self.FORMAT;
    }
    return result;
};

BarcodeReader.prototype._matchRange = function (start, end, value) {
    var i;

    start = start < 0 ? 0 : start;
    for (i = start; i < end; i++) {
        if (this._row[i] !== value) {
            return false;
        }
    }
    return true;
};

BarcodeReader.prototype._fillCounters = function (offset, end, isWhite) {
    var self = this,
        counterPos = 0,
        i,
        counters = [];

    isWhite = typeof isWhite !== 'undefined' ? isWhite : true;
    offset = typeof offset !== 'undefined' ? offset : self._nextUnset(self._row);
    end = end || self._row.length;

    counters[counterPos] = 0;
    for (i = offset; i < end; i++) {
        if (self._row[i] ^ isWhite) {
            counters[counterPos]++;
        } else {
            counterPos++;
            counters[counterPos] = 1;
            isWhite = !isWhite;
        }
    }
    return counters;
};

BarcodeReader.prototype._toCounters = function (start, counter) {
    var self = this,
        numCounters = counter.length,
        end = self._row.length,
        isWhite = !self._row[start],
        i,
        counterPos = 0;

    _array_helper2.default.init(counter, 0);

    for (i = start; i < end; i++) {
        if (self._row[i] ^ isWhite) {
            counter[counterPos]++;
        } else {
            counterPos++;
            if (counterPos === numCounters) {
                break;
            } else {
                counter[counterPos] = 1;
                isWhite = !isWhite;
            }
        }
    }

    return counter;
};

Object.defineProperty(BarcodeReader.prototype, "FORMAT", {
    value: 'unknown',
    writeable: false
});

BarcodeReader.DIRECTION = {
    FORWARD: 1,
    REVERSE: -1
};

BarcodeReader.Exception = {
    StartNotFoundException: "Start-Info was not found!",
    CodeNotFoundException: "Code could not be found!",
    PatternNotFoundException: "Pattern could not be found!"
};

BarcodeReader.CONFIG_KEYS = {};

exports.default = BarcodeReader;

/***/ }),
/* 2 */
/***/ (function(module, exports) {

/**
 * Checks if `value` is classified as an `Array` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array, else `false`.
 * @example
 *
 * _.isArray([1, 2, 3]);
 * // => true
 *
 * _.isArray(document.body.children);
 * // => false
 *
 * _.isArray('abc');
 * // => false
 *
 * _.isArray(_.noop);
 * // => false
 */
var isArray = Array.isArray;

module.exports = isArray;


/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;
exports.default = {
    init: function init(arr, val) {
        var l = arr.length;
        while (l--) {
            arr[l] = val;
        }
    },

    /**
     * Shuffles the content of an array
     * @return {Array} the array itself shuffled
     */
    shuffle: function shuffle(arr) {
        var i = arr.length - 1,
            j,
            x;
        for (i; i >= 0; i--) {
            j = Math.floor(Math.random() * i);
            x = arr[i];
            arr[i] = arr[j];
            arr[j] = x;
        }
        return arr;
    },

    toPointList: function toPointList(arr) {
        var i,
            j,
            row = [],
            rows = [];
        for (i = 0; i < arr.length; i++) {
            row = [];
            for (j = 0; j < arr[i].length; j++) {
                row[j] = arr[i][j];
            }
            rows[i] = "[" + row.join(",") + "]";
        }
        return "[" + rows.join(",\r\n") + "]";
    },

    /**
     * returns the elements which's score is bigger than the threshold
     * @return {Array} the reduced array
     */
    threshold: function threshold(arr, _threshold, scoreFunc) {
        var i,
            queue = [];
        for (i = 0; i < arr.length; i++) {
            if (scoreFunc.apply(arr, [arr[i]]) >= _threshold) {
                queue.push(arr[i]);
            }
        }
        return queue;
    },

    maxIndex: function maxIndex(arr) {
        var i,
            max = 0;
        for (i = 0; i < arr.length; i++) {
            if (arr[i] > arr[max]) {
                max = i;
            }
        }
        return max;
    },

    max: function max(arr) {
        var i,
            max = 0;
        for (i = 0; i < arr.length; i++) {
            if (arr[i] > max) {
                max = arr[i];
            }
        }
        return max;
    },

    sum: function sum(arr) {
        var length = arr.length,
            sum = 0;

        while (length--) {
            sum += arr[length];
        }
        return sum;
    }
};

/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _merge2 = __webpack_require__(28);

var _merge3 = _interopRequireDefault(_merge2);

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _barcode_reader = __webpack_require__(1);

var _barcode_reader2 = _interopRequireDefault(_barcode_reader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function EANReader(opts, supplements) {
    opts = (0, _merge3.default)(getDefaulConfig(), opts);
    _barcode_reader2.default.call(this, opts, supplements);
}

function getDefaulConfig() {
    var config = {};

    Object.keys(EANReader.CONFIG_KEYS).forEach(function (key) {
        config[key] = EANReader.CONFIG_KEYS[key].default;
    });
    return config;
}

var properties = {
    CODE_L_START: { value: 0 },
    CODE_G_START: { value: 10 },
    START_PATTERN: { value: [1, 1, 1] },
    STOP_PATTERN: { value: [1, 1, 1] },
    MIDDLE_PATTERN: { value: [1, 1, 1, 1, 1] },
    EXTENSION_START_PATTERN: { value: [1, 1, 2] },
    CODE_PATTERN: { value: [[3, 2, 1, 1], [2, 2, 2, 1], [2, 1, 2, 2], [1, 4, 1, 1], [1, 1, 3, 2], [1, 2, 3, 1], [1, 1, 1, 4], [1, 3, 1, 2], [1, 2, 1, 3], [3, 1, 1, 2], [1, 1, 2, 3], [1, 2, 2, 2], [2, 2, 1, 2], [1, 1, 4, 1], [2, 3, 1, 1], [1, 3, 2, 1], [4, 1, 1, 1], [2, 1, 3, 1], [3, 1, 2, 1], [2, 1, 1, 3]] },
    CODE_FREQUENCY: { value: [0, 11, 13, 14, 19, 25, 28, 21, 22, 26] },
    SINGLE_CODE_ERROR: { value: 0.70 },
    AVG_CODE_ERROR: { value: 0.48 },
    FORMAT: { value: "ean_13", writeable: false }
};

EANReader.prototype = Object.create(_barcode_reader2.default.prototype, properties);
EANReader.prototype.constructor = EANReader;

EANReader.prototype._decodeCode = function (start, coderange) {
    var counter = [0, 0, 0, 0],
        i,
        self = this,
        offset = start,
        isWhite = !self._row[offset],
        counterPos = 0,
        bestMatch = {
        error: Number.MAX_VALUE,
        code: -1,
        start: start,
        end: start
    },
        code,
        error;

    if (!coderange) {
        coderange = self.CODE_PATTERN.length;
    }

    for (i = offset; i < self._row.length; i++) {
        if (self._row[i] ^ isWhite) {
            counter[counterPos]++;
        } else {
            if (counterPos === counter.length - 1) {
                for (code = 0; code < coderange; code++) {
                    error = self._matchPattern(counter, self.CODE_PATTERN[code]);
                    if (error < bestMatch.error) {
                        bestMatch.code = code;
                        bestMatch.error = error;
                    }
                }
                bestMatch.end = i;
                if (bestMatch.error > self.AVG_CODE_ERROR) {
                    return null;
                }
                return bestMatch;
            } else {
                counterPos++;
            }
            counter[counterPos] = 1;
            isWhite = !isWhite;
        }
    }
    return null;
};

EANReader.prototype._findPattern = function (pattern, offset, isWhite, tryHarder, epsilon) {
    var counter = [],
        self = this,
        i,
        counterPos = 0,
        bestMatch = {
        error: Number.MAX_VALUE,
        code: -1,
        start: 0,
        end: 0
    },
        error,
        j,
        sum;

    if (!offset) {
        offset = self._nextSet(self._row);
    }

    if (isWhite === undefined) {
        isWhite = false;
    }

    if (tryHarder === undefined) {
        tryHarder = true;
    }

    if (epsilon === undefined) {
        epsilon = self.AVG_CODE_ERROR;
    }

    for (i = 0; i < pattern.length; i++) {
        counter[i] = 0;
    }

    for (i = offset; i < self._row.length; i++) {
        if (self._row[i] ^ isWhite) {
            counter[counterPos]++;
        } else {
            if (counterPos === counter.length - 1) {
                sum = 0;
                for (j = 0; j < counter.length; j++) {
                    sum += counter[j];
                }
                error = self._matchPattern(counter, pattern);

                if (error < epsilon) {
                    bestMatch.error = error;
                    bestMatch.start = i - sum;
                    bestMatch.end = i;
                    return bestMatch;
                }
                if (tryHarder) {
                    for (j = 0; j < counter.length - 2; j++) {
                        counter[j] = counter[j + 2];
                    }
                    counter[counter.length - 2] = 0;
                    counter[counter.length - 1] = 0;
                    counterPos--;
                } else {
                    return null;
                }
            } else {
                counterPos++;
            }
            counter[counterPos] = 1;
            isWhite = !isWhite;
        }
    }
    return null;
};

EANReader.prototype._findStart = function () {
    var self = this,
        leadingWhitespaceStart,
        offset = self._nextSet(self._row),
        startInfo;

    while (!startInfo) {
        startInfo = self._findPattern(self.START_PATTERN, offset);
        if (!startInfo) {
            return null;
        }
        leadingWhitespaceStart = startInfo.start - (startInfo.end - startInfo.start);
        if (leadingWhitespaceStart >= 0) {
            if (self._matchRange(leadingWhitespaceStart, startInfo.start, 0)) {
                return startInfo;
            }
        }
        offset = startInfo.end;
        startInfo = null;
    }
};

EANReader.prototype._verifyTrailingWhitespace = function (endInfo) {
    var self = this,
        trailingWhitespaceEnd;

    trailingWhitespaceEnd = endInfo.end + (endInfo.end - endInfo.start);
    if (trailingWhitespaceEnd < self._row.length) {
        if (self._matchRange(endInfo.end, trailingWhitespaceEnd, 0)) {
            return endInfo;
        }
    }
    return null;
};

EANReader.prototype._findEnd = function (offset, isWhite) {
    var self = this,
        endInfo = self._findPattern(self.STOP_PATTERN, offset, isWhite, false);

    return endInfo !== null ? self._verifyTrailingWhitespace(endInfo) : null;
};

EANReader.prototype._calculateFirstDigit = function (codeFrequency) {
    var i,
        self = this;

    for (i = 0; i < self.CODE_FREQUENCY.length; i++) {
        if (codeFrequency === self.CODE_FREQUENCY[i]) {
            return i;
        }
    }
    return null;
};

EANReader.prototype._decodePayload = function (code, result, decodedCodes) {
    var i,
        self = this,
        codeFrequency = 0x0,
        firstDigit;

    for (i = 0; i < 6; i++) {
        code = self._decodeCode(code.end);
        if (!code) {
            return null;
        }
        if (code.code >= self.CODE_G_START) {
            code.code = code.code - self.CODE_G_START;
            codeFrequency |= 1 << 5 - i;
        } else {
            codeFrequency |= 0 << 5 - i;
        }
        result.push(code.code);
        decodedCodes.push(code);
    }

    firstDigit = self._calculateFirstDigit(codeFrequency);
    if (firstDigit === null) {
        return null;
    }
    result.unshift(firstDigit);

    code = self._findPattern(self.MIDDLE_PATTERN, code.end, true, false);
    if (code === null) {
        return null;
    }
    decodedCodes.push(code);

    for (i = 0; i < 6; i++) {
        code = self._decodeCode(code.end, self.CODE_G_START);
        if (!code) {
            return null;
        }
        decodedCodes.push(code);
        result.push(code.code);
    }

    return code;
};

EANReader.prototype._decode = function () {
    var startInfo,
        self = this,
        code,
        result = [],
        decodedCodes = [],
        resultInfo = {};

    startInfo = self._findStart();
    if (!startInfo) {
        return null;
    }
    code = {
        code: startInfo.code,
        start: startInfo.start,
        end: startInfo.end
    };
    decodedCodes.push(code);
    code = self._decodePayload(code, result, decodedCodes);
    if (!code) {
        return null;
    }
    code = self._findEnd(code.end, false);
    if (!code) {
        return null;
    }

    decodedCodes.push(code);

    // Checksum
    if (!self._checksum(result)) {
        return null;
    }

    if (this.supplements.length > 0) {
        var ext = this._decodeExtensions(code.end);
        if (!ext) {
            return null;
        }
        var lastCode = ext.decodedCodes[ext.decodedCodes.length - 1],
            endInfo = {
            start: lastCode.start + ((lastCode.end - lastCode.start) / 2 | 0),
            end: lastCode.end
        };
        if (!self._verifyTrailingWhitespace(endInfo)) {
            return null;
        }
        resultInfo = {
            supplement: ext,
            code: result.join("") + ext.code
        };
    }

    return _extends({
        code: result.join(""),
        start: startInfo.start,
        end: code.end,
        codeset: "",
        startInfo: startInfo,
        decodedCodes: decodedCodes
    }, resultInfo);
};

EANReader.prototype._decodeExtensions = function (offset) {
    var i,
        start = this._nextSet(this._row, offset),
        startInfo = this._findPattern(this.EXTENSION_START_PATTERN, start, false, false),
        result;

    if (startInfo === null) {
        return null;
    }

    for (i = 0; i < this.supplements.length; i++) {
        result = this.supplements[i].decode(this._row, startInfo.end);
        if (result !== null) {
            return {
                code: result.code,
                start: start,
                startInfo: startInfo,
                end: result.end,
                codeset: "",
                decodedCodes: result.decodedCodes
            };
        }
    }
    return null;
};

EANReader.prototype._checksum = function (result) {
    var sum = 0,
        i;

    for (i = result.length - 2; i >= 0; i -= 2) {
        sum += result[i];
    }
    sum *= 3;
    for (i = result.length - 1; i >= 0; i -= 2) {
        sum += result[i];
    }
    return sum % 10 === 0;
};

EANReader.CONFIG_KEYS = {
    supplements: {
        'type': 'arrayOf(string)',
        'default': [],
        'description': 'Allowed extensions to be decoded (2 and/or 5)'
    }
};

exports.default = EANReader;

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

var freeGlobal = __webpack_require__(38);

/** Detect free variable `self`. */
var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

/** Used as a reference to the global object. */
var root = freeGlobal || freeSelf || Function('return this')();

module.exports = root;


/***/ }),
/* 6 */
/***/ (function(module, exports) {

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return value != null && typeof value == 'object';
}

module.exports = isObjectLike;


/***/ }),
/* 7 */
/***/ (function(module, exports) {

module.exports = clone

/**
 * Creates a new vec2 initialized with values from an existing vector
 *
 * @param {vec2} a vector to clone
 * @returns {vec2} a new 2D vector
 */
function clone(a) {
    var out = new Float32Array(2)
    out[0] = a[0]
    out[1] = a[1]
    return out
}

/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

var Symbol = __webpack_require__(11),
    getRawTag = __webpack_require__(117),
    objectToString = __webpack_require__(144);

/** `Object#toString` result references. */
var nullTag = '[object Null]',
    undefinedTag = '[object Undefined]';

/** Built-in value references. */
var symToStringTag = Symbol ? Symbol.toStringTag : undefined;

/**
 * The base implementation of `getTag` without fallbacks for buggy environments.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
function baseGetTag(value) {
  if (value == null) {
    return value === undefined ? undefinedTag : nullTag;
  }
  return (symToStringTag && symToStringTag in Object(value))
    ? getRawTag(value)
    : objectToString(value);
}

module.exports = baseGetTag;


/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;
exports.default = {
    drawRect: function drawRect(pos, size, ctx, style) {
        ctx.strokeStyle = style.color;
        ctx.fillStyle = style.color;
        ctx.lineWidth = 1;
        ctx.beginPath();
        ctx.strokeRect(pos.x, pos.y, size.x, size.y);
    },
    drawPath: function drawPath(path, def, ctx, style) {
        ctx.strokeStyle = style.color;
        ctx.fillStyle = style.color;
        ctx.lineWidth = style.lineWidth;
        ctx.beginPath();
        ctx.moveTo(path[0][def.x], path[0][def.y]);
        for (var j = 1; j < path.length; j++) {
            ctx.lineTo(path[j][def.x], path[j][def.y]);
        }
        ctx.closePath();
        ctx.stroke();
    },
    drawImage: function drawImage(imageData, size, ctx) {
        var canvasData = ctx.getImageData(0, 0, size.x, size.y),
            data = canvasData.data,
            imageDataPos = imageData.length,
            canvasDataPos = data.length,
            value;

        if (canvasDataPos / imageDataPos !== 4) {
            return false;
        }
        while (imageDataPos--) {
            value = imageData[imageDataPos];
            data[--canvasDataPos] = 255;
            data[--canvasDataPos] = value;
            data[--canvasDataPos] = value;
            data[--canvasDataPos] = value;
        }
        ctx.putImageData(canvasData, 0, 0);
        return true;
    }
};

/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

var listCacheClear = __webpack_require__(131),
    listCacheDelete = __webpack_require__(132),
    listCacheGet = __webpack_require__(133),
    listCacheHas = __webpack_require__(134),
    listCacheSet = __webpack_require__(135);

/**
 * Creates an list cache object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function ListCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `ListCache`.
ListCache.prototype.clear = listCacheClear;
ListCache.prototype['delete'] = listCacheDelete;
ListCache.prototype.get = listCacheGet;
ListCache.prototype.has = listCacheHas;
ListCache.prototype.set = listCacheSet;

module.exports = ListCache;


/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

var root = __webpack_require__(5);

/** Built-in value references. */
var Symbol = root.Symbol;

module.exports = Symbol;


/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

var eq = __webpack_require__(17);

/**
 * Gets the index at which the `key` is found in `array` of key-value pairs.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} key The key to search for.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function assocIndexOf(array, key) {
  var length = array.length;
  while (length--) {
    if (eq(array[length][0], key)) {
      return length;
    }
  }
  return -1;
}

module.exports = assocIndexOf;


/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

var isArray = __webpack_require__(2),
    isKey = __webpack_require__(128),
    stringToPath = __webpack_require__(152),
    toString = __webpack_require__(163);

/**
 * Casts `value` to a path array if it's not one.
 *
 * @private
 * @param {*} value The value to inspect.
 * @param {Object} [object] The object to query keys on.
 * @returns {Array} Returns the cast property path array.
 */
function castPath(value, object) {
  if (isArray(value)) {
    return value;
  }
  return isKey(value, object) ? [value] : stringToPath(toString(value));
}

module.exports = castPath;


/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

var isKeyable = __webpack_require__(129);

/**
 * Gets the data for `map`.
 *
 * @private
 * @param {Object} map The map to query.
 * @param {string} key The reference key.
 * @returns {*} Returns the map data.
 */
function getMapData(map, key) {
  var data = map.__data__;
  return isKeyable(key)
    ? data[typeof key == 'string' ? 'string' : 'hash']
    : data.map;
}

module.exports = getMapData;


/***/ }),
/* 15 */
/***/ (function(module, exports) {

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER = 9007199254740991;

/** Used to detect unsigned integer values. */
var reIsUint = /^(?:0|[1-9]\d*)$/;

/**
 * Checks if `value` is a valid array-like index.
 *
 * @private
 * @param {*} value The value to check.
 * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
 * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
 */
function isIndex(value, length) {
  length = length == null ? MAX_SAFE_INTEGER : length;
  return !!length &&
    (typeof value == 'number' || reIsUint.test(value)) &&
    (value > -1 && value % 1 == 0 && value < length);
}

module.exports = isIndex;


/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

var getNative = __webpack_require__(22);

/* Built-in method references that are verified to be native. */
var nativeCreate = getNative(Object, 'create');

module.exports = nativeCreate;


/***/ }),
/* 17 */
/***/ (function(module, exports) {

/**
 * Performs a
 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * comparison between two values to determine if they are equivalent.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.eq(object, object);
 * // => true
 *
 * _.eq(object, other);
 * // => false
 *
 * _.eq('a', 'a');
 * // => true
 *
 * _.eq('a', Object('a'));
 * // => false
 *
 * _.eq(NaN, NaN);
 * // => true
 */
function eq(value, other) {
  return value === other || (value !== value && other !== other);
}

module.exports = eq;


/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

var baseIsArguments = __webpack_require__(94),
    isObjectLike = __webpack_require__(6);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/** Built-in value references. */
var propertyIsEnumerable = objectProto.propertyIsEnumerable;

/**
 * Checks if `value` is likely an `arguments` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 *  else `false`.
 * @example
 *
 * _.isArguments(function() { return arguments; }());
 * // => true
 *
 * _.isArguments([1, 2, 3]);
 * // => false
 */
var isArguments = baseIsArguments(function() { return arguments; }()) ? baseIsArguments : function(value) {
  return isObjectLike(value) && hasOwnProperty.call(value, 'callee') &&
    !propertyIsEnumerable.call(value, 'callee');
};

module.exports = isArguments;


/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;
exports._dimensionsConverters = exports.ERODE = exports.DILATE = exports.Tracer = undefined;
exports.imageRef = imageRef;
exports.computeIntegralImage2 = computeIntegralImage2;
exports.computeIntegralImage = computeIntegralImage;
exports.thresholdImage = thresholdImage;
exports.computeHistogram = computeHistogram;
exports.sharpenLine = sharpenLine;
exports.determineOtsuThreshold = determineOtsuThreshold;
exports.otsuThreshold = otsuThreshold;
exports.computeBinaryImage = computeBinaryImage;
exports.cluster = cluster;
exports.dilate = dilate;
exports.erode = erode;
exports.subtract = subtract;
exports.bitwiseOr = bitwiseOr;
exports.countNonZero = countNonZero;
exports.topGeneric = topGeneric;
exports.grayArrayFromImage = grayArrayFromImage;
exports.grayArrayFromContext = grayArrayFromContext;
exports.grayAndHalfSampleFromCanvasData = grayAndHalfSampleFromCanvasData;
exports.computeGray = computeGray;
exports.loadImageArray = loadImageArray;
exports.halfSample = halfSample;
exports.hsv2rgb = hsv2rgb;
exports._computeDivisors = _computeDivisors;
exports.calculatePatchSize = calculatePatchSize;
exports._parseCSSDimensionValues = _parseCSSDimensionValues;
exports.computeImageArea = computeImageArea;

var _cluster = __webpack_require__(52);

var _cluster2 = _interopRequireDefault(_cluster);

var _array_helper = __webpack_require__(3);

var _array_helper2 = _interopRequireDefault(_array_helper);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var vec2 = {
    clone: __webpack_require__(7)
};
var vec3 = {
    clone: __webpack_require__(81)
};

/**
 * @param x x-coordinate
 * @param y y-coordinate
 * @return ImageReference {x,y} Coordinate
 */
function imageRef(x, y) {
    var that = {
        x: x,
        y: y,
        toVec2: function toVec2() {
            return vec2.clone([this.x, this.y]);
        },
        toVec3: function toVec3() {
            return vec3.clone([this.x, this.y, 1]);
        },
        round: function round() {
            this.x = this.x > 0.0 ? Math.floor(this.x + 0.5) : Math.floor(this.x - 0.5);
            this.y = this.y > 0.0 ? Math.floor(this.y + 0.5) : Math.floor(this.y - 0.5);
            return this;
        }
    };
    return that;
};

/**
 * Computes an integral image of a given grayscale image.
 * @param imageDataContainer {ImageDataContainer} the image to be integrated
 */
function computeIntegralImage2(imageWrapper, integralWrapper) {
    var imageData = imageWrapper.data;
    var width = imageWrapper.size.x;
    var height = imageWrapper.size.y;
    var integralImageData = integralWrapper.data;
    var sum = 0,
        posA = 0,
        posB = 0,
        posC = 0,
        posD = 0,
        x,
        y;

    // sum up first column
    posB = width;
    sum = 0;
    for (y = 1; y < height; y++) {
        sum += imageData[posA];
        integralImageData[posB] += sum;
        posA += width;
        posB += width;
    }

    posA = 0;
    posB = 1;
    sum = 0;
    for (x = 1; x < width; x++) {
        sum += imageData[posA];
        integralImageData[posB] += sum;
        posA++;
        posB++;
    }

    for (y = 1; y < height; y++) {
        posA = y * width + 1;
        posB = (y - 1) * width + 1;
        posC = y * width;
        posD = (y - 1) * width;
        for (x = 1; x < width; x++) {
            integralImageData[posA] += imageData[posA] + integralImageData[posB] + integralImageData[posC] - integralImageData[posD];
            posA++;
            posB++;
            posC++;
            posD++;
        }
    }
};

function computeIntegralImage(imageWrapper, integralWrapper) {
    var imageData = imageWrapper.data;
    var width = imageWrapper.size.x;
    var height = imageWrapper.size.y;
    var integralImageData = integralWrapper.data;
    var sum = 0;

    // sum up first row
    for (var i = 0; i < width; i++) {
        sum += imageData[i];
        integralImageData[i] = sum;
    }

    for (var v = 1; v < height; v++) {
        sum = 0;
        for (var u = 0; u < width; u++) {
            sum += imageData[v * width + u];
            integralImageData[v * width + u] = sum + integralImageData[(v - 1) * width + u];
        }
    }
};

function thresholdImage(imageWrapper, threshold, targetWrapper) {
    if (!targetWrapper) {
        targetWrapper = imageWrapper;
    }
    var imageData = imageWrapper.data,
        length = imageData.length,
        targetData = targetWrapper.data;

    while (length--) {
        targetData[length] = imageData[length] < threshold ? 1 : 0;
    }
};

function computeHistogram(imageWrapper, bitsPerPixel) {
    if (!bitsPerPixel) {
        bitsPerPixel = 8;
    }
    var imageData = imageWrapper.data,
        length = imageData.length,
        bitShift = 8 - bitsPerPixel,
        bucketCnt = 1 << bitsPerPixel,
        hist = new Int32Array(bucketCnt);

    while (length--) {
        hist[imageData[length] >> bitShift]++;
    }
    return hist;
};

function sharpenLine(line) {
    var i,
        length = line.length,
        left = line[0],
        center = line[1],
        right;

    for (i = 1; i < length - 1; i++) {
        right = line[i + 1];
        //  -1 4 -1 kernel
        line[i - 1] = center * 2 - left - right & 255;
        left = center;
        center = right;
    }
    return line;
};

function determineOtsuThreshold(imageWrapper, bitsPerPixel) {
    if (!bitsPerPixel) {
        bitsPerPixel = 8;
    }
    var hist,
        threshold,
        bitShift = 8 - bitsPerPixel;

    function px(init, end) {
        var sum = 0,
            i;
        for (i = init; i <= end; i++) {
            sum += hist[i];
        }
        return sum;
    }

    function mx(init, end) {
        var i,
            sum = 0;

        for (i = init; i <= end; i++) {
            sum += i * hist[i];
        }

        return sum;
    }

    function determineThreshold() {
        var vet = [0],
            p1,
            p2,
            p12,
            k,
            m1,
            m2,
            m12,
            max = (1 << bitsPerPixel) - 1;

        hist = computeHistogram(imageWrapper, bitsPerPixel);
        for (k = 1; k < max; k++) {
            p1 = px(0, k);
            p2 = px(k + 1, max);
            p12 = p1 * p2;
            if (p12 === 0) {
                p12 = 1;
            }
            m1 = mx(0, k) * p2;
            m2 = mx(k + 1, max) * p1;
            m12 = m1 - m2;
            vet[k] = m12 * m12 / p12;
        }
        return _array_helper2.default.maxIndex(vet);
    }

    threshold = determineThreshold();
    return threshold << bitShift;
};

function otsuThreshold(imageWrapper, targetWrapper) {
    var threshold = determineOtsuThreshold(imageWrapper);

    thresholdImage(imageWrapper, threshold, targetWrapper);
    return threshold;
};

// local thresholding
function computeBinaryImage(imageWrapper, integralWrapper, targetWrapper) {
    computeIntegralImage(imageWrapper, integralWrapper);

    if (!targetWrapper) {
        targetWrapper = imageWrapper;
    }
    var imageData = imageWrapper.data;
    var targetData = targetWrapper.data;
    var width = imageWrapper.size.x;
    var height = imageWrapper.size.y;
    var integralImageData = integralWrapper.data;
    var sum = 0,
        v,
        u,
        kernel = 3,
        A,
        B,
        C,
        D,
        avg,
        size = (kernel * 2 + 1) * (kernel * 2 + 1);

    // clear out top & bottom-border
    for (v = 0; v <= kernel; v++) {
        for (u = 0; u < width; u++) {
            targetData[v * width + u] = 0;
            targetData[(height - 1 - v) * width + u] = 0;
        }
    }

    // clear out left & right border
    for (v = kernel; v < height - kernel; v++) {
        for (u = 0; u <= kernel; u++) {
            targetData[v * width + u] = 0;
            targetData[v * width + (width - 1 - u)] = 0;
        }
    }

    for (v = kernel + 1; v < height - kernel - 1; v++) {
        for (u = kernel + 1; u < width - kernel; u++) {
            A = integralImageData[(v - kernel - 1) * width + (u - kernel - 1)];
            B = integralImageData[(v - kernel - 1) * width + (u + kernel)];
            C = integralImageData[(v + kernel) * width + (u - kernel - 1)];
            D = integralImageData[(v + kernel) * width + (u + kernel)];
            sum = D - C - B + A;
            avg = sum / size;
            targetData[v * width + u] = imageData[v * width + u] > avg + 5 ? 0 : 1;
        }
    }
};

function cluster(points, threshold, property) {
    var i,
        k,
        cluster,
        point,
        clusters = [];

    if (!property) {
        property = "rad";
    }

    function addToCluster(newPoint) {
        var found = false;
        for (k = 0; k < clusters.length; k++) {
            cluster = clusters[k];
            if (cluster.fits(newPoint)) {
                cluster.add(newPoint);
                found = true;
            }
        }
        return found;
    }

    // iterate over each cloud
    for (i = 0; i < points.length; i++) {
        point = _cluster2.default.createPoint(points[i], i, property);
        if (!addToCluster(point)) {
            clusters.push(_cluster2.default.create(point, threshold));
        }
    }
    return clusters;
};

var Tracer = exports.Tracer = {
    trace: function trace(points, vec) {
        var iteration,
            maxIterations = 10,
            top = [],
            result = [],
            centerPos = 0,
            currentPos = 0;

        function trace(idx, forward) {
            var from,
                to,
                toIdx,
                predictedPos,
                thresholdX = 1,
                thresholdY = Math.abs(vec[1] / 10),
                found = false;

            function match(pos, predicted) {
                if (pos.x > predicted.x - thresholdX && pos.x < predicted.x + thresholdX && pos.y > predicted.y - thresholdY && pos.y < predicted.y + thresholdY) {
                    return true;
                } else {
                    return false;
                }
            }

            // check if the next index is within the vec specifications
            // if not, check as long as the threshold is met

            from = points[idx];
            if (forward) {
                predictedPos = {
                    x: from.x + vec[0],
                    y: from.y + vec[1]
                };
            } else {
                predictedPos = {
                    x: from.x - vec[0],
                    y: from.y - vec[1]
                };
            }

            toIdx = forward ? idx + 1 : idx - 1;
            to = points[toIdx];
            while (to && (found = match(to, predictedPos)) !== true && Math.abs(to.y - from.y) < vec[1]) {
                toIdx = forward ? toIdx + 1 : toIdx - 1;
                to = points[toIdx];
            }

            return found ? toIdx : null;
        }

        for (iteration = 0; iteration < maxIterations; iteration++) {
            // randomly select point to start with
            centerPos = Math.floor(Math.random() * points.length);

            // trace forward
            top = [];
            currentPos = centerPos;
            top.push(points[currentPos]);
            while ((currentPos = trace(currentPos, true)) !== null) {
                top.push(points[currentPos]);
            }
            if (centerPos > 0) {
                currentPos = centerPos;
                while ((currentPos = trace(currentPos, false)) !== null) {
                    top.push(points[currentPos]);
                }
            }

            if (top.length > result.length) {
                result = top;
            }
        }
        return result;
    }
};

var DILATE = exports.DILATE = 1;
var ERODE = exports.ERODE = 2;

function dilate(inImageWrapper, outImageWrapper) {
    var v,
        u,
        inImageData = inImageWrapper.data,
        outImageData = outImageWrapper.data,
        height = inImageWrapper.size.y,
        width = inImageWrapper.size.x,
        sum,
        yStart1,
        yStart2,
        xStart1,
        xStart2;

    for (v = 1; v < height - 1; v++) {
        for (u = 1; u < width - 1; u++) {
            yStart1 = v - 1;
            yStart2 = v + 1;
            xStart1 = u - 1;
            xStart2 = u + 1;
            sum = inImageData[yStart1 * width + xStart1] + inImageData[yStart1 * width + xStart2] + inImageData[v * width + u] + inImageData[yStart2 * width + xStart1] + inImageData[yStart2 * width + xStart2];
            outImageData[v * width + u] = sum > 0 ? 1 : 0;
        }
    }
};

function erode(inImageWrapper, outImageWrapper) {
    var v,
        u,
        inImageData = inImageWrapper.data,
        outImageData = outImageWrapper.data,
        height = inImageWrapper.size.y,
        width = inImageWrapper.size.x,
        sum,
        yStart1,
        yStart2,
        xStart1,
        xStart2;

    for (v = 1; v < height - 1; v++) {
        for (u = 1; u < width - 1; u++) {
            yStart1 = v - 1;
            yStart2 = v + 1;
            xStart1 = u - 1;
            xStart2 = u + 1;
            sum = inImageData[yStart1 * width + xStart1] + inImageData[yStart1 * width + xStart2] + inImageData[v * width + u] + inImageData[yStart2 * width + xStart1] + inImageData[yStart2 * width + xStart2];
            outImageData[v * width + u] = sum === 5 ? 1 : 0;
        }
    }
};

function subtract(aImageWrapper, bImageWrapper, resultImageWrapper) {
    if (!resultImageWrapper) {
        resultImageWrapper = aImageWrapper;
    }
    var length = aImageWrapper.data.length,
        aImageData = aImageWrapper.data,
        bImageData = bImageWrapper.data,
        cImageData = resultImageWrapper.data;

    while (length--) {
        cImageData[length] = aImageData[length] - bImageData[length];
    }
};

function bitwiseOr(aImageWrapper, bImageWrapper, resultImageWrapper) {
    if (!resultImageWrapper) {
        resultImageWrapper = aImageWrapper;
    }
    var length = aImageWrapper.data.length,
        aImageData = aImageWrapper.data,
        bImageData = bImageWrapper.data,
        cImageData = resultImageWrapper.data;

    while (length--) {
        cImageData[length] = aImageData[length] || bImageData[length];
    }
};

function countNonZero(imageWrapper) {
    var length = imageWrapper.data.length,
        data = imageWrapper.data,
        sum = 0;

    while (length--) {
        sum += data[length];
    }
    return sum;
};

function topGeneric(list, top, scoreFunc) {
    var i,
        minIdx = 0,
        min = 0,
        queue = [],
        score,
        hit,
        pos;

    for (i = 0; i < top; i++) {
        queue[i] = {
            score: 0,
            item: null
        };
    }

    for (i = 0; i < list.length; i++) {
        score = scoreFunc.apply(this, [list[i]]);
        if (score > min) {
            hit = queue[minIdx];
            hit.score = score;
            hit.item = list[i];
            min = Number.MAX_VALUE;
            for (pos = 0; pos < top; pos++) {
                if (queue[pos].score < min) {
                    min = queue[pos].score;
                    minIdx = pos;
                }
            }
        }
    }

    return queue;
};

function grayArrayFromImage(htmlImage, offsetX, ctx, array) {
    ctx.drawImage(htmlImage, offsetX, 0, htmlImage.width, htmlImage.height);
    var ctxData = ctx.getImageData(offsetX, 0, htmlImage.width, htmlImage.height).data;
    computeGray(ctxData, array);
};

function grayArrayFromContext(ctx, size, offset, array) {
    var ctxData = ctx.getImageData(offset.x, offset.y, size.x, size.y).data;
    computeGray(ctxData, array);
};

function grayAndHalfSampleFromCanvasData(canvasData, size, outArray) {
    var topRowIdx = 0;
    var bottomRowIdx = size.x;
    var endIdx = Math.floor(canvasData.length / 4);
    var outWidth = size.x / 2;
    var outImgIdx = 0;
    var inWidth = size.x;
    var i;

    while (bottomRowIdx < endIdx) {
        for (i = 0; i < outWidth; i++) {
            outArray[outImgIdx] = (0.299 * canvasData[topRowIdx * 4 + 0] + 0.587 * canvasData[topRowIdx * 4 + 1] + 0.114 * canvasData[topRowIdx * 4 + 2] + (0.299 * canvasData[(topRowIdx + 1) * 4 + 0] + 0.587 * canvasData[(topRowIdx + 1) * 4 + 1] + 0.114 * canvasData[(topRowIdx + 1) * 4 + 2]) + (0.299 * canvasData[bottomRowIdx * 4 + 0] + 0.587 * canvasData[bottomRowIdx * 4 + 1] + 0.114 * canvasData[bottomRowIdx * 4 + 2]) + (0.299 * canvasData[(bottomRowIdx + 1) * 4 + 0] + 0.587 * canvasData[(bottomRowIdx + 1) * 4 + 1] + 0.114 * canvasData[(bottomRowIdx + 1) * 4 + 2])) / 4;
            outImgIdx++;
            topRowIdx = topRowIdx + 2;
            bottomRowIdx = bottomRowIdx + 2;
        }
        topRowIdx = topRowIdx + inWidth;
        bottomRowIdx = bottomRowIdx + inWidth;
    }
};

function computeGray(imageData, outArray, config) {
    var l = imageData.length / 4 | 0,
        i,
        singleChannel = config && config.singleChannel === true;

    if (singleChannel) {
        for (i = 0; i < l; i++) {
            outArray[i] = imageData[i * 4 + 0];
        }
    } else {
        for (i = 0; i < l; i++) {
            outArray[i] = 0.299 * imageData[i * 4 + 0] + 0.587 * imageData[i * 4 + 1] + 0.114 * imageData[i * 4 + 2];
        }
    }
};

function loadImageArray(src, callback, canvas) {
    if (!canvas) {
        canvas = document.createElement('canvas');
    }
    var img = new Image();
    img.callback = callback;
    img.onload = function () {
        canvas.width = this.width;
        canvas.height = this.height;
        var ctx = canvas.getContext('2d');
        ctx.drawImage(this, 0, 0);
        var array = new Uint8Array(this.width * this.height);
        ctx.drawImage(this, 0, 0);
        var data = ctx.getImageData(0, 0, this.width, this.height).data;
        computeGray(data, array);
        this.callback(array, {
            x: this.width,
            y: this.height
        }, this);
    };
    img.src = src;
};

/**
 * @param inImg {ImageWrapper} input image to be sampled
 * @param outImg {ImageWrapper} to be stored in
 */
function halfSample(inImgWrapper, outImgWrapper) {
    var inImg = inImgWrapper.data;
    var inWidth = inImgWrapper.size.x;
    var outImg = outImgWrapper.data;
    var topRowIdx = 0;
    var bottomRowIdx = inWidth;
    var endIdx = inImg.length;
    var outWidth = inWidth / 2;
    var outImgIdx = 0;
    while (bottomRowIdx < endIdx) {
        for (var i = 0; i < outWidth; i++) {
            outImg[outImgIdx] = Math.floor((inImg[topRowIdx] + inImg[topRowIdx + 1] + inImg[bottomRowIdx] + inImg[bottomRowIdx + 1]) / 4);
            outImgIdx++;
            topRowIdx = topRowIdx + 2;
            bottomRowIdx = bottomRowIdx + 2;
        }
        topRowIdx = topRowIdx + inWidth;
        bottomRowIdx = bottomRowIdx + inWidth;
    }
};

function hsv2rgb(hsv, rgb) {
    var h = hsv[0],
        s = hsv[1],
        v = hsv[2],
        c = v * s,
        x = c * (1 - Math.abs(h / 60 % 2 - 1)),
        m = v - c,
        r = 0,
        g = 0,
        b = 0;

    rgb = rgb || [0, 0, 0];

    if (h < 60) {
        r = c;
        g = x;
    } else if (h < 120) {
        r = x;
        g = c;
    } else if (h < 180) {
        g = c;
        b = x;
    } else if (h < 240) {
        g = x;
        b = c;
    } else if (h < 300) {
        r = x;
        b = c;
    } else if (h < 360) {
        r = c;
        b = x;
    }
    rgb[0] = (r + m) * 255 | 0;
    rgb[1] = (g + m) * 255 | 0;
    rgb[2] = (b + m) * 255 | 0;
    return rgb;
};

function _computeDivisors(n) {
    var largeDivisors = [],
        divisors = [],
        i;

    for (i = 1; i < Math.sqrt(n) + 1; i++) {
        if (n % i === 0) {
            divisors.push(i);
            if (i !== n / i) {
                largeDivisors.unshift(Math.floor(n / i));
            }
        }
    }
    return divisors.concat(largeDivisors);
};

function _computeIntersection(arr1, arr2) {
    var i = 0,
        j = 0,
        result = [];

    while (i < arr1.length && j < arr2.length) {
        if (arr1[i] === arr2[j]) {
            result.push(arr1[i]);
            i++;
            j++;
        } else if (arr1[i] > arr2[j]) {
            j++;
        } else {
            i++;
        }
    }
    return result;
};

function calculatePatchSize(patchSize, imgSize) {
    var divisorsX = _computeDivisors(imgSize.x),
        divisorsY = _computeDivisors(imgSize.y),
        wideSide = Math.max(imgSize.x, imgSize.y),
        common = _computeIntersection(divisorsX, divisorsY),
        nrOfPatchesList = [8, 10, 15, 20, 32, 60, 80],
        nrOfPatchesMap = {
        "x-small": 5,
        "small": 4,
        "medium": 3,
        "large": 2,
        "x-large": 1
    },
        nrOfPatchesIdx = nrOfPatchesMap[patchSize] || nrOfPatchesMap.medium,
        nrOfPatches = nrOfPatchesList[nrOfPatchesIdx],
        desiredPatchSize = Math.floor(wideSide / nrOfPatches),
        optimalPatchSize;

    function findPatchSizeForDivisors(divisors) {
        var i = 0,
            found = divisors[Math.floor(divisors.length / 2)];

        while (i < divisors.length - 1 && divisors[i] < desiredPatchSize) {
            i++;
        }
        if (i > 0) {
            if (Math.abs(divisors[i] - desiredPatchSize) > Math.abs(divisors[i - 1] - desiredPatchSize)) {
                found = divisors[i - 1];
            } else {
                found = divisors[i];
            }
        }
        if (desiredPatchSize / found < nrOfPatchesList[nrOfPatchesIdx + 1] / nrOfPatchesList[nrOfPatchesIdx] && desiredPatchSize / found > nrOfPatchesList[nrOfPatchesIdx - 1] / nrOfPatchesList[nrOfPatchesIdx]) {
            return { x: found, y: found };
        }
        return null;
    }

    optimalPatchSize = findPatchSizeForDivisors(common);
    if (!optimalPatchSize) {
        optimalPatchSize = findPatchSizeForDivisors(_computeDivisors(wideSide));
        if (!optimalPatchSize) {
            optimalPatchSize = findPatchSizeForDivisors(_computeDivisors(desiredPatchSize * nrOfPatches));
        }
    }
    return optimalPatchSize;
};

function _parseCSSDimensionValues(value) {
    var dimension = {
        value: parseFloat(value),
        unit: value.indexOf("%") === value.length - 1 ? "%" : "%"
    };

    return dimension;
};

var _dimensionsConverters = exports._dimensionsConverters = {
    top: function top(dimension, context) {
        if (dimension.unit === "%") {
            return Math.floor(context.height * (dimension.value / 100));
        }
    },
    right: function right(dimension, context) {
        if (dimension.unit === "%") {
            return Math.floor(context.width - context.width * (dimension.value / 100));
        }
    },
    bottom: function bottom(dimension, context) {
        if (dimension.unit === "%") {
            return Math.floor(context.height - context.height * (dimension.value / 100));
        }
    },
    left: function left(dimension, context) {
        if (dimension.unit === "%") {
            return Math.floor(context.width * (dimension.value / 100));
        }
    }
};

function computeImageArea(inputWidth, inputHeight, area) {
    var context = { width: inputWidth, height: inputHeight };

    var parsedArea = Object.keys(area).reduce(function (result, key) {
        var value = area[key],
            parsed = _parseCSSDimensionValues(value),
            calculated = _dimensionsConverters[key](parsed, context);

        result[key] = calculated;
        return result;
    }, {});

    return {
        sx: parsedArea.left,
        sy: parsedArea.top,
        sw: parsedArea.right - parsedArea.left,
        sh: parsedArea.bottom - parsedArea.top
    };
};

/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _subImage = __webpack_require__(55);

var _subImage2 = _interopRequireDefault(_subImage);

var _cv_utils = __webpack_require__(19);

var _array_helper = __webpack_require__(3);

var _array_helper2 = _interopRequireDefault(_array_helper);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var vec2 = {
    clone: __webpack_require__(7)
};

/**
 * Represents a basic image combining the data and size.
 * In addition, some methods for manipulation are contained.
 * @param size {x,y} The size of the image in pixel
 * @param data {Array} If given, a flat array containing the pixel data
 * @param ArrayType {Type} If given, the desired DataType of the Array (may be typed/non-typed)
 * @param initialize {Boolean} Indicating if the array should be initialized on creation.
 * @returns {ImageWrapper}
 */
function ImageWrapper(size, data, ArrayType, initialize) {
    if (!data) {
        if (ArrayType) {
            this.data = new ArrayType(size.x * size.y);
            if (ArrayType === Array && initialize) {
                _array_helper2.default.init(this.data, 0);
            }
        } else {
            this.data = new Uint8Array(size.x * size.y);
            if (Uint8Array === Array && initialize) {
                _array_helper2.default.init(this.data, 0);
            }
        }
    } else {
        this.data = data;
    }
    this.size = size;
}

/**
 * tests if a position is within the image with a given offset
 * @param imgRef {x, y} The location to test
 * @param border Number the padding value in pixel
 * @returns {Boolean} true if location inside the image's border, false otherwise
 * @see cvd/image.h
 */
ImageWrapper.prototype.inImageWithBorder = function (imgRef, border) {
    return imgRef.x >= border && imgRef.y >= border && imgRef.x < this.size.x - border && imgRef.y < this.size.y - border;
};

/**
 * Performs bilinear sampling
 * @param inImg Image to extract sample from
 * @param x the x-coordinate
 * @param y the y-coordinate
 * @returns the sampled value
 * @see cvd/vision.h
 */
ImageWrapper.sample = function (inImg, x, y) {
    var lx = Math.floor(x);
    var ly = Math.floor(y);
    var w = inImg.size.x;
    var base = ly * inImg.size.x + lx;
    var a = inImg.data[base + 0];
    var b = inImg.data[base + 1];
    var c = inImg.data[base + w];
    var d = inImg.data[base + w + 1];
    var e = a - b;
    x -= lx;
    y -= ly;

    var result = Math.floor(x * (y * (e - c + d) - e) + y * (c - a) + a);
    return result;
};

/**
 * Initializes a given array. Sets each element to zero.
 * @param array {Array} The array to initialize
 */
ImageWrapper.clearArray = function (array) {
    var l = array.length;
    while (l--) {
        array[l] = 0;
    }
};

/**
 * Creates a {SubImage} from the current image ({this}).
 * @param from {ImageRef} The position where to start the {SubImage} from. (top-left corner)
 * @param size {ImageRef} The size of the resulting image
 * @returns {SubImage} A shared part of the original image
 */
ImageWrapper.prototype.subImage = function (from, size) {
    return new _subImage2.default(from, size, this);
};

/**
 * Creates an {ImageWrapper) and copies the needed underlying image-data area
 * @param imageWrapper {ImageWrapper} The target {ImageWrapper} where the data should be copied
 * @param from {ImageRef} The location where to copy from (top-left location)
 */
ImageWrapper.prototype.subImageAsCopy = function (imageWrapper, from) {
    var sizeY = imageWrapper.size.y,
        sizeX = imageWrapper.size.x;
    var x, y;
    for (x = 0; x < sizeX; x++) {
        for (y = 0; y < sizeY; y++) {
            imageWrapper.data[y * sizeX + x] = this.data[(from.y + y) * this.size.x + from.x + x];
        }
    }
};

ImageWrapper.prototype.copyTo = function (imageWrapper) {
    var length = this.data.length,
        srcData = this.data,
        dstData = imageWrapper.data;

    while (length--) {
        dstData[length] = srcData[length];
    }
};

/**
 * Retrieves a given pixel position from the image
 * @param x {Number} The x-position
 * @param y {Number} The y-position
 * @returns {Number} The grayscale value at the pixel-position
 */
ImageWrapper.prototype.get = function (x, y) {
    return this.data[y * this.size.x + x];
};

/**
 * Retrieves a given pixel position from the image
 * @param x {Number} The x-position
 * @param y {Number} The y-position
 * @returns {Number} The grayscale value at the pixel-position
 */
ImageWrapper.prototype.getSafe = function (x, y) {
    var i;

    if (!this.indexMapping) {
        this.indexMapping = {
            x: [],
            y: []
        };
        for (i = 0; i < this.size.x; i++) {
            this.indexMapping.x[i] = i;
            this.indexMapping.x[i + this.size.x] = i;
        }
        for (i = 0; i < this.size.y; i++) {
            this.indexMapping.y[i] = i;
            this.indexMapping.y[i + this.size.y] = i;
        }
    }
    return this.data[this.indexMapping.y[y + this.size.y] * this.size.x + this.indexMapping.x[x + this.size.x]];
};

/**
 * Sets a given pixel position in the image
 * @param x {Number} The x-position
 * @param y {Number} The y-position
 * @param value {Number} The grayscale value to set
 * @returns {ImageWrapper} The Image itself (for possible chaining)
 */
ImageWrapper.prototype.set = function (x, y, value) {
    this.data[y * this.size.x + x] = value;
    return this;
};

/**
 * Sets the border of the image (1 pixel) to zero
 */
ImageWrapper.prototype.zeroBorder = function () {
    var i,
        width = this.size.x,
        height = this.size.y,
        data = this.data;
    for (i = 0; i < width; i++) {
        data[i] = data[(height - 1) * width + i] = 0;
    }
    for (i = 1; i < height - 1; i++) {
        data[i * width] = data[i * width + (width - 1)] = 0;
    }
};

/**
 * Inverts a binary image in place
 */
ImageWrapper.prototype.invert = function () {
    var data = this.data,
        length = data.length;

    while (length--) {
        data[length] = data[length] ? 0 : 1;
    }
};

ImageWrapper.prototype.convolve = function (kernel) {
    var x,
        y,
        kx,
        ky,
        kSize = kernel.length / 2 | 0,
        accu = 0;
    for (y = 0; y < this.size.y; y++) {
        for (x = 0; x < this.size.x; x++) {
            accu = 0;
            for (ky = -kSize; ky <= kSize; ky++) {
                for (kx = -kSize; kx <= kSize; kx++) {
                    accu += kernel[ky + kSize][kx + kSize] * this.getSafe(x + kx, y + ky);
                }
            }
            this.data[y * this.size.x + x] = accu;
        }
    }
};

ImageWrapper.prototype.moments = function (labelcount) {
    var data = this.data,
        x,
        y,
        height = this.size.y,
        width = this.size.x,
        val,
        ysq,
        labelsum = [],
        i,
        label,
        mu11,
        mu02,
        mu20,
        x_,
        y_,
        tmp,
        result = [],
        PI = Math.PI,
        PI_4 = PI / 4;

    if (labelcount <= 0) {
        return result;
    }

    for (i = 0; i < labelcount; i++) {
        labelsum[i] = {
            m00: 0,
            m01: 0,
            m10: 0,
            m11: 0,
            m02: 0,
            m20: 0,
            theta: 0,
            rad: 0
        };
    }

    for (y = 0; y < height; y++) {
        ysq = y * y;
        for (x = 0; x < width; x++) {
            val = data[y * width + x];
            if (val > 0) {
                label = labelsum[val - 1];
                label.m00 += 1;
                label.m01 += y;
                label.m10 += x;
                label.m11 += x * y;
                label.m02 += ysq;
                label.m20 += x * x;
            }
        }
    }

    for (i = 0; i < labelcount; i++) {
        label = labelsum[i];
        if (!isNaN(label.m00) && label.m00 !== 0) {
            x_ = label.m10 / label.m00;
            y_ = label.m01 / label.m00;
            mu11 = label.m11 / label.m00 - x_ * y_;
            mu02 = label.m02 / label.m00 - y_ * y_;
            mu20 = label.m20 / label.m00 - x_ * x_;
            tmp = (mu02 - mu20) / (2 * mu11);
            tmp = 0.5 * Math.atan(tmp) + (mu11 >= 0 ? PI_4 : -PI_4) + PI;
            label.theta = (tmp * 180 / PI + 90) % 180 - 90;
            if (label.theta < 0) {
                label.theta += 180;
            }
            label.rad = tmp > PI ? tmp - PI : tmp;
            label.vec = vec2.clone([Math.cos(tmp), Math.sin(tmp)]);
            result.push(label);
        }
    }

    return result;
};

/**
 * Displays the {ImageWrapper} in a given canvas
 * @param canvas {Canvas} The canvas element to write to
 * @param scale {Number} Scale which is applied to each pixel-value
 */
ImageWrapper.prototype.show = function (canvas, scale) {
    var ctx, frame, data, current, pixel, x, y;

    if (!scale) {
        scale = 1.0;
    }
    ctx = canvas.getContext('2d');
    canvas.width = this.size.x;
    canvas.height = this.size.y;
    frame = ctx.getImageData(0, 0, canvas.width, canvas.height);
    data = frame.data;
    current = 0;
    for (y = 0; y < this.size.y; y++) {
        for (x = 0; x < this.size.x; x++) {
            pixel = y * this.size.x + x;
            current = this.get(x, y) * scale;
            data[pixel * 4 + 0] = current;
            data[pixel * 4 + 1] = current;
            data[pixel * 4 + 2] = current;
            data[pixel * 4 + 3] = 255;
        }
    }
    //frame.data = data;
    ctx.putImageData(frame, 0, 0);
};

/**
 * Displays the {SubImage} in a given canvas
 * @param canvas {Canvas} The canvas element to write to
 * @param scale {Number} Scale which is applied to each pixel-value
 */
ImageWrapper.prototype.overlay = function (canvas, scale, from) {
    if (!scale || scale < 0 || scale > 360) {
        scale = 360;
    }
    var hsv = [0, 1, 1];
    var rgb = [0, 0, 0];
    var whiteRgb = [255, 255, 255];
    var blackRgb = [0, 0, 0];
    var result = [];
    var ctx = canvas.getContext('2d');
    var frame = ctx.getImageData(from.x, from.y, this.size.x, this.size.y);
    var data = frame.data;
    var length = this.data.length;
    while (length--) {
        hsv[0] = this.data[length] * scale;
        result = hsv[0] <= 0 ? whiteRgb : hsv[0] >= 360 ? blackRgb : (0, _cv_utils.hsv2rgb)(hsv, rgb);
        data[length * 4 + 0] = result[0];
        data[length * 4 + 1] = result[1];
        data[length * 4 + 2] = result[2];
        data[length * 4 + 3] = 255;
    }
    ctx.putImageData(frame, from.x, from.y);
};

exports.default = ImageWrapper;

/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

var defineProperty = __webpack_require__(37);

/**
 * The base implementation of `assignValue` and `assignMergeValue` without
 * value checks.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function baseAssignValue(object, key, value) {
  if (key == '__proto__' && defineProperty) {
    defineProperty(object, key, {
      'configurable': true,
      'enumerable': true,
      'value': value,
      'writable': true
    });
  } else {
    object[key] = value;
  }
}

module.exports = baseAssignValue;


/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

var baseIsNative = __webpack_require__(95),
    getValue = __webpack_require__(118);

/**
 * Gets the native function at `key` of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the method to get.
 * @returns {*} Returns the function if it's native, else `undefined`.
 */
function getNative(object, key) {
  var value = getValue(object, key);
  return baseIsNative(value) ? value : undefined;
}

module.exports = getNative;


/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

var isSymbol = __webpack_require__(27);

/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0;

/**
 * Converts `value` to a string key if it's not a string or symbol.
 *
 * @private
 * @param {*} value The value to inspect.
 * @returns {string|symbol} Returns the key.
 */
function toKey(value) {
  if (typeof value == 'string' || isSymbol(value)) {
    return value;
  }
  var result = (value + '');
  return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
}

module.exports = toKey;


/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

var isFunction = __webpack_require__(25),
    isLength = __webpack_require__(26);

/**
 * Checks if `value` is array-like. A value is considered array-like if it's
 * not a function and has a `value.length` that's an integer greater than or
 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
 * @example
 *
 * _.isArrayLike([1, 2, 3]);
 * // => true
 *
 * _.isArrayLike(document.body.children);
 * // => true
 *
 * _.isArrayLike('abc');
 * // => true
 *
 * _.isArrayLike(_.noop);
 * // => false
 */
function isArrayLike(value) {
  return value != null && isLength(value.length) && !isFunction(value);
}

module.exports = isArrayLike;


/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

var baseGetTag = __webpack_require__(8),
    isObject = __webpack_require__(0);

/** `Object#toString` result references. */
var asyncTag = '[object AsyncFunction]',
    funcTag = '[object Function]',
    genTag = '[object GeneratorFunction]',
    proxyTag = '[object Proxy]';

/**
 * Checks if `value` is classified as a `Function` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a function, else `false`.
 * @example
 *
 * _.isFunction(_);
 * // => true
 *
 * _.isFunction(/abc/);
 * // => false
 */
function isFunction(value) {
  if (!isObject(value)) {
    return false;
  }
  // The use of `Object#toString` avoids issues with the `typeof` operator
  // in Safari 9 which returns 'object' for typed arrays and other constructors.
  var tag = baseGetTag(value);
  return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
}

module.exports = isFunction;


/***/ }),
/* 26 */
/***/ (function(module, exports) {

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER = 9007199254740991;

/**
 * Checks if `value` is a valid array-like length.
 *
 * **Note:** This method is loosely based on
 * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
 * @example
 *
 * _.isLength(3);
 * // => true
 *
 * _.isLength(Number.MIN_VALUE);
 * // => false
 *
 * _.isLength(Infinity);
 * // => false
 *
 * _.isLength('3');
 * // => false
 */
function isLength(value) {
  return typeof value == 'number' &&
    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
}

module.exports = isLength;


/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

var baseGetTag = __webpack_require__(8),
    isObjectLike = __webpack_require__(6);

/** `Object#toString` result references. */
var symbolTag = '[object Symbol]';

/**
 * Checks if `value` is classified as a `Symbol` primitive or object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
 * @example
 *
 * _.isSymbol(Symbol.iterator);
 * // => true
 *
 * _.isSymbol('abc');
 * // => false
 */
function isSymbol(value) {
  return typeof value == 'symbol' ||
    (isObjectLike(value) && baseGetTag(value) == symbolTag);
}

module.exports = isSymbol;


/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

var baseMerge = __webpack_require__(98),
    createAssigner = __webpack_require__(114);

/**
 * This method is like `_.assign` except that it recursively merges own and
 * inherited enumerable string keyed properties of source objects into the
 * destination object. Source properties that resolve to `undefined` are
 * skipped if a destination value exists. Array and plain object properties
 * are merged recursively. Other objects and value types are overridden by
 * assignment. Source objects are applied from left to right. Subsequent
 * sources overwrite property assignments of previous sources.
 *
 * **Note:** This method mutates `object`.
 *
 * @static
 * @memberOf _
 * @since 0.5.0
 * @category Object
 * @param {Object} object The destination object.
 * @param {...Object} [sources] The source objects.
 * @returns {Object} Returns `object`.
 * @example
 *
 * var object = {
 *   'a': [{ 'b': 2 }, { 'd': 4 }]
 * };
 *
 * var other = {
 *   'a': [{ 'c': 3 }, { 'e': 5 }]
 * };
 *
 * _.merge(object, other);
 * // => { 'a': [{ 'b': 2, 'c': 3 }, { 'd': 4, 'e': 5 }] }
 */
var merge = createAssigner(function(object, source, srcIndex) {
  baseMerge(object, source, srcIndex);
});

module.exports = merge;


/***/ }),
/* 29 */
/***/ (function(module, exports) {

module.exports = function(module) {
	if(!module.webpackPolyfill) {
		module.deprecate = function() {};
		module.paths = [];
		// module.parent = undefined by default
		if(!module.children) module.children = [];
		Object.defineProperty(module, "loaded", {
			enumerable: true,
			get: function() {
				return module.l;
			}
		});
		Object.defineProperty(module, "id", {
			enumerable: true,
			get: function() {
				return module.i;
			}
		});
		module.webpackPolyfill = 1;
	}
	return module;
};


/***/ }),
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;
/**
 * http://www.codeproject.com/Tips/407172/Connected-Component-Labeling-and-Vectorization
 */
var Tracer = {
    searchDirections: [[0, 1], [1, 1], [1, 0], [1, -1], [0, -1], [-1, -1], [-1, 0], [-1, 1]],
    create: function create(imageWrapper, labelWrapper) {
        var imageData = imageWrapper.data,
            labelData = labelWrapper.data,
            searchDirections = this.searchDirections,
            width = imageWrapper.size.x,
            pos;

        function _trace(current, color, label, edgelabel) {
            var i, y, x;

            for (i = 0; i < 7; i++) {
                y = current.cy + searchDirections[current.dir][0];
                x = current.cx + searchDirections[current.dir][1];
                pos = y * width + x;
                if (imageData[pos] === color && (labelData[pos] === 0 || labelData[pos] === label)) {
                    labelData[pos] = label;
                    current.cy = y;
                    current.cx = x;
                    return true;
                } else {
                    if (labelData[pos] === 0) {
                        labelData[pos] = edgelabel;
                    }
                    current.dir = (current.dir + 1) % 8;
                }
            }
            return false;
        }

        function vertex2D(x, y, dir) {
            return {
                dir: dir,
                x: x,
                y: y,
                next: null,
                prev: null
            };
        }

        function _contourTracing(sy, sx, label, color, edgelabel) {
            var Fv = null,
                Cv,
                P,
                ldir,
                current = {
                cx: sx,
                cy: sy,
                dir: 0
            };

            if (_trace(current, color, label, edgelabel)) {
                Fv = vertex2D(sx, sy, current.dir);
                Cv = Fv;
                ldir = current.dir;
                P = vertex2D(current.cx, current.cy, 0);
                P.prev = Cv;
                Cv.next = P;
                P.next = null;
                Cv = P;
                do {
                    current.dir = (current.dir + 6) % 8;
                    _trace(current, color, label, edgelabel);
                    if (ldir !== current.dir) {
                        Cv.dir = current.dir;
                        P = vertex2D(current.cx, current.cy, 0);
                        P.prev = Cv;
                        Cv.next = P;
                        P.next = null;
                        Cv = P;
                    } else {
                        Cv.dir = ldir;
                        Cv.x = current.cx;
                        Cv.y = current.cy;
                    }
                    ldir = current.dir;
                } while (current.cx !== sx || current.cy !== sy);
                Fv.prev = Cv.prev;
                Cv.prev.next = Fv;
            }
            return Fv;
        }

        return {
            trace: function trace(current, color, label, edgelabel) {
                return _trace(current, color, label, edgelabel);
            },
            contourTracing: function contourTracing(sy, sx, label, color, edgelabel) {
                return _contourTracing(sy, sx, label, color, edgelabel);
            }
        };
    }
};

exports.default = Tracer;

/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _barcode_reader = __webpack_require__(1);

var _barcode_reader2 = _interopRequireDefault(_barcode_reader);

var _array_helper = __webpack_require__(3);

var _array_helper2 = _interopRequireDefault(_array_helper);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function Code39Reader() {
    _barcode_reader2.default.call(this);
}

var properties = {
    ALPHABETH_STRING: { value: "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%" },
    ALPHABET: { value: [48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 45, 46, 32, 42, 36, 47, 43, 37] },
    CHARACTER_ENCODINGS: { value: [0x034, 0x121, 0x061, 0x160, 0x031, 0x130, 0x070, 0x025, 0x124, 0x064, 0x109, 0x049, 0x148, 0x019, 0x118, 0x058, 0x00D, 0x10C, 0x04C, 0x01C, 0x103, 0x043, 0x142, 0x013, 0x112, 0x052, 0x007, 0x106, 0x046, 0x016, 0x181, 0x0C1, 0x1C0, 0x091, 0x190, 0x0D0, 0x085, 0x184, 0x0C4, 0x094, 0x0A8, 0x0A2, 0x08A, 0x02A] },
    ASTERISK: { value: 0x094 },
    FORMAT: { value: "code_39", writeable: false }
};

Code39Reader.prototype = Object.create(_barcode_reader2.default.prototype, properties);
Code39Reader.prototype.constructor = Code39Reader;

Code39Reader.prototype._decode = function () {
    var self = this,
        counters = [0, 0, 0, 0, 0, 0, 0, 0, 0],
        result = [],
        start = self._findStart(),
        decodedChar,
        lastStart,
        pattern,
        nextStart;

    if (!start) {
        return null;
    }
    nextStart = self._nextSet(self._row, start.end);

    do {
        counters = self._toCounters(nextStart, counters);
        pattern = self._toPattern(counters);
        if (pattern < 0) {
            return null;
        }
        decodedChar = self._patternToChar(pattern);
        if (decodedChar < 0) {
            return null;
        }
        result.push(decodedChar);
        lastStart = nextStart;
        nextStart += _array_helper2.default.sum(counters);
        nextStart = self._nextSet(self._row, nextStart);
    } while (decodedChar !== '*');
    result.pop();

    if (!result.length) {
        return null;
    }

    if (!self._verifyTrailingWhitespace(lastStart, nextStart, counters)) {
        return null;
    }

    return {
        code: result.join(""),
        start: start.start,
        end: nextStart,
        startInfo: start,
        decodedCodes: result
    };
};

Code39Reader.prototype._verifyTrailingWhitespace = function (lastStart, nextStart, counters) {
    var trailingWhitespaceEnd,
        patternSize = _array_helper2.default.sum(counters);

    trailingWhitespaceEnd = nextStart - lastStart - patternSize;
    if (trailingWhitespaceEnd * 3 >= patternSize) {
        return true;
    }
    return false;
};

Code39Reader.prototype._patternToChar = function (pattern) {
    var i,
        self = this;

    for (i = 0; i < self.CHARACTER_ENCODINGS.length; i++) {
        if (self.CHARACTER_ENCODINGS[i] === pattern) {
            return String.fromCharCode(self.ALPHABET[i]);
        }
    }
    return -1;
};

Code39Reader.prototype._findNextWidth = function (counters, current) {
    var i,
        minWidth = Number.MAX_VALUE;

    for (i = 0; i < counters.length; i++) {
        if (counters[i] < minWidth && counters[i] > current) {
            minWidth = counters[i];
        }
    }

    return minWidth;
};

Code39Reader.prototype._toPattern = function (counters) {
    var numCounters = counters.length,
        maxNarrowWidth = 0,
        numWideBars = numCounters,
        wideBarWidth = 0,
        self = this,
        pattern,
        i;

    while (numWideBars > 3) {
        maxNarrowWidth = self._findNextWidth(counters, maxNarrowWidth);
        numWideBars = 0;
        pattern = 0;
        for (i = 0; i < numCounters; i++) {
            if (counters[i] > maxNarrowWidth) {
                pattern |= 1 << numCounters - 1 - i;
                numWideBars++;
                wideBarWidth += counters[i];
            }
        }

        if (numWideBars === 3) {
            for (i = 0; i < numCounters && numWideBars > 0; i++) {
                if (counters[i] > maxNarrowWidth) {
                    numWideBars--;
                    if (counters[i] * 2 >= wideBarWidth) {
                        return -1;
                    }
                }
            }
            return pattern;
        }
    }
    return -1;
};

Code39Reader.prototype._findStart = function () {
    var self = this,
        offset = self._nextSet(self._row),
        patternStart = offset,
        counter = [0, 0, 0, 0, 0, 0, 0, 0, 0],
        counterPos = 0,
        isWhite = false,
        i,
        j,
        whiteSpaceMustStart;

    for (i = offset; i < self._row.length; i++) {
        if (self._row[i] ^ isWhite) {
            counter[counterPos]++;
        } else {
            if (counterPos === counter.length - 1) {
                // find start pattern
                if (self._toPattern(counter) === self.ASTERISK) {
                    whiteSpaceMustStart = Math.floor(Math.max(0, patternStart - (i - patternStart) / 4));
                    if (self._matchRange(whiteSpaceMustStart, patternStart, 0)) {
                        return {
                            start: patternStart,
                            end: i
                        };
                    }
                }

                patternStart += counter[0] + counter[1];
                for (j = 0; j < 7; j++) {
                    counter[j] = counter[j + 2];
                }
                counter[7] = 0;
                counter[8] = 0;
                counterPos--;
            } else {
                counterPos++;
            }
            counter[counterPos] = 1;
            isWhite = !isWhite;
        }
    }
    return null;
};

exports.default = Code39Reader;

/***/ }),
/* 32 */
/***/ (function(module, exports) {

module.exports = dot

/**
 * Calculates the dot product of two vec2's
 *
 * @param {vec2} a the first operand
 * @param {vec2} b the second operand
 * @returns {Number} dot product of a and b
 */
function dot(a, b) {
    return a[0] * b[0] + a[1] * b[1]
}

/***/ }),
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

var getNative = __webpack_require__(22),
    root = __webpack_require__(5);

/* Built-in method references that are verified to be native. */
var Map = getNative(root, 'Map');

module.exports = Map;


/***/ }),
/* 34 */
/***/ (function(module, exports, __webpack_require__) {

var mapCacheClear = __webpack_require__(136),
    mapCacheDelete = __webpack_require__(137),
    mapCacheGet = __webpack_require__(138),
    mapCacheHas = __webpack_require__(139),
    mapCacheSet = __webpack_require__(140);

/**
 * Creates a map cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function MapCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `MapCache`.
MapCache.prototype.clear = mapCacheClear;
MapCache.prototype['delete'] = mapCacheDelete;
MapCache.prototype.get = mapCacheGet;
MapCache.prototype.has = mapCacheHas;
MapCache.prototype.set = mapCacheSet;

module.exports = MapCache;


/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {

var baseAssignValue = __webpack_require__(21),
    eq = __webpack_require__(17);

/**
 * This function is like `assignValue` except that it doesn't assign
 * `undefined` values.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function assignMergeValue(object, key, value) {
  if ((value !== undefined && !eq(object[key], value)) ||
      (value === undefined && !(key in object))) {
    baseAssignValue(object, key, value);
  }
}

module.exports = assignMergeValue;


/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

var baseAssignValue = __webpack_require__(21),
    eq = __webpack_require__(17);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Assigns `value` to `key` of `object` if the existing value is not equivalent
 * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * for equality comparisons.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function assignValue(object, key, value) {
  var objValue = object[key];
  if (!(hasOwnProperty.call(object, key) && eq(objValue, value)) ||
      (value === undefined && !(key in object))) {
    baseAssignValue(object, key, value);
  }
}

module.exports = assignValue;


/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

var getNative = __webpack_require__(22);

var defineProperty = (function() {
  try {
    var func = getNative(Object, 'defineProperty');
    func({}, '', {});
    return func;
  } catch (e) {}
}());

module.exports = defineProperty;


/***/ }),
/* 38 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global) {/** Detect free variable `global` from Node.js. */
var freeGlobal = typeof global == 'object' && global && global.Object === Object && global;

module.exports = freeGlobal;

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(47)))

/***/ }),
/* 39 */
/***/ (function(module, exports, __webpack_require__) {

var overArg = __webpack_require__(145);

/** Built-in value references. */
var getPrototype = overArg(Object.getPrototypeOf, Object);

module.exports = getPrototype;


/***/ }),
/* 40 */
/***/ (function(module, exports) {

/** Used for built-in method references. */
var objectProto = Object.prototype;

/**
 * Checks if `value` is likely a prototype object.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
 */
function isPrototype(value) {
  var Ctor = value && value.constructor,
      proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto;

  return value === proto;
}

module.exports = isPrototype;


/***/ }),
/* 41 */
/***/ (function(module, exports, __webpack_require__) {

var apply = __webpack_require__(85);

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeMax = Math.max;

/**
 * A specialized version of `baseRest` which transforms the rest array.
 *
 * @private
 * @param {Function} func The function to apply a rest parameter to.
 * @param {number} [start=func.length-1] The start position of the rest parameter.
 * @param {Function} transform The rest array transform.
 * @returns {Function} Returns the new function.
 */
function overRest(func, start, transform) {
  start = nativeMax(start === undefined ? (func.length - 1) : start, 0);
  return function() {
    var args = arguments,
        index = -1,
        length = nativeMax(args.length - start, 0),
        array = Array(length);

    while (++index < length) {
      array[index] = args[start + index];
    }
    index = -1;
    var otherArgs = Array(start + 1);
    while (++index < start) {
      otherArgs[index] = args[index];
    }
    otherArgs[start] = transform(array);
    return apply(func, this, otherArgs);
  };
}

module.exports = overRest;


/***/ }),
/* 42 */
/***/ (function(module, exports, __webpack_require__) {

var baseSetToString = __webpack_require__(104),
    shortOut = __webpack_require__(146);

/**
 * Sets the `toString` method of `func` to return `string`.
 *
 * @private
 * @param {Function} func The function to modify.
 * @param {Function} string The `toString` result.
 * @returns {Function} Returns `func`.
 */
var setToString = shortOut(baseSetToString);

module.exports = setToString;


/***/ }),
/* 43 */
/***/ (function(module, exports) {

/**
 * This method returns the first argument it receives.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Util
 * @param {*} value Any value.
 * @returns {*} Returns `value`.
 * @example
 *
 * var object = { 'a': 1 };
 *
 * console.log(_.identity(object) === object);
 * // => true
 */
function identity(value) {
  return value;
}

module.exports = identity;


/***/ }),
/* 44 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(module) {var root = __webpack_require__(5),
    stubFalse = __webpack_require__(161);

/** Detect free variable `exports`. */
var freeExports = typeof exports == 'object' && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && typeof module == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/** Built-in value references. */
var Buffer = moduleExports ? root.Buffer : undefined;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined;

/**
 * Checks if `value` is a buffer.
 *
 * @static
 * @memberOf _
 * @since 4.3.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.
 * @example
 *
 * _.isBuffer(new Buffer(2));
 * // => true
 *
 * _.isBuffer(new Uint8Array(2));
 * // => false
 */
var isBuffer = nativeIsBuffer || stubFalse;

module.exports = isBuffer;

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(29)(module)))

/***/ }),
/* 45 */
/***/ (function(module, exports, __webpack_require__) {

var baseIsTypedArray = __webpack_require__(96),
    baseUnary = __webpack_require__(107),
    nodeUtil = __webpack_require__(143);

/* Node.js helper references. */
var nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;

/**
 * Checks if `value` is classified as a typed array.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 * @example
 *
 * _.isTypedArray(new Uint8Array);
 * // => true
 *
 * _.isTypedArray([]);
 * // => false
 */
var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;

module.exports = isTypedArray;


/***/ }),
/* 46 */
/***/ (function(module, exports, __webpack_require__) {

var arrayLikeKeys = __webpack_require__(86),
    baseKeysIn = __webpack_require__(97),
    isArrayLike = __webpack_require__(24);

/**
 * Creates an array of the own and inherited enumerable property names of `object`.
 *
 * **Note:** Non-object values are coerced to objects.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.keysIn(new Foo);
 * // => ['a', 'b', 'c'] (iteration order is not guaranteed)
 */
function keysIn(object) {
  return isArrayLike(object) ? arrayLikeKeys(object, true) : baseKeysIn(object);
}

module.exports = keysIn;


/***/ }),
/* 47 */
/***/ (function(module, exports) {

var g;

// This works in non-strict mode
g = (function() {
	return this;
})();

try {
	// This works if eval is allowed (see CSP)
	g = g || Function("return this")() || (1,eval)("this");
} catch(e) {
	// This works if the window reference is available
	if(typeof window === "object")
		g = window;
}

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

module.exports = g;


/***/ }),
/* 48 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _merge2 = __webpack_require__(28);

var _merge3 = _interopRequireDefault(_merge2);

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // eslint-disable-line no-unused-vars


var _typedefs = __webpack_require__(56);

var _typedefs2 = _interopRequireDefault(_typedefs);

var _image_wrapper = __webpack_require__(20);

var _image_wrapper2 = _interopRequireDefault(_image_wrapper);

var _barcode_locator = __webpack_require__(62);

var _barcode_locator2 = _interopRequireDefault(_barcode_locator);

var _barcode_decoder = __webpack_require__(59);

var _barcode_decoder2 = _interopRequireDefault(_barcode_decoder);

var _events = __webpack_require__(53);

var _events2 = _interopRequireDefault(_events);

var _camera_access = __webpack_require__(61);

var _camera_access2 = _interopRequireDefault(_camera_access);

var _image_debug = __webpack_require__(9);

var _image_debug2 = _interopRequireDefault(_image_debug);

var _result_collector = __webpack_require__(51);

var _result_collector2 = _interopRequireDefault(_result_collector);

var _config2 = __webpack_require__(57);

var _config3 = _interopRequireDefault(_config2);

var _input_stream = __webpack_require__(50);

var _input_stream2 = _interopRequireDefault(_input_stream);

var _frame_grabber = __webpack_require__(49);

var _frame_grabber2 = _interopRequireDefault(_frame_grabber);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var vec2 = {
    clone: __webpack_require__(7)
};

var _inputStream,
    _framegrabber,
    _stopped,
    _canvasContainer = {
    ctx: {
        image: null,
        overlay: null
    },
    dom: {
        image: null,
        overlay: null
    }
},
    _inputImageWrapper,
    _boxSize,
    _decoder,
    _workerPool = [],
    _onUIThread = true,
    _resultCollector,
    _config = {};

function initializeData(imageWrapper) {
    initBuffers(imageWrapper);
    _decoder = _barcode_decoder2.default.create(_config.decoder, _inputImageWrapper);
}

function initInputStream(cb) {
    var video;
    if (_config.inputStream.type === "VideoStream") {
        video = document.createElement("video");
        _inputStream = _input_stream2.default.createVideoStream(video);
    } else if (_config.inputStream.type === "ImageStream") {
        _inputStream = _input_stream2.default.createImageStream();
    } else if (_config.inputStream.type === "LiveStream") {
        var $viewport = getViewPort();
        if ($viewport) {
            video = $viewport.querySelector("video");
            if (!video) {
                video = document.createElement("video");
                $viewport.appendChild(video);
            }
        }
        _inputStream = _input_stream2.default.createLiveStream(video);
        _camera_access2.default.request(video, _config.inputStream.constraints).then(function () {
            _inputStream.trigger("canrecord");
        }).catch(function (err) {
            return cb(err);
        });
    }

    _inputStream.setAttribute("preload", "auto");
    _inputStream.setInputStream(_config.inputStream);
    _inputStream.addEventListener("canrecord", canRecord.bind(undefined, cb));
}

function getViewPort() {
    var target = _config.inputStream.target;
    // Check if target is already a DOM element
    if (target && target.nodeName && target.nodeType === 1) {
        return target;
    } else {
        // Use '#interactive.viewport' as a fallback selector (backwards compatibility)
        var selector = typeof target === 'string' ? target : '#interactive.viewport';
        return document.querySelector(selector);
    }
}

function canRecord(cb) {
    _barcode_locator2.default.checkImageConstraints(_inputStream, _config.locator);
    initCanvas(_config);
    _framegrabber = _frame_grabber2.default.create(_inputStream, _canvasContainer.dom.image);

    adjustWorkerPool(_config.numOfWorkers, function () {
        if (_config.numOfWorkers === 0) {
            initializeData();
        }
        ready(cb);
    });
}

function ready(cb) {
    _inputStream.play();
    cb();
}

function initCanvas() {
    if (typeof document !== "undefined") {
        var $viewport = getViewPort();
        _canvasContainer.dom.image = document.querySelector("canvas.imgBuffer");
        if (!_canvasContainer.dom.image) {
            _canvasContainer.dom.image = document.createElement("canvas");
            _canvasContainer.dom.image.className = "imgBuffer";
            if ($viewport && _config.inputStream.type === "ImageStream") {
                $viewport.appendChild(_canvasContainer.dom.image);
            }
        }
        _canvasContainer.ctx.image = _canvasContainer.dom.image.getContext("2d");
        _canvasContainer.dom.image.width = _inputStream.getCanvasSize().x;
        _canvasContainer.dom.image.height = _inputStream.getCanvasSize().y;

        _canvasContainer.dom.overlay = document.querySelector("canvas.drawingBuffer");
        if (!_canvasContainer.dom.overlay) {
            _canvasContainer.dom.overlay = document.createElement("canvas");
            _canvasContainer.dom.overlay.className = "drawingBuffer";
            if ($viewport) {
                $viewport.appendChild(_canvasContainer.dom.overlay);
            }
            var clearFix = document.createElement("br");
            clearFix.setAttribute("clear", "all");
            if ($viewport) {
                $viewport.appendChild(clearFix);
            }
        }
        _canvasContainer.ctx.overlay = _canvasContainer.dom.overlay.getContext("2d");
        _canvasContainer.dom.overlay.width = _inputStream.getCanvasSize().x;
        _canvasContainer.dom.overlay.height = _inputStream.getCanvasSize().y;
    }
}

function initBuffers(imageWrapper) {
    if (imageWrapper) {
        _inputImageWrapper = imageWrapper;
    } else {
        _inputImageWrapper = new _image_wrapper2.default({
            x: _inputStream.getWidth(),
            y: _inputStream.getHeight()
        });
    }

    if (false) {
        console.log(_inputImageWrapper.size);
    }
    _boxSize = [vec2.clone([0, 0]), vec2.clone([0, _inputImageWrapper.size.y]), vec2.clone([_inputImageWrapper.size.x, _inputImageWrapper.size.y]), vec2.clone([_inputImageWrapper.size.x, 0])];
    _barcode_locator2.default.init(_inputImageWrapper, _config.locator);
}

function getBoundingBoxes() {
    if (_config.locate) {
        return _barcode_locator2.default.locate();
    } else {
        return [[vec2.clone(_boxSize[0]), vec2.clone(_boxSize[1]), vec2.clone(_boxSize[2]), vec2.clone(_boxSize[3])]];
    }
}

function transformResult(result) {
    var topRight = _inputStream.getTopRight(),
        xOffset = topRight.x,
        yOffset = topRight.y,
        i;

    if (xOffset === 0 && yOffset === 0) {
        return;
    }

    if (result.barcodes) {
        for (i = 0; i < result.barcodes.length; i++) {
            transformResult(result.barcodes[i]);
        }
    }

    if (result.line && result.line.length === 2) {
        moveLine(result.line);
    }

    if (result.box) {
        moveBox(result.box);
    }

    if (result.boxes && result.boxes.length > 0) {
        for (i = 0; i < result.boxes.length; i++) {
            moveBox(result.boxes[i]);
        }
    }

    function moveBox(box) {
        var corner = box.length;

        while (corner--) {
            box[corner][0] += xOffset;
            box[corner][1] += yOffset;
        }
    }

    function moveLine(line) {
        line[0].x += xOffset;
        line[0].y += yOffset;
        line[1].x += xOffset;
        line[1].y += yOffset;
    }
}

function addResult(result, imageData) {
    if (!imageData || !_resultCollector) {
        return;
    }

    if (result.barcodes) {
        result.barcodes.filter(function (barcode) {
            return barcode.codeResult;
        }).forEach(function (barcode) {
            return addResult(barcode, imageData);
        });
    } else if (result.codeResult) {
        _resultCollector.addResult(imageData, _inputStream.getCanvasSize(), result.codeResult);
    }
}

function hasCodeResult(result) {
    return result && (result.barcodes ? result.barcodes.some(function (barcode) {
        return barcode.codeResult;
    }) : result.codeResult);
}

function publishResult(result, imageData) {
    var resultToPublish = result;

    if (result && _onUIThread) {
        transformResult(result);
        addResult(result, imageData);
        resultToPublish = result.barcodes || result;
    }

    _events2.default.publish("processed", resultToPublish);
    if (hasCodeResult(result)) {
        _events2.default.publish("detected", resultToPublish);
    }
}

function locateAndDecode() {
    var result, boxes;

    boxes = getBoundingBoxes();
    if (boxes) {
        result = _decoder.decodeFromBoundingBoxes(boxes);
        result = result || {};
        result.boxes = boxes;
        publishResult(result, _inputImageWrapper.data);
    } else {
        publishResult();
    }
}

function update() {
    var availableWorker;

    if (_onUIThread) {
        if (_workerPool.length > 0) {
            availableWorker = _workerPool.filter(function (workerThread) {
                return !workerThread.busy;
            })[0];
            if (availableWorker) {
                _framegrabber.attachData(availableWorker.imageData);
            } else {
                return; // all workers are busy
            }
        } else {
            _framegrabber.attachData(_inputImageWrapper.data);
        }
        if (_framegrabber.grab()) {
            if (availableWorker) {
                availableWorker.busy = true;
                availableWorker.worker.postMessage({
                    cmd: 'process',
                    imageData: availableWorker.imageData
                }, [availableWorker.imageData.buffer]);
            } else {
                locateAndDecode();
            }
        }
    } else {
        locateAndDecode();
    }
}

function startContinuousUpdate() {
    var next = null,
        delay = 1000 / (_config.frequency || 60);

    _stopped = false;
    (function frame(timestamp) {
        next = next || timestamp;
        if (!_stopped) {
            if (timestamp >= next) {
                next += delay;
                update();
            }
            window.requestAnimFrame(frame);
        }
    })(performance.now());
}

function _start() {
    if (_onUIThread && _config.inputStream.type === "LiveStream") {
        startContinuousUpdate();
    } else {
        update();
    }
}

function initWorker(cb) {
    var blobURL,
        workerThread = {
        worker: undefined,
        imageData: new Uint8Array(_inputStream.getWidth() * _inputStream.getHeight()),
        busy: true
    };

    blobURL = generateWorkerBlob();
    workerThread.worker = new Worker(blobURL);

    workerThread.worker.onmessage = function (e) {
        if (e.data.event === 'initialized') {
            URL.revokeObjectURL(blobURL);
            workerThread.busy = false;
            workerThread.imageData = new Uint8Array(e.data.imageData);
            if (false) {
                console.log("Worker initialized");
            }
            return cb(workerThread);
        } else if (e.data.event === 'processed') {
            workerThread.imageData = new Uint8Array(e.data.imageData);
            workerThread.busy = false;
            publishResult(e.data.result, workerThread.imageData);
        } else if (e.data.event === 'error') {
            if (false) {
                console.log("Worker error: " + e.data.message);
            }
        }
    };

    workerThread.worker.postMessage({
        cmd: 'init',
        size: { x: _inputStream.getWidth(), y: _inputStream.getHeight() },
        imageData: workerThread.imageData,
        config: configForWorker(_config)
    }, [workerThread.imageData.buffer]);
}

function configForWorker(config) {
    return _extends({}, config, {
        inputStream: _extends({}, config.inputStream, {
            target: null
        })
    });
}

function workerInterface(factory) {
    /* eslint-disable no-undef*/
    if (factory) {
        var Quagga = factory().default;
        if (!Quagga) {
            self.postMessage({ 'event': 'error', message: 'Quagga could not be created' });
            return;
        }
    }
    var imageWrapper;

    self.onmessage = function (e) {
        if (e.data.cmd === 'init') {
            var config = e.data.config;
            config.numOfWorkers = 0;
            imageWrapper = new Quagga.ImageWrapper({
                x: e.data.size.x,
                y: e.data.size.y
            }, new Uint8Array(e.data.imageData));
            Quagga.init(config, ready, imageWrapper);
            Quagga.onProcessed(onProcessed);
        } else if (e.data.cmd === 'process') {
            imageWrapper.data = new Uint8Array(e.data.imageData);
            Quagga.start();
        } else if (e.data.cmd === 'setReaders') {
            Quagga.setReaders(e.data.readers);
        }
    };

    function onProcessed(result) {
        self.postMessage({
            'event': 'processed',
            imageData: imageWrapper.data,
            result: result
        }, [imageWrapper.data.buffer]);
    }

    function ready() {
        // eslint-disable-line
        self.postMessage({ 'event': 'initialized', imageData: imageWrapper.data }, [imageWrapper.data.buffer]);
    }

    /* eslint-enable */
}

function generateWorkerBlob() {
    var blob, factorySource;

    /* jshint ignore:start */
    if (typeof __factorySource__ !== 'undefined') {
        factorySource = __factorySource__; // eslint-disable-line no-undef
    }
    /* jshint ignore:end */

    blob = new Blob(['(' + workerInterface.toString() + ')(' + factorySource + ');'], { type: 'text/javascript' });

    return window.URL.createObjectURL(blob);
}

function _setReaders(readers) {
    if (_decoder) {
        _decoder.setReaders(readers);
    } else if (_onUIThread && _workerPool.length > 0) {
        _workerPool.forEach(function (workerThread) {
            workerThread.worker.postMessage({ cmd: 'setReaders', readers: readers });
        });
    }
}

function adjustWorkerPool(capacity, cb) {
    var increaseBy = capacity - _workerPool.length;
    if (increaseBy === 0) {
        return cb && cb();
    }
    if (increaseBy < 0) {
        var workersToTerminate = _workerPool.slice(increaseBy);
        workersToTerminate.forEach(function (workerThread) {
            workerThread.worker.terminate();
            if (false) {
                console.log("Worker terminated!");
            }
        });
        _workerPool = _workerPool.slice(0, increaseBy);
        return cb && cb();
    } else {
        var workerInitialized = function workerInitialized(workerThread) {
            _workerPool.push(workerThread);
            if (_workerPool.length >= capacity) {
                cb && cb();
            }
        };

        for (var i = 0; i < increaseBy; i++) {
            initWorker(workerInitialized);
        }
    }
}

exports.default = {
    init: function init(config, cb, imageWrapper) {
        _config = (0, _merge3.default)({}, _config3.default, config);
        if (imageWrapper) {
            _onUIThread = false;
            initializeData(imageWrapper);
            return cb();
        } else {
            initInputStream(cb);
        }
    },
    start: function start() {
        _start();
    },
    stop: function stop() {
        _stopped = true;
        adjustWorkerPool(0);
        if (_config.inputStream.type === "LiveStream") {
            _camera_access2.default.release();
            _inputStream.clearEventHandlers();
        }
    },
    pause: function pause() {
        _stopped = true;
    },
    onDetected: function onDetected(callback) {
        _events2.default.subscribe("detected", callback);
    },
    offDetected: function offDetected(callback) {
        _events2.default.unsubscribe("detected", callback);
    },
    onProcessed: function onProcessed(callback) {
        _events2.default.subscribe("processed", callback);
    },
    offProcessed: function offProcessed(callback) {
        _events2.default.unsubscribe("processed", callback);
    },
    setReaders: function setReaders(readers) {
        _setReaders(readers);
    },
    registerResultCollector: function registerResultCollector(resultCollector) {
        if (resultCollector && typeof resultCollector.addResult === 'function') {
            _resultCollector = resultCollector;
        }
    },
    canvas: _canvasContainer,
    decodeSingle: function decodeSingle(config, resultCallback) {
        var _this = this;

        config = (0, _merge3.default)({
            inputStream: {
                type: "ImageStream",
                sequence: false,
                size: 800,
                src: config.src
            },
            numOfWorkers:  false ? 0 : 1,
            locator: {
                halfSample: false
            }
        }, config);
        this.init(config, function () {
            _events2.default.once("processed", function (result) {
                _this.stop();
                resultCallback.call(null, result);
            }, true);
            _start();
        });
    },
    ImageWrapper: _image_wrapper2.default,
    ImageDebug: _image_debug2.default,
    ResultCollector: _result_collector2.default,
    CameraAccess: _camera_access2.default
};

/***/ }),
/* 49 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var CVUtils = __webpack_require__(19),
    Ndarray = __webpack_require__(165),
    Interp2D = __webpack_require__(166).d2;

var FrameGrabber = {};

FrameGrabber.create = function (inputStream) {
    var _that = {},
        _streamConfig = inputStream.getConfig(),
        _video_size = CVUtils.imageRef(inputStream.getRealWidth(), inputStream.getRealHeight()),
        _canvasSize = inputStream.getCanvasSize(),
        _size = CVUtils.imageRef(inputStream.getWidth(), inputStream.getHeight()),
        _topRight = inputStream.getTopRight(),
        _data = new Uint8Array(_size.x * _size.y),
        _grayData = new Uint8Array(_video_size.x * _video_size.y),
        _canvasData = new Uint8Array(_canvasSize.x * _canvasSize.y),
        _grayImageArray = Ndarray(_grayData, [_video_size.y, _video_size.x]).transpose(1, 0),
        _canvasImageArray = Ndarray(_canvasData, [_canvasSize.y, _canvasSize.x]).transpose(1, 0),
        _targetImageArray = _canvasImageArray.hi(_topRight.x + _size.x, _topRight.y + _size.y).lo(_topRight.x, _topRight.y),
        _stepSizeX = _video_size.x / _canvasSize.x,
        _stepSizeY = _video_size.y / _canvasSize.y;

    console.log("FrameGrabber", JSON.stringify({
        videoSize: _grayImageArray.shape,
        canvasSize: _canvasImageArray.shape,
        stepSize: [_stepSizeX, _stepSizeY],
        size: _targetImageArray.shape,
        topRight: _topRight
    }));

    /**
     * Uses the given array as frame-buffer
     */
    _that.attachData = function (data) {
        _data = data;
    };

    /**
     * Returns the used frame-buffer
     */
    _that.getData = function () {
        return _data;
    };

    /**
     * Fetches a frame from the input-stream and puts into the frame-buffer.
     * The image-data is converted to gray-scale and then half-sampled if configured.
     */
    _that.grab = function () {
        var frame = inputStream.getFrame();

        if (frame) {
            this.scaleAndCrop(frame);
            return true;
        } else {
            return false;
        }
    };

    _that.scaleAndCrop = function (frame) {
        var x, y;

        // 1. compute full-sized gray image
        CVUtils.computeGray(frame.data, _grayData);

        // 2. interpolate
        for (y = 0; y < _canvasSize.y; y++) {
            for (x = 0; x < _canvasSize.x; x++) {
                _canvasImageArray.set(x, y, Interp2D(_grayImageArray, x * _stepSizeX, y * _stepSizeY) | 0);
            }
        }

        // targetImageArray must be equal to targetSize
        if (_targetImageArray.shape[0] !== _size.x || _targetImageArray.shape[1] !== _size.y) {
            throw new Error("Shapes do not match!");
        }

        // 3. crop
        for (y = 0; y < _size.y; y++) {
            for (x = 0; x < _size.x; x++) {
                _data[y * _size.x + x] = _targetImageArray.get(x, y);
            }
        }
    }, _that.getSize = function () {
        return _size;
    };

    return _that;
};

module.exports = FrameGrabber;

/***/ }),
/* 50 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var GetPixels = __webpack_require__(164);

var InputStream = {};

InputStream.createImageStream = function () {
    var that = {};
    var _config = null;

    var width = 0,
        height = 0,
        frameIdx = 0,
        paused = true,
        loaded = false,
        frame = null,
        baseUrl,
        ended = false,
        size,
        calculatedWidth,
        calculatedHeight,
        _eventNames = ['canrecord', 'ended'],
        _eventHandlers = {},
        _topRight = { x: 0, y: 0 },
        _canvasSize = { x: 0, y: 0 };

    function loadImages() {
        loaded = false;
        GetPixels(baseUrl, _config.mime, function (err, pixels) {
            if (err) {
                console.log(err);
                exit(1);
            }
            loaded = true;
            console.log(pixels.shape);
            frame = pixels;
            width = pixels.shape[0];
            height = pixels.shape[1];
            calculatedWidth = _config.size ? width / height > 1 ? _config.size : Math.floor(width / height * _config.size) : width;
            calculatedHeight = _config.size ? width / height > 1 ? Math.floor(height / width * _config.size) : _config.size : height;

            _canvasSize.x = calculatedWidth;
            _canvasSize.y = calculatedHeight;

            setTimeout(function () {
                publishEvent("canrecord", []);
            }, 0);
        });
    }

    function publishEvent(eventName, args) {
        var j,
            handlers = _eventHandlers[eventName];

        if (handlers && handlers.length > 0) {
            for (j = 0; j < handlers.length; j++) {
                handlers[j].apply(that, args);
            }
        }
    }

    that.trigger = publishEvent;

    that.getWidth = function () {
        return calculatedWidth;
    };

    that.getHeight = function () {
        return calculatedHeight;
    };

    that.setWidth = function (width) {
        calculatedWidth = width;
    };

    that.setHeight = function (height) {
        calculatedHeight = height;
    };

    that.getRealWidth = function () {
        return width;
    };

    that.getRealHeight = function () {
        return height;
    };

    that.setInputStream = function (stream) {
        _config = stream;
        baseUrl = _config.src;
        size = 1;
        loadImages();
    };

    that.ended = function () {
        return ended;
    };

    that.setAttribute = function () {};

    that.getConfig = function () {
        return _config;
    };

    that.pause = function () {
        paused = true;
    };

    that.play = function () {
        paused = false;
    };

    that.setCurrentTime = function (time) {
        frameIdx = time;
    };

    that.addEventListener = function (event, f) {
        if (_eventNames.indexOf(event) !== -1) {
            if (!_eventHandlers[event]) {
                _eventHandlers[event] = [];
            }
            _eventHandlers[event].push(f);
        }
    };

    that.setTopRight = function (topRight) {
        _topRight.x = topRight.x;
        _topRight.y = topRight.y;
    };

    that.getTopRight = function () {
        return _topRight;
    };

    that.setCanvasSize = function (size) {
        _canvasSize.x = size.x;
        _canvasSize.y = size.y;
    };

    that.getCanvasSize = function () {
        return _canvasSize;
    };

    that.getFrame = function () {
        if (!loaded) {
            return null;
        }
        return frame;
    };

    return that;
};

module.exports = InputStream;

/***/ }),
/* 51 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _image_debug = __webpack_require__(9);

var _image_debug2 = _interopRequireDefault(_image_debug);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function contains(codeResult, list) {
    if (list) {
        return list.some(function (item) {
            return Object.keys(item).every(function (key) {
                return item[key] === codeResult[key];
            });
        });
    }
    return false;
}

function passesFilter(codeResult, filter) {
    if (typeof filter === 'function') {
        return filter(codeResult);
    }
    return true;
}

exports.default = {
    create: function create(config) {
        var canvas = document.createElement("canvas"),
            ctx = canvas.getContext("2d"),
            results = [],
            capacity = config.capacity || 20,
            capture = config.capture === true;

        function matchesConstraints(codeResult) {
            return capacity && codeResult && !contains(codeResult, config.blacklist) && passesFilter(codeResult, config.filter);
        }

        return {
            addResult: function addResult(data, imageSize, codeResult) {
                var result = {};

                if (matchesConstraints(codeResult)) {
                    capacity--;
                    result.codeResult = codeResult;
                    if (capture) {
                        canvas.width = imageSize.x;
                        canvas.height = imageSize.y;
                        _image_debug2.default.drawImage(data, imageSize, ctx);
                        result.frame = canvas.toDataURL();
                    }
                    results.push(result);
                }
            },
            getResults: function getResults() {
                return results;
            }
        };
    }
};

/***/ }),
/* 52 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;
var vec2 = {
    clone: __webpack_require__(7),
    dot: __webpack_require__(32)
};
/**
 * Creates a cluster for grouping similar orientations of datapoints
 */
exports.default = {
    create: function create(point, threshold) {
        var points = [],
            center = {
            rad: 0,
            vec: vec2.clone([0, 0])
        },
            pointMap = {};

        function init() {
            _add(point);
            updateCenter();
        }

        function _add(pointToAdd) {
            pointMap[pointToAdd.id] = pointToAdd;
            points.push(pointToAdd);
        }

        function updateCenter() {
            var i,
                sum = 0;
            for (i = 0; i < points.length; i++) {
                sum += points[i].rad;
            }
            center.rad = sum / points.length;
            center.vec = vec2.clone([Math.cos(center.rad), Math.sin(center.rad)]);
        }

        init();

        return {
            add: function add(pointToAdd) {
                if (!pointMap[pointToAdd.id]) {
                    _add(pointToAdd);
                    updateCenter();
                }
            },
            fits: function fits(otherPoint) {
                // check cosine similarity to center-angle
                var similarity = Math.abs(vec2.dot(otherPoint.point.vec, center.vec));
                if (similarity > threshold) {
                    return true;
                }
                return false;
            },
            getPoints: function getPoints() {
                return points;
            },
            getCenter: function getCenter() {
                return center;
            }
        };
    },
    createPoint: function createPoint(newPoint, id, property) {
        return {
            rad: newPoint[property],
            point: newPoint,
            id: id
        };
    }
};

/***/ }),
/* 53 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

exports.default = function () {
    var events = {};

    function getEvent(eventName) {
        if (!events[eventName]) {
            events[eventName] = {
                subscribers: []
            };
        }
        return events[eventName];
    }

    function clearEvents() {
        events = {};
    }

    function publishSubscription(subscription, data) {
        if (subscription.async) {
            setTimeout(function () {
                subscription.callback(data);
            }, 4);
        } else {
            subscription.callback(data);
        }
    }

    function _subscribe(event, callback, async) {
        var subscription;

        if (typeof callback === "function") {
            subscription = {
                callback: callback,
                async: async
            };
        } else {
            subscription = callback;
            if (!subscription.callback) {
                throw "Callback was not specified on options";
            }
        }

        getEvent(event).subscribers.push(subscription);
    }

    return {
        subscribe: function subscribe(event, callback, async) {
            return _subscribe(event, callback, async);
        },
        publish: function publish(eventName, data) {
            var event = getEvent(eventName),
                subscribers = event.subscribers;

            // Publish one-time subscriptions
            subscribers.filter(function (subscriber) {
                return !!subscriber.once;
            }).forEach(function (subscriber) {
                publishSubscription(subscriber, data);
            });

            // remove them from the subscriber
            event.subscribers = subscribers.filter(function (subscriber) {
                return !subscriber.once;
            });

            // publish the rest
            event.subscribers.forEach(function (subscriber) {
                publishSubscription(subscriber, data);
            });
        },
        once: function once(event, callback, async) {
            _subscribe(event, {
                callback: callback,
                async: async,
                once: true
            });
        },
        unsubscribe: function unsubscribe(eventName, callback) {
            var event;

            if (eventName) {
                event = getEvent(eventName);
                if (event && callback) {
                    event.subscribers = event.subscribers.filter(function (subscriber) {
                        return subscriber.callback !== callback;
                    });
                } else {
                    event.subscribers = [];
                }
            } else {
                clearEvents();
            }
        }
    };
}();

/***/ }),
/* 54 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;
exports.enumerateDevices = enumerateDevices;
exports.getUserMedia = getUserMedia;
function enumerateDevices() {
    if (navigator.mediaDevices && typeof navigator.mediaDevices.enumerateDevices === 'function') {
        return navigator.mediaDevices.enumerateDevices();
    }
    return Promise.reject(new Error('enumerateDevices is not defined'));
};

function getUserMedia(constraints) {
    if (navigator.mediaDevices && typeof navigator.mediaDevices.getUserMedia === 'function') {
        return navigator.mediaDevices.getUserMedia(constraints);
    }
    return Promise.reject(new Error('getUserMedia is not defined'));
}

/***/ }),
/* 55 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;
/**
 * Construct representing a part of another {ImageWrapper}. Shares data
 * between the parent and the child.
 * @param from {ImageRef} The position where to start the {SubImage} from. (top-left corner)
 * @param size {ImageRef} The size of the resulting image
 * @param I {ImageWrapper} The {ImageWrapper} to share from
 * @returns {SubImage} A shared part of the original image
 */
function SubImage(from, size, I) {
    if (!I) {
        I = {
            data: null,
            size: size
        };
    }
    this.data = I.data;
    this.originalSize = I.size;
    this.I = I;

    this.from = from;
    this.size = size;
}

/**
 * Displays the {SubImage} in a given canvas
 * @param canvas {Canvas} The canvas element to write to
 * @param scale {Number} Scale which is applied to each pixel-value
 */
SubImage.prototype.show = function (canvas, scale) {
    var ctx, frame, data, current, y, x, pixel;

    if (!scale) {
        scale = 1.0;
    }
    ctx = canvas.getContext('2d');
    canvas.width = this.size.x;
    canvas.height = this.size.y;
    frame = ctx.getImageData(0, 0, canvas.width, canvas.height);
    data = frame.data;
    current = 0;
    for (y = 0; y < this.size.y; y++) {
        for (x = 0; x < this.size.x; x++) {
            pixel = y * this.size.x + x;
            current = this.get(x, y) * scale;
            data[pixel * 4 + 0] = current;
            data[pixel * 4 + 1] = current;
            data[pixel * 4 + 2] = current;
            data[pixel * 4 + 3] = 255;
        }
    }
    frame.data = data;
    ctx.putImageData(frame, 0, 0);
};

/**
 * Retrieves a given pixel position from the {SubImage}
 * @param x {Number} The x-position
 * @param y {Number} The y-position
 * @returns {Number} The grayscale value at the pixel-position
 */
SubImage.prototype.get = function (x, y) {
    return this.data[(this.from.y + y) * this.originalSize.x + this.from.x + x];
};

/**
 * Updates the underlying data from a given {ImageWrapper}
 * @param image {ImageWrapper} The updated image
 */
SubImage.prototype.updateData = function (image) {
    this.originalSize = image.size;
    this.data = image.data;
};

/**
 * Updates the position of the shared area
 * @param from {x,y} The new location
 * @returns {SubImage} returns {this} for possible chaining
 */
SubImage.prototype.updateFrom = function (from) {
    this.from = from;
    return this;
};

exports.default = SubImage;

/***/ }),
/* 56 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/*
 * typedefs.js
 * Normalizes browser-specific prefixes
 */

if (typeof window !== 'undefined') {
    window.requestAnimFrame = function () {
        return window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame || function ( /* function FrameRequestCallback */callback) {
            window.setTimeout(callback, 1000 / 60);
        };
    }();
}
Math.imul = Math.imul || function (a, b) {
    var ah = a >>> 16 & 0xffff,
        al = a & 0xffff,
        bh = b >>> 16 & 0xffff,
        bl = b & 0xffff;
    // the shift by 0 fixes the sign on the high part
    // the final |0 converts the unsigned value into a signed value
    return al * bl + (ah * bl + al * bh << 16 >>> 0) | 0;
};

if (typeof Object.assign !== 'function') {
    Object.assign = function (target) {
        // .length of function is 2
        'use strict';

        if (target === null) {
            // TypeError if undefined or null
            throw new TypeError('Cannot convert undefined or null to object');
        }

        var to = Object(target);

        for (var index = 1; index < arguments.length; index++) {
            var nextSource = arguments[index];

            if (nextSource !== null) {
                // Skip over if undefined or null
                for (var nextKey in nextSource) {
                    // Avoid bugs when hasOwnProperty is shadowed
                    if (Object.prototype.hasOwnProperty.call(nextSource, nextKey)) {
                        to[nextKey] = nextSource[nextKey];
                    }
                }
            }
        }
        return to;
    };
}

/***/ }),
/* 57 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;
var config = void 0;

if (false) {
    config = require('./config.dev.js');
} else if (true) {
    config = __webpack_require__(58);
} else {
    config = require('./config.prod.js');
}

exports.default = config;

/***/ }),
/* 58 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


module.exports = {
    inputStream: {
        type: "ImageStream",
        sequence: false,
        size: 800,
        area: {
            top: "0%",
            right: "0%",
            left: "0%",
            bottom: "0%"
        },
        singleChannel: false // true: only the red color-channel is read
    },
    locate: true,
    numOfWorkers: 0,
    decoder: {
        readers: ['code_128_reader']
    },
    locator: {
        halfSample: true,
        patchSize: "medium" // x-small, small, medium, large, x-large
    }
};

/***/ }),
/* 59 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _bresenham = __webpack_require__(60);

var _bresenham2 = _interopRequireDefault(_bresenham);

var _image_debug = __webpack_require__(9);

var _image_debug2 = _interopRequireDefault(_image_debug);

var _code_128_reader = __webpack_require__(67);

var _code_128_reader2 = _interopRequireDefault(_code_128_reader);

var _ean_reader = __webpack_require__(4);

var _ean_reader2 = _interopRequireDefault(_ean_reader);

var _code_39_reader = __webpack_require__(31);

var _code_39_reader2 = _interopRequireDefault(_code_39_reader);

var _code_39_vin_reader = __webpack_require__(68);

var _code_39_vin_reader2 = _interopRequireDefault(_code_39_vin_reader);

var _codabar_reader = __webpack_require__(66);

var _codabar_reader2 = _interopRequireDefault(_codabar_reader);

var _upc_reader = __webpack_require__(75);

var _upc_reader2 = _interopRequireDefault(_upc_reader);

var _ean_8_reader = __webpack_require__(72);

var _ean_8_reader2 = _interopRequireDefault(_ean_8_reader);

var _ean_2_reader = __webpack_require__(70);

var _ean_2_reader2 = _interopRequireDefault(_ean_2_reader);

var _ean_5_reader = __webpack_require__(71);

var _ean_5_reader2 = _interopRequireDefault(_ean_5_reader);

var _upc_e_reader = __webpack_require__(74);

var _upc_e_reader2 = _interopRequireDefault(_upc_e_reader);

var _i2of5_reader = __webpack_require__(73);

var _i2of5_reader2 = _interopRequireDefault(_i2of5_reader);

var _of5_reader = __webpack_require__(65);

var _of5_reader2 = _interopRequireDefault(_of5_reader);

var _code_93_reader = __webpack_require__(69);

var _code_93_reader2 = _interopRequireDefault(_code_93_reader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var READERS = {
    code_128_reader: _code_128_reader2.default,
    ean_reader: _ean_reader2.default,
    ean_5_reader: _ean_5_reader2.default,
    ean_2_reader: _ean_2_reader2.default,
    ean_8_reader: _ean_8_reader2.default,
    code_39_reader: _code_39_reader2.default,
    code_39_vin_reader: _code_39_vin_reader2.default,
    codabar_reader: _codabar_reader2.default,
    upc_reader: _upc_reader2.default,
    upc_e_reader: _upc_e_reader2.default,
    i2of5_reader: _i2of5_reader2.default,
    '2of5_reader': _of5_reader2.default,
    code_93_reader: _code_93_reader2.default
};
exports.default = {
    create: function create(config, inputImageWrapper) {
        var _canvas = {
            ctx: {
                frequency: null,
                pattern: null,
                overlay: null
            },
            dom: {
                frequency: null,
                pattern: null,
                overlay: null
            }
        },
            _barcodeReaders = [];

        initCanvas();
        initReaders();
        initConfig();

        function initCanvas() {
            if (false) {
                var $debug = document.querySelector("#debug.detection");
                _canvas.dom.frequency = document.querySelector("canvas.frequency");
                if (!_canvas.dom.frequency) {
                    _canvas.dom.frequency = document.createElement("canvas");
                    _canvas.dom.frequency.className = "frequency";
                    if ($debug) {
                        $debug.appendChild(_canvas.dom.frequency);
                    }
                }
                _canvas.ctx.frequency = _canvas.dom.frequency.getContext("2d");

                _canvas.dom.pattern = document.querySelector("canvas.patternBuffer");
                if (!_canvas.dom.pattern) {
                    _canvas.dom.pattern = document.createElement("canvas");
                    _canvas.dom.pattern.className = "patternBuffer";
                    if ($debug) {
                        $debug.appendChild(_canvas.dom.pattern);
                    }
                }
                _canvas.ctx.pattern = _canvas.dom.pattern.getContext("2d");

                _canvas.dom.overlay = document.querySelector("canvas.drawingBuffer");
                if (_canvas.dom.overlay) {
                    _canvas.ctx.overlay = _canvas.dom.overlay.getContext("2d");
                }
            }
        }

        function initReaders() {
            config.readers.forEach(function (readerConfig) {
                var reader,
                    configuration = {},
                    supplements = [];

                if ((typeof readerConfig === 'undefined' ? 'undefined' : _typeof(readerConfig)) === 'object') {
                    reader = readerConfig.format;
                    configuration = readerConfig.config;
                } else if (typeof readerConfig === 'string') {
                    reader = readerConfig;
                }
                if (false) {
                    console.log("Before registering reader: ", reader);
                }
                if (configuration.supplements) {
                    supplements = configuration.supplements.map(function (supplement) {
                        return new READERS[supplement]();
                    });
                }
                _barcodeReaders.push(new READERS[reader](configuration, supplements));
            });
            if (false) {
                console.log("Registered Readers: " + _barcodeReaders.map(function (reader) {
                    return JSON.stringify({ format: reader.FORMAT, config: reader.config });
                }).join(', '));
            }
        }

        function initConfig() {
            if (false) {
                var i,
                    vis = [{
                    node: _canvas.dom.frequency,
                    prop: config.debug.showFrequency
                }, {
                    node: _canvas.dom.pattern,
                    prop: config.debug.showPattern
                }];

                for (i = 0; i < vis.length; i++) {
                    if (vis[i].prop === true) {
                        vis[i].node.style.display = "block";
                    } else {
                        vis[i].node.style.display = "none";
                    }
                }
            }
        }

        /**
         * extend the line on both ends
         * @param {Array} line
         * @param {Number} angle
         */
        function getExtendedLine(line, angle, ext) {
            function extendLine(amount) {
                var extension = {
                    y: amount * Math.sin(angle),
                    x: amount * Math.cos(angle)
                };

                line[0].y -= extension.y;
                line[0].x -= extension.x;
                line[1].y += extension.y;
                line[1].x += extension.x;
            }

            // check if inside image
            extendLine(ext);
            while (ext > 1 && (!inputImageWrapper.inImageWithBorder(line[0], 0) || !inputImageWrapper.inImageWithBorder(line[1], 0))) {
                ext -= Math.ceil(ext / 2);
                extendLine(-ext);
            }
            return line;
        }

        function getLine(box) {
            return [{
                x: (box[1][0] - box[0][0]) / 2 + box[0][0],
                y: (box[1][1] - box[0][1]) / 2 + box[0][1]
            }, {
                x: (box[3][0] - box[2][0]) / 2 + box[2][0],
                y: (box[3][1] - box[2][1]) / 2 + box[2][1]
            }];
        }

        function tryDecode(line) {
            var result = null,
                i,
                barcodeLine = _bresenham2.default.getBarcodeLine(inputImageWrapper, line[0], line[1]);

            if (false) {
                _image_debug2.default.drawPath(line, { x: 'x', y: 'y' }, _canvas.ctx.overlay, { color: 'red', lineWidth: 3 });
                _bresenham2.default.debug.printFrequency(barcodeLine.line, _canvas.dom.frequency);
            }

            _bresenham2.default.toBinaryLine(barcodeLine);

            if (false) {
                _bresenham2.default.debug.printPattern(barcodeLine.line, _canvas.dom.pattern);
            }

            for (i = 0; i < _barcodeReaders.length && result === null; i++) {
                result = _barcodeReaders[i].decodePattern(barcodeLine.line);
            }
            if (result === null) {
                return null;
            }
            return {
                codeResult: result,
                barcodeLine: barcodeLine
            };
        }

        /**
         * This method slices the given area apart and tries to detect a barcode-pattern
         * for each slice. It returns the decoded barcode, or null if nothing was found
         * @param {Array} box
         * @param {Array} line
         * @param {Number} lineAngle
         */
        function tryDecodeBruteForce(box, line, lineAngle) {
            var sideLength = Math.sqrt(Math.pow(box[1][0] - box[0][0], 2) + Math.pow(box[1][1] - box[0][1], 2)),
                i,
                slices = 16,
                result = null,
                dir,
                extension,
                xdir = Math.sin(lineAngle),
                ydir = Math.cos(lineAngle);

            for (i = 1; i < slices && result === null; i++) {
                // move line perpendicular to angle
                dir = sideLength / slices * i * (i % 2 === 0 ? -1 : 1);
                extension = {
                    y: dir * xdir,
                    x: dir * ydir
                };
                line[0].y += extension.x;
                line[0].x -= extension.y;
                line[1].y += extension.x;
                line[1].x -= extension.y;

                result = tryDecode(line);
            }
            return result;
        }

        function getLineLength(line) {
            return Math.sqrt(Math.pow(Math.abs(line[1].y - line[0].y), 2) + Math.pow(Math.abs(line[1].x - line[0].x), 2));
        }

        /**
         * With the help of the configured readers (Code128 or EAN) this function tries to detect a
         * valid barcode pattern within the given area.
         * @param {Object} box The area to search in
         * @returns {Object} the result {codeResult, line, angle, pattern, threshold}
         */
        function _decodeFromBoundingBox(box) {
            var line,
                lineAngle,
                ctx = _canvas.ctx.overlay,
                result,
                lineLength;

            if (false) {
                if (config.debug.drawBoundingBox && ctx) {
                    _image_debug2.default.drawPath(box, { x: 0, y: 1 }, ctx, { color: "blue", lineWidth: 2 });
                }
            }

            line = getLine(box);
            lineLength = getLineLength(line);
            lineAngle = Math.atan2(line[1].y - line[0].y, line[1].x - line[0].x);
            line = getExtendedLine(line, lineAngle, Math.floor(lineLength * 0.1));
            if (line === null) {
                return null;
            }

            result = tryDecode(line);
            if (result === null) {
                result = tryDecodeBruteForce(box, line, lineAngle);
            }

            if (result === null) {
                return null;
            }

            if (false) {
                _image_debug2.default.drawPath(line, { x: 'x', y: 'y' }, ctx, { color: 'red', lineWidth: 3 });
            }

            return {
                codeResult: result.codeResult,
                line: line,
                angle: lineAngle,
                pattern: result.barcodeLine.line,
                threshold: result.barcodeLine.threshold
            };
        }

        return {
            decodeFromBoundingBox: function decodeFromBoundingBox(box) {
                return _decodeFromBoundingBox(box);
            },
            decodeFromBoundingBoxes: function decodeFromBoundingBoxes(boxes) {
                var i,
                    result,
                    barcodes = [],
                    multiple = config.multiple;

                for (i = 0; i < boxes.length; i++) {
                    var box = boxes[i];
                    result = _decodeFromBoundingBox(box) || {};
                    result.box = box;

                    if (multiple) {
                        barcodes.push(result);
                    } else if (result.codeResult) {
                        return result;
                    }
                }

                if (multiple) {
                    return {
                        barcodes: barcodes
                    };
                }
            },
            setReaders: function setReaders(readers) {
                config.readers = readers;
                _barcodeReaders.length = 0;
                initReaders();
            }
        };
    }
};

/***/ }),
/* 60 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _image_wrapper = __webpack_require__(20);

var _image_wrapper2 = _interopRequireDefault(_image_wrapper);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var Bresenham = {};

var Slope = {
    DIR: {
        UP: 1,
        DOWN: -1
    }
};
/**
 * Scans a line of the given image from point p1 to p2 and returns a result object containing
 * gray-scale values (0-255) of the underlying pixels in addition to the min
 * and max values.
 * @param {Object} imageWrapper
 * @param {Object} p1 The start point {x,y}
 * @param {Object} p2 The end point {x,y}
 * @returns {line, min, max}
 */
Bresenham.getBarcodeLine = function (imageWrapper, p1, p2) {
    var x0 = p1.x | 0,
        y0 = p1.y | 0,
        x1 = p2.x | 0,
        y1 = p2.y | 0,
        steep = Math.abs(y1 - y0) > Math.abs(x1 - x0),
        deltax,
        deltay,
        error,
        ystep,
        y,
        tmp,
        x,
        line = [],
        imageData = imageWrapper.data,
        width = imageWrapper.size.x,
        sum = 0,
        val,
        min = 255,
        max = 0;

    function read(a, b) {
        val = imageData[b * width + a];
        sum += val;
        min = val < min ? val : min;
        max = val > max ? val : max;
        line.push(val);
    }

    if (steep) {
        tmp = x0;
        x0 = y0;
        y0 = tmp;

        tmp = x1;
        x1 = y1;
        y1 = tmp;
    }
    if (x0 > x1) {
        tmp = x0;
        x0 = x1;
        x1 = tmp;

        tmp = y0;
        y0 = y1;
        y1 = tmp;
    }
    deltax = x1 - x0;
    deltay = Math.abs(y1 - y0);
    error = deltax / 2 | 0;
    y = y0;
    ystep = y0 < y1 ? 1 : -1;
    for (x = x0; x < x1; x++) {
        if (steep) {
            read(y, x);
        } else {
            read(x, y);
        }
        error = error - deltay;
        if (error < 0) {
            y = y + ystep;
            error = error + deltax;
        }
    }

    return {
        line: line,
        min: min,
        max: max
    };
};

/**
 * Converts the result from getBarcodeLine into a binary representation
 * also considering the frequency and slope of the signal for more robust results
 * @param {Object} result {line, min, max}
 */
Bresenham.toBinaryLine = function (result) {
    var min = result.min,
        max = result.max,
        line = result.line,
        slope,
        slope2,
        center = min + (max - min) / 2,
        extrema = [],
        currentDir,
        dir,
        threshold = (max - min) / 12,
        rThreshold = -threshold,
        i,
        j;

    // 1. find extrema
    currentDir = line[0] > center ? Slope.DIR.UP : Slope.DIR.DOWN;
    extrema.push({
        pos: 0,
        val: line[0]
    });
    for (i = 0; i < line.length - 2; i++) {
        slope = line[i + 1] - line[i];
        slope2 = line[i + 2] - line[i + 1];
        if (slope + slope2 < rThreshold && line[i + 1] < center * 1.5) {
            dir = Slope.DIR.DOWN;
        } else if (slope + slope2 > threshold && line[i + 1] > center * 0.5) {
            dir = Slope.DIR.UP;
        } else {
            dir = currentDir;
        }

        if (currentDir !== dir) {
            extrema.push({
                pos: i,
                val: line[i]
            });
            currentDir = dir;
        }
    }
    extrema.push({
        pos: line.length,
        val: line[line.length - 1]
    });

    for (j = extrema[0].pos; j < extrema[1].pos; j++) {
        line[j] = line[j] > center ? 0 : 1;
    }

    // iterate over extrema and convert to binary based on avg between minmax
    for (i = 1; i < extrema.length - 1; i++) {
        if (extrema[i + 1].val > extrema[i].val) {
            threshold = extrema[i].val + (extrema[i + 1].val - extrema[i].val) / 3 * 2 | 0;
        } else {
            threshold = extrema[i + 1].val + (extrema[i].val - extrema[i + 1].val) / 3 | 0;
        }

        for (j = extrema[i].pos; j < extrema[i + 1].pos; j++) {
            line[j] = line[j] > threshold ? 0 : 1;
        }
    }

    return {
        line: line,
        threshold: threshold
    };
};

/**
 * Used for development only
 */
Bresenham.debug = {
    printFrequency: function printFrequency(line, canvas) {
        var i,
            ctx = canvas.getContext("2d");
        canvas.width = line.length;
        canvas.height = 256;

        ctx.beginPath();
        ctx.strokeStyle = "blue";
        for (i = 0; i < line.length; i++) {
            ctx.moveTo(i, 255);
            ctx.lineTo(i, 255 - line[i]);
        }
        ctx.stroke();
        ctx.closePath();
    },

    printPattern: function printPattern(line, canvas) {
        var ctx = canvas.getContext("2d"),
            i;

        canvas.width = line.length;
        ctx.fillColor = "black";
        for (i = 0; i < line.length; i++) {
            if (line[i] === 1) {
                ctx.fillRect(i, 0, 1, 100);
            }
        }
    }
};

exports.default = Bresenham;

/***/ }),
/* 61 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _pick2 = __webpack_require__(160);

var _pick3 = _interopRequireDefault(_pick2);

exports.pickConstraints = pickConstraints;

var _mediaDevices = __webpack_require__(54);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var facingMatching = {
    "user": /front/i,
    "environment": /back/i
};

var streamRef;

function waitForVideo(video) {
    return new Promise(function (resolve, reject) {
        var attempts = 10;

        function checkVideo() {
            if (attempts > 0) {
                if (video.videoWidth > 10 && video.videoHeight > 10) {
                    if (false) {
                        console.log(video.videoWidth + "px x " + video.videoHeight + "px");
                    }
                    resolve();
                } else {
                    window.setTimeout(checkVideo, 500);
                }
            } else {
                reject('Unable to play video stream. Is webcam working?');
            }
            attempts--;
        }
        checkVideo();
    });
}

/**
 * Tries to attach the camera-stream to a given video-element
 * and calls the callback function when the content is ready
 * @param {Object} constraints
 * @param {Object} video
 */
function initCamera(video, constraints) {
    return (0, _mediaDevices.getUserMedia)(constraints).then(function (stream) {
        return new Promise(function (resolve) {
            streamRef = stream;
            video.setAttribute("autoplay", true);
            video.setAttribute('muted', true);
            video.setAttribute('playsinline', true);
            video.srcObject = stream;
            video.addEventListener('loadedmetadata', function () {
                video.play();
                resolve();
            });
        });
    }).then(waitForVideo.bind(null, video));
}

function deprecatedConstraints(videoConstraints) {
    var normalized = (0, _pick3.default)(videoConstraints, ["width", "height", "facingMode", "aspectRatio", "deviceId"]);

    if (typeof videoConstraints.minAspectRatio !== 'undefined' && videoConstraints.minAspectRatio > 0) {
        normalized.aspectRatio = videoConstraints.minAspectRatio;
        console.log("WARNING: Constraint 'minAspectRatio' is deprecated; Use 'aspectRatio' instead");
    }
    if (typeof videoConstraints.facing !== 'undefined') {
        normalized.facingMode = videoConstraints.facing;
        console.log("WARNING: Constraint 'facing' is deprecated. Use 'facingMode' instead'");
    }
    return normalized;
}

function pickConstraints(videoConstraints) {
    var normalizedConstraints = {
        audio: false,
        video: deprecatedConstraints(videoConstraints)
    };

    if (normalizedConstraints.video.deviceId && normalizedConstraints.video.facingMode) {
        delete normalizedConstraints.video.facingMode;
    }
    return Promise.resolve(normalizedConstraints);
}

function enumerateVideoDevices() {
    return (0, _mediaDevices.enumerateDevices)().then(function (devices) {
        return devices.filter(function (device) {
            return device.kind === 'videoinput';
        });
    });
}

function getActiveTrack() {
    if (streamRef) {
        var tracks = streamRef.getVideoTracks();
        if (tracks && tracks.length) {
            return tracks[0];
        }
    }
}

exports.default = {
    request: function request(video, videoConstraints) {
        return pickConstraints(videoConstraints).then(initCamera.bind(null, video));
    },
    release: function release() {
        var tracks = streamRef && streamRef.getVideoTracks();
        if (tracks && tracks.length) {
            tracks[0].stop();
        }
        streamRef = null;
    },
    enumerateVideoDevices: enumerateVideoDevices,
    getActiveStreamLabel: function getActiveStreamLabel() {
        var track = getActiveTrack();
        return track ? track.label : '';
    },
    getActiveTrack: getActiveTrack
};

/***/ }),
/* 62 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global) {

exports.__esModule = true;

var _image_wrapper = __webpack_require__(20);

var _image_wrapper2 = _interopRequireDefault(_image_wrapper);

var _cv_utils = __webpack_require__(19);

var _array_helper = __webpack_require__(3);

var _array_helper2 = _interopRequireDefault(_array_helper);

var _image_debug = __webpack_require__(9);

var _image_debug2 = _interopRequireDefault(_image_debug);

var _rasterizer = __webpack_require__(63);

var _rasterizer2 = _interopRequireDefault(_rasterizer);

var _tracer = __webpack_require__(30);

var _tracer2 = _interopRequireDefault(_tracer);

var _skeletonizer2 = __webpack_require__(64);

var _skeletonizer3 = _interopRequireDefault(_skeletonizer2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var vec2 = {
    clone: __webpack_require__(7),
    dot: __webpack_require__(32),
    scale: __webpack_require__(79),
    transformMat2: __webpack_require__(80)
};
var mat2 = {
    copy: __webpack_require__(76),
    create: __webpack_require__(77),
    invert: __webpack_require__(78)
};

var _config,
    _currentImageWrapper,
    _skelImageWrapper,
    _subImageWrapper,
    _labelImageWrapper,
    _patchGrid,
    _patchLabelGrid,
    _imageToPatchGrid,
    _binaryImageWrapper,
    _patchSize,
    _canvasContainer = {
    ctx: {
        binary: null
    },
    dom: {
        binary: null
    }
},
    _numPatches = { x: 0, y: 0 },
    _inputImageWrapper,
    _skeletonizer;

function initBuffers() {
    var skeletonImageData;

    if (_config.halfSample) {
        _currentImageWrapper = new _image_wrapper2.default({
            x: _inputImageWrapper.size.x / 2 | 0,
            y: _inputImageWrapper.size.y / 2 | 0
        });
    } else {
        _currentImageWrapper = _inputImageWrapper;
    }

    _patchSize = (0, _cv_utils.calculatePatchSize)(_config.patchSize, _currentImageWrapper.size);

    _numPatches.x = _currentImageWrapper.size.x / _patchSize.x | 0;
    _numPatches.y = _currentImageWrapper.size.y / _patchSize.y | 0;

    _binaryImageWrapper = new _image_wrapper2.default(_currentImageWrapper.size, undefined, Uint8Array, false);

    _labelImageWrapper = new _image_wrapper2.default(_patchSize, undefined, Array, true);

    skeletonImageData = new ArrayBuffer(64 * 1024);
    _subImageWrapper = new _image_wrapper2.default(_patchSize, new Uint8Array(skeletonImageData, 0, _patchSize.x * _patchSize.y));
    _skelImageWrapper = new _image_wrapper2.default(_patchSize, new Uint8Array(skeletonImageData, _patchSize.x * _patchSize.y * 3, _patchSize.x * _patchSize.y), undefined, true);
    _skeletonizer = (0, _skeletonizer3.default)(typeof window !== 'undefined' ? window : typeof self !== 'undefined' ? self : global, {
        size: _patchSize.x
    }, skeletonImageData);

    _imageToPatchGrid = new _image_wrapper2.default({
        x: _currentImageWrapper.size.x / _subImageWrapper.size.x | 0,
        y: _currentImageWrapper.size.y / _subImageWrapper.size.y | 0
    }, undefined, Array, true);
    _patchGrid = new _image_wrapper2.default(_imageToPatchGrid.size, undefined, undefined, true);
    _patchLabelGrid = new _image_wrapper2.default(_imageToPatchGrid.size, undefined, Int32Array, true);
}

function initCanvas() {
    if (_config.useWorker || typeof document === 'undefined') {
        return;
    }
    _canvasContainer.dom.binary = document.createElement("canvas");
    _canvasContainer.dom.binary.className = "binaryBuffer";
    if (false) {
        document.querySelector("#debug").appendChild(_canvasContainer.dom.binary);
    }
    _canvasContainer.ctx.binary = _canvasContainer.dom.binary.getContext("2d");
    _canvasContainer.dom.binary.width = _binaryImageWrapper.size.x;
    _canvasContainer.dom.binary.height = _binaryImageWrapper.size.y;
}

/**
 * Creates a bounding box which encloses all the given patches
 * @returns {Array} The minimal bounding box
 */
function boxFromPatches(patches) {
    var overAvg,
        i,
        j,
        patch,
        transMat,
        minx = _binaryImageWrapper.size.x,
        miny = _binaryImageWrapper.size.y,
        maxx = -_binaryImageWrapper.size.x,
        maxy = -_binaryImageWrapper.size.y,
        box,
        scale;

    // draw all patches which are to be taken into consideration
    overAvg = 0;
    for (i = 0; i < patches.length; i++) {
        patch = patches[i];
        overAvg += patch.rad;
        if (false) {
            _image_debug2.default.drawRect(patch.pos, _subImageWrapper.size, _canvasContainer.ctx.binary, { color: "red" });
        }
    }

    overAvg /= patches.length;
    overAvg = (overAvg * 180 / Math.PI + 90) % 180 - 90;
    if (overAvg < 0) {
        overAvg += 180;
    }

    overAvg = (180 - overAvg) * Math.PI / 180;
    transMat = mat2.copy(mat2.create(), [Math.cos(overAvg), Math.sin(overAvg), -Math.sin(overAvg), Math.cos(overAvg)]);

    // iterate over patches and rotate by angle
    for (i = 0; i < patches.length; i++) {
        patch = patches[i];
        for (j = 0; j < 4; j++) {
            vec2.transformMat2(patch.box[j], patch.box[j], transMat);
        }

        if (false) {
            _image_debug2.default.drawPath(patch.box, { x: 0, y: 1 }, _canvasContainer.ctx.binary, { color: '#99ff00', lineWidth: 2 });
        }
    }

    // find bounding box
    for (i = 0; i < patches.length; i++) {
        patch = patches[i];
        for (j = 0; j < 4; j++) {
            if (patch.box[j][0] < minx) {
                minx = patch.box[j][0];
            }
            if (patch.box[j][0] > maxx) {
                maxx = patch.box[j][0];
            }
            if (patch.box[j][1] < miny) {
                miny = patch.box[j][1];
            }
            if (patch.box[j][1] > maxy) {
                maxy = patch.box[j][1];
            }
        }
    }

    box = [[minx, miny], [maxx, miny], [maxx, maxy], [minx, maxy]];

    if (false) {
        _image_debug2.default.drawPath(box, { x: 0, y: 1 }, _canvasContainer.ctx.binary, { color: '#ff0000', lineWidth: 2 });
    }

    scale = _config.halfSample ? 2 : 1;
    // reverse rotation;
    transMat = mat2.invert(transMat, transMat);
    for (j = 0; j < 4; j++) {
        vec2.transformMat2(box[j], box[j], transMat);
    }

    if (false) {
        _image_debug2.default.drawPath(box, { x: 0, y: 1 }, _canvasContainer.ctx.binary, { color: '#ff0000', lineWidth: 2 });
    }

    for (j = 0; j < 4; j++) {
        vec2.scale(box[j], box[j], scale);
    }

    return box;
}

/**
 * Creates a binary image of the current image
 */
function binarizeImage() {
    (0, _cv_utils.otsuThreshold)(_currentImageWrapper, _binaryImageWrapper);
    _binaryImageWrapper.zeroBorder();
    if (false) {
        _binaryImageWrapper.show(_canvasContainer.dom.binary, 255);
    }
}

/**
 * Iterate over the entire image
 * extract patches
 */
function findPatches() {
    var i,
        j,
        x,
        y,
        moments,
        patchesFound = [],
        rasterizer,
        rasterResult,
        patch;
    for (i = 0; i < _numPatches.x; i++) {
        for (j = 0; j < _numPatches.y; j++) {
            x = _subImageWrapper.size.x * i;
            y = _subImageWrapper.size.y * j;

            // seperate parts
            skeletonize(x, y);

            // Rasterize, find individual bars
            _skelImageWrapper.zeroBorder();
            _array_helper2.default.init(_labelImageWrapper.data, 0);
            rasterizer = _rasterizer2.default.create(_skelImageWrapper, _labelImageWrapper);
            rasterResult = rasterizer.rasterize(0);

            if (false) {
                _labelImageWrapper.overlay(_canvasContainer.dom.binary, Math.floor(360 / rasterResult.count), { x: x, y: y });
            }

            // calculate moments from the skeletonized patch
            moments = _labelImageWrapper.moments(rasterResult.count);

            // extract eligible patches
            patchesFound = patchesFound.concat(describePatch(moments, [i, j], x, y));
        }
    }

    if (false) {
        for (i = 0; i < patchesFound.length; i++) {
            patch = patchesFound[i];
            _image_debug2.default.drawRect(patch.pos, _subImageWrapper.size, _canvasContainer.ctx.binary, { color: "#99ff00", lineWidth: 2 });
        }
    }

    return patchesFound;
}

/**
 * Finds those connected areas which contain at least 6 patches
 * and returns them ordered DESC by the number of contained patches
 * @param {Number} maxLabel
 */
function findBiggestConnectedAreas(maxLabel) {
    var i,
        sum,
        labelHist = [],
        topLabels = [];

    for (i = 0; i < maxLabel; i++) {
        labelHist.push(0);
    }
    sum = _patchLabelGrid.data.length;
    while (sum--) {
        if (_patchLabelGrid.data[sum] > 0) {
            labelHist[_patchLabelGrid.data[sum] - 1]++;
        }
    }

    labelHist = labelHist.map(function (val, idx) {
        return {
            val: val,
            label: idx + 1
        };
    });

    labelHist.sort(function (a, b) {
        return b.val - a.val;
    });

    // extract top areas with at least 6 patches present
    topLabels = labelHist.filter(function (el) {
        return el.val >= 5;
    });

    return topLabels;
}

/**
 *
 */
function findBoxes(topLabels, maxLabel) {
    var i,
        j,
        sum,
        patches = [],
        patch,
        box,
        boxes = [],
        hsv = [0, 1, 1],
        rgb = [0, 0, 0];

    for (i = 0; i < topLabels.length; i++) {
        sum = _patchLabelGrid.data.length;
        patches.length = 0;
        while (sum--) {
            if (_patchLabelGrid.data[sum] === topLabels[i].label) {
                patch = _imageToPatchGrid.data[sum];
                patches.push(patch);
            }
        }
        box = boxFromPatches(patches);
        if (box) {
            boxes.push(box);

            // draw patch-labels if requested
            if (false) {
                for (j = 0; j < patches.length; j++) {
                    patch = patches[j];
                    hsv[0] = topLabels[i].label / (maxLabel + 1) * 360;
                    (0, _cv_utils.hsv2rgb)(hsv, rgb);
                    _image_debug2.default.drawRect(patch.pos, _subImageWrapper.size, _canvasContainer.ctx.binary, { color: "rgb(" + rgb.join(",") + ")", lineWidth: 2 });
                }
            }
        }
    }
    return boxes;
}

/**
 * Find similar moments (via cluster)
 * @param {Object} moments
 */
function similarMoments(moments) {
    var clusters = (0, _cv_utils.cluster)(moments, 0.90);
    var topCluster = (0, _cv_utils.topGeneric)(clusters, 1, function (e) {
        return e.getPoints().length;
    });
    var points = [],
        result = [];
    if (topCluster.length === 1) {
        points = topCluster[0].item.getPoints();
        for (var i = 0; i < points.length; i++) {
            result.push(points[i].point);
        }
    }
    return result;
}

function skeletonize(x, y) {
    _binaryImageWrapper.subImageAsCopy(_subImageWrapper, (0, _cv_utils.imageRef)(x, y));
    _skeletonizer.skeletonize();

    // Show skeleton if requested
    if (false) {
        _skelImageWrapper.overlay(_canvasContainer.dom.binary, 360, (0, _cv_utils.imageRef)(x, y));
    }
}

/**
 * Extracts and describes those patches which seem to contain a barcode pattern
 * @param {Array} moments
 * @param {Object} patchPos,
 * @param {Number} x
 * @param {Number} y
 * @returns {Array} list of patches
 */
function describePatch(moments, patchPos, x, y) {
    var k,
        avg,
        eligibleMoments = [],
        matchingMoments,
        patch,
        patchesFound = [],
        minComponentWeight = Math.ceil(_patchSize.x / 3);

    if (moments.length >= 2) {
        // only collect moments which's area covers at least minComponentWeight pixels.
        for (k = 0; k < moments.length; k++) {
            if (moments[k].m00 > minComponentWeight) {
                eligibleMoments.push(moments[k]);
            }
        }

        // if at least 2 moments are found which have at least minComponentWeights covered
        if (eligibleMoments.length >= 2) {
            matchingMoments = similarMoments(eligibleMoments);
            avg = 0;
            // determine the similarity of the moments
            for (k = 0; k < matchingMoments.length; k++) {
                avg += matchingMoments[k].rad;
            }

            // Only two of the moments are allowed not to fit into the equation
            // add the patch to the set
            if (matchingMoments.length > 1 && matchingMoments.length >= eligibleMoments.length / 4 * 3 && matchingMoments.length > moments.length / 4) {
                avg /= matchingMoments.length;
                patch = {
                    index: patchPos[1] * _numPatches.x + patchPos[0],
                    pos: {
                        x: x,
                        y: y
                    },
                    box: [vec2.clone([x, y]), vec2.clone([x + _subImageWrapper.size.x, y]), vec2.clone([x + _subImageWrapper.size.x, y + _subImageWrapper.size.y]), vec2.clone([x, y + _subImageWrapper.size.y])],
                    moments: matchingMoments,
                    rad: avg,
                    vec: vec2.clone([Math.cos(avg), Math.sin(avg)])
                };
                patchesFound.push(patch);
            }
        }
    }
    return patchesFound;
}

/**
 * finds patches which are connected and share the same orientation
 * @param {Object} patchesFound
 */
function rasterizeAngularSimilarity(patchesFound) {
    var label = 0,
        threshold = 0.95,
        currIdx = 0,
        j,
        patch,
        hsv = [0, 1, 1],
        rgb = [0, 0, 0];

    function notYetProcessed() {
        var i;
        for (i = 0; i < _patchLabelGrid.data.length; i++) {
            if (_patchLabelGrid.data[i] === 0 && _patchGrid.data[i] === 1) {
                return i;
            }
        }
        return _patchLabelGrid.length;
    }

    function trace(currentIdx) {
        var x,
            y,
            currentPatch,
            idx,
            dir,
            current = {
            x: currentIdx % _patchLabelGrid.size.x,
            y: currentIdx / _patchLabelGrid.size.x | 0
        },
            similarity;

        if (currentIdx < _patchLabelGrid.data.length) {
            currentPatch = _imageToPatchGrid.data[currentIdx];
            // assign label
            _patchLabelGrid.data[currentIdx] = label;
            for (dir = 0; dir < _tracer2.default.searchDirections.length; dir++) {
                y = current.y + _tracer2.default.searchDirections[dir][0];
                x = current.x + _tracer2.default.searchDirections[dir][1];
                idx = y * _patchLabelGrid.size.x + x;

                // continue if patch empty
                if (_patchGrid.data[idx] === 0) {
                    _patchLabelGrid.data[idx] = Number.MAX_VALUE;
                    continue;
                }

                if (_patchLabelGrid.data[idx] === 0) {
                    similarity = Math.abs(vec2.dot(_imageToPatchGrid.data[idx].vec, currentPatch.vec));
                    if (similarity > threshold) {
                        trace(idx);
                    }
                }
            }
        }
    }

    // prepare for finding the right patches
    _array_helper2.default.init(_patchGrid.data, 0);
    _array_helper2.default.init(_patchLabelGrid.data, 0);
    _array_helper2.default.init(_imageToPatchGrid.data, null);

    for (j = 0; j < patchesFound.length; j++) {
        patch = patchesFound[j];
        _imageToPatchGrid.data[patch.index] = patch;
        _patchGrid.data[patch.index] = 1;
    }

    // rasterize the patches found to determine area
    _patchGrid.zeroBorder();

    while ((currIdx = notYetProcessed()) < _patchLabelGrid.data.length) {
        label++;
        trace(currIdx);
    }

    // draw patch-labels if requested
    if (false) {
        for (j = 0; j < _patchLabelGrid.data.length; j++) {
            if (_patchLabelGrid.data[j] > 0 && _patchLabelGrid.data[j] <= label) {
                patch = _imageToPatchGrid.data[j];
                hsv[0] = _patchLabelGrid.data[j] / (label + 1) * 360;
                (0, _cv_utils.hsv2rgb)(hsv, rgb);
                _image_debug2.default.drawRect(patch.pos, _subImageWrapper.size, _canvasContainer.ctx.binary, { color: "rgb(" + rgb.join(",") + ")", lineWidth: 2 });
            }
        }
    }

    return label;
}

exports.default = {
    init: function init(inputImageWrapper, config) {
        _config = config;
        _inputImageWrapper = inputImageWrapper;

        initBuffers();
        initCanvas();
    },

    locate: function locate() {
        var patchesFound, topLabels, boxes;

        if (_config.halfSample) {
            (0, _cv_utils.halfSample)(_inputImageWrapper, _currentImageWrapper);
        }

        binarizeImage();
        patchesFound = findPatches();
        // return unless 5% or more patches are found
        if (patchesFound.length < _numPatches.x * _numPatches.y * 0.05) {
            return null;
        }

        // rasterrize area by comparing angular similarity;
        var maxLabel = rasterizeAngularSimilarity(patchesFound);
        if (maxLabel < 1) {
            return null;
        }

        // search for area with the most patches (biggest connected area)
        topLabels = findBiggestConnectedAreas(maxLabel);
        if (topLabels.length === 0) {
            return null;
        }

        boxes = findBoxes(topLabels, maxLabel);
        return boxes;
    },

    checkImageConstraints: function checkImageConstraints(inputStream, config) {
        var patchSize,
            width = inputStream.getWidth(),
            height = inputStream.getHeight(),
            halfSample = config.halfSample ? 0.5 : 1,
            size,
            area;

        // calculate width and height based on area
        if (inputStream.getConfig().area) {
            area = (0, _cv_utils.computeImageArea)(width, height, inputStream.getConfig().area);
            inputStream.setTopRight({ x: area.sx, y: area.sy });
            inputStream.setCanvasSize({ x: width, y: height });
            width = area.sw;
            height = area.sh;
        }

        size = {
            x: Math.floor(width * halfSample),
            y: Math.floor(height * halfSample)
        };

        patchSize = (0, _cv_utils.calculatePatchSize)(config.patchSize, size);
        if (false) {
            console.log("Patch-Size: " + JSON.stringify(patchSize));
        }

        inputStream.setWidth(Math.floor(Math.floor(size.x / patchSize.x) * (1 / halfSample) * patchSize.x));
        inputStream.setHeight(Math.floor(Math.floor(size.y / patchSize.y) * (1 / halfSample) * patchSize.y));

        if (inputStream.getWidth() % patchSize.x === 0 && inputStream.getHeight() % patchSize.y === 0) {
            return true;
        }

        throw new Error("Image dimensions do not comply with the current settings: Width (" + width + " )and height (" + height + ") must a multiple of " + patchSize.x);
    }
};
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(47)))

/***/ }),
/* 63 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _tracer = __webpack_require__(30);

var _tracer2 = _interopRequireDefault(_tracer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * http://www.codeproject.com/Tips/407172/Connected-Component-Labeling-and-Vectorization
 */
var Rasterizer = {
    createContour2D: function createContour2D() {
        return {
            dir: null,
            index: null,
            firstVertex: null,
            insideContours: null,
            nextpeer: null,
            prevpeer: null
        };
    },
    CONTOUR_DIR: {
        CW_DIR: 0,
        CCW_DIR: 1,
        UNKNOWN_DIR: 2
    },
    DIR: {
        OUTSIDE_EDGE: -32767,
        INSIDE_EDGE: -32766
    },
    create: function create(imageWrapper, labelWrapper) {
        var imageData = imageWrapper.data,
            labelData = labelWrapper.data,
            width = imageWrapper.size.x,
            height = imageWrapper.size.y,
            tracer = _tracer2.default.create(imageWrapper, labelWrapper);

        return {
            rasterize: function rasterize(depthlabel) {
                var color,
                    bc,
                    lc,
                    labelindex,
                    cx,
                    cy,
                    colorMap = [],
                    vertex,
                    p,
                    cc,
                    sc,
                    pos,
                    connectedCount = 0,
                    i;

                for (i = 0; i < 400; i++) {
                    colorMap[i] = 0;
                }

                colorMap[0] = imageData[0];
                cc = null;
                for (cy = 1; cy < height - 1; cy++) {
                    labelindex = 0;
                    bc = colorMap[0];
                    for (cx = 1; cx < width - 1; cx++) {
                        pos = cy * width + cx;
                        if (labelData[pos] === 0) {
                            color = imageData[pos];
                            if (color !== bc) {
                                if (labelindex === 0) {
                                    lc = connectedCount + 1;
                                    colorMap[lc] = color;
                                    bc = color;
                                    vertex = tracer.contourTracing(cy, cx, lc, color, Rasterizer.DIR.OUTSIDE_EDGE);
                                    if (vertex !== null) {
                                        connectedCount++;
                                        labelindex = lc;
                                        p = Rasterizer.createContour2D();
                                        p.dir = Rasterizer.CONTOUR_DIR.CW_DIR;
                                        p.index = labelindex;
                                        p.firstVertex = vertex;
                                        p.nextpeer = cc;
                                        p.insideContours = null;
                                        if (cc !== null) {
                                            cc.prevpeer = p;
                                        }
                                        cc = p;
                                    }
                                } else {
                                    vertex = tracer.contourTracing(cy, cx, Rasterizer.DIR.INSIDE_EDGE, color, labelindex);
                                    if (vertex !== null) {
                                        p = Rasterizer.createContour2D();
                                        p.firstVertex = vertex;
                                        p.insideContours = null;
                                        if (depthlabel === 0) {
                                            p.dir = Rasterizer.CONTOUR_DIR.CCW_DIR;
                                        } else {
                                            p.dir = Rasterizer.CONTOUR_DIR.CW_DIR;
                                        }
                                        p.index = depthlabel;
                                        sc = cc;
                                        while (sc !== null && sc.index !== labelindex) {
                                            sc = sc.nextpeer;
                                        }
                                        if (sc !== null) {
                                            p.nextpeer = sc.insideContours;
                                            if (sc.insideContours !== null) {
                                                sc.insideContours.prevpeer = p;
                                            }
                                            sc.insideContours = p;
                                        }
                                    }
                                }
                            } else {
                                labelData[pos] = labelindex;
                            }
                        } else if (labelData[pos] === Rasterizer.DIR.OUTSIDE_EDGE || labelData[pos] === Rasterizer.DIR.INSIDE_EDGE) {
                            labelindex = 0;
                            if (labelData[pos] === Rasterizer.DIR.INSIDE_EDGE) {
                                bc = imageData[pos];
                            } else {
                                bc = colorMap[0];
                            }
                        } else {
                            labelindex = labelData[pos];
                            bc = colorMap[labelindex];
                        }
                    }
                }
                sc = cc;
                while (sc !== null) {
                    sc.index = depthlabel;
                    sc = sc.nextpeer;
                }
                return {
                    cc: cc,
                    count: connectedCount
                };
            },
            debug: {
                drawContour: function drawContour(canvas, firstContour) {
                    var ctx = canvas.getContext("2d"),
                        pq = firstContour,
                        iq,
                        q,
                        p;

                    ctx.strokeStyle = "red";
                    ctx.fillStyle = "red";
                    ctx.lineWidth = 1;

                    if (pq !== null) {
                        iq = pq.insideContours;
                    } else {
                        iq = null;
                    }

                    while (pq !== null) {
                        if (iq !== null) {
                            q = iq;
                            iq = iq.nextpeer;
                        } else {
                            q = pq;
                            pq = pq.nextpeer;
                            if (pq !== null) {
                                iq = pq.insideContours;
                            } else {
                                iq = null;
                            }
                        }

                        switch (q.dir) {
                            case Rasterizer.CONTOUR_DIR.CW_DIR:
                                ctx.strokeStyle = "red";
                                break;
                            case Rasterizer.CONTOUR_DIR.CCW_DIR:
                                ctx.strokeStyle = "blue";
                                break;
                            case Rasterizer.CONTOUR_DIR.UNKNOWN_DIR:
                                ctx.strokeStyle = "green";
                                break;
                        }

                        p = q.firstVertex;
                        ctx.beginPath();
                        ctx.moveTo(p.x, p.y);
                        do {
                            p = p.next;
                            ctx.lineTo(p.x, p.y);
                        } while (p !== q.firstVertex);
                        ctx.stroke();
                    }
                }
            }
        };
    }
};

exports.default = Rasterizer;

/***/ }),
/* 64 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;
/* @preserve ASM BEGIN */
/* eslint-disable eqeqeq*/
function Skeletonizer(stdlib, foreign, buffer) {
    "use asm";

    var images = new stdlib.Uint8Array(buffer),
        size = foreign.size | 0,
        imul = stdlib.Math.imul;

    function erode(inImagePtr, outImagePtr) {
        inImagePtr = inImagePtr | 0;
        outImagePtr = outImagePtr | 0;

        var v = 0,
            u = 0,
            sum = 0,
            yStart1 = 0,
            yStart2 = 0,
            xStart1 = 0,
            xStart2 = 0,
            offset = 0;

        for (v = 1; (v | 0) < (size - 1 | 0); v = v + 1 | 0) {
            offset = offset + size | 0;
            for (u = 1; (u | 0) < (size - 1 | 0); u = u + 1 | 0) {
                yStart1 = offset - size | 0;
                yStart2 = offset + size | 0;
                xStart1 = u - 1 | 0;
                xStart2 = u + 1 | 0;
                sum = (images[inImagePtr + yStart1 + xStart1 | 0] | 0) + (images[inImagePtr + yStart1 + xStart2 | 0] | 0) + (images[inImagePtr + offset + u | 0] | 0) + (images[inImagePtr + yStart2 + xStart1 | 0] | 0) + (images[inImagePtr + yStart2 + xStart2 | 0] | 0) | 0;
                if ((sum | 0) == (5 | 0)) {
                    images[outImagePtr + offset + u | 0] = 1;
                } else {
                    images[outImagePtr + offset + u | 0] = 0;
                }
            }
        }
        return;
    }

    function subtract(aImagePtr, bImagePtr, outImagePtr) {
        aImagePtr = aImagePtr | 0;
        bImagePtr = bImagePtr | 0;
        outImagePtr = outImagePtr | 0;

        var length = 0;

        length = imul(size, size) | 0;

        while ((length | 0) > 0) {
            length = length - 1 | 0;
            images[outImagePtr + length | 0] = (images[aImagePtr + length | 0] | 0) - (images[bImagePtr + length | 0] | 0) | 0;
        }
    }

    function bitwiseOr(aImagePtr, bImagePtr, outImagePtr) {
        aImagePtr = aImagePtr | 0;
        bImagePtr = bImagePtr | 0;
        outImagePtr = outImagePtr | 0;

        var length = 0;

        length = imul(size, size) | 0;

        while ((length | 0) > 0) {
            length = length - 1 | 0;
            images[outImagePtr + length | 0] = images[aImagePtr + length | 0] | 0 | (images[bImagePtr + length | 0] | 0) | 0;
        }
    }

    function countNonZero(imagePtr) {
        imagePtr = imagePtr | 0;

        var sum = 0,
            length = 0;

        length = imul(size, size) | 0;

        while ((length | 0) > 0) {
            length = length - 1 | 0;
            sum = (sum | 0) + (images[imagePtr + length | 0] | 0) | 0;
        }

        return sum | 0;
    }

    function init(imagePtr, value) {
        imagePtr = imagePtr | 0;
        value = value | 0;

        var length = 0;

        length = imul(size, size) | 0;

        while ((length | 0) > 0) {
            length = length - 1 | 0;
            images[imagePtr + length | 0] = value;
        }
    }

    function dilate(inImagePtr, outImagePtr) {
        inImagePtr = inImagePtr | 0;
        outImagePtr = outImagePtr | 0;

        var v = 0,
            u = 0,
            sum = 0,
            yStart1 = 0,
            yStart2 = 0,
            xStart1 = 0,
            xStart2 = 0,
            offset = 0;

        for (v = 1; (v | 0) < (size - 1 | 0); v = v + 1 | 0) {
            offset = offset + size | 0;
            for (u = 1; (u | 0) < (size - 1 | 0); u = u + 1 | 0) {
                yStart1 = offset - size | 0;
                yStart2 = offset + size | 0;
                xStart1 = u - 1 | 0;
                xStart2 = u + 1 | 0;
                sum = (images[inImagePtr + yStart1 + xStart1 | 0] | 0) + (images[inImagePtr + yStart1 + xStart2 | 0] | 0) + (images[inImagePtr + offset + u | 0] | 0) + (images[inImagePtr + yStart2 + xStart1 | 0] | 0) + (images[inImagePtr + yStart2 + xStart2 | 0] | 0) | 0;
                if ((sum | 0) > (0 | 0)) {
                    images[outImagePtr + offset + u | 0] = 1;
                } else {
                    images[outImagePtr + offset + u | 0] = 0;
                }
            }
        }
        return;
    }

    function memcpy(srcImagePtr, dstImagePtr) {
        srcImagePtr = srcImagePtr | 0;
        dstImagePtr = dstImagePtr | 0;

        var length = 0;

        length = imul(size, size) | 0;

        while ((length | 0) > 0) {
            length = length - 1 | 0;
            images[dstImagePtr + length | 0] = images[srcImagePtr + length | 0] | 0;
        }
    }

    function zeroBorder(imagePtr) {
        imagePtr = imagePtr | 0;

        var x = 0,
            y = 0;

        for (x = 0; (x | 0) < (size - 1 | 0); x = x + 1 | 0) {
            images[imagePtr + x | 0] = 0;
            images[imagePtr + y | 0] = 0;
            y = y + size - 1 | 0;
            images[imagePtr + y | 0] = 0;
            y = y + 1 | 0;
        }
        for (x = 0; (x | 0) < (size | 0); x = x + 1 | 0) {
            images[imagePtr + y | 0] = 0;
            y = y + 1 | 0;
        }
    }

    function skeletonize() {
        var subImagePtr = 0,
            erodedImagePtr = 0,
            tempImagePtr = 0,
            skelImagePtr = 0,
            sum = 0,
            done = 0;

        erodedImagePtr = imul(size, size) | 0;
        tempImagePtr = erodedImagePtr + erodedImagePtr | 0;
        skelImagePtr = tempImagePtr + erodedImagePtr | 0;

        // init skel-image
        init(skelImagePtr, 0);
        zeroBorder(subImagePtr);

        do {
            erode(subImagePtr, erodedImagePtr);
            dilate(erodedImagePtr, tempImagePtr);
            subtract(subImagePtr, tempImagePtr, tempImagePtr);
            bitwiseOr(skelImagePtr, tempImagePtr, skelImagePtr);
            memcpy(erodedImagePtr, subImagePtr);
            sum = countNonZero(subImagePtr) | 0;
            done = (sum | 0) == 0 | 0;
        } while (!done);
    }
    return {
        skeletonize: skeletonize
    };
}
/* @preserve ASM END */
exports.default = Skeletonizer;
/* eslint-enable eqeqeq*/

/***/ }),
/* 65 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _barcode_reader = __webpack_require__(1);

var _barcode_reader2 = _interopRequireDefault(_barcode_reader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function TwoOfFiveReader(opts) {
    _barcode_reader2.default.call(this, opts);
    this.barSpaceRatio = [1, 1];
}

var N = 1,
    W = 3,
    properties = {
    START_PATTERN: { value: [W, N, W, N, N, N] },
    STOP_PATTERN: { value: [W, N, N, N, W] },
    CODE_PATTERN: { value: [[N, N, W, W, N], [W, N, N, N, W], [N, W, N, N, W], [W, W, N, N, N], [N, N, W, N, W], [W, N, W, N, N], [N, W, W, N, N], [N, N, N, W, W], [W, N, N, W, N], [N, W, N, W, N]] },
    SINGLE_CODE_ERROR: { value: 0.78, writable: true },
    AVG_CODE_ERROR: { value: 0.30, writable: true },
    FORMAT: { value: "2of5" }
};

var startPatternLength = properties.START_PATTERN.value.reduce(function (sum, val) {
    return sum + val;
}, 0);

TwoOfFiveReader.prototype = Object.create(_barcode_reader2.default.prototype, properties);
TwoOfFiveReader.prototype.constructor = TwoOfFiveReader;

TwoOfFiveReader.prototype._findPattern = function (pattern, offset, isWhite, tryHarder) {
    var counter = [],
        self = this,
        i,
        counterPos = 0,
        bestMatch = {
        error: Number.MAX_VALUE,
        code: -1,
        start: 0,
        end: 0
    },
        error,
        j,
        sum,
        epsilon = self.AVG_CODE_ERROR;

    isWhite = isWhite || false;
    tryHarder = tryHarder || false;

    if (!offset) {
        offset = self._nextSet(self._row);
    }

    for (i = 0; i < pattern.length; i++) {
        counter[i] = 0;
    }

    for (i = offset; i < self._row.length; i++) {
        if (self._row[i] ^ isWhite) {
            counter[counterPos]++;
        } else {
            if (counterPos === counter.length - 1) {
                sum = 0;
                for (j = 0; j < counter.length; j++) {
                    sum += counter[j];
                }
                error = self._matchPattern(counter, pattern);
                if (error < epsilon) {
                    bestMatch.error = error;
                    bestMatch.start = i - sum;
                    bestMatch.end = i;
                    return bestMatch;
                }
                if (tryHarder) {
                    for (j = 0; j < counter.length - 2; j++) {
                        counter[j] = counter[j + 2];
                    }
                    counter[counter.length - 2] = 0;
                    counter[counter.length - 1] = 0;
                    counterPos--;
                } else {
                    return null;
                }
            } else {
                counterPos++;
            }
            counter[counterPos] = 1;
            isWhite = !isWhite;
        }
    }
    return null;
};

TwoOfFiveReader.prototype._findStart = function () {
    var self = this,
        leadingWhitespaceStart,
        offset = self._nextSet(self._row),
        startInfo,
        narrowBarWidth = 1;

    while (!startInfo) {
        startInfo = self._findPattern(self.START_PATTERN, offset, false, true);
        if (!startInfo) {
            return null;
        }
        narrowBarWidth = Math.floor((startInfo.end - startInfo.start) / startPatternLength);
        leadingWhitespaceStart = startInfo.start - narrowBarWidth * 5;
        if (leadingWhitespaceStart >= 0) {
            if (self._matchRange(leadingWhitespaceStart, startInfo.start, 0)) {
                return startInfo;
            }
        }
        offset = startInfo.end;
        startInfo = null;
    }
};

TwoOfFiveReader.prototype._verifyTrailingWhitespace = function (endInfo) {
    var self = this,
        trailingWhitespaceEnd;

    trailingWhitespaceEnd = endInfo.end + (endInfo.end - endInfo.start) / 2;
    if (trailingWhitespaceEnd < self._row.length) {
        if (self._matchRange(endInfo.end, trailingWhitespaceEnd, 0)) {
            return endInfo;
        }
    }
    return null;
};

TwoOfFiveReader.prototype._findEnd = function () {
    var self = this,
        endInfo,
        tmp,
        offset;

    self._row.reverse();
    offset = self._nextSet(self._row);
    endInfo = self._findPattern(self.STOP_PATTERN, offset, false, true);
    self._row.reverse();

    if (endInfo === null) {
        return null;
    }

    // reverse numbers
    tmp = endInfo.start;
    endInfo.start = self._row.length - endInfo.end;
    endInfo.end = self._row.length - tmp;

    return endInfo !== null ? self._verifyTrailingWhitespace(endInfo) : null;
};

TwoOfFiveReader.prototype._decodeCode = function (counter) {
    var j,
        self = this,
        sum = 0,
        normalized,
        error,
        epsilon = self.AVG_CODE_ERROR,
        code,
        bestMatch = {
        error: Number.MAX_VALUE,
        code: -1,
        start: 0,
        end: 0
    };

    for (j = 0; j < counter.length; j++) {
        sum += counter[j];
    }
    for (code = 0; code < self.CODE_PATTERN.length; code++) {
        error = self._matchPattern(counter, self.CODE_PATTERN[code]);
        if (error < bestMatch.error) {
            bestMatch.code = code;
            bestMatch.error = error;
        }
    }
    if (bestMatch.error < epsilon) {
        return bestMatch;
    }
};

TwoOfFiveReader.prototype._decodePayload = function (counters, result, decodedCodes) {
    var i,
        self = this,
        pos = 0,
        counterLength = counters.length,
        counter = [0, 0, 0, 0, 0],
        code;

    while (pos < counterLength) {
        for (i = 0; i < 5; i++) {
            counter[i] = counters[pos] * this.barSpaceRatio[0];
            pos += 2;
        }
        code = self._decodeCode(counter);
        if (!code) {
            return null;
        }
        result.push(code.code + "");
        decodedCodes.push(code);
    }
    return code;
};

TwoOfFiveReader.prototype._verifyCounterLength = function (counters) {
    return counters.length % 10 === 0;
};

TwoOfFiveReader.prototype._decode = function () {
    var startInfo,
        endInfo,
        self = this,
        code,
        result = [],
        decodedCodes = [],
        counters;

    startInfo = self._findStart();
    if (!startInfo) {
        return null;
    }
    decodedCodes.push(startInfo);

    endInfo = self._findEnd();
    if (!endInfo) {
        return null;
    }

    counters = self._fillCounters(startInfo.end, endInfo.start, false);
    if (!self._verifyCounterLength(counters)) {
        return null;
    }
    code = self._decodePayload(counters, result, decodedCodes);
    if (!code) {
        return null;
    }
    if (result.length < 5) {
        return null;
    }

    decodedCodes.push(endInfo);
    return {
        code: result.join(""),
        start: startInfo.start,
        end: endInfo.end,
        startInfo: startInfo,
        decodedCodes: decodedCodes
    };
};

exports.default = TwoOfFiveReader;

/***/ }),
/* 66 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _barcode_reader = __webpack_require__(1);

var _barcode_reader2 = _interopRequireDefault(_barcode_reader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function CodabarReader() {
    _barcode_reader2.default.call(this);
    this._counters = [];
}

var properties = {
    ALPHABETH_STRING: { value: "0123456789-$:/.+ABCD" },
    ALPHABET: { value: [48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 36, 58, 47, 46, 43, 65, 66, 67, 68] },
    CHARACTER_ENCODINGS: { value: [0x003, 0x006, 0x009, 0x060, 0x012, 0x042, 0x021, 0x024, 0x030, 0x048, 0x00c, 0x018, 0x045, 0x051, 0x054, 0x015, 0x01A, 0x029, 0x00B, 0x00E] },
    START_END: { value: [0x01A, 0x029, 0x00B, 0x00E] },
    MIN_ENCODED_CHARS: { value: 4 },
    MAX_ACCEPTABLE: { value: 2.0 },
    PADDING: { value: 1.5 },
    FORMAT: { value: "codabar", writeable: false }
};

CodabarReader.prototype = Object.create(_barcode_reader2.default.prototype, properties);
CodabarReader.prototype.constructor = CodabarReader;

CodabarReader.prototype._decode = function () {
    var self = this,
        result = [],
        start,
        decodedChar,
        pattern,
        nextStart,
        end;

    this._counters = self._fillCounters();
    start = self._findStart();
    if (!start) {
        return null;
    }
    nextStart = start.startCounter;

    do {
        pattern = self._toPattern(nextStart);
        if (pattern < 0) {
            return null;
        }
        decodedChar = self._patternToChar(pattern);
        if (decodedChar < 0) {
            return null;
        }
        result.push(decodedChar);
        nextStart += 8;
        if (result.length > 1 && self._isStartEnd(pattern)) {
            break;
        }
    } while (nextStart < self._counters.length);

    // verify end
    if (result.length - 2 < self.MIN_ENCODED_CHARS || !self._isStartEnd(pattern)) {
        return null;
    }

    // verify end white space
    if (!self._verifyWhitespace(start.startCounter, nextStart - 8)) {
        return null;
    }

    if (!self._validateResult(result, start.startCounter)) {
        return null;
    }

    nextStart = nextStart > self._counters.length ? self._counters.length : nextStart;
    end = start.start + self._sumCounters(start.startCounter, nextStart - 8);

    return {
        code: result.join(""),
        start: start.start,
        end: end,
        startInfo: start,
        decodedCodes: result
    };
};

CodabarReader.prototype._verifyWhitespace = function (startCounter, endCounter) {
    if (startCounter - 1 <= 0 || this._counters[startCounter - 1] >= this._calculatePatternLength(startCounter) / 2.0) {
        if (endCounter + 8 >= this._counters.length || this._counters[endCounter + 7] >= this._calculatePatternLength(endCounter) / 2.0) {
            return true;
        }
    }
    return false;
};

CodabarReader.prototype._calculatePatternLength = function (offset) {
    var i,
        sum = 0;

    for (i = offset; i < offset + 7; i++) {
        sum += this._counters[i];
    }

    return sum;
};

CodabarReader.prototype._thresholdResultPattern = function (result, startCounter) {
    var self = this,
        categorization = {
        space: {
            narrow: { size: 0, counts: 0, min: 0, max: Number.MAX_VALUE },
            wide: { size: 0, counts: 0, min: 0, max: Number.MAX_VALUE }
        },
        bar: {
            narrow: { size: 0, counts: 0, min: 0, max: Number.MAX_VALUE },
            wide: { size: 0, counts: 0, min: 0, max: Number.MAX_VALUE }
        }
    },
        kind,
        cat,
        i,
        j,
        pos = startCounter,
        pattern;

    for (i = 0; i < result.length; i++) {
        pattern = self._charToPattern(result[i]);
        for (j = 6; j >= 0; j--) {
            kind = (j & 1) === 2 ? categorization.bar : categorization.space;
            cat = (pattern & 1) === 1 ? kind.wide : kind.narrow;
            cat.size += self._counters[pos + j];
            cat.counts++;
            pattern >>= 1;
        }
        pos += 8;
    }

    ["space", "bar"].forEach(function (key) {
        var newkind = categorization[key];
        newkind.wide.min = Math.floor((newkind.narrow.size / newkind.narrow.counts + newkind.wide.size / newkind.wide.counts) / 2);
        newkind.narrow.max = Math.ceil(newkind.wide.min);
        newkind.wide.max = Math.ceil((newkind.wide.size * self.MAX_ACCEPTABLE + self.PADDING) / newkind.wide.counts);
    });

    return categorization;
};

CodabarReader.prototype._charToPattern = function (char) {
    var self = this,
        charCode = char.charCodeAt(0),
        i;

    for (i = 0; i < self.ALPHABET.length; i++) {
        if (self.ALPHABET[i] === charCode) {
            return self.CHARACTER_ENCODINGS[i];
        }
    }
    return 0x0;
};

CodabarReader.prototype._validateResult = function (result, startCounter) {
    var self = this,
        thresholds = self._thresholdResultPattern(result, startCounter),
        i,
        j,
        kind,
        cat,
        size,
        pos = startCounter,
        pattern;

    for (i = 0; i < result.length; i++) {
        pattern = self._charToPattern(result[i]);
        for (j = 6; j >= 0; j--) {
            kind = (j & 1) === 0 ? thresholds.bar : thresholds.space;
            cat = (pattern & 1) === 1 ? kind.wide : kind.narrow;
            size = self._counters[pos + j];
            if (size < cat.min || size > cat.max) {
                return false;
            }
            pattern >>= 1;
        }
        pos += 8;
    }
    return true;
};

CodabarReader.prototype._patternToChar = function (pattern) {
    var i,
        self = this;

    for (i = 0; i < self.CHARACTER_ENCODINGS.length; i++) {
        if (self.CHARACTER_ENCODINGS[i] === pattern) {
            return String.fromCharCode(self.ALPHABET[i]);
        }
    }
    return -1;
};

CodabarReader.prototype._computeAlternatingThreshold = function (offset, end) {
    var i,
        min = Number.MAX_VALUE,
        max = 0,
        counter;

    for (i = offset; i < end; i += 2) {
        counter = this._counters[i];
        if (counter > max) {
            max = counter;
        }
        if (counter < min) {
            min = counter;
        }
    }

    return (min + max) / 2.0 | 0;
};

CodabarReader.prototype._toPattern = function (offset) {
    var numCounters = 7,
        end = offset + numCounters,
        barThreshold,
        spaceThreshold,
        bitmask = 1 << numCounters - 1,
        pattern = 0,
        i,
        threshold;

    if (end > this._counters.length) {
        return -1;
    }

    barThreshold = this._computeAlternatingThreshold(offset, end);
    spaceThreshold = this._computeAlternatingThreshold(offset + 1, end);

    for (i = 0; i < numCounters; i++) {
        threshold = (i & 1) === 0 ? barThreshold : spaceThreshold;
        if (this._counters[offset + i] > threshold) {
            pattern |= bitmask;
        }
        bitmask >>= 1;
    }

    return pattern;
};

CodabarReader.prototype._isStartEnd = function (pattern) {
    var i;

    for (i = 0; i < this.START_END.length; i++) {
        if (this.START_END[i] === pattern) {
            return true;
        }
    }
    return false;
};

CodabarReader.prototype._sumCounters = function (start, end) {
    var i,
        sum = 0;

    for (i = start; i < end; i++) {
        sum += this._counters[i];
    }
    return sum;
};

CodabarReader.prototype._findStart = function () {
    var self = this,
        i,
        pattern,
        start = self._nextUnset(self._row),
        end;

    for (i = 1; i < this._counters.length; i++) {
        pattern = self._toPattern(i);
        if (pattern !== -1 && self._isStartEnd(pattern)) {
            // TODO: Look for whitespace ahead
            start += self._sumCounters(0, i);
            end = start + self._sumCounters(i, i + 8);
            return {
                start: start,
                end: end,
                startCounter: i,
                endCounter: i + 8
            };
        }
    }
};

exports.default = CodabarReader;

/***/ }),
/* 67 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _barcode_reader = __webpack_require__(1);

var _barcode_reader2 = _interopRequireDefault(_barcode_reader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function Code128Reader() {
    _barcode_reader2.default.call(this);
}

var properties = {
    CODE_SHIFT: { value: 98 },
    CODE_C: { value: 99 },
    CODE_B: { value: 100 },
    CODE_A: { value: 101 },
    START_CODE_A: { value: 103 },
    START_CODE_B: { value: 104 },
    START_CODE_C: { value: 105 },
    STOP_CODE: { value: 106 },
    CODE_PATTERN: { value: [[2, 1, 2, 2, 2, 2], [2, 2, 2, 1, 2, 2], [2, 2, 2, 2, 2, 1], [1, 2, 1, 2, 2, 3], [1, 2, 1, 3, 2, 2], [1, 3, 1, 2, 2, 2], [1, 2, 2, 2, 1, 3], [1, 2, 2, 3, 1, 2], [1, 3, 2, 2, 1, 2], [2, 2, 1, 2, 1, 3], [2, 2, 1, 3, 1, 2], [2, 3, 1, 2, 1, 2], [1, 1, 2, 2, 3, 2], [1, 2, 2, 1, 3, 2], [1, 2, 2, 2, 3, 1], [1, 1, 3, 2, 2, 2], [1, 2, 3, 1, 2, 2], [1, 2, 3, 2, 2, 1], [2, 2, 3, 2, 1, 1], [2, 2, 1, 1, 3, 2], [2, 2, 1, 2, 3, 1], [2, 1, 3, 2, 1, 2], [2, 2, 3, 1, 1, 2], [3, 1, 2, 1, 3, 1], [3, 1, 1, 2, 2, 2], [3, 2, 1, 1, 2, 2], [3, 2, 1, 2, 2, 1], [3, 1, 2, 2, 1, 2], [3, 2, 2, 1, 1, 2], [3, 2, 2, 2, 1, 1], [2, 1, 2, 1, 2, 3], [2, 1, 2, 3, 2, 1], [2, 3, 2, 1, 2, 1], [1, 1, 1, 3, 2, 3], [1, 3, 1, 1, 2, 3], [1, 3, 1, 3, 2, 1], [1, 1, 2, 3, 1, 3], [1, 3, 2, 1, 1, 3], [1, 3, 2, 3, 1, 1], [2, 1, 1, 3, 1, 3], [2, 3, 1, 1, 1, 3], [2, 3, 1, 3, 1, 1], [1, 1, 2, 1, 3, 3], [1, 1, 2, 3, 3, 1], [1, 3, 2, 1, 3, 1], [1, 1, 3, 1, 2, 3], [1, 1, 3, 3, 2, 1], [1, 3, 3, 1, 2, 1], [3, 1, 3, 1, 2, 1], [2, 1, 1, 3, 3, 1], [2, 3, 1, 1, 3, 1], [2, 1, 3, 1, 1, 3], [2, 1, 3, 3, 1, 1], [2, 1, 3, 1, 3, 1], [3, 1, 1, 1, 2, 3], [3, 1, 1, 3, 2, 1], [3, 3, 1, 1, 2, 1], [3, 1, 2, 1, 1, 3], [3, 1, 2, 3, 1, 1], [3, 3, 2, 1, 1, 1], [3, 1, 4, 1, 1, 1], [2, 2, 1, 4, 1, 1], [4, 3, 1, 1, 1, 1], [1, 1, 1, 2, 2, 4], [1, 1, 1, 4, 2, 2], [1, 2, 1, 1, 2, 4], [1, 2, 1, 4, 2, 1], [1, 4, 1, 1, 2, 2], [1, 4, 1, 2, 2, 1], [1, 1, 2, 2, 1, 4], [1, 1, 2, 4, 1, 2], [1, 2, 2, 1, 1, 4], [1, 2, 2, 4, 1, 1], [1, 4, 2, 1, 1, 2], [1, 4, 2, 2, 1, 1], [2, 4, 1, 2, 1, 1], [2, 2, 1, 1, 1, 4], [4, 1, 3, 1, 1, 1], [2, 4, 1, 1, 1, 2], [1, 3, 4, 1, 1, 1], [1, 1, 1, 2, 4, 2], [1, 2, 1, 1, 4, 2], [1, 2, 1, 2, 4, 1], [1, 1, 4, 2, 1, 2], [1, 2, 4, 1, 1, 2], [1, 2, 4, 2, 1, 1], [4, 1, 1, 2, 1, 2], [4, 2, 1, 1, 1, 2], [4, 2, 1, 2, 1, 1], [2, 1, 2, 1, 4, 1], [2, 1, 4, 1, 2, 1], [4, 1, 2, 1, 2, 1], [1, 1, 1, 1, 4, 3], [1, 1, 1, 3, 4, 1], [1, 3, 1, 1, 4, 1], [1, 1, 4, 1, 1, 3], [1, 1, 4, 3, 1, 1], [4, 1, 1, 1, 1, 3], [4, 1, 1, 3, 1, 1], [1, 1, 3, 1, 4, 1], [1, 1, 4, 1, 3, 1], [3, 1, 1, 1, 4, 1], [4, 1, 1, 1, 3, 1], [2, 1, 1, 4, 1, 2], [2, 1, 1, 2, 1, 4], [2, 1, 1, 2, 3, 2], [2, 3, 3, 1, 1, 1, 2]] },
    SINGLE_CODE_ERROR: { value: 0.64 },
    AVG_CODE_ERROR: { value: 0.30 },
    FORMAT: { value: "code_128", writeable: false },
    MODULE_INDICES: { value: { bar: [0, 2, 4], space: [1, 3, 5] } }
};

Code128Reader.prototype = Object.create(_barcode_reader2.default.prototype, properties);
Code128Reader.prototype.constructor = Code128Reader;

Code128Reader.prototype._decodeCode = function (start, correction) {
    var counter = [0, 0, 0, 0, 0, 0],
        i,
        self = this,
        offset = start,
        isWhite = !self._row[offset],
        counterPos = 0,
        bestMatch = {
        error: Number.MAX_VALUE,
        code: -1,
        start: start,
        end: start,
        correction: {
            bar: 1,
            space: 1
        }
    },
        code,
        error;

    for (i = offset; i < self._row.length; i++) {
        if (self._row[i] ^ isWhite) {
            counter[counterPos]++;
        } else {
            if (counterPos === counter.length - 1) {
                if (correction) {
                    self._correct(counter, correction);
                }
                for (code = 0; code < self.CODE_PATTERN.length; code++) {
                    error = self._matchPattern(counter, self.CODE_PATTERN[code]);
                    if (error < bestMatch.error) {
                        bestMatch.code = code;
                        bestMatch.error = error;
                    }
                }
                bestMatch.end = i;
                if (bestMatch.code === -1 || bestMatch.error > self.AVG_CODE_ERROR) {
                    return null;
                }
                if (self.CODE_PATTERN[bestMatch.code]) {
                    bestMatch.correction.bar = calculateCorrection(self.CODE_PATTERN[bestMatch.code], counter, this.MODULE_INDICES.bar);
                    bestMatch.correction.space = calculateCorrection(self.CODE_PATTERN[bestMatch.code], counter, this.MODULE_INDICES.space);
                }
                return bestMatch;
            } else {
                counterPos++;
            }
            counter[counterPos] = 1;
            isWhite = !isWhite;
        }
    }
    return null;
};

Code128Reader.prototype._correct = function (counter, correction) {
    this._correctBars(counter, correction.bar, this.MODULE_INDICES.bar);
    this._correctBars(counter, correction.space, this.MODULE_INDICES.space);
};

Code128Reader.prototype._findStart = function () {
    var counter = [0, 0, 0, 0, 0, 0],
        i,
        self = this,
        offset = self._nextSet(self._row),
        isWhite = false,
        counterPos = 0,
        bestMatch = {
        error: Number.MAX_VALUE,
        code: -1,
        start: 0,
        end: 0,
        correction: {
            bar: 1,
            space: 1
        }
    },
        code,
        error,
        j,
        sum;

    for (i = offset; i < self._row.length; i++) {
        if (self._row[i] ^ isWhite) {
            counter[counterPos]++;
        } else {
            if (counterPos === counter.length - 1) {
                sum = 0;
                for (j = 0; j < counter.length; j++) {
                    sum += counter[j];
                }
                for (code = self.START_CODE_A; code <= self.START_CODE_C; code++) {
                    error = self._matchPattern(counter, self.CODE_PATTERN[code]);
                    if (error < bestMatch.error) {
                        bestMatch.code = code;
                        bestMatch.error = error;
                    }
                }
                if (bestMatch.error < self.AVG_CODE_ERROR) {
                    bestMatch.start = i - sum;
                    bestMatch.end = i;
                    bestMatch.correction.bar = calculateCorrection(self.CODE_PATTERN[bestMatch.code], counter, this.MODULE_INDICES.bar);
                    bestMatch.correction.space = calculateCorrection(self.CODE_PATTERN[bestMatch.code], counter, this.MODULE_INDICES.space);
                    return bestMatch;
                }

                for (j = 0; j < 4; j++) {
                    counter[j] = counter[j + 2];
                }
                counter[4] = 0;
                counter[5] = 0;
                counterPos--;
            } else {
                counterPos++;
            }
            counter[counterPos] = 1;
            isWhite = !isWhite;
        }
    }
    return null;
};

Code128Reader.prototype._decode = function () {
    var self = this,
        startInfo = self._findStart(),
        code = null,
        done = false,
        result = [],
        multiplier = 0,
        checksum = 0,
        codeset,
        rawResult = [],
        decodedCodes = [],
        shiftNext = false,
        unshift,
        removeLastCharacter = true;

    if (startInfo === null) {
        return null;
    }
    code = {
        code: startInfo.code,
        start: startInfo.start,
        end: startInfo.end,
        correction: {
            bar: startInfo.correction.bar,
            space: startInfo.correction.space
        }
    };
    decodedCodes.push(code);
    checksum = code.code;
    switch (code.code) {
        case self.START_CODE_A:
            codeset = self.CODE_A;
            break;
        case self.START_CODE_B:
            codeset = self.CODE_B;
            break;
        case self.START_CODE_C:
            codeset = self.CODE_C;
            break;
        default:
            return null;
    }

    while (!done) {
        unshift = shiftNext;
        shiftNext = false;
        code = self._decodeCode(code.end, code.correction);
        if (code !== null) {
            if (code.code !== self.STOP_CODE) {
                removeLastCharacter = true;
            }

            if (code.code !== self.STOP_CODE) {
                rawResult.push(code.code);
                multiplier++;
                checksum += multiplier * code.code;
            }
            decodedCodes.push(code);

            switch (codeset) {
                case self.CODE_A:
                    if (code.code < 64) {
                        result.push(String.fromCharCode(32 + code.code));
                    } else if (code.code < 96) {
                        result.push(String.fromCharCode(code.code - 64));
                    } else {
                        if (code.code !== self.STOP_CODE) {
                            removeLastCharacter = false;
                        }
                        switch (code.code) {
                            case self.CODE_SHIFT:
                                shiftNext = true;
                                codeset = self.CODE_B;
                                break;
                            case self.CODE_B:
                                codeset = self.CODE_B;
                                break;
                            case self.CODE_C:
                                codeset = self.CODE_C;
                                break;
                            case self.STOP_CODE:
                                done = true;
                                break;
                        }
                    }
                    break;
                case self.CODE_B:
                    if (code.code < 96) {
                        result.push(String.fromCharCode(32 + code.code));
                    } else {
                        if (code.code !== self.STOP_CODE) {
                            removeLastCharacter = false;
                        }
                        switch (code.code) {
                            case self.CODE_SHIFT:
                                shiftNext = true;
                                codeset = self.CODE_A;
                                break;
                            case self.CODE_A:
                                codeset = self.CODE_A;
                                break;
                            case self.CODE_C:
                                codeset = self.CODE_C;
                                break;
                            case self.STOP_CODE:
                                done = true;
                                break;
                        }
                    }
                    break;
                case self.CODE_C:
                    if (code.code < 100) {
                        result.push(code.code < 10 ? "0" + code.code : code.code);
                    } else {
                        if (code.code !== self.STOP_CODE) {
                            removeLastCharacter = false;
                        }
                        switch (code.code) {
                            case self.CODE_A:
                                codeset = self.CODE_A;
                                break;
                            case self.CODE_B:
                                codeset = self.CODE_B;
                                break;
                            case self.STOP_CODE:
                                done = true;
                                break;
                        }
                    }
                    break;
            }
        } else {
            done = true;
        }
        if (unshift) {
            codeset = codeset === self.CODE_A ? self.CODE_B : self.CODE_A;
        }
    }

    if (code === null) {
        return null;
    }

    code.end = self._nextUnset(self._row, code.end);
    if (!self._verifyTrailingWhitespace(code)) {
        return null;
    }

    checksum -= multiplier * rawResult[rawResult.length - 1];
    if (checksum % 103 !== rawResult[rawResult.length - 1]) {
        return null;
    }

    if (!result.length) {
        return null;
    }

    // remove last code from result (checksum)
    if (removeLastCharacter) {
        result.splice(result.length - 1, 1);
    }

    return {
        code: result.join(""),
        start: startInfo.start,
        end: code.end,
        codeset: codeset,
        startInfo: startInfo,
        decodedCodes: decodedCodes,
        endInfo: code
    };
};

_barcode_reader2.default.prototype._verifyTrailingWhitespace = function (endInfo) {
    var self = this,
        trailingWhitespaceEnd;

    trailingWhitespaceEnd = endInfo.end + (endInfo.end - endInfo.start) / 2;
    if (trailingWhitespaceEnd < self._row.length) {
        if (self._matchRange(endInfo.end, trailingWhitespaceEnd, 0)) {
            return endInfo;
        }
    }
    return null;
};

function calculateCorrection(expected, normalized, indices) {
    var length = indices.length,
        sumNormalized = 0,
        sumExpected = 0;

    while (length--) {
        sumExpected += expected[indices[length]];
        sumNormalized += normalized[indices[length]];
    }
    return sumExpected / sumNormalized;
}

exports.default = Code128Reader;

/***/ }),
/* 68 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _code_39_reader = __webpack_require__(31);

var _code_39_reader2 = _interopRequireDefault(_code_39_reader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function Code39VINReader() {
    _code_39_reader2.default.call(this);
}

var patterns = {
    IOQ: /[IOQ]/g,
    AZ09: /[A-Z0-9]{17}/
};

Code39VINReader.prototype = Object.create(_code_39_reader2.default.prototype);
Code39VINReader.prototype.constructor = Code39VINReader;

// Cribbed from:
// https://github.com/zxing/zxing/blob/master/core/src/main/java/com/google/zxing/client/result/VINResultParser.java
Code39VINReader.prototype._decode = function () {
    var result = _code_39_reader2.default.prototype._decode.apply(this);
    if (!result) {
        return null;
    }

    var code = result.code;

    if (!code) {
        return null;
    }

    code = code.replace(patterns.IOQ, '');

    if (!code.match(patterns.AZ09)) {
        if (false) {
            console.log('Failed AZ09 pattern code:', code);
        }
        return null;
    }

    if (!this._checkChecksum(code)) {
        return null;
    }

    result.code = code;
    return result;
};

Code39VINReader.prototype._checkChecksum = function (code) {
    // TODO
    return !!code;
};

exports.default = Code39VINReader;

/***/ }),
/* 69 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _barcode_reader = __webpack_require__(1);

var _barcode_reader2 = _interopRequireDefault(_barcode_reader);

var _array_helper = __webpack_require__(3);

var _array_helper2 = _interopRequireDefault(_array_helper);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function Code93Reader() {
    _barcode_reader2.default.call(this);
}

var ALPHABETH_STRING = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*";

var properties = {
    ALPHABETH_STRING: { value: ALPHABETH_STRING },
    ALPHABET: { value: ALPHABETH_STRING.split('').map(function (char) {
            return char.charCodeAt(0);
        }) },
    CHARACTER_ENCODINGS: { value: [0x114, 0x148, 0x144, 0x142, 0x128, 0x124, 0x122, 0x150, 0x112, 0x10A, 0x1A8, 0x1A4, 0x1A2, 0x194, 0x192, 0x18A, 0x168, 0x164, 0x162, 0x134, 0x11A, 0x158, 0x14C, 0x146, 0x12C, 0x116, 0x1B4, 0x1B2, 0x1AC, 0x1A6, 0x196, 0x19A, 0x16C, 0x166, 0x136, 0x13A, 0x12E, 0x1D4, 0x1D2, 0x1CA, 0x16E, 0x176, 0x1AE, 0x126, 0x1DA, 0x1D6, 0x132, 0x15E] },
    ASTERISK: { value: 0x15E },
    FORMAT: { value: "code_93", writeable: false }
};

Code93Reader.prototype = Object.create(_barcode_reader2.default.prototype, properties);
Code93Reader.prototype.constructor = Code93Reader;

Code93Reader.prototype._decode = function () {
    var self = this,
        counters = [0, 0, 0, 0, 0, 0],
        result = [],
        start = self._findStart(),
        decodedChar,
        lastStart,
        pattern,
        nextStart;

    if (!start) {
        return null;
    }
    nextStart = self._nextSet(self._row, start.end);

    do {
        counters = self._toCounters(nextStart, counters);
        pattern = self._toPattern(counters);
        if (pattern < 0) {
            return null;
        }
        decodedChar = self._patternToChar(pattern);
        if (decodedChar < 0) {
            return null;
        }
        result.push(decodedChar);
        lastStart = nextStart;
        nextStart += _array_helper2.default.sum(counters);
        nextStart = self._nextSet(self._row, nextStart);
    } while (decodedChar !== '*');
    result.pop();

    if (!result.length) {
        return null;
    }

    if (!self._verifyEnd(lastStart, nextStart, counters)) {
        return null;
    }

    if (!self._verifyChecksums(result)) {
        return null;
    }

    result = result.slice(0, result.length - 2);
    if ((result = self._decodeExtended(result)) === null) {
        return null;
    };

    return {
        code: result.join(""),
        start: start.start,
        end: nextStart,
        startInfo: start,
        decodedCodes: result
    };
};

Code93Reader.prototype._verifyEnd = function (lastStart, nextStart) {
    if (lastStart === nextStart || !this._row[nextStart]) {
        return false;
    }
    return true;
};

Code93Reader.prototype._patternToChar = function (pattern) {
    var i,
        self = this;

    for (i = 0; i < self.CHARACTER_ENCODINGS.length; i++) {
        if (self.CHARACTER_ENCODINGS[i] === pattern) {
            return String.fromCharCode(self.ALPHABET[i]);
        }
    }
    return -1;
};

Code93Reader.prototype._toPattern = function (counters) {
    var numCounters = counters.length;
    var pattern = 0;
    var sum = 0;
    for (var i = 0; i < numCounters; i++) {
        sum += counters[i];
    }

    for (var _i = 0; _i < numCounters; _i++) {
        var normalized = Math.round(counters[_i] * 9 / sum);
        if (normalized < 1 || normalized > 4) {
            return -1;
        }
        if ((_i & 1) === 0) {
            for (var j = 0; j < normalized; j++) {
                pattern = pattern << 1 | 1;
            }
        } else {
            pattern <<= normalized;
        }
    }

    return pattern;
};

Code93Reader.prototype._findStart = function () {
    var self = this,
        offset = self._nextSet(self._row),
        patternStart = offset,
        counter = [0, 0, 0, 0, 0, 0],
        counterPos = 0,
        isWhite = false,
        i,
        j,
        whiteSpaceMustStart;

    for (i = offset; i < self._row.length; i++) {
        if (self._row[i] ^ isWhite) {
            counter[counterPos]++;
        } else {
            if (counterPos === counter.length - 1) {
                // find start pattern
                if (self._toPattern(counter) === self.ASTERISK) {
                    whiteSpaceMustStart = Math.floor(Math.max(0, patternStart - (i - patternStart) / 4));
                    if (self._matchRange(whiteSpaceMustStart, patternStart, 0)) {
                        return {
                            start: patternStart,
                            end: i
                        };
                    }
                }

                patternStart += counter[0] + counter[1];
                for (j = 0; j < 4; j++) {
                    counter[j] = counter[j + 2];
                }
                counter[4] = 0;
                counter[5] = 0;
                counterPos--;
            } else {
                counterPos++;
            }
            counter[counterPos] = 1;
            isWhite = !isWhite;
        }
    }
    return null;
};

Code93Reader.prototype._decodeExtended = function (charArray) {
    var length = charArray.length;
    var result = [];
    for (var i = 0; i < length; i++) {
        var char = charArray[i];
        if (char >= 'a' && char <= 'd') {
            if (i > length - 2) {
                return null;
            }
            var nextChar = charArray[++i];
            var nextCharCode = nextChar.charCodeAt(0);
            var decodedChar = void 0;
            switch (char) {
                case 'a':
                    if (nextChar >= 'A' && nextChar <= 'Z') {
                        decodedChar = String.fromCharCode(nextCharCode - 64);
                    } else {
                        return null;
                    }
                    break;
                case 'b':
                    if (nextChar >= 'A' && nextChar <= 'E') {
                        decodedChar = String.fromCharCode(nextCharCode - 38);
                    } else if (nextChar >= 'F' && nextChar <= 'J') {
                        decodedChar = String.fromCharCode(nextCharCode - 11);
                    } else if (nextChar >= 'K' && nextChar <= 'O') {
                        decodedChar = String.fromCharCode(nextCharCode + 16);
                    } else if (nextChar >= 'P' && nextChar <= 'S') {
                        decodedChar = String.fromCharCode(nextCharCode + 43);
                    } else if (nextChar >= 'T' && nextChar <= 'Z') {
                        decodedChar = String.fromCharCode(127);
                    } else {
                        return null;
                    }
                    break;
                case 'c':
                    if (nextChar >= 'A' && nextChar <= 'O') {
                        decodedChar = String.fromCharCode(nextCharCode - 32);
                    } else if (nextChar === 'Z') {
                        decodedChar = ':';
                    } else {
                        return null;
                    }
                    break;
                case 'd':
                    if (nextChar >= 'A' && nextChar <= 'Z') {
                        decodedChar = String.fromCharCode(nextCharCode + 32);
                    } else {
                        return null;
                    }
                    break;
            }
            result.push(decodedChar);
        } else {
            result.push(char);
        }
    }
    return result;
};

Code93Reader.prototype._verifyChecksums = function (charArray) {
    return this._matchCheckChar(charArray, charArray.length - 2, 20) && this._matchCheckChar(charArray, charArray.length - 1, 15);
};

Code93Reader.prototype._matchCheckChar = function (charArray, index, maxWeight) {
    var _this = this;

    var arrayToCheck = charArray.slice(0, index);
    var length = arrayToCheck.length;
    var weightedSums = arrayToCheck.reduce(function (sum, char, i) {
        var weight = (i * -1 + (length - 1)) % maxWeight + 1;
        var value = _this.ALPHABET.indexOf(char.charCodeAt(0));
        return sum + weight * value;
    }, 0);

    var checkChar = this.ALPHABET[weightedSums % 47];
    return checkChar === charArray[index].charCodeAt(0);
};

exports.default = Code93Reader;

/***/ }),
/* 70 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _ean_reader = __webpack_require__(4);

var _ean_reader2 = _interopRequireDefault(_ean_reader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function EAN2Reader() {
    _ean_reader2.default.call(this);
}

var properties = {
    FORMAT: { value: "ean_2", writeable: false }
};

EAN2Reader.prototype = Object.create(_ean_reader2.default.prototype, properties);
EAN2Reader.prototype.constructor = EAN2Reader;

EAN2Reader.prototype.decode = function (row, start) {
    this._row = row;
    var counters = [0, 0, 0, 0],
        codeFrequency = 0,
        i = 0,
        offset = start,
        end = this._row.length,
        code,
        result = [],
        decodedCodes = [];

    for (i = 0; i < 2 && offset < end; i++) {
        code = this._decodeCode(offset);
        if (!code) {
            return null;
        }
        decodedCodes.push(code);
        result.push(code.code % 10);
        if (code.code >= this.CODE_G_START) {
            codeFrequency |= 1 << 1 - i;
        }
        if (i != 1) {
            offset = this._nextSet(this._row, code.end);
            offset = this._nextUnset(this._row, offset);
        }
    }

    if (result.length != 2 || parseInt(result.join("")) % 4 !== codeFrequency) {
        return null;
    }
    return {
        code: result.join(""),
        decodedCodes: decodedCodes,
        end: code.end
    };
};

exports.default = EAN2Reader;

/***/ }),
/* 71 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _ean_reader = __webpack_require__(4);

var _ean_reader2 = _interopRequireDefault(_ean_reader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function EAN5Reader() {
    _ean_reader2.default.call(this);
}

var properties = {
    FORMAT: { value: "ean_5", writeable: false }
};

var CHECK_DIGIT_ENCODINGS = [24, 20, 18, 17, 12, 6, 3, 10, 9, 5];

EAN5Reader.prototype = Object.create(_ean_reader2.default.prototype, properties);
EAN5Reader.prototype.constructor = EAN5Reader;

EAN5Reader.prototype.decode = function (row, start) {
    this._row = row;
    var counters = [0, 0, 0, 0],
        codeFrequency = 0,
        i = 0,
        offset = start,
        end = this._row.length,
        code,
        result = [],
        decodedCodes = [];

    for (i = 0; i < 5 && offset < end; i++) {
        code = this._decodeCode(offset);
        if (!code) {
            return null;
        }
        decodedCodes.push(code);
        result.push(code.code % 10);
        if (code.code >= this.CODE_G_START) {
            codeFrequency |= 1 << 4 - i;
        }
        if (i != 4) {
            offset = this._nextSet(this._row, code.end);
            offset = this._nextUnset(this._row, offset);
        }
    }

    if (result.length != 5) {
        return null;
    }

    if (extensionChecksum(result) !== determineCheckDigit(codeFrequency)) {
        return null;
    }
    return {
        code: result.join(""),
        decodedCodes: decodedCodes,
        end: code.end
    };
};

function determineCheckDigit(codeFrequency) {
    var i;
    for (i = 0; i < 10; i++) {
        if (codeFrequency === CHECK_DIGIT_ENCODINGS[i]) {
            return i;
        }
    }
    return null;
}

function extensionChecksum(result) {
    var length = result.length,
        sum = 0,
        i;

    for (i = length - 2; i >= 0; i -= 2) {
        sum += result[i];
    }
    sum *= 3;
    for (i = length - 1; i >= 0; i -= 2) {
        sum += result[i];
    }
    sum *= 3;
    return sum % 10;
}

exports.default = EAN5Reader;

/***/ }),
/* 72 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _ean_reader = __webpack_require__(4);

var _ean_reader2 = _interopRequireDefault(_ean_reader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function EAN8Reader(opts, supplements) {
    _ean_reader2.default.call(this, opts, supplements);
}

var properties = {
    FORMAT: { value: "ean_8", writeable: false }
};

EAN8Reader.prototype = Object.create(_ean_reader2.default.prototype, properties);
EAN8Reader.prototype.constructor = EAN8Reader;

EAN8Reader.prototype._decodePayload = function (code, result, decodedCodes) {
    var i,
        self = this;

    for (i = 0; i < 4; i++) {
        code = self._decodeCode(code.end, self.CODE_G_START);
        if (!code) {
            return null;
        }
        result.push(code.code);
        decodedCodes.push(code);
    }

    code = self._findPattern(self.MIDDLE_PATTERN, code.end, true, false);
    if (code === null) {
        return null;
    }
    decodedCodes.push(code);

    for (i = 0; i < 4; i++) {
        code = self._decodeCode(code.end, self.CODE_G_START);
        if (!code) {
            return null;
        }
        decodedCodes.push(code);
        result.push(code.code);
    }

    return code;
};

exports.default = EAN8Reader;

/***/ }),
/* 73 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _merge2 = __webpack_require__(28);

var _merge3 = _interopRequireDefault(_merge2);

var _barcode_reader = __webpack_require__(1);

var _barcode_reader2 = _interopRequireDefault(_barcode_reader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function I2of5Reader(opts) {
    opts = (0, _merge3.default)(getDefaulConfig(), opts);
    _barcode_reader2.default.call(this, opts);
    this.barSpaceRatio = [1, 1];
    if (opts.normalizeBarSpaceWidth) {
        this.SINGLE_CODE_ERROR = 0.38;
        this.AVG_CODE_ERROR = 0.09;
    }
}

function getDefaulConfig() {
    var config = {};

    Object.keys(I2of5Reader.CONFIG_KEYS).forEach(function (key) {
        config[key] = I2of5Reader.CONFIG_KEYS[key].default;
    });
    return config;
}

var N = 1,
    W = 3,
    properties = {
    START_PATTERN: { value: [N, N, N, N] },
    STOP_PATTERN: { value: [N, N, W] },
    CODE_PATTERN: { value: [[N, N, W, W, N], [W, N, N, N, W], [N, W, N, N, W], [W, W, N, N, N], [N, N, W, N, W], [W, N, W, N, N], [N, W, W, N, N], [N, N, N, W, W], [W, N, N, W, N], [N, W, N, W, N]] },
    SINGLE_CODE_ERROR: { value: 0.78, writable: true },
    AVG_CODE_ERROR: { value: 0.38, writable: true },
    MAX_CORRECTION_FACTOR: { value: 5 },
    FORMAT: { value: "i2of5" }
};

I2of5Reader.prototype = Object.create(_barcode_reader2.default.prototype, properties);
I2of5Reader.prototype.constructor = I2of5Reader;

I2of5Reader.prototype._matchPattern = function (counter, code) {
    if (this.config.normalizeBarSpaceWidth) {
        var i,
            counterSum = [0, 0],
            codeSum = [0, 0],
            correction = [0, 0],
            correctionRatio = this.MAX_CORRECTION_FACTOR,
            correctionRatioInverse = 1 / correctionRatio;

        for (i = 0; i < counter.length; i++) {
            counterSum[i % 2] += counter[i];
            codeSum[i % 2] += code[i];
        }
        correction[0] = codeSum[0] / counterSum[0];
        correction[1] = codeSum[1] / counterSum[1];

        correction[0] = Math.max(Math.min(correction[0], correctionRatio), correctionRatioInverse);
        correction[1] = Math.max(Math.min(correction[1], correctionRatio), correctionRatioInverse);
        this.barSpaceRatio = correction;
        for (i = 0; i < counter.length; i++) {
            counter[i] *= this.barSpaceRatio[i % 2];
        }
    }
    return _barcode_reader2.default.prototype._matchPattern.call(this, counter, code);
};

I2of5Reader.prototype._findPattern = function (pattern, offset, isWhite, tryHarder) {
    var counter = [],
        self = this,
        i,
        counterPos = 0,
        bestMatch = {
        error: Number.MAX_VALUE,
        code: -1,
        start: 0,
        end: 0
    },
        error,
        j,
        sum,
        normalized,
        epsilon = self.AVG_CODE_ERROR;

    isWhite = isWhite || false;
    tryHarder = tryHarder || false;

    if (!offset) {
        offset = self._nextSet(self._row);
    }

    for (i = 0; i < pattern.length; i++) {
        counter[i] = 0;
    }

    for (i = offset; i < self._row.length; i++) {
        if (self._row[i] ^ isWhite) {
            counter[counterPos]++;
        } else {
            if (counterPos === counter.length - 1) {
                sum = 0;
                for (j = 0; j < counter.length; j++) {
                    sum += counter[j];
                }
                error = self._matchPattern(counter, pattern);
                if (error < epsilon) {
                    bestMatch.error = error;
                    bestMatch.start = i - sum;
                    bestMatch.end = i;
                    return bestMatch;
                }
                if (tryHarder) {
                    for (j = 0; j < counter.length - 2; j++) {
                        counter[j] = counter[j + 2];
                    }
                    counter[counter.length - 2] = 0;
                    counter[counter.length - 1] = 0;
                    counterPos--;
                } else {
                    return null;
                }
            } else {
                counterPos++;
            }
            counter[counterPos] = 1;
            isWhite = !isWhite;
        }
    }
    return null;
};

I2of5Reader.prototype._findStart = function () {
    var self = this,
        leadingWhitespaceStart,
        offset = self._nextSet(self._row),
        startInfo,
        narrowBarWidth = 1;

    while (!startInfo) {
        startInfo = self._findPattern(self.START_PATTERN, offset, false, true);
        if (!startInfo) {
            return null;
        }
        narrowBarWidth = Math.floor((startInfo.end - startInfo.start) / 4);
        leadingWhitespaceStart = startInfo.start - narrowBarWidth * 10;
        if (leadingWhitespaceStart >= 0) {
            if (self._matchRange(leadingWhitespaceStart, startInfo.start, 0)) {
                return startInfo;
            }
        }
        offset = startInfo.end;
        startInfo = null;
    }
};

I2of5Reader.prototype._verifyTrailingWhitespace = function (endInfo) {
    var self = this,
        trailingWhitespaceEnd;

    trailingWhitespaceEnd = endInfo.end + (endInfo.end - endInfo.start) / 2;
    if (trailingWhitespaceEnd < self._row.length) {
        if (self._matchRange(endInfo.end, trailingWhitespaceEnd, 0)) {
            return endInfo;
        }
    }
    return null;
};

I2of5Reader.prototype._findEnd = function () {
    var self = this,
        endInfo,
        tmp;

    self._row.reverse();
    endInfo = self._findPattern(self.STOP_PATTERN);
    self._row.reverse();

    if (endInfo === null) {
        return null;
    }

    // reverse numbers
    tmp = endInfo.start;
    endInfo.start = self._row.length - endInfo.end;
    endInfo.end = self._row.length - tmp;

    return endInfo !== null ? self._verifyTrailingWhitespace(endInfo) : null;
};

I2of5Reader.prototype._decodePair = function (counterPair) {
    var i,
        code,
        codes = [],
        self = this;

    for (i = 0; i < counterPair.length; i++) {
        code = self._decodeCode(counterPair[i]);
        if (!code) {
            return null;
        }
        codes.push(code);
    }
    return codes;
};

I2of5Reader.prototype._decodeCode = function (counter) {
    var j,
        self = this,
        sum = 0,
        normalized,
        error,
        epsilon = self.AVG_CODE_ERROR,
        code,
        bestMatch = {
        error: Number.MAX_VALUE,
        code: -1,
        start: 0,
        end: 0
    };

    for (j = 0; j < counter.length; j++) {
        sum += counter[j];
    }
    for (code = 0; code < self.CODE_PATTERN.length; code++) {
        error = self._matchPattern(counter, self.CODE_PATTERN[code]);
        if (error < bestMatch.error) {
            bestMatch.code = code;
            bestMatch.error = error;
        }
    }
    if (bestMatch.error < epsilon) {
        return bestMatch;
    }
};

I2of5Reader.prototype._decodePayload = function (counters, result, decodedCodes) {
    var i,
        self = this,
        pos = 0,
        counterLength = counters.length,
        counterPair = [[0, 0, 0, 0, 0], [0, 0, 0, 0, 0]],
        codes;

    while (pos < counterLength) {
        for (i = 0; i < 5; i++) {
            counterPair[0][i] = counters[pos] * this.barSpaceRatio[0];
            counterPair[1][i] = counters[pos + 1] * this.barSpaceRatio[1];
            pos += 2;
        }
        codes = self._decodePair(counterPair);
        if (!codes) {
            return null;
        }
        for (i = 0; i < codes.length; i++) {
            result.push(codes[i].code + "");
            decodedCodes.push(codes[i]);
        }
    }
    return codes;
};

I2of5Reader.prototype._verifyCounterLength = function (counters) {
    return counters.length % 10 === 0;
};

I2of5Reader.prototype._decode = function () {
    var startInfo,
        endInfo,
        self = this,
        code,
        result = [],
        decodedCodes = [],
        counters;

    startInfo = self._findStart();
    if (!startInfo) {
        return null;
    }
    decodedCodes.push(startInfo);

    endInfo = self._findEnd();
    if (!endInfo) {
        return null;
    }

    counters = self._fillCounters(startInfo.end, endInfo.start, false);
    if (!self._verifyCounterLength(counters)) {
        return null;
    }
    code = self._decodePayload(counters, result, decodedCodes);
    if (!code) {
        return null;
    }
    if (result.length % 2 !== 0 || result.length < 6) {
        return null;
    }

    decodedCodes.push(endInfo);
    return {
        code: result.join(""),
        start: startInfo.start,
        end: endInfo.end,
        startInfo: startInfo,
        decodedCodes: decodedCodes
    };
};

I2of5Reader.CONFIG_KEYS = {
    normalizeBarSpaceWidth: {
        'type': 'boolean',
        'default': false,
        'description': 'If true, the reader tries to normalize the' + 'width-difference between bars and spaces'
    }
};

exports.default = I2of5Reader;

/***/ }),
/* 74 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _ean_reader = __webpack_require__(4);

var _ean_reader2 = _interopRequireDefault(_ean_reader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function UPCEReader(opts, supplements) {
    _ean_reader2.default.call(this, opts, supplements);
}

var properties = {
    CODE_FREQUENCY: { value: [[56, 52, 50, 49, 44, 38, 35, 42, 41, 37], [7, 11, 13, 14, 19, 25, 28, 21, 22, 26]] },
    STOP_PATTERN: { value: [1 / 6 * 7, 1 / 6 * 7, 1 / 6 * 7, 1 / 6 * 7, 1 / 6 * 7, 1 / 6 * 7] },
    FORMAT: { value: "upc_e", writeable: false }
};

UPCEReader.prototype = Object.create(_ean_reader2.default.prototype, properties);
UPCEReader.prototype.constructor = UPCEReader;

UPCEReader.prototype._decodePayload = function (code, result, decodedCodes) {
    var i,
        self = this,
        codeFrequency = 0x0;

    for (i = 0; i < 6; i++) {
        code = self._decodeCode(code.end);
        if (!code) {
            return null;
        }
        if (code.code >= self.CODE_G_START) {
            code.code = code.code - self.CODE_G_START;
            codeFrequency |= 1 << 5 - i;
        }
        result.push(code.code);
        decodedCodes.push(code);
    }
    if (!self._determineParity(codeFrequency, result)) {
        return null;
    }

    return code;
};

UPCEReader.prototype._determineParity = function (codeFrequency, result) {
    var i, nrSystem;

    for (nrSystem = 0; nrSystem < this.CODE_FREQUENCY.length; nrSystem++) {
        for (i = 0; i < this.CODE_FREQUENCY[nrSystem].length; i++) {
            if (codeFrequency === this.CODE_FREQUENCY[nrSystem][i]) {
                result.unshift(nrSystem);
                result.push(i);
                return true;
            }
        }
    }
    return false;
};

UPCEReader.prototype._convertToUPCA = function (result) {
    var upca = [result[0]],
        lastDigit = result[result.length - 2];

    if (lastDigit <= 2) {
        upca = upca.concat(result.slice(1, 3)).concat([lastDigit, 0, 0, 0, 0]).concat(result.slice(3, 6));
    } else if (lastDigit === 3) {
        upca = upca.concat(result.slice(1, 4)).concat([0, 0, 0, 0, 0]).concat(result.slice(4, 6));
    } else if (lastDigit === 4) {
        upca = upca.concat(result.slice(1, 5)).concat([0, 0, 0, 0, 0, result[5]]);
    } else {
        upca = upca.concat(result.slice(1, 6)).concat([0, 0, 0, 0, lastDigit]);
    }

    upca.push(result[result.length - 1]);
    return upca;
};

UPCEReader.prototype._checksum = function (result) {
    return _ean_reader2.default.prototype._checksum.call(this, this._convertToUPCA(result));
};

UPCEReader.prototype._findEnd = function (offset, isWhite) {
    isWhite = true;
    return _ean_reader2.default.prototype._findEnd.call(this, offset, isWhite);
};

UPCEReader.prototype._verifyTrailingWhitespace = function (endInfo) {
    var self = this,
        trailingWhitespaceEnd;

    trailingWhitespaceEnd = endInfo.end + (endInfo.end - endInfo.start) / 2;
    if (trailingWhitespaceEnd < self._row.length) {
        if (self._matchRange(endInfo.end, trailingWhitespaceEnd, 0)) {
            return endInfo;
        }
    }
};

exports.default = UPCEReader;

/***/ }),
/* 75 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _ean_reader = __webpack_require__(4);

var _ean_reader2 = _interopRequireDefault(_ean_reader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function UPCReader(opts, supplements) {
    _ean_reader2.default.call(this, opts, supplements);
}

var properties = {
    FORMAT: { value: "upc_a", writeable: false }
};

UPCReader.prototype = Object.create(_ean_reader2.default.prototype, properties);
UPCReader.prototype.constructor = UPCReader;

UPCReader.prototype._decode = function () {
    var result = _ean_reader2.default.prototype._decode.call(this);

    if (result && result.code && result.code.length === 13 && result.code.charAt(0) === "0") {
        result.code = result.code.substring(1);
        return result;
    }
    return null;
};

exports.default = UPCReader;

/***/ }),
/* 76 */
/***/ (function(module, exports) {

module.exports = copy

/**
 * Copy the values from one mat2 to another
 *
 * @alias mat2.copy
 * @param {mat2} out the receiving matrix
 * @param {mat2} a the source matrix
 * @returns {mat2} out
 */
function copy(out, a) {
  out[0] = a[0]
  out[1] = a[1]
  out[2] = a[2]
  out[3] = a[3]
  return out
}


/***/ }),
/* 77 */
/***/ (function(module, exports) {

module.exports = create

/**
 * Creates a new identity mat2
 *
 * @alias mat2.create
 * @returns {mat2} a new 2x2 matrix
 */
function create() {
  var out = new Float32Array(4)
  out[0] = 1
  out[1] = 0
  out[2] = 0
  out[3] = 1
  return out
}


/***/ }),
/* 78 */
/***/ (function(module, exports) {

module.exports = invert

/**
 * Inverts a mat2
 *
 * @alias mat2.invert
 * @param {mat2} out the receiving matrix
 * @param {mat2} a the source matrix
 * @returns {mat2} out
 */
function invert(out, a) {
  var a0 = a[0]
  var a1 = a[1]
  var a2 = a[2]
  var a3 = a[3]
  var det = a0 * a3 - a2 * a1

  if (!det) return null
  det = 1.0 / det

  out[0] =  a3 * det
  out[1] = -a1 * det
  out[2] = -a2 * det
  out[3] =  a0 * det

  return out
}


/***/ }),
/* 79 */
/***/ (function(module, exports) {

module.exports = scale

/**
 * Scales a vec2 by a scalar number
 *
 * @param {vec2} out the receiving vector
 * @param {vec2} a the vector to scale
 * @param {Number} b amount to scale the vector by
 * @returns {vec2} out
 */
function scale(out, a, b) {
    out[0] = a[0] * b
    out[1] = a[1] * b
    return out
}

/***/ }),
/* 80 */
/***/ (function(module, exports) {

module.exports = transformMat2

/**
 * Transforms the vec2 with a mat2
 *
 * @param {vec2} out the receiving vector
 * @param {vec2} a the vector to transform
 * @param {mat2} m matrix to transform with
 * @returns {vec2} out
 */
function transformMat2(out, a, m) {
    var x = a[0],
        y = a[1]
    out[0] = m[0] * x + m[2] * y
    out[1] = m[1] * x + m[3] * y
    return out
}

/***/ }),
/* 81 */
/***/ (function(module, exports) {

module.exports = clone;

/**
 * Creates a new vec3 initialized with values from an existing vector
 *
 * @param {vec3} a vector to clone
 * @returns {vec3} a new 3D vector
 */
function clone(a) {
    var out = new Float32Array(3)
    out[0] = a[0]
    out[1] = a[1]
    out[2] = a[2]
    return out
}

/***/ }),
/* 82 */
/***/ (function(module, exports, __webpack_require__) {

var hashClear = __webpack_require__(120),
    hashDelete = __webpack_require__(121),
    hashGet = __webpack_require__(122),
    hashHas = __webpack_require__(123),
    hashSet = __webpack_require__(124);

/**
 * Creates a hash object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Hash(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `Hash`.
Hash.prototype.clear = hashClear;
Hash.prototype['delete'] = hashDelete;
Hash.prototype.get = hashGet;
Hash.prototype.has = hashHas;
Hash.prototype.set = hashSet;

module.exports = Hash;


/***/ }),
/* 83 */
/***/ (function(module, exports, __webpack_require__) {

var ListCache = __webpack_require__(10),
    stackClear = __webpack_require__(147),
    stackDelete = __webpack_require__(148),
    stackGet = __webpack_require__(149),
    stackHas = __webpack_require__(150),
    stackSet = __webpack_require__(151);

/**
 * Creates a stack cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Stack(entries) {
  var data = this.__data__ = new ListCache(entries);
  this.size = data.size;
}

// Add methods to `Stack`.
Stack.prototype.clear = stackClear;
Stack.prototype['delete'] = stackDelete;
Stack.prototype.get = stackGet;
Stack.prototype.has = stackHas;
Stack.prototype.set = stackSet;

module.exports = Stack;


/***/ }),
/* 84 */
/***/ (function(module, exports, __webpack_require__) {

var root = __webpack_require__(5);

/** Built-in value references. */
var Uint8Array = root.Uint8Array;

module.exports = Uint8Array;


/***/ }),
/* 85 */
/***/ (function(module, exports) {

/**
 * A faster alternative to `Function#apply`, this function invokes `func`
 * with the `this` binding of `thisArg` and the arguments of `args`.
 *
 * @private
 * @param {Function} func The function to invoke.
 * @param {*} thisArg The `this` binding of `func`.
 * @param {Array} args The arguments to invoke `func` with.
 * @returns {*} Returns the result of `func`.
 */
function apply(func, thisArg, args) {
  switch (args.length) {
    case 0: return func.call(thisArg);
    case 1: return func.call(thisArg, args[0]);
    case 2: return func.call(thisArg, args[0], args[1]);
    case 3: return func.call(thisArg, args[0], args[1], args[2]);
  }
  return func.apply(thisArg, args);
}

module.exports = apply;


/***/ }),
/* 86 */
/***/ (function(module, exports, __webpack_require__) {

var baseTimes = __webpack_require__(105),
    isArguments = __webpack_require__(18),
    isArray = __webpack_require__(2),
    isBuffer = __webpack_require__(44),
    isIndex = __webpack_require__(15),
    isTypedArray = __webpack_require__(45);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Creates an array of the enumerable property names of the array-like `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @param {boolean} inherited Specify returning inherited property names.
 * @returns {Array} Returns the array of property names.
 */
function arrayLikeKeys(value, inherited) {
  var isArr = isArray(value),
      isArg = !isArr && isArguments(value),
      isBuff = !isArr && !isArg && isBuffer(value),
      isType = !isArr && !isArg && !isBuff && isTypedArray(value),
      skipIndexes = isArr || isArg || isBuff || isType,
      result = skipIndexes ? baseTimes(value.length, String) : [],
      length = result.length;

  for (var key in value) {
    if ((inherited || hasOwnProperty.call(value, key)) &&
        !(skipIndexes && (
           // Safari 9 has enumerable `arguments.length` in strict mode.
           key == 'length' ||
           // Node.js 0.10 has enumerable non-index properties on buffers.
           (isBuff && (key == 'offset' || key == 'parent')) ||
           // PhantomJS 2 has enumerable non-index properties on typed arrays.
           (isType && (key == 'buffer' || key == 'byteLength' || key == 'byteOffset')) ||
           // Skip index properties.
           isIndex(key, length)
        ))) {
      result.push(key);
    }
  }
  return result;
}

module.exports = arrayLikeKeys;


/***/ }),
/* 87 */
/***/ (function(module, exports) {

/**
 * A specialized version of `_.map` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the new mapped array.
 */
function arrayMap(array, iteratee) {
  var index = -1,
      length = array == null ? 0 : array.length,
      result = Array(length);

  while (++index < length) {
    result[index] = iteratee(array[index], index, array);
  }
  return result;
}

module.exports = arrayMap;


/***/ }),
/* 88 */
/***/ (function(module, exports) {

/**
 * Appends the elements of `values` to `array`.
 *
 * @private
 * @param {Array} array The array to modify.
 * @param {Array} values The values to append.
 * @returns {Array} Returns `array`.
 */
function arrayPush(array, values) {
  var index = -1,
      length = values.length,
      offset = array.length;

  while (++index < length) {
    array[offset + index] = values[index];
  }
  return array;
}

module.exports = arrayPush;


/***/ }),
/* 89 */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(0);

/** Built-in value references. */
var objectCreate = Object.create;

/**
 * The base implementation of `_.create` without support for assigning
 * properties to the created object.
 *
 * @private
 * @param {Object} proto The object to inherit from.
 * @returns {Object} Returns the new object.
 */
var baseCreate = (function() {
  function object() {}
  return function(proto) {
    if (!isObject(proto)) {
      return {};
    }
    if (objectCreate) {
      return objectCreate(proto);
    }
    object.prototype = proto;
    var result = new object;
    object.prototype = undefined;
    return result;
  };
}());

module.exports = baseCreate;


/***/ }),
/* 90 */
/***/ (function(module, exports, __webpack_require__) {

var arrayPush = __webpack_require__(88),
    isFlattenable = __webpack_require__(126);

/**
 * The base implementation of `_.flatten` with support for restricting flattening.
 *
 * @private
 * @param {Array} array The array to flatten.
 * @param {number} depth The maximum recursion depth.
 * @param {boolean} [predicate=isFlattenable] The function invoked per iteration.
 * @param {boolean} [isStrict] Restrict to values that pass `predicate` checks.
 * @param {Array} [result=[]] The initial result value.
 * @returns {Array} Returns the new flattened array.
 */
function baseFlatten(array, depth, predicate, isStrict, result) {
  var index = -1,
      length = array.length;

  predicate || (predicate = isFlattenable);
  result || (result = []);

  while (++index < length) {
    var value = array[index];
    if (depth > 0 && predicate(value)) {
      if (depth > 1) {
        // Recursively flatten arrays (susceptible to call stack limits).
        baseFlatten(value, depth - 1, predicate, isStrict, result);
      } else {
        arrayPush(result, value);
      }
    } else if (!isStrict) {
      result[result.length] = value;
    }
  }
  return result;
}

module.exports = baseFlatten;


/***/ }),
/* 91 */
/***/ (function(module, exports, __webpack_require__) {

var createBaseFor = __webpack_require__(115);

/**
 * The base implementation of `baseForOwn` which iterates over `object`
 * properties returned by `keysFunc` and invokes `iteratee` for each property.
 * Iteratee functions may exit iteration early by explicitly returning `false`.
 *
 * @private
 * @param {Object} object The object to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @param {Function} keysFunc The function to get the keys of `object`.
 * @returns {Object} Returns `object`.
 */
var baseFor = createBaseFor();

module.exports = baseFor;


/***/ }),
/* 92 */
/***/ (function(module, exports, __webpack_require__) {

var castPath = __webpack_require__(13),
    toKey = __webpack_require__(23);

/**
 * The base implementation of `_.get` without support for default values.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array|string} path The path of the property to get.
 * @returns {*} Returns the resolved value.
 */
function baseGet(object, path) {
  path = castPath(path, object);

  var index = 0,
      length = path.length;

  while (object != null && index < length) {
    object = object[toKey(path[index++])];
  }
  return (index && index == length) ? object : undefined;
}

module.exports = baseGet;


/***/ }),
/* 93 */
/***/ (function(module, exports) {

/**
 * The base implementation of `_.hasIn` without support for deep paths.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {Array|string} key The key to check.
 * @returns {boolean} Returns `true` if `key` exists, else `false`.
 */
function baseHasIn(object, key) {
  return object != null && key in Object(object);
}

module.exports = baseHasIn;


/***/ }),
/* 94 */
/***/ (function(module, exports, __webpack_require__) {

var baseGetTag = __webpack_require__(8),
    isObjectLike = __webpack_require__(6);

/** `Object#toString` result references. */
var argsTag = '[object Arguments]';

/**
 * The base implementation of `_.isArguments`.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 */
function baseIsArguments(value) {
  return isObjectLike(value) && baseGetTag(value) == argsTag;
}

module.exports = baseIsArguments;


/***/ }),
/* 95 */
/***/ (function(module, exports, __webpack_require__) {

var isFunction = __webpack_require__(25),
    isMasked = __webpack_require__(130),
    isObject = __webpack_require__(0),
    toSource = __webpack_require__(153);

/**
 * Used to match `RegExp`
 * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
 */
var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

/** Used to detect host constructors (Safari). */
var reIsHostCtor = /^\[object .+?Constructor\]$/;

/** Used for built-in method references. */
var funcProto = Function.prototype,
    objectProto = Object.prototype;

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/** Used to detect if a method is native. */
var reIsNative = RegExp('^' +
  funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&')
  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
);

/**
 * The base implementation of `_.isNative` without bad shim checks.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a native function,
 *  else `false`.
 */
function baseIsNative(value) {
  if (!isObject(value) || isMasked(value)) {
    return false;
  }
  var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
  return pattern.test(toSource(value));
}

module.exports = baseIsNative;


/***/ }),
/* 96 */
/***/ (function(module, exports, __webpack_require__) {

var baseGetTag = __webpack_require__(8),
    isLength = __webpack_require__(26),
    isObjectLike = __webpack_require__(6);

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    funcTag = '[object Function]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    objectTag = '[object Object]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    weakMapTag = '[object WeakMap]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]',
    float32Tag = '[object Float32Array]',
    float64Tag = '[object Float64Array]',
    int8Tag = '[object Int8Array]',
    int16Tag = '[object Int16Array]',
    int32Tag = '[object Int32Array]',
    uint8Tag = '[object Uint8Array]',
    uint8ClampedTag = '[object Uint8ClampedArray]',
    uint16Tag = '[object Uint16Array]',
    uint32Tag = '[object Uint32Array]';

/** Used to identify `toStringTag` values of typed arrays. */
var typedArrayTags = {};
typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
typedArrayTags[uint32Tag] = true;
typedArrayTags[argsTag] = typedArrayTags[arrayTag] =
typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =
typedArrayTags[dataViewTag] = typedArrayTags[dateTag] =
typedArrayTags[errorTag] = typedArrayTags[funcTag] =
typedArrayTags[mapTag] = typedArrayTags[numberTag] =
typedArrayTags[objectTag] = typedArrayTags[regexpTag] =
typedArrayTags[setTag] = typedArrayTags[stringTag] =
typedArrayTags[weakMapTag] = false;

/**
 * The base implementation of `_.isTypedArray` without Node.js optimizations.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 */
function baseIsTypedArray(value) {
  return isObjectLike(value) &&
    isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
}

module.exports = baseIsTypedArray;


/***/ }),
/* 97 */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(0),
    isPrototype = __webpack_require__(40),
    nativeKeysIn = __webpack_require__(142);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * The base implementation of `_.keysIn` which doesn't treat sparse arrays as dense.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function baseKeysIn(object) {
  if (!isObject(object)) {
    return nativeKeysIn(object);
  }
  var isProto = isPrototype(object),
      result = [];

  for (var key in object) {
    if (!(key == 'constructor' && (isProto || !hasOwnProperty.call(object, key)))) {
      result.push(key);
    }
  }
  return result;
}

module.exports = baseKeysIn;


/***/ }),
/* 98 */
/***/ (function(module, exports, __webpack_require__) {

var Stack = __webpack_require__(83),
    assignMergeValue = __webpack_require__(35),
    baseFor = __webpack_require__(91),
    baseMergeDeep = __webpack_require__(99),
    isObject = __webpack_require__(0),
    keysIn = __webpack_require__(46);

/**
 * The base implementation of `_.merge` without support for multiple sources.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @param {number} srcIndex The index of `source`.
 * @param {Function} [customizer] The function to customize merged values.
 * @param {Object} [stack] Tracks traversed source values and their merged
 *  counterparts.
 */
function baseMerge(object, source, srcIndex, customizer, stack) {
  if (object === source) {
    return;
  }
  baseFor(source, function(srcValue, key) {
    if (isObject(srcValue)) {
      stack || (stack = new Stack);
      baseMergeDeep(object, source, key, srcIndex, baseMerge, customizer, stack);
    }
    else {
      var newValue = customizer
        ? customizer(object[key], srcValue, (key + ''), object, source, stack)
        : undefined;

      if (newValue === undefined) {
        newValue = srcValue;
      }
      assignMergeValue(object, key, newValue);
    }
  }, keysIn);
}

module.exports = baseMerge;


/***/ }),
/* 99 */
/***/ (function(module, exports, __webpack_require__) {

var assignMergeValue = __webpack_require__(35),
    cloneBuffer = __webpack_require__(109),
    cloneTypedArray = __webpack_require__(110),
    copyArray = __webpack_require__(111),
    initCloneObject = __webpack_require__(125),
    isArguments = __webpack_require__(18),
    isArray = __webpack_require__(2),
    isArrayLikeObject = __webpack_require__(157),
    isBuffer = __webpack_require__(44),
    isFunction = __webpack_require__(25),
    isObject = __webpack_require__(0),
    isPlainObject = __webpack_require__(158),
    isTypedArray = __webpack_require__(45),
    toPlainObject = __webpack_require__(162);

/**
 * A specialized version of `baseMerge` for arrays and objects which performs
 * deep merges and tracks traversed objects enabling objects with circular
 * references to be merged.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @param {string} key The key of the value to merge.
 * @param {number} srcIndex The index of `source`.
 * @param {Function} mergeFunc The function to merge values.
 * @param {Function} [customizer] The function to customize assigned values.
 * @param {Object} [stack] Tracks traversed source values and their merged
 *  counterparts.
 */
function baseMergeDeep(object, source, key, srcIndex, mergeFunc, customizer, stack) {
  var objValue = object[key],
      srcValue = source[key],
      stacked = stack.get(srcValue);

  if (stacked) {
    assignMergeValue(object, key, stacked);
    return;
  }
  var newValue = customizer
    ? customizer(objValue, srcValue, (key + ''), object, source, stack)
    : undefined;

  var isCommon = newValue === undefined;

  if (isCommon) {
    var isArr = isArray(srcValue),
        isBuff = !isArr && isBuffer(srcValue),
        isTyped = !isArr && !isBuff && isTypedArray(srcValue);

    newValue = srcValue;
    if (isArr || isBuff || isTyped) {
      if (isArray(objValue)) {
        newValue = objValue;
      }
      else if (isArrayLikeObject(objValue)) {
        newValue = copyArray(objValue);
      }
      else if (isBuff) {
        isCommon = false;
        newValue = cloneBuffer(srcValue, true);
      }
      else if (isTyped) {
        isCommon = false;
        newValue = cloneTypedArray(srcValue, true);
      }
      else {
        newValue = [];
      }
    }
    else if (isPlainObject(srcValue) || isArguments(srcValue)) {
      newValue = objValue;
      if (isArguments(objValue)) {
        newValue = toPlainObject(objValue);
      }
      else if (!isObject(objValue) || (srcIndex && isFunction(objValue))) {
        newValue = initCloneObject(srcValue);
      }
    }
    else {
      isCommon = false;
    }
  }
  if (isCommon) {
    // Recursively merge objects and arrays (susceptible to call stack limits).
    stack.set(srcValue, newValue);
    mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
    stack['delete'](srcValue);
  }
  assignMergeValue(object, key, newValue);
}

module.exports = baseMergeDeep;


/***/ }),
/* 100 */
/***/ (function(module, exports, __webpack_require__) {

var basePickBy = __webpack_require__(101),
    hasIn = __webpack_require__(156);

/**
 * The base implementation of `_.pick` without support for individual
 * property identifiers.
 *
 * @private
 * @param {Object} object The source object.
 * @param {string[]} paths The property paths to pick.
 * @returns {Object} Returns the new object.
 */
function basePick(object, paths) {
  return basePickBy(object, paths, function(value, path) {
    return hasIn(object, path);
  });
}

module.exports = basePick;


/***/ }),
/* 101 */
/***/ (function(module, exports, __webpack_require__) {

var baseGet = __webpack_require__(92),
    baseSet = __webpack_require__(103),
    castPath = __webpack_require__(13);

/**
 * The base implementation of  `_.pickBy` without support for iteratee shorthands.
 *
 * @private
 * @param {Object} object The source object.
 * @param {string[]} paths The property paths to pick.
 * @param {Function} predicate The function invoked per property.
 * @returns {Object} Returns the new object.
 */
function basePickBy(object, paths, predicate) {
  var index = -1,
      length = paths.length,
      result = {};

  while (++index < length) {
    var path = paths[index],
        value = baseGet(object, path);

    if (predicate(value, path)) {
      baseSet(result, castPath(path, object), value);
    }
  }
  return result;
}

module.exports = basePickBy;


/***/ }),
/* 102 */
/***/ (function(module, exports, __webpack_require__) {

var identity = __webpack_require__(43),
    overRest = __webpack_require__(41),
    setToString = __webpack_require__(42);

/**
 * The base implementation of `_.rest` which doesn't validate or coerce arguments.
 *
 * @private
 * @param {Function} func The function to apply a rest parameter to.
 * @param {number} [start=func.length-1] The start position of the rest parameter.
 * @returns {Function} Returns the new function.
 */
function baseRest(func, start) {
  return setToString(overRest(func, start, identity), func + '');
}

module.exports = baseRest;


/***/ }),
/* 103 */
/***/ (function(module, exports, __webpack_require__) {

var assignValue = __webpack_require__(36),
    castPath = __webpack_require__(13),
    isIndex = __webpack_require__(15),
    isObject = __webpack_require__(0),
    toKey = __webpack_require__(23);

/**
 * The base implementation of `_.set`.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {Array|string} path The path of the property to set.
 * @param {*} value The value to set.
 * @param {Function} [customizer] The function to customize path creation.
 * @returns {Object} Returns `object`.
 */
function baseSet(object, path, value, customizer) {
  if (!isObject(object)) {
    return object;
  }
  path = castPath(path, object);

  var index = -1,
      length = path.length,
      lastIndex = length - 1,
      nested = object;

  while (nested != null && ++index < length) {
    var key = toKey(path[index]),
        newValue = value;

    if (index != lastIndex) {
      var objValue = nested[key];
      newValue = customizer ? customizer(objValue, key, nested) : undefined;
      if (newValue === undefined) {
        newValue = isObject(objValue)
          ? objValue
          : (isIndex(path[index + 1]) ? [] : {});
      }
    }
    assignValue(nested, key, newValue);
    nested = nested[key];
  }
  return object;
}

module.exports = baseSet;


/***/ }),
/* 104 */
/***/ (function(module, exports, __webpack_require__) {

var constant = __webpack_require__(154),
    defineProperty = __webpack_require__(37),
    identity = __webpack_require__(43);

/**
 * The base implementation of `setToString` without support for hot loop shorting.
 *
 * @private
 * @param {Function} func The function to modify.
 * @param {Function} string The `toString` result.
 * @returns {Function} Returns `func`.
 */
var baseSetToString = !defineProperty ? identity : function(func, string) {
  return defineProperty(func, 'toString', {
    'configurable': true,
    'enumerable': false,
    'value': constant(string),
    'writable': true
  });
};

module.exports = baseSetToString;


/***/ }),
/* 105 */
/***/ (function(module, exports) {

/**
 * The base implementation of `_.times` without support for iteratee shorthands
 * or max array length checks.
 *
 * @private
 * @param {number} n The number of times to invoke `iteratee`.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the array of results.
 */
function baseTimes(n, iteratee) {
  var index = -1,
      result = Array(n);

  while (++index < n) {
    result[index] = iteratee(index);
  }
  return result;
}

module.exports = baseTimes;


/***/ }),
/* 106 */
/***/ (function(module, exports, __webpack_require__) {

var Symbol = __webpack_require__(11),
    arrayMap = __webpack_require__(87),
    isArray = __webpack_require__(2),
    isSymbol = __webpack_require__(27);

/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0;

/** Used to convert symbols to primitives and strings. */
var symbolProto = Symbol ? Symbol.prototype : undefined,
    symbolToString = symbolProto ? symbolProto.toString : undefined;

/**
 * The base implementation of `_.toString` which doesn't convert nullish
 * values to empty strings.
 *
 * @private
 * @param {*} value The value to process.
 * @returns {string} Returns the string.
 */
function baseToString(value) {
  // Exit early for strings to avoid a performance hit in some environments.
  if (typeof value == 'string') {
    return value;
  }
  if (isArray(value)) {
    // Recursively convert values (susceptible to call stack limits).
    return arrayMap(value, baseToString) + '';
  }
  if (isSymbol(value)) {
    return symbolToString ? symbolToString.call(value) : '';
  }
  var result = (value + '');
  return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
}

module.exports = baseToString;


/***/ }),
/* 107 */
/***/ (function(module, exports) {

/**
 * The base implementation of `_.unary` without support for storing metadata.
 *
 * @private
 * @param {Function} func The function to cap arguments for.
 * @returns {Function} Returns the new capped function.
 */
function baseUnary(func) {
  return function(value) {
    return func(value);
  };
}

module.exports = baseUnary;


/***/ }),
/* 108 */
/***/ (function(module, exports, __webpack_require__) {

var Uint8Array = __webpack_require__(84);

/**
 * Creates a clone of `arrayBuffer`.
 *
 * @private
 * @param {ArrayBuffer} arrayBuffer The array buffer to clone.
 * @returns {ArrayBuffer} Returns the cloned array buffer.
 */
function cloneArrayBuffer(arrayBuffer) {
  var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
  new Uint8Array(result).set(new Uint8Array(arrayBuffer));
  return result;
}

module.exports = cloneArrayBuffer;


/***/ }),
/* 109 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(module) {var root = __webpack_require__(5);

/** Detect free variable `exports`. */
var freeExports = typeof exports == 'object' && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && typeof module == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/** Built-in value references. */
var Buffer = moduleExports ? root.Buffer : undefined,
    allocUnsafe = Buffer ? Buffer.allocUnsafe : undefined;

/**
 * Creates a clone of  `buffer`.
 *
 * @private
 * @param {Buffer} buffer The buffer to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Buffer} Returns the cloned buffer.
 */
function cloneBuffer(buffer, isDeep) {
  if (isDeep) {
    return buffer.slice();
  }
  var length = buffer.length,
      result = allocUnsafe ? allocUnsafe(length) : new buffer.constructor(length);

  buffer.copy(result);
  return result;
}

module.exports = cloneBuffer;

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(29)(module)))

/***/ }),
/* 110 */
/***/ (function(module, exports, __webpack_require__) {

var cloneArrayBuffer = __webpack_require__(108);

/**
 * Creates a clone of `typedArray`.
 *
 * @private
 * @param {Object} typedArray The typed array to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Object} Returns the cloned typed array.
 */
function cloneTypedArray(typedArray, isDeep) {
  var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
  return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
}

module.exports = cloneTypedArray;


/***/ }),
/* 111 */
/***/ (function(module, exports) {

/**
 * Copies the values of `source` to `array`.
 *
 * @private
 * @param {Array} source The array to copy values from.
 * @param {Array} [array=[]] The array to copy values to.
 * @returns {Array} Returns `array`.
 */
function copyArray(source, array) {
  var index = -1,
      length = source.length;

  array || (array = Array(length));
  while (++index < length) {
    array[index] = source[index];
  }
  return array;
}

module.exports = copyArray;


/***/ }),
/* 112 */
/***/ (function(module, exports, __webpack_require__) {

var assignValue = __webpack_require__(36),
    baseAssignValue = __webpack_require__(21);

/**
 * Copies properties of `source` to `object`.
 *
 * @private
 * @param {Object} source The object to copy properties from.
 * @param {Array} props The property identifiers to copy.
 * @param {Object} [object={}] The object to copy properties to.
 * @param {Function} [customizer] The function to customize copied values.
 * @returns {Object} Returns `object`.
 */
function copyObject(source, props, object, customizer) {
  var isNew = !object;
  object || (object = {});

  var index = -1,
      length = props.length;

  while (++index < length) {
    var key = props[index];

    var newValue = customizer
      ? customizer(object[key], source[key], key, object, source)
      : undefined;

    if (newValue === undefined) {
      newValue = source[key];
    }
    if (isNew) {
      baseAssignValue(object, key, newValue);
    } else {
      assignValue(object, key, newValue);
    }
  }
  return object;
}

module.exports = copyObject;


/***/ }),
/* 113 */
/***/ (function(module, exports, __webpack_require__) {

var root = __webpack_require__(5);

/** Used to detect overreaching core-js shims. */
var coreJsData = root['__core-js_shared__'];

module.exports = coreJsData;


/***/ }),
/* 114 */
/***/ (function(module, exports, __webpack_require__) {

var baseRest = __webpack_require__(102),
    isIterateeCall = __webpack_require__(127);

/**
 * Creates a function like `_.assign`.
 *
 * @private
 * @param {Function} assigner The function to assign values.
 * @returns {Function} Returns the new assigner function.
 */
function createAssigner(assigner) {
  return baseRest(function(object, sources) {
    var index = -1,
        length = sources.length,
        customizer = length > 1 ? sources[length - 1] : undefined,
        guard = length > 2 ? sources[2] : undefined;

    customizer = (assigner.length > 3 && typeof customizer == 'function')
      ? (length--, customizer)
      : undefined;

    if (guard && isIterateeCall(sources[0], sources[1], guard)) {
      customizer = length < 3 ? undefined : customizer;
      length = 1;
    }
    object = Object(object);
    while (++index < length) {
      var source = sources[index];
      if (source) {
        assigner(object, source, index, customizer);
      }
    }
    return object;
  });
}

module.exports = createAssigner;


/***/ }),
/* 115 */
/***/ (function(module, exports) {

/**
 * Creates a base function for methods like `_.forIn` and `_.forOwn`.
 *
 * @private
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {Function} Returns the new base function.
 */
function createBaseFor(fromRight) {
  return function(object, iteratee, keysFunc) {
    var index = -1,
        iterable = Object(object),
        props = keysFunc(object),
        length = props.length;

    while (length--) {
      var key = props[fromRight ? length : ++index];
      if (iteratee(iterable[key], key, iterable) === false) {
        break;
      }
    }
    return object;
  };
}

module.exports = createBaseFor;


/***/ }),
/* 116 */
/***/ (function(module, exports, __webpack_require__) {

var flatten = __webpack_require__(155),
    overRest = __webpack_require__(41),
    setToString = __webpack_require__(42);

/**
 * A specialized version of `baseRest` which flattens the rest array.
 *
 * @private
 * @param {Function} func The function to apply a rest parameter to.
 * @returns {Function} Returns the new function.
 */
function flatRest(func) {
  return setToString(overRest(func, undefined, flatten), func + '');
}

module.exports = flatRest;


/***/ }),
/* 117 */
/***/ (function(module, exports, __webpack_require__) {

var Symbol = __webpack_require__(11);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString = objectProto.toString;

/** Built-in value references. */
var symToStringTag = Symbol ? Symbol.toStringTag : undefined;

/**
 * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the raw `toStringTag`.
 */
function getRawTag(value) {
  var isOwn = hasOwnProperty.call(value, symToStringTag),
      tag = value[symToStringTag];

  try {
    value[symToStringTag] = undefined;
    var unmasked = true;
  } catch (e) {}

  var result = nativeObjectToString.call(value);
  if (unmasked) {
    if (isOwn) {
      value[symToStringTag] = tag;
    } else {
      delete value[symToStringTag];
    }
  }
  return result;
}

module.exports = getRawTag;


/***/ }),
/* 118 */
/***/ (function(module, exports) {

/**
 * Gets the value at `key` of `object`.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {string} key The key of the property to get.
 * @returns {*} Returns the property value.
 */
function getValue(object, key) {
  return object == null ? undefined : object[key];
}

module.exports = getValue;


/***/ }),
/* 119 */
/***/ (function(module, exports, __webpack_require__) {

var castPath = __webpack_require__(13),
    isArguments = __webpack_require__(18),
    isArray = __webpack_require__(2),
    isIndex = __webpack_require__(15),
    isLength = __webpack_require__(26),
    toKey = __webpack_require__(23);

/**
 * Checks if `path` exists on `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array|string} path The path to check.
 * @param {Function} hasFunc The function to check properties.
 * @returns {boolean} Returns `true` if `path` exists, else `false`.
 */
function hasPath(object, path, hasFunc) {
  path = castPath(path, object);

  var index = -1,
      length = path.length,
      result = false;

  while (++index < length) {
    var key = toKey(path[index]);
    if (!(result = object != null && hasFunc(object, key))) {
      break;
    }
    object = object[key];
  }
  if (result || ++index != length) {
    return result;
  }
  length = object == null ? 0 : object.length;
  return !!length && isLength(length) && isIndex(key, length) &&
    (isArray(object) || isArguments(object));
}

module.exports = hasPath;


/***/ }),
/* 120 */
/***/ (function(module, exports, __webpack_require__) {

var nativeCreate = __webpack_require__(16);

/**
 * Removes all key-value entries from the hash.
 *
 * @private
 * @name clear
 * @memberOf Hash
 */
function hashClear() {
  this.__data__ = nativeCreate ? nativeCreate(null) : {};
  this.size = 0;
}

module.exports = hashClear;


/***/ }),
/* 121 */
/***/ (function(module, exports) {

/**
 * Removes `key` and its value from the hash.
 *
 * @private
 * @name delete
 * @memberOf Hash
 * @param {Object} hash The hash to modify.
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function hashDelete(key) {
  var result = this.has(key) && delete this.__data__[key];
  this.size -= result ? 1 : 0;
  return result;
}

module.exports = hashDelete;


/***/ }),
/* 122 */
/***/ (function(module, exports, __webpack_require__) {

var nativeCreate = __webpack_require__(16);

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Gets the hash value for `key`.
 *
 * @private
 * @name get
 * @memberOf Hash
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function hashGet(key) {
  var data = this.__data__;
  if (nativeCreate) {
    var result = data[key];
    return result === HASH_UNDEFINED ? undefined : result;
  }
  return hasOwnProperty.call(data, key) ? data[key] : undefined;
}

module.exports = hashGet;


/***/ }),
/* 123 */
/***/ (function(module, exports, __webpack_require__) {

var nativeCreate = __webpack_require__(16);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Checks if a hash value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Hash
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function hashHas(key) {
  var data = this.__data__;
  return nativeCreate ? (data[key] !== undefined) : hasOwnProperty.call(data, key);
}

module.exports = hashHas;


/***/ }),
/* 124 */
/***/ (function(module, exports, __webpack_require__) {

var nativeCreate = __webpack_require__(16);

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/**
 * Sets the hash `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Hash
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the hash instance.
 */
function hashSet(key, value) {
  var data = this.__data__;
  this.size += this.has(key) ? 0 : 1;
  data[key] = (nativeCreate && value === undefined) ? HASH_UNDEFINED : value;
  return this;
}

module.exports = hashSet;


/***/ }),
/* 125 */
/***/ (function(module, exports, __webpack_require__) {

var baseCreate = __webpack_require__(89),
    getPrototype = __webpack_require__(39),
    isPrototype = __webpack_require__(40);

/**
 * Initializes an object clone.
 *
 * @private
 * @param {Object} object The object to clone.
 * @returns {Object} Returns the initialized clone.
 */
function initCloneObject(object) {
  return (typeof object.constructor == 'function' && !isPrototype(object))
    ? baseCreate(getPrototype(object))
    : {};
}

module.exports = initCloneObject;


/***/ }),
/* 126 */
/***/ (function(module, exports, __webpack_require__) {

var Symbol = __webpack_require__(11),
    isArguments = __webpack_require__(18),
    isArray = __webpack_require__(2);

/** Built-in value references. */
var spreadableSymbol = Symbol ? Symbol.isConcatSpreadable : undefined;

/**
 * Checks if `value` is a flattenable `arguments` object or array.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is flattenable, else `false`.
 */
function isFlattenable(value) {
  return isArray(value) || isArguments(value) ||
    !!(spreadableSymbol && value && value[spreadableSymbol]);
}

module.exports = isFlattenable;


/***/ }),
/* 127 */
/***/ (function(module, exports, __webpack_require__) {

var eq = __webpack_require__(17),
    isArrayLike = __webpack_require__(24),
    isIndex = __webpack_require__(15),
    isObject = __webpack_require__(0);

/**
 * Checks if the given arguments are from an iteratee call.
 *
 * @private
 * @param {*} value The potential iteratee value argument.
 * @param {*} index The potential iteratee index or key argument.
 * @param {*} object The potential iteratee object argument.
 * @returns {boolean} Returns `true` if the arguments are from an iteratee call,
 *  else `false`.
 */
function isIterateeCall(value, index, object) {
  if (!isObject(object)) {
    return false;
  }
  var type = typeof index;
  if (type == 'number'
        ? (isArrayLike(object) && isIndex(index, object.length))
        : (type == 'string' && index in object)
      ) {
    return eq(object[index], value);
  }
  return false;
}

module.exports = isIterateeCall;


/***/ }),
/* 128 */
/***/ (function(module, exports, __webpack_require__) {

var isArray = __webpack_require__(2),
    isSymbol = __webpack_require__(27);

/** Used to match property names within property paths. */
var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,
    reIsPlainProp = /^\w*$/;

/**
 * Checks if `value` is a property name and not a property path.
 *
 * @private
 * @param {*} value The value to check.
 * @param {Object} [object] The object to query keys on.
 * @returns {boolean} Returns `true` if `value` is a property name, else `false`.
 */
function isKey(value, object) {
  if (isArray(value)) {
    return false;
  }
  var type = typeof value;
  if (type == 'number' || type == 'symbol' || type == 'boolean' ||
      value == null || isSymbol(value)) {
    return true;
  }
  return reIsPlainProp.test(value) || !reIsDeepProp.test(value) ||
    (object != null && value in Object(object));
}

module.exports = isKey;


/***/ }),
/* 129 */
/***/ (function(module, exports) {

/**
 * Checks if `value` is suitable for use as unique object key.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
 */
function isKeyable(value) {
  var type = typeof value;
  return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')
    ? (value !== '__proto__')
    : (value === null);
}

module.exports = isKeyable;


/***/ }),
/* 130 */
/***/ (function(module, exports, __webpack_require__) {

var coreJsData = __webpack_require__(113);

/** Used to detect methods masquerading as native. */
var maskSrcKey = (function() {
  var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
  return uid ? ('Symbol(src)_1.' + uid) : '';
}());

/**
 * Checks if `func` has its source masked.
 *
 * @private
 * @param {Function} func The function to check.
 * @returns {boolean} Returns `true` if `func` is masked, else `false`.
 */
function isMasked(func) {
  return !!maskSrcKey && (maskSrcKey in func);
}

module.exports = isMasked;


/***/ }),
/* 131 */
/***/ (function(module, exports) {

/**
 * Removes all key-value entries from the list cache.
 *
 * @private
 * @name clear
 * @memberOf ListCache
 */
function listCacheClear() {
  this.__data__ = [];
  this.size = 0;
}

module.exports = listCacheClear;


/***/ }),
/* 132 */
/***/ (function(module, exports, __webpack_require__) {

var assocIndexOf = __webpack_require__(12);

/** Used for built-in method references. */
var arrayProto = Array.prototype;

/** Built-in value references. */
var splice = arrayProto.splice;

/**
 * Removes `key` and its value from the list cache.
 *
 * @private
 * @name delete
 * @memberOf ListCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function listCacheDelete(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    return false;
  }
  var lastIndex = data.length - 1;
  if (index == lastIndex) {
    data.pop();
  } else {
    splice.call(data, index, 1);
  }
  --this.size;
  return true;
}

module.exports = listCacheDelete;


/***/ }),
/* 133 */
/***/ (function(module, exports, __webpack_require__) {

var assocIndexOf = __webpack_require__(12);

/**
 * Gets the list cache value for `key`.
 *
 * @private
 * @name get
 * @memberOf ListCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function listCacheGet(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  return index < 0 ? undefined : data[index][1];
}

module.exports = listCacheGet;


/***/ }),
/* 134 */
/***/ (function(module, exports, __webpack_require__) {

var assocIndexOf = __webpack_require__(12);

/**
 * Checks if a list cache value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf ListCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function listCacheHas(key) {
  return assocIndexOf(this.__data__, key) > -1;
}

module.exports = listCacheHas;


/***/ }),
/* 135 */
/***/ (function(module, exports, __webpack_require__) {

var assocIndexOf = __webpack_require__(12);

/**
 * Sets the list cache `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf ListCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the list cache instance.
 */
function listCacheSet(key, value) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    ++this.size;
    data.push([key, value]);
  } else {
    data[index][1] = value;
  }
  return this;
}

module.exports = listCacheSet;


/***/ }),
/* 136 */
/***/ (function(module, exports, __webpack_require__) {

var Hash = __webpack_require__(82),
    ListCache = __webpack_require__(10),
    Map = __webpack_require__(33);

/**
 * Removes all key-value entries from the map.
 *
 * @private
 * @name clear
 * @memberOf MapCache
 */
function mapCacheClear() {
  this.size = 0;
  this.__data__ = {
    'hash': new Hash,
    'map': new (Map || ListCache),
    'string': new Hash
  };
}

module.exports = mapCacheClear;


/***/ }),
/* 137 */
/***/ (function(module, exports, __webpack_require__) {

var getMapData = __webpack_require__(14);

/**
 * Removes `key` and its value from the map.
 *
 * @private
 * @name delete
 * @memberOf MapCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function mapCacheDelete(key) {
  var result = getMapData(this, key)['delete'](key);
  this.size -= result ? 1 : 0;
  return result;
}

module.exports = mapCacheDelete;


/***/ }),
/* 138 */
/***/ (function(module, exports, __webpack_require__) {

var getMapData = __webpack_require__(14);

/**
 * Gets the map value for `key`.
 *
 * @private
 * @name get
 * @memberOf MapCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function mapCacheGet(key) {
  return getMapData(this, key).get(key);
}

module.exports = mapCacheGet;


/***/ }),
/* 139 */
/***/ (function(module, exports, __webpack_require__) {

var getMapData = __webpack_require__(14);

/**
 * Checks if a map value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf MapCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function mapCacheHas(key) {
  return getMapData(this, key).has(key);
}

module.exports = mapCacheHas;


/***/ }),
/* 140 */
/***/ (function(module, exports, __webpack_require__) {

var getMapData = __webpack_require__(14);

/**
 * Sets the map `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf MapCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the map cache instance.
 */
function mapCacheSet(key, value) {
  var data = getMapData(this, key),
      size = data.size;

  data.set(key, value);
  this.size += data.size == size ? 0 : 1;
  return this;
}

module.exports = mapCacheSet;


/***/ }),
/* 141 */
/***/ (function(module, exports, __webpack_require__) {

var memoize = __webpack_require__(159);

/** Used as the maximum memoize cache size. */
var MAX_MEMOIZE_SIZE = 500;

/**
 * A specialized version of `_.memoize` which clears the memoized function's
 * cache when it exceeds `MAX_MEMOIZE_SIZE`.
 *
 * @private
 * @param {Function} func The function to have its output memoized.
 * @returns {Function} Returns the new memoized function.
 */
function memoizeCapped(func) {
  var result = memoize(func, function(key) {
    if (cache.size === MAX_MEMOIZE_SIZE) {
      cache.clear();
    }
    return key;
  });

  var cache = result.cache;
  return result;
}

module.exports = memoizeCapped;


/***/ }),
/* 142 */
/***/ (function(module, exports) {

/**
 * This function is like
 * [`Object.keys`](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
 * except that it includes inherited enumerable properties.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function nativeKeysIn(object) {
  var result = [];
  if (object != null) {
    for (var key in Object(object)) {
      result.push(key);
    }
  }
  return result;
}

module.exports = nativeKeysIn;


/***/ }),
/* 143 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(module) {var freeGlobal = __webpack_require__(38);

/** Detect free variable `exports`. */
var freeExports = typeof exports == 'object' && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && typeof module == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/** Detect free variable `process` from Node.js. */
var freeProcess = moduleExports && freeGlobal.process;

/** Used to access faster Node.js helpers. */
var nodeUtil = (function() {
  try {
    return freeProcess && freeProcess.binding && freeProcess.binding('util');
  } catch (e) {}
}());

module.exports = nodeUtil;

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(29)(module)))

/***/ }),
/* 144 */
/***/ (function(module, exports) {

/** Used for built-in method references. */
var objectProto = Object.prototype;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString = objectProto.toString;

/**
 * Converts `value` to a string using `Object.prototype.toString`.
 *
 * @private
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 */
function objectToString(value) {
  return nativeObjectToString.call(value);
}

module.exports = objectToString;


/***/ }),
/* 145 */
/***/ (function(module, exports) {

/**
 * Creates a unary function that invokes `func` with its argument transformed.
 *
 * @private
 * @param {Function} func The function to wrap.
 * @param {Function} transform The argument transform.
 * @returns {Function} Returns the new function.
 */
function overArg(func, transform) {
  return function(arg) {
    return func(transform(arg));
  };
}

module.exports = overArg;


/***/ }),
/* 146 */
/***/ (function(module, exports) {

/** Used to detect hot functions by number of calls within a span of milliseconds. */
var HOT_COUNT = 800,
    HOT_SPAN = 16;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeNow = Date.now;

/**
 * Creates a function that'll short out and invoke `identity` instead
 * of `func` when it's called `HOT_COUNT` or more times in `HOT_SPAN`
 * milliseconds.
 *
 * @private
 * @param {Function} func The function to restrict.
 * @returns {Function} Returns the new shortable function.
 */
function shortOut(func) {
  var count = 0,
      lastCalled = 0;

  return function() {
    var stamp = nativeNow(),
        remaining = HOT_SPAN - (stamp - lastCalled);

    lastCalled = stamp;
    if (remaining > 0) {
      if (++count >= HOT_COUNT) {
        return arguments[0];
      }
    } else {
      count = 0;
    }
    return func.apply(undefined, arguments);
  };
}

module.exports = shortOut;


/***/ }),
/* 147 */
/***/ (function(module, exports, __webpack_require__) {

var ListCache = __webpack_require__(10);

/**
 * Removes all key-value entries from the stack.
 *
 * @private
 * @name clear
 * @memberOf Stack
 */
function stackClear() {
  this.__data__ = new ListCache;
  this.size = 0;
}

module.exports = stackClear;


/***/ }),
/* 148 */
/***/ (function(module, exports) {

/**
 * Removes `key` and its value from the stack.
 *
 * @private
 * @name delete
 * @memberOf Stack
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function stackDelete(key) {
  var data = this.__data__,
      result = data['delete'](key);

  this.size = data.size;
  return result;
}

module.exports = stackDelete;


/***/ }),
/* 149 */
/***/ (function(module, exports) {

/**
 * Gets the stack value for `key`.
 *
 * @private
 * @name get
 * @memberOf Stack
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function stackGet(key) {
  return this.__data__.get(key);
}

module.exports = stackGet;


/***/ }),
/* 150 */
/***/ (function(module, exports) {

/**
 * Checks if a stack value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Stack
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function stackHas(key) {
  return this.__data__.has(key);
}

module.exports = stackHas;


/***/ }),
/* 151 */
/***/ (function(module, exports, __webpack_require__) {

var ListCache = __webpack_require__(10),
    Map = __webpack_require__(33),
    MapCache = __webpack_require__(34);

/** Used as the size to enable large array optimizations. */
var LARGE_ARRAY_SIZE = 200;

/**
 * Sets the stack `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Stack
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the stack cache instance.
 */
function stackSet(key, value) {
  var data = this.__data__;
  if (data instanceof ListCache) {
    var pairs = data.__data__;
    if (!Map || (pairs.length < LARGE_ARRAY_SIZE - 1)) {
      pairs.push([key, value]);
      this.size = ++data.size;
      return this;
    }
    data = this.__data__ = new MapCache(pairs);
  }
  data.set(key, value);
  this.size = data.size;
  return this;
}

module.exports = stackSet;


/***/ }),
/* 152 */
/***/ (function(module, exports, __webpack_require__) {

var memoizeCapped = __webpack_require__(141);

/** Used to match property names within property paths. */
var reLeadingDot = /^\./,
    rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;

/** Used to match backslashes in property paths. */
var reEscapeChar = /\\(\\)?/g;

/**
 * Converts `string` to a property path array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the property path array.
 */
var stringToPath = memoizeCapped(function(string) {
  var result = [];
  if (reLeadingDot.test(string)) {
    result.push('');
  }
  string.replace(rePropName, function(match, number, quote, string) {
    result.push(quote ? string.replace(reEscapeChar, '$1') : (number || match));
  });
  return result;
});

module.exports = stringToPath;


/***/ }),
/* 153 */
/***/ (function(module, exports) {

/** Used for built-in method references. */
var funcProto = Function.prototype;

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/**
 * Converts `func` to its source code.
 *
 * @private
 * @param {Function} func The function to convert.
 * @returns {string} Returns the source code.
 */
function toSource(func) {
  if (func != null) {
    try {
      return funcToString.call(func);
    } catch (e) {}
    try {
      return (func + '');
    } catch (e) {}
  }
  return '';
}

module.exports = toSource;


/***/ }),
/* 154 */
/***/ (function(module, exports) {

/**
 * Creates a function that returns `value`.
 *
 * @static
 * @memberOf _
 * @since 2.4.0
 * @category Util
 * @param {*} value The value to return from the new function.
 * @returns {Function} Returns the new constant function.
 * @example
 *
 * var objects = _.times(2, _.constant({ 'a': 1 }));
 *
 * console.log(objects);
 * // => [{ 'a': 1 }, { 'a': 1 }]
 *
 * console.log(objects[0] === objects[1]);
 * // => true
 */
function constant(value) {
  return function() {
    return value;
  };
}

module.exports = constant;


/***/ }),
/* 155 */
/***/ (function(module, exports, __webpack_require__) {

var baseFlatten = __webpack_require__(90);

/**
 * Flattens `array` a single level deep.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Array
 * @param {Array} array The array to flatten.
 * @returns {Array} Returns the new flattened array.
 * @example
 *
 * _.flatten([1, [2, [3, [4]], 5]]);
 * // => [1, 2, [3, [4]], 5]
 */
function flatten(array) {
  var length = array == null ? 0 : array.length;
  return length ? baseFlatten(array, 1) : [];
}

module.exports = flatten;


/***/ }),
/* 156 */
/***/ (function(module, exports, __webpack_require__) {

var baseHasIn = __webpack_require__(93),
    hasPath = __webpack_require__(119);

/**
 * Checks if `path` is a direct or inherited property of `object`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Object
 * @param {Object} object The object to query.
 * @param {Array|string} path The path to check.
 * @returns {boolean} Returns `true` if `path` exists, else `false`.
 * @example
 *
 * var object = _.create({ 'a': _.create({ 'b': 2 }) });
 *
 * _.hasIn(object, 'a');
 * // => true
 *
 * _.hasIn(object, 'a.b');
 * // => true
 *
 * _.hasIn(object, ['a', 'b']);
 * // => true
 *
 * _.hasIn(object, 'b');
 * // => false
 */
function hasIn(object, path) {
  return object != null && hasPath(object, path, baseHasIn);
}

module.exports = hasIn;


/***/ }),
/* 157 */
/***/ (function(module, exports, __webpack_require__) {

var isArrayLike = __webpack_require__(24),
    isObjectLike = __webpack_require__(6);

/**
 * This method is like `_.isArrayLike` except that it also checks if `value`
 * is an object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array-like object,
 *  else `false`.
 * @example
 *
 * _.isArrayLikeObject([1, 2, 3]);
 * // => true
 *
 * _.isArrayLikeObject(document.body.children);
 * // => true
 *
 * _.isArrayLikeObject('abc');
 * // => false
 *
 * _.isArrayLikeObject(_.noop);
 * // => false
 */
function isArrayLikeObject(value) {
  return isObjectLike(value) && isArrayLike(value);
}

module.exports = isArrayLikeObject;


/***/ }),
/* 158 */
/***/ (function(module, exports, __webpack_require__) {

var baseGetTag = __webpack_require__(8),
    getPrototype = __webpack_require__(39),
    isObjectLike = __webpack_require__(6);

/** `Object#toString` result references. */
var objectTag = '[object Object]';

/** Used for built-in method references. */
var funcProto = Function.prototype,
    objectProto = Object.prototype;

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/** Used to infer the `Object` constructor. */
var objectCtorString = funcToString.call(Object);

/**
 * Checks if `value` is a plain object, that is, an object created by the
 * `Object` constructor or one with a `[[Prototype]]` of `null`.
 *
 * @static
 * @memberOf _
 * @since 0.8.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a plain object, else `false`.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 * }
 *
 * _.isPlainObject(new Foo);
 * // => false
 *
 * _.isPlainObject([1, 2, 3]);
 * // => false
 *
 * _.isPlainObject({ 'x': 0, 'y': 0 });
 * // => true
 *
 * _.isPlainObject(Object.create(null));
 * // => true
 */
function isPlainObject(value) {
  if (!isObjectLike(value) || baseGetTag(value) != objectTag) {
    return false;
  }
  var proto = getPrototype(value);
  if (proto === null) {
    return true;
  }
  var Ctor = hasOwnProperty.call(proto, 'constructor') && proto.constructor;
  return typeof Ctor == 'function' && Ctor instanceof Ctor &&
    funcToString.call(Ctor) == objectCtorString;
}

module.exports = isPlainObject;


/***/ }),
/* 159 */
/***/ (function(module, exports, __webpack_require__) {

var MapCache = __webpack_require__(34);

/** Error message constants. */
var FUNC_ERROR_TEXT = 'Expected a function';

/**
 * Creates a function that memoizes the result of `func`. If `resolver` is
 * provided, it determines the cache key for storing the result based on the
 * arguments provided to the memoized function. By default, the first argument
 * provided to the memoized function is used as the map cache key. The `func`
 * is invoked with the `this` binding of the memoized function.
 *
 * **Note:** The cache is exposed as the `cache` property on the memoized
 * function. Its creation may be customized by replacing the `_.memoize.Cache`
 * constructor with one whose instances implement the
 * [`Map`](http://ecma-international.org/ecma-262/7.0/#sec-properties-of-the-map-prototype-object)
 * method interface of `clear`, `delete`, `get`, `has`, and `set`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Function
 * @param {Function} func The function to have its output memoized.
 * @param {Function} [resolver] The function to resolve the cache key.
 * @returns {Function} Returns the new memoized function.
 * @example
 *
 * var object = { 'a': 1, 'b': 2 };
 * var other = { 'c': 3, 'd': 4 };
 *
 * var values = _.memoize(_.values);
 * values(object);
 * // => [1, 2]
 *
 * values(other);
 * // => [3, 4]
 *
 * object.a = 2;
 * values(object);
 * // => [1, 2]
 *
 * // Modify the result cache.
 * values.cache.set(object, ['a', 'b']);
 * values(object);
 * // => ['a', 'b']
 *
 * // Replace `_.memoize.Cache`.
 * _.memoize.Cache = WeakMap;
 */
function memoize(func, resolver) {
  if (typeof func != 'function' || (resolver != null && typeof resolver != 'function')) {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  var memoized = function() {
    var args = arguments,
        key = resolver ? resolver.apply(this, args) : args[0],
        cache = memoized.cache;

    if (cache.has(key)) {
      return cache.get(key);
    }
    var result = func.apply(this, args);
    memoized.cache = cache.set(key, result) || cache;
    return result;
  };
  memoized.cache = new (memoize.Cache || MapCache);
  return memoized;
}

// Expose `MapCache`.
memoize.Cache = MapCache;

module.exports = memoize;


/***/ }),
/* 160 */
/***/ (function(module, exports, __webpack_require__) {

var basePick = __webpack_require__(100),
    flatRest = __webpack_require__(116);

/**
 * Creates an object composed of the picked `object` properties.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Object
 * @param {Object} object The source object.
 * @param {...(string|string[])} [paths] The property paths to pick.
 * @returns {Object} Returns the new object.
 * @example
 *
 * var object = { 'a': 1, 'b': '2', 'c': 3 };
 *
 * _.pick(object, ['a', 'c']);
 * // => { 'a': 1, 'c': 3 }
 */
var pick = flatRest(function(object, paths) {
  return object == null ? {} : basePick(object, paths);
});

module.exports = pick;


/***/ }),
/* 161 */
/***/ (function(module, exports) {

/**
 * This method returns `false`.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {boolean} Returns `false`.
 * @example
 *
 * _.times(2, _.stubFalse);
 * // => [false, false]
 */
function stubFalse() {
  return false;
}

module.exports = stubFalse;


/***/ }),
/* 162 */
/***/ (function(module, exports, __webpack_require__) {

var copyObject = __webpack_require__(112),
    keysIn = __webpack_require__(46);

/**
 * Converts `value` to a plain object flattening inherited enumerable string
 * keyed properties of `value` to own properties of the plain object.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {Object} Returns the converted plain object.
 * @example
 *
 * function Foo() {
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.assign({ 'a': 1 }, new Foo);
 * // => { 'a': 1, 'b': 2 }
 *
 * _.assign({ 'a': 1 }, _.toPlainObject(new Foo));
 * // => { 'a': 1, 'b': 2, 'c': 3 }
 */
function toPlainObject(value) {
  return copyObject(value, keysIn(value));
}

module.exports = toPlainObject;


/***/ }),
/* 163 */
/***/ (function(module, exports, __webpack_require__) {

var baseToString = __webpack_require__(106);

/**
 * Converts `value` to a string. An empty string is returned for `null`
 * and `undefined` values. The sign of `-0` is preserved.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 * @example
 *
 * _.toString(null);
 * // => ''
 *
 * _.toString(-0);
 * // => '-0'
 *
 * _.toString([1, 2, 3]);
 * // => '1,2,3'
 */
function toString(value) {
  return value == null ? '' : baseToString(value);
}

module.exports = toString;


/***/ }),
/* 164 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_164__;

/***/ }),
/* 165 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_165__;

/***/ }),
/* 166 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_166__;

/***/ }),
/* 167 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(48);


/***/ })
/******/ ]);
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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