/*!
 * Dynamsoft JavaScript Library
 * @product Dynamsoft Utility JS Edition
 * @website https://www.dynamsoft.com
 * @copyright Copyright 2024, Dynamsoft Corporation
 * @author Dynamsoft
 * @version 1.2.10
 * @fileoverview Dynamsoft JavaScript Library for Core
 * More info DU JS: https://www.dynamsoft.com/capture-vision/docs/web/programming/javascript/api-reference/utility/utility-module.html
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("dynamsoft-core")):"function"==typeof define&&define.amd?define(["exports","dynamsoft-core"],t):t(((e="undefined"!=typeof globalThis?globalThis:e||self).Dynamsoft=e.Dynamsoft||{},e.Dynamsoft.Utility={}),e.Dynamsoft.Core)}(this,(function(e,t){"use strict";const i=async(e,t,i)=>await new Promise((async(r,l)=>{try{const l=t.split(".");let a=l[l.length-1];const s=await n(`image/${a}`,e);l.length<=1&&(a="png");const u=new File([s],t,{type:`image/${a}`});if(i){const e=URL.createObjectURL(u),i=document.createElement("a");i.href=e,i.download=t,i.click()}return r(u)}catch(e){return l()}})),r=e=>{const t=document.createElement("canvas");t.width=e.width,t.height=e.height;return t.getContext("2d",{willReadFrequently:!0}).putImageData(e,0,0),t},n=async(e,t)=>{const i=r(t);return new Promise(((t,r)=>{i.toBlob((e=>t(e)),e)}))},l=e=>{let i,r=e.bytes;if(!(r&&r instanceof Uint8Array))throw Error("Parameter type error");if(Number(e.format)===t.EnumImagePixelFormat.IPF_BGR_888){const e=r.length/3;i=new Uint8ClampedArray(4*e);for(let t=0;t<e;++t)i[4*t]=r[3*t],i[4*t+1]=r[3*t+1],i[4*t+2]=r[3*t+2],i[4*t+3]=255}else if(Number(e.format)===t.EnumImagePixelFormat.IPF_RGB_888){const e=r.length/3;i=new Uint8ClampedArray(4*e);for(let t=0;t<e;++t)i[4*t]=r[3*t+2],i[4*t+1]=r[3*t+1],i[4*t+2]=r[3*t],i[4*t+3]=255}else if(Number(e.format)===t.EnumImagePixelFormat.IPF_GRAYSCALED){const e=r.length;i=new Uint8ClampedArray(4*e);for(let t=0;t<e;t++)i[4*t]=i[4*t+1]=i[4*t+2]=r[t],i[4*t+3]=255}else if(Number(e.format)===t.EnumImagePixelFormat.IPF_BINARY_8){const t=r.length,n=e.width,l=e.height,a=e.stride;i=new Uint8ClampedArray(n*l*4);for(let e=0;e<t;e++){let t=r[e],l=e%a,s=Math.floor(e/a);for(let e=0;e<8;e++){let r=l+e,a=4*(s*n+r);if(r>=n)break;i[a]=i[a+1]=i[a+2]=(128&t)/128*255,i[a+3]=255,t<<=1}}}else if(Number(e.format)===t.EnumImagePixelFormat.IPF_ABGR_8888){const e=r.length/4;i=new Uint8ClampedArray(r.length);for(let t=0;t<e;++t)i[4*t]=r[4*t],i[4*t+1]=r[4*t+1],i[4*t+2]=r[4*t+2],i[4*t+3]=r[4*t+3]}else if(Number(e.format)===t.EnumImagePixelFormat.IPF_ARGB_8888){const e=r.length/4;i=new Uint8ClampedArray(r.length);for(let t=0;t<e;++t)i[4*t]=r[4*t],i[4*t+1]=r[4*t+1],i[4*t+2]=r[4*t+2],i[4*t+3]=r[4*t+3]}return new ImageData(i,e.width,e.height)};const a={barcode:2,text_line:4,detected_quad:8,normalized_image:16},s=e=>Object.values(a).includes(e)||a.hasOwnProperty(e),u=(e,t)=>"string"==typeof e?t[a[e]]:t[e],o=(e,t,i)=>{"string"==typeof e?t[a[e]]=i:t[e]=i};e.ImageManager=class{async saveToFile(e,t,r){if(!e||!t)return null;if("string"!=typeof t)throw new TypeError("FileName must be of type string.");const n=l(e);return i(n,t,r)}},e.MultiFrameResultCrossFilter=class{constructor(){this.verificationEnabled={[t.EnumCapturedResultItemType.CRIT_BARCODE]:!1,[t.EnumCapturedResultItemType.CRIT_TEXT_LINE]:!0,[t.EnumCapturedResultItemType.CRIT_DETECTED_QUAD]:!0,[t.EnumCapturedResultItemType.CRIT_NORMALIZED_IMAGE]:!1},this.duplicateFilterEnabled={[t.EnumCapturedResultItemType.CRIT_BARCODE]:!1,[t.EnumCapturedResultItemType.CRIT_TEXT_LINE]:!1,[t.EnumCapturedResultItemType.CRIT_DETECTED_QUAD]:!1,[t.EnumCapturedResultItemType.CRIT_NORMALIZED_IMAGE]:!1},this.duplicateForgetTime={[t.EnumCapturedResultItemType.CRIT_BARCODE]:3e3,[t.EnumCapturedResultItemType.CRIT_TEXT_LINE]:3e3,[t.EnumCapturedResultItemType.CRIT_DETECTED_QUAD]:3e3,[t.EnumCapturedResultItemType.CRIT_NORMALIZED_IMAGE]:3e3}}enableResultCrossVerification(e,t){s(e)&&o(e,this.verificationEnabled,t)}isResultCrossVerificationEnabled(e){return!!s(e)&&u(e,this.verificationEnabled)}enableResultDeduplication(e,t){s(e)&&o(e,this.duplicateFilterEnabled,t)}isResultDeduplicationEnabled(e){return!!s(e)&&u(e,this.duplicateFilterEnabled)}setDuplicateForgetTime(e,t){s(e)&&(t>18e4&&(t=18e4),t<0&&(t=0),o(e,this.duplicateForgetTime,t))}getDuplicateForgetTime(e){return s(e)?u(e,this.duplicateForgetTime):-1}getFilteredResultItemTypes(){let e=0;const i=[t.EnumCapturedResultItemType.CRIT_BARCODE,t.EnumCapturedResultItemType.CRIT_TEXT_LINE,t.EnumCapturedResultItemType.CRIT_DETECTED_QUAD];for(let t=0;t<i.length;t++)(this.verificationEnabled[i[t]]||this.duplicateFilterEnabled[i[t]])&&(e|=i[t]);return e}onOriginalImageResultReceived(e){}onDecodedBarcodesReceived(e){if(this.isResultCrossVerificationEnabled(t.EnumCapturedResultItemType.CRIT_BARCODE))for(let i=0;i<e.length;i++)e[i]&&e[i].type===t.EnumCapturedResultItemType.CRIT_BARCODE&&!e[i].verified&&(e[i].isFilter=!0);if(this.isResultDeduplicationEnabled(t.EnumCapturedResultItemType.CRIT_BARCODE))for(let i=0;i<e.length;i++)e[i]&&e[i].type===t.EnumCapturedResultItemType.CRIT_BARCODE&&e[i].duplicate&&(e[i].isFilter=!0)}onRecognizedTextLinesReceived(e){if(this.isResultCrossVerificationEnabled(t.EnumCapturedResultItemType.CRIT_TEXT_LINE))for(let i=0;i<e.length;i++)e[i]&&e[i].type===t.EnumCapturedResultItemType.CRIT_TEXT_LINE&&!e[i].verified&&(e[i].isFilter=!0);if(this.isResultDeduplicationEnabled(t.EnumCapturedResultItemType.CRIT_TEXT_LINE))for(let i=0;i<e.length;i++)e[i]&&e[i].type===t.EnumCapturedResultItemType.CRIT_TEXT_LINE&&e[i].duplicate&&(e[i].isFilter=!0)}onDetectedQuadsReceived(e){if(this.isResultCrossVerificationEnabled(t.EnumCapturedResultItemType.CRIT_DETECTED_QUAD))for(let i=0;i<e.length;i++)e[i]&&e[i].type===t.EnumCapturedResultItemType.CRIT_DETECTED_QUAD&&!e[i].verified&&(e[i].isFilter=!0);if(this.isResultDeduplicationEnabled(t.EnumCapturedResultItemType.CRIT_DETECTED_QUAD))for(let i=0;i<e.length;i++)e[i]&&e[i].type===t.EnumCapturedResultItemType.CRIT_DETECTED_QUAD&&e[i].duplicate&&(e[i].isFilter=!0)}onNormalizedImagesReceived(e){if(this.isResultCrossVerificationEnabled(t.EnumCapturedResultItemType.CRIT_NORMALIZED_IMAGE))for(let i=0;i<e.length;i++)e[i]&&e[i].type===t.EnumCapturedResultItemType.CRIT_NORMALIZED_IMAGE&&!e[i].verified&&(e[i].isFilter=!0);if(this.isResultDeduplicationEnabled(t.EnumCapturedResultItemType.CRIT_NORMALIZED_IMAGE))for(let i=0;i<e.length;i++)e[i]&&e[i].type===t.EnumCapturedResultItemType.CRIT_NORMALIZED_IMAGE&&e[i].duplicate&&(e[i].isFilter=!0)}},e.UtilityModule=class{static getVersion(){return"1.2.10(Worker: No Worker, Wasm: No Wasm)"}},e._getNorImageData=l,e._saveToFile=i,e._toBlob=n,e._toCanvas=r,e._toImage=(e,t)=>{const i=r(t);let n=new Image,l=i.toDataURL(e);return n.src=l,n},Object.defineProperty(e,"__esModule",{value:!0})}));
