/*!
 * Dynamsoft JavaScript Library
 * @product Dynamsoft License JS Edition
 * @website https://www.dynamsoft.com
 * @copyright Copyright 2024, Dynamsoft Corporation
 * @author Dynamsoft
 * @version 3.2.10
 * @fileoverview Dynamsoft JavaScript Library for Core
 * More info DL JS: https://www.dynamsoft.com/capture-vision/docs/web/programming/javascript/api-reference/license/license-module.html
 */
import{mapPackageRegister as e,loadWasm as t,doOrWaitAsyncDependency as s,getNextTaskID as r,mapTaskCallBack as i,onLog as n,CoreModule as a,engineResourcePaths as o,waitAsyncDependency as l,worker as c,mapAsyncDependency as d,workerAutoResources as u,compareVersion as f,innerVersions as h}from"dynamsoft-core";const m="undefined"==typeof self,g=m?{}:self,p=(()=>{if(!m&&document.currentScript){let e=document.currentScript.src,t=e.indexOf("?");if(-1!=t)e=e.substring(0,t);else{let t=e.indexOf("#");-1!=t&&(e=e.substring(0,t))}return e.substring(0,e.lastIndexOf("/")+1)}return"./"})(),y=e=>{if(null==e&&(e="./"),m);else{let t=document.createElement("a");t.href=e,e=t.href}return e.endsWith("/")||(e+="/"),e},v=e=>e&&"object"==typeof e&&"function"==typeof e.then;class w extends Promise{constructor(e){let t,s;super(((e,r)=>{t=e,s=r})),this._s="pending",this.resolve=e=>{this.isPending&&(v(e)?this.task=e:(this._s="fulfilled",t(e)))},this.reject=e=>{this.isPending&&(this._s="rejected",s(e))},this.task=e}get status(){return this._s}get isPending(){return"pending"===this._s}get isFulfilled(){return"fulfilled"===this._s}get isRejected(){return"rejected"===this._s}get task(){return this._task}set task(e){let t;this._task=e,v(e)?t=e:"function"==typeof e&&(t=new Promise(e)),t&&(async()=>{try{const s=await t;e===this._task&&this.resolve(s)}catch(t){e===this._task&&this.reject(t)}})()}get isEmpty(){return null==this._task}}const b=" is not allowed to change after `createInstance` or `loadWasm` is called.",S=!m&&document.currentScript&&(document.currentScript.getAttribute("data-license")||document.currentScript.getAttribute("data-productKeys")||document.currentScript.getAttribute("data-licenseKey")||document.currentScript.getAttribute("data-handshakeCode")||document.currentScript.getAttribute("data-organizationID"))||"",_=(e,t)=>{const s=e;if(!s._pLoad.isEmpty)throw new Error("`license`"+b);s._license=t};!m&&document.currentScript&&document.currentScript.getAttribute("data-sessionPassword");const k=e=>{if(null==e)e=[];else{e=e instanceof Array?[...e]:[e];for(let t=0;t<e.length;++t){if(!m){let s=document.createElement("a");s.href=e[t],e[t]=s.href}e[t].endsWith("/")||(e[t]+="/")}}return e},E=(e,t)=>{const s=e;if(!s._pLoad.isEmpty)throw new Error("`licenseServer`"+b);s._licenseServer=k(t)},L=(e,t)=>{const s=e;if(!s._pLoad.isEmpty)throw new Error("`deviceFriendlyName`"+b);s._deviceFriendlyName=t||""};let O,C,x,P,N;"undefined"!=typeof navigator&&(O=navigator,C=O.userAgent,x=O.platform,P=O.mediaDevices),function(){if(!m){const e={Edge:{search:"Edg",verSearch:"Edg"},OPR:null,Chrome:null,Safari:{str:O.vendor,search:"Apple",verSearch:["Version","iPhone OS","CPU OS"]},Firefox:null,Explorer:{search:"MSIE",verSearch:"MSIE"}},t={HarmonyOS:null,Android:null,iPhone:null,iPad:null,Windows:{str:x,search:"Win"},Mac:{str:x},Linux:{str:x}};let s="unknownBrowser",r=0,i="unknownOS";for(let t in e){const i=e[t]||{};let n=i.str||C,a=i.search||t,o=i.verStr||C,l=i.verSearch||t;if(l instanceof Array||(l=[l]),-1!=n.indexOf(a)){s=t;for(let e of l){let t=o.indexOf(e);if(-1!=t){r=parseFloat(o.substring(t+e.length+1));break}}break}}for(let e in t){const s=t[e]||{};let r=s.str||C,n=s.search||e;if(-1!=r.indexOf(n)){i=e;break}}"Linux"==i&&-1!=C.indexOf("Windows NT")&&(i="HarmonyOS"),N={browser:s,version:r,OS:i}}m&&(N={browser:"ssr",version:0,OS:"ssr"})}(),"undefined"!=typeof WebAssembly&&C&&(!/Safari/.test(C)||/Chrome/.test(C)||/\(.+\s11_2_([2-6]).*\)/.test(C)),P&&P.getUserMedia,"Chrome"===N.browser&&N.version>66||"Safari"===N.browser&&N.version>13||"OPR"===N.browser&&N.version>43||"Edge"===N.browser&&N.version;const W=async()=>(t("license"),s("dynamsoft_inited",(async()=>{let{lt:e,l:t,ls:s,sp:d,rmk:u,cv:f}=((e,t=!1)=>{const s=e;if(s._pLoad.isEmpty){let e,r,i,n=s._license||"",a=JSON.parse(JSON.stringify(s._licenseServer)),o=s._sessionPassword,l=0;if(n.startsWith("t")||n.startsWith("f"))l=0;else if(0===n.length||n.startsWith("P")||n.startsWith("L")||n.startsWith("Y")||n.startsWith("A"))l=1;else{l=2;const t=n.indexOf(":");-1!=t&&(n=n.substring(t+1));const s=n.indexOf("?");if(-1!=s&&(r=n.substring(s+1),n=n.substring(0,s)),n.startsWith("DLC2"))l=0;else{if(n.startsWith("DLS2")){let t;try{let e=n.substring(4);e=atob(e),t=JSON.parse(e)}catch(e){throw new Error("Format Error: The license string you specified is invalid, please check to make sure it is correct.")}if(n=t.handshakeCode?t.handshakeCode:t.organizationID?t.organizationID:"","number"==typeof n&&(n=JSON.stringify(n)),0===a.length){let e=[];t.mainServerURL&&(e[0]=t.mainServerURL),t.standbyServerURL&&(e[1]=t.standbyServerURL),a=k(e)}!o&&t.sessionPassword&&(o=t.sessionPassword),e=t.remark}n&&"200001"!==n&&!n.startsWith("200001-")||(l=1)}}if(l&&(t||(g.crypto||(i="Please upgrade your browser to support online key."),g.crypto.subtle||(i="Require https to use online key in this browser."))),i){if(1!==l)throw new Error(i);l=0,console.warn(i),s._lastErrorCode=-1,s._lastErrorString=i}return 1===l&&(n="",console.warn("Applying for a public trial license ...")),{lt:l,l:n,ls:a,sp:o,rmk:e,cv:r}}throw new Error("Can't preprocess license again"+b)})(D),h=new w;D._pLoad.task=h,(async()=>{try{await D._pLoad}catch(e){}})();let m=r();i[m]=t=>{if(t.message&&D._onAuthMessage){let e=D._onAuthMessage(t.message);null!=e&&(t.message=e)}let s,r=!1;if(1===e&&(r=!0),t.success?(n&&n("init license success"),t.message&&console.warn(t.message),a._bSupportIRTModule=t.bSupportIRTModule,a._bSupportDce4Module=t.bSupportDce4Module,D.bPassValidation=!0):(s=Error(t.message),t.stack&&(s.stack=t.stack),t.ltsErrorCode&&(s.ltsErrorCode=t.ltsErrorCode),r||111==t.ltsErrorCode&&-1!=t.message.toLowerCase().indexOf("trial license")&&(r=!0)),r){let e=o.license;o.rootDirectory&&(e=o.rootDirectory+"/"+e),e=y(e),(async(e,t,s)=>{if(!e._bNeverShowDialog)try{let r=await fetch(e.engineResourcePath+"dls.license.dialog.html");if(!r.ok)throw Error("Get license dialog fail. Network Error: "+r.statusText);let i=await r.text();if(!i.trim().startsWith("<"))throw Error("Get license dialog fail. Can't get valid HTMLElement.");let n=document.createElement("div");n.innerHTML=i;let a=[];for(let e=0;e<n.childElementCount;++e){let t=n.children[e];t instanceof HTMLStyleElement&&(a.push(t),document.head.append(t))}let o=1==n.childElementCount?n.children[0]:n;o.remove();let l,c,d,u,f,h=[o],m=o.children;for(let e of m)h.push(e);for(let e=0;e<h.length;++e)for(let t of h[e].children)h.push(t);for(let e of h)if(!l&&e.classList.contains("dls-license-mask"))l=e,e.addEventListener("click",(t=>{if(e==t.target){o.remove();for(let e of a)e.remove()}}));else if(!c&&e.classList.contains("dls-license-icon-close"))c=e,e.addEventListener("click",(()=>{o.remove();for(let e of a)e.remove()}));else if(!d&&e.classList.contains("dls-license-icon-error"))d=e,"error"!=t&&e.remove();else if(!u&&e.classList.contains("dls-license-icon-warn"))u=e,"warn"!=t&&e.remove();else if(!f&&e.classList.contains("dls-license-msg-content")){f=e;let t=s;for(;t;){let s=t.indexOf("["),r=t.indexOf("]",s),i=t.indexOf("(",r),n=t.indexOf(")",i);if(-1==s||-1==r||-1==i||-1==n){e.appendChild(new Text(t));break}s>0&&e.appendChild(new Text(t.substring(0,s)));let a=document.createElement("a"),o=t.substring(s+1,r);a.innerText=o;let l=t.substring(i+1,n);a.setAttribute("href",l),a.setAttribute("target","_blank"),e.appendChild(a),t=t.substring(n+1)}}document.body.appendChild(o)}catch(t){e._onLog&&e._onLog(t.message||t)}})({_bNeverShowDialog:D._bNeverShowDialog,engineResourcePath:e,_onLog:n},t.success?"warn":"error",t.message)}t.success?h.resolve(void 0):h.reject(s)},await l("worker"),c.postMessage({type:"dynamsoft",body:{v:"3.2.10",brtk:!!e,bptk:1===e,l:t,os:N,fn:D.deviceFriendlyName,ls:s,sp:d,rmk:u,cv:f},id:m}),D.bCallInitLicense=!0,await h})));let A;e.license={},e.license.dynamsoft=W,e.license.getAR=async()=>{{let e=d.dynamsoft_inited;e&&e.isRejected&&await e}return c?new Promise(((e,t)=>{let s=r();i[s]=async s=>{if(s.success){delete s.success;{let e=D.license;e&&(e.startsWith("t")||e.startsWith("f"))&&(s.pk=e)}if(Object.keys(s).length){if(s.lem){let e=Error(s.lem);e.ltsErrorCode=s.lec,delete s.lem,delete s.lec,s.ae=e}e(s)}else e(null)}else{let e=Error(s.message);s.stack&&(e.stack=s.stack),t(e)}},c.postMessage({type:"getAR",id:s})})):null};class D{static setLicenseServer(e){E(D,e)}static get license(){return this._license}static set license(e){_(D,e)}static get licenseServer(){return this._licenseServer}static set licenseServer(e){E(D,e)}static get deviceFriendlyName(){return this._deviceFriendlyName}static set deviceFriendlyName(e){L(D,e)}static initLicense(e,t){if(_(D,e),D.bCallInitLicense=!0,t)return W()}static setDeviceFriendlyName(e){L(D,e)}static getDeviceFriendlyName(){return D._deviceFriendlyName}static getDeviceUUID(){return(async()=>(await s("dynamsoft_uuid",(async()=>{await t();let e=new w,s=r();i[s]=t=>{if(t.success)e.resolve(t.uuid);else{const s=Error(t.message);t.stack&&(s.stack=t.stack),e.reject(s)}},c.postMessage({type:"getDeviceUUID",id:s}),A=await e})),A))()}}D._pLoad=new w,D.bPassValidation=!1,D.bCallInitLicense=!1,D._license=S,D._licenseServer=[],D._deviceFriendlyName="",null==o.license&&(o.license=p),u.license={wasm:!0},e.license.LicenseManager=D;const M="1.2.0";"string"!=typeof o.std&&f(o.std.version,M)<0&&(o.std={version:M,path:y(p+`../../dynamsoft-capture-vision-std@${M}/dist/`)});class R{static getVersion(){return`3.2.10(Worker: ${h.license&&h.license.worker||"Not Loaded"}, Wasm: ${h.license&&h.license.wasm||"Not Loaded"})`}}export{D as LicenseManager,R as LicenseModule};
