/*!
 * Dynamsoft JavaScript Library
 * @product Dynamsoft Core JS Edition
 * @website https://www.dynamsoft.com
 * @copyright Copyright 2024, Dynamsoft Corporation
 * @author Dynamsoft
 * @version 3.2.10
 * @fileoverview Dynamsoft JavaScript Library for Core
 * More info on Dynamsoft Core JS: https://www.dynamsoft.com/capture-vision/docs/web/programming/javascript/api-reference/core/core-module.html
 */
function _(_,E,e,I){if("a"===e&&!I)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof E?_!==E||!I:!E.has(_))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===e?I:"a"===e?I.call(_):I?I.value:E.get(_)}function E(_,E,e,I,t){if("m"===I)throw new TypeError("Private method is not writable");if("a"===I&&!t)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof E?_!==E||!t:!E.has(_))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===I?t.call(_,e):t?t.value=e:E.set(_,e),e}var e,I,t;"function"==typeof SuppressedError&&SuppressedError,function(_){_[_.BOPM_BLOCK=0]="BOPM_BLOCK",_[_.BOPM_UPDATE=1]="BOPM_UPDATE"}(e||(e={})),function(_){_[_.CCUT_AUTO=0]="CCUT_AUTO",_[_.CCUT_FULL_CHANNEL=1]="CCUT_FULL_CHANNEL",_[_.CCUT_Y_CHANNEL_ONLY=2]="CCUT_Y_CHANNEL_ONLY",_[_.CCUT_RGB_R_CHANNEL_ONLY=3]="CCUT_RGB_R_CHANNEL_ONLY",_[_.CCUT_RGB_G_CHANNEL_ONLY=4]="CCUT_RGB_G_CHANNEL_ONLY",_[_.CCUT_RGB_B_CHANNEL_ONLY=5]="CCUT_RGB_B_CHANNEL_ONLY"}(I||(I={})),function(_){_[_.IPF_BINARY=0]="IPF_BINARY",_[_.IPF_BINARYINVERTED=1]="IPF_BINARYINVERTED",_[_.IPF_GRAYSCALED=2]="IPF_GRAYSCALED",_[_.IPF_NV21=3]="IPF_NV21",_[_.IPF_RGB_565=4]="IPF_RGB_565",_[_.IPF_RGB_555=5]="IPF_RGB_555",_[_.IPF_RGB_888=6]="IPF_RGB_888",_[_.IPF_ARGB_8888=7]="IPF_ARGB_8888",_[_.IPF_RGB_161616=8]="IPF_RGB_161616",_[_.IPF_ARGB_16161616=9]="IPF_ARGB_16161616",_[_.IPF_ABGR_8888=10]="IPF_ABGR_8888",_[_.IPF_ABGR_16161616=11]="IPF_ABGR_16161616",_[_.IPF_BGR_888=12]="IPF_BGR_888",_[_.IPF_BINARY_8=13]="IPF_BINARY_8",_[_.IPF_NV12=14]="IPF_NV12",_[_.IPF_BINARY_8_INVERTED=15]="IPF_BINARY_8_INVERTED"}(t||(t={}));const C=_=>Object.prototype.toString.call(_),s=_=>Array.isArray?Array.isArray(_):"[object Array]"===C(_),A=_=>"[object Boolean]"===C(_),r=_=>"number"==typeof _&&!Number.isNaN(_),T=_=>null!==_&&"object"==typeof _&&!Array.isArray(_),R=_=>!!T(_)&&(!!r(_.x)&&(!!r(_.y)&&(!!r(_.radius)&&(!(_.radius<0)&&(!!r(_.startAngle)&&!!r(_.endAngle)))))),N=_=>!!T(_)&&(!!s(_.points)&&(0!=_.points.length&&!_.points.some((_=>!D(_))))),n=_=>!!T(_)&&(_.bytes instanceof Uint8Array&&(!!r(_.width)&&(!(_.width<=0)&&(!!r(_.height)&&(!(_.height<=0)&&(!!r(_.stride)&&(!(_.stride<=0)&&("format"in _&&!("tag"in _&&!o(_.tag)))))))))),i=_=>!!T(_)&&(!!r(_.left)&&(!(_.left<0)&&(!!r(_.top)&&(!(_.top<0)&&(!!r(_.right)&&(!(_.right<0)&&(!!r(_.bottom)&&(!(_.bottom<0)&&(!(_.left>=_.right)&&(!(_.top>=_.bottom)&&!!A(_.isMeasuredInPercentage))))))))))),o=_=>!!T(_)&&(!!r(_.imageId)&&"type"in _),L=_=>!!T(_)&&(!!D(_.startPoint)&&(!!D(_.endPoint)&&(_.startPoint.x!=_.endPoint.x||_.startPoint.y!=_.endPoint.y))),D=_=>!!T(_)&&(!!r(_.x)&&!!r(_.y)),a=_=>!!T(_)&&(!!s(_.points)&&(0!=_.points.length&&!_.points.some((_=>!D(_))))),O=_=>!!T(_)&&(!!s(_.points)&&(0!=_.points.length&&4==_.points.length&&!_.points.some((_=>!D(_))))),S=_=>!!T(_)&&(!!r(_.x)&&(!!r(_.y)&&(!!r(_.width)&&(!(_.width<0)&&(!!r(_.height)&&(!(_.height<0)&&!("isMeasuredInPercentage"in _&&!A(_.isMeasuredInPercentage))))))));async function c(_,E){return await new Promise(((e,I)=>{let t=new XMLHttpRequest;t.open("GET",_,!0),t.responseType=E,t.send(),t.onloadend=async()=>{e(t.response)},t.onerror=()=>{I(new Error("Network Error: "+t.statusText))}}))}function M(_){return/^(https:\/\/www\.|http:\/\/www\.|https:\/\/|http:\/\/)|^[a-zA-Z0-9]{2,}(\.[a-zA-Z0-9]{2,})(\.[a-zA-Z0-9]{2,})?/.test(_)}const l=(_,E)=>{let e=_.split("."),I=E.split(".");for(let _=0;_<e.length&&_<I.length;++_){let E=e[_],t=I[_];if(E===t)continue;let C=parseInt(e[_]),s=parseInt(I[_]);return C===s||Number.isNaN(C)&&Number.isNaN(s)?E<t?-1:1:C<s||Number.isNaN(C)&&Number.isInteger(s)?-1:1}return e.length===I.length?0:e.length<I.length?-1:1},P="function"==typeof BigInt;var h,U,G,f,u,d,F,g;class B{get _isFetchingStarted(){return _(this,u,"f")}constructor(){h.add(this),U.set(this,[]),G.set(this,1),f.set(this,e.BOPM_BLOCK),u.set(this,!1),d.set(this,void 0),F.set(this,I.CCUT_AUTO)}setErrorListener(_){}addImageToBuffer(E){var I;if(!n(E))throw new TypeError("Invalid 'image'.");if((null===(I=E.tag)||void 0===I?void 0:I.hasOwnProperty("imageId"))&&"number"==typeof E.tag.imageId&&this.hasImage(E.tag.imageId))throw new Error("Existed imageId.");if(_(this,U,"f").length>=_(this,G,"f"))switch(_(this,f,"f")){case e.BOPM_BLOCK:break;case e.BOPM_UPDATE:if(_(this,U,"f").push(E),T(_(this,d,"f"))&&r(_(this,d,"f").imageId)&&1==_(this,d,"f").keepInBuffer)for(;_(this,U,"f").length>_(this,G,"f");){const E=_(this,U,"f").findIndex((E=>{var e;return(null===(e=E.tag)||void 0===e?void 0:e.imageId)!==_(this,d,"f").imageId}));_(this,U,"f").splice(E,1)}else _(this,U,"f").splice(0,_(this,U,"f").length-_(this,G,"f"))}else _(this,U,"f").push(E)}getImage(){if(0===_(this,U,"f").length)return null;let E;if(_(this,d,"f")&&r(_(this,d,"f").imageId)){const e=_(this,h,"m",g).call(this,_(this,d,"f").imageId);if(e<0)throw new Error(`Image with id ${_(this,d,"f").imageId} doesn't exist.`);E=_(this,U,"f").slice(e,e+1)[0]}else E=_(this,U,"f").pop();if([t.IPF_RGB_565,t.IPF_RGB_555,t.IPF_RGB_888,t.IPF_ARGB_8888,t.IPF_RGB_161616,t.IPF_ARGB_16161616,t.IPF_ABGR_8888,t.IPF_ABGR_16161616,t.IPF_BGR_888].includes(E.format)){if(_(this,F,"f")===I.CCUT_RGB_R_CHANNEL_ONLY){B._onLog&&B._onLog("only get R channel data.");const _=new Uint8Array(E.width*E.height);for(let e=0;e<_.length;e++)switch(E.format){case t.IPF_RGB_565:case t.IPF_RGB_555:case t.IPF_RGB_888:case t.IPF_RGB_161616:_[e]=E.bytes[3*e+2];break;case t.IPF_ARGB_8888:case t.IPF_ARGB_16161616:_[e]=E.bytes[4*e+2];break;case t.IPF_BGR_888:_[e]=E.bytes[3*e];break;case t.IPF_ABGR_8888:case t.IPF_ABGR_16161616:_[e]=E.bytes[4*e]}E.bytes=_,E.stride=E.width,E.format=t.IPF_GRAYSCALED}else if(_(this,F,"f")===I.CCUT_RGB_G_CHANNEL_ONLY){B._onLog&&B._onLog("only get G channel data.");const _=new Uint8Array(E.width*E.height);for(let e=0;e<_.length;e++)switch(E.format){case t.IPF_RGB_565:case t.IPF_RGB_555:case t.IPF_RGB_888:case t.IPF_RGB_161616:case t.IPF_BGR_888:_[e]=E.bytes[3*e+1];break;case t.IPF_ARGB_8888:case t.IPF_ARGB_16161616:case t.IPF_ABGR_8888:case t.IPF_ABGR_16161616:_[e]=E.bytes[4*e+1]}E.bytes=_,E.stride=E.width,E.format=t.IPF_GRAYSCALED}else if(_(this,F,"f")===I.CCUT_RGB_B_CHANNEL_ONLY){B._onLog&&B._onLog("only get B channel data.");const _=new Uint8Array(E.width*E.height);for(let e=0;e<_.length;e++)switch(E.format){case t.IPF_RGB_565:case t.IPF_RGB_555:case t.IPF_RGB_888:case t.IPF_RGB_161616:_[e]=E.bytes[3*e];break;case t.IPF_ARGB_8888:case t.IPF_ARGB_16161616:_[e]=E.bytes[4*e];break;case t.IPF_BGR_888:_[e]=E.bytes[3*e+2];break;case t.IPF_ABGR_8888:case t.IPF_ABGR_16161616:_[e]=E.bytes[4*e+2]}E.bytes=_,E.stride=E.width,E.format=t.IPF_GRAYSCALED}}else[t.IPF_NV21,t.IPF_NV12].includes(E.format)&&B._onLog&&B._onLog("NV21 or NV12 is not supported.");return E}setNextImageToReturn(_,e){if(!((..._)=>0!==_.length&&_.every((_=>r(_))))(_))throw new TypeError("Invalid 'imageId'.");if(void 0!==e&&!A(e))throw new TypeError("Invalid 'keepInBuffer'.");E(this,d,{imageId:_,keepInBuffer:e},"f")}_resetNextReturnedImage(){E(this,d,null,"f")}hasImage(E){return _(this,h,"m",g).call(this,E)>=0}startFetching(){E(this,u,!0,"f")}stopFetching(){E(this,u,!1,"f")}setMaxImageCount(e){if("number"!=typeof e)throw new TypeError("Invalid 'count'.");if(e<1||Math.round(e)!==e)throw new Error("Invalid 'count'.");for(E(this,G,e,"f");_(this,U,"f")&&_(this,U,"f").length>e;)_(this,U,"f").shift()}getMaxImageCount(){return _(this,G,"f")}getImageCount(){return _(this,U,"f").length}clearBuffer(){_(this,U,"f").length=0}isBufferEmpty(){return 0===_(this,U,"f").length}setBufferOverflowProtectionMode(_){E(this,f,_,"f")}getBufferOverflowProtectionMode(){return _(this,f,"f")}setColourChannelUsageType(_){E(this,F,_,"f")}getColourChannelUsageType(){return _(this,F,"f")}}U=new WeakMap,G=new WeakMap,f=new WeakMap,u=new WeakMap,d=new WeakMap,F=new WeakMap,h=new WeakSet,g=function(E){if("number"!=typeof E)throw new TypeError("Invalid 'imageId'.");return _(this,U,"f").findIndex((_=>{var e;return(null===(e=_.tag)||void 0===e?void 0:e.imageId)===E}))};const p="undefined"==typeof self,V=(()=>{if(!p&&document.currentScript){let _=document.currentScript.src,E=_.indexOf("?");if(-1!=E)_=_.substring(0,E);else{let E=_.indexOf("#");-1!=E&&(_=_.substring(0,E))}return _.substring(0,_.lastIndexOf("/")+1)}return"./"})(),w=_=>{if(null==_&&(_="./"),p);else{let E=document.createElement("a");E.href=_,_=E.href}return _.endsWith("/")||(_+="/"),_};let y,m,b,Y,v;"undefined"!=typeof navigator&&(y=navigator,m=y.userAgent,b=y.platform,Y=y.mediaDevices),function(){if(!p){const _={Edge:{search:"Edg",verSearch:"Edg"},OPR:null,Chrome:null,Safari:{str:y.vendor,search:"Apple",verSearch:["Version","iPhone OS","CPU OS"]},Firefox:null,Explorer:{search:"MSIE",verSearch:"MSIE"}},E={HarmonyOS:null,Android:null,iPhone:null,iPad:null,Windows:{str:b,search:"Win"},Mac:{str:b},Linux:{str:b}};let e="unknownBrowser",I=0,t="unknownOS";for(let E in _){const t=_[E]||{};let C=t.str||m,s=t.search||E,A=t.verStr||m,r=t.verSearch||E;if(r instanceof Array||(r=[r]),-1!=C.indexOf(s)){e=E;for(let _ of r){let E=A.indexOf(_);if(-1!=E){I=parseFloat(A.substring(E+_.length+1));break}}break}}for(let _ in E){const e=E[_]||{};let I=e.str||m,C=e.search||_;if(-1!=I.indexOf(C)){t=_;break}}"Linux"==t&&-1!=m.indexOf("Windows NT")&&(t="HarmonyOS"),v={browser:e,version:I,OS:t}}p&&(v={browser:"ssr",version:0,OS:"ssr"})}();const H="undefined"!=typeof WebAssembly&&m&&!(/Safari/.test(m)&&!/Chrome/.test(m)&&/\(.+\s11_2_([2-6]).*\)/.test(m)),k=!("undefined"==typeof Worker),X=!(!Y||!Y.getUserMedia),Z=async()=>{let _=!1;if(X)try{(await Y.getUserMedia({video:!0})).getTracks().forEach((_=>{_.stop()})),_=!0}catch(_){}return _};"Chrome"===v.browser&&v.version>66||"Safari"===v.browser&&v.version>13||"OPR"===v.browser&&v.version>43||"Edge"===v.browser&&v.version;const x=_=>_&&"object"==typeof _&&"function"==typeof _.then;class W extends Promise{constructor(_){let E,e;super(((_,I)=>{E=_,e=I})),this._s="pending",this.resolve=_=>{this.isPending&&(x(_)?this.task=_:(this._s="fulfilled",E(_)))},this.reject=_=>{this.isPending&&(this._s="rejected",e(_))},this.task=_}get status(){return this._s}get isPending(){return"pending"===this._s}get isFulfilled(){return"fulfilled"===this._s}get isRejected(){return"rejected"===this._s}get task(){return this._task}set task(_){let E;this._task=_,x(_)?E=_:"function"==typeof _&&(E=new Promise(_)),E&&(async()=>{try{const e=await E;_===this._task&&this.resolve(e)}catch(E){_===this._task&&this.reject(E)}})()}get isEmpty(){return null==this._task}}const K={},j=_=>{let E=K[_],e=!1;return E?E.isEmpty?E.task=()=>{}:e=!0:E=K[_]=new W((()=>{})),{p:E,justWait:e}},Q=async _=>{let E="string"==typeof _?[_]:_,e=[];for(let _ of E)e.push(K[_]=K[_]||new W);await Promise.all(e)},J=async(_,E)=>{let e,I="string"==typeof _?[_]:_,t=[];for(let _ of I){let I;t.push(I=K[_]=K[_]||new W(e=e||E())),I.isEmpty&&(I.task=e=e||E())}await Promise.all(t)};let z,$=0;const q=()=>$++,__={};let E_;const e_=_=>{E_=_,z&&z.postMessage({type:"setBLog",body:{value:!!_}})};let I_=!1;const t_=_=>{I_=_,z&&z.postMessage({type:"setBDebug",body:{value:!!_}})},C_={},s_={},A_={std:{version:"1.2.0",path:w(V+"../../dynamsoft-capture-vision-std@1.2.0/dist/")},core:{version:"3.2.10",path:V}},r_=new Proxy(A_,{get(_,E,e){let I=Reflect.get(_,E,e);return I&&I.path&&(I=I.path),I}}),T_={dip:{wasm:!0}},R_=async _=>{let E;_ instanceof Array||(_=_?[_]:[]);{let _=K.core;E=!_||_.isEmpty}let e=new Map;for(let E of _){if(E=E.toLowerCase(),"std"==E||"core"==E)continue;if(!T_[E])throw Error("Module '"+E+"' not existed.");let _=T_[E].deps;if(null==_?void 0:_.length)for(let E of _){let _=K[E];e.has(E)||e.set(E,!_||_.isEmpty)}let I=K[E];e.has(E)||e.set(E,!I||I.isEmpty)}let I=[];E&&I.push("core"),I.push(...e.keys()),await J(I,(async()=>{const _=[...e.entries()].filter((_=>_[1])).map((_=>_[0])),I={};for(let _ in r_){if("rootDirectory"==_)continue;let E=r_[_];r_.rootDirectory&&(E.startsWith("http://")||E.startsWith("https://")||(E=r_.rootDirectory+"/"+E)),I[_]=w(E)}const t={};for(let E of _)t[E]=T_[E];const C={engineResourcePaths:I,autoResources:t,names:_};let s=new W;if(E){C.needLoadCore=!0;let _=I.core+N_._workerName;I.rootDirectory&&(_=I.rootDirectory+_),_.startsWith(location.origin)||(_=await fetch(_).then((_=>_.blob())).then((_=>URL.createObjectURL(_)))),z=new Worker(_),z.onerror=_=>{let E=new Error(_.message);s.reject(E)},z.addEventListener("message",(_=>{let E=_.data?_.data:_,e=E.type,I=E.id,t=E.body;switch(e){case"log":E_&&E_(E.message);break;case"task":try{__[I](t),delete __[I]}catch(_){throw delete __[I],_}break;case"event":try{__[I](t)}catch(_){throw _}break;default:console.log(_)}})),C.bLog=!!E_,C.bd=I_,C.dm=location.origin.startsWith("http")?location.origin:"https://localhost"}else await Q("worker");let A=$++;__[A]=_=>{if(_.success)Object.assign(C_,_.versions),"{}"!==JSON.stringify(_.versions)&&(N_._versions=_.versions),s.resolve(void 0);else{const E=Error(_.message);_.stack&&(E.stack=_.stack),s.reject(E)}},z.postMessage({type:"loadWasm",body:C,id:A}),E&&J("worker",(()=>Promise.resolve())),await s}))};class N_{static get engineResourcePaths(){return r_}static set engineResourcePaths(_){Object.assign(A_,_)}static get bSupportDce4Module(){return this._bSupportDce4Module}static get bSupportIRTModule(){return this._bSupportIRTModule}static get versions(){return this._versions}static get _onLog(){return E_}static set _onLog(_){e_(_)}static get _bDebug(){return I_}static set _bDebug(_){t_(_)}static isModuleLoaded(_){return _=(_=_||"core").toLowerCase(),!!K[_]&&K[_].isFulfilled}static async loadWasm(_){return await R_(_)}static async detectEnvironment(){return await(async()=>({wasm:H,worker:k,getUserMedia:X,camera:await Z(),browser:v.browser,version:v.version,OS:v.OS}))()}static async getModuleVersion(){return await new Promise(((_,E)=>{let e=q();__[e]=async e=>{if(e.success)return _(e.versions);{let _=new Error(e.message);return _.stack=e.stack+"\n"+_.stack,E(_)}},z.postMessage({type:"getModuleVersion",id:e})}))}static getVersion(){const _=C_.core&&C_.core.worker,E=C_.core&&C_.core.wasm;return`3.2.10(Worker: ${_||"Not Loaded"}, Wasm: ${E||"Not Loaded"})`}static enableLogging(){B._onLog=console.log,N_._onLog=console.log}static disableLogging(){B._onLog=null,N_._onLog=null}static async cfd(_){return await new Promise(((E,e)=>{let I=q();__[I]=async _=>{if(_.success)return E();{let E=new Error(_.message);return E.stack=_.stack+"\n"+E.stack,e(E)}},z.postMessage({type:"cfd",id:I,body:{count:_}})}))}}var n_,i_,o_,L_,D_,a_,O_,S_,c_,M_,l_;N_._bSupportDce4Module=-1,N_._bSupportIRTModule=-1,N_._versions=null,N_._workerName="core.worker.js",N_.browserInfo=v,function(_){_[_.CRIT_ORIGINAL_IMAGE=1]="CRIT_ORIGINAL_IMAGE",_[_.CRIT_BARCODE=2]="CRIT_BARCODE",_[_.CRIT_TEXT_LINE=4]="CRIT_TEXT_LINE",_[_.CRIT_DETECTED_QUAD=8]="CRIT_DETECTED_QUAD",_[_.CRIT_NORMALIZED_IMAGE=16]="CRIT_NORMALIZED_IMAGE",_[_.CRIT_PARSED_RESULT=32]="CRIT_PARSED_RESULT"}(n_||(n_={})),function(_){_[_.CT_NORMAL_INTERSECTED=0]="CT_NORMAL_INTERSECTED",_[_.CT_T_INTERSECTED=1]="CT_T_INTERSECTED",_[_.CT_CROSS_INTERSECTED=2]="CT_CROSS_INTERSECTED",_[_.CT_NOT_INTERSECTED=3]="CT_NOT_INTERSECTED"}(i_||(i_={})),function(_){_[_.EC_OK=0]="EC_OK",_[_.EC_UNKNOWN=-1e4]="EC_UNKNOWN",_[_.EC_NO_MEMORY=-10001]="EC_NO_MEMORY",_[_.EC_NULL_POINTER=-10002]="EC_NULL_POINTER",_[_.EC_LICENSE_INVALID=-10003]="EC_LICENSE_INVALID",_[_.EC_LICENSE_EXPIRED=-10004]="EC_LICENSE_EXPIRED",_[_.EC_FILE_NOT_FOUND=-10005]="EC_FILE_NOT_FOUND",_[_.EC_FILE_TYPE_NOT_SUPPORTED=-10006]="EC_FILE_TYPE_NOT_SUPPORTED",_[_.EC_BPP_NOT_SUPPORTED=-10007]="EC_BPP_NOT_SUPPORTED",_[_.EC_INDEX_INVALID=-10008]="EC_INDEX_INVALID",_[_.EC_CUSTOM_REGION_INVALID=-10010]="EC_CUSTOM_REGION_INVALID",_[_.EC_IMAGE_READ_FAILED=-10012]="EC_IMAGE_READ_FAILED",_[_.EC_TIFF_READ_FAILED=-10013]="EC_TIFF_READ_FAILED",_[_.EC_DIB_BUFFER_INVALID=-10018]="EC_DIB_BUFFER_INVALID",_[_.EC_PDF_READ_FAILED=-10021]="EC_PDF_READ_FAILED",_[_.EC_PDF_DLL_MISSING=-10022]="EC_PDF_DLL_MISSING",_[_.EC_PAGE_NUMBER_INVALID=-10023]="EC_PAGE_NUMBER_INVALID",_[_.EC_CUSTOM_SIZE_INVALID=-10024]="EC_CUSTOM_SIZE_INVALID",_[_.EC_TIMEOUT=-10026]="EC_TIMEOUT",_[_.EC_JSON_PARSE_FAILED=-10030]="EC_JSON_PARSE_FAILED",_[_.EC_JSON_TYPE_INVALID=-10031]="EC_JSON_TYPE_INVALID",_[_.EC_JSON_KEY_INVALID=-10032]="EC_JSON_KEY_INVALID",_[_.EC_JSON_VALUE_INVALID=-10033]="EC_JSON_VALUE_INVALID",_[_.EC_JSON_NAME_KEY_MISSING=-10034]="EC_JSON_NAME_KEY_MISSING",_[_.EC_JSON_NAME_VALUE_DUPLICATED=-10035]="EC_JSON_NAME_VALUE_DUPLICATED",_[_.EC_TEMPLATE_NAME_INVALID=-10036]="EC_TEMPLATE_NAME_INVALID",_[_.EC_JSON_NAME_REFERENCE_INVALID=-10037]="EC_JSON_NAME_REFERENCE_INVALID",_[_.EC_PARAMETER_VALUE_INVALID=-10038]="EC_PARAMETER_VALUE_INVALID",_[_.EC_DOMAIN_NOT_MATCH=-10039]="EC_DOMAIN_NOT_MATCH",_[_.EC_RESERVED_INFO_NOT_MATCH=-10040]="EC_RESERVED_INFO_NOT_MATCH",_[_.EC_LICENSE_KEY_NOT_MATCH=-10043]="EC_LICENSE_KEY_NOT_MATCH",_[_.EC_REQUEST_FAILED=-10044]="EC_REQUEST_FAILED",_[_.EC_LICENSE_INIT_FAILED=-10045]="EC_LICENSE_INIT_FAILED",_[_.EC_SET_MODE_ARGUMENT_ERROR=-10051]="EC_SET_MODE_ARGUMENT_ERROR",_[_.EC_LICENSE_CONTENT_INVALID=-10052]="EC_LICENSE_CONTENT_INVALID",_[_.EC_LICENSE_KEY_INVALID=-10053]="EC_LICENSE_KEY_INVALID",_[_.EC_LICENSE_DEVICE_RUNS_OUT=-10054]="EC_LICENSE_DEVICE_RUNS_OUT",_[_.EC_GET_MODE_ARGUMENT_ERROR=-10055]="EC_GET_MODE_ARGUMENT_ERROR",_[_.EC_IRT_LICENSE_INVALID=-10056]="EC_IRT_LICENSE_INVALID",_[_.EC_FILE_SAVE_FAILED=-10058]="EC_FILE_SAVE_FAILED",_[_.EC_STAGE_TYPE_INVALID=-10059]="EC_STAGE_TYPE_INVALID",_[_.EC_IMAGE_ORIENTATION_INVALID=-10060]="EC_IMAGE_ORIENTATION_INVALID",_[_.EC_CONVERT_COMPLEX_TEMPLATE_ERROR=-10061]="EC_CONVERT_COMPLEX_TEMPLATE_ERROR",_[_.EC_CALL_REJECTED_WHEN_CAPTURING=-10062]="EC_CALL_REJECTED_WHEN_CAPTURING",_[_.EC_NO_IMAGE_SOURCE=-10063]="EC_NO_IMAGE_SOURCE",_[_.EC_READ_DIRECTORY_FAILED=-10064]="EC_READ_DIRECTORY_FAILED",_[_.EC_MODULE_NOT_FOUND=-10065]="EC_MODULE_NOT_FOUND",_[_.EC_MULTI_PAGES_NOT_SUPPORTED=-10066]="EC_MULTI_PAGES_NOT_SUPPORTED",_[_.EC_FILE_ALREADY_EXISTS=-10067]="EC_FILE_ALREADY_EXISTS",_[_.EC_CREATE_FILE_FAILED=-10068]="EC_CREATE_FILE_FAILED",_[_.EC_IMGAE_DATA_INVALID=-10069]="EC_IMGAE_DATA_INVALID",_[_.EC_IMAGE_SIZE_NOT_MATCH=-10070]="EC_IMAGE_SIZE_NOT_MATCH",_[_.EC_IMAGE_PIXEL_FORMAT_NOT_MATCH=-10071]="EC_IMAGE_PIXEL_FORMAT_NOT_MATCH",_[_.EC_SECTION_LEVEL_RESULT_IRREPLACEABLE=-10072]="EC_SECTION_LEVEL_RESULT_IRREPLACEABLE",_[_.EC_AXIS_DEFINITION_INCORRECT=-10073]="EC_AXIS_DEFINITION_INCORRECT",_[_.EC_RESULT_TYPE_MISMATCH_IRREPLACEABLE=-10074]="EC_RESULT_TYPE_MISMATCH_IRREPLACEABLE",_[_.EC_NO_LICENSE=-2e4]="EC_NO_LICENSE",_[_.EC_HANDSHAKE_CODE_INVALID=-20001]="EC_HANDSHAKE_CODE_INVALID",_[_.EC_LICENSE_BUFFER_FAILED=-20002]="EC_LICENSE_BUFFER_FAILED",_[_.EC_LICENSE_SYNC_FAILED=-20003]="EC_LICENSE_SYNC_FAILED",_[_.EC_DEVICE_NOT_MATCH=-20004]="EC_DEVICE_NOT_MATCH",_[_.EC_BIND_DEVICE_FAILED=-20005]="EC_BIND_DEVICE_FAILED",_[_.EC_INSTANCE_COUNT_OVER_LIMIT=-20008]="EC_INSTANCE_COUNT_OVER_LIMIT",_[_.EC_LICENSE_INIT_SEQUENCE_FAILED=-20009]="EC_LICENSE_INIT_SEQUENCE_FAILED",_[_.EC_TRIAL_LICENSE=-20010]="EC_TRIAL_LICENSE",_[_.EC_FAILED_TO_REACH_DLS=-20200]="EC_FAILED_TO_REACH_DLS",_[_.EC_LICENSE_CACHE_USED=-20012]="EC_LICENSE_CACHE_USED",_[_.EC_BARCODE_FORMAT_INVALID=-30009]="EC_BARCODE_FORMAT_INVALID",_[_.EC_QR_LICENSE_INVALID=-30016]="EC_QR_LICENSE_INVALID",_[_.EC_1D_LICENSE_INVALID=-30017]="EC_1D_LICENSE_INVALID",_[_.EC_PDF417_LICENSE_INVALID=-30019]="EC_PDF417_LICENSE_INVALID",_[_.EC_DATAMATRIX_LICENSE_INVALID=-30020]="EC_DATAMATRIX_LICENSE_INVALID",_[_.EC_CUSTOM_MODULESIZE_INVALID=-30025]="EC_CUSTOM_MODULESIZE_INVALID",_[_.EC_AZTEC_LICENSE_INVALID=-30041]="EC_AZTEC_LICENSE_INVALID",_[_.EC_PATCHCODE_LICENSE_INVALID=-30046]="EC_PATCHCODE_LICENSE_INVALID",_[_.EC_POSTALCODE_LICENSE_INVALID=-30047]="EC_POSTALCODE_LICENSE_INVALID",_[_.EC_DPM_LICENSE_INVALID=-30048]="EC_DPM_LICENSE_INVALID",_[_.EC_FRAME_DECODING_THREAD_EXISTS=-30049]="EC_FRAME_DECODING_THREAD_EXISTS",_[_.EC_STOP_DECODING_THREAD_FAILED=-30050]="EC_STOP_DECODING_THREAD_FAILED",_[_.EC_MAXICODE_LICENSE_INVALID=-30057]="EC_MAXICODE_LICENSE_INVALID",_[_.EC_GS1_DATABAR_LICENSE_INVALID=-30058]="EC_GS1_DATABAR_LICENSE_INVALID",_[_.EC_GS1_COMPOSITE_LICENSE_INVALID=-30059]="EC_GS1_COMPOSITE_LICENSE_INVALID",_[_.EC_DOTCODE_LICENSE_INVALID=-30061]="EC_DOTCODE_LICENSE_INVALID",_[_.EC_PHARMACODE_LICENSE_INVALID=-30062]="EC_PHARMACODE_LICENSE_INVALID",_[_.EC_CHARACTER_MODEL_FILE_NOT_FOUND=-40100]="EC_CHARACTER_MODEL_FILE_NOT_FOUND",_[_.EC_TEXT_LINE_GROUP_LAYOUT_CONFLICT=-40101]="EC_TEXT_LINE_GROUP_LAYOUT_CONFLICT",_[_.EC_TEXT_LINE_GROUP_REGEX_CONFLICT=-40102]="EC_TEXT_LINE_GROUP_REGEX_CONFLICT",_[_.EC_QUADRILATERAL_INVALID=-50057]="EC_QUADRILATERAL_INVALID",_[_.EC_PANORAMA_LICENSE_INVALID=-70060]="EC_PANORAMA_LICENSE_INVALID",_[_.EC_RESOURCE_PATH_NOT_EXIST=-90001]="EC_RESOURCE_PATH_NOT_EXIST",_[_.EC_RESOURCE_LOAD_FAILED=-90002]="EC_RESOURCE_LOAD_FAILED",_[_.EC_CODE_SPECIFICATION_NOT_FOUND=-90003]="EC_CODE_SPECIFICATION_NOT_FOUND",_[_.EC_FULL_CODE_EMPTY=-90004]="EC_FULL_CODE_EMPTY",_[_.EC_FULL_CODE_PREPROCESS_FAILED=-90005]="EC_FULL_CODE_PREPROCESS_FAILED",_[_.EC_ZA_DL_LICENSE_INVALID=-90006]="EC_ZA_DL_LICENSE_INVALID",_[_.EC_AAMVA_DL_ID_LICENSE_INVALID=-90007]="EC_AAMVA_DL_ID_LICENSE_INVALID",_[_.EC_AADHAAR_LICENSE_INVALID=-90008]="EC_AADHAAR_LICENSE_INVALID",_[_.EC_MRTD_LICENSE_INVALID=-90009]="EC_MRTD_LICENSE_INVALID",_[_.EC_VIN_LICENSE_INVALID=-90010]="EC_VIN_LICENSE_INVALID",_[_.EC_CUSTOMIZED_CODE_TYPE_LICENSE_INVALID=-90011]="EC_CUSTOMIZED_CODE_TYPE_LICENSE_INVALID"}(o_||(o_={})),function(_){_[_.GEM_SKIP=0]="GEM_SKIP",_[_.GEM_AUTO=1]="GEM_AUTO",_[_.GEM_GENERAL=2]="GEM_GENERAL",_[_.GEM_GRAY_EQUALIZE=4]="GEM_GRAY_EQUALIZE",_[_.GEM_GRAY_SMOOTH=8]="GEM_GRAY_SMOOTH",_[_.GEM_SHARPEN_SMOOTH=16]="GEM_SHARPEN_SMOOTH",_[_.GEM_REV=-2147483648]="GEM_REV"}(L_||(L_={})),function(_){_[_.GTM_SKIP=0]="GTM_SKIP",_[_.GTM_INVERTED=1]="GTM_INVERTED",_[_.GTM_ORIGINAL=2]="GTM_ORIGINAL",_[_.GTM_AUTO=4]="GTM_AUTO",_[_.GTM_REV=-2147483648]="GTM_REV"}(D_||(D_={})),function(_){_[_.ITT_FILE_IMAGE=0]="ITT_FILE_IMAGE",_[_.ITT_VIDEO_FRAME=1]="ITT_VIDEO_FRAME"}(a_||(a_={})),function(_){_[_.PDFRM_VECTOR=1]="PDFRM_VECTOR",_[_.PDFRM_RASTER=2]="PDFRM_RASTER",_[_.PDFRM_REV=-2147483648]="PDFRM_REV"}(O_||(O_={})),function(_){_[_.RDS_RASTERIZED_PAGES=0]="RDS_RASTERIZED_PAGES",_[_.RDS_EXTRACTED_IMAGES=1]="RDS_EXTRACTED_IMAGES"}(S_||(S_={})),function(_){_[_.IRUT_NULL=0]="IRUT_NULL",_[_.IRUT_COLOUR_IMAGE=1]="IRUT_COLOUR_IMAGE",_[_.IRUT_SCALED_DOWN_COLOUR_IMAGE=2]="IRUT_SCALED_DOWN_COLOUR_IMAGE",_[_.IRUT_GRAYSCALE_IMAGE=4]="IRUT_GRAYSCALE_IMAGE",_[_.IRUT_TRANSOFORMED_GRAYSCALE_IMAGE=8]="IRUT_TRANSOFORMED_GRAYSCALE_IMAGE",_[_.IRUT_ENHANCED_GRAYSCALE_IMAGE=16]="IRUT_ENHANCED_GRAYSCALE_IMAGE",_[_.IRUT_PREDETECTED_REGIONS=32]="IRUT_PREDETECTED_REGIONS",_[_.IRUT_BINARY_IMAGE=64]="IRUT_BINARY_IMAGE",_[_.IRUT_TEXTURE_DETECTION_RESULT=128]="IRUT_TEXTURE_DETECTION_RESULT",_[_.IRUT_TEXTURE_REMOVED_GRAYSCALE_IMAGE=256]="IRUT_TEXTURE_REMOVED_GRAYSCALE_IMAGE",_[_.IRUT_TEXTURE_REMOVED_BINARY_IMAGE=512]="IRUT_TEXTURE_REMOVED_BINARY_IMAGE",_[_.IRUT_CONTOURS=1024]="IRUT_CONTOURS",_[_.IRUT_LINE_SEGMENTS=2048]="IRUT_LINE_SEGMENTS",_[_.IRUT_TEXT_ZONES=4096]="IRUT_TEXT_ZONES",_[_.IRUT_TEXT_REMOVED_BINARY_IMAGE=8192]="IRUT_TEXT_REMOVED_BINARY_IMAGE",_[_.IRUT_CANDIDATE_BARCODE_ZONES=16384]="IRUT_CANDIDATE_BARCODE_ZONES",_[_.IRUT_LOCALIZED_BARCODES=32768]="IRUT_LOCALIZED_BARCODES",_[_.IRUT_SCALED_UP_BARCODE_IMAGE=65536]="IRUT_SCALED_UP_BARCODE_IMAGE",_[_.IRUT_DEFORMATION_RESISTED_BARCODE_IMAGE=131072]="IRUT_DEFORMATION_RESISTED_BARCODE_IMAGE",_[_.IRUT_COMPLEMENTED_BARCODE_IMAGE=262144]="IRUT_COMPLEMENTED_BARCODE_IMAGE",_[_.IRUT_DECODED_BARCODES=524288]="IRUT_DECODED_BARCODES",_[_.IRUT_LONG_LINES=1048576]="IRUT_LONG_LINES",_[_.IRUT_CORNERS=2097152]="IRUT_CORNERS",_[_.IRUT_CANDIDATE_QUAD_EDGES=4194304]="IRUT_CANDIDATE_QUAD_EDGES",_[_.IRUT_DETECTED_QUADS=8388608]="IRUT_DETECTED_QUADS",_[_.IRUT_LOCALIZED_TEXT_LINES=16777216]="IRUT_LOCALIZED_TEXT_LINES",_[_.IRUT_RECOGNIZED_TEXT_LINES=33554432]="IRUT_RECOGNIZED_TEXT_LINES",_[_.IRUT_NORMALIZED_IMAGES=67108864]="IRUT_NORMALIZED_IMAGES",_[_.IRUT_SHORT_LINES=134217728]="IRUT_SHORT_LINES",_[_.IRUT_ALL=268435455]="IRUT_ALL"}(c_||(c_={})),function(_){_[_.ROET_PREDETECTED_REGION=0]="ROET_PREDETECTED_REGION",_[_.ROET_LOCALIZED_BARCODE=1]="ROET_LOCALIZED_BARCODE",_[_.ROET_DECODED_BARCODE=2]="ROET_DECODED_BARCODE",_[_.ROET_LOCALIZED_TEXT_LINE=3]="ROET_LOCALIZED_TEXT_LINE",_[_.ROET_RECOGNIZED_TEXT_LINE=4]="ROET_RECOGNIZED_TEXT_LINE",_[_.ROET_DETECTED_QUAD=5]="ROET_DETECTED_QUAD",_[_.ROET_NORMALIZED_IMAGE=6]="ROET_NORMALIZED_IMAGE",_[_.ROET_SOURCE_IMAGE=7]="ROET_SOURCE_IMAGE",_[_.ROET_TARGET_ROI=8]="ROET_TARGET_ROI"}(M_||(M_={})),function(_){_[_.ST_NULL=0]="ST_NULL",_[_.ST_REGION_PREDETECTION=1]="ST_REGION_PREDETECTION",_[_.ST_BARCODE_LOCALIZATION=2]="ST_BARCODE_LOCALIZATION",_[_.ST_BARCODE_DECODING=3]="ST_BARCODE_DECODING",_[_.ST_TEXT_LINE_LOCALIZATION=4]="ST_TEXT_LINE_LOCALIZATION",_[_.ST_TEXT_LINE_RECOGNITION=5]="ST_TEXT_LINE_RECOGNITION",_[_.ST_DOCUMENT_DETECTION=6]="ST_DOCUMENT_DETECTION",_[_.ST_DOCUMENT_NORMALIZATION=7]="ST_DOCUMENT_NORMALIZATION"}(l_||(l_={}));export{N_ as CoreModule,e as EnumBufferOverflowProtectionMode,n_ as EnumCapturedResultItemType,I as EnumColourChannelUsageType,i_ as EnumCornerType,o_ as EnumErrorCode,L_ as EnumGrayscaleEnhancementMode,D_ as EnumGrayscaleTransformationMode,t as EnumImagePixelFormat,a_ as EnumImageTagType,c_ as EnumIntermediateResultUnitType,O_ as EnumPDFReadingMode,S_ as EnumRasterDataSource,M_ as EnumRegionObjectElementType,l_ as EnumSectionType,B as ImageSourceAdapter,R as _isArc,N as _isContour,n as _isDSImageData,i as _isDSRect,o as _isImageTag,L as _isLineSegment,D as _isPoint,a as _isPolygon,O as _isQuad,S as _isRect,I_ as bDebug,P as bSupportBigInt,M as checkIsLink,l as compareVersion,J as doOrWaitAsyncDependency,A_ as engineResourcePaths,q as getNextTaskID,C_ as innerVersions,R_ as loadWasm,K as mapAsyncDependency,s_ as mapPackageRegister,__ as mapTaskCallBack,j as newAsyncDependency,E_ as onLog,c as requestResource,t_ as setBDebug,e_ as setOnLog,Q as waitAsyncDependency,z as worker,T_ as workerAutoResources};
