/*!
 * Dynamsoft JavaScript Library
 * @product Dynamsoft Core JS Edition
 * @website https://www.dynamsoft.com
 * @copyright Copyright 2024, Dynamsoft Corporation
 * @author Dynamsoft
 * @version 3.2.10
 * @fileoverview Dynamsoft JavaScript Library for Core
 * More info on Dynamsoft Core JS: https://www.dynamsoft.com/capture-vision/docs/web/programming/javascript/api-reference/core/core-module.html
 */
!function(E,_){"object"==typeof exports&&"undefined"!=typeof module?_(exports):"function"==typeof define&&define.amd?define(["exports"],_):_(((E="undefined"!=typeof globalThis?globalThis:E||self).Dynamsoft=E.Dynamsoft||{},E.Dynamsoft.Core={}))}(this,(function(E){"use strict";function _(E,_,e,t){if("a"===e&&!t)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof _?E!==_||!t:!_.has(E))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===e?t:"a"===e?t.call(E):t?t.value:_.get(E)}function e(E,_,e,t,I){if("m"===t)throw new TypeError("Private method is not writable");if("a"===t&&!I)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof _?E!==_||!I:!_.has(E))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===t?I.call(E,e):I?I.value=e:_.set(E,e),e}var t,I,r;"function"==typeof SuppressedError&&SuppressedError,E.EnumBufferOverflowProtectionMode=void 0,(t=E.EnumBufferOverflowProtectionMode||(E.EnumBufferOverflowProtectionMode={}))[t.BOPM_BLOCK=0]="BOPM_BLOCK",t[t.BOPM_UPDATE=1]="BOPM_UPDATE",E.EnumColourChannelUsageType=void 0,(I=E.EnumColourChannelUsageType||(E.EnumColourChannelUsageType={}))[I.CCUT_AUTO=0]="CCUT_AUTO",I[I.CCUT_FULL_CHANNEL=1]="CCUT_FULL_CHANNEL",I[I.CCUT_Y_CHANNEL_ONLY=2]="CCUT_Y_CHANNEL_ONLY",I[I.CCUT_RGB_R_CHANNEL_ONLY=3]="CCUT_RGB_R_CHANNEL_ONLY",I[I.CCUT_RGB_G_CHANNEL_ONLY=4]="CCUT_RGB_G_CHANNEL_ONLY",I[I.CCUT_RGB_B_CHANNEL_ONLY=5]="CCUT_RGB_B_CHANNEL_ONLY",E.EnumImagePixelFormat=void 0,(r=E.EnumImagePixelFormat||(E.EnumImagePixelFormat={}))[r.IPF_BINARY=0]="IPF_BINARY",r[r.IPF_BINARYINVERTED=1]="IPF_BINARYINVERTED",r[r.IPF_GRAYSCALED=2]="IPF_GRAYSCALED",r[r.IPF_NV21=3]="IPF_NV21",r[r.IPF_RGB_565=4]="IPF_RGB_565",r[r.IPF_RGB_555=5]="IPF_RGB_555",r[r.IPF_RGB_888=6]="IPF_RGB_888",r[r.IPF_ARGB_8888=7]="IPF_ARGB_8888",r[r.IPF_RGB_161616=8]="IPF_RGB_161616",r[r.IPF_ARGB_16161616=9]="IPF_ARGB_16161616",r[r.IPF_ABGR_8888=10]="IPF_ABGR_8888",r[r.IPF_ABGR_16161616=11]="IPF_ABGR_16161616",r[r.IPF_BGR_888=12]="IPF_BGR_888",r[r.IPF_BINARY_8=13]="IPF_BINARY_8",r[r.IPF_NV12=14]="IPF_NV12",r[r.IPF_BINARY_8_INVERTED=15]="IPF_BINARY_8_INVERTED";const n=E=>Object.prototype.toString.call(E),o=E=>Array.isArray?Array.isArray(E):"[object Array]"===n(E),s=E=>"[object Boolean]"===n(E),C=E=>"number"==typeof E&&!Number.isNaN(E),a=E=>null!==E&&"object"==typeof E&&!Array.isArray(E),T=E=>!!a(E)&&(E.bytes instanceof Uint8Array&&(!!C(E.width)&&(!(E.width<=0)&&(!!C(E.height)&&(!(E.height<=0)&&(!!C(E.stride)&&(!(E.stride<=0)&&("format"in E&&!("tag"in E&&!A(E.tag)))))))))),A=E=>!!a(E)&&(!!C(E.imageId)&&"type"in E),i=E=>!!a(E)&&(!!C(E.x)&&!!C(E.y));const R="function"==typeof BigInt;var N,L,D,O,S,l,u,m;class c{get _isFetchingStarted(){return _(this,S,"f")}constructor(){N.add(this),L.set(this,[]),D.set(this,1),O.set(this,E.EnumBufferOverflowProtectionMode.BOPM_BLOCK),S.set(this,!1),l.set(this,void 0),u.set(this,E.EnumColourChannelUsageType.CCUT_AUTO)}setErrorListener(E){}addImageToBuffer(e){var t;if(!T(e))throw new TypeError("Invalid 'image'.");if((null===(t=e.tag)||void 0===t?void 0:t.hasOwnProperty("imageId"))&&"number"==typeof e.tag.imageId&&this.hasImage(e.tag.imageId))throw new Error("Existed imageId.");if(_(this,L,"f").length>=_(this,D,"f"))switch(_(this,O,"f")){case E.EnumBufferOverflowProtectionMode.BOPM_BLOCK:break;case E.EnumBufferOverflowProtectionMode.BOPM_UPDATE:if(_(this,L,"f").push(e),a(_(this,l,"f"))&&C(_(this,l,"f").imageId)&&1==_(this,l,"f").keepInBuffer)for(;_(this,L,"f").length>_(this,D,"f");){const E=_(this,L,"f").findIndex((E=>{var e;return(null===(e=E.tag)||void 0===e?void 0:e.imageId)!==_(this,l,"f").imageId}));_(this,L,"f").splice(E,1)}else _(this,L,"f").splice(0,_(this,L,"f").length-_(this,D,"f"))}else _(this,L,"f").push(e)}getImage(){if(0===_(this,L,"f").length)return null;let e;if(_(this,l,"f")&&C(_(this,l,"f").imageId)){const E=_(this,N,"m",m).call(this,_(this,l,"f").imageId);if(E<0)throw new Error(`Image with id ${_(this,l,"f").imageId} doesn't exist.`);e=_(this,L,"f").slice(E,E+1)[0]}else e=_(this,L,"f").pop();if([E.EnumImagePixelFormat.IPF_RGB_565,E.EnumImagePixelFormat.IPF_RGB_555,E.EnumImagePixelFormat.IPF_RGB_888,E.EnumImagePixelFormat.IPF_ARGB_8888,E.EnumImagePixelFormat.IPF_RGB_161616,E.EnumImagePixelFormat.IPF_ARGB_16161616,E.EnumImagePixelFormat.IPF_ABGR_8888,E.EnumImagePixelFormat.IPF_ABGR_16161616,E.EnumImagePixelFormat.IPF_BGR_888].includes(e.format)){if(_(this,u,"f")===E.EnumColourChannelUsageType.CCUT_RGB_R_CHANNEL_ONLY){c._onLog&&c._onLog("only get R channel data.");const _=new Uint8Array(e.width*e.height);for(let t=0;t<_.length;t++)switch(e.format){case E.EnumImagePixelFormat.IPF_RGB_565:case E.EnumImagePixelFormat.IPF_RGB_555:case E.EnumImagePixelFormat.IPF_RGB_888:case E.EnumImagePixelFormat.IPF_RGB_161616:_[t]=e.bytes[3*t+2];break;case E.EnumImagePixelFormat.IPF_ARGB_8888:case E.EnumImagePixelFormat.IPF_ARGB_16161616:_[t]=e.bytes[4*t+2];break;case E.EnumImagePixelFormat.IPF_BGR_888:_[t]=e.bytes[3*t];break;case E.EnumImagePixelFormat.IPF_ABGR_8888:case E.EnumImagePixelFormat.IPF_ABGR_16161616:_[t]=e.bytes[4*t]}e.bytes=_,e.stride=e.width,e.format=E.EnumImagePixelFormat.IPF_GRAYSCALED}else if(_(this,u,"f")===E.EnumColourChannelUsageType.CCUT_RGB_G_CHANNEL_ONLY){c._onLog&&c._onLog("only get G channel data.");const _=new Uint8Array(e.width*e.height);for(let t=0;t<_.length;t++)switch(e.format){case E.EnumImagePixelFormat.IPF_RGB_565:case E.EnumImagePixelFormat.IPF_RGB_555:case E.EnumImagePixelFormat.IPF_RGB_888:case E.EnumImagePixelFormat.IPF_RGB_161616:case E.EnumImagePixelFormat.IPF_BGR_888:_[t]=e.bytes[3*t+1];break;case E.EnumImagePixelFormat.IPF_ARGB_8888:case E.EnumImagePixelFormat.IPF_ARGB_16161616:case E.EnumImagePixelFormat.IPF_ABGR_8888:case E.EnumImagePixelFormat.IPF_ABGR_16161616:_[t]=e.bytes[4*t+1]}e.bytes=_,e.stride=e.width,e.format=E.EnumImagePixelFormat.IPF_GRAYSCALED}else if(_(this,u,"f")===E.EnumColourChannelUsageType.CCUT_RGB_B_CHANNEL_ONLY){c._onLog&&c._onLog("only get B channel data.");const _=new Uint8Array(e.width*e.height);for(let t=0;t<_.length;t++)switch(e.format){case E.EnumImagePixelFormat.IPF_RGB_565:case E.EnumImagePixelFormat.IPF_RGB_555:case E.EnumImagePixelFormat.IPF_RGB_888:case E.EnumImagePixelFormat.IPF_RGB_161616:_[t]=e.bytes[3*t];break;case E.EnumImagePixelFormat.IPF_ARGB_8888:case E.EnumImagePixelFormat.IPF_ARGB_16161616:_[t]=e.bytes[4*t];break;case E.EnumImagePixelFormat.IPF_BGR_888:_[t]=e.bytes[3*t+2];break;case E.EnumImagePixelFormat.IPF_ABGR_8888:case E.EnumImagePixelFormat.IPF_ABGR_16161616:_[t]=e.bytes[4*t+2]}e.bytes=_,e.stride=e.width,e.format=E.EnumImagePixelFormat.IPF_GRAYSCALED}}else[E.EnumImagePixelFormat.IPF_NV21,E.EnumImagePixelFormat.IPF_NV12].includes(e.format)&&c._onLog&&c._onLog("NV21 or NV12 is not supported.");return e}setNextImageToReturn(E,_){if(!((...E)=>0!==E.length&&E.every((E=>C(E))))(E))throw new TypeError("Invalid 'imageId'.");if(void 0!==_&&!s(_))throw new TypeError("Invalid 'keepInBuffer'.");e(this,l,{imageId:E,keepInBuffer:_},"f")}_resetNextReturnedImage(){e(this,l,null,"f")}hasImage(E){return _(this,N,"m",m).call(this,E)>=0}startFetching(){e(this,S,!0,"f")}stopFetching(){e(this,S,!1,"f")}setMaxImageCount(E){if("number"!=typeof E)throw new TypeError("Invalid 'count'.");if(E<1||Math.round(E)!==E)throw new Error("Invalid 'count'.");for(e(this,D,E,"f");_(this,L,"f")&&_(this,L,"f").length>E;)_(this,L,"f").shift()}getMaxImageCount(){return _(this,D,"f")}getImageCount(){return _(this,L,"f").length}clearBuffer(){_(this,L,"f").length=0}isBufferEmpty(){return 0===_(this,L,"f").length}setBufferOverflowProtectionMode(E){e(this,O,E,"f")}getBufferOverflowProtectionMode(){return _(this,O,"f")}setColourChannelUsageType(E){e(this,u,E,"f")}getColourChannelUsageType(){return _(this,u,"f")}}L=new WeakMap,D=new WeakMap,O=new WeakMap,S=new WeakMap,l=new WeakMap,u=new WeakMap,N=new WeakSet,m=function(E){if("number"!=typeof E)throw new TypeError("Invalid 'imageId'.");return _(this,L,"f").findIndex((_=>{var e;return(null===(e=_.tag)||void 0===e?void 0:e.imageId)===E}))};const P="undefined"==typeof self,M=(()=>{if(!P&&document.currentScript){let E=document.currentScript.src,_=E.indexOf("?");if(-1!=_)E=E.substring(0,_);else{let _=E.indexOf("#");-1!=_&&(E=E.substring(0,_))}return E.substring(0,E.lastIndexOf("/")+1)}return"./"})(),g=E=>{if(null==E&&(E="./"),P);else{let _=document.createElement("a");_.href=E,E=_.href}return E.endsWith("/")||(E+="/"),E};let d,f,h,F,U;"undefined"!=typeof navigator&&(d=navigator,f=d.userAgent,h=d.platform,F=d.mediaDevices),function(){if(!P){const E={Edge:{search:"Edg",verSearch:"Edg"},OPR:null,Chrome:null,Safari:{str:d.vendor,search:"Apple",verSearch:["Version","iPhone OS","CPU OS"]},Firefox:null,Explorer:{search:"MSIE",verSearch:"MSIE"}},_={HarmonyOS:null,Android:null,iPhone:null,iPad:null,Windows:{str:h,search:"Win"},Mac:{str:h},Linux:{str:h}};let e="unknownBrowser",t=0,I="unknownOS";for(let _ in E){const I=E[_]||{};let r=I.str||f,n=I.search||_,o=I.verStr||f,s=I.verSearch||_;if(s instanceof Array||(s=[s]),-1!=r.indexOf(n)){e=_;for(let E of s){let _=o.indexOf(E);if(-1!=_){t=parseFloat(o.substring(_+E.length+1));break}}break}}for(let E in _){const e=_[E]||{};let t=e.str||f,r=e.search||E;if(-1!=t.indexOf(r)){I=E;break}}"Linux"==I&&-1!=f.indexOf("Windows NT")&&(I="HarmonyOS"),U={browser:e,version:t,OS:I}}P&&(U={browser:"ssr",version:0,OS:"ssr"})}();const G="undefined"!=typeof WebAssembly&&f&&!(/Safari/.test(f)&&!/Chrome/.test(f)&&/\(.+\s11_2_([2-6]).*\)/.test(f)),p=!("undefined"==typeof Worker),y=!(!F||!F.getUserMedia),B=async()=>{let E=!1;if(y)try{(await F.getUserMedia({video:!0})).getTracks().forEach((E=>{E.stop()})),E=!0}catch(E){}return E};"Chrome"===U.browser&&U.version>66||"Safari"===U.browser&&U.version>13||"OPR"===U.browser&&U.version>43||"Edge"===U.browser&&U.version;const w=E=>E&&"object"==typeof E&&"function"==typeof E.then;class V extends Promise{constructor(E){let _,e;super(((E,t)=>{_=E,e=t})),this._s="pending",this.resolve=E=>{this.isPending&&(w(E)?this.task=E:(this._s="fulfilled",_(E)))},this.reject=E=>{this.isPending&&(this._s="rejected",e(E))},this.task=E}get status(){return this._s}get isPending(){return"pending"===this._s}get isFulfilled(){return"fulfilled"===this._s}get isRejected(){return"rejected"===this._s}get task(){return this._task}set task(E){let _;this._task=E,w(E)?_=E:"function"==typeof E&&(_=new Promise(E)),_&&(async()=>{try{const e=await _;E===this._task&&this.resolve(e)}catch(_){E===this._task&&this.reject(_)}})()}get isEmpty(){return null==this._task}}const b={},v=async E=>{let _="string"==typeof E?[E]:E,e=[];for(let E of _)e.push(b[E]=b[E]||new V);await Promise.all(e)},k=async(E,_)=>{let e,t="string"==typeof E?[E]:E,I=[];for(let E of t){let t;I.push(t=b[E]=b[E]||new V(e=e||_())),t.isEmpty&&(t.task=e=e||_())}await Promise.all(I)};E.worker=void 0;let x=0;const Y=()=>x++,H={};E.onLog=void 0;const X=_=>{E.onLog=_,E.worker&&E.worker.postMessage({type:"setBLog",body:{value:!!_}})};E.bDebug=!1;const Z=_=>{E.bDebug=_,E.worker&&E.worker.postMessage({type:"setBDebug",body:{value:!!_}})},W={},j={std:{version:"1.2.0",path:g(M+"../../dynamsoft-capture-vision-std@1.2.0/dist/")},core:{version:"3.2.10",path:M}},K=new Proxy(j,{get(E,_,e){let t=Reflect.get(E,_,e);return t&&t.path&&(t=t.path),t}}),Q={dip:{wasm:!0}},J=async _=>{let e;_ instanceof Array||(_=_?[_]:[]);{let E=b.core;e=!E||E.isEmpty}let t=new Map;for(let E of _){if(E=E.toLowerCase(),"std"==E||"core"==E)continue;if(!Q[E])throw Error("Module '"+E+"' not existed.");let _=Q[E].deps;if(null==_?void 0:_.length)for(let E of _){let _=b[E];t.has(E)||t.set(E,!_||_.isEmpty)}let e=b[E];t.has(E)||t.set(E,!e||e.isEmpty)}let I=[];e&&I.push("core"),I.push(...t.keys()),await k(I,(async()=>{const _=[...t.entries()].filter((E=>E[1])).map((E=>E[0])),I={};for(let E in K){if("rootDirectory"==E)continue;let _=K[E];K.rootDirectory&&(_.startsWith("http://")||_.startsWith("https://")||(_=K.rootDirectory+"/"+_)),I[E]=g(_)}const r={};for(let E of _)r[E]=Q[E];const n={engineResourcePaths:I,autoResources:r,names:_};let o=new V;if(e){n.needLoadCore=!0;let _=I.core+z._workerName;I.rootDirectory&&(_=I.rootDirectory+_),_.startsWith(location.origin)||(_=await fetch(_).then((E=>E.blob())).then((E=>URL.createObjectURL(E)))),E.worker=new Worker(_),E.worker.onerror=E=>{let _=new Error(E.message);o.reject(_)},E.worker.addEventListener("message",(_=>{let e=_.data?_.data:_,t=e.type,I=e.id,r=e.body;switch(t){case"log":E.onLog&&E.onLog(e.message);break;case"task":try{H[I](r),delete H[I]}catch(E){throw delete H[I],E}break;case"event":try{H[I](r)}catch(E){throw E}break;default:console.log(_)}})),n.bLog=!!E.onLog,n.bd=E.bDebug,n.dm=location.origin.startsWith("http")?location.origin:"https://localhost"}else await v("worker");let s=x++;H[s]=E=>{if(E.success)Object.assign(W,E.versions),"{}"!==JSON.stringify(E.versions)&&(z._versions=E.versions),o.resolve(void 0);else{const _=Error(E.message);E.stack&&(_.stack=E.stack),o.reject(_)}},E.worker.postMessage({type:"loadWasm",body:n,id:s}),e&&k("worker",(()=>Promise.resolve())),await o}))};class z{static get engineResourcePaths(){return K}static set engineResourcePaths(E){Object.assign(j,E)}static get bSupportDce4Module(){return this._bSupportDce4Module}static get bSupportIRTModule(){return this._bSupportIRTModule}static get versions(){return this._versions}static get _onLog(){return E.onLog}static set _onLog(E){X(E)}static get _bDebug(){return E.bDebug}static set _bDebug(E){Z(E)}static isModuleLoaded(E){return E=(E=E||"core").toLowerCase(),!!b[E]&&b[E].isFulfilled}static async loadWasm(E){return await J(E)}static async detectEnvironment(){return await(async()=>({wasm:G,worker:p,getUserMedia:y,camera:await B(),browser:U.browser,version:U.version,OS:U.OS}))()}static async getModuleVersion(){return await new Promise(((_,e)=>{let t=Y();H[t]=async E=>{if(E.success)return _(E.versions);{let _=new Error(E.message);return _.stack=E.stack+"\n"+_.stack,e(_)}},E.worker.postMessage({type:"getModuleVersion",id:t})}))}static getVersion(){const E=W.core&&W.core.worker,_=W.core&&W.core.wasm;return`3.2.10(Worker: ${E||"Not Loaded"}, Wasm: ${_||"Not Loaded"})`}static enableLogging(){c._onLog=console.log,z._onLog=console.log}static disableLogging(){c._onLog=null,z._onLog=null}static async cfd(_){return await new Promise(((e,t)=>{let I=Y();H[I]=async E=>{if(E.success)return e();{let _=new Error(E.message);return _.stack=E.stack+"\n"+_.stack,t(_)}},E.worker.postMessage({type:"cfd",id:I,body:{count:_}})}))}}var $,q,EE,_E,eE,tE,IE,rE,nE,oE,sE;z._bSupportDce4Module=-1,z._bSupportIRTModule=-1,z._versions=null,z._workerName="core.worker.js",z.browserInfo=U,E.EnumCapturedResultItemType=void 0,($=E.EnumCapturedResultItemType||(E.EnumCapturedResultItemType={}))[$.CRIT_ORIGINAL_IMAGE=1]="CRIT_ORIGINAL_IMAGE",$[$.CRIT_BARCODE=2]="CRIT_BARCODE",$[$.CRIT_TEXT_LINE=4]="CRIT_TEXT_LINE",$[$.CRIT_DETECTED_QUAD=8]="CRIT_DETECTED_QUAD",$[$.CRIT_NORMALIZED_IMAGE=16]="CRIT_NORMALIZED_IMAGE",$[$.CRIT_PARSED_RESULT=32]="CRIT_PARSED_RESULT",E.EnumCornerType=void 0,(q=E.EnumCornerType||(E.EnumCornerType={}))[q.CT_NORMAL_INTERSECTED=0]="CT_NORMAL_INTERSECTED",q[q.CT_T_INTERSECTED=1]="CT_T_INTERSECTED",q[q.CT_CROSS_INTERSECTED=2]="CT_CROSS_INTERSECTED",q[q.CT_NOT_INTERSECTED=3]="CT_NOT_INTERSECTED",E.EnumErrorCode=void 0,(EE=E.EnumErrorCode||(E.EnumErrorCode={}))[EE.EC_OK=0]="EC_OK",EE[EE.EC_UNKNOWN=-1e4]="EC_UNKNOWN",EE[EE.EC_NO_MEMORY=-10001]="EC_NO_MEMORY",EE[EE.EC_NULL_POINTER=-10002]="EC_NULL_POINTER",EE[EE.EC_LICENSE_INVALID=-10003]="EC_LICENSE_INVALID",EE[EE.EC_LICENSE_EXPIRED=-10004]="EC_LICENSE_EXPIRED",EE[EE.EC_FILE_NOT_FOUND=-10005]="EC_FILE_NOT_FOUND",EE[EE.EC_FILE_TYPE_NOT_SUPPORTED=-10006]="EC_FILE_TYPE_NOT_SUPPORTED",EE[EE.EC_BPP_NOT_SUPPORTED=-10007]="EC_BPP_NOT_SUPPORTED",EE[EE.EC_INDEX_INVALID=-10008]="EC_INDEX_INVALID",EE[EE.EC_CUSTOM_REGION_INVALID=-10010]="EC_CUSTOM_REGION_INVALID",EE[EE.EC_IMAGE_READ_FAILED=-10012]="EC_IMAGE_READ_FAILED",EE[EE.EC_TIFF_READ_FAILED=-10013]="EC_TIFF_READ_FAILED",EE[EE.EC_DIB_BUFFER_INVALID=-10018]="EC_DIB_BUFFER_INVALID",EE[EE.EC_PDF_READ_FAILED=-10021]="EC_PDF_READ_FAILED",EE[EE.EC_PDF_DLL_MISSING=-10022]="EC_PDF_DLL_MISSING",EE[EE.EC_PAGE_NUMBER_INVALID=-10023]="EC_PAGE_NUMBER_INVALID",EE[EE.EC_CUSTOM_SIZE_INVALID=-10024]="EC_CUSTOM_SIZE_INVALID",EE[EE.EC_TIMEOUT=-10026]="EC_TIMEOUT",EE[EE.EC_JSON_PARSE_FAILED=-10030]="EC_JSON_PARSE_FAILED",EE[EE.EC_JSON_TYPE_INVALID=-10031]="EC_JSON_TYPE_INVALID",EE[EE.EC_JSON_KEY_INVALID=-10032]="EC_JSON_KEY_INVALID",EE[EE.EC_JSON_VALUE_INVALID=-10033]="EC_JSON_VALUE_INVALID",EE[EE.EC_JSON_NAME_KEY_MISSING=-10034]="EC_JSON_NAME_KEY_MISSING",EE[EE.EC_JSON_NAME_VALUE_DUPLICATED=-10035]="EC_JSON_NAME_VALUE_DUPLICATED",EE[EE.EC_TEMPLATE_NAME_INVALID=-10036]="EC_TEMPLATE_NAME_INVALID",EE[EE.EC_JSON_NAME_REFERENCE_INVALID=-10037]="EC_JSON_NAME_REFERENCE_INVALID",EE[EE.EC_PARAMETER_VALUE_INVALID=-10038]="EC_PARAMETER_VALUE_INVALID",EE[EE.EC_DOMAIN_NOT_MATCH=-10039]="EC_DOMAIN_NOT_MATCH",EE[EE.EC_RESERVED_INFO_NOT_MATCH=-10040]="EC_RESERVED_INFO_NOT_MATCH",EE[EE.EC_LICENSE_KEY_NOT_MATCH=-10043]="EC_LICENSE_KEY_NOT_MATCH",EE[EE.EC_REQUEST_FAILED=-10044]="EC_REQUEST_FAILED",EE[EE.EC_LICENSE_INIT_FAILED=-10045]="EC_LICENSE_INIT_FAILED",EE[EE.EC_SET_MODE_ARGUMENT_ERROR=-10051]="EC_SET_MODE_ARGUMENT_ERROR",EE[EE.EC_LICENSE_CONTENT_INVALID=-10052]="EC_LICENSE_CONTENT_INVALID",EE[EE.EC_LICENSE_KEY_INVALID=-10053]="EC_LICENSE_KEY_INVALID",EE[EE.EC_LICENSE_DEVICE_RUNS_OUT=-10054]="EC_LICENSE_DEVICE_RUNS_OUT",EE[EE.EC_GET_MODE_ARGUMENT_ERROR=-10055]="EC_GET_MODE_ARGUMENT_ERROR",EE[EE.EC_IRT_LICENSE_INVALID=-10056]="EC_IRT_LICENSE_INVALID",EE[EE.EC_FILE_SAVE_FAILED=-10058]="EC_FILE_SAVE_FAILED",EE[EE.EC_STAGE_TYPE_INVALID=-10059]="EC_STAGE_TYPE_INVALID",EE[EE.EC_IMAGE_ORIENTATION_INVALID=-10060]="EC_IMAGE_ORIENTATION_INVALID",EE[EE.EC_CONVERT_COMPLEX_TEMPLATE_ERROR=-10061]="EC_CONVERT_COMPLEX_TEMPLATE_ERROR",EE[EE.EC_CALL_REJECTED_WHEN_CAPTURING=-10062]="EC_CALL_REJECTED_WHEN_CAPTURING",EE[EE.EC_NO_IMAGE_SOURCE=-10063]="EC_NO_IMAGE_SOURCE",EE[EE.EC_READ_DIRECTORY_FAILED=-10064]="EC_READ_DIRECTORY_FAILED",EE[EE.EC_MODULE_NOT_FOUND=-10065]="EC_MODULE_NOT_FOUND",EE[EE.EC_MULTI_PAGES_NOT_SUPPORTED=-10066]="EC_MULTI_PAGES_NOT_SUPPORTED",EE[EE.EC_FILE_ALREADY_EXISTS=-10067]="EC_FILE_ALREADY_EXISTS",EE[EE.EC_CREATE_FILE_FAILED=-10068]="EC_CREATE_FILE_FAILED",EE[EE.EC_IMGAE_DATA_INVALID=-10069]="EC_IMGAE_DATA_INVALID",EE[EE.EC_IMAGE_SIZE_NOT_MATCH=-10070]="EC_IMAGE_SIZE_NOT_MATCH",EE[EE.EC_IMAGE_PIXEL_FORMAT_NOT_MATCH=-10071]="EC_IMAGE_PIXEL_FORMAT_NOT_MATCH",EE[EE.EC_SECTION_LEVEL_RESULT_IRREPLACEABLE=-10072]="EC_SECTION_LEVEL_RESULT_IRREPLACEABLE",EE[EE.EC_AXIS_DEFINITION_INCORRECT=-10073]="EC_AXIS_DEFINITION_INCORRECT",EE[EE.EC_RESULT_TYPE_MISMATCH_IRREPLACEABLE=-10074]="EC_RESULT_TYPE_MISMATCH_IRREPLACEABLE",EE[EE.EC_NO_LICENSE=-2e4]="EC_NO_LICENSE",EE[EE.EC_HANDSHAKE_CODE_INVALID=-20001]="EC_HANDSHAKE_CODE_INVALID",EE[EE.EC_LICENSE_BUFFER_FAILED=-20002]="EC_LICENSE_BUFFER_FAILED",EE[EE.EC_LICENSE_SYNC_FAILED=-20003]="EC_LICENSE_SYNC_FAILED",EE[EE.EC_DEVICE_NOT_MATCH=-20004]="EC_DEVICE_NOT_MATCH",EE[EE.EC_BIND_DEVICE_FAILED=-20005]="EC_BIND_DEVICE_FAILED",EE[EE.EC_INSTANCE_COUNT_OVER_LIMIT=-20008]="EC_INSTANCE_COUNT_OVER_LIMIT",EE[EE.EC_LICENSE_INIT_SEQUENCE_FAILED=-20009]="EC_LICENSE_INIT_SEQUENCE_FAILED",EE[EE.EC_TRIAL_LICENSE=-20010]="EC_TRIAL_LICENSE",EE[EE.EC_FAILED_TO_REACH_DLS=-20200]="EC_FAILED_TO_REACH_DLS",EE[EE.EC_LICENSE_CACHE_USED=-20012]="EC_LICENSE_CACHE_USED",EE[EE.EC_BARCODE_FORMAT_INVALID=-30009]="EC_BARCODE_FORMAT_INVALID",EE[EE.EC_QR_LICENSE_INVALID=-30016]="EC_QR_LICENSE_INVALID",EE[EE.EC_1D_LICENSE_INVALID=-30017]="EC_1D_LICENSE_INVALID",EE[EE.EC_PDF417_LICENSE_INVALID=-30019]="EC_PDF417_LICENSE_INVALID",EE[EE.EC_DATAMATRIX_LICENSE_INVALID=-30020]="EC_DATAMATRIX_LICENSE_INVALID",EE[EE.EC_CUSTOM_MODULESIZE_INVALID=-30025]="EC_CUSTOM_MODULESIZE_INVALID",EE[EE.EC_AZTEC_LICENSE_INVALID=-30041]="EC_AZTEC_LICENSE_INVALID",EE[EE.EC_PATCHCODE_LICENSE_INVALID=-30046]="EC_PATCHCODE_LICENSE_INVALID",EE[EE.EC_POSTALCODE_LICENSE_INVALID=-30047]="EC_POSTALCODE_LICENSE_INVALID",EE[EE.EC_DPM_LICENSE_INVALID=-30048]="EC_DPM_LICENSE_INVALID",EE[EE.EC_FRAME_DECODING_THREAD_EXISTS=-30049]="EC_FRAME_DECODING_THREAD_EXISTS",EE[EE.EC_STOP_DECODING_THREAD_FAILED=-30050]="EC_STOP_DECODING_THREAD_FAILED",EE[EE.EC_MAXICODE_LICENSE_INVALID=-30057]="EC_MAXICODE_LICENSE_INVALID",EE[EE.EC_GS1_DATABAR_LICENSE_INVALID=-30058]="EC_GS1_DATABAR_LICENSE_INVALID",EE[EE.EC_GS1_COMPOSITE_LICENSE_INVALID=-30059]="EC_GS1_COMPOSITE_LICENSE_INVALID",EE[EE.EC_DOTCODE_LICENSE_INVALID=-30061]="EC_DOTCODE_LICENSE_INVALID",EE[EE.EC_PHARMACODE_LICENSE_INVALID=-30062]="EC_PHARMACODE_LICENSE_INVALID",EE[EE.EC_CHARACTER_MODEL_FILE_NOT_FOUND=-40100]="EC_CHARACTER_MODEL_FILE_NOT_FOUND",EE[EE.EC_TEXT_LINE_GROUP_LAYOUT_CONFLICT=-40101]="EC_TEXT_LINE_GROUP_LAYOUT_CONFLICT",EE[EE.EC_TEXT_LINE_GROUP_REGEX_CONFLICT=-40102]="EC_TEXT_LINE_GROUP_REGEX_CONFLICT",EE[EE.EC_QUADRILATERAL_INVALID=-50057]="EC_QUADRILATERAL_INVALID",EE[EE.EC_PANORAMA_LICENSE_INVALID=-70060]="EC_PANORAMA_LICENSE_INVALID",EE[EE.EC_RESOURCE_PATH_NOT_EXIST=-90001]="EC_RESOURCE_PATH_NOT_EXIST",EE[EE.EC_RESOURCE_LOAD_FAILED=-90002]="EC_RESOURCE_LOAD_FAILED",EE[EE.EC_CODE_SPECIFICATION_NOT_FOUND=-90003]="EC_CODE_SPECIFICATION_NOT_FOUND",EE[EE.EC_FULL_CODE_EMPTY=-90004]="EC_FULL_CODE_EMPTY",EE[EE.EC_FULL_CODE_PREPROCESS_FAILED=-90005]="EC_FULL_CODE_PREPROCESS_FAILED",EE[EE.EC_ZA_DL_LICENSE_INVALID=-90006]="EC_ZA_DL_LICENSE_INVALID",EE[EE.EC_AAMVA_DL_ID_LICENSE_INVALID=-90007]="EC_AAMVA_DL_ID_LICENSE_INVALID",EE[EE.EC_AADHAAR_LICENSE_INVALID=-90008]="EC_AADHAAR_LICENSE_INVALID",EE[EE.EC_MRTD_LICENSE_INVALID=-90009]="EC_MRTD_LICENSE_INVALID",EE[EE.EC_VIN_LICENSE_INVALID=-90010]="EC_VIN_LICENSE_INVALID",EE[EE.EC_CUSTOMIZED_CODE_TYPE_LICENSE_INVALID=-90011]="EC_CUSTOMIZED_CODE_TYPE_LICENSE_INVALID",E.EnumGrayscaleEnhancementMode=void 0,(_E=E.EnumGrayscaleEnhancementMode||(E.EnumGrayscaleEnhancementMode={}))[_E.GEM_SKIP=0]="GEM_SKIP",_E[_E.GEM_AUTO=1]="GEM_AUTO",_E[_E.GEM_GENERAL=2]="GEM_GENERAL",_E[_E.GEM_GRAY_EQUALIZE=4]="GEM_GRAY_EQUALIZE",_E[_E.GEM_GRAY_SMOOTH=8]="GEM_GRAY_SMOOTH",_E[_E.GEM_SHARPEN_SMOOTH=16]="GEM_SHARPEN_SMOOTH",_E[_E.GEM_REV=-2147483648]="GEM_REV",E.EnumGrayscaleTransformationMode=void 0,(eE=E.EnumGrayscaleTransformationMode||(E.EnumGrayscaleTransformationMode={}))[eE.GTM_SKIP=0]="GTM_SKIP",eE[eE.GTM_INVERTED=1]="GTM_INVERTED",eE[eE.GTM_ORIGINAL=2]="GTM_ORIGINAL",eE[eE.GTM_AUTO=4]="GTM_AUTO",eE[eE.GTM_REV=-2147483648]="GTM_REV",E.EnumImageTagType=void 0,(tE=E.EnumImageTagType||(E.EnumImageTagType={}))[tE.ITT_FILE_IMAGE=0]="ITT_FILE_IMAGE",tE[tE.ITT_VIDEO_FRAME=1]="ITT_VIDEO_FRAME",E.EnumPDFReadingMode=void 0,(IE=E.EnumPDFReadingMode||(E.EnumPDFReadingMode={}))[IE.PDFRM_VECTOR=1]="PDFRM_VECTOR",IE[IE.PDFRM_RASTER=2]="PDFRM_RASTER",IE[IE.PDFRM_REV=-2147483648]="PDFRM_REV",E.EnumRasterDataSource=void 0,(rE=E.EnumRasterDataSource||(E.EnumRasterDataSource={}))[rE.RDS_RASTERIZED_PAGES=0]="RDS_RASTERIZED_PAGES",rE[rE.RDS_EXTRACTED_IMAGES=1]="RDS_EXTRACTED_IMAGES",E.EnumIntermediateResultUnitType=void 0,(nE=E.EnumIntermediateResultUnitType||(E.EnumIntermediateResultUnitType={}))[nE.IRUT_NULL=0]="IRUT_NULL",nE[nE.IRUT_COLOUR_IMAGE=1]="IRUT_COLOUR_IMAGE",nE[nE.IRUT_SCALED_DOWN_COLOUR_IMAGE=2]="IRUT_SCALED_DOWN_COLOUR_IMAGE",nE[nE.IRUT_GRAYSCALE_IMAGE=4]="IRUT_GRAYSCALE_IMAGE",nE[nE.IRUT_TRANSOFORMED_GRAYSCALE_IMAGE=8]="IRUT_TRANSOFORMED_GRAYSCALE_IMAGE",nE[nE.IRUT_ENHANCED_GRAYSCALE_IMAGE=16]="IRUT_ENHANCED_GRAYSCALE_IMAGE",nE[nE.IRUT_PREDETECTED_REGIONS=32]="IRUT_PREDETECTED_REGIONS",nE[nE.IRUT_BINARY_IMAGE=64]="IRUT_BINARY_IMAGE",nE[nE.IRUT_TEXTURE_DETECTION_RESULT=128]="IRUT_TEXTURE_DETECTION_RESULT",nE[nE.IRUT_TEXTURE_REMOVED_GRAYSCALE_IMAGE=256]="IRUT_TEXTURE_REMOVED_GRAYSCALE_IMAGE",nE[nE.IRUT_TEXTURE_REMOVED_BINARY_IMAGE=512]="IRUT_TEXTURE_REMOVED_BINARY_IMAGE",nE[nE.IRUT_CONTOURS=1024]="IRUT_CONTOURS",nE[nE.IRUT_LINE_SEGMENTS=2048]="IRUT_LINE_SEGMENTS",nE[nE.IRUT_TEXT_ZONES=4096]="IRUT_TEXT_ZONES",nE[nE.IRUT_TEXT_REMOVED_BINARY_IMAGE=8192]="IRUT_TEXT_REMOVED_BINARY_IMAGE",nE[nE.IRUT_CANDIDATE_BARCODE_ZONES=16384]="IRUT_CANDIDATE_BARCODE_ZONES",nE[nE.IRUT_LOCALIZED_BARCODES=32768]="IRUT_LOCALIZED_BARCODES",nE[nE.IRUT_SCALED_UP_BARCODE_IMAGE=65536]="IRUT_SCALED_UP_BARCODE_IMAGE",nE[nE.IRUT_DEFORMATION_RESISTED_BARCODE_IMAGE=131072]="IRUT_DEFORMATION_RESISTED_BARCODE_IMAGE",nE[nE.IRUT_COMPLEMENTED_BARCODE_IMAGE=262144]="IRUT_COMPLEMENTED_BARCODE_IMAGE",nE[nE.IRUT_DECODED_BARCODES=524288]="IRUT_DECODED_BARCODES",nE[nE.IRUT_LONG_LINES=1048576]="IRUT_LONG_LINES",nE[nE.IRUT_CORNERS=2097152]="IRUT_CORNERS",nE[nE.IRUT_CANDIDATE_QUAD_EDGES=4194304]="IRUT_CANDIDATE_QUAD_EDGES",nE[nE.IRUT_DETECTED_QUADS=8388608]="IRUT_DETECTED_QUADS",nE[nE.IRUT_LOCALIZED_TEXT_LINES=16777216]="IRUT_LOCALIZED_TEXT_LINES",nE[nE.IRUT_RECOGNIZED_TEXT_LINES=33554432]="IRUT_RECOGNIZED_TEXT_LINES",nE[nE.IRUT_NORMALIZED_IMAGES=67108864]="IRUT_NORMALIZED_IMAGES",nE[nE.IRUT_SHORT_LINES=134217728]="IRUT_SHORT_LINES",nE[nE.IRUT_ALL=268435455]="IRUT_ALL",E.EnumRegionObjectElementType=void 0,(oE=E.EnumRegionObjectElementType||(E.EnumRegionObjectElementType={}))[oE.ROET_PREDETECTED_REGION=0]="ROET_PREDETECTED_REGION",oE[oE.ROET_LOCALIZED_BARCODE=1]="ROET_LOCALIZED_BARCODE",oE[oE.ROET_DECODED_BARCODE=2]="ROET_DECODED_BARCODE",oE[oE.ROET_LOCALIZED_TEXT_LINE=3]="ROET_LOCALIZED_TEXT_LINE",oE[oE.ROET_RECOGNIZED_TEXT_LINE=4]="ROET_RECOGNIZED_TEXT_LINE",oE[oE.ROET_DETECTED_QUAD=5]="ROET_DETECTED_QUAD",oE[oE.ROET_NORMALIZED_IMAGE=6]="ROET_NORMALIZED_IMAGE",oE[oE.ROET_SOURCE_IMAGE=7]="ROET_SOURCE_IMAGE",oE[oE.ROET_TARGET_ROI=8]="ROET_TARGET_ROI",E.EnumSectionType=void 0,(sE=E.EnumSectionType||(E.EnumSectionType={}))[sE.ST_NULL=0]="ST_NULL",sE[sE.ST_REGION_PREDETECTION=1]="ST_REGION_PREDETECTION",sE[sE.ST_BARCODE_LOCALIZATION=2]="ST_BARCODE_LOCALIZATION",sE[sE.ST_BARCODE_DECODING=3]="ST_BARCODE_DECODING",sE[sE.ST_TEXT_LINE_LOCALIZATION=4]="ST_TEXT_LINE_LOCALIZATION",sE[sE.ST_TEXT_LINE_RECOGNITION=5]="ST_TEXT_LINE_RECOGNITION",sE[sE.ST_DOCUMENT_DETECTION=6]="ST_DOCUMENT_DETECTION",sE[sE.ST_DOCUMENT_NORMALIZATION=7]="ST_DOCUMENT_NORMALIZATION",E.CoreModule=z,E.ImageSourceAdapter=c,E._isArc=E=>!!a(E)&&(!!C(E.x)&&(!!C(E.y)&&(!!C(E.radius)&&(!(E.radius<0)&&(!!C(E.startAngle)&&!!C(E.endAngle)))))),E._isContour=E=>!!a(E)&&(!!o(E.points)&&(0!=E.points.length&&!E.points.some((E=>!i(E))))),E._isDSImageData=T,E._isDSRect=E=>!!a(E)&&(!!C(E.left)&&(!(E.left<0)&&(!!C(E.top)&&(!(E.top<0)&&(!!C(E.right)&&(!(E.right<0)&&(!!C(E.bottom)&&(!(E.bottom<0)&&(!(E.left>=E.right)&&(!(E.top>=E.bottom)&&!!s(E.isMeasuredInPercentage))))))))))),E._isImageTag=A,E._isLineSegment=E=>!!a(E)&&(!!i(E.startPoint)&&(!!i(E.endPoint)&&(E.startPoint.x!=E.endPoint.x||E.startPoint.y!=E.endPoint.y))),E._isPoint=i,E._isPolygon=E=>!!a(E)&&(!!o(E.points)&&(0!=E.points.length&&!E.points.some((E=>!i(E))))),E._isQuad=E=>!!a(E)&&(!!o(E.points)&&(0!=E.points.length&&4==E.points.length&&!E.points.some((E=>!i(E))))),E._isRect=E=>!!a(E)&&(!!C(E.x)&&(!!C(E.y)&&(!!C(E.width)&&(!(E.width<0)&&(!!C(E.height)&&(!(E.height<0)&&!("isMeasuredInPercentage"in E&&!s(E.isMeasuredInPercentage)))))))),E.bSupportBigInt=R,E.checkIsLink=function(E){return/^(https:\/\/www\.|http:\/\/www\.|https:\/\/|http:\/\/)|^[a-zA-Z0-9]{2,}(\.[a-zA-Z0-9]{2,})(\.[a-zA-Z0-9]{2,})?/.test(E)},E.compareVersion=(E,_)=>{let e=E.split("."),t=_.split(".");for(let E=0;E<e.length&&E<t.length;++E){let _=e[E],I=t[E];if(_===I)continue;let r=parseInt(e[E]),n=parseInt(t[E]);return r===n||Number.isNaN(r)&&Number.isNaN(n)?_<I?-1:1:r<n||Number.isNaN(r)&&Number.isInteger(n)?-1:1}return e.length===t.length?0:e.length<t.length?-1:1},E.doOrWaitAsyncDependency=k,E.engineResourcePaths=j,E.getNextTaskID=Y,E.innerVersions=W,E.loadWasm=J,E.mapAsyncDependency=b,E.mapPackageRegister={},E.mapTaskCallBack=H,E.newAsyncDependency=E=>{let _=b[E],e=!1;return _?_.isEmpty?_.task=()=>{}:e=!0:_=b[E]=new V((()=>{})),{p:_,justWait:e}},E.requestResource=async function(E,_){return await new Promise(((e,t)=>{let I=new XMLHttpRequest;I.open("GET",E,!0),I.responseType=_,I.send(),I.onloadend=async()=>{e(I.response)},I.onerror=()=>{t(new Error("Network Error: "+I.statusText))}}))},E.setBDebug=Z,E.setOnLog=X,E.waitAsyncDependency=v,E.workerAutoResources=Q,Object.defineProperty(E,"__esModule",{value:!0})}));
