/*!
 * Dynamsoft JavaScript Library
 * @product Dynamsoft Capture Vision Router JS Edition
 * @website http://www.dynamsoft.com
 * @copyright Copyright 2024, Dynamsoft Corporation
 * @author Dynamsoft
 * @version "2.2.10"
 * @fileoverview Dynamsoft JavaScript Library for Capture Vision
 * More info on cvr JS: https://www.dynamsoft.com/capture-vision/docs/web/programming/javascript/api-reference/capture-vision-router/capture-vision-router-module.html
 */
import{engineResourcePaths as e,workerAutoResources as t,mapPackageRegister as s,compareVersion as i,innerVersions as a,EnumCapturedResultItemType as r,CoreModule as n,loadWasm as o,getNextTaskID as c,mapTaskCallBack as d,worker as l,EnumImagePixelFormat as u,EnumColourChannelUsageType as _,_isDSImageData as m,requestResource as h,bSupportBigInt as R,EnumIntermediateResultUnitType as g}from"dynamsoft-core";const I=e=>e&&"object"==typeof e&&"function"==typeof e.then;class p extends Promise{constructor(e){let t,s;super(((e,i)=>{t=e,s=i})),this._s="pending",this.resolve=e=>{this.isPending&&(I(e)?this.task=e:(this._s="fulfilled",t(e)))},this.reject=e=>{this.isPending&&(this._s="rejected",s(e))},this.task=e}get status(){return this._s}get isPending(){return"pending"===this._s}get isFulfilled(){return"fulfilled"===this._s}get isRejected(){return"rejected"===this._s}get task(){return this._task}set task(e){let t;this._task=e,I(e)?t=e:"function"==typeof e&&(t=new Promise(e)),t&&(async()=>{try{const s=await t;e===this._task&&this.resolve(s)}catch(t){e===this._task&&this.reject(t)}})()}get isEmpty(){return null==this._task}}class v{constructor(){this.addResultReceiver=null,this.removeResultReceiver=null,this.getOriginalImage=null}}var T={onTaskResultsReceived:!1,onTaskResultsReceivedForDce:!1,onPredetectedRegionsReceived:!1,onLocalizedBarcodesReceived:!1,onDecodedBarcodesReceived:!1,onLocalizedTextLinesReceived:!1,onRecognizedTextLinesReceived:!1,onDetectedQuadsReceived:!1,onNormalizedImagesReceived:!1,onColourImageUnitReceived:!1,onScaledDownColourImageUnitReceived:!1,onGrayscaleImageUnitReceived:!1,onTransformedGrayscaleImageUnitReceived:!1,onEnhancedGrayscaleImageUnitReceived:!1,onBinaryImageUnitReceived:!1,onTextureDetectionResultUnitReceived:!1,onTextureRemovedGrayscaleImageUnitReceived:!1,onTextureRemovedBinaryImageUnitReceived:!1,onContoursUnitReceived:!1,onLineSegmentsUnitReceived:!1,onTextZonesUnitReceived:!1,onTextRemovedBinaryImageUnitReceived:!1,onLongLinesUnitReceived:!1,onCornersUnitReceived:!1,onCandidateQuadEdgesUnitReceived:!1,onCandidateBarcodeZonesUnitReceived:!1,onScaledUpBarcodeImageUnitReceived:!1,onDeformationResistedBarcodeImageUnitReceived:!1,onComplementedBarcodeImageUnitReceived:!1,onShortLinesUnitReceived:!1};const f="undefined"==typeof self,E=(()=>{if(!f&&document.currentScript){let e=document.currentScript.src,t=e.indexOf("?");if(-1!=t)e=e.substring(0,t);else{let t=e.indexOf("#");-1!=t&&(e=e.substring(0,t))}return e.substring(0,e.lastIndexOf("/")+1)}return"./"})(),y=e=>{if(null==e&&(e="./"),f);else{let t=document.createElement("a");t.href=e,e=t.href}return e.endsWith("/")||(e+="/"),e};var S;null==e.cvr&&(e.cvr=E),t.cvr={js:!0,wasm:!0,deps:["license","dip"]},s.cvr={};const D="1.2.0";"string"!=typeof e.std&&i(e.std.version,D)<0&&(e.std={version:D,path:y(E+`../../dynamsoft-capture-vision-std@${D}/dist/`)});const b="2.2.10";(!e.dip||"string"!=typeof e.dip&&i(e.dip.version,b)<0)&&(e.dip={version:b,path:y(E+`../../dynamsoft-image-processing@${b}/dist/`)});class w{static getVersion(){return this._version}}var C,O;function U(e,t){if(e&&e.location){const s=e.location.points;for(let e of s)e.x=e.x/t,e.y=e.y/t;U(e.referencedItem,t)}}w._version=`2.2.10(Worker: ${null===(S=a.cvr)||void 0===S?void 0:S.worker}, Wasm: loading...`,function(e){e[e.ISS_BUFFER_EMPTY=0]="ISS_BUFFER_EMPTY",e[e.ISS_EXHAUSTED=1]="ISS_EXHAUSTED"}(C||(C={})),function(e){e[e.IRUT_NULL=0]="IRUT_NULL",e[e.IRUT_COLOUR_IMAGE=1]="IRUT_COLOUR_IMAGE",e[e.IRUT_SCALED_DOWN_COLOUR_IMAGE=2]="IRUT_SCALED_DOWN_COLOUR_IMAGE",e[e.IRUT_GRAYSCALE_IMAGE=4]="IRUT_GRAYSCALE_IMAGE",e[e.IRUT_TRANSOFORMED_GRAYSCALE_IMAGE=8]="IRUT_TRANSOFORMED_GRAYSCALE_IMAGE",e[e.IRUT_ENHANCED_GRAYSCALE_IMAGE=16]="IRUT_ENHANCED_GRAYSCALE_IMAGE",e[e.IRUT_PREDETECTED_REGIONS=32]="IRUT_PREDETECTED_REGIONS",e[e.IRUT_BINARY_IMAGE=64]="IRUT_BINARY_IMAGE",e[e.IRUT_TEXTURE_DETECTION_RESULT=128]="IRUT_TEXTURE_DETECTION_RESULT",e[e.IRUT_TEXTURE_REMOVED_GRAYSCALE_IMAGE=256]="IRUT_TEXTURE_REMOVED_GRAYSCALE_IMAGE",e[e.IRUT_TEXTURE_REMOVED_BINARY_IMAGE=512]="IRUT_TEXTURE_REMOVED_BINARY_IMAGE",e[e.IRUT_CONTOURS=1024]="IRUT_CONTOURS",e[e.IRUT_LINE_SEGMENTS=2048]="IRUT_LINE_SEGMENTS",e[e.IRUT_TEXT_ZONES=4096]="IRUT_TEXT_ZONES",e[e.IRUT_TEXT_REMOVED_BINARY_IMAGE=8192]="IRUT_TEXT_REMOVED_BINARY_IMAGE",e[e.IRUT_CANDIDATE_BARCODE_ZONES=16384]="IRUT_CANDIDATE_BARCODE_ZONES",e[e.IRUT_LOCALIZED_BARCODES=32768]="IRUT_LOCALIZED_BARCODES",e[e.IRUT_SCALED_UP_BARCODE_IMAGE=65536]="IRUT_SCALED_UP_BARCODE_IMAGE",e[e.IRUT_DEFORMATION_RESISTED_BARCODE_IMAGE=131072]="IRUT_DEFORMATION_RESISTED_BARCODE_IMAGE",e[e.IRUT_COMPLEMENTED_BARCODE_IMAGE=262144]="IRUT_COMPLEMENTED_BARCODE_IMAGE",e[e.IRUT_DECODED_BARCODES=524288]="IRUT_DECODED_BARCODES",e[e.IRUT_LONG_LINES=1048576]="IRUT_LONG_LINES",e[e.IRUT_CORNERS=2097152]="IRUT_CORNERS",e[e.IRUT_CANDIDATE_QUAD_EDGES=4194304]="IRUT_CANDIDATE_QUAD_EDGES",e[e.IRUT_DETECTED_QUADS=8388608]="IRUT_DETECTED_QUADS",e[e.IRUT_LOCALIZED_TEXT_LINES=16777216]="IRUT_LOCALIZED_TEXT_LINES",e[e.IRUT_RECOGNIZED_TEXT_LINES=33554432]="IRUT_RECOGNIZED_TEXT_LINES",e[e.IRUT_NORMALIZED_IMAGES=67108864]="IRUT_NORMALIZED_IMAGES",e[e.IRUT_SHORT_LINES=134217728]="IRUT_SHORT_LINES",e[e.IRUT_ALL=134217727]="IRUT_ALL"}(O||(O={}));class L{constructor(){this.maxCvsSideLength=["iPhone","Android","HarmonyOS"].includes(n.browserInfo.OS)?2048:4096,this._isa=null,this._dsImage=null,this._instanceID=void 0,this._bPauseScan=!0,this._bNeedOutputOriginalImage=!1,this._canvas=null,this._irrRegistryState=T,this._resultReceiverSet=new Set,this._isaStateListenerSet=new Set,this._resultFilterSet=new Set,this._intermediateResultReceiverSet=new Set,this._intermediateResultManager=null,this._templateName="Default",this._bOpenDetectVerify=!1,this._bOpenNormalizeVerify=!1,this._bOpenBarcodeVerify=!1,this._bOpenLabelVerify=!1,this._minImageCaptureInterval=0,this._averageProcessintTimeArray=[],this._averageFetchImageTimeArray=[],this._currentSettings=null,this._averageTime=999,this._compressRate=0,this._dynamsoft=!1,this.captureInParallel=!0,this.bDestroyed=!1,this._singleFrameModeCallbackBind=this._singleFrameModeCallback.bind(this),this._promiseStartScan=null}get disposed(){return this.bDestroyed}static async createInstance(){if(!s.license)throw Error("Module `license` is not existed.");await s.license.dynamsoft(),await o(["cvr"]);const e=new L,t=new p;let i=c();return d[i]=async s=>{var i;if(s.success)e._instanceID=s.instanceID,e._currentSettings=JSON.parse(s.outputSettings),w._version=`2.2.10(Worker: ${null===(i=a.cvr)||void 0===i?void 0:i.worker}, Wasm: ${s.version})`,0===n.bSupportDce4Module&&(e._intermediateResultManager=e.getIntermediateResultManager(!0)),t.resolve(e);else{const e=Error(s.message);s.stack&&(e.stack=s.stack),t.reject(e)}},l.postMessage({type:"cvr_createInstance",id:i}),t}async _singleFrameModeCallback(e){this._isa.getCameraView().setScanLaserVisible(!0);for(let t of this._resultReceiverSet)this._bNeedOutputOriginalImage&&t.onOriginalImageResultReceived&&t.onOriginalImageResultReceived({imageData:e});const t={bytes:new Uint8Array(e.bytes),width:e.width,height:e.height,stride:e.stride,format:e.format,tag:e.tag},s=await this.capture(t,this._templateName);s.originalImageTag=e.tag;for(let e of this._resultReceiverSet)e.isDce&&e.onCapturedResultReceived(s,{isDetectVerifyOpen:!1,isNormalizeVerifyOpen:!1,isBarcodeVerifyOpen:!1,isLabelVerifyOpen:!1});const i={originalImageHashId:s.originalImageHashId,originalImageTag:s.originalImageTag,errorCode:s.errorCode,errorString:s.errorString};for(let t of this._resultReceiverSet)if(t.onDecodedBarcodesReceived&&s.barcodeResultItems&&t.onDecodedBarcodesReceived(Object.assign(Object.assign({},i),{barcodeResultItems:s.barcodeResultItems})),t.onRecognizedTextLinesReceived&&s.textLineResultItems&&t.onRecognizedTextLinesReceived(Object.assign(Object.assign({},i),{textLineResultItems:s.textLineResultItems})),t.onDetectedQuadsReceived&&s.detectedQuadResultItems&&t.onDetectedQuadsReceived(Object.assign(Object.assign({},i),{detectedQuadResultItems:s.detectedQuadResultItems})),t.onNormalizedImagesReceived&&s.normalizedImageResultItems&&t.onNormalizedImagesReceived(Object.assign(Object.assign({},i),{normalizedImageResultItems:s.normalizedImageResultItems})),t.onParsedResultsReceived&&s.parsedResultItems&&t.onParsedResultsReceived(Object.assign(Object.assign({},i),{parsedResultItems:s.parsedResultItems})),t.onCapturedResultReceived&&!t.isDce){if(this._bNeedOutputOriginalImage){const t=s.items.findIndex((e=>1===e.type));-1!==t&&(s.items[t].imageData=e)}t.onCapturedResultReceived(s)}}setInput(e){if(this._checkIsDisposed(),e){if(this._isa=e,e.isCameraEnhancer){this._intermediateResultManager&&(this._isa._intermediateResultReceiver.isDce=!0,this._intermediateResultManager.addResultReceiver(this._isa._intermediateResultReceiver));const e=this._isa.getCameraView();if(e){const t=e._capturedResultReceiver;t.isDce=!0,this._resultReceiverSet.add(t)}}}else this._isa=null}getInput(){return this._isa}addImageSourceStateListener(e){if(this._checkIsDisposed(),"object"!=typeof e)return console.warn("Invalid ISA state listener.");e&&Object.keys(e)&&this._isaStateListenerSet.add(e)}removeImageSourceStateListener(e){return this._checkIsDisposed(),this._isaStateListenerSet.delete(e)}addResultReceiver(e){if(this._checkIsDisposed(),"object"!=typeof e)throw new Error("Invalid receiver.");e&&Object.keys(e).length&&(this._resultReceiverSet.add(e),this._setCrrRegistry())}removeResultReceiver(e){this._checkIsDisposed(),this._resultReceiverSet.delete(e),this._setCrrRegistry()}async _setCrrRegistry(){const e={onCapturedResultReceived:!1,onDecodedBarcodesReceived:!1,onRecognizedTextLinesReceived:!1,onDetectedQuadsReceived:!1,onNormalizedImagesReceived:!1,onParsedResultsReceived:!1};for(let t of this._resultReceiverSet)t.isDce||(e.onCapturedResultReceived=!!t.onCapturedResultReceived,e.onDecodedBarcodesReceived=!!t.onDecodedBarcodesReceived,e.onRecognizedTextLinesReceived=!!t.onRecognizedTextLinesReceived,e.onDetectedQuadsReceived=!!t.onDetectedQuadsReceived,e.onNormalizedImagesReceived=!!t.onNormalizedImagesReceived,e.onParsedResultsReceived=!!t.onParsedResultsReceived);const t=new p;let s=c();return d[s]=async e=>{if(e.success)t.resolve();else{let s=new Error(e.message);s.stack=e.stack+"\n"+s.stack,t.reject()}},l.postMessage({type:"cvr_setCrrRegistry",id:s,instanceID:this._instanceID,body:{receiver:JSON.stringify(e)}}),t}async addResultFilter(e){if(this._checkIsDisposed(),"object"!=typeof e)return console.warn("Invalid filter.");if(e&&Object.keys(e)){this._resultFilterSet.add(e),this._handleFilterSwitch();for(let e of this._resultFilterSet)await this._enableResultCrossVerification(e.verificationEnabled),await this._enableResultDeduplication(e.duplicateFilterEnabled),await this._setDuplicateForgetTime(e.duplicateForgetTime)}}async removeResultFilter(e){this._checkIsDisposed(),this._resultFilterSet.delete(e),this._handleFilterSwitch();for(let e of this._resultFilterSet)await this._enableResultCrossVerification(e.verificationEnabled),await this._enableResultDeduplication(e.duplicateFilterEnabled),await this._setDuplicateForgetTime(e.duplicateForgetTime)}_handleFilterSwitch(){this._bOpenBarcodeVerify=!1,this._bOpenLabelVerify=!1,this._bOpenDetectVerify=!1,this._bOpenNormalizeVerify=!1;for(let e of this._resultFilterSet)e.isResultCrossVerificationEnabled(r.CRIT_BARCODE)&&(this._bOpenBarcodeVerify=!0),e.isResultCrossVerificationEnabled(r.CRIT_TEXT_LINE)&&(this._bOpenLabelVerify=!0),e.isResultCrossVerificationEnabled(r.CRIT_DETECTED_QUAD)&&(this._bOpenDetectVerify=!0),e.isResultCrossVerificationEnabled(r.CRIT_NORMALIZED_IMAGE)&&(this._bOpenNormalizeVerify=!0)}async startCapturing(e="Default"){if(this._checkIsDisposed(),!this._bPauseScan)return;if(!this._isa)throw new Error("'ImageSourceAdapter' is not set. call 'setInput' before 'startCapturing'");const t=await this.containsTask(e);if(await o(t),this._isa.isCameraEnhancer&&(t.includes("ddn")?this._isa.setPixelFormat(u.IPF_ABGR_8888):this._isa.setPixelFormat(u.IPF_GRAYSCALED)),void 0!==this._isa.singleFrameMode&&"disabled"!==this._isa.singleFrameMode)return this._templateName=e,void this._isa.on("singleFrameAcquired",this._singleFrameModeCallbackBind);return this._isa.getColourChannelUsageType()===_.CCUT_AUTO&&this._isa.setColourChannelUsageType(t.includes("ddn")?_.CCUT_FULL_CHANNEL:_.CCUT_Y_CHANNEL_ONLY),this._promiseStartScan&&this._promiseStartScan.isPending?this._promiseStartScan:(this._promiseStartScan=new p(((t,s)=>{if(this.disposed)return;let i=c();d[i]=async i=>{if(this._promiseStartScan&&!this._promiseStartScan.isFulfilled){if(!i.success){let e=new Error(i.message);return e.stack=i.stack+"\n"+e.stack,s(e)}for(let e of this._resultFilterSet)await this.addResultFilter(e);this._bPauseScan=!1,this._bNeedOutputOriginalImage=i.bNeedOutputOriginalImage,this._loopReadVideoTimeoutId&&clearTimeout(this._loopReadVideoTimeoutId),this._loopReadVideoTimeoutId=setTimeout((async()=>{-1!==this._minImageCaptureInterval&&this._isa.startFetching(),this._loopReadVideo(e),t()}),0),this._isa.isCameraEnhancer&&this._isa.getCameraView().setScanLaserVisible(!0)}},l.postMessage({type:"cvr_startCapturing",id:i,instanceID:this._instanceID,body:{templateName:e}})})),await this._promiseStartScan)}stopCapturing(){this._checkIsDisposed(),this._isa&&(this._isa.isCameraEnhancer&&(this._isa.getCameraView().setScanLaserVisible(!1),void 0!==this._isa.singleFrameMode&&"disabled"!==this._isa.singleFrameMode)?this._isa.off("singleFrameAcquired",this._singleFrameModeCallbackBind):(this._isa.stopFetching(),this._clearVerifyList(),this._averageProcessintTimeArray=[],this._averageTime=999,this._bPauseScan=!0,this._promiseStartScan=null,this._isa.setColourChannelUsageType(_.CCUT_AUTO)))}async _clearVerifyList(){let e=c();const t=new p;return d[e]=async e=>{if(e.success)return t.resolve();{let s=new Error(e.message);return s.stack=e.stack+"\n"+s.stack,t.reject(s)}},l.postMessage({type:"cvr_clearVerifyList",id:e,instanceID:this._instanceID}),t}async _getIntermediateResult(){this._checkIsDisposed();let e=c();const t=new p;return d[e]=async e=>{if(e.success)t.resolve(e.result);else{let s=new Error(e.message);s.stack=e.stack+"\n"+s.stack,t.reject(s)}},l.postMessage({type:"cvr_getIntermediateResult",id:e,instanceID:this._instanceID}),t}async containsTask(e){return this._checkIsDisposed(),await new Promise(((t,s)=>{let i=c();d[i]=async e=>{if(e.success)return t(JSON.parse(e.tasks));{let t=new Error(e.message);return t.stack=e.stack+"\n"+t.stack,s(t)}},l.postMessage({type:"cvr_containsTask",id:i,instanceID:this._instanceID,body:{templateName:e}})}))}async _loopReadVideo(e){if(this._dynamsoft=!0,this.disposed||this._bPauseScan)return;if(this._isa.isBufferEmpty())if(this._isa.hasNextImageToFetch())for(let e of this._isaStateListenerSet)e.onImageSourceStateReceived&&e.onImageSourceStateReceived(C.ISS_BUFFER_EMPTY);else if(!this._isa.hasNextImageToFetch())for(let e of this._isaStateListenerSet)e.onImageSourceStateReceived&&e.onImageSourceStateReceived(C.ISS_EXHAUSTED);if(-1===this._minImageCaptureInterval||this._isa.isBufferEmpty())try{this._isa.isBufferEmpty()&&L._onLog&&L._onLog("buffer is empty so fetch image"),L._onLog&&L._onLog(`DCE: start fetching a frame: ${Date.now()}`),this._dsImage=this._isa.fetchImage(),L._onLog&&L._onLog(`DCE: finish fetching a frame: ${Date.now()}`),this._isa.setImageFetchInterval(this._averageTime)}catch(t){return void this._reRunCurrnetFunc(e)}else if(this._isa.setImageFetchInterval(this._averageTime-(this._dsImage&&this._dsImage.tag?this._dsImage.tag.timeSpent:0)),this._dsImage=this._isa.getImage(),this._dsImage.tag&&Date.now()-this._dsImage.tag.timeStamp>200)return void this._reRunCurrnetFunc(e);if(!this._dsImage)return void this._reRunCurrnetFunc(e);for(let e of this._resultReceiverSet)this._bNeedOutputOriginalImage&&e.onOriginalImageResultReceived&&e.onOriginalImageResultReceived({imageData:this._dsImage});const t=Date.now();this._captureDsimage(this._dsImage,e).then((async s=>{if(L._onLog&&L._onLog("no js handle time: "+(Date.now()-t)),this._bPauseScan)return void this._reRunCurrnetFunc(e);s.originalImageTag=this._dsImage.tag?this._dsImage.tag:null;for(let e of this._resultReceiverSet)if(e.isDce){const t=Date.now();if(e.onCapturedResultReceived(s,{isDetectVerifyOpen:this._bOpenDetectVerify,isNormalizeVerifyOpen:this._bOpenNormalizeVerify,isBarcodeVerifyOpen:this._bOpenBarcodeVerify,isLabelVerifyOpen:this._bOpenLabelVerify}),L._onLog){const e=Date.now()-t;e>10&&L._onLog(`draw result time: ${e}`)}}const i={originalImageHashId:s.originalImageHashId,originalImageTag:s.originalImageTag,errorCode:s.errorCode,errorString:s.errorString};for(let e of this._resultReceiverSet)e.onDecodedBarcodesReceived&&s.barcodeResultItems&&e.onDecodedBarcodesReceived(Object.assign(Object.assign({},i),{barcodeResultItems:s.barcodeResultItems.filter((e=>!e.isFilter))})),e.onRecognizedTextLinesReceived&&s.textLineResultItems&&e.onRecognizedTextLinesReceived(Object.assign(Object.assign({},i),{textLineResultItems:s.textLineResultItems.filter((e=>!e.isFilter))})),e.onDetectedQuadsReceived&&s.detectedQuadResultItems&&e.onDetectedQuadsReceived(Object.assign(Object.assign({},i),{detectedQuadResultItems:s.detectedQuadResultItems.filter((e=>!e.isFilter))})),e.onNormalizedImagesReceived&&s.normalizedImageResultItems&&e.onNormalizedImagesReceived(Object.assign(Object.assign({},i),{normalizedImageResultItems:s.normalizedImageResultItems.filter((e=>!e.isFilter))})),e.onParsedResultsReceived&&s.parsedResultItems&&e.onParsedResultsReceived(Object.assign(Object.assign({},i),{parsedResultItems:s.parsedResultItems.filter((e=>!e.isFilter))})),e.onCapturedResultReceived&&!e.isDce&&(s.items=s.items.filter((e=>!e.isFilter)),s.barcodeResultItems&&(s.barcodeResultItems=s.barcodeResultItems.filter((e=>!e.isFilter))),s.textLineResultItems&&(s.textLineResultItems=s.textLineResultItems.filter((e=>!e.isFilter))),s.detectedQuadResultItems&&(s.detectedQuadResultItems=s.detectedQuadResultItems.filter((e=>!e.isFilter))),s.normalizedImageResultItems&&(s.normalizedImageResultItems=s.normalizedImageResultItems.filter((e=>!e.isFilter))),s.parsedResultItems&&(s.parsedResultItems=s.parsedResultItems.filter((e=>!e.isFilter))),e.onCapturedResultReceived(s));const a=Date.now();if(this._minImageCaptureInterval>-1&&(5===this._averageProcessintTimeArray.length&&this._averageProcessintTimeArray.shift(),5===this._averageFetchImageTimeArray.length&&this._averageFetchImageTimeArray.shift(),this._averageProcessintTimeArray.push(Date.now()-t),this._averageFetchImageTimeArray.push(this._dsImage&&this._dsImage.tag?this._dsImage.tag.timeSpent:0),this._averageTime=Math.min(...this._averageProcessintTimeArray)-Math.max(...this._averageFetchImageTimeArray),this._averageTime=this._averageTime>0?this._averageTime:0,L._onLog&&(L._onLog(`minImageCaptureInterval: ${this._minImageCaptureInterval}`),L._onLog(`averageProcessintTimeArray: ${this._averageProcessintTimeArray}`),L._onLog(`averageFetchImageTimeArray: ${this._averageFetchImageTimeArray}`),L._onLog(`averageTime: ${this._averageTime}`))),L._onLog){const e=Date.now()-a;e>10&&L._onLog(`fetch image calculate time: ${e}`)}L._onLog&&L._onLog(`time finish decode: ${Date.now()}`),L._onLog&&L._onLog("main time: "+(Date.now()-t)),L._onLog&&L._onLog("===================================================="),this._loopReadVideoTimeoutId&&clearTimeout(this._loopReadVideoTimeoutId),this._minImageCaptureInterval>0&&this._minImageCaptureInterval>=this._averageTime?this._loopReadVideoTimeoutId=setTimeout((()=>{this._loopReadVideo(e)}),this._minImageCaptureInterval-this._averageTime):this._loopReadVideoTimeoutId=setTimeout((()=>{this._loopReadVideo(e)}),Math.max(this._minImageCaptureInterval,0))})).catch((t=>{this._isa.stopFetching(),this._loopReadVideoTimeoutId&&clearTimeout(this._loopReadVideoTimeoutId),this._loopReadVideoTimeoutId=setTimeout((()=>{this._isa.startFetching(),this._loopReadVideo(e)}),Math.max(this._minImageCaptureInterval,1e3)),"platform error"!==t.message&&setTimeout((()=>{throw t}),0)}))}_reRunCurrnetFunc(e){this._loopReadVideoTimeoutId&&clearTimeout(this._loopReadVideoTimeoutId),this._loopReadVideoTimeoutId=setTimeout((()=>{this._loopReadVideo(e)}),0)}async capture(e,t="Default"){this._checkIsDisposed();const s=await this.containsTask(t);let i;if(await o(s),this._dynamsoft=!1,m(e))i=await this._captureDsimage(e,t);else if("string"==typeof e)i="data:image/"==e.substring(0,11)?await this._captureBase64(e,t):await this._captureUrl(e,t);else if(e instanceof Blob)i=await this._captureBlob(e,t);else if(e instanceof HTMLImageElement)i=await this._captureImage(e,t);else if(e instanceof HTMLCanvasElement)i=await this._captureCanvas(e,t);else{if(!(e instanceof HTMLVideoElement))throw new TypeError("'capture(imageOrFile, templateName)': Type of 'imageOrFile' should be 'DSImageData', 'Url', 'Base64', 'Blob', 'HTMLImageElement', 'HTMLCanvasElement', 'HTMLVideoElement'.");i=await this._captureVideo(e,t)}return i}async _captureDsimage(e,t){return await this._captureInWorker(e,t)}async _captureUrl(e,t){let s=await h(e,"blob");return await this._captureBlob(s,t)}async _captureBase64(e,t){e=e.substring(e.indexOf(",")+1);let s=atob(e),i=s.length,a=new Uint8Array(i);for(;i--;)a[i]=s.charCodeAt(i);return await this._captureBlob(new Blob([a]),t)}async _captureBlob(e,t){let s=null,i=null;if("undefined"!=typeof createImageBitmap)try{s=await createImageBitmap(e)}catch(e){}s||(i=await async function(e){return await new Promise(((t,s)=>{let i=URL.createObjectURL(e),a=new Image;a.src=i,a.onload=()=>{URL.revokeObjectURL(a.dbrObjUrl),t(a)},a.onerror=e=>{s(new Error("Can't convert blob to image : "+(e instanceof Event?e.type:e)))}}))}(e));let a=await this._captureImage(s||i,t);return s&&s.close(),a}async _captureImage(e,t){let s,i,a=e instanceof HTMLImageElement?e.naturalWidth:e.width,r=e instanceof HTMLImageElement?e.naturalHeight:e.height,n=Math.max(a,r);n>this.maxCvsSideLength?(this._compressRate=this.maxCvsSideLength/n,s=Math.round(a*this._compressRate),i=Math.round(r*this._compressRate)):(s=a,i=r),this._canvas||(this._canvas=document.createElement("canvas"));const o=this._canvas;o.width===s&&o.height===i||(o.width=s,o.height=i),o.ctx2d||(o.ctx2d=o.getContext("2d",{willReadFrequently:!0}));return o.ctx2d.drawImage(e,0,0,a,r,0,0,s,i),e.dbrObjUrl&&URL.revokeObjectURL(e.dbrObjUrl),await this._captureCanvas(o,t)}async _captureCanvas(e,t){if(e.crossOrigin&&"anonymous"!=e.crossOrigin)throw"cors";if([e.width,e.height].includes(0))throw Error("The width or height of the 'canvas' is 0.");const s=e.ctx2d||e.getContext("2d",{willReadFrequently:!0}),i={bytes:Uint8Array.from(s.getImageData(0,0,e.width,e.height).data),width:e.width,height:e.height,stride:4*e.width,format:10};return await this._captureInWorker(i,t)}async _captureVideo(e,t){if(e.crossOrigin&&"anonymous"!=e.crossOrigin)throw"cors";let s,i,a=e.videoWidth,r=e.videoHeight,n=Math.max(a,r);n>this.maxCvsSideLength?(this._compressRate=this.maxCvsSideLength/n,s=Math.round(a*this._compressRate),i=Math.round(r*this._compressRate)):(s=a,i=r),this._canvas||(this._canvas=document.createElement("canvas"));const o=this._canvas;o.width===s&&o.height===i||(o.width=s,o.height=i),o.ctx2d||(o.ctx2d=o.getContext("2d",{willReadFrequently:!0}));return o.ctx2d.drawImage(e,0,0,a,r,0,0,s,i),await this._captureCanvas(o,t)}async _captureInWorker(e,t){const{bytes:i,width:a,height:n,stride:o,format:u}=e;let _=c();const m=new p;return d[_]=async t=>{var i,a;if(!t.success){let e=new Error(t.message);return e.stack=t.stack+"\n"+e.stack,m.reject(e)}{const n=Date.now();L._onLog&&(L._onLog(`get result time from worker: ${n}`),L._onLog("worker to main time consume: "+(n-t.workerReturnMsgTime)));try{const n=t.captureResult;e.bytes=t.bytes;for(let t of n.items)0!==this._compressRate&&U(t,this._compressRate),t.type===r.CRIT_ORIGINAL_IMAGE?t.imageData=e:t.type===r.CRIT_NORMALIZED_IMAGE?null===(i=s.ddn)||void 0===i||i.handleNormalizedImageResultItem(t):t.type===r.CRIT_PARSED_RESULT&&(null===(a=s.dcp)||void 0===a||a.handleParsedResultItem(t));if(this._dynamsoft)for(let e of this._resultFilterSet)e.onDecodedBarcodesReceived(n.items),e.onRecognizedTextLinesReceived(n.items),e.onDetectedQuadsReceived(n.items),e.onNormalizedImagesReceived(n.items);const o=function(e){const t={barcodeResultItems:[],textLineResultItems:[],detectedQuadResultItems:[],normalizedImageResultItems:[],parsedResultItems:[]};return e.items.forEach((e=>{e.type===r.CRIT_BARCODE?t.barcodeResultItems.push(e):e.type===r.CRIT_TEXT_LINE?t.textLineResultItems.push(e):e.type===r.CRIT_DETECTED_QUAD?t.detectedQuadResultItems.push(e):e.type===r.CRIT_NORMALIZED_IMAGE?t.normalizedImageResultItems.push(e):e.type===r.CRIT_PARSED_RESULT&&t.parsedResultItems.push(e)})),t}(n);o.barcodeResultItems.length&&(n.barcodeResultItems=o.barcodeResultItems),o.textLineResultItems.length&&(n.textLineResultItems=o.textLineResultItems),o.detectedQuadResultItems.length&&(n.detectedQuadResultItems=o.detectedQuadResultItems),o.normalizedImageResultItems.length&&(n.normalizedImageResultItems=o.normalizedImageResultItems),o.parsedResultItems.length&&(n.parsedResultItems=o.parsedResultItems);const c=n.intermediateResult;if(c){let t=0;for(let s of this._intermediateResultReceiverSet){t++;for(let i of c){if("onTaskResultsReceived"===i.info.callbackName){for(let t of i.intermediateResultUnits)t.originalImageTag=e.tag?e.tag:null;s[i.info.callbackName]&&s[i.info.callbackName]({intermediateResultUnits:i.intermediateResultUnits},i.info)}else s[i.info.callbackName]&&s[i.info.callbackName](i.result,i.info);t===this._intermediateResultReceiverSet.size&&delete i.info.callbackName}}}return n&&n.intermediateResult&&delete n.intermediateResult,this._compressRate=0,m.resolve(n)}catch(e){return m.reject(e)}}},L._onLog&&L._onLog(`send buffer to worker: ${Date.now()}`),l.postMessage({type:"cvr_capture",id:_,instanceID:this._instanceID,body:{bytes:i,width:a,height:n,stride:o,format:u,templateName:t||"",dynamsoft:this._dynamsoft}},[i.buffer]),m}async initSettings(e){return this._checkIsDisposed(),e&&["string","object"].includes(typeof e)?("string"==typeof e?e.startsWith("{")?this._currentSettings=JSON.parse(e):e=await h(e,"text"):"object"==typeof e&&(this._currentSettings=e,e=JSON.stringify(e)),await new Promise(((t,s)=>{let i=c();d[i]=async i=>{if(i.success){const a=JSON.parse(i.response);if(0!==a.exception){let e=new Error(a.description?a.description:"Init Settings Failed.");return e.errorCode=a.exception,s(e)}let r=[],n=JSON.parse(e).CaptureVisionTemplates;for(let e=0;e<n.length;e++){let t=await this.containsTask(n[e].Name);r=r.concat(t)}return await o([...new Set(r)]),this._bNeedOutputOriginalImage=1===this._currentSettings.CaptureVisionTemplates[0].OutputOriginalImage,t(a)}{let e=new Error(i.message);return e.stack=i.stack+"\n"+e.stack,s(e)}},l.postMessage({type:"cvr_initSettings",id:i,instanceID:this._instanceID,body:{settings:e}})}))):console.error("Invalid template.")}async outputSettings(e){return this._checkIsDisposed(),await new Promise(((t,s)=>{let i=c();d[i]=async e=>{if(e.success){const i=JSON.parse(e.settings);if(0!==i.errorCode){let e=new Error(i.errorString);return e.errorCode=i.errorCode,s(e)}return delete i.errorCode,delete i.errorString,t(i)}{let t=new Error(e.message);return t.stack=e.stack+"\n"+t.stack,s(t)}},l.postMessage({type:"cvr_outputSettings",id:i,instanceID:this._instanceID,body:{templateName:e||"Default"}})}))}async outputSettingsToFile(e,t,s){const i=await this.outputSettings(e),a=new Blob([JSON.stringify(i,null,2,(function(e,t){return t instanceof Array?JSON.stringify(t):t}),2)],{type:"application/json"});if(s){const e=document.createElement("a");e.href=URL.createObjectURL(a),t.endsWith(".json")&&(t=t.replace(".json","")),e.download=`${t}.json`,e.onclick=()=>{setTimeout((()=>{URL.revokeObjectURL(e.href)}),500)},e.click()}return a}async getSimplifiedSettings(e="Default"){this._checkIsDisposed();const t=await this.containsTask(e);return await o(t),await new Promise(((t,s)=>{let i=c();d[i]=async e=>{if(e.success){const i=JSON.parse(e.settings,((e,t)=>R&&"barcodeFormatIds"===e?BigInt(t):t));if(i.minImageCaptureInterval=this._minImageCaptureInterval,0!==i.code){let e=new Error(i.codeString);return e.errorCode=i.errorCode,s(e)}return delete i.code,delete i.codeString,t(i)}{let t=new Error(e.message);return t.stack=e.stack+"\n"+t.stack,s(t)}},l.postMessage({type:"cvr_getSimplifiedSettings",id:i,instanceID:this._instanceID,body:{templateName:e}})}))}async updateSettings(e,t){this._checkIsDisposed();const s=await this.containsTask(e);return await o(s),await new Promise(((s,i)=>{let a=c();d[a]=async e=>{if(e.success){const a=JSON.parse(e.response);if(t.minImageCaptureInterval&&t.minImageCaptureInterval>=-1&&(this._minImageCaptureInterval=t.minImageCaptureInterval),this._bNeedOutputOriginalImage=e.bNeedOutputOriginalImage,0!==a.exception){let e=new Error(a.description?a.description:"Update Settings Failed.");return e.errorCode=a.exception,i(e)}return this._currentSettings=await this.outputSettings("*"),s(a)}{let t=new Error(e.message);return t.stack=e.stack+"\n"+t.stack,i(t)}},l.postMessage({type:"cvr_updateSettings",id:a,instanceID:this._instanceID,body:{settings:t,templateName:e}})}))}async resetSettings(){return this._checkIsDisposed(),await new Promise(((e,t)=>{let s=c();d[s]=async s=>{if(s.success){const i=JSON.parse(s.response);if(0!==i.exception){let e=new Error(i.description?i.description:"Reset Settings Failed.");return e.errorCode=i.exception,t(e)}return this._currentSettings=await this.outputSettings("*"),e(i)}{let e=new Error(s.message);return e.stack=s.stack+"\n"+e.stack,t(e)}},l.postMessage({type:"cvr_resetSettings",id:s,instanceID:this._instanceID})}))}getIntermediateResultManager(e){if(this._checkIsDisposed(),!e&&0!==n.bSupportIRTModule)throw new Error("The current license does not support the use of intermediate results.");return this._intermediateResultManager||(this._intermediateResultManager=new v,this._intermediateResultManager.addResultReceiver=async e=>{if("object"!=typeof e)throw new Error("Invalid receiver.");this._intermediateResultReceiverSet.add(e),this._handleIntermediateResultReceiver();let t=-1,s={};if(!e.isDce){if(!e._observedResultUnitTypes||!e._observedTaskMap)throw new Error("Invalid Intermediate Result Receiver.");t=e._observedResultUnitTypes,e._observedTaskMap.forEach(((e,t)=>{s[t]=e})),e._observedTaskMap.clear()}return await(async()=>await new Promise(((e,i)=>{let a=c();d[a]=async t=>{if(t.success)return e();{let e=new Error(t.message);return e.stack=t.stack+"\n"+e.stack,i(e)}},l.postMessage({type:"cvr_setIrrRegistry",id:a,instanceID:this._instanceID,body:{receiverObj:this._irrRegistryState,observedResultUnitTypes:String(t),observedTaskMap:s}})})))()},this._intermediateResultManager.removeResultReceiver=async e=>(this._intermediateResultReceiverSet.delete(e),this._handleIntermediateResultReceiver(),await new Promise(((e,t)=>{let s=c();d[s]=async s=>{if(s.success)return e();{let e=new Error(s.message);return e.stack=s.stack+"\n"+e.stack,t(e)}},l.postMessage({type:"cvr_setIrrRegistry",id:s,instanceID:this._instanceID,body:{receiverObj:this._irrRegistryState}})}))),this._intermediateResultManager.getOriginalImage=()=>this._dsImage),this._intermediateResultManager}_handleIntermediateResultReceiver(){for(let e in this._irrRegistryState)this._irrRegistryState[e]=!1;for(let e of this._intermediateResultReceiverSet)if(e.isDce)this._irrRegistryState.onTaskResultsReceivedForDce=!0;else for(let t in e)this._irrRegistryState[t]||(this._irrRegistryState[t]=!!e[t])}contains(e,t){return function(e,t){let s=t.x,i=t.y,a=e[0].x,r=e[0].y,n=e[1].x,o=e[1].y,c=e[2].x,d=e[2].y,l=e[3].x,u=e[3].y,_=g(s,i,a,r,n,o),m=g(s,i,n,o,c,d),h=g(s,i,c,d,l,u),R=g(s,i,l,u,a,r);function g(e,t,s,i,a,r){return(e-s)*(r-i)-(t-i)*(a-s)}return _>=0&&m>=0&&h>=0&&R>=0||_<=0&&m<=0&&h<=0&&R<=0}(e,t)}async parseRequiredResources(e){return this._checkIsDisposed(),await new Promise(((t,s)=>{let i=c();d[i]=async e=>{if(e.success)return t(JSON.parse(e.resources));{let t=new Error(e.message);return t.stack=e.stack+"\n"+t.stack,s(t)}},l.postMessage({type:"cvr_parseRequiredResources",id:i,instanceID:this._instanceID,body:{templateName:e}})}))}async dispose(){this._checkIsDisposed(),this._promiseStartScan&&this.stopCapturing(),this._isa=null,this._resultReceiverSet.clear(),this._isaStateListenerSet.clear(),this._resultFilterSet.clear(),this.bDestroyed=!0;let e=c();d[e]=e=>{if(!e.success){let t=new Error(e.message);throw t.stack=e.stack+"\n"+t.stack,t}},l.postMessage({type:"cvr_dispose",id:e,instanceID:this._instanceID})}async _enableResultCrossVerification(e){return this._checkIsDisposed(),await new Promise(((t,s)=>{let i=c();d[i]=async e=>{if(e.success)return t(e.result);{let t=new Error(e.message);return t.stack=e.stack+"\n"+t.stack,s(t)}},l.postMessage({type:"cvr_enableResultCrossVerification",id:i,instanceID:this._instanceID,body:{verificationEnabled:e}})}))}async _enableResultDeduplication(e){return this._checkIsDisposed(),await new Promise(((t,s)=>{let i=c();d[i]=async e=>{if(e.success)return t(e.result);{let t=new Error(e.message);return t.stack=e.stack+"\n"+t.stack,s(t)}},l.postMessage({type:"cvr_enableResultDeduplication",id:i,instanceID:this._instanceID,body:{duplicateFilterEnabled:e}})}))}async _setDuplicateForgetTime(e){return this._checkIsDisposed(),await new Promise(((t,s)=>{let i=c();d[i]=async e=>{if(e.success)return t(e.result);{let t=new Error(e.message);return t.stack=e.stack+"\n"+t.stack,s(t)}},l.postMessage({type:"cvr_setDuplicateForgetTime",id:i,instanceID:this._instanceID,body:{duplicateForgetTime:e}})}))}async _getDuplicateForgetTime(e){return this._checkIsDisposed(),await new Promise(((t,s)=>{let i=c();d[i]=async e=>{if(e.success)return t(e.time);{let t=new Error(e.message);return t.stack=e.stack+"\n"+t.stack,s(t)}},l.postMessage({type:"cvr_getDuplicateForgetTime",id:i,instanceID:this._instanceID,body:{type:e}})}))}async _setThresholdValue(e,t,s){return await o("ddn"),await new Promise(((i,a)=>{let r=c();d[r]=async e=>{if(e.success)return i();{let t=new Error(e.message);return t.stack=e.stack+"\n"+t.stack,a(t)}},l.postMessage({type:"ddn_setThresholdValue",id:r,instanceID:this._instanceID,body:{threshold:e,leftLimit:t,rightLimit:s}})}))}_checkIsDisposed(){if(this.disposed)throw new Error('"CaptureVisionRouter" instance has been disposed')}}class k{constructor(){this.onCapturedResultReceived=null,this.onOriginalImageResultReceived=null}}class A{constructor(){this._observedResultUnitTypes=g.IRUT_ALL,this._observedTaskMap=new Map,this._parameters={setObservedResultUnitTypes:e=>{this._observedResultUnitTypes=e},getObservedResultUnitTypes:()=>this._observedResultUnitTypes,isResultUnitTypeObserved:e=>!!(e&this._observedResultUnitTypes),addObservedTask:e=>{this._observedTaskMap.set(e,!0)},removeObservedTask:e=>{this._observedTaskMap.set(e,!1)},isTaskObserved:e=>0===this._observedTaskMap.size||!!this._observedTaskMap.get(e)},this.onTaskResultsReceived=null,this.onPredetectedRegionsReceived=null,this.onColourImageUnitReceived=null,this.onScaledDownColourImageUnitReceived=null,this.onGrayscaleImageUnitReceived=null,this.onTransformedGrayscaleImageUnitReceived=null,this.onEnhancedGrayscaleImageUnitReceived=null,this.onBinaryImageUnitReceived=null,this.onTextureDetectionResultUnitReceived=null,this.onTextureRemovedGrayscaleImageUnitReceived=null,this.onTextureRemovedBinaryImageUnitReceived=null,this.onContoursUnitReceived=null,this.onLineSegmentsUnitReceived=null,this.onTextZonesUnitReceived=null,this.onTextRemovedBinaryImageUnitReceived=null,this.onShortLinesUnitReceived=null}getObservationParameters(){return this._parameters}}export{L as CaptureVisionRouter,w as CaptureVisionRouterModule,k as CapturedResultReceiver,C as EnumImageSourceState,v as IntermediateResultManager,A as IntermediateResultReceiver};
