/*!
 * Dynamsoft JavaScript Library
 * @product Dynamsoft Capture Vision Router JS Edition
 * @website http://www.dynamsoft.com
 * @copyright Copyright 2024, Dynamsoft Corporation
 * @author Dynamsoft
 * @version "2.2.10"
 * @fileoverview Dynamsoft JavaScript Library for Capture Vision
 * More info on cvr JS: https://www.dynamsoft.com/capture-vision/docs/web/programming/javascript/api-reference/capture-vision-router/capture-vision-router-module.html
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("dynamsoft-core")):"function"==typeof define&&define.amd?define(["exports","dynamsoft-core"],t):t(((e="undefined"!=typeof globalThis?globalThis:e||self).Dynamsoft=e.Dynamsoft||{},e.Dynamsoft.CVR={}),e.Dynamsoft.Core)}(this,(function(e,t){"use strict";const s=e=>e&&"object"==typeof e&&"function"==typeof e.then;class i extends Promise{constructor(e){let t,i;super(((e,s)=>{t=e,i=s})),this._s="pending",this.resolve=e=>{this.isPending&&(s(e)?this.task=e:(this._s="fulfilled",t(e)))},this.reject=e=>{this.isPending&&(this._s="rejected",i(e))},this.task=e}get status(){return this._s}get isPending(){return"pending"===this._s}get isFulfilled(){return"fulfilled"===this._s}get isRejected(){return"rejected"===this._s}get task(){return this._task}set task(e){let t;this._task=e,s(e)?t=e:"function"==typeof e&&(t=new Promise(e)),t&&(async()=>{try{const s=await t;e===this._task&&this.resolve(s)}catch(t){e===this._task&&this.reject(t)}})()}get isEmpty(){return null==this._task}}class a{constructor(){this.addResultReceiver=null,this.removeResultReceiver=null,this.getOriginalImage=null}}var r={onTaskResultsReceived:!1,onTaskResultsReceivedForDce:!1,onPredetectedRegionsReceived:!1,onLocalizedBarcodesReceived:!1,onDecodedBarcodesReceived:!1,onLocalizedTextLinesReceived:!1,onRecognizedTextLinesReceived:!1,onDetectedQuadsReceived:!1,onNormalizedImagesReceived:!1,onColourImageUnitReceived:!1,onScaledDownColourImageUnitReceived:!1,onGrayscaleImageUnitReceived:!1,onTransformedGrayscaleImageUnitReceived:!1,onEnhancedGrayscaleImageUnitReceived:!1,onBinaryImageUnitReceived:!1,onTextureDetectionResultUnitReceived:!1,onTextureRemovedGrayscaleImageUnitReceived:!1,onTextureRemovedBinaryImageUnitReceived:!1,onContoursUnitReceived:!1,onLineSegmentsUnitReceived:!1,onTextZonesUnitReceived:!1,onTextRemovedBinaryImageUnitReceived:!1,onLongLinesUnitReceived:!1,onCornersUnitReceived:!1,onCandidateQuadEdgesUnitReceived:!1,onCandidateBarcodeZonesUnitReceived:!1,onScaledUpBarcodeImageUnitReceived:!1,onDeformationResistedBarcodeImageUnitReceived:!1,onComplementedBarcodeImageUnitReceived:!1,onShortLinesUnitReceived:!1};const n="undefined"==typeof self,o=(()=>{if(!n&&document.currentScript){let e=document.currentScript.src,t=e.indexOf("?");if(-1!=t)e=e.substring(0,t);else{let t=e.indexOf("#");-1!=t&&(e=e.substring(0,t))}return e.substring(0,e.lastIndexOf("/")+1)}return"./"})(),c=e=>{if(null==e&&(e="./"),n);else{let t=document.createElement("a");t.href=e,e=t.href}return e.endsWith("/")||(e+="/"),e};var l;null==t.engineResourcePaths.cvr&&(t.engineResourcePaths.cvr=o),t.workerAutoResources.cvr={js:!0,wasm:!0,deps:["license","dip"]},t.mapPackageRegister.cvr={};const d="1.2.0";"string"!=typeof t.engineResourcePaths.std&&t.compareVersion(t.engineResourcePaths.std.version,d)<0&&(t.engineResourcePaths.std={version:d,path:c(o+`../../dynamsoft-capture-vision-std@${d}/dist/`)});const u="2.2.10";(!t.engineResourcePaths.dip||"string"!=typeof t.engineResourcePaths.dip&&t.compareVersion(t.engineResourcePaths.dip.version,u)<0)&&(t.engineResourcePaths.dip={version:u,path:c(o+`../../dynamsoft-image-processing@${u}/dist/`)});class m{static getVersion(){return this._version}}var _,h;function R(e,t){if(e&&e.location){const s=e.location.points;for(let e of s)e.x=e.x/t,e.y=e.y/t;R(e.referencedItem,t)}}m._version=`2.2.10(Worker: ${null===(l=t.innerVersions.cvr)||void 0===l?void 0:l.worker}, Wasm: loading...`,e.EnumImageSourceState=void 0,(_=e.EnumImageSourceState||(e.EnumImageSourceState={}))[_.ISS_BUFFER_EMPTY=0]="ISS_BUFFER_EMPTY",_[_.ISS_EXHAUSTED=1]="ISS_EXHAUSTED",function(e){e[e.IRUT_NULL=0]="IRUT_NULL",e[e.IRUT_COLOUR_IMAGE=1]="IRUT_COLOUR_IMAGE",e[e.IRUT_SCALED_DOWN_COLOUR_IMAGE=2]="IRUT_SCALED_DOWN_COLOUR_IMAGE",e[e.IRUT_GRAYSCALE_IMAGE=4]="IRUT_GRAYSCALE_IMAGE",e[e.IRUT_TRANSOFORMED_GRAYSCALE_IMAGE=8]="IRUT_TRANSOFORMED_GRAYSCALE_IMAGE",e[e.IRUT_ENHANCED_GRAYSCALE_IMAGE=16]="IRUT_ENHANCED_GRAYSCALE_IMAGE",e[e.IRUT_PREDETECTED_REGIONS=32]="IRUT_PREDETECTED_REGIONS",e[e.IRUT_BINARY_IMAGE=64]="IRUT_BINARY_IMAGE",e[e.IRUT_TEXTURE_DETECTION_RESULT=128]="IRUT_TEXTURE_DETECTION_RESULT",e[e.IRUT_TEXTURE_REMOVED_GRAYSCALE_IMAGE=256]="IRUT_TEXTURE_REMOVED_GRAYSCALE_IMAGE",e[e.IRUT_TEXTURE_REMOVED_BINARY_IMAGE=512]="IRUT_TEXTURE_REMOVED_BINARY_IMAGE",e[e.IRUT_CONTOURS=1024]="IRUT_CONTOURS",e[e.IRUT_LINE_SEGMENTS=2048]="IRUT_LINE_SEGMENTS",e[e.IRUT_TEXT_ZONES=4096]="IRUT_TEXT_ZONES",e[e.IRUT_TEXT_REMOVED_BINARY_IMAGE=8192]="IRUT_TEXT_REMOVED_BINARY_IMAGE",e[e.IRUT_CANDIDATE_BARCODE_ZONES=16384]="IRUT_CANDIDATE_BARCODE_ZONES",e[e.IRUT_LOCALIZED_BARCODES=32768]="IRUT_LOCALIZED_BARCODES",e[e.IRUT_SCALED_UP_BARCODE_IMAGE=65536]="IRUT_SCALED_UP_BARCODE_IMAGE",e[e.IRUT_DEFORMATION_RESISTED_BARCODE_IMAGE=131072]="IRUT_DEFORMATION_RESISTED_BARCODE_IMAGE",e[e.IRUT_COMPLEMENTED_BARCODE_IMAGE=262144]="IRUT_COMPLEMENTED_BARCODE_IMAGE",e[e.IRUT_DECODED_BARCODES=524288]="IRUT_DECODED_BARCODES",e[e.IRUT_LONG_LINES=1048576]="IRUT_LONG_LINES",e[e.IRUT_CORNERS=2097152]="IRUT_CORNERS",e[e.IRUT_CANDIDATE_QUAD_EDGES=4194304]="IRUT_CANDIDATE_QUAD_EDGES",e[e.IRUT_DETECTED_QUADS=8388608]="IRUT_DETECTED_QUADS",e[e.IRUT_LOCALIZED_TEXT_LINES=16777216]="IRUT_LOCALIZED_TEXT_LINES",e[e.IRUT_RECOGNIZED_TEXT_LINES=33554432]="IRUT_RECOGNIZED_TEXT_LINES",e[e.IRUT_NORMALIZED_IMAGES=67108864]="IRUT_NORMALIZED_IMAGES",e[e.IRUT_SHORT_LINES=134217728]="IRUT_SHORT_LINES",e[e.IRUT_ALL=134217727]="IRUT_ALL"}(h||(h={}));class g{constructor(){this.maxCvsSideLength=["iPhone","Android","HarmonyOS"].includes(t.CoreModule.browserInfo.OS)?2048:4096,this._isa=null,this._dsImage=null,this._instanceID=void 0,this._bPauseScan=!0,this._bNeedOutputOriginalImage=!1,this._canvas=null,this._irrRegistryState=r,this._resultReceiverSet=new Set,this._isaStateListenerSet=new Set,this._resultFilterSet=new Set,this._intermediateResultReceiverSet=new Set,this._intermediateResultManager=null,this._templateName="Default",this._bOpenDetectVerify=!1,this._bOpenNormalizeVerify=!1,this._bOpenBarcodeVerify=!1,this._bOpenLabelVerify=!1,this._minImageCaptureInterval=0,this._averageProcessintTimeArray=[],this._averageFetchImageTimeArray=[],this._currentSettings=null,this._averageTime=999,this._compressRate=0,this._dynamsoft=!1,this.captureInParallel=!0,this.bDestroyed=!1,this._singleFrameModeCallbackBind=this._singleFrameModeCallback.bind(this),this._promiseStartScan=null}get disposed(){return this.bDestroyed}static async createInstance(){if(!t.mapPackageRegister.license)throw Error("Module `license` is not existed.");await t.mapPackageRegister.license.dynamsoft(),await t.loadWasm(["cvr"]);const e=new g,s=new i;let a=t.getNextTaskID();return t.mapTaskCallBack[a]=async i=>{var a;if(i.success)e._instanceID=i.instanceID,e._currentSettings=JSON.parse(i.outputSettings),m._version=`2.2.10(Worker: ${null===(a=t.innerVersions.cvr)||void 0===a?void 0:a.worker}, Wasm: ${i.version})`,0===t.CoreModule.bSupportDce4Module&&(e._intermediateResultManager=e.getIntermediateResultManager(!0)),s.resolve(e);else{const e=Error(i.message);i.stack&&(e.stack=i.stack),s.reject(e)}},t.worker.postMessage({type:"cvr_createInstance",id:a}),s}async _singleFrameModeCallback(e){this._isa.getCameraView().setScanLaserVisible(!0);for(let t of this._resultReceiverSet)this._bNeedOutputOriginalImage&&t.onOriginalImageResultReceived&&t.onOriginalImageResultReceived({imageData:e});const t={bytes:new Uint8Array(e.bytes),width:e.width,height:e.height,stride:e.stride,format:e.format,tag:e.tag},s=await this.capture(t,this._templateName);s.originalImageTag=e.tag;for(let e of this._resultReceiverSet)e.isDce&&e.onCapturedResultReceived(s,{isDetectVerifyOpen:!1,isNormalizeVerifyOpen:!1,isBarcodeVerifyOpen:!1,isLabelVerifyOpen:!1});const i={originalImageHashId:s.originalImageHashId,originalImageTag:s.originalImageTag,errorCode:s.errorCode,errorString:s.errorString};for(let t of this._resultReceiverSet)if(t.onDecodedBarcodesReceived&&s.barcodeResultItems&&t.onDecodedBarcodesReceived(Object.assign(Object.assign({},i),{barcodeResultItems:s.barcodeResultItems})),t.onRecognizedTextLinesReceived&&s.textLineResultItems&&t.onRecognizedTextLinesReceived(Object.assign(Object.assign({},i),{textLineResultItems:s.textLineResultItems})),t.onDetectedQuadsReceived&&s.detectedQuadResultItems&&t.onDetectedQuadsReceived(Object.assign(Object.assign({},i),{detectedQuadResultItems:s.detectedQuadResultItems})),t.onNormalizedImagesReceived&&s.normalizedImageResultItems&&t.onNormalizedImagesReceived(Object.assign(Object.assign({},i),{normalizedImageResultItems:s.normalizedImageResultItems})),t.onParsedResultsReceived&&s.parsedResultItems&&t.onParsedResultsReceived(Object.assign(Object.assign({},i),{parsedResultItems:s.parsedResultItems})),t.onCapturedResultReceived&&!t.isDce){if(this._bNeedOutputOriginalImage){const t=s.items.findIndex((e=>1===e.type));-1!==t&&(s.items[t].imageData=e)}t.onCapturedResultReceived(s)}}setInput(e){if(this._checkIsDisposed(),e){if(this._isa=e,e.isCameraEnhancer){this._intermediateResultManager&&(this._isa._intermediateResultReceiver.isDce=!0,this._intermediateResultManager.addResultReceiver(this._isa._intermediateResultReceiver));const e=this._isa.getCameraView();if(e){const t=e._capturedResultReceiver;t.isDce=!0,this._resultReceiverSet.add(t)}}}else this._isa=null}getInput(){return this._isa}addImageSourceStateListener(e){if(this._checkIsDisposed(),"object"!=typeof e)return console.warn("Invalid ISA state listener.");e&&Object.keys(e)&&this._isaStateListenerSet.add(e)}removeImageSourceStateListener(e){return this._checkIsDisposed(),this._isaStateListenerSet.delete(e)}addResultReceiver(e){if(this._checkIsDisposed(),"object"!=typeof e)throw new Error("Invalid receiver.");e&&Object.keys(e).length&&(this._resultReceiverSet.add(e),this._setCrrRegistry())}removeResultReceiver(e){this._checkIsDisposed(),this._resultReceiverSet.delete(e),this._setCrrRegistry()}async _setCrrRegistry(){const e={onCapturedResultReceived:!1,onDecodedBarcodesReceived:!1,onRecognizedTextLinesReceived:!1,onDetectedQuadsReceived:!1,onNormalizedImagesReceived:!1,onParsedResultsReceived:!1};for(let t of this._resultReceiverSet)t.isDce||(e.onCapturedResultReceived=!!t.onCapturedResultReceived,e.onDecodedBarcodesReceived=!!t.onDecodedBarcodesReceived,e.onRecognizedTextLinesReceived=!!t.onRecognizedTextLinesReceived,e.onDetectedQuadsReceived=!!t.onDetectedQuadsReceived,e.onNormalizedImagesReceived=!!t.onNormalizedImagesReceived,e.onParsedResultsReceived=!!t.onParsedResultsReceived);const s=new i;let a=t.getNextTaskID();return t.mapTaskCallBack[a]=async e=>{if(e.success)s.resolve();else{let t=new Error(e.message);t.stack=e.stack+"\n"+t.stack,s.reject()}},t.worker.postMessage({type:"cvr_setCrrRegistry",id:a,instanceID:this._instanceID,body:{receiver:JSON.stringify(e)}}),s}async addResultFilter(e){if(this._checkIsDisposed(),"object"!=typeof e)return console.warn("Invalid filter.");if(e&&Object.keys(e)){this._resultFilterSet.add(e),this._handleFilterSwitch();for(let e of this._resultFilterSet)await this._enableResultCrossVerification(e.verificationEnabled),await this._enableResultDeduplication(e.duplicateFilterEnabled),await this._setDuplicateForgetTime(e.duplicateForgetTime)}}async removeResultFilter(e){this._checkIsDisposed(),this._resultFilterSet.delete(e),this._handleFilterSwitch();for(let e of this._resultFilterSet)await this._enableResultCrossVerification(e.verificationEnabled),await this._enableResultDeduplication(e.duplicateFilterEnabled),await this._setDuplicateForgetTime(e.duplicateForgetTime)}_handleFilterSwitch(){this._bOpenBarcodeVerify=!1,this._bOpenLabelVerify=!1,this._bOpenDetectVerify=!1,this._bOpenNormalizeVerify=!1;for(let e of this._resultFilterSet)e.isResultCrossVerificationEnabled(t.EnumCapturedResultItemType.CRIT_BARCODE)&&(this._bOpenBarcodeVerify=!0),e.isResultCrossVerificationEnabled(t.EnumCapturedResultItemType.CRIT_TEXT_LINE)&&(this._bOpenLabelVerify=!0),e.isResultCrossVerificationEnabled(t.EnumCapturedResultItemType.CRIT_DETECTED_QUAD)&&(this._bOpenDetectVerify=!0),e.isResultCrossVerificationEnabled(t.EnumCapturedResultItemType.CRIT_NORMALIZED_IMAGE)&&(this._bOpenNormalizeVerify=!0)}async startCapturing(e="Default"){if(this._checkIsDisposed(),!this._bPauseScan)return;if(!this._isa)throw new Error("'ImageSourceAdapter' is not set. call 'setInput' before 'startCapturing'");const s=await this.containsTask(e);if(await t.loadWasm(s),this._isa.isCameraEnhancer&&(s.includes("ddn")?this._isa.setPixelFormat(t.EnumImagePixelFormat.IPF_ABGR_8888):this._isa.setPixelFormat(t.EnumImagePixelFormat.IPF_GRAYSCALED)),void 0!==this._isa.singleFrameMode&&"disabled"!==this._isa.singleFrameMode)return this._templateName=e,void this._isa.on("singleFrameAcquired",this._singleFrameModeCallbackBind);return this._isa.getColourChannelUsageType()===t.EnumColourChannelUsageType.CCUT_AUTO&&this._isa.setColourChannelUsageType(s.includes("ddn")?t.EnumColourChannelUsageType.CCUT_FULL_CHANNEL:t.EnumColourChannelUsageType.CCUT_Y_CHANNEL_ONLY),this._promiseStartScan&&this._promiseStartScan.isPending?this._promiseStartScan:(this._promiseStartScan=new i(((s,i)=>{if(this.disposed)return;let a=t.getNextTaskID();t.mapTaskCallBack[a]=async t=>{if(this._promiseStartScan&&!this._promiseStartScan.isFulfilled){if(!t.success){let e=new Error(t.message);return e.stack=t.stack+"\n"+e.stack,i(e)}for(let e of this._resultFilterSet)await this.addResultFilter(e);this._bPauseScan=!1,this._bNeedOutputOriginalImage=t.bNeedOutputOriginalImage,this._loopReadVideoTimeoutId&&clearTimeout(this._loopReadVideoTimeoutId),this._loopReadVideoTimeoutId=setTimeout((async()=>{-1!==this._minImageCaptureInterval&&this._isa.startFetching(),this._loopReadVideo(e),s()}),0),this._isa.isCameraEnhancer&&this._isa.getCameraView().setScanLaserVisible(!0)}},t.worker.postMessage({type:"cvr_startCapturing",id:a,instanceID:this._instanceID,body:{templateName:e}})})),await this._promiseStartScan)}stopCapturing(){this._checkIsDisposed(),this._isa&&(this._isa.isCameraEnhancer&&(this._isa.getCameraView().setScanLaserVisible(!1),void 0!==this._isa.singleFrameMode&&"disabled"!==this._isa.singleFrameMode)?this._isa.off("singleFrameAcquired",this._singleFrameModeCallbackBind):(this._isa.stopFetching(),this._clearVerifyList(),this._averageProcessintTimeArray=[],this._averageTime=999,this._bPauseScan=!0,this._promiseStartScan=null,this._isa.setColourChannelUsageType(t.EnumColourChannelUsageType.CCUT_AUTO)))}async _clearVerifyList(){let e=t.getNextTaskID();const s=new i;return t.mapTaskCallBack[e]=async e=>{if(e.success)return s.resolve();{let t=new Error(e.message);return t.stack=e.stack+"\n"+t.stack,s.reject(t)}},t.worker.postMessage({type:"cvr_clearVerifyList",id:e,instanceID:this._instanceID}),s}async _getIntermediateResult(){this._checkIsDisposed();let e=t.getNextTaskID();const s=new i;return t.mapTaskCallBack[e]=async e=>{if(e.success)s.resolve(e.result);else{let t=new Error(e.message);t.stack=e.stack+"\n"+t.stack,s.reject(t)}},t.worker.postMessage({type:"cvr_getIntermediateResult",id:e,instanceID:this._instanceID}),s}async containsTask(e){return this._checkIsDisposed(),await new Promise(((s,i)=>{let a=t.getNextTaskID();t.mapTaskCallBack[a]=async e=>{if(e.success)return s(JSON.parse(e.tasks));{let t=new Error(e.message);return t.stack=e.stack+"\n"+t.stack,i(t)}},t.worker.postMessage({type:"cvr_containsTask",id:a,instanceID:this._instanceID,body:{templateName:e}})}))}async _loopReadVideo(t){if(this._dynamsoft=!0,this.disposed||this._bPauseScan)return;if(this._isa.isBufferEmpty())if(this._isa.hasNextImageToFetch())for(let t of this._isaStateListenerSet)t.onImageSourceStateReceived&&t.onImageSourceStateReceived(e.EnumImageSourceState.ISS_BUFFER_EMPTY);else if(!this._isa.hasNextImageToFetch())for(let t of this._isaStateListenerSet)t.onImageSourceStateReceived&&t.onImageSourceStateReceived(e.EnumImageSourceState.ISS_EXHAUSTED);if(-1===this._minImageCaptureInterval||this._isa.isBufferEmpty())try{this._isa.isBufferEmpty()&&g._onLog&&g._onLog("buffer is empty so fetch image"),g._onLog&&g._onLog(`DCE: start fetching a frame: ${Date.now()}`),this._dsImage=this._isa.fetchImage(),g._onLog&&g._onLog(`DCE: finish fetching a frame: ${Date.now()}`),this._isa.setImageFetchInterval(this._averageTime)}catch(e){return void this._reRunCurrnetFunc(t)}else if(this._isa.setImageFetchInterval(this._averageTime-(this._dsImage&&this._dsImage.tag?this._dsImage.tag.timeSpent:0)),this._dsImage=this._isa.getImage(),this._dsImage.tag&&Date.now()-this._dsImage.tag.timeStamp>200)return void this._reRunCurrnetFunc(t);if(!this._dsImage)return void this._reRunCurrnetFunc(t);for(let e of this._resultReceiverSet)this._bNeedOutputOriginalImage&&e.onOriginalImageResultReceived&&e.onOriginalImageResultReceived({imageData:this._dsImage});const s=Date.now();this._captureDsimage(this._dsImage,t).then((async e=>{if(g._onLog&&g._onLog("no js handle time: "+(Date.now()-s)),this._bPauseScan)return void this._reRunCurrnetFunc(t);e.originalImageTag=this._dsImage.tag?this._dsImage.tag:null;for(let t of this._resultReceiverSet)if(t.isDce){const s=Date.now();if(t.onCapturedResultReceived(e,{isDetectVerifyOpen:this._bOpenDetectVerify,isNormalizeVerifyOpen:this._bOpenNormalizeVerify,isBarcodeVerifyOpen:this._bOpenBarcodeVerify,isLabelVerifyOpen:this._bOpenLabelVerify}),g._onLog){const e=Date.now()-s;e>10&&g._onLog(`draw result time: ${e}`)}}const i={originalImageHashId:e.originalImageHashId,originalImageTag:e.originalImageTag,errorCode:e.errorCode,errorString:e.errorString};for(let t of this._resultReceiverSet)t.onDecodedBarcodesReceived&&e.barcodeResultItems&&t.onDecodedBarcodesReceived(Object.assign(Object.assign({},i),{barcodeResultItems:e.barcodeResultItems.filter((e=>!e.isFilter))})),t.onRecognizedTextLinesReceived&&e.textLineResultItems&&t.onRecognizedTextLinesReceived(Object.assign(Object.assign({},i),{textLineResultItems:e.textLineResultItems.filter((e=>!e.isFilter))})),t.onDetectedQuadsReceived&&e.detectedQuadResultItems&&t.onDetectedQuadsReceived(Object.assign(Object.assign({},i),{detectedQuadResultItems:e.detectedQuadResultItems.filter((e=>!e.isFilter))})),t.onNormalizedImagesReceived&&e.normalizedImageResultItems&&t.onNormalizedImagesReceived(Object.assign(Object.assign({},i),{normalizedImageResultItems:e.normalizedImageResultItems.filter((e=>!e.isFilter))})),t.onParsedResultsReceived&&e.parsedResultItems&&t.onParsedResultsReceived(Object.assign(Object.assign({},i),{parsedResultItems:e.parsedResultItems.filter((e=>!e.isFilter))})),t.onCapturedResultReceived&&!t.isDce&&(e.items=e.items.filter((e=>!e.isFilter)),e.barcodeResultItems&&(e.barcodeResultItems=e.barcodeResultItems.filter((e=>!e.isFilter))),e.textLineResultItems&&(e.textLineResultItems=e.textLineResultItems.filter((e=>!e.isFilter))),e.detectedQuadResultItems&&(e.detectedQuadResultItems=e.detectedQuadResultItems.filter((e=>!e.isFilter))),e.normalizedImageResultItems&&(e.normalizedImageResultItems=e.normalizedImageResultItems.filter((e=>!e.isFilter))),e.parsedResultItems&&(e.parsedResultItems=e.parsedResultItems.filter((e=>!e.isFilter))),t.onCapturedResultReceived(e));const a=Date.now();if(this._minImageCaptureInterval>-1&&(5===this._averageProcessintTimeArray.length&&this._averageProcessintTimeArray.shift(),5===this._averageFetchImageTimeArray.length&&this._averageFetchImageTimeArray.shift(),this._averageProcessintTimeArray.push(Date.now()-s),this._averageFetchImageTimeArray.push(this._dsImage&&this._dsImage.tag?this._dsImage.tag.timeSpent:0),this._averageTime=Math.min(...this._averageProcessintTimeArray)-Math.max(...this._averageFetchImageTimeArray),this._averageTime=this._averageTime>0?this._averageTime:0,g._onLog&&(g._onLog(`minImageCaptureInterval: ${this._minImageCaptureInterval}`),g._onLog(`averageProcessintTimeArray: ${this._averageProcessintTimeArray}`),g._onLog(`averageFetchImageTimeArray: ${this._averageFetchImageTimeArray}`),g._onLog(`averageTime: ${this._averageTime}`))),g._onLog){const e=Date.now()-a;e>10&&g._onLog(`fetch image calculate time: ${e}`)}g._onLog&&g._onLog(`time finish decode: ${Date.now()}`),g._onLog&&g._onLog("main time: "+(Date.now()-s)),g._onLog&&g._onLog("===================================================="),this._loopReadVideoTimeoutId&&clearTimeout(this._loopReadVideoTimeoutId),this._minImageCaptureInterval>0&&this._minImageCaptureInterval>=this._averageTime?this._loopReadVideoTimeoutId=setTimeout((()=>{this._loopReadVideo(t)}),this._minImageCaptureInterval-this._averageTime):this._loopReadVideoTimeoutId=setTimeout((()=>{this._loopReadVideo(t)}),Math.max(this._minImageCaptureInterval,0))})).catch((e=>{this._isa.stopFetching(),this._loopReadVideoTimeoutId&&clearTimeout(this._loopReadVideoTimeoutId),this._loopReadVideoTimeoutId=setTimeout((()=>{this._isa.startFetching(),this._loopReadVideo(t)}),Math.max(this._minImageCaptureInterval,1e3)),"platform error"!==e.message&&setTimeout((()=>{throw e}),0)}))}_reRunCurrnetFunc(e){this._loopReadVideoTimeoutId&&clearTimeout(this._loopReadVideoTimeoutId),this._loopReadVideoTimeoutId=setTimeout((()=>{this._loopReadVideo(e)}),0)}async capture(e,s="Default"){this._checkIsDisposed();const i=await this.containsTask(s);let a;if(await t.loadWasm(i),this._dynamsoft=!1,t._isDSImageData(e))a=await this._captureDsimage(e,s);else if("string"==typeof e)a="data:image/"==e.substring(0,11)?await this._captureBase64(e,s):await this._captureUrl(e,s);else if(e instanceof Blob)a=await this._captureBlob(e,s);else if(e instanceof HTMLImageElement)a=await this._captureImage(e,s);else if(e instanceof HTMLCanvasElement)a=await this._captureCanvas(e,s);else{if(!(e instanceof HTMLVideoElement))throw new TypeError("'capture(imageOrFile, templateName)': Type of 'imageOrFile' should be 'DSImageData', 'Url', 'Base64', 'Blob', 'HTMLImageElement', 'HTMLCanvasElement', 'HTMLVideoElement'.");a=await this._captureVideo(e,s)}return a}async _captureDsimage(e,t){return await this._captureInWorker(e,t)}async _captureUrl(e,s){let i=await t.requestResource(e,"blob");return await this._captureBlob(i,s)}async _captureBase64(e,t){e=e.substring(e.indexOf(",")+1);let s=atob(e),i=s.length,a=new Uint8Array(i);for(;i--;)a[i]=s.charCodeAt(i);return await this._captureBlob(new Blob([a]),t)}async _captureBlob(e,t){let s=null,i=null;if("undefined"!=typeof createImageBitmap)try{s=await createImageBitmap(e)}catch(e){}s||(i=await async function(e){return await new Promise(((t,s)=>{let i=URL.createObjectURL(e),a=new Image;a.src=i,a.onload=()=>{URL.revokeObjectURL(a.dbrObjUrl),t(a)},a.onerror=e=>{s(new Error("Can't convert blob to image : "+(e instanceof Event?e.type:e)))}}))}(e));let a=await this._captureImage(s||i,t);return s&&s.close(),a}async _captureImage(e,t){let s,i,a=e instanceof HTMLImageElement?e.naturalWidth:e.width,r=e instanceof HTMLImageElement?e.naturalHeight:e.height,n=Math.max(a,r);n>this.maxCvsSideLength?(this._compressRate=this.maxCvsSideLength/n,s=Math.round(a*this._compressRate),i=Math.round(r*this._compressRate)):(s=a,i=r),this._canvas||(this._canvas=document.createElement("canvas"));const o=this._canvas;o.width===s&&o.height===i||(o.width=s,o.height=i),o.ctx2d||(o.ctx2d=o.getContext("2d",{willReadFrequently:!0}));return o.ctx2d.drawImage(e,0,0,a,r,0,0,s,i),e.dbrObjUrl&&URL.revokeObjectURL(e.dbrObjUrl),await this._captureCanvas(o,t)}async _captureCanvas(e,t){if(e.crossOrigin&&"anonymous"!=e.crossOrigin)throw"cors";if([e.width,e.height].includes(0))throw Error("The width or height of the 'canvas' is 0.");const s=e.ctx2d||e.getContext("2d",{willReadFrequently:!0}),i={bytes:Uint8Array.from(s.getImageData(0,0,e.width,e.height).data),width:e.width,height:e.height,stride:4*e.width,format:10};return await this._captureInWorker(i,t)}async _captureVideo(e,t){if(e.crossOrigin&&"anonymous"!=e.crossOrigin)throw"cors";let s,i,a=e.videoWidth,r=e.videoHeight,n=Math.max(a,r);n>this.maxCvsSideLength?(this._compressRate=this.maxCvsSideLength/n,s=Math.round(a*this._compressRate),i=Math.round(r*this._compressRate)):(s=a,i=r),this._canvas||(this._canvas=document.createElement("canvas"));const o=this._canvas;o.width===s&&o.height===i||(o.width=s,o.height=i),o.ctx2d||(o.ctx2d=o.getContext("2d",{willReadFrequently:!0}));return o.ctx2d.drawImage(e,0,0,a,r,0,0,s,i),await this._captureCanvas(o,t)}async _captureInWorker(e,s){const{bytes:a,width:r,height:n,stride:o,format:c}=e;let l=t.getNextTaskID();const d=new i;return t.mapTaskCallBack[l]=async s=>{var i,a;if(!s.success){let e=new Error(s.message);return e.stack=s.stack+"\n"+e.stack,d.reject(e)}{const r=Date.now();g._onLog&&(g._onLog(`get result time from worker: ${r}`),g._onLog("worker to main time consume: "+(r-s.workerReturnMsgTime)));try{const r=s.captureResult;e.bytes=s.bytes;for(let s of r.items)0!==this._compressRate&&R(s,this._compressRate),s.type===t.EnumCapturedResultItemType.CRIT_ORIGINAL_IMAGE?s.imageData=e:s.type===t.EnumCapturedResultItemType.CRIT_NORMALIZED_IMAGE?null===(i=t.mapPackageRegister.ddn)||void 0===i||i.handleNormalizedImageResultItem(s):s.type===t.EnumCapturedResultItemType.CRIT_PARSED_RESULT&&(null===(a=t.mapPackageRegister.dcp)||void 0===a||a.handleParsedResultItem(s));if(this._dynamsoft)for(let e of this._resultFilterSet)e.onDecodedBarcodesReceived(r.items),e.onRecognizedTextLinesReceived(r.items),e.onDetectedQuadsReceived(r.items),e.onNormalizedImagesReceived(r.items);const n=function(e){const s={barcodeResultItems:[],textLineResultItems:[],detectedQuadResultItems:[],normalizedImageResultItems:[],parsedResultItems:[]};return e.items.forEach((e=>{e.type===t.EnumCapturedResultItemType.CRIT_BARCODE?s.barcodeResultItems.push(e):e.type===t.EnumCapturedResultItemType.CRIT_TEXT_LINE?s.textLineResultItems.push(e):e.type===t.EnumCapturedResultItemType.CRIT_DETECTED_QUAD?s.detectedQuadResultItems.push(e):e.type===t.EnumCapturedResultItemType.CRIT_NORMALIZED_IMAGE?s.normalizedImageResultItems.push(e):e.type===t.EnumCapturedResultItemType.CRIT_PARSED_RESULT&&s.parsedResultItems.push(e)})),s}(r);n.barcodeResultItems.length&&(r.barcodeResultItems=n.barcodeResultItems),n.textLineResultItems.length&&(r.textLineResultItems=n.textLineResultItems),n.detectedQuadResultItems.length&&(r.detectedQuadResultItems=n.detectedQuadResultItems),n.normalizedImageResultItems.length&&(r.normalizedImageResultItems=n.normalizedImageResultItems),n.parsedResultItems.length&&(r.parsedResultItems=n.parsedResultItems);const o=r.intermediateResult;if(o){let t=0;for(let s of this._intermediateResultReceiverSet){t++;for(let i of o){if("onTaskResultsReceived"===i.info.callbackName){for(let t of i.intermediateResultUnits)t.originalImageTag=e.tag?e.tag:null;s[i.info.callbackName]&&s[i.info.callbackName]({intermediateResultUnits:i.intermediateResultUnits},i.info)}else s[i.info.callbackName]&&s[i.info.callbackName](i.result,i.info);t===this._intermediateResultReceiverSet.size&&delete i.info.callbackName}}}return r&&r.intermediateResult&&delete r.intermediateResult,this._compressRate=0,d.resolve(r)}catch(e){return d.reject(e)}}},g._onLog&&g._onLog(`send buffer to worker: ${Date.now()}`),t.worker.postMessage({type:"cvr_capture",id:l,instanceID:this._instanceID,body:{bytes:a,width:r,height:n,stride:o,format:c,templateName:s||"",dynamsoft:this._dynamsoft}},[a.buffer]),d}async initSettings(e){return this._checkIsDisposed(),e&&["string","object"].includes(typeof e)?("string"==typeof e?e.startsWith("{")?this._currentSettings=JSON.parse(e):e=await t.requestResource(e,"text"):"object"==typeof e&&(this._currentSettings=e,e=JSON.stringify(e)),await new Promise(((s,i)=>{let a=t.getNextTaskID();t.mapTaskCallBack[a]=async a=>{if(a.success){const r=JSON.parse(a.response);if(0!==r.exception){let e=new Error(r.description?r.description:"Init Settings Failed.");return e.errorCode=r.exception,i(e)}let n=[],o=JSON.parse(e).CaptureVisionTemplates;for(let e=0;e<o.length;e++){let t=await this.containsTask(o[e].Name);n=n.concat(t)}return await t.loadWasm([...new Set(n)]),this._bNeedOutputOriginalImage=1===this._currentSettings.CaptureVisionTemplates[0].OutputOriginalImage,s(r)}{let e=new Error(a.message);return e.stack=a.stack+"\n"+e.stack,i(e)}},t.worker.postMessage({type:"cvr_initSettings",id:a,instanceID:this._instanceID,body:{settings:e}})}))):console.error("Invalid template.")}async outputSettings(e){return this._checkIsDisposed(),await new Promise(((s,i)=>{let a=t.getNextTaskID();t.mapTaskCallBack[a]=async e=>{if(e.success){const t=JSON.parse(e.settings);if(0!==t.errorCode){let e=new Error(t.errorString);return e.errorCode=t.errorCode,i(e)}return delete t.errorCode,delete t.errorString,s(t)}{let t=new Error(e.message);return t.stack=e.stack+"\n"+t.stack,i(t)}},t.worker.postMessage({type:"cvr_outputSettings",id:a,instanceID:this._instanceID,body:{templateName:e||"Default"}})}))}async outputSettingsToFile(e,t,s){const i=await this.outputSettings(e),a=new Blob([JSON.stringify(i,null,2,(function(e,t){return t instanceof Array?JSON.stringify(t):t}),2)],{type:"application/json"});if(s){const e=document.createElement("a");e.href=URL.createObjectURL(a),t.endsWith(".json")&&(t=t.replace(".json","")),e.download=`${t}.json`,e.onclick=()=>{setTimeout((()=>{URL.revokeObjectURL(e.href)}),500)},e.click()}return a}async getSimplifiedSettings(e="Default"){this._checkIsDisposed();const s=await this.containsTask(e);return await t.loadWasm(s),await new Promise(((s,i)=>{let a=t.getNextTaskID();t.mapTaskCallBack[a]=async e=>{if(e.success){const a=JSON.parse(e.settings,((e,s)=>t.bSupportBigInt&&"barcodeFormatIds"===e?BigInt(s):s));if(a.minImageCaptureInterval=this._minImageCaptureInterval,0!==a.code){let e=new Error(a.codeString);return e.errorCode=a.errorCode,i(e)}return delete a.code,delete a.codeString,s(a)}{let t=new Error(e.message);return t.stack=e.stack+"\n"+t.stack,i(t)}},t.worker.postMessage({type:"cvr_getSimplifiedSettings",id:a,instanceID:this._instanceID,body:{templateName:e}})}))}async updateSettings(e,s){this._checkIsDisposed();const i=await this.containsTask(e);return await t.loadWasm(i),await new Promise(((i,a)=>{let r=t.getNextTaskID();t.mapTaskCallBack[r]=async e=>{if(e.success){const t=JSON.parse(e.response);if(s.minImageCaptureInterval&&s.minImageCaptureInterval>=-1&&(this._minImageCaptureInterval=s.minImageCaptureInterval),this._bNeedOutputOriginalImage=e.bNeedOutputOriginalImage,0!==t.exception){let e=new Error(t.description?t.description:"Update Settings Failed.");return e.errorCode=t.exception,a(e)}return this._currentSettings=await this.outputSettings("*"),i(t)}{let t=new Error(e.message);return t.stack=e.stack+"\n"+t.stack,a(t)}},t.worker.postMessage({type:"cvr_updateSettings",id:r,instanceID:this._instanceID,body:{settings:s,templateName:e}})}))}async resetSettings(){return this._checkIsDisposed(),await new Promise(((e,s)=>{let i=t.getNextTaskID();t.mapTaskCallBack[i]=async t=>{if(t.success){const i=JSON.parse(t.response);if(0!==i.exception){let e=new Error(i.description?i.description:"Reset Settings Failed.");return e.errorCode=i.exception,s(e)}return this._currentSettings=await this.outputSettings("*"),e(i)}{let e=new Error(t.message);return e.stack=t.stack+"\n"+e.stack,s(e)}},t.worker.postMessage({type:"cvr_resetSettings",id:i,instanceID:this._instanceID})}))}getIntermediateResultManager(e){if(this._checkIsDisposed(),!e&&0!==t.CoreModule.bSupportIRTModule)throw new Error("The current license does not support the use of intermediate results.");return this._intermediateResultManager||(this._intermediateResultManager=new a,this._intermediateResultManager.addResultReceiver=async e=>{if("object"!=typeof e)throw new Error("Invalid receiver.");this._intermediateResultReceiverSet.add(e),this._handleIntermediateResultReceiver();let s=-1,i={};if(!e.isDce){if(!e._observedResultUnitTypes||!e._observedTaskMap)throw new Error("Invalid Intermediate Result Receiver.");s=e._observedResultUnitTypes,e._observedTaskMap.forEach(((e,t)=>{i[t]=e})),e._observedTaskMap.clear()}return await(async()=>await new Promise(((e,a)=>{let r=t.getNextTaskID();t.mapTaskCallBack[r]=async t=>{if(t.success)return e();{let e=new Error(t.message);return e.stack=t.stack+"\n"+e.stack,a(e)}},t.worker.postMessage({type:"cvr_setIrrRegistry",id:r,instanceID:this._instanceID,body:{receiverObj:this._irrRegistryState,observedResultUnitTypes:String(s),observedTaskMap:i}})})))()},this._intermediateResultManager.removeResultReceiver=async e=>(this._intermediateResultReceiverSet.delete(e),this._handleIntermediateResultReceiver(),await new Promise(((e,s)=>{let i=t.getNextTaskID();t.mapTaskCallBack[i]=async t=>{if(t.success)return e();{let e=new Error(t.message);return e.stack=t.stack+"\n"+e.stack,s(e)}},t.worker.postMessage({type:"cvr_setIrrRegistry",id:i,instanceID:this._instanceID,body:{receiverObj:this._irrRegistryState}})}))),this._intermediateResultManager.getOriginalImage=()=>this._dsImage),this._intermediateResultManager}_handleIntermediateResultReceiver(){for(let e in this._irrRegistryState)this._irrRegistryState[e]=!1;for(let e of this._intermediateResultReceiverSet)if(e.isDce)this._irrRegistryState.onTaskResultsReceivedForDce=!0;else for(let t in e)this._irrRegistryState[t]||(this._irrRegistryState[t]=!!e[t])}contains(e,t){return function(e,t){let s=t.x,i=t.y,a=e[0].x,r=e[0].y,n=e[1].x,o=e[1].y,c=e[2].x,l=e[2].y,d=e[3].x,u=e[3].y,m=g(s,i,a,r,n,o),_=g(s,i,n,o,c,l),h=g(s,i,c,l,d,u),R=g(s,i,d,u,a,r);function g(e,t,s,i,a,r){return(e-s)*(r-i)-(t-i)*(a-s)}return m>=0&&_>=0&&h>=0&&R>=0||m<=0&&_<=0&&h<=0&&R<=0}(e,t)}async parseRequiredResources(e){return this._checkIsDisposed(),await new Promise(((s,i)=>{let a=t.getNextTaskID();t.mapTaskCallBack[a]=async e=>{if(e.success)return s(JSON.parse(e.resources));{let t=new Error(e.message);return t.stack=e.stack+"\n"+t.stack,i(t)}},t.worker.postMessage({type:"cvr_parseRequiredResources",id:a,instanceID:this._instanceID,body:{templateName:e}})}))}async dispose(){this._checkIsDisposed(),this._promiseStartScan&&this.stopCapturing(),this._isa=null,this._resultReceiverSet.clear(),this._isaStateListenerSet.clear(),this._resultFilterSet.clear(),this.bDestroyed=!0;let e=t.getNextTaskID();t.mapTaskCallBack[e]=e=>{if(!e.success){let t=new Error(e.message);throw t.stack=e.stack+"\n"+t.stack,t}},t.worker.postMessage({type:"cvr_dispose",id:e,instanceID:this._instanceID})}async _enableResultCrossVerification(e){return this._checkIsDisposed(),await new Promise(((s,i)=>{let a=t.getNextTaskID();t.mapTaskCallBack[a]=async e=>{if(e.success)return s(e.result);{let t=new Error(e.message);return t.stack=e.stack+"\n"+t.stack,i(t)}},t.worker.postMessage({type:"cvr_enableResultCrossVerification",id:a,instanceID:this._instanceID,body:{verificationEnabled:e}})}))}async _enableResultDeduplication(e){return this._checkIsDisposed(),await new Promise(((s,i)=>{let a=t.getNextTaskID();t.mapTaskCallBack[a]=async e=>{if(e.success)return s(e.result);{let t=new Error(e.message);return t.stack=e.stack+"\n"+t.stack,i(t)}},t.worker.postMessage({type:"cvr_enableResultDeduplication",id:a,instanceID:this._instanceID,body:{duplicateFilterEnabled:e}})}))}async _setDuplicateForgetTime(e){return this._checkIsDisposed(),await new Promise(((s,i)=>{let a=t.getNextTaskID();t.mapTaskCallBack[a]=async e=>{if(e.success)return s(e.result);{let t=new Error(e.message);return t.stack=e.stack+"\n"+t.stack,i(t)}},t.worker.postMessage({type:"cvr_setDuplicateForgetTime",id:a,instanceID:this._instanceID,body:{duplicateForgetTime:e}})}))}async _getDuplicateForgetTime(e){return this._checkIsDisposed(),await new Promise(((s,i)=>{let a=t.getNextTaskID();t.mapTaskCallBack[a]=async e=>{if(e.success)return s(e.time);{let t=new Error(e.message);return t.stack=e.stack+"\n"+t.stack,i(t)}},t.worker.postMessage({type:"cvr_getDuplicateForgetTime",id:a,instanceID:this._instanceID,body:{type:e}})}))}async _setThresholdValue(e,s,i){return await t.loadWasm("ddn"),await new Promise(((a,r)=>{let n=t.getNextTaskID();t.mapTaskCallBack[n]=async e=>{if(e.success)return a();{let t=new Error(e.message);return t.stack=e.stack+"\n"+t.stack,r(t)}},t.worker.postMessage({type:"ddn_setThresholdValue",id:n,instanceID:this._instanceID,body:{threshold:e,leftLimit:s,rightLimit:i}})}))}_checkIsDisposed(){if(this.disposed)throw new Error('"CaptureVisionRouter" instance has been disposed')}}e.CaptureVisionRouter=g,e.CaptureVisionRouterModule=m,e.CapturedResultReceiver=class{constructor(){this.onCapturedResultReceived=null,this.onOriginalImageResultReceived=null}},e.IntermediateResultManager=a,e.IntermediateResultReceiver=class{constructor(){this._observedResultUnitTypes=t.EnumIntermediateResultUnitType.IRUT_ALL,this._observedTaskMap=new Map,this._parameters={setObservedResultUnitTypes:e=>{this._observedResultUnitTypes=e},getObservedResultUnitTypes:()=>this._observedResultUnitTypes,isResultUnitTypeObserved:e=>!!(e&this._observedResultUnitTypes),addObservedTask:e=>{this._observedTaskMap.set(e,!0)},removeObservedTask:e=>{this._observedTaskMap.set(e,!1)},isTaskObserved:e=>0===this._observedTaskMap.size||!!this._observedTaskMap.get(e)},this.onTaskResultsReceived=null,this.onPredetectedRegionsReceived=null,this.onColourImageUnitReceived=null,this.onScaledDownColourImageUnitReceived=null,this.onGrayscaleImageUnitReceived=null,this.onTransformedGrayscaleImageUnitReceived=null,this.onEnhancedGrayscaleImageUnitReceived=null,this.onBinaryImageUnitReceived=null,this.onTextureDetectionResultUnitReceived=null,this.onTextureRemovedGrayscaleImageUnitReceived=null,this.onTextureRemovedBinaryImageUnitReceived=null,this.onContoursUnitReceived=null,this.onLineSegmentsUnitReceived=null,this.onTextZonesUnitReceived=null,this.onTextRemovedBinaryImageUnitReceived=null,this.onShortLinesUnitReceived=null}getObservationParameters(){return this._parameters}}}));
