/*Dashboard Init*/
"use strict"; 
/*DataTable Init*/
if ($("#datable_1").length > 0) {
	/*Checkbox Add*/
	var tdCnt=0;
	$('table tr').each(function(){
		$('<span class="form-check mb-0"><input type="checkbox" class="form-check-input check-select" id="chk_sel_'+tdCnt+'"><label class="form-check-label" for="chk_sel_'+tdCnt+'"></label></span>').appendTo($(this).find("td:first-child"));
		tdCnt++;
	});
	var targetDt = $('#datable_1').DataTable({
		"dom": '<"row"<"col-7 mb-3"<"contact-toolbar-left">><"col-5 mb-3"<"contact-toolbar-right"f>>><"row"<"col-sm-12"t>><"row"<"col-sm-12 col-md-5"i><"col-sm-12 col-md-7"p>>',
		"ordering": true,
		"columnDefs": [ {
			"searchable": false,
			"orderable": false,
			"targets": [0,5]
		} ],
		"order": [1, 'asc' ],
		language: { search: "",
			searchPlaceholder: "Search",
			"info": "_START_ - _END_ of _TOTAL_",
			sLengthMenu: "View  _MENU_",
			paginate: {
			  next: '<i class="ri-arrow-right-s-line"></i>', // or '→'
			  previous: '<i class="ri-arrow-left-s-line"></i>' // or '←' 
			}
		},
		"drawCallback": function () {
			$('.dataTables_paginate > .pagination').addClass('custom-pagination pagination-simple pagination-sm');
		}
	});
	$(document).on( 'click', '.del-button', function () {
		targetDt.row('.selected').remove().draw( false );
		return false;
	});
	$("div.contact-toolbar-left").html('<div class="d-xxl-flex d-none align-items-center"><div class="btn-group btn-group-sm" role="group" aria-label="Basic outlined example"><button type="button" class="btn btn-outline-light active">View all</button><button type="button" class="btn btn-outline-light">Monitored</button><button type="button" class="btn btn-outline-light">Unmonitored</button></div>');
	$("div.contact-toolbar-right").addClass('d-flex justify-content-end').append('	<button class="btn btn-sm btn-outline-light ms-3"><span><span class="icon"><i class="bi bi-filter"></i></span><span class="btn-text">Filters</span></span></button>');
	$("#datable_1").parent().addClass('table-responsive');
	
	/*Select all using checkbox*/
	var  DT1 = $('#datable_1').DataTable();
	$(".check-select-all").on( "click", function(e) {
		$('.check-select').attr('checked', true);
		if ($(this).is( ":checked" )) {
			DT1.rows().select();    
			$('.check-select').prop('checked', true);			
		} else {
			DT1.rows().deselect(); 
			$('.check-select').prop('checked', false);
		}
	});
	$(".check-select").on( "click", function(e) {
		if ($(this).is( ":checked" )) {
			$(this).closest('tr').addClass('selected');        
		} else {
			$(this).closest('tr').removeClass('selected');
			$('.check-select-all').prop('checked', false);
		}
	});
}

/*Apex Column Chart*/
window.Apex = {
	chart: {
		foreColor: "#646A71",
		fontFamily: 'DM Sans',
		toolbar: {
			tools: {
				download: '<svg viewBox="0 0 24 24" width="24" height="24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1"><circle cx="12" cy="12" r="1"></circle><circle cx="12" cy="5" r="1"></circle><circle cx="12" cy="19" r="1"></circle></svg>',
				selection: '<img src="/static/icons/reset.png" width="20">',
				zoom: '<svg viewBox="0 0 24 24" width="24" height="24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1"><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line><line x1="11" y1="8" x2="11" y2="14"></line><line x1="8" y1="11" x2="14" y2="11"></line></svg>',
				zoomin: '<svg viewBox="0 0 24 24" width="24" height="24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="8" x2="12" y2="16"></line><line x1="8" y1="12" x2="16" y2="12"></line></svg>',
				zoomout: '<svg viewBox="0 0 24 24" width="24" height="24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1"><circle cx="12" cy="12" r="10"></circle><line x1="8" y1="12" x2="16" y2="12"></line></svg>',
				pan: '<svg viewBox="0 0 24 24" width="24" height="24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1"><polyline points="5 9 2 12 5 15"></polyline><polyline points="9 5 12 2 15 5"></polyline><polyline points="15 19 12 22 9 19"></polyline><polyline points="19 9 22 12 19 15"></polyline><line x1="2" y1="12" x2="22" y2="12"></line><line x1="12" y1="2" x2="12" y2="22"></line></svg>',
				reset: '<svg viewBox="0 0 24 24" width="24" height="24" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="css-i6dzq1"><path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path><polyline points="9 22 9 12 15 12 15 22"></polyline></svg>',
			}
		}
	},
	grid: {
		borderColor: '#F4F5F6',
	},
	xaxis: {
		labels: {
			style: {
				fontSize: '12px',
				fontFamily: 'inherit',
			},
		},
		axisBorder: {
			show: false,
		},
		title: {
			style: {
				fontSize: '12px',
				fontFamily: 'inherit',
			}
		}
	},
	yaxis: {
		labels: {
			style: {
				fontSize: '12px',
				fontFamily: 'inherit',
			},
		},
		title: {
			style: {
				fontSize: '12px',
				fontFamily: 'inherit',
			}
		},
	},
};

/*Multiple Chart*/
// var options2 = {
// 	series: [80, 75],
// 	stroke: {
// 		lineCap: 'round'
// 	},
// 	chart: {
// 		height: 255,
// 		type: 'radialBar',
// 	},
// 	plotOptions: {
// 		radialBar: {
// 			hollow: {
// 				margin: 0,
// 				size: "55%",
// 			},
// 			dataLabels: {
// 				showOn: "always",
// 				name: {
// 					show: false,
// 				},
// 				value: {
// 					fontSize: "1.75rem",
// 					show: true,
// 					fontWeight: '500'
// 				}	,
// 				total: {
// 					show: true,
// 					formatter: function () {
// 						return [('$2249')];
// 					}
// 				}
// 			  }
// 		}
// 	},
// 	colors: ['#007D88', '#25cba1'],
// 	labels: ['Subscriptions', 'Food'],
// };

// var chart2 = new ApexCharts(document.querySelector("#radial_chart_2"), options2);
// chart2.render();

/*Animated Map*/	
am5.ready(function () {
    var amcharts_map_states = [
        {
            id: "HCM",
            title: "Hồ Chí Minh",
            geometry: { type: "Point", coordinates: [current_location.longitude, current_location.latitude] },
        }
    ];
    var amcharts_map_destinations = [];
    amcharts_map_data.forEach(function (state) {
        amcharts_map_destinations.push(state.state_code);
        amcharts_map_states.push({
            id: state.state_code,
            title: state.state_name,
            geometry: { type: "Point", coordinates: [state.state_longitude, state.state_latitude] },
        });
    });

    // Create root element
    var root = am5.Root.new("anim_map_2");

    // Set themes
    root.setThemes([
        am5themes_Animated.new(root)
    ]);

    // Create the map chart
    var chart = root.container.children.push(am5map.MapChart.new(root, {
        panX: "translateX",
        panY: "translateY",
        projection: am5map.geoMercator()
    }));

    var cont = chart.children.push(am5.Container.new(root, {
        layout: root.horizontalLayout,
        x: 20,
        y: 40
    }));

    // Add labels and controls
    cont.children.push(am5.Label.new(root, {
        centerY: am5.p50,
        text: "Map"
    }));

    var switchButton = cont.children.push(am5.Button.new(root, {
        themeTags: ["switch"],
        centerY: am5.p50,
        icon: am5.Circle.new(root, {
            themeTags: ["icon"]
        })
    }));

    switchButton.on("active", function () {
        if (!switchButton.get("active")) {
            chart.set("projection", am5map.geoMercator());
            chart.set("panX", "translateX");
            chart.set("panY", "translateY");
        } else {
            chart.set("projection", am5map.geoOrthographic());
            chart.set("panX", "rotateX");
            chart.set("panY", "rotateY");
        }
    });

    cont.children.push(am5.Label.new(root, {
        centerY: am5.p50,
        text: "Globe"
    }));

    // Create main polygon series for countries
    var polygonSeries = chart.series.push(am5map.MapPolygonSeries.new(root, {
        geoJSON: am5geodata_worldLow
    }));

    // Add tooltip to polygon series
    polygonSeries.mapPolygons.template.set("tooltipText", "{name}");

    var graticuleSeries = chart.series.push(am5map.GraticuleSeries.new(root, {}));
    graticuleSeries.mapLines.template.setAll({
        stroke: root.interfaceColors.get("alternativeBackground"),
        strokeOpacity: 0.08
    });

    // Create line series for trajectory lines
    var lineSeries = chart.series.push(am5map.MapLineSeries.new(root, {}));
    lineSeries.mapLines.template.setAll({
        stroke: root.interfaceColors.get("alternativeBackground"),
        strokeOpacity: 0.6
    });

    // Destination series
    var citySeries = chart.series.push(
        am5map.MapPointSeries.new(root, {})
    );

    citySeries.bullets.push(function () {
        var circle = am5.Circle.new(root, {
            radius: 5,
            tooltipText: "{title}",
            tooltipY: 0,
            fill: am5.color(0xffba00),
            stroke: root.interfaceColors.get("background"),
            strokeWidth: 2
        });

        return am5.Bullet.new(root, {
            sprite: circle
        });
    });

    // Arrow series
    var arrowSeries = chart.series.push(
        am5map.MapPointSeries.new(root, {})
    );

    arrowSeries.bullets.push(function () {
        var arrow = am5.Graphics.new(root, {
            fill: am5.color(0x000000),
            stroke: am5.color(0x000000),
            draw: function (display) {
                display.moveTo(0, -3);
                display.lineTo(8, 0);
                display.lineTo(0, 3);
                display.lineTo(0, -3);
            }
        });

        return am5.Bullet.new(root, {
            sprite: arrow
        });
    });

    citySeries.data.setAll(amcharts_map_states);

    // Ho Chi Minh coordinates
    var originLongitude = current_location.longitude;
    var originLatitude = current_location.latitude;

    am5.array.each(amcharts_map_destinations, function (did) {
        var destinationDataItem = citySeries.getDataItemById(did);
        var lineDataItem = lineSeries.pushDataItem({
            geometry: {
                type: "LineString",
                coordinates: [
                    [originLongitude, originLatitude],
                    [destinationDataItem.get("longitude"), destinationDataItem.get("latitude")]
                ]
            }
        });

        arrowSeries.pushDataItem({
            lineDataItem: lineDataItem,
            positionOnLine: 0.5,
            autoRotate: true
        });
    });

    polygonSeries.events.on("datavalidated", function () {
        chart.zoomToGeoPoint({ longitude: current_location.longitude, latitude: current_location.latitude }, 3);
    });

    // Make stuff animate on load
    chart.appear(1000, 100);

}); // end am5.ready()