<?php

namespace Database\Seeders;

// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use App\Models\User;
use App\Models\Branch;
use App\Models\Country;
use App\Models\Position;
use Illuminate\Support\Str;
use App\Models\MenuByPosition;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {

        foreach(config('constans.branchs') as $branch){
            Branch::create($branch);
        }
        
        foreach(config('constans.positions') as $position){
            $position_created = Position::create($position);
            foreach(collect(config('constans.menus'))->pluck('menus')->flatten(1)->toArray() as $menu){
                MenuByPosition::create([
                    'position_id' => $position_created['position_id'],
                    'menu_key' => $menu['primary']
                ]);
            }
        }

        User::create([
            'user_name' => 'admin@kango.com',
            'user_code' => 'KG20001',
            'user_api_key' => Str::random(50),
            'password' => 'Kango123',
            'position_id' => 1,
            'branch_id' => 1,
            'user_contact_name' => 'ADMIN KANGO',
            'user_phone' => '19009475',
            'user_address' => 'Hồ Chí Minh',
            'active_flg' => ACTIVE
        ]);
    }
}
