<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('service_surcharge_fees', function (Blueprint $table) {
            $table->id('service_surcharge_fee_id');
            $table->unsignedBigInteger('service_id')->comment('Dịch vụ sử dụng');
            $table->tinyInteger('condition_type')->default(0)->comment('Loại điều kiện (1: trên/0: dưới kg)');
            $table->decimal('condition_value', 8, 2)->comment('Giá trị kg để so sánh');
            $table->string('surcharge_name')->comment('Tên phụ thu');
            $table->decimal('amount', 12, 2)->comment('Số tiền phụ thu');

            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();

            $table->foreign('service_id')->references('service_id')->on('services')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('service_surcharge_fees');
    }
};
