<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('account_activity_logs', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id'); // ID tài khoản
            $table->string('action')->comment('Hành động'); // Hành động
            $table->text('details')->nullable()->comment('Chi tiết hành động'); // Chi tiết hành động
            $table->text('path')->nullable()->comment('Đường dẫn đến file lưu trữ dữ liệu thay đổi'); 
            $table->ipAddress('ip_address')->nullable()->comment('Địa sách IP'); // Địa chỉ IP
            $table->timestamp('performed_at')->nullable()->comment('Thời điểm thực hiện'); // Thời điểm thực hiện
            $table->timestamps(); // created_at và updated_at

            // Khóa ngoại
            $table->foreign('user_id')->references('user_id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('account_activity_logs');
    }
};
