<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('checked_payment_cashs', function (Blueprint $table) {
            $table->id();
            $table->string('code');
            $table->unsignedBigInteger('account_id');
            $table->unsignedBigInteger('customer_id');
            $table->unsignedBigInteger('checked_by');
            $table->tinyInteger('kind'); // 0: shipment, 1:debit, 2: stament
            $table->tinyInteger('checked')->default(0); 
            $table->float('amount', 15, 2)->default(0);
            $table->date('payment_at')->nullable();
            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();

            $table->foreign('account_id')->references('user_id')->on('users')->onDelete('cascade');
            $table->foreign('customer_id')->references('user_id')->on('users')->onDelete('cascade');
            $table->foreign('checked_by')->references('user_id')->on('users')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('checked_payment_cashs');
    }
};
