<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('packages', function (Blueprint $table) {
            $table->float('package_length_actual', 50, 5)->nullable()->after('package_length')->comment('Chiều dài thực tế của kiện hàng sau khi được scan import');
            $table->float('package_width_actual', 50, 5)->nullable()->after('package_width')->comment('Chiều rộng thực tế của kiện hàng sau khi được scan import');
            $table->float('package_height_actual', 50, 5)->nullable()->after('package_height')->comment('Chiều cao thực tế của kiện hàng sau khi được scan import');
            $table->float('package_weight_actual', 50, 5)->nullable()->after('package_weight')->comment('Cân nặng thực tế của kiện hàng sau khi được scan import');
            $table->float('package_converted_weight_actual', 50, 5)->nullable()->after('package_converted_weight')->comment('Cân nặng quy đổi thực tế của kiện hàng sau khi được scan import');
            $table->float('package_charged_weight_actual', 50, 5)->nullable()->after('package_charged_weight')->comment('Cân nặng tính phí thực tế của kiện hàng sau khi được scan import');
            $table->float('package_price', 50, 5)->default(0)->after('package_tracking_code')->comment('Giá trị kiện hàng trước khi được scan import');
            $table->float('package_price_actual', 50, 5)->default(0)->after('package_price')->comment('Giá trị kiện hàng thực tế sau khi được scan import');
            $table->tinyInteger('package_approve')->default(PACKAGE_APPROVE_WAITING)->after('package_price_actual')->comment('Duyệt lô hàng(0: Chưa duyệt, 1: Đã duyệt, 2: Đã dư tiền, 3: Đã thiếu tiền)');
            $table->unsignedBigInteger('processing_staff_id')->nullable()->after('package_approve')->comment('Nhân viên xử lý kiện hàng');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('packages', function (Blueprint $table) {
            //
        });
    }
};
