<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('shipments', function (Blueprint $table) {
            $table->float('shipment_amount_service_actual', 50, 5)->default(0)->after('shipment_amount_discount')->comment('Số tiền tính bằng bảng giá dịch vụ sau khi được scan import');
            $table->float('shipment_total_amount_actual', 50, 5)->default(0)->after('shipment_amount_service_actual')->comment('Tổng tiền thực tế của lô hàng sau khi được scan import');
            $table->longText('shipment_note')->nullable()->after('shipment_total_amount_actual')->comment('Ghi chú lô hàng');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('shipments', function (Blueprint $table) {
            //
        });
    }
};
