<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('statement_items', function (Blueprint $table) {
            $table->bigIncrements('statement_item_id');
            $table->unsignedBigInteger('statement_id');
            $table->unsignedBigInteger('debit_id');
            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();

            $table->foreign('statement_id')->references('statement_id')->on('statements')->onDelete('cascade');
            $table->foreign('debit_id')->references('debit_id')->on('debits')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('statement_items');
    }
};
