<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('debits', function (Blueprint $table) {
            $table->unsignedBigInteger('statement_id')->nullable()->after('debit_no');
            $table->tinyInteger('payment_by_statement')->default(0)->after('debit_no');
            
            $table->foreign('statement_id')->references('statement_id')->on('statements')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
