<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('statements', function (Blueprint $table) {
            $table->bigIncrements('statement_id');
            $table->string('statement_code')->unique();
            $table->unsignedBigInteger('customer_id');
            $table->unsignedBigInteger('ceator_id');
            $table->string('statement_start');
            $table->string('statement_end');
            $table->tinyInteger('statement_status')->default(0);
            $table->tinyInteger('statement_payment_method')->default(0);
            $table->mediumText('statement_images')->nullable();
            $table->float('statement_amount', 12, 2)->default(0);
            $table->string('statement_note', 225)->nullable();
            
            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();

            $table->foreign('customer_id')->references('user_id')->on('users')->onDelete('cascade');
            $table->foreign('ceator_id')->references('user_id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('statements');
    }
};
