<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('credit_items', function (Blueprint $table) {
            $table->id('credit_item_id');
            $table->unsignedBigInteger('credit_id');
            $table->unsignedBigInteger('package_id');
            $table->float('value_package', 12, 2); // giá trị của package
            $table->float('goods_compensation', 12, 2); // số tiền bồi thường 
            $table->string('credit_item_note', 225)->nullable();
            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();

            $table->foreign('credit_id')->references('credit_id')->on('credits')->onDelete('cascade');
            $table->foreign('package_id')->references('package_id')->on('packages')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('credit_items');
    }
};
