<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('credits', function (Blueprint $table) {
            $table->id('credit_id');
            $table->string('credit_no', 12)->unique();
            $table->unsignedBigInteger('customer_id');
            $table->unsignedBigInteger('creater_id');
            $table->tinyInteger('credit_status')->default(0);
            $table->mediumText('credit_images')->nullable();
            $table->mediumText('credit_note')->nullable();
            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();

            $table->foreign('customer_id')->references('user_id')->on('users')->onDelete('cascade');
            $table->foreign('creater_id')->references('user_id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('credits');
    }
};
