<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('weight_conversion', function (Blueprint $table) {
            $table->id('weight_conversion_id');
            $table->unsignedBigInteger('service_id');
            $table->float('initial_weight')->default(0);
            $table->float('weight_conversion')->default(0);
            $table->string('weight_unit');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('weight_conversion');
    }
};
