<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('set_amount_origin_shipment', function (Blueprint $table) {
            $table->id();
            $table->string('shipment_code');
            $table->float('set_amount', 12, 2);
            $table->float('old_amount', 12, 2);
            $table->bigInteger('created_by');

            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('set_amount_origin_shipment');
    }
};
