<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('financial_management', function (Blueprint $table) {
            $table->id('financial_id');
            $table->string('financial_code')->unique();
            $table->unsignedBigInteger('financial_branch_id'); // Mã chi nhánh branch_id    
            $table->tinyInteger('financial_type')->default(0); // Loại 0: thu tiền, 1: chi tiền
            $table->float('financial_amount', 12, 2)->default(0); // Sô tiền
            $table->tinyInteger('financial_method')->default(0); // Phương thức thanh toán 0: tiền mặt, 1: chuyển khoản
            $table->unsignedBigInteger('created_by'); // Mã tài khoản user_id người tạo 
            $table->bigInteger('financial_customer_id')->nullable(); // Mã tài khoản user_id    
            $table->string('financial_customer_name', 225); // Tên người nhận
            $table->string('financial_content', 325); // Nội dung
            $table->tinyInteger('financial_is_salary')->default(0); // Thu chi tiền lương 0: sai, 1 đúng
            $table->mediumText('financial_images')->nullable(); // Hình ảnh bằng chứng                                                                                                                                                                                                          

            $table->tinyInteger('active_flg')->default(ACTIVE);
            $table->tinyInteger('delete_flg')->default(NO_DELETE);
            $table->timestamps();

            $table->foreign('created_by')->references('user_id')->on('users')->onDelete('cascade');
            $table->foreign('financial_branch_id')->references('branch_id')->on('branchs')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('financial_management');
    }
};
