<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('discount_user_weight_levels', function (Blueprint $table) {
            $table->id('discount_user_weight_level_id');
            $table->unsignedBigInteger('discount_user_id');
            $table->float('discount_user_weight');
            $table->float('discount_user_amount');
            $table->timestamps();

            $table->foreign('discount_user_id')->references('discount_user_id')->on('discount_users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('discount_user_weight_levels');
    }
};
