<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('debits', function (Blueprint $table) {
            $table->float('debit_payment_amount', 12, 2)->default(0)->after('debit_type'); // Số tiền thanh toán
            $table->string('debit_payment_date')->nullable()->after('debit_type'); // Thời gian thanh toán

            $table->float('debit_advance_amount', 12, 2)->default(0)->after('debit_type'); // tiền tạm ứng
            $table->longText('debit_advance_images')->nullable()->after('debit_type'); // Bằng chứng
            $table->tinyInteger('debit_advance_note')->nullable()->after('debit_type'); // ghi chú tạm ứng
            $table->string('debit_advance_date')->nullable()->after('debit_type'); // Ngày tạo tạm ứng
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
