<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('delete_accounts', function (Blueprint $table) {
            $table->id();
            $table->string('email');
            $table->bigInteger('confirm_by');
            $table->tinyInteger('status')->default(0); // 0: chờ, 1: xác nhận, 2: hủy
            $table->longText('note')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('delete_accounts');
    }
};
